# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AssetTypeArgs', 'AssetType']

@pulumi.input_type
class AssetTypeArgs:
    def __init__(__self__, *,
                 domain_identifier: pulumi.Input[_builtins.str],
                 owning_project_identifier: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forms_inputs: Optional[pulumi.Input[Sequence[pulumi.Input['AssetTypeFormsInputArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['AssetTypeTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a AssetType resource.
        :param pulumi.Input[_builtins.str] domain_identifier: The unique identifier of the Amazon DataZone domain where the custom asset type is being created.
        :param pulumi.Input[_builtins.str] owning_project_identifier: The unique identifier of the Amazon DataZone project that owns the custom asset type.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] description: The description of the custom asset type.
        :param pulumi.Input[Sequence[pulumi.Input['AssetTypeFormsInputArgs']]] forms_inputs: The metadata forms that are to be attached to the custom asset type.
        :param pulumi.Input[_builtins.str] name: The name of the custom asset type.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "domain_identifier", domain_identifier)
        pulumi.set(__self__, "owning_project_identifier", owning_project_identifier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if forms_inputs is not None:
            pulumi.set(__self__, "forms_inputs", forms_inputs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier of the Amazon DataZone domain where the custom asset type is being created.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_identifier", value)

    @_builtins.property
    @pulumi.getter(name="owningProjectIdentifier")
    def owning_project_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier of the Amazon DataZone project that owns the custom asset type.

        The following arguments are optional:
        """
        return pulumi.get(self, "owning_project_identifier")

    @owning_project_identifier.setter
    def owning_project_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "owning_project_identifier", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the custom asset type.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="formsInputs")
    def forms_inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssetTypeFormsInputArgs']]]]:
        """
        The metadata forms that are to be attached to the custom asset type.
        """
        return pulumi.get(self, "forms_inputs")

    @forms_inputs.setter
    def forms_inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssetTypeFormsInputArgs']]]]):
        pulumi.set(self, "forms_inputs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the custom asset type.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AssetTypeTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AssetTypeTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _AssetTypeState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 forms_inputs: Optional[pulumi.Input[Sequence[pulumi.Input['AssetTypeFormsInputArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owning_project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 revision: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['AssetTypeTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering AssetType resources.
        :param pulumi.Input[_builtins.str] created_at: The timestamp when the custom asset type was created.
        :param pulumi.Input[_builtins.str] created_by: The user who created the custom asset type.
        :param pulumi.Input[_builtins.str] description: The description of the custom asset type.
        :param pulumi.Input[_builtins.str] domain_identifier: The unique identifier of the Amazon DataZone domain where the custom asset type is being created.
        :param pulumi.Input[Sequence[pulumi.Input['AssetTypeFormsInputArgs']]] forms_inputs: The metadata forms that are to be attached to the custom asset type.
        :param pulumi.Input[_builtins.str] name: The name of the custom asset type.
        :param pulumi.Input[_builtins.str] owning_project_identifier: The unique identifier of the Amazon DataZone project that owns the custom asset type.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] revision: The revision of the asset type.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_identifier is not None:
            pulumi.set(__self__, "domain_identifier", domain_identifier)
        if forms_inputs is not None:
            pulumi.set(__self__, "forms_inputs", forms_inputs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owning_project_identifier is not None:
            pulumi.set(__self__, "owning_project_identifier", owning_project_identifier)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the custom asset type was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user who created the custom asset type.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the custom asset type.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the Amazon DataZone domain where the custom asset type is being created.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_identifier", value)

    @_builtins.property
    @pulumi.getter(name="formsInputs")
    def forms_inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssetTypeFormsInputArgs']]]]:
        """
        The metadata forms that are to be attached to the custom asset type.
        """
        return pulumi.get(self, "forms_inputs")

    @forms_inputs.setter
    def forms_inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssetTypeFormsInputArgs']]]]):
        pulumi.set(self, "forms_inputs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the custom asset type.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="owningProjectIdentifier")
    def owning_project_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the Amazon DataZone project that owns the custom asset type.

        The following arguments are optional:
        """
        return pulumi.get(self, "owning_project_identifier")

    @owning_project_identifier.setter
    def owning_project_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owning_project_identifier", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The revision of the asset type.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revision", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AssetTypeTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AssetTypeTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:datazone/assetType:AssetType")
class AssetType(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 forms_inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssetTypeFormsInputArgs', 'AssetTypeFormsInputArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owning_project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['AssetTypeTimeoutsArgs', 'AssetTypeTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS DataZone Asset Type.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.datazone.AssetType("test",
            description="example",
            domain_identifier=test_aws_datazone_domain["id"],
            name="example",
            owning_project_identifier=test_aws_datazone_project["id"])
        ```

        ## Import

        Using `pulumi import`, import DataZone Asset Type using the `domain_identifier,name`. For example:

        ```sh
        $ pulumi import aws:datazone/assetType:AssetType example domain-id-12345678,example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the custom asset type.
        :param pulumi.Input[_builtins.str] domain_identifier: The unique identifier of the Amazon DataZone domain where the custom asset type is being created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AssetTypeFormsInputArgs', 'AssetTypeFormsInputArgsDict']]]] forms_inputs: The metadata forms that are to be attached to the custom asset type.
        :param pulumi.Input[_builtins.str] name: The name of the custom asset type.
        :param pulumi.Input[_builtins.str] owning_project_identifier: The unique identifier of the Amazon DataZone project that owns the custom asset type.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssetTypeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS DataZone Asset Type.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.datazone.AssetType("test",
            description="example",
            domain_identifier=test_aws_datazone_domain["id"],
            name="example",
            owning_project_identifier=test_aws_datazone_project["id"])
        ```

        ## Import

        Using `pulumi import`, import DataZone Asset Type using the `domain_identifier,name`. For example:

        ```sh
        $ pulumi import aws:datazone/assetType:AssetType example domain-id-12345678,example
        ```

        :param str resource_name: The name of the resource.
        :param AssetTypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssetTypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 forms_inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssetTypeFormsInputArgs', 'AssetTypeFormsInputArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owning_project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['AssetTypeTimeoutsArgs', 'AssetTypeTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssetTypeArgs.__new__(AssetTypeArgs)

            __props__.__dict__["description"] = description
            if domain_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'domain_identifier'")
            __props__.__dict__["domain_identifier"] = domain_identifier
            __props__.__dict__["forms_inputs"] = forms_inputs
            __props__.__dict__["name"] = name
            if owning_project_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'owning_project_identifier'")
            __props__.__dict__["owning_project_identifier"] = owning_project_identifier
            __props__.__dict__["region"] = region
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["revision"] = None
        super(AssetType, __self__).__init__(
            'aws:datazone/assetType:AssetType',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            domain_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            forms_inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssetTypeFormsInputArgs', 'AssetTypeFormsInputArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owning_project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            revision: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['AssetTypeTimeoutsArgs', 'AssetTypeTimeoutsArgsDict']]] = None) -> 'AssetType':
        """
        Get an existing AssetType resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The timestamp when the custom asset type was created.
        :param pulumi.Input[_builtins.str] created_by: The user who created the custom asset type.
        :param pulumi.Input[_builtins.str] description: The description of the custom asset type.
        :param pulumi.Input[_builtins.str] domain_identifier: The unique identifier of the Amazon DataZone domain where the custom asset type is being created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AssetTypeFormsInputArgs', 'AssetTypeFormsInputArgsDict']]]] forms_inputs: The metadata forms that are to be attached to the custom asset type.
        :param pulumi.Input[_builtins.str] name: The name of the custom asset type.
        :param pulumi.Input[_builtins.str] owning_project_identifier: The unique identifier of the Amazon DataZone project that owns the custom asset type.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] revision: The revision of the asset type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssetTypeState.__new__(_AssetTypeState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_identifier"] = domain_identifier
        __props__.__dict__["forms_inputs"] = forms_inputs
        __props__.__dict__["name"] = name
        __props__.__dict__["owning_project_identifier"] = owning_project_identifier
        __props__.__dict__["region"] = region
        __props__.__dict__["revision"] = revision
        __props__.__dict__["timeouts"] = timeouts
        return AssetType(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the custom asset type was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The user who created the custom asset type.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the custom asset type.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the Amazon DataZone domain where the custom asset type is being created.
        """
        return pulumi.get(self, "domain_identifier")

    @_builtins.property
    @pulumi.getter(name="formsInputs")
    def forms_inputs(self) -> pulumi.Output[Optional[Sequence['outputs.AssetTypeFormsInput']]]:
        """
        The metadata forms that are to be attached to the custom asset type.
        """
        return pulumi.get(self, "forms_inputs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the custom asset type.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="owningProjectIdentifier")
    def owning_project_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the Amazon DataZone project that owns the custom asset type.

        The following arguments are optional:
        """
        return pulumi.get(self, "owning_project_identifier")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> pulumi.Output[_builtins.str]:
        """
        The revision of the asset type.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.AssetTypeTimeouts']]:
        return pulumi.get(self, "timeouts")

