# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GatewayAssociationArgs', 'GatewayAssociation']

@pulumi.input_type
class GatewayAssociationArgs:
    def __init__(__self__, *,
                 dx_gateway_id: pulumi.Input[_builtins.str],
                 allowed_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 associated_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 associated_gateway_owner_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proposal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GatewayAssociation resource.
        :param pulumi.Input[_builtins.str] dx_gateway_id: The ID of the Direct Connect gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_prefixes: VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
               
               > **NOTE:** `dx_gateway_id` and `associated_gateway_id` must be specified for single account Direct Connect gateway associations.
               
               > **NOTE:** If the `associated_gateway_id` is in another region, an alias in a new provider block for that region should be specified.
        :param pulumi.Input[_builtins.str] associated_gateway_id: The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
               Used for single account Direct Connect gateway associations.
        :param pulumi.Input[_builtins.str] associated_gateway_owner_account_id: The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
               Used for cross-account Direct Connect gateway associations.
        :param pulumi.Input[_builtins.str] proposal_id: The ID of the Direct Connect gateway association proposal.
               Used for cross-account Direct Connect gateway associations.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "dx_gateway_id", dx_gateway_id)
        if allowed_prefixes is not None:
            pulumi.set(__self__, "allowed_prefixes", allowed_prefixes)
        if associated_gateway_id is not None:
            pulumi.set(__self__, "associated_gateway_id", associated_gateway_id)
        if associated_gateway_owner_account_id is not None:
            pulumi.set(__self__, "associated_gateway_owner_account_id", associated_gateway_owner_account_id)
        if proposal_id is not None:
            pulumi.set(__self__, "proposal_id", proposal_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="dxGatewayId")
    def dx_gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Direct Connect gateway.
        """
        return pulumi.get(self, "dx_gateway_id")

    @dx_gateway_id.setter
    def dx_gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dx_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="allowedPrefixes")
    def allowed_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.

        > **NOTE:** `dx_gateway_id` and `associated_gateway_id` must be specified for single account Direct Connect gateway associations.

        > **NOTE:** If the `associated_gateway_id` is in another region, an alias in a new provider block for that region should be specified.
        """
        return pulumi.get(self, "allowed_prefixes")

    @allowed_prefixes.setter
    def allowed_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_prefixes", value)

    @_builtins.property
    @pulumi.getter(name="associatedGatewayId")
    def associated_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
        Used for single account Direct Connect gateway associations.
        """
        return pulumi.get(self, "associated_gateway_id")

    @associated_gateway_id.setter
    def associated_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associated_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="associatedGatewayOwnerAccountId")
    def associated_gateway_owner_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
        Used for cross-account Direct Connect gateway associations.
        """
        return pulumi.get(self, "associated_gateway_owner_account_id")

    @associated_gateway_owner_account_id.setter
    def associated_gateway_owner_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associated_gateway_owner_account_id", value)

    @_builtins.property
    @pulumi.getter(name="proposalId")
    def proposal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Direct Connect gateway association proposal.
        Used for cross-account Direct Connect gateway associations.
        """
        return pulumi.get(self, "proposal_id")

    @proposal_id.setter
    def proposal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proposal_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _GatewayAssociationState:
    def __init__(__self__, *,
                 allowed_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 associated_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 associated_gateway_owner_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 associated_gateway_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dx_gateway_association_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dx_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dx_gateway_owner_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proposal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_gateway_attachment_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GatewayAssociation resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_prefixes: VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
               
               > **NOTE:** `dx_gateway_id` and `associated_gateway_id` must be specified for single account Direct Connect gateway associations.
               
               > **NOTE:** If the `associated_gateway_id` is in another region, an alias in a new provider block for that region should be specified.
        :param pulumi.Input[_builtins.str] associated_gateway_id: The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
               Used for single account Direct Connect gateway associations.
        :param pulumi.Input[_builtins.str] associated_gateway_owner_account_id: The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
               Used for cross-account Direct Connect gateway associations.
        :param pulumi.Input[_builtins.str] associated_gateway_type: The type of the associated gateway, `transitGateway` or `virtualPrivateGateway`.
        :param pulumi.Input[_builtins.str] dx_gateway_association_id: The ID of the Direct Connect gateway association.
        :param pulumi.Input[_builtins.str] dx_gateway_id: The ID of the Direct Connect gateway.
        :param pulumi.Input[_builtins.str] dx_gateway_owner_account_id: The ID of the AWS account that owns the Direct Connect gateway.
        :param pulumi.Input[_builtins.str] proposal_id: The ID of the Direct Connect gateway association proposal.
               Used for cross-account Direct Connect gateway associations.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] transit_gateway_attachment_id: The ID of the Transit Gateway Attachment when the type is `transitGateway`.
        """
        if allowed_prefixes is not None:
            pulumi.set(__self__, "allowed_prefixes", allowed_prefixes)
        if associated_gateway_id is not None:
            pulumi.set(__self__, "associated_gateway_id", associated_gateway_id)
        if associated_gateway_owner_account_id is not None:
            pulumi.set(__self__, "associated_gateway_owner_account_id", associated_gateway_owner_account_id)
        if associated_gateway_type is not None:
            pulumi.set(__self__, "associated_gateway_type", associated_gateway_type)
        if dx_gateway_association_id is not None:
            pulumi.set(__self__, "dx_gateway_association_id", dx_gateway_association_id)
        if dx_gateway_id is not None:
            pulumi.set(__self__, "dx_gateway_id", dx_gateway_id)
        if dx_gateway_owner_account_id is not None:
            pulumi.set(__self__, "dx_gateway_owner_account_id", dx_gateway_owner_account_id)
        if proposal_id is not None:
            pulumi.set(__self__, "proposal_id", proposal_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if transit_gateway_attachment_id is not None:
            pulumi.set(__self__, "transit_gateway_attachment_id", transit_gateway_attachment_id)

    @_builtins.property
    @pulumi.getter(name="allowedPrefixes")
    def allowed_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.

        > **NOTE:** `dx_gateway_id` and `associated_gateway_id` must be specified for single account Direct Connect gateway associations.

        > **NOTE:** If the `associated_gateway_id` is in another region, an alias in a new provider block for that region should be specified.
        """
        return pulumi.get(self, "allowed_prefixes")

    @allowed_prefixes.setter
    def allowed_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_prefixes", value)

    @_builtins.property
    @pulumi.getter(name="associatedGatewayId")
    def associated_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
        Used for single account Direct Connect gateway associations.
        """
        return pulumi.get(self, "associated_gateway_id")

    @associated_gateway_id.setter
    def associated_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associated_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="associatedGatewayOwnerAccountId")
    def associated_gateway_owner_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
        Used for cross-account Direct Connect gateway associations.
        """
        return pulumi.get(self, "associated_gateway_owner_account_id")

    @associated_gateway_owner_account_id.setter
    def associated_gateway_owner_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associated_gateway_owner_account_id", value)

    @_builtins.property
    @pulumi.getter(name="associatedGatewayType")
    def associated_gateway_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the associated gateway, `transitGateway` or `virtualPrivateGateway`.
        """
        return pulumi.get(self, "associated_gateway_type")

    @associated_gateway_type.setter
    def associated_gateway_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associated_gateway_type", value)

    @_builtins.property
    @pulumi.getter(name="dxGatewayAssociationId")
    def dx_gateway_association_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Direct Connect gateway association.
        """
        return pulumi.get(self, "dx_gateway_association_id")

    @dx_gateway_association_id.setter
    def dx_gateway_association_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dx_gateway_association_id", value)

    @_builtins.property
    @pulumi.getter(name="dxGatewayId")
    def dx_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Direct Connect gateway.
        """
        return pulumi.get(self, "dx_gateway_id")

    @dx_gateway_id.setter
    def dx_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dx_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="dxGatewayOwnerAccountId")
    def dx_gateway_owner_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the AWS account that owns the Direct Connect gateway.
        """
        return pulumi.get(self, "dx_gateway_owner_account_id")

    @dx_gateway_owner_account_id.setter
    def dx_gateway_owner_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dx_gateway_owner_account_id", value)

    @_builtins.property
    @pulumi.getter(name="proposalId")
    def proposal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Direct Connect gateway association proposal.
        Used for cross-account Direct Connect gateway associations.
        """
        return pulumi.get(self, "proposal_id")

    @proposal_id.setter
    def proposal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proposal_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="transitGatewayAttachmentId")
    def transit_gateway_attachment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Transit Gateway Attachment when the type is `transitGateway`.
        """
        return pulumi.get(self, "transit_gateway_attachment_id")

    @transit_gateway_attachment_id.setter
    def transit_gateway_attachment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_gateway_attachment_id", value)


@pulumi.type_token("aws:directconnect/gatewayAssociation:GatewayAssociation")
class GatewayAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 associated_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 associated_gateway_owner_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dx_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proposal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Associates a Direct Connect Gateway with a VGW or transit gateway.

        To create a cross-account association, create an `directconnect.GatewayAssociationProposal` resource
        in the AWS account that owns the VGW or transit gateway and then accept the proposal in the AWS account that owns the Direct Connect Gateway
        by creating an `directconnect.GatewayAssociation` resource with the `proposal_id` and `associated_gateway_owner_account_id` attributes set.

        ## Example Usage

        ### VPN Gateway Association

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.directconnect.Gateway("example",
            name="example",
            amazon_side_asn="64512")
        example_vpc = aws.ec2.Vpc("example", cidr_block="10.255.255.0/28")
        example_vpn_gateway = aws.ec2.VpnGateway("example", vpc_id=example_vpc.id)
        example_gateway_association = aws.directconnect.GatewayAssociation("example",
            dx_gateway_id=example.id,
            associated_gateway_id=example_vpn_gateway.id)
        ```

        ### Transit Gateway Association

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.directconnect.Gateway("example",
            name="example",
            amazon_side_asn="64512")
        example_transit_gateway = aws.ec2transitgateway.TransitGateway("example")
        example_gateway_association = aws.directconnect.GatewayAssociation("example",
            dx_gateway_id=example.id,
            associated_gateway_id=example_transit_gateway.id,
            allowed_prefixes=[
                "10.255.255.0/30",
                "10.255.255.8/30",
            ])
        ```

        ### Allowed Prefixes

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.directconnect.Gateway("example",
            name="example",
            amazon_side_asn="64512")
        example_vpc = aws.ec2.Vpc("example", cidr_block="10.255.255.0/28")
        example_vpn_gateway = aws.ec2.VpnGateway("example", vpc_id=example_vpc.id)
        example_gateway_association = aws.directconnect.GatewayAssociation("example",
            dx_gateway_id=example.id,
            associated_gateway_id=example_vpn_gateway.id,
            allowed_prefixes=[
                "210.52.109.0/24",
                "175.45.176.0/22",
            ])
        ```

        ## Import

        Using `pulumi import`, import Direct Connect gateway associations using `dx_gateway_id` together with `associated_gateway_id`. For example:

        ```sh
        $ pulumi import aws:directconnect/gatewayAssociation:GatewayAssociation example 345508c3-7215-4aef-9832-07c125d5bd0f/vgw-98765432
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_prefixes: VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
               
               > **NOTE:** `dx_gateway_id` and `associated_gateway_id` must be specified for single account Direct Connect gateway associations.
               
               > **NOTE:** If the `associated_gateway_id` is in another region, an alias in a new provider block for that region should be specified.
        :param pulumi.Input[_builtins.str] associated_gateway_id: The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
               Used for single account Direct Connect gateway associations.
        :param pulumi.Input[_builtins.str] associated_gateway_owner_account_id: The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
               Used for cross-account Direct Connect gateway associations.
        :param pulumi.Input[_builtins.str] dx_gateway_id: The ID of the Direct Connect gateway.
        :param pulumi.Input[_builtins.str] proposal_id: The ID of the Direct Connect gateway association proposal.
               Used for cross-account Direct Connect gateway associations.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Associates a Direct Connect Gateway with a VGW or transit gateway.

        To create a cross-account association, create an `directconnect.GatewayAssociationProposal` resource
        in the AWS account that owns the VGW or transit gateway and then accept the proposal in the AWS account that owns the Direct Connect Gateway
        by creating an `directconnect.GatewayAssociation` resource with the `proposal_id` and `associated_gateway_owner_account_id` attributes set.

        ## Example Usage

        ### VPN Gateway Association

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.directconnect.Gateway("example",
            name="example",
            amazon_side_asn="64512")
        example_vpc = aws.ec2.Vpc("example", cidr_block="10.255.255.0/28")
        example_vpn_gateway = aws.ec2.VpnGateway("example", vpc_id=example_vpc.id)
        example_gateway_association = aws.directconnect.GatewayAssociation("example",
            dx_gateway_id=example.id,
            associated_gateway_id=example_vpn_gateway.id)
        ```

        ### Transit Gateway Association

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.directconnect.Gateway("example",
            name="example",
            amazon_side_asn="64512")
        example_transit_gateway = aws.ec2transitgateway.TransitGateway("example")
        example_gateway_association = aws.directconnect.GatewayAssociation("example",
            dx_gateway_id=example.id,
            associated_gateway_id=example_transit_gateway.id,
            allowed_prefixes=[
                "10.255.255.0/30",
                "10.255.255.8/30",
            ])
        ```

        ### Allowed Prefixes

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.directconnect.Gateway("example",
            name="example",
            amazon_side_asn="64512")
        example_vpc = aws.ec2.Vpc("example", cidr_block="10.255.255.0/28")
        example_vpn_gateway = aws.ec2.VpnGateway("example", vpc_id=example_vpc.id)
        example_gateway_association = aws.directconnect.GatewayAssociation("example",
            dx_gateway_id=example.id,
            associated_gateway_id=example_vpn_gateway.id,
            allowed_prefixes=[
                "210.52.109.0/24",
                "175.45.176.0/22",
            ])
        ```

        ## Import

        Using `pulumi import`, import Direct Connect gateway associations using `dx_gateway_id` together with `associated_gateway_id`. For example:

        ```sh
        $ pulumi import aws:directconnect/gatewayAssociation:GatewayAssociation example 345508c3-7215-4aef-9832-07c125d5bd0f/vgw-98765432
        ```

        :param str resource_name: The name of the resource.
        :param GatewayAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 associated_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 associated_gateway_owner_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dx_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proposal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayAssociationArgs.__new__(GatewayAssociationArgs)

            __props__.__dict__["allowed_prefixes"] = allowed_prefixes
            __props__.__dict__["associated_gateway_id"] = associated_gateway_id
            __props__.__dict__["associated_gateway_owner_account_id"] = associated_gateway_owner_account_id
            if dx_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'dx_gateway_id'")
            __props__.__dict__["dx_gateway_id"] = dx_gateway_id
            __props__.__dict__["proposal_id"] = proposal_id
            __props__.__dict__["region"] = region
            __props__.__dict__["associated_gateway_type"] = None
            __props__.__dict__["dx_gateway_association_id"] = None
            __props__.__dict__["dx_gateway_owner_account_id"] = None
            __props__.__dict__["transit_gateway_attachment_id"] = None
        super(GatewayAssociation, __self__).__init__(
            'aws:directconnect/gatewayAssociation:GatewayAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            associated_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            associated_gateway_owner_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            associated_gateway_type: Optional[pulumi.Input[_builtins.str]] = None,
            dx_gateway_association_id: Optional[pulumi.Input[_builtins.str]] = None,
            dx_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            dx_gateway_owner_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            proposal_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            transit_gateway_attachment_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'GatewayAssociation':
        """
        Get an existing GatewayAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_prefixes: VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
               
               > **NOTE:** `dx_gateway_id` and `associated_gateway_id` must be specified for single account Direct Connect gateway associations.
               
               > **NOTE:** If the `associated_gateway_id` is in another region, an alias in a new provider block for that region should be specified.
        :param pulumi.Input[_builtins.str] associated_gateway_id: The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
               Used for single account Direct Connect gateway associations.
        :param pulumi.Input[_builtins.str] associated_gateway_owner_account_id: The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
               Used for cross-account Direct Connect gateway associations.
        :param pulumi.Input[_builtins.str] associated_gateway_type: The type of the associated gateway, `transitGateway` or `virtualPrivateGateway`.
        :param pulumi.Input[_builtins.str] dx_gateway_association_id: The ID of the Direct Connect gateway association.
        :param pulumi.Input[_builtins.str] dx_gateway_id: The ID of the Direct Connect gateway.
        :param pulumi.Input[_builtins.str] dx_gateway_owner_account_id: The ID of the AWS account that owns the Direct Connect gateway.
        :param pulumi.Input[_builtins.str] proposal_id: The ID of the Direct Connect gateway association proposal.
               Used for cross-account Direct Connect gateway associations.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] transit_gateway_attachment_id: The ID of the Transit Gateway Attachment when the type is `transitGateway`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayAssociationState.__new__(_GatewayAssociationState)

        __props__.__dict__["allowed_prefixes"] = allowed_prefixes
        __props__.__dict__["associated_gateway_id"] = associated_gateway_id
        __props__.__dict__["associated_gateway_owner_account_id"] = associated_gateway_owner_account_id
        __props__.__dict__["associated_gateway_type"] = associated_gateway_type
        __props__.__dict__["dx_gateway_association_id"] = dx_gateway_association_id
        __props__.__dict__["dx_gateway_id"] = dx_gateway_id
        __props__.__dict__["dx_gateway_owner_account_id"] = dx_gateway_owner_account_id
        __props__.__dict__["proposal_id"] = proposal_id
        __props__.__dict__["region"] = region
        __props__.__dict__["transit_gateway_attachment_id"] = transit_gateway_attachment_id
        return GatewayAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedPrefixes")
    def allowed_prefixes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.

        > **NOTE:** `dx_gateway_id` and `associated_gateway_id` must be specified for single account Direct Connect gateway associations.

        > **NOTE:** If the `associated_gateway_id` is in another region, an alias in a new provider block for that region should be specified.
        """
        return pulumi.get(self, "allowed_prefixes")

    @_builtins.property
    @pulumi.getter(name="associatedGatewayId")
    def associated_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
        Used for single account Direct Connect gateway associations.
        """
        return pulumi.get(self, "associated_gateway_id")

    @_builtins.property
    @pulumi.getter(name="associatedGatewayOwnerAccountId")
    def associated_gateway_owner_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
        Used for cross-account Direct Connect gateway associations.
        """
        return pulumi.get(self, "associated_gateway_owner_account_id")

    @_builtins.property
    @pulumi.getter(name="associatedGatewayType")
    def associated_gateway_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the associated gateway, `transitGateway` or `virtualPrivateGateway`.
        """
        return pulumi.get(self, "associated_gateway_type")

    @_builtins.property
    @pulumi.getter(name="dxGatewayAssociationId")
    def dx_gateway_association_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Direct Connect gateway association.
        """
        return pulumi.get(self, "dx_gateway_association_id")

    @_builtins.property
    @pulumi.getter(name="dxGatewayId")
    def dx_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Direct Connect gateway.
        """
        return pulumi.get(self, "dx_gateway_id")

    @_builtins.property
    @pulumi.getter(name="dxGatewayOwnerAccountId")
    def dx_gateway_owner_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the AWS account that owns the Direct Connect gateway.
        """
        return pulumi.get(self, "dx_gateway_owner_account_id")

    @_builtins.property
    @pulumi.getter(name="proposalId")
    def proposal_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Direct Connect gateway association proposal.
        Used for cross-account Direct Connect gateway associations.
        """
        return pulumi.get(self, "proposal_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="transitGatewayAttachmentId")
    def transit_gateway_attachment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Transit Gateway Attachment when the type is `transitGateway`.
        """
        return pulumi.get(self, "transit_gateway_attachment_id")

