# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRouterConfigurationResult',
    'AwaitableGetRouterConfigurationResult',
    'get_router_configuration',
    'get_router_configuration_output',
]

@pulumi.output_type
class GetRouterConfigurationResult:
    """
    A collection of values returned by getRouterConfiguration.
    """
    def __init__(__self__, customer_router_config=None, id=None, region=None, router_type_identifier=None, routers=None, virtual_interface_id=None, virtual_interface_name=None):
        if customer_router_config and not isinstance(customer_router_config, str):
            raise TypeError("Expected argument 'customer_router_config' to be a str")
        pulumi.set(__self__, "customer_router_config", customer_router_config)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if router_type_identifier and not isinstance(router_type_identifier, str):
            raise TypeError("Expected argument 'router_type_identifier' to be a str")
        pulumi.set(__self__, "router_type_identifier", router_type_identifier)
        if routers and not isinstance(routers, list):
            raise TypeError("Expected argument 'routers' to be a list")
        pulumi.set(__self__, "routers", routers)
        if virtual_interface_id and not isinstance(virtual_interface_id, str):
            raise TypeError("Expected argument 'virtual_interface_id' to be a str")
        pulumi.set(__self__, "virtual_interface_id", virtual_interface_id)
        if virtual_interface_name and not isinstance(virtual_interface_name, str):
            raise TypeError("Expected argument 'virtual_interface_name' to be a str")
        pulumi.set(__self__, "virtual_interface_name", virtual_interface_name)

    @_builtins.property
    @pulumi.getter(name="customerRouterConfig")
    def customer_router_config(self) -> _builtins.str:
        """
        Instructions for configuring your router
        """
        return pulumi.get(self, "customer_router_config")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routerTypeIdentifier")
    def router_type_identifier(self) -> _builtins.str:
        """
        Router type identifier
        """
        return pulumi.get(self, "router_type_identifier")

    @_builtins.property
    @pulumi.getter
    def routers(self) -> Sequence['outputs.GetRouterConfigurationRouterResult']:
        """
        Block of the router type details
        """
        return pulumi.get(self, "routers")

    @_builtins.property
    @pulumi.getter(name="virtualInterfaceId")
    def virtual_interface_id(self) -> _builtins.str:
        return pulumi.get(self, "virtual_interface_id")

    @_builtins.property
    @pulumi.getter(name="virtualInterfaceName")
    def virtual_interface_name(self) -> _builtins.str:
        return pulumi.get(self, "virtual_interface_name")


class AwaitableGetRouterConfigurationResult(GetRouterConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouterConfigurationResult(
            customer_router_config=self.customer_router_config,
            id=self.id,
            region=self.region,
            router_type_identifier=self.router_type_identifier,
            routers=self.routers,
            virtual_interface_id=self.virtual_interface_id,
            virtual_interface_name=self.virtual_interface_name)


def get_router_configuration(region: Optional[_builtins.str] = None,
                             router_type_identifier: Optional[_builtins.str] = None,
                             virtual_interface_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouterConfigurationResult:
    """
    Data source for retrieving Router Configuration instructions for a given AWS Direct Connect Virtual Interface and Router Type.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.directconnect.get_router_configuration(virtual_interface_id="dxvif-abcde123",
        router_type_identifier="CiscoSystemsInc-2900SeriesRouters-IOS124")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str router_type_identifier: ID of the Router Type. For example: `CiscoSystemsInc-2900SeriesRouters-IOS124`
           
           There is currently no AWS API to retrieve the full list of `router_type_identifier` values. Here is a list of known `RouterType` objects that can be used:
           
           ```json
           {
           "routerTypes": [
           {"platform":"2900 Series Routers","routerTypeIdentifier":"CiscoSystemsInc-2900SeriesRouters-IOS124","software":"IOS 12.4+","vendor":"Cisco Systems, Inc.","xsltTemplateName":"customer-router-cisco-generic.xslt","xsltTemplateNameForMacSec":""},
           {"platform":"3700 Series Routers","routerTypeIdentifier":"CiscoSystemsInc-3700SeriesRouters-IOS124","software":"IOS 12.4+","vendor":"Cisco Systems, Inc.","xsltTemplateName":"customer-router-cisco-generic.xslt","xsltTemplateNameForMacSec":""},
           {"platform":"7200 Series Routers","routerTypeIdentifier":"CiscoSystemsInc-7200SeriesRouters-IOS124","software":"IOS 12.4+","vendor":"Cisco Systems, Inc.","xsltTemplateName":"customer-router-cisco-generic.xslt","xsltTemplateNameForMacSec":""},
           {"platform":"Nexus 7000 Series Switches","routerTypeIdentifier":"CiscoSystemsInc-Nexus7000SeriesSwitches-NXOS51","software":"NX-OS 5.1+","vendor":"Cisco Systems, Inc.","xsltTemplateName":"customer-switch-cisco-nexus-generic.xslt","xsltTemplateNameForMacSec":""},
           {"platform":"Nexus 9K+ Series Switches","routerTypeIdentifier":"CiscoSystemsInc-Nexus9KSeriesSwitches-NXOS93","software":"NX-OS 9.3+","vendor":"Cisco Systems, Inc.","xsltTemplateName":"customer-switch-cisco-nexus-generic.xslt","xsltTemplateNameForMacSec":"customer-switch-cisco-nexus-generic-macsec.xslt"},
           {"platform":"M/MX Series Routers","routerTypeIdentifier":"JuniperNetworksInc-MMXSeriesRouters-JunOS95","software":"JunOS 9.5+","vendor":"Juniper Networks, Inc.","xsltTemplateName":"customer-router-juniper-generic.xslt","xsltTemplateNameForMacSec":"customer-router-juniper-generic-macsec.xslt"},
           {"platform":"SRX Series Routers","routerTypeIdentifier":"JuniperNetworksInc-SRXSeriesRouters-JunOS95","software":"JunOS 9.5+","vendor":"Juniper Networks, Inc.","xsltTemplateName":"customer-router-juniper-generic.xslt","xsltTemplateNameForMacSec":""},
           {"platform":"T Series Routers","routerTypeIdentifier":"JuniperNetworksInc-TSeriesRouters-JunOS95","software":"JunOS 9.5+","vendor":"Juniper Networks, Inc.","xsltTemplateName":"customer-router-juniper-generic.xslt","xsltTemplateNameForMacSec":""},
           {"platform":"PA-3000+ and 5000+ series","routerTypeIdentifier":"PaloAltoNetworks-PA3000and5000series-PANOS803","software":"PAN-OS 8.0.3+","vendor":"Palo Alto Networks","xsltTemplateName":"customer-router-palo-alto-generic.xslt","xsltTemplateNameForMacSec":""}]
           }
           ```
    :param _builtins.str virtual_interface_id: ID of the Direct Connect Virtual Interface
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['routerTypeIdentifier'] = router_type_identifier
    __args__['virtualInterfaceId'] = virtual_interface_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:directconnect/getRouterConfiguration:getRouterConfiguration', __args__, opts=opts, typ=GetRouterConfigurationResult).value

    return AwaitableGetRouterConfigurationResult(
        customer_router_config=pulumi.get(__ret__, 'customer_router_config'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        router_type_identifier=pulumi.get(__ret__, 'router_type_identifier'),
        routers=pulumi.get(__ret__, 'routers'),
        virtual_interface_id=pulumi.get(__ret__, 'virtual_interface_id'),
        virtual_interface_name=pulumi.get(__ret__, 'virtual_interface_name'))
def get_router_configuration_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    router_type_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                                    virtual_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRouterConfigurationResult]:
    """
    Data source for retrieving Router Configuration instructions for a given AWS Direct Connect Virtual Interface and Router Type.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.directconnect.get_router_configuration(virtual_interface_id="dxvif-abcde123",
        router_type_identifier="CiscoSystemsInc-2900SeriesRouters-IOS124")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str router_type_identifier: ID of the Router Type. For example: `CiscoSystemsInc-2900SeriesRouters-IOS124`
           
           There is currently no AWS API to retrieve the full list of `router_type_identifier` values. Here is a list of known `RouterType` objects that can be used:
           
           ```json
           {
           "routerTypes": [
           {"platform":"2900 Series Routers","routerTypeIdentifier":"CiscoSystemsInc-2900SeriesRouters-IOS124","software":"IOS 12.4+","vendor":"Cisco Systems, Inc.","xsltTemplateName":"customer-router-cisco-generic.xslt","xsltTemplateNameForMacSec":""},
           {"platform":"3700 Series Routers","routerTypeIdentifier":"CiscoSystemsInc-3700SeriesRouters-IOS124","software":"IOS 12.4+","vendor":"Cisco Systems, Inc.","xsltTemplateName":"customer-router-cisco-generic.xslt","xsltTemplateNameForMacSec":""},
           {"platform":"7200 Series Routers","routerTypeIdentifier":"CiscoSystemsInc-7200SeriesRouters-IOS124","software":"IOS 12.4+","vendor":"Cisco Systems, Inc.","xsltTemplateName":"customer-router-cisco-generic.xslt","xsltTemplateNameForMacSec":""},
           {"platform":"Nexus 7000 Series Switches","routerTypeIdentifier":"CiscoSystemsInc-Nexus7000SeriesSwitches-NXOS51","software":"NX-OS 5.1+","vendor":"Cisco Systems, Inc.","xsltTemplateName":"customer-switch-cisco-nexus-generic.xslt","xsltTemplateNameForMacSec":""},
           {"platform":"Nexus 9K+ Series Switches","routerTypeIdentifier":"CiscoSystemsInc-Nexus9KSeriesSwitches-NXOS93","software":"NX-OS 9.3+","vendor":"Cisco Systems, Inc.","xsltTemplateName":"customer-switch-cisco-nexus-generic.xslt","xsltTemplateNameForMacSec":"customer-switch-cisco-nexus-generic-macsec.xslt"},
           {"platform":"M/MX Series Routers","routerTypeIdentifier":"JuniperNetworksInc-MMXSeriesRouters-JunOS95","software":"JunOS 9.5+","vendor":"Juniper Networks, Inc.","xsltTemplateName":"customer-router-juniper-generic.xslt","xsltTemplateNameForMacSec":"customer-router-juniper-generic-macsec.xslt"},
           {"platform":"SRX Series Routers","routerTypeIdentifier":"JuniperNetworksInc-SRXSeriesRouters-JunOS95","software":"JunOS 9.5+","vendor":"Juniper Networks, Inc.","xsltTemplateName":"customer-router-juniper-generic.xslt","xsltTemplateNameForMacSec":""},
           {"platform":"T Series Routers","routerTypeIdentifier":"JuniperNetworksInc-TSeriesRouters-JunOS95","software":"JunOS 9.5+","vendor":"Juniper Networks, Inc.","xsltTemplateName":"customer-router-juniper-generic.xslt","xsltTemplateNameForMacSec":""},
           {"platform":"PA-3000+ and 5000+ series","routerTypeIdentifier":"PaloAltoNetworks-PA3000and5000series-PANOS803","software":"PAN-OS 8.0.3+","vendor":"Palo Alto Networks","xsltTemplateName":"customer-router-palo-alto-generic.xslt","xsltTemplateNameForMacSec":""}]
           }
           ```
    :param _builtins.str virtual_interface_id: ID of the Direct Connect Virtual Interface
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['routerTypeIdentifier'] = router_type_identifier
    __args__['virtualInterfaceId'] = virtual_interface_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:directconnect/getRouterConfiguration:getRouterConfiguration', __args__, opts=opts, typ=GetRouterConfigurationResult)
    return __ret__.apply(lambda __response__: GetRouterConfigurationResult(
        customer_router_config=pulumi.get(__response__, 'customer_router_config'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        router_type_identifier=pulumi.get(__response__, 'router_type_identifier'),
        routers=pulumi.get(__response__, 'routers'),
        virtual_interface_id=pulumi.get(__response__, 'virtual_interface_id'),
        virtual_interface_name=pulumi.get(__response__, 'virtual_interface_name')))
