# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TrustArgs', 'Trust']

@pulumi.input_type
class TrustArgs:
    def __init__(__self__, *,
                 directory_id: pulumi.Input[_builtins.str],
                 remote_domain_name: pulumi.Input[_builtins.str],
                 trust_direction: pulumi.Input[_builtins.str],
                 trust_password: pulumi.Input[_builtins.str],
                 conditional_forwarder_ip_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 delete_associated_conditional_forwarder: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 selective_auth: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Trust resource.
        :param pulumi.Input[_builtins.str] directory_id: ID of the Directory.
        :param pulumi.Input[_builtins.str] remote_domain_name: Fully qualified domain name of the remote Directory.
        :param pulumi.Input[_builtins.str] trust_direction: The direction of the Trust relationship.
               Valid values are `One-Way: Outgoing`, `One-Way: Incoming`, and `Two-Way`.
        :param pulumi.Input[_builtins.str] trust_password: Password for the Trust.
               Does not need to match the passwords for either Directory.
               Can contain upper- and lower-case letters, numbers, and punctuation characters.
               May be up to 128 characters long.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] conditional_forwarder_ip_addrs: Set of IPv4 addresses for the DNS server associated with the remote Directory.
               Can contain between 1 and 4 values.
        :param pulumi.Input[_builtins.bool] delete_associated_conditional_forwarder: Whether to delete the conditional forwarder when deleting the Trust relationship.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] selective_auth: Whether to enable selective authentication.
               Valid values are `Enabled` and `Disabled`.
               Default value is `Disabled`.
        :param pulumi.Input[_builtins.str] trust_type: Type of the Trust relationship.
               Valid values are `Forest` and `External`.
               Default value is `Forest`.
        """
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "remote_domain_name", remote_domain_name)
        pulumi.set(__self__, "trust_direction", trust_direction)
        pulumi.set(__self__, "trust_password", trust_password)
        if conditional_forwarder_ip_addrs is not None:
            pulumi.set(__self__, "conditional_forwarder_ip_addrs", conditional_forwarder_ip_addrs)
        if delete_associated_conditional_forwarder is not None:
            pulumi.set(__self__, "delete_associated_conditional_forwarder", delete_associated_conditional_forwarder)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if selective_auth is not None:
            pulumi.set(__self__, "selective_auth", selective_auth)
        if trust_type is not None:
            pulumi.set(__self__, "trust_type", trust_type)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="remoteDomainName")
    def remote_domain_name(self) -> pulumi.Input[_builtins.str]:
        """
        Fully qualified domain name of the remote Directory.
        """
        return pulumi.get(self, "remote_domain_name")

    @remote_domain_name.setter
    def remote_domain_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "remote_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="trustDirection")
    def trust_direction(self) -> pulumi.Input[_builtins.str]:
        """
        The direction of the Trust relationship.
        Valid values are `One-Way: Outgoing`, `One-Way: Incoming`, and `Two-Way`.
        """
        return pulumi.get(self, "trust_direction")

    @trust_direction.setter
    def trust_direction(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trust_direction", value)

    @_builtins.property
    @pulumi.getter(name="trustPassword")
    def trust_password(self) -> pulumi.Input[_builtins.str]:
        """
        Password for the Trust.
        Does not need to match the passwords for either Directory.
        Can contain upper- and lower-case letters, numbers, and punctuation characters.
        May be up to 128 characters long.
        """
        return pulumi.get(self, "trust_password")

    @trust_password.setter
    def trust_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trust_password", value)

    @_builtins.property
    @pulumi.getter(name="conditionalForwarderIpAddrs")
    def conditional_forwarder_ip_addrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of IPv4 addresses for the DNS server associated with the remote Directory.
        Can contain between 1 and 4 values.
        """
        return pulumi.get(self, "conditional_forwarder_ip_addrs")

    @conditional_forwarder_ip_addrs.setter
    def conditional_forwarder_ip_addrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "conditional_forwarder_ip_addrs", value)

    @_builtins.property
    @pulumi.getter(name="deleteAssociatedConditionalForwarder")
    def delete_associated_conditional_forwarder(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to delete the conditional forwarder when deleting the Trust relationship.
        """
        return pulumi.get(self, "delete_associated_conditional_forwarder")

    @delete_associated_conditional_forwarder.setter
    def delete_associated_conditional_forwarder(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_associated_conditional_forwarder", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="selectiveAuth")
    def selective_auth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable selective authentication.
        Valid values are `Enabled` and `Disabled`.
        Default value is `Disabled`.
        """
        return pulumi.get(self, "selective_auth")

    @selective_auth.setter
    def selective_auth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "selective_auth", value)

    @_builtins.property
    @pulumi.getter(name="trustType")
    def trust_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the Trust relationship.
        Valid values are `Forest` and `External`.
        Default value is `Forest`.
        """
        return pulumi.get(self, "trust_type")

    @trust_type.setter
    def trust_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_type", value)


@pulumi.input_type
class _TrustState:
    def __init__(__self__, *,
                 conditional_forwarder_ip_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 created_date_time: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_associated_conditional_forwarder: Optional[pulumi.Input[_builtins.bool]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_date_time: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 selective_auth: Optional[pulumi.Input[_builtins.str]] = None,
                 state_last_updated_date_time: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_password: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_state: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_state_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Trust resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] conditional_forwarder_ip_addrs: Set of IPv4 addresses for the DNS server associated with the remote Directory.
               Can contain between 1 and 4 values.
        :param pulumi.Input[_builtins.str] created_date_time: Date and time when the Trust was created.
        :param pulumi.Input[_builtins.bool] delete_associated_conditional_forwarder: Whether to delete the conditional forwarder when deleting the Trust relationship.
        :param pulumi.Input[_builtins.str] directory_id: ID of the Directory.
        :param pulumi.Input[_builtins.str] last_updated_date_time: Date and time when the Trust was last updated.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] remote_domain_name: Fully qualified domain name of the remote Directory.
        :param pulumi.Input[_builtins.str] selective_auth: Whether to enable selective authentication.
               Valid values are `Enabled` and `Disabled`.
               Default value is `Disabled`.
        :param pulumi.Input[_builtins.str] state_last_updated_date_time: Date and time when the Trust state in `trust_state` was last updated.
        :param pulumi.Input[_builtins.str] trust_direction: The direction of the Trust relationship.
               Valid values are `One-Way: Outgoing`, `One-Way: Incoming`, and `Two-Way`.
        :param pulumi.Input[_builtins.str] trust_password: Password for the Trust.
               Does not need to match the passwords for either Directory.
               Can contain upper- and lower-case letters, numbers, and punctuation characters.
               May be up to 128 characters long.
        :param pulumi.Input[_builtins.str] trust_state: State of the Trust relationship.
               One of `Created`, `VerifyFailed`,`Verified`, `UpdateFailed`,`Updated`,`Deleted`, or `Failed`.
        :param pulumi.Input[_builtins.str] trust_state_reason: Reason for the Trust state set in `trust_state`.
        :param pulumi.Input[_builtins.str] trust_type: Type of the Trust relationship.
               Valid values are `Forest` and `External`.
               Default value is `Forest`.
        """
        if conditional_forwarder_ip_addrs is not None:
            pulumi.set(__self__, "conditional_forwarder_ip_addrs", conditional_forwarder_ip_addrs)
        if created_date_time is not None:
            pulumi.set(__self__, "created_date_time", created_date_time)
        if delete_associated_conditional_forwarder is not None:
            pulumi.set(__self__, "delete_associated_conditional_forwarder", delete_associated_conditional_forwarder)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if last_updated_date_time is not None:
            pulumi.set(__self__, "last_updated_date_time", last_updated_date_time)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remote_domain_name is not None:
            pulumi.set(__self__, "remote_domain_name", remote_domain_name)
        if selective_auth is not None:
            pulumi.set(__self__, "selective_auth", selective_auth)
        if state_last_updated_date_time is not None:
            pulumi.set(__self__, "state_last_updated_date_time", state_last_updated_date_time)
        if trust_direction is not None:
            pulumi.set(__self__, "trust_direction", trust_direction)
        if trust_password is not None:
            pulumi.set(__self__, "trust_password", trust_password)
        if trust_state is not None:
            pulumi.set(__self__, "trust_state", trust_state)
        if trust_state_reason is not None:
            pulumi.set(__self__, "trust_state_reason", trust_state_reason)
        if trust_type is not None:
            pulumi.set(__self__, "trust_type", trust_type)

    @_builtins.property
    @pulumi.getter(name="conditionalForwarderIpAddrs")
    def conditional_forwarder_ip_addrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of IPv4 addresses for the DNS server associated with the remote Directory.
        Can contain between 1 and 4 values.
        """
        return pulumi.get(self, "conditional_forwarder_ip_addrs")

    @conditional_forwarder_ip_addrs.setter
    def conditional_forwarder_ip_addrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "conditional_forwarder_ip_addrs", value)

    @_builtins.property
    @pulumi.getter(name="createdDateTime")
    def created_date_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time when the Trust was created.
        """
        return pulumi.get(self, "created_date_time")

    @created_date_time.setter
    def created_date_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_date_time", value)

    @_builtins.property
    @pulumi.getter(name="deleteAssociatedConditionalForwarder")
    def delete_associated_conditional_forwarder(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to delete the conditional forwarder when deleting the Trust relationship.
        """
        return pulumi.get(self, "delete_associated_conditional_forwarder")

    @delete_associated_conditional_forwarder.setter
    def delete_associated_conditional_forwarder(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_associated_conditional_forwarder", value)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedDateTime")
    def last_updated_date_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time when the Trust was last updated.
        """
        return pulumi.get(self, "last_updated_date_time")

    @last_updated_date_time.setter
    def last_updated_date_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_date_time", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="remoteDomainName")
    def remote_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified domain name of the remote Directory.
        """
        return pulumi.get(self, "remote_domain_name")

    @remote_domain_name.setter
    def remote_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="selectiveAuth")
    def selective_auth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable selective authentication.
        Valid values are `Enabled` and `Disabled`.
        Default value is `Disabled`.
        """
        return pulumi.get(self, "selective_auth")

    @selective_auth.setter
    def selective_auth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "selective_auth", value)

    @_builtins.property
    @pulumi.getter(name="stateLastUpdatedDateTime")
    def state_last_updated_date_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time when the Trust state in `trust_state` was last updated.
        """
        return pulumi.get(self, "state_last_updated_date_time")

    @state_last_updated_date_time.setter
    def state_last_updated_date_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state_last_updated_date_time", value)

    @_builtins.property
    @pulumi.getter(name="trustDirection")
    def trust_direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The direction of the Trust relationship.
        Valid values are `One-Way: Outgoing`, `One-Way: Incoming`, and `Two-Way`.
        """
        return pulumi.get(self, "trust_direction")

    @trust_direction.setter
    def trust_direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_direction", value)

    @_builtins.property
    @pulumi.getter(name="trustPassword")
    def trust_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for the Trust.
        Does not need to match the passwords for either Directory.
        Can contain upper- and lower-case letters, numbers, and punctuation characters.
        May be up to 128 characters long.
        """
        return pulumi.get(self, "trust_password")

    @trust_password.setter
    def trust_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_password", value)

    @_builtins.property
    @pulumi.getter(name="trustState")
    def trust_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the Trust relationship.
        One of `Created`, `VerifyFailed`,`Verified`, `UpdateFailed`,`Updated`,`Deleted`, or `Failed`.
        """
        return pulumi.get(self, "trust_state")

    @trust_state.setter
    def trust_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_state", value)

    @_builtins.property
    @pulumi.getter(name="trustStateReason")
    def trust_state_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reason for the Trust state set in `trust_state`.
        """
        return pulumi.get(self, "trust_state_reason")

    @trust_state_reason.setter
    def trust_state_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_state_reason", value)

    @_builtins.property
    @pulumi.getter(name="trustType")
    def trust_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the Trust relationship.
        Valid values are `Forest` and `External`.
        Default value is `Forest`.
        """
        return pulumi.get(self, "trust_type")

    @trust_type.setter
    def trust_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_type", value)


@pulumi.type_token("aws:directoryservice/trust:Trust")
class Trust(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditional_forwarder_ip_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 delete_associated_conditional_forwarder: Optional[pulumi.Input[_builtins.bool]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 selective_auth: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_password: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a trust relationship between two Active Directory Directories.

        The directories may either be both AWS Managed Microsoft AD domains or an AWS Managed Microsoft AD domain and a self-managed Active Directory Domain.

        The Trust relationship must be configured on both sides of the relationship.
        If a Trust has only been created on one side, it will be in the state `VerifyFailed`.
        Once the second Trust is created, the first will update to the correct state.

        ## Example Usage

        ### Two-Way Trust

        ```python
        import pulumi
        import pulumi_aws as aws

        one_directory = aws.directoryservice.Directory("one",
            name="one.example.com",
            type="MicrosoftAD")
        two_directory = aws.directoryservice.Directory("two",
            name="two.example.com",
            type="MicrosoftAD")
        one = aws.directoryservice.Trust("one",
            directory_id=one_directory.id,
            remote_domain_name=two_directory.name,
            trust_direction="Two-Way",
            trust_password="Some0therPassword",
            conditional_forwarder_ip_addrs=two_directory.dns_ip_addresses)
        two = aws.directoryservice.Trust("two",
            directory_id=two_directory.id,
            remote_domain_name=one_directory.name,
            trust_direction="Two-Way",
            trust_password="Some0therPassword",
            conditional_forwarder_ip_addrs=one_directory.dns_ip_addresses)
        ```

        ### One-Way Trust

        ```python
        import pulumi
        import pulumi_aws as aws

        one_directory = aws.directoryservice.Directory("one",
            name="one.example.com",
            type="MicrosoftAD")
        two_directory = aws.directoryservice.Directory("two",
            name="two.example.com",
            type="MicrosoftAD")
        one = aws.directoryservice.Trust("one",
            directory_id=one_directory.id,
            remote_domain_name=two_directory.name,
            trust_direction="One-Way: Incoming",
            trust_password="Some0therPassword",
            conditional_forwarder_ip_addrs=two_directory.dns_ip_addresses)
        two = aws.directoryservice.Trust("two",
            directory_id=two_directory.id,
            remote_domain_name=one_directory.name,
            trust_direction="One-Way: Outgoing",
            trust_password="Some0therPassword",
            conditional_forwarder_ip_addrs=one_directory.dns_ip_addresses)
        ```

        ## Import

        Using `pulumi import`, import the Trust relationship using the directory ID and remote domain name, separated by a `/`. For example:

        ```sh
        $ pulumi import aws:directoryservice/trust:Trust example d-926724cf57/directory.example.com
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] conditional_forwarder_ip_addrs: Set of IPv4 addresses for the DNS server associated with the remote Directory.
               Can contain between 1 and 4 values.
        :param pulumi.Input[_builtins.bool] delete_associated_conditional_forwarder: Whether to delete the conditional forwarder when deleting the Trust relationship.
        :param pulumi.Input[_builtins.str] directory_id: ID of the Directory.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] remote_domain_name: Fully qualified domain name of the remote Directory.
        :param pulumi.Input[_builtins.str] selective_auth: Whether to enable selective authentication.
               Valid values are `Enabled` and `Disabled`.
               Default value is `Disabled`.
        :param pulumi.Input[_builtins.str] trust_direction: The direction of the Trust relationship.
               Valid values are `One-Way: Outgoing`, `One-Way: Incoming`, and `Two-Way`.
        :param pulumi.Input[_builtins.str] trust_password: Password for the Trust.
               Does not need to match the passwords for either Directory.
               Can contain upper- and lower-case letters, numbers, and punctuation characters.
               May be up to 128 characters long.
        :param pulumi.Input[_builtins.str] trust_type: Type of the Trust relationship.
               Valid values are `Forest` and `External`.
               Default value is `Forest`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrustArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a trust relationship between two Active Directory Directories.

        The directories may either be both AWS Managed Microsoft AD domains or an AWS Managed Microsoft AD domain and a self-managed Active Directory Domain.

        The Trust relationship must be configured on both sides of the relationship.
        If a Trust has only been created on one side, it will be in the state `VerifyFailed`.
        Once the second Trust is created, the first will update to the correct state.

        ## Example Usage

        ### Two-Way Trust

        ```python
        import pulumi
        import pulumi_aws as aws

        one_directory = aws.directoryservice.Directory("one",
            name="one.example.com",
            type="MicrosoftAD")
        two_directory = aws.directoryservice.Directory("two",
            name="two.example.com",
            type="MicrosoftAD")
        one = aws.directoryservice.Trust("one",
            directory_id=one_directory.id,
            remote_domain_name=two_directory.name,
            trust_direction="Two-Way",
            trust_password="Some0therPassword",
            conditional_forwarder_ip_addrs=two_directory.dns_ip_addresses)
        two = aws.directoryservice.Trust("two",
            directory_id=two_directory.id,
            remote_domain_name=one_directory.name,
            trust_direction="Two-Way",
            trust_password="Some0therPassword",
            conditional_forwarder_ip_addrs=one_directory.dns_ip_addresses)
        ```

        ### One-Way Trust

        ```python
        import pulumi
        import pulumi_aws as aws

        one_directory = aws.directoryservice.Directory("one",
            name="one.example.com",
            type="MicrosoftAD")
        two_directory = aws.directoryservice.Directory("two",
            name="two.example.com",
            type="MicrosoftAD")
        one = aws.directoryservice.Trust("one",
            directory_id=one_directory.id,
            remote_domain_name=two_directory.name,
            trust_direction="One-Way: Incoming",
            trust_password="Some0therPassword",
            conditional_forwarder_ip_addrs=two_directory.dns_ip_addresses)
        two = aws.directoryservice.Trust("two",
            directory_id=two_directory.id,
            remote_domain_name=one_directory.name,
            trust_direction="One-Way: Outgoing",
            trust_password="Some0therPassword",
            conditional_forwarder_ip_addrs=one_directory.dns_ip_addresses)
        ```

        ## Import

        Using `pulumi import`, import the Trust relationship using the directory ID and remote domain name, separated by a `/`. For example:

        ```sh
        $ pulumi import aws:directoryservice/trust:Trust example d-926724cf57/directory.example.com
        ```

        :param str resource_name: The name of the resource.
        :param TrustArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrustArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditional_forwarder_ip_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 delete_associated_conditional_forwarder: Optional[pulumi.Input[_builtins.bool]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 selective_auth: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_password: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrustArgs.__new__(TrustArgs)

            __props__.__dict__["conditional_forwarder_ip_addrs"] = conditional_forwarder_ip_addrs
            __props__.__dict__["delete_associated_conditional_forwarder"] = delete_associated_conditional_forwarder
            if directory_id is None and not opts.urn:
                raise TypeError("Missing required property 'directory_id'")
            __props__.__dict__["directory_id"] = directory_id
            __props__.__dict__["region"] = region
            if remote_domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'remote_domain_name'")
            __props__.__dict__["remote_domain_name"] = remote_domain_name
            __props__.__dict__["selective_auth"] = selective_auth
            if trust_direction is None and not opts.urn:
                raise TypeError("Missing required property 'trust_direction'")
            __props__.__dict__["trust_direction"] = trust_direction
            if trust_password is None and not opts.urn:
                raise TypeError("Missing required property 'trust_password'")
            __props__.__dict__["trust_password"] = trust_password
            __props__.__dict__["trust_type"] = trust_type
            __props__.__dict__["created_date_time"] = None
            __props__.__dict__["last_updated_date_time"] = None
            __props__.__dict__["state_last_updated_date_time"] = None
            __props__.__dict__["trust_state"] = None
            __props__.__dict__["trust_state_reason"] = None
        super(Trust, __self__).__init__(
            'aws:directoryservice/trust:Trust',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            conditional_forwarder_ip_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            created_date_time: Optional[pulumi.Input[_builtins.str]] = None,
            delete_associated_conditional_forwarder: Optional[pulumi.Input[_builtins.bool]] = None,
            directory_id: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_date_time: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            remote_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            selective_auth: Optional[pulumi.Input[_builtins.str]] = None,
            state_last_updated_date_time: Optional[pulumi.Input[_builtins.str]] = None,
            trust_direction: Optional[pulumi.Input[_builtins.str]] = None,
            trust_password: Optional[pulumi.Input[_builtins.str]] = None,
            trust_state: Optional[pulumi.Input[_builtins.str]] = None,
            trust_state_reason: Optional[pulumi.Input[_builtins.str]] = None,
            trust_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Trust':
        """
        Get an existing Trust resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] conditional_forwarder_ip_addrs: Set of IPv4 addresses for the DNS server associated with the remote Directory.
               Can contain between 1 and 4 values.
        :param pulumi.Input[_builtins.str] created_date_time: Date and time when the Trust was created.
        :param pulumi.Input[_builtins.bool] delete_associated_conditional_forwarder: Whether to delete the conditional forwarder when deleting the Trust relationship.
        :param pulumi.Input[_builtins.str] directory_id: ID of the Directory.
        :param pulumi.Input[_builtins.str] last_updated_date_time: Date and time when the Trust was last updated.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] remote_domain_name: Fully qualified domain name of the remote Directory.
        :param pulumi.Input[_builtins.str] selective_auth: Whether to enable selective authentication.
               Valid values are `Enabled` and `Disabled`.
               Default value is `Disabled`.
        :param pulumi.Input[_builtins.str] state_last_updated_date_time: Date and time when the Trust state in `trust_state` was last updated.
        :param pulumi.Input[_builtins.str] trust_direction: The direction of the Trust relationship.
               Valid values are `One-Way: Outgoing`, `One-Way: Incoming`, and `Two-Way`.
        :param pulumi.Input[_builtins.str] trust_password: Password for the Trust.
               Does not need to match the passwords for either Directory.
               Can contain upper- and lower-case letters, numbers, and punctuation characters.
               May be up to 128 characters long.
        :param pulumi.Input[_builtins.str] trust_state: State of the Trust relationship.
               One of `Created`, `VerifyFailed`,`Verified`, `UpdateFailed`,`Updated`,`Deleted`, or `Failed`.
        :param pulumi.Input[_builtins.str] trust_state_reason: Reason for the Trust state set in `trust_state`.
        :param pulumi.Input[_builtins.str] trust_type: Type of the Trust relationship.
               Valid values are `Forest` and `External`.
               Default value is `Forest`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrustState.__new__(_TrustState)

        __props__.__dict__["conditional_forwarder_ip_addrs"] = conditional_forwarder_ip_addrs
        __props__.__dict__["created_date_time"] = created_date_time
        __props__.__dict__["delete_associated_conditional_forwarder"] = delete_associated_conditional_forwarder
        __props__.__dict__["directory_id"] = directory_id
        __props__.__dict__["last_updated_date_time"] = last_updated_date_time
        __props__.__dict__["region"] = region
        __props__.__dict__["remote_domain_name"] = remote_domain_name
        __props__.__dict__["selective_auth"] = selective_auth
        __props__.__dict__["state_last_updated_date_time"] = state_last_updated_date_time
        __props__.__dict__["trust_direction"] = trust_direction
        __props__.__dict__["trust_password"] = trust_password
        __props__.__dict__["trust_state"] = trust_state
        __props__.__dict__["trust_state_reason"] = trust_state_reason
        __props__.__dict__["trust_type"] = trust_type
        return Trust(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="conditionalForwarderIpAddrs")
    def conditional_forwarder_ip_addrs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of IPv4 addresses for the DNS server associated with the remote Directory.
        Can contain between 1 and 4 values.
        """
        return pulumi.get(self, "conditional_forwarder_ip_addrs")

    @_builtins.property
    @pulumi.getter(name="createdDateTime")
    def created_date_time(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time when the Trust was created.
        """
        return pulumi.get(self, "created_date_time")

    @_builtins.property
    @pulumi.getter(name="deleteAssociatedConditionalForwarder")
    def delete_associated_conditional_forwarder(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to delete the conditional forwarder when deleting the Trust relationship.
        """
        return pulumi.get(self, "delete_associated_conditional_forwarder")

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedDateTime")
    def last_updated_date_time(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time when the Trust was last updated.
        """
        return pulumi.get(self, "last_updated_date_time")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="remoteDomainName")
    def remote_domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified domain name of the remote Directory.
        """
        return pulumi.get(self, "remote_domain_name")

    @_builtins.property
    @pulumi.getter(name="selectiveAuth")
    def selective_auth(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to enable selective authentication.
        Valid values are `Enabled` and `Disabled`.
        Default value is `Disabled`.
        """
        return pulumi.get(self, "selective_auth")

    @_builtins.property
    @pulumi.getter(name="stateLastUpdatedDateTime")
    def state_last_updated_date_time(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time when the Trust state in `trust_state` was last updated.
        """
        return pulumi.get(self, "state_last_updated_date_time")

    @_builtins.property
    @pulumi.getter(name="trustDirection")
    def trust_direction(self) -> pulumi.Output[_builtins.str]:
        """
        The direction of the Trust relationship.
        Valid values are `One-Way: Outgoing`, `One-Way: Incoming`, and `Two-Way`.
        """
        return pulumi.get(self, "trust_direction")

    @_builtins.property
    @pulumi.getter(name="trustPassword")
    def trust_password(self) -> pulumi.Output[_builtins.str]:
        """
        Password for the Trust.
        Does not need to match the passwords for either Directory.
        Can contain upper- and lower-case letters, numbers, and punctuation characters.
        May be up to 128 characters long.
        """
        return pulumi.get(self, "trust_password")

    @_builtins.property
    @pulumi.getter(name="trustState")
    def trust_state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the Trust relationship.
        One of `Created`, `VerifyFailed`,`Verified`, `UpdateFailed`,`Updated`,`Deleted`, or `Failed`.
        """
        return pulumi.get(self, "trust_state")

    @_builtins.property
    @pulumi.getter(name="trustStateReason")
    def trust_state_reason(self) -> pulumi.Output[_builtins.str]:
        """
        Reason for the Trust state set in `trust_state`.
        """
        return pulumi.get(self, "trust_state_reason")

    @_builtins.property
    @pulumi.getter(name="trustType")
    def trust_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the Trust relationship.
        Valid values are `Forest` and `External`.
        Default value is `Forest`.
        """
        return pulumi.get(self, "trust_type")

