# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'LifecyclePolicyPolicyDetails',
    'LifecyclePolicyPolicyDetailsAction',
    'LifecyclePolicyPolicyDetailsActionCrossRegionCopy',
    'LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration',
    'LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRule',
    'LifecyclePolicyPolicyDetailsEventSource',
    'LifecyclePolicyPolicyDetailsEventSourceParameters',
    'LifecyclePolicyPolicyDetailsExclusions',
    'LifecyclePolicyPolicyDetailsParameters',
    'LifecyclePolicyPolicyDetailsSchedule',
    'LifecyclePolicyPolicyDetailsScheduleArchiveRule',
    'LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRule',
    'LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRuleRetentionArchiveTier',
    'LifecyclePolicyPolicyDetailsScheduleCreateRule',
    'LifecyclePolicyPolicyDetailsScheduleCreateRuleScripts',
    'LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule',
    'LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule',
    'LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule',
    'LifecyclePolicyPolicyDetailsScheduleDeprecateRule',
    'LifecyclePolicyPolicyDetailsScheduleFastRestoreRule',
    'LifecyclePolicyPolicyDetailsScheduleRetainRule',
    'LifecyclePolicyPolicyDetailsScheduleShareRule',
]

@pulumi.output_type
class LifecyclePolicyPolicyDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyTags":
            suggest = "copy_tags"
        elif key == "createInterval":
            suggest = "create_interval"
        elif key == "eventSource":
            suggest = "event_source"
        elif key == "extendDeletion":
            suggest = "extend_deletion"
        elif key == "policyLanguage":
            suggest = "policy_language"
        elif key == "policyType":
            suggest = "policy_type"
        elif key == "resourceLocations":
            suggest = "resource_locations"
        elif key == "resourceType":
            suggest = "resource_type"
        elif key == "resourceTypes":
            suggest = "resource_types"
        elif key == "retainInterval":
            suggest = "retain_interval"
        elif key == "targetTags":
            suggest = "target_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional['outputs.LifecyclePolicyPolicyDetailsAction'] = None,
                 copy_tags: Optional[_builtins.bool] = None,
                 create_interval: Optional[_builtins.int] = None,
                 event_source: Optional['outputs.LifecyclePolicyPolicyDetailsEventSource'] = None,
                 exclusions: Optional['outputs.LifecyclePolicyPolicyDetailsExclusions'] = None,
                 extend_deletion: Optional[_builtins.bool] = None,
                 parameters: Optional['outputs.LifecyclePolicyPolicyDetailsParameters'] = None,
                 policy_language: Optional[_builtins.str] = None,
                 policy_type: Optional[_builtins.str] = None,
                 resource_locations: Optional[_builtins.str] = None,
                 resource_type: Optional[_builtins.str] = None,
                 resource_types: Optional[Sequence[_builtins.str]] = None,
                 retain_interval: Optional[_builtins.int] = None,
                 schedules: Optional[Sequence['outputs.LifecyclePolicyPolicyDetailsSchedule']] = None,
                 target_tags: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param 'LifecyclePolicyPolicyDetailsActionArgs' action: The actions to be performed when the event-based policy is triggered. You can specify only one action per policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `action` configuration block.
        :param _builtins.int create_interval: How often the policy should run and create snapshots or AMIs. valid values range from `1` to `7`. Default value is `1`.
        :param 'LifecyclePolicyPolicyDetailsEventSourceArgs' event_source: The event that triggers the event-based policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `event_source` configuration block.
        :param 'LifecyclePolicyPolicyDetailsExclusionsArgs' exclusions: Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs.  See the `exclusions` configuration block.
        :param _builtins.bool extend_deletion: snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state. Default value is `false`.
        :param _builtins.str policy_language: Type of policy to create. `SIMPLIFIED` To create a default policy. `STANDARD` To create a custom policy.
        :param _builtins.str policy_type: The valid target resource types and actions a policy can manage. Specify `EBS_SNAPSHOT_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify `IMAGE_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify `EVENT_BASED_POLICY` to create an event-based policy that performs specific actions when a defined event occurs in your AWS account. Default value is `EBS_SNAPSHOT_MANAGEMENT`.
        :param _builtins.str resource_locations: The location of the resources to backup. If the source resources are located in an AWS Region, specify `CLOUD`. If the source resources are located on an Outpost in your account, specify `OUTPOST`. If the source resources are located in a Local Zone, specify `LOCAL_ZONE`. Valid values are `CLOUD`, `LOCAL_ZONE`, and `OUTPOST`.
        :param _builtins.str resource_type: Type of default policy to create. Valid values are `VOLUME` and `INSTANCE`.
        :param Sequence[_builtins.str] resource_types: A list of resource types that should be targeted by the lifecycle policy. Valid values are `VOLUME` and `INSTANCE`.
        :param _builtins.int retain_interval: Specifies how long the policy should retain snapshots or AMIs before deleting them. valid values range from `2` to `14`. Default value is `7`.
        :param Sequence['LifecyclePolicyPolicyDetailsScheduleArgs'] schedules: See the `schedule` configuration block.
        :param Mapping[str, _builtins.str] target_tags: A map of tag keys and their values. Any resources that match the `resource_types` and are tagged with _any_ of these tags will be targeted. Required when `policy_type` is `EBS_SNAPSHOT_MANAGEMENT` or `IMAGE_MANAGEMENT`. Must not be specified when `policy_type` is `EVENT_BASED_POLICY`.
               
               > Note: You cannot have overlapping lifecycle policies that share the same `target_tags`. Pulumi is unable to detect this at plan time but it will fail during apply.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if copy_tags is not None:
            pulumi.set(__self__, "copy_tags", copy_tags)
        if create_interval is not None:
            pulumi.set(__self__, "create_interval", create_interval)
        if event_source is not None:
            pulumi.set(__self__, "event_source", event_source)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if extend_deletion is not None:
            pulumi.set(__self__, "extend_deletion", extend_deletion)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if policy_language is not None:
            pulumi.set(__self__, "policy_language", policy_language)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if resource_locations is not None:
            pulumi.set(__self__, "resource_locations", resource_locations)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)
        if retain_interval is not None:
            pulumi.set(__self__, "retain_interval", retain_interval)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)
        if target_tags is not None:
            pulumi.set(__self__, "target_tags", target_tags)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsAction']:
        """
        The actions to be performed when the event-based policy is triggered. You can specify only one action per policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `action` configuration block.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="copyTags")
    def copy_tags(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "copy_tags")

    @_builtins.property
    @pulumi.getter(name="createInterval")
    def create_interval(self) -> Optional[_builtins.int]:
        """
        How often the policy should run and create snapshots or AMIs. valid values range from `1` to `7`. Default value is `1`.
        """
        return pulumi.get(self, "create_interval")

    @_builtins.property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsEventSource']:
        """
        The event that triggers the event-based policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `event_source` configuration block.
        """
        return pulumi.get(self, "event_source")

    @_builtins.property
    @pulumi.getter
    def exclusions(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsExclusions']:
        """
        Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs.  See the `exclusions` configuration block.
        """
        return pulumi.get(self, "exclusions")

    @_builtins.property
    @pulumi.getter(name="extendDeletion")
    def extend_deletion(self) -> Optional[_builtins.bool]:
        """
        snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state. Default value is `false`.
        """
        return pulumi.get(self, "extend_deletion")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsParameters']:
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="policyLanguage")
    def policy_language(self) -> Optional[_builtins.str]:
        """
        Type of policy to create. `SIMPLIFIED` To create a default policy. `STANDARD` To create a custom policy.
        """
        return pulumi.get(self, "policy_language")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[_builtins.str]:
        """
        The valid target resource types and actions a policy can manage. Specify `EBS_SNAPSHOT_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify `IMAGE_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify `EVENT_BASED_POLICY` to create an event-based policy that performs specific actions when a defined event occurs in your AWS account. Default value is `EBS_SNAPSHOT_MANAGEMENT`.
        """
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter(name="resourceLocations")
    def resource_locations(self) -> Optional[_builtins.str]:
        """
        The location of the resources to backup. If the source resources are located in an AWS Region, specify `CLOUD`. If the source resources are located on an Outpost in your account, specify `OUTPOST`. If the source resources are located in a Local Zone, specify `LOCAL_ZONE`. Valid values are `CLOUD`, `LOCAL_ZONE`, and `OUTPOST`.
        """
        return pulumi.get(self, "resource_locations")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        Type of default policy to create. Valid values are `VOLUME` and `INSTANCE`.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of resource types that should be targeted by the lifecycle policy. Valid values are `VOLUME` and `INSTANCE`.
        """
        return pulumi.get(self, "resource_types")

    @_builtins.property
    @pulumi.getter(name="retainInterval")
    def retain_interval(self) -> Optional[_builtins.int]:
        """
        Specifies how long the policy should retain snapshots or AMIs before deleting them. valid values range from `2` to `14`. Default value is `7`.
        """
        return pulumi.get(self, "retain_interval")

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> Optional[Sequence['outputs.LifecyclePolicyPolicyDetailsSchedule']]:
        """
        See the `schedule` configuration block.
        """
        return pulumi.get(self, "schedules")

    @_builtins.property
    @pulumi.getter(name="targetTags")
    def target_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of tag keys and their values. Any resources that match the `resource_types` and are tagged with _any_ of these tags will be targeted. Required when `policy_type` is `EBS_SNAPSHOT_MANAGEMENT` or `IMAGE_MANAGEMENT`. Must not be specified when `policy_type` is `EVENT_BASED_POLICY`.

        > Note: You cannot have overlapping lifecycle policies that share the same `target_tags`. Pulumi is unable to detect this at plan time but it will fail during apply.
        """
        return pulumi.get(self, "target_tags")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crossRegionCopies":
            suggest = "cross_region_copies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cross_region_copies: Sequence['outputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopy'],
                 name: _builtins.str):
        """
        :param Sequence['LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs'] cross_region_copies: The rule for copying shared snapshots across Regions. See the `cross_region_copy` configuration block.
        """
        pulumi.set(__self__, "cross_region_copies", cross_region_copies)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="crossRegionCopies")
    def cross_region_copies(self) -> Sequence['outputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopy']:
        """
        The rule for copying shared snapshots across Regions. See the `cross_region_copy` configuration block.
        """
        return pulumi.get(self, "cross_region_copies")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsActionCrossRegionCopy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionConfiguration":
            suggest = "encryption_configuration"
        elif key == "retainRule":
            suggest = "retain_rule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsActionCrossRegionCopy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsActionCrossRegionCopy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsActionCrossRegionCopy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_configuration: 'outputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration',
                 target: _builtins.str,
                 retain_rule: Optional['outputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRule'] = None):
        """
        :param 'LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfigurationArgs' encryption_configuration: The encryption settings for the copied snapshot. See the `encryption_configuration` block. Max of 1 per action.
        """
        pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        pulumi.set(__self__, "target", target)
        if retain_rule is not None:
            pulumi.set(__self__, "retain_rule", retain_rule)

    @_builtins.property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> 'outputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration':
        """
        The encryption settings for the copied snapshot. See the `encryption_configuration` block. Max of 1 per action.
        """
        return pulumi.get(self, "encryption_configuration")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="retainRule")
    def retain_rule(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRule']:
        return pulumi.get(self, "retain_rule")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cmkArn":
            suggest = "cmk_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cmk_arn: Optional[_builtins.str] = None,
                 encrypted: Optional[_builtins.bool] = None):
        if cmk_arn is not None:
            pulumi.set(__self__, "cmk_arn", cmk_arn)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)

    @_builtins.property
    @pulumi.getter(name="cmkArn")
    def cmk_arn(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "cmk_arn")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "encrypted")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalUnit":
            suggest = "interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval: _builtins.int,
                 interval_unit: _builtins.str):
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "interval_unit", interval_unit)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.int:
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="intervalUnit")
    def interval_unit(self) -> _builtins.str:
        return pulumi.get(self, "interval_unit")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsEventSource(dict):
    def __init__(__self__, *,
                 parameters: 'outputs.LifecyclePolicyPolicyDetailsEventSourceParameters',
                 type: _builtins.str):
        """
        :param _builtins.str type: The source of the event. Currently only managed CloudWatch Events rules are supported. Valid values are `MANAGED_CWE`.
        """
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> 'outputs.LifecyclePolicyPolicyDetailsEventSourceParameters':
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The source of the event. Currently only managed CloudWatch Events rules are supported. Valid values are `MANAGED_CWE`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsEventSourceParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "descriptionRegex":
            suggest = "description_regex"
        elif key == "eventType":
            suggest = "event_type"
        elif key == "snapshotOwners":
            suggest = "snapshot_owners"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsEventSourceParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsEventSourceParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsEventSourceParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description_regex: _builtins.str,
                 event_type: _builtins.str,
                 snapshot_owners: Sequence[_builtins.str]):
        """
        :param _builtins.str description_regex: The snapshot description that can trigger the policy. The description pattern is specified using a regular expression. The policy runs only if a snapshot with a description that matches the specified pattern is shared with your account.
        :param _builtins.str event_type: The type of event. Currently, only `shareSnapshot` events are supported.
        :param Sequence[_builtins.str] snapshot_owners: The IDs of the AWS accounts that can trigger policy by sharing snapshots with your account. The policy only runs if one of the specified AWS accounts shares a snapshot with your account.
        """
        pulumi.set(__self__, "description_regex", description_regex)
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "snapshot_owners", snapshot_owners)

    @_builtins.property
    @pulumi.getter(name="descriptionRegex")
    def description_regex(self) -> _builtins.str:
        """
        The snapshot description that can trigger the policy. The description pattern is specified using a regular expression. The policy runs only if a snapshot with a description that matches the specified pattern is shared with your account.
        """
        return pulumi.get(self, "description_regex")

    @_builtins.property
    @pulumi.getter(name="eventType")
    def event_type(self) -> _builtins.str:
        """
        The type of event. Currently, only `shareSnapshot` events are supported.
        """
        return pulumi.get(self, "event_type")

    @_builtins.property
    @pulumi.getter(name="snapshotOwners")
    def snapshot_owners(self) -> Sequence[_builtins.str]:
        """
        The IDs of the AWS accounts that can trigger policy by sharing snapshots with your account. The policy only runs if one of the specified AWS accounts shares a snapshot with your account.
        """
        return pulumi.get(self, "snapshot_owners")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsExclusions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeBootVolumes":
            suggest = "exclude_boot_volumes"
        elif key == "excludeTags":
            suggest = "exclude_tags"
        elif key == "excludeVolumeTypes":
            suggest = "exclude_volume_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsExclusions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsExclusions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsExclusions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_boot_volumes: Optional[_builtins.bool] = None,
                 exclude_tags: Optional[Mapping[str, _builtins.str]] = None,
                 exclude_volume_types: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool exclude_boot_volumes: Indicates whether to exclude volumes that are attached to instances as the boot volume. To exclude boot volumes, specify `true`.
        :param Mapping[str, _builtins.str] exclude_tags: Map specifies whether to exclude volumes that have specific tags.
        :param Sequence[_builtins.str] exclude_volume_types: List specifies the volume types to exclude.
        """
        if exclude_boot_volumes is not None:
            pulumi.set(__self__, "exclude_boot_volumes", exclude_boot_volumes)
        if exclude_tags is not None:
            pulumi.set(__self__, "exclude_tags", exclude_tags)
        if exclude_volume_types is not None:
            pulumi.set(__self__, "exclude_volume_types", exclude_volume_types)

    @_builtins.property
    @pulumi.getter(name="excludeBootVolumes")
    def exclude_boot_volumes(self) -> Optional[_builtins.bool]:
        """
        Indicates whether to exclude volumes that are attached to instances as the boot volume. To exclude boot volumes, specify `true`.
        """
        return pulumi.get(self, "exclude_boot_volumes")

    @_builtins.property
    @pulumi.getter(name="excludeTags")
    def exclude_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Map specifies whether to exclude volumes that have specific tags.
        """
        return pulumi.get(self, "exclude_tags")

    @_builtins.property
    @pulumi.getter(name="excludeVolumeTypes")
    def exclude_volume_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        List specifies the volume types to exclude.
        """
        return pulumi.get(self, "exclude_volume_types")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeBootVolume":
            suggest = "exclude_boot_volume"
        elif key == "noReboot":
            suggest = "no_reboot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_boot_volume: Optional[_builtins.bool] = None,
                 no_reboot: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool exclude_boot_volume: Indicates whether to exclude the root volume from snapshots created using CreateSnapshots. The default is `false`.
        :param _builtins.bool no_reboot: Applies to AMI lifecycle policies only. Indicates whether targeted instances are rebooted when the lifecycle policy runs. `true` indicates that targeted instances are not rebooted when the policy runs. `false` indicates that target instances are rebooted when the policy runs. The default is `true` (instances are not rebooted).
        """
        if exclude_boot_volume is not None:
            pulumi.set(__self__, "exclude_boot_volume", exclude_boot_volume)
        if no_reboot is not None:
            pulumi.set(__self__, "no_reboot", no_reboot)

    @_builtins.property
    @pulumi.getter(name="excludeBootVolume")
    def exclude_boot_volume(self) -> Optional[_builtins.bool]:
        """
        Indicates whether to exclude the root volume from snapshots created using CreateSnapshots. The default is `false`.
        """
        return pulumi.get(self, "exclude_boot_volume")

    @_builtins.property
    @pulumi.getter(name="noReboot")
    def no_reboot(self) -> Optional[_builtins.bool]:
        """
        Applies to AMI lifecycle policies only. Indicates whether targeted instances are rebooted when the lifecycle policy runs. `true` indicates that targeted instances are not rebooted when the policy runs. `false` indicates that target instances are rebooted when the policy runs. The default is `true` (instances are not rebooted).
        """
        return pulumi.get(self, "no_reboot")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createRule":
            suggest = "create_rule"
        elif key == "retainRule":
            suggest = "retain_rule"
        elif key == "archiveRule":
            suggest = "archive_rule"
        elif key == "copyTags":
            suggest = "copy_tags"
        elif key == "crossRegionCopyRules":
            suggest = "cross_region_copy_rules"
        elif key == "deprecateRule":
            suggest = "deprecate_rule"
        elif key == "fastRestoreRule":
            suggest = "fast_restore_rule"
        elif key == "shareRule":
            suggest = "share_rule"
        elif key == "tagsToAdd":
            suggest = "tags_to_add"
        elif key == "variableTags":
            suggest = "variable_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_rule: 'outputs.LifecyclePolicyPolicyDetailsScheduleCreateRule',
                 name: _builtins.str,
                 retain_rule: 'outputs.LifecyclePolicyPolicyDetailsScheduleRetainRule',
                 archive_rule: Optional['outputs.LifecyclePolicyPolicyDetailsScheduleArchiveRule'] = None,
                 copy_tags: Optional[_builtins.bool] = None,
                 cross_region_copy_rules: Optional[Sequence['outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule']] = None,
                 deprecate_rule: Optional['outputs.LifecyclePolicyPolicyDetailsScheduleDeprecateRule'] = None,
                 fast_restore_rule: Optional['outputs.LifecyclePolicyPolicyDetailsScheduleFastRestoreRule'] = None,
                 share_rule: Optional['outputs.LifecyclePolicyPolicyDetailsScheduleShareRule'] = None,
                 tags_to_add: Optional[Mapping[str, _builtins.str]] = None,
                 variable_tags: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param 'LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs' create_rule: See the `create_rule` block. Max of 1 per schedule.
        :param 'LifecyclePolicyPolicyDetailsScheduleArchiveRuleArgs' archive_rule: Specifies a snapshot archiving rule for a schedule. See `archive_rule` block.
        :param Sequence['LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs'] cross_region_copy_rules: See the `cross_region_copy_rule` block. Max of 3 per schedule.
        :param 'LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs' fast_restore_rule: See the `fast_restore_rule` block. Max of 1 per schedule.
        :param 'LifecyclePolicyPolicyDetailsScheduleShareRuleArgs' share_rule: See the `share_rule` block. Max of 1 per schedule.
        :param Mapping[str, _builtins.str] tags_to_add: A map of tag keys and their values. DLM lifecycle policies will already tag the snapshot with the tags on the volume. This configuration adds extra tags on top of these.
        :param Mapping[str, _builtins.str] variable_tags: A map of tag keys and variable values, where the values are determined when the policy is executed. Only `$(instance-id)` or `$(timestamp)` are valid values. Can only be used when `resource_types` is `INSTANCE`.
        """
        pulumi.set(__self__, "create_rule", create_rule)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "retain_rule", retain_rule)
        if archive_rule is not None:
            pulumi.set(__self__, "archive_rule", archive_rule)
        if copy_tags is not None:
            pulumi.set(__self__, "copy_tags", copy_tags)
        if cross_region_copy_rules is not None:
            pulumi.set(__self__, "cross_region_copy_rules", cross_region_copy_rules)
        if deprecate_rule is not None:
            pulumi.set(__self__, "deprecate_rule", deprecate_rule)
        if fast_restore_rule is not None:
            pulumi.set(__self__, "fast_restore_rule", fast_restore_rule)
        if share_rule is not None:
            pulumi.set(__self__, "share_rule", share_rule)
        if tags_to_add is not None:
            pulumi.set(__self__, "tags_to_add", tags_to_add)
        if variable_tags is not None:
            pulumi.set(__self__, "variable_tags", variable_tags)

    @_builtins.property
    @pulumi.getter(name="createRule")
    def create_rule(self) -> 'outputs.LifecyclePolicyPolicyDetailsScheduleCreateRule':
        """
        See the `create_rule` block. Max of 1 per schedule.
        """
        return pulumi.get(self, "create_rule")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="retainRule")
    def retain_rule(self) -> 'outputs.LifecyclePolicyPolicyDetailsScheduleRetainRule':
        return pulumi.get(self, "retain_rule")

    @_builtins.property
    @pulumi.getter(name="archiveRule")
    def archive_rule(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsScheduleArchiveRule']:
        """
        Specifies a snapshot archiving rule for a schedule. See `archive_rule` block.
        """
        return pulumi.get(self, "archive_rule")

    @_builtins.property
    @pulumi.getter(name="copyTags")
    def copy_tags(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "copy_tags")

    @_builtins.property
    @pulumi.getter(name="crossRegionCopyRules")
    def cross_region_copy_rules(self) -> Optional[Sequence['outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule']]:
        """
        See the `cross_region_copy_rule` block. Max of 3 per schedule.
        """
        return pulumi.get(self, "cross_region_copy_rules")

    @_builtins.property
    @pulumi.getter(name="deprecateRule")
    def deprecate_rule(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsScheduleDeprecateRule']:
        return pulumi.get(self, "deprecate_rule")

    @_builtins.property
    @pulumi.getter(name="fastRestoreRule")
    def fast_restore_rule(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsScheduleFastRestoreRule']:
        """
        See the `fast_restore_rule` block. Max of 1 per schedule.
        """
        return pulumi.get(self, "fast_restore_rule")

    @_builtins.property
    @pulumi.getter(name="shareRule")
    def share_rule(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsScheduleShareRule']:
        """
        See the `share_rule` block. Max of 1 per schedule.
        """
        return pulumi.get(self, "share_rule")

    @_builtins.property
    @pulumi.getter(name="tagsToAdd")
    def tags_to_add(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of tag keys and their values. DLM lifecycle policies will already tag the snapshot with the tags on the volume. This configuration adds extra tags on top of these.
        """
        return pulumi.get(self, "tags_to_add")

    @_builtins.property
    @pulumi.getter(name="variableTags")
    def variable_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of tag keys and variable values, where the values are determined when the policy is executed. Only `$(instance-id)` or `$(timestamp)` are valid values. Can only be used when `resource_types` is `INSTANCE`.
        """
        return pulumi.get(self, "variable_tags")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleArchiveRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveRetainRule":
            suggest = "archive_retain_rule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleArchiveRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleArchiveRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleArchiveRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_retain_rule: 'outputs.LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRule'):
        """
        :param 'LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRuleArgs' archive_retain_rule: Information about the retention period for the snapshot archiving rule. See the `archive_retain_rule` block.
        """
        pulumi.set(__self__, "archive_retain_rule", archive_retain_rule)

    @_builtins.property
    @pulumi.getter(name="archiveRetainRule")
    def archive_retain_rule(self) -> 'outputs.LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRule':
        """
        Information about the retention period for the snapshot archiving rule. See the `archive_retain_rule` block.
        """
        return pulumi.get(self, "archive_retain_rule")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionArchiveTier":
            suggest = "retention_archive_tier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_archive_tier: 'outputs.LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRuleRetentionArchiveTier'):
        """
        :param 'LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRuleRetentionArchiveTierArgs' retention_archive_tier: Information about retention period in the Amazon EBS Snapshots Archive. See the `retention_archive_tier` block.
        """
        pulumi.set(__self__, "retention_archive_tier", retention_archive_tier)

    @_builtins.property
    @pulumi.getter(name="retentionArchiveTier")
    def retention_archive_tier(self) -> 'outputs.LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRuleRetentionArchiveTier':
        """
        Information about retention period in the Amazon EBS Snapshots Archive. See the `retention_archive_tier` block.
        """
        return pulumi.get(self, "retention_archive_tier")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRuleRetentionArchiveTier(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalUnit":
            suggest = "interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRuleRetentionArchiveTier. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRuleRetentionArchiveTier.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleArchiveRuleArchiveRetainRuleRetentionArchiveTier.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[_builtins.int] = None,
                 interval: Optional[_builtins.int] = None,
                 interval_unit: Optional[_builtins.str] = None):
        if count is not None:
            pulumi.set(__self__, "count", count)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if interval_unit is not None:
            pulumi.set(__self__, "interval_unit", interval_unit)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="intervalUnit")
    def interval_unit(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "interval_unit")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleCreateRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpression":
            suggest = "cron_expression"
        elif key == "intervalUnit":
            suggest = "interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleCreateRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCreateRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCreateRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_expression: Optional[_builtins.str] = None,
                 interval: Optional[_builtins.int] = None,
                 interval_unit: Optional[_builtins.str] = None,
                 location: Optional[_builtins.str] = None,
                 scripts: Optional['outputs.LifecyclePolicyPolicyDetailsScheduleCreateRuleScripts'] = None,
                 times: Optional[_builtins.str] = None):
        """
        :param _builtins.str cron_expression: The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1 year. Conflicts with `interval`, `interval_unit`, and `times`.
        :param _builtins.str location: Specifies the destination for snapshots created by the policy. To create snapshots in the same Region as the source resource, specify `CLOUD`. To create snapshots on the same Outpost as the source resource, specify `OUTPOST_LOCAL`. If you omit this parameter, `CLOUD` is used by default. If the policy targets resources in an AWS Region, then you must create snapshots in the same Region as the source resource. If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the source resource, or in the Region of that Outpost. Valid values are `CLOUD` and `OUTPOST_LOCAL`.
        :param 'LifecyclePolicyPolicyDetailsScheduleCreateRuleScriptsArgs' scripts: Specifies pre and/or post scripts for a snapshot lifecycle policy that targets instances. Valid only when `resource_type` is INSTANCE. See the `scripts` configuration block.
        :param _builtins.str times: A list of times in 24 hour clock format that sets when the lifecycle policy should be evaluated. Max of 1. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        if cron_expression is not None:
            pulumi.set(__self__, "cron_expression", cron_expression)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if interval_unit is not None:
            pulumi.set(__self__, "interval_unit", interval_unit)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if scripts is not None:
            pulumi.set(__self__, "scripts", scripts)
        if times is not None:
            pulumi.set(__self__, "times", times)

    @_builtins.property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> Optional[_builtins.str]:
        """
        The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1 year. Conflicts with `interval`, `interval_unit`, and `times`.
        """
        return pulumi.get(self, "cron_expression")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="intervalUnit")
    def interval_unit(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "interval_unit")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        Specifies the destination for snapshots created by the policy. To create snapshots in the same Region as the source resource, specify `CLOUD`. To create snapshots on the same Outpost as the source resource, specify `OUTPOST_LOCAL`. If you omit this parameter, `CLOUD` is used by default. If the policy targets resources in an AWS Region, then you must create snapshots in the same Region as the source resource. If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the source resource, or in the Region of that Outpost. Valid values are `CLOUD` and `OUTPOST_LOCAL`.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def scripts(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsScheduleCreateRuleScripts']:
        """
        Specifies pre and/or post scripts for a snapshot lifecycle policy that targets instances. Valid only when `resource_type` is INSTANCE. See the `scripts` configuration block.
        """
        return pulumi.get(self, "scripts")

    @_builtins.property
    @pulumi.getter
    def times(self) -> Optional[_builtins.str]:
        """
        A list of times in 24 hour clock format that sets when the lifecycle policy should be evaluated. Max of 1. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        return pulumi.get(self, "times")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleCreateRuleScripts(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionHandler":
            suggest = "execution_handler"
        elif key == "executeOperationOnScriptFailure":
            suggest = "execute_operation_on_script_failure"
        elif key == "executionHandlerService":
            suggest = "execution_handler_service"
        elif key == "executionTimeout":
            suggest = "execution_timeout"
        elif key == "maximumRetryCount":
            suggest = "maximum_retry_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleCreateRuleScripts. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCreateRuleScripts.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCreateRuleScripts.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_handler: _builtins.str,
                 execute_operation_on_script_failure: Optional[_builtins.bool] = None,
                 execution_handler_service: Optional[_builtins.str] = None,
                 execution_timeout: Optional[_builtins.int] = None,
                 maximum_retry_count: Optional[_builtins.int] = None,
                 stages: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str execution_handler: The SSM document that includes the pre and/or post scripts to run. In case automating VSS backups, specify `AWS_VSS_BACKUP`. In case automating application-consistent snapshots for SAP HANA workloads, specify `AWSSystemsManagerSAP-CreateDLMSnapshotForSAPHANA`. If you are using a custom SSM document that you own, specify either the name or ARN of the SSM document.
        :param _builtins.bool execute_operation_on_script_failure: Indicates whether Amazon Data Lifecycle Manager should default to crash-consistent snapshots if the pre script fails. The default is `true`.
        :param _builtins.str execution_handler_service: Indicates the service used to execute the pre and/or post scripts. If using custom SSM documents or automating application-consistent snapshots of SAP HANA workloads, specify `AWS_SYSTEMS_MANAGER`. In case automating VSS Backups, omit this parameter. The default is `AWS_SYSTEMS_MANAGER`.
        :param _builtins.int execution_timeout: Specifies a timeout period, in seconds, after which Amazon Data Lifecycle Manager fails the script run attempt if it has not completed. In case automating VSS Backups, omit this parameter. The default is `10`.
        :param _builtins.int maximum_retry_count: Specifies the number of times Amazon Data Lifecycle Manager should retry scripts that fail. Must be an integer between `0` and `3`. The default is `0`.
        :param Sequence[_builtins.str] stages: List to indicate which scripts Amazon Data Lifecycle Manager should run on target instances. Pre scripts run before Amazon Data Lifecycle Manager initiates snapshot creation. Post scripts run after Amazon Data Lifecycle Manager initiates snapshot creation. Valid values: `PRE` and `POST`. The default is `PRE` and `POST`
        """
        pulumi.set(__self__, "execution_handler", execution_handler)
        if execute_operation_on_script_failure is not None:
            pulumi.set(__self__, "execute_operation_on_script_failure", execute_operation_on_script_failure)
        if execution_handler_service is not None:
            pulumi.set(__self__, "execution_handler_service", execution_handler_service)
        if execution_timeout is not None:
            pulumi.set(__self__, "execution_timeout", execution_timeout)
        if maximum_retry_count is not None:
            pulumi.set(__self__, "maximum_retry_count", maximum_retry_count)
        if stages is not None:
            pulumi.set(__self__, "stages", stages)

    @_builtins.property
    @pulumi.getter(name="executionHandler")
    def execution_handler(self) -> _builtins.str:
        """
        The SSM document that includes the pre and/or post scripts to run. In case automating VSS backups, specify `AWS_VSS_BACKUP`. In case automating application-consistent snapshots for SAP HANA workloads, specify `AWSSystemsManagerSAP-CreateDLMSnapshotForSAPHANA`. If you are using a custom SSM document that you own, specify either the name or ARN of the SSM document.
        """
        return pulumi.get(self, "execution_handler")

    @_builtins.property
    @pulumi.getter(name="executeOperationOnScriptFailure")
    def execute_operation_on_script_failure(self) -> Optional[_builtins.bool]:
        """
        Indicates whether Amazon Data Lifecycle Manager should default to crash-consistent snapshots if the pre script fails. The default is `true`.
        """
        return pulumi.get(self, "execute_operation_on_script_failure")

    @_builtins.property
    @pulumi.getter(name="executionHandlerService")
    def execution_handler_service(self) -> Optional[_builtins.str]:
        """
        Indicates the service used to execute the pre and/or post scripts. If using custom SSM documents or automating application-consistent snapshots of SAP HANA workloads, specify `AWS_SYSTEMS_MANAGER`. In case automating VSS Backups, omit this parameter. The default is `AWS_SYSTEMS_MANAGER`.
        """
        return pulumi.get(self, "execution_handler_service")

    @_builtins.property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> Optional[_builtins.int]:
        """
        Specifies a timeout period, in seconds, after which Amazon Data Lifecycle Manager fails the script run attempt if it has not completed. In case automating VSS Backups, omit this parameter. The default is `10`.
        """
        return pulumi.get(self, "execution_timeout")

    @_builtins.property
    @pulumi.getter(name="maximumRetryCount")
    def maximum_retry_count(self) -> Optional[_builtins.int]:
        """
        Specifies the number of times Amazon Data Lifecycle Manager should retry scripts that fail. Must be an integer between `0` and `3`. The default is `0`.
        """
        return pulumi.get(self, "maximum_retry_count")

    @_builtins.property
    @pulumi.getter
    def stages(self) -> Optional[Sequence[_builtins.str]]:
        """
        List to indicate which scripts Amazon Data Lifecycle Manager should run on target instances. Pre scripts run before Amazon Data Lifecycle Manager initiates snapshot creation. Post scripts run after Amazon Data Lifecycle Manager initiates snapshot creation. Valid values: `PRE` and `POST`. The default is `PRE` and `POST`
        """
        return pulumi.get(self, "stages")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cmkArn":
            suggest = "cmk_arn"
        elif key == "copyTags":
            suggest = "copy_tags"
        elif key == "deprecateRule":
            suggest = "deprecate_rule"
        elif key == "retainRule":
            suggest = "retain_rule"
        elif key == "targetRegion":
            suggest = "target_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encrypted: _builtins.bool,
                 cmk_arn: Optional[_builtins.str] = None,
                 copy_tags: Optional[_builtins.bool] = None,
                 deprecate_rule: Optional['outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule'] = None,
                 retain_rule: Optional['outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule'] = None,
                 target: Optional[_builtins.str] = None,
                 target_region: Optional[_builtins.str] = None):
        """
        :param _builtins.str target_region: Use only for DLM policies of `policy_type=IMAGE_MANAGEMENT`. The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
        """
        pulumi.set(__self__, "encrypted", encrypted)
        if cmk_arn is not None:
            pulumi.set(__self__, "cmk_arn", cmk_arn)
        if copy_tags is not None:
            pulumi.set(__self__, "copy_tags", copy_tags)
        if deprecate_rule is not None:
            pulumi.set(__self__, "deprecate_rule", deprecate_rule)
        if retain_rule is not None:
            pulumi.set(__self__, "retain_rule", retain_rule)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if target_region is not None:
            pulumi.set(__self__, "target_region", target_region)

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> _builtins.bool:
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter(name="cmkArn")
    def cmk_arn(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "cmk_arn")

    @_builtins.property
    @pulumi.getter(name="copyTags")
    def copy_tags(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "copy_tags")

    @_builtins.property
    @pulumi.getter(name="deprecateRule")
    def deprecate_rule(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule']:
        return pulumi.get(self, "deprecate_rule")

    @_builtins.property
    @pulumi.getter(name="retainRule")
    def retain_rule(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule']:
        return pulumi.get(self, "retain_rule")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="targetRegion")
    def target_region(self) -> Optional[_builtins.str]:
        """
        Use only for DLM policies of `policy_type=IMAGE_MANAGEMENT`. The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
        """
        return pulumi.get(self, "target_region")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalUnit":
            suggest = "interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval: _builtins.int,
                 interval_unit: _builtins.str):
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "interval_unit", interval_unit)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.int:
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="intervalUnit")
    def interval_unit(self) -> _builtins.str:
        return pulumi.get(self, "interval_unit")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalUnit":
            suggest = "interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval: _builtins.int,
                 interval_unit: _builtins.str):
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "interval_unit", interval_unit)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.int:
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="intervalUnit")
    def interval_unit(self) -> _builtins.str:
        return pulumi.get(self, "interval_unit")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleDeprecateRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalUnit":
            suggest = "interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleDeprecateRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleDeprecateRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleDeprecateRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[_builtins.int] = None,
                 interval: Optional[_builtins.int] = None,
                 interval_unit: Optional[_builtins.str] = None):
        if count is not None:
            pulumi.set(__self__, "count", count)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if interval_unit is not None:
            pulumi.set(__self__, "interval_unit", interval_unit)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="intervalUnit")
    def interval_unit(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "interval_unit")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleFastRestoreRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZones":
            suggest = "availability_zones"
        elif key == "intervalUnit":
            suggest = "interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleFastRestoreRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleFastRestoreRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleFastRestoreRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zones: Sequence[_builtins.str],
                 count: Optional[_builtins.int] = None,
                 interval: Optional[_builtins.int] = None,
                 interval_unit: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] availability_zones: The Availability Zones in which to enable fast snapshot restore.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if interval_unit is not None:
            pulumi.set(__self__, "interval_unit", interval_unit)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[_builtins.str]:
        """
        The Availability Zones in which to enable fast snapshot restore.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="intervalUnit")
    def interval_unit(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "interval_unit")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleRetainRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalUnit":
            suggest = "interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleRetainRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleRetainRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleRetainRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[_builtins.int] = None,
                 interval: Optional[_builtins.int] = None,
                 interval_unit: Optional[_builtins.str] = None):
        if count is not None:
            pulumi.set(__self__, "count", count)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if interval_unit is not None:
            pulumi.set(__self__, "interval_unit", interval_unit)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="intervalUnit")
    def interval_unit(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "interval_unit")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleShareRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetAccounts":
            suggest = "target_accounts"
        elif key == "unshareInterval":
            suggest = "unshare_interval"
        elif key == "unshareIntervalUnit":
            suggest = "unshare_interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleShareRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleShareRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleShareRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_accounts: Sequence[_builtins.str],
                 unshare_interval: Optional[_builtins.int] = None,
                 unshare_interval_unit: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] target_accounts: The IDs of the AWS accounts with which to share the snapshots.
        :param _builtins.int unshare_interval: The period after which snapshots that are shared with other AWS accounts are automatically unshared.
        :param _builtins.str unshare_interval_unit: The unit of time for the automatic unsharing interval. Valid values are `DAYS`, `WEEKS`, `MONTHS`, `YEARS`.
        """
        pulumi.set(__self__, "target_accounts", target_accounts)
        if unshare_interval is not None:
            pulumi.set(__self__, "unshare_interval", unshare_interval)
        if unshare_interval_unit is not None:
            pulumi.set(__self__, "unshare_interval_unit", unshare_interval_unit)

    @_builtins.property
    @pulumi.getter(name="targetAccounts")
    def target_accounts(self) -> Sequence[_builtins.str]:
        """
        The IDs of the AWS accounts with which to share the snapshots.
        """
        return pulumi.get(self, "target_accounts")

    @_builtins.property
    @pulumi.getter(name="unshareInterval")
    def unshare_interval(self) -> Optional[_builtins.int]:
        """
        The period after which snapshots that are shared with other AWS accounts are automatically unshared.
        """
        return pulumi.get(self, "unshare_interval")

    @_builtins.property
    @pulumi.getter(name="unshareIntervalUnit")
    def unshare_interval_unit(self) -> Optional[_builtins.str]:
        """
        The unit of time for the automatic unsharing interval. Valid values are `DAYS`, `WEEKS`, `MONTHS`, `YEARS`.
        """
        return pulumi.get(self, "unshare_interval_unit")


