# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'EndpointElasticsearchSettingsArgs',
    'EndpointElasticsearchSettingsArgsDict',
    'EndpointKafkaSettingsArgs',
    'EndpointKafkaSettingsArgsDict',
    'EndpointKinesisSettingsArgs',
    'EndpointKinesisSettingsArgsDict',
    'EndpointMongodbSettingsArgs',
    'EndpointMongodbSettingsArgsDict',
    'EndpointOracleSettingsArgs',
    'EndpointOracleSettingsArgsDict',
    'EndpointPostgresSettingsArgs',
    'EndpointPostgresSettingsArgsDict',
    'EndpointRedisSettingsArgs',
    'EndpointRedisSettingsArgsDict',
    'EndpointRedshiftSettingsArgs',
    'EndpointRedshiftSettingsArgsDict',
    'ReplicationConfigComputeConfigArgs',
    'ReplicationConfigComputeConfigArgsDict',
    'ReplicationInstanceKerberosAuthenticationSettingsArgs',
    'ReplicationInstanceKerberosAuthenticationSettingsArgsDict',
]

MYPY = False

if not MYPY:
    class EndpointElasticsearchSettingsArgsDict(TypedDict):
        endpoint_uri: pulumi.Input[_builtins.str]
        """
        Endpoint for the OpenSearch cluster.
        """
        service_access_role_arn: pulumi.Input[_builtins.str]
        """
        ARN of the IAM Role with permissions to write to the OpenSearch cluster.
        """
        error_retry_duration: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster. Default is `300`.
        """
        full_load_error_percentage: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum percentage of records that can fail to be written before a full load operation stops. Default is `10`.
        """
        use_new_mapping_type: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable to migrate documentation using the documentation type `_doc`. OpenSearch and an Elasticsearch clusters only support the _doc documentation type in versions 7.x and later. The default value is `false`.
        """
elif False:
    EndpointElasticsearchSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointElasticsearchSettingsArgs:
    def __init__(__self__, *,
                 endpoint_uri: pulumi.Input[_builtins.str],
                 service_access_role_arn: pulumi.Input[_builtins.str],
                 error_retry_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 full_load_error_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 use_new_mapping_type: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] endpoint_uri: Endpoint for the OpenSearch cluster.
        :param pulumi.Input[_builtins.str] service_access_role_arn: ARN of the IAM Role with permissions to write to the OpenSearch cluster.
        :param pulumi.Input[_builtins.int] error_retry_duration: Maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster. Default is `300`.
        :param pulumi.Input[_builtins.int] full_load_error_percentage: Maximum percentage of records that can fail to be written before a full load operation stops. Default is `10`.
        :param pulumi.Input[_builtins.bool] use_new_mapping_type: Enable to migrate documentation using the documentation type `_doc`. OpenSearch and an Elasticsearch clusters only support the _doc documentation type in versions 7.x and later. The default value is `false`.
        """
        pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        if error_retry_duration is not None:
            pulumi.set(__self__, "error_retry_duration", error_retry_duration)
        if full_load_error_percentage is not None:
            pulumi.set(__self__, "full_load_error_percentage", full_load_error_percentage)
        if use_new_mapping_type is not None:
            pulumi.set(__self__, "use_new_mapping_type", use_new_mapping_type)

    @_builtins.property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> pulumi.Input[_builtins.str]:
        """
        Endpoint for the OpenSearch cluster.
        """
        return pulumi.get(self, "endpoint_uri")

    @endpoint_uri.setter
    def endpoint_uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint_uri", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the IAM Role with permissions to write to the OpenSearch cluster.
        """
        return pulumi.get(self, "service_access_role_arn")

    @service_access_role_arn.setter
    def service_access_role_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_access_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="errorRetryDuration")
    def error_retry_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster. Default is `300`.
        """
        return pulumi.get(self, "error_retry_duration")

    @error_retry_duration.setter
    def error_retry_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "error_retry_duration", value)

    @_builtins.property
    @pulumi.getter(name="fullLoadErrorPercentage")
    def full_load_error_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum percentage of records that can fail to be written before a full load operation stops. Default is `10`.
        """
        return pulumi.get(self, "full_load_error_percentage")

    @full_load_error_percentage.setter
    def full_load_error_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "full_load_error_percentage", value)

    @_builtins.property
    @pulumi.getter(name="useNewMappingType")
    def use_new_mapping_type(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to migrate documentation using the documentation type `_doc`. OpenSearch and an Elasticsearch clusters only support the _doc documentation type in versions 7.x and later. The default value is `false`.
        """
        return pulumi.get(self, "use_new_mapping_type")

    @use_new_mapping_type.setter
    def use_new_mapping_type(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_new_mapping_type", value)


if not MYPY:
    class EndpointKafkaSettingsArgsDict(TypedDict):
        broker: pulumi.Input[_builtins.str]
        """
        Kafka broker location. Specify in the form broker-hostname-or-ip:port.
        """
        include_control_details: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output. Default is `false`.
        """
        include_null_and_empty: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Include NULL and empty columns for records migrated to the endpoint. Default is `false`.
        """
        include_partition_value: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Shows the partition value within the Kafka message output unless the partition type is `schema-table-type`. Default is `false`.
        """
        include_table_alter_operations: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table`, `drop-table`, `add-column`, `drop-column`, and `rename-column`. Default is `false`.
        """
        include_transaction_details: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Provides detailed transaction information from the source database. This information includes a commit timestamp, a log position, and values for `transaction_id`, previous `transaction_id`, and `transaction_record_id` (the record offset within a transaction). Default is `false`.
        """
        message_format: NotRequired[pulumi.Input[_builtins.str]]
        """
        Output format for the records created on the endpoint. Message format is `JSON` (default) or `JSON_UNFORMATTED` (a single line with no tab).
        """
        message_max_bytes: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum size in bytes for records created on the endpoint Default is `1,000,000`.
        """
        no_hex_prefix: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Set this optional parameter to true to avoid adding a '0x' prefix to raw data in hexadecimal format. For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the `no_hex_prefix` endpoint setting to enable migration of RAW data type columns without adding the `'0x'` prefix.
        """
        partition_include_schema_table: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Prefixes schema and table names to partition values, when the partition type is `primary-key-type`. Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. Default is `false`.
        """
        sasl_mechanism: NotRequired[pulumi.Input[_builtins.str]]
        """
        For SASL/SSL authentication, AWS DMS supports the `scram-sha-512` mechanism by default. AWS DMS versions 3.5.0 and later also support the PLAIN mechanism. To use the PLAIN mechanism, set this parameter to `plain`.
        """
        sasl_password: NotRequired[pulumi.Input[_builtins.str]]
        """
        Secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        """
        sasl_username: NotRequired[pulumi.Input[_builtins.str]]
        """
        Secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        """
        security_protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include `ssl-encryption`, `ssl-authentication`, and `sasl-ssl`. `sasl-ssl` requires `sasl_username` and `sasl_password`.
        """
        ssl_ca_certificate_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        ARN for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
        """
        ssl_client_certificate_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        ARN of the client certificate used to securely connect to a Kafka target endpoint.
        """
        ssl_client_key_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        ARN for the client private key used to securely connect to a Kafka target endpoint.
        """
        ssl_client_key_password: NotRequired[pulumi.Input[_builtins.str]]
        """
        Password for the client private key used to securely connect to a Kafka target endpoint.
        """
        topic: NotRequired[pulumi.Input[_builtins.str]]
        """
        Kafka topic for migration. Default is `kafka-default-topic`.
        """
elif False:
    EndpointKafkaSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointKafkaSettingsArgs:
    def __init__(__self__, *,
                 broker: pulumi.Input[_builtins.str],
                 include_control_details: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_null_and_empty: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_partition_value: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_table_alter_operations: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_transaction_details: Optional[pulumi.Input[_builtins.bool]] = None,
                 message_format: Optional[pulumi.Input[_builtins.str]] = None,
                 message_max_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 no_hex_prefix: Optional[pulumi.Input[_builtins.bool]] = None,
                 partition_include_schema_table: Optional[pulumi.Input[_builtins.bool]] = None,
                 sasl_mechanism: Optional[pulumi.Input[_builtins.str]] = None,
                 sasl_password: Optional[pulumi.Input[_builtins.str]] = None,
                 sasl_username: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_ca_certificate_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_client_certificate_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_client_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_client_key_password: Optional[pulumi.Input[_builtins.str]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] broker: Kafka broker location. Specify in the form broker-hostname-or-ip:port.
        :param pulumi.Input[_builtins.bool] include_control_details: Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output. Default is `false`.
        :param pulumi.Input[_builtins.bool] include_null_and_empty: Include NULL and empty columns for records migrated to the endpoint. Default is `false`.
        :param pulumi.Input[_builtins.bool] include_partition_value: Shows the partition value within the Kafka message output unless the partition type is `schema-table-type`. Default is `false`.
        :param pulumi.Input[_builtins.bool] include_table_alter_operations: Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table`, `drop-table`, `add-column`, `drop-column`, and `rename-column`. Default is `false`.
        :param pulumi.Input[_builtins.bool] include_transaction_details: Provides detailed transaction information from the source database. This information includes a commit timestamp, a log position, and values for `transaction_id`, previous `transaction_id`, and `transaction_record_id` (the record offset within a transaction). Default is `false`.
        :param pulumi.Input[_builtins.str] message_format: Output format for the records created on the endpoint. Message format is `JSON` (default) or `JSON_UNFORMATTED` (a single line with no tab).
        :param pulumi.Input[_builtins.int] message_max_bytes: Maximum size in bytes for records created on the endpoint Default is `1,000,000`.
        :param pulumi.Input[_builtins.bool] no_hex_prefix: Set this optional parameter to true to avoid adding a '0x' prefix to raw data in hexadecimal format. For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the `no_hex_prefix` endpoint setting to enable migration of RAW data type columns without adding the `'0x'` prefix.
        :param pulumi.Input[_builtins.bool] partition_include_schema_table: Prefixes schema and table names to partition values, when the partition type is `primary-key-type`. Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. Default is `false`.
        :param pulumi.Input[_builtins.str] sasl_mechanism: For SASL/SSL authentication, AWS DMS supports the `scram-sha-512` mechanism by default. AWS DMS versions 3.5.0 and later also support the PLAIN mechanism. To use the PLAIN mechanism, set this parameter to `plain`.
        :param pulumi.Input[_builtins.str] sasl_password: Secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        :param pulumi.Input[_builtins.str] sasl_username: Secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        :param pulumi.Input[_builtins.str] security_protocol: Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include `ssl-encryption`, `ssl-authentication`, and `sasl-ssl`. `sasl-ssl` requires `sasl_username` and `sasl_password`.
        :param pulumi.Input[_builtins.str] ssl_ca_certificate_arn: ARN for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
        :param pulumi.Input[_builtins.str] ssl_client_certificate_arn: ARN of the client certificate used to securely connect to a Kafka target endpoint.
        :param pulumi.Input[_builtins.str] ssl_client_key_arn: ARN for the client private key used to securely connect to a Kafka target endpoint.
        :param pulumi.Input[_builtins.str] ssl_client_key_password: Password for the client private key used to securely connect to a Kafka target endpoint.
        :param pulumi.Input[_builtins.str] topic: Kafka topic for migration. Default is `kafka-default-topic`.
        """
        pulumi.set(__self__, "broker", broker)
        if include_control_details is not None:
            pulumi.set(__self__, "include_control_details", include_control_details)
        if include_null_and_empty is not None:
            pulumi.set(__self__, "include_null_and_empty", include_null_and_empty)
        if include_partition_value is not None:
            pulumi.set(__self__, "include_partition_value", include_partition_value)
        if include_table_alter_operations is not None:
            pulumi.set(__self__, "include_table_alter_operations", include_table_alter_operations)
        if include_transaction_details is not None:
            pulumi.set(__self__, "include_transaction_details", include_transaction_details)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if message_max_bytes is not None:
            pulumi.set(__self__, "message_max_bytes", message_max_bytes)
        if no_hex_prefix is not None:
            pulumi.set(__self__, "no_hex_prefix", no_hex_prefix)
        if partition_include_schema_table is not None:
            pulumi.set(__self__, "partition_include_schema_table", partition_include_schema_table)
        if sasl_mechanism is not None:
            pulumi.set(__self__, "sasl_mechanism", sasl_mechanism)
        if sasl_password is not None:
            pulumi.set(__self__, "sasl_password", sasl_password)
        if sasl_username is not None:
            pulumi.set(__self__, "sasl_username", sasl_username)
        if security_protocol is not None:
            pulumi.set(__self__, "security_protocol", security_protocol)
        if ssl_ca_certificate_arn is not None:
            pulumi.set(__self__, "ssl_ca_certificate_arn", ssl_ca_certificate_arn)
        if ssl_client_certificate_arn is not None:
            pulumi.set(__self__, "ssl_client_certificate_arn", ssl_client_certificate_arn)
        if ssl_client_key_arn is not None:
            pulumi.set(__self__, "ssl_client_key_arn", ssl_client_key_arn)
        if ssl_client_key_password is not None:
            pulumi.set(__self__, "ssl_client_key_password", ssl_client_key_password)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @_builtins.property
    @pulumi.getter
    def broker(self) -> pulumi.Input[_builtins.str]:
        """
        Kafka broker location. Specify in the form broker-hostname-or-ip:port.
        """
        return pulumi.get(self, "broker")

    @broker.setter
    def broker(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "broker", value)

    @_builtins.property
    @pulumi.getter(name="includeControlDetails")
    def include_control_details(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output. Default is `false`.
        """
        return pulumi.get(self, "include_control_details")

    @include_control_details.setter
    def include_control_details(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_control_details", value)

    @_builtins.property
    @pulumi.getter(name="includeNullAndEmpty")
    def include_null_and_empty(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include NULL and empty columns for records migrated to the endpoint. Default is `false`.
        """
        return pulumi.get(self, "include_null_and_empty")

    @include_null_and_empty.setter
    def include_null_and_empty(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_null_and_empty", value)

    @_builtins.property
    @pulumi.getter(name="includePartitionValue")
    def include_partition_value(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Shows the partition value within the Kafka message output unless the partition type is `schema-table-type`. Default is `false`.
        """
        return pulumi.get(self, "include_partition_value")

    @include_partition_value.setter
    def include_partition_value(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_partition_value", value)

    @_builtins.property
    @pulumi.getter(name="includeTableAlterOperations")
    def include_table_alter_operations(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table`, `drop-table`, `add-column`, `drop-column`, and `rename-column`. Default is `false`.
        """
        return pulumi.get(self, "include_table_alter_operations")

    @include_table_alter_operations.setter
    def include_table_alter_operations(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_table_alter_operations", value)

    @_builtins.property
    @pulumi.getter(name="includeTransactionDetails")
    def include_transaction_details(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Provides detailed transaction information from the source database. This information includes a commit timestamp, a log position, and values for `transaction_id`, previous `transaction_id`, and `transaction_record_id` (the record offset within a transaction). Default is `false`.
        """
        return pulumi.get(self, "include_transaction_details")

    @include_transaction_details.setter
    def include_transaction_details(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_transaction_details", value)

    @_builtins.property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output format for the records created on the endpoint. Message format is `JSON` (default) or `JSON_UNFORMATTED` (a single line with no tab).
        """
        return pulumi.get(self, "message_format")

    @message_format.setter
    def message_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message_format", value)

    @_builtins.property
    @pulumi.getter(name="messageMaxBytes")
    def message_max_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum size in bytes for records created on the endpoint Default is `1,000,000`.
        """
        return pulumi.get(self, "message_max_bytes")

    @message_max_bytes.setter
    def message_max_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "message_max_bytes", value)

    @_builtins.property
    @pulumi.getter(name="noHexPrefix")
    def no_hex_prefix(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set this optional parameter to true to avoid adding a '0x' prefix to raw data in hexadecimal format. For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the `no_hex_prefix` endpoint setting to enable migration of RAW data type columns without adding the `'0x'` prefix.
        """
        return pulumi.get(self, "no_hex_prefix")

    @no_hex_prefix.setter
    def no_hex_prefix(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_hex_prefix", value)

    @_builtins.property
    @pulumi.getter(name="partitionIncludeSchemaTable")
    def partition_include_schema_table(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prefixes schema and table names to partition values, when the partition type is `primary-key-type`. Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. Default is `false`.
        """
        return pulumi.get(self, "partition_include_schema_table")

    @partition_include_schema_table.setter
    def partition_include_schema_table(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "partition_include_schema_table", value)

    @_builtins.property
    @pulumi.getter(name="saslMechanism")
    def sasl_mechanism(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For SASL/SSL authentication, AWS DMS supports the `scram-sha-512` mechanism by default. AWS DMS versions 3.5.0 and later also support the PLAIN mechanism. To use the PLAIN mechanism, set this parameter to `plain`.
        """
        return pulumi.get(self, "sasl_mechanism")

    @sasl_mechanism.setter
    def sasl_mechanism(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sasl_mechanism", value)

    @_builtins.property
    @pulumi.getter(name="saslPassword")
    def sasl_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        """
        return pulumi.get(self, "sasl_password")

    @sasl_password.setter
    def sasl_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sasl_password", value)

    @_builtins.property
    @pulumi.getter(name="saslUsername")
    def sasl_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        """
        return pulumi.get(self, "sasl_username")

    @sasl_username.setter
    def sasl_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sasl_username", value)

    @_builtins.property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include `ssl-encryption`, `ssl-authentication`, and `sasl-ssl`. `sasl-ssl` requires `sasl_username` and `sasl_password`.
        """
        return pulumi.get(self, "security_protocol")

    @security_protocol.setter
    def security_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_protocol", value)

    @_builtins.property
    @pulumi.getter(name="sslCaCertificateArn")
    def ssl_ca_certificate_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_ca_certificate_arn")

    @ssl_ca_certificate_arn.setter
    def ssl_ca_certificate_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_ca_certificate_arn", value)

    @_builtins.property
    @pulumi.getter(name="sslClientCertificateArn")
    def ssl_client_certificate_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the client certificate used to securely connect to a Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_client_certificate_arn")

    @ssl_client_certificate_arn.setter
    def ssl_client_certificate_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_client_certificate_arn", value)

    @_builtins.property
    @pulumi.getter(name="sslClientKeyArn")
    def ssl_client_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN for the client private key used to securely connect to a Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_client_key_arn")

    @ssl_client_key_arn.setter
    def ssl_client_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_client_key_arn", value)

    @_builtins.property
    @pulumi.getter(name="sslClientKeyPassword")
    def ssl_client_key_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for the client private key used to securely connect to a Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_client_key_password")

    @ssl_client_key_password.setter
    def ssl_client_key_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_client_key_password", value)

    @_builtins.property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kafka topic for migration. Default is `kafka-default-topic`.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic", value)


if not MYPY:
    class EndpointKinesisSettingsArgsDict(TypedDict):
        include_control_details: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output. Default is `false`.
        """
        include_null_and_empty: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Include NULL and empty columns in the target. Default is `false`.
        """
        include_partition_value: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Shows the partition value within the Kinesis message output, unless the partition type is schema-table-type. Default is `false`.
        """
        include_table_alter_operations: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Includes any data definition language (DDL) operations that change the table in the control data. Default is `false`.
        """
        include_transaction_details: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Provides detailed transaction information from the source database. Default is `false`.
        """
        message_format: NotRequired[pulumi.Input[_builtins.str]]
        """
        Output format for the records created. Default is `json`. Valid values are `json` and `json-unformatted` (a single line with no tab).
        """
        partition_include_schema_table: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Prefixes schema and table names to partition values, when the partition type is primary-key-type. Default is `false`.
        """
        service_access_role_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        ARN of the IAM Role with permissions to write to the Kinesis data stream.
        """
        stream_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        ARN of the Kinesis data stream.
        """
        use_large_integer_value: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Use up to 18 digit int instead of casting ints as doubles, available from AWS DMS version 3.5.4. Default is `false`.
        """
elif False:
    EndpointKinesisSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointKinesisSettingsArgs:
    def __init__(__self__, *,
                 include_control_details: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_null_and_empty: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_partition_value: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_table_alter_operations: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_transaction_details: Optional[pulumi.Input[_builtins.bool]] = None,
                 message_format: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_include_schema_table: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_access_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 use_large_integer_value: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] include_control_details: Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output. Default is `false`.
        :param pulumi.Input[_builtins.bool] include_null_and_empty: Include NULL and empty columns in the target. Default is `false`.
        :param pulumi.Input[_builtins.bool] include_partition_value: Shows the partition value within the Kinesis message output, unless the partition type is schema-table-type. Default is `false`.
        :param pulumi.Input[_builtins.bool] include_table_alter_operations: Includes any data definition language (DDL) operations that change the table in the control data. Default is `false`.
        :param pulumi.Input[_builtins.bool] include_transaction_details: Provides detailed transaction information from the source database. Default is `false`.
        :param pulumi.Input[_builtins.str] message_format: Output format for the records created. Default is `json`. Valid values are `json` and `json-unformatted` (a single line with no tab).
        :param pulumi.Input[_builtins.bool] partition_include_schema_table: Prefixes schema and table names to partition values, when the partition type is primary-key-type. Default is `false`.
        :param pulumi.Input[_builtins.str] service_access_role_arn: ARN of the IAM Role with permissions to write to the Kinesis data stream.
        :param pulumi.Input[_builtins.str] stream_arn: ARN of the Kinesis data stream.
        :param pulumi.Input[_builtins.bool] use_large_integer_value: Use up to 18 digit int instead of casting ints as doubles, available from AWS DMS version 3.5.4. Default is `false`.
        """
        if include_control_details is not None:
            pulumi.set(__self__, "include_control_details", include_control_details)
        if include_null_and_empty is not None:
            pulumi.set(__self__, "include_null_and_empty", include_null_and_empty)
        if include_partition_value is not None:
            pulumi.set(__self__, "include_partition_value", include_partition_value)
        if include_table_alter_operations is not None:
            pulumi.set(__self__, "include_table_alter_operations", include_table_alter_operations)
        if include_transaction_details is not None:
            pulumi.set(__self__, "include_transaction_details", include_transaction_details)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if partition_include_schema_table is not None:
            pulumi.set(__self__, "partition_include_schema_table", partition_include_schema_table)
        if service_access_role_arn is not None:
            pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        if stream_arn is not None:
            pulumi.set(__self__, "stream_arn", stream_arn)
        if use_large_integer_value is not None:
            pulumi.set(__self__, "use_large_integer_value", use_large_integer_value)

    @_builtins.property
    @pulumi.getter(name="includeControlDetails")
    def include_control_details(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output. Default is `false`.
        """
        return pulumi.get(self, "include_control_details")

    @include_control_details.setter
    def include_control_details(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_control_details", value)

    @_builtins.property
    @pulumi.getter(name="includeNullAndEmpty")
    def include_null_and_empty(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include NULL and empty columns in the target. Default is `false`.
        """
        return pulumi.get(self, "include_null_and_empty")

    @include_null_and_empty.setter
    def include_null_and_empty(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_null_and_empty", value)

    @_builtins.property
    @pulumi.getter(name="includePartitionValue")
    def include_partition_value(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Shows the partition value within the Kinesis message output, unless the partition type is schema-table-type. Default is `false`.
        """
        return pulumi.get(self, "include_partition_value")

    @include_partition_value.setter
    def include_partition_value(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_partition_value", value)

    @_builtins.property
    @pulumi.getter(name="includeTableAlterOperations")
    def include_table_alter_operations(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Includes any data definition language (DDL) operations that change the table in the control data. Default is `false`.
        """
        return pulumi.get(self, "include_table_alter_operations")

    @include_table_alter_operations.setter
    def include_table_alter_operations(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_table_alter_operations", value)

    @_builtins.property
    @pulumi.getter(name="includeTransactionDetails")
    def include_transaction_details(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Provides detailed transaction information from the source database. Default is `false`.
        """
        return pulumi.get(self, "include_transaction_details")

    @include_transaction_details.setter
    def include_transaction_details(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_transaction_details", value)

    @_builtins.property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output format for the records created. Default is `json`. Valid values are `json` and `json-unformatted` (a single line with no tab).
        """
        return pulumi.get(self, "message_format")

    @message_format.setter
    def message_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message_format", value)

    @_builtins.property
    @pulumi.getter(name="partitionIncludeSchemaTable")
    def partition_include_schema_table(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prefixes schema and table names to partition values, when the partition type is primary-key-type. Default is `false`.
        """
        return pulumi.get(self, "partition_include_schema_table")

    @partition_include_schema_table.setter
    def partition_include_schema_table(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "partition_include_schema_table", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM Role with permissions to write to the Kinesis data stream.
        """
        return pulumi.get(self, "service_access_role_arn")

    @service_access_role_arn.setter
    def service_access_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_access_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Kinesis data stream.
        """
        return pulumi.get(self, "stream_arn")

    @stream_arn.setter
    def stream_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_arn", value)

    @_builtins.property
    @pulumi.getter(name="useLargeIntegerValue")
    def use_large_integer_value(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use up to 18 digit int instead of casting ints as doubles, available from AWS DMS version 3.5.4. Default is `false`.
        """
        return pulumi.get(self, "use_large_integer_value")

    @use_large_integer_value.setter
    def use_large_integer_value(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_large_integer_value", value)


if not MYPY:
    class EndpointMongodbSettingsArgsDict(TypedDict):
        auth_mechanism: NotRequired[pulumi.Input[_builtins.str]]
        """
        Authentication mechanism to access the MongoDB source endpoint. Default is `default`.
        """
        auth_source: NotRequired[pulumi.Input[_builtins.str]]
        """
        Authentication database name. Not used when `auth_type` is `no`. Default is `admin`.
        """
        auth_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Authentication type to access the MongoDB source endpoint. Default is `password`.
        """
        docs_to_investigate: NotRequired[pulumi.Input[_builtins.str]]
        """
        Number of documents to preview to determine the document organization. Use this setting when `nesting_level` is set to `one`. Default is `1000`.
        """
        extract_doc_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Document ID. Use this setting when `nesting_level` is set to `none`. Default is `false`.
        """
        nesting_level: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies either document or table mode. Default is `none`. Valid values are `one` (table mode) and `none` (document mode).
        """
elif False:
    EndpointMongodbSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointMongodbSettingsArgs:
    def __init__(__self__, *,
                 auth_mechanism: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_source: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 docs_to_investigate: Optional[pulumi.Input[_builtins.str]] = None,
                 extract_doc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nesting_level: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] auth_mechanism: Authentication mechanism to access the MongoDB source endpoint. Default is `default`.
        :param pulumi.Input[_builtins.str] auth_source: Authentication database name. Not used when `auth_type` is `no`. Default is `admin`.
        :param pulumi.Input[_builtins.str] auth_type: Authentication type to access the MongoDB source endpoint. Default is `password`.
        :param pulumi.Input[_builtins.str] docs_to_investigate: Number of documents to preview to determine the document organization. Use this setting when `nesting_level` is set to `one`. Default is `1000`.
        :param pulumi.Input[_builtins.str] extract_doc_id: Document ID. Use this setting when `nesting_level` is set to `none`. Default is `false`.
        :param pulumi.Input[_builtins.str] nesting_level: Specifies either document or table mode. Default is `none`. Valid values are `one` (table mode) and `none` (document mode).
        """
        if auth_mechanism is not None:
            pulumi.set(__self__, "auth_mechanism", auth_mechanism)
        if auth_source is not None:
            pulumi.set(__self__, "auth_source", auth_source)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if docs_to_investigate is not None:
            pulumi.set(__self__, "docs_to_investigate", docs_to_investigate)
        if extract_doc_id is not None:
            pulumi.set(__self__, "extract_doc_id", extract_doc_id)
        if nesting_level is not None:
            pulumi.set(__self__, "nesting_level", nesting_level)

    @_builtins.property
    @pulumi.getter(name="authMechanism")
    def auth_mechanism(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication mechanism to access the MongoDB source endpoint. Default is `default`.
        """
        return pulumi.get(self, "auth_mechanism")

    @auth_mechanism.setter
    def auth_mechanism(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_mechanism", value)

    @_builtins.property
    @pulumi.getter(name="authSource")
    def auth_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication database name. Not used when `auth_type` is `no`. Default is `admin`.
        """
        return pulumi.get(self, "auth_source")

    @auth_source.setter
    def auth_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_source", value)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication type to access the MongoDB source endpoint. Default is `password`.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_type", value)

    @_builtins.property
    @pulumi.getter(name="docsToInvestigate")
    def docs_to_investigate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of documents to preview to determine the document organization. Use this setting when `nesting_level` is set to `one`. Default is `1000`.
        """
        return pulumi.get(self, "docs_to_investigate")

    @docs_to_investigate.setter
    def docs_to_investigate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "docs_to_investigate", value)

    @_builtins.property
    @pulumi.getter(name="extractDocId")
    def extract_doc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Document ID. Use this setting when `nesting_level` is set to `none`. Default is `false`.
        """
        return pulumi.get(self, "extract_doc_id")

    @extract_doc_id.setter
    def extract_doc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extract_doc_id", value)

    @_builtins.property
    @pulumi.getter(name="nestingLevel")
    def nesting_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies either document or table mode. Default is `none`. Valid values are `one` (table mode) and `none` (document mode).
        """
        return pulumi.get(self, "nesting_level")

    @nesting_level.setter
    def nesting_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nesting_level", value)


if not MYPY:
    class EndpointOracleSettingsArgsDict(TypedDict):
        authentication_method: NotRequired[pulumi.Input[_builtins.str]]
        """
        Authentication mechanism to access the Oracle source endpoint. Default is `password`. Valid values are `password` and `kerberos`.
        """
elif False:
    EndpointOracleSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointOracleSettingsArgs:
    def __init__(__self__, *,
                 authentication_method: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] authentication_method: Authentication mechanism to access the Oracle source endpoint. Default is `password`. Valid values are `password` and `kerberos`.
        """
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)

    @_builtins.property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication mechanism to access the Oracle source endpoint. Default is `password`. Valid values are `password` and `kerberos`.
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_method", value)


if not MYPY:
    class EndpointPostgresSettingsArgsDict(TypedDict):
        after_connect_script: NotRequired[pulumi.Input[_builtins.str]]
        """
        For use with change data capture (CDC) only, this attribute has AWS DMS bypass foreign keys and user triggers to reduce the time it takes to bulk load data.
        """
        authentication_method: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the authentication method. Valid values: `password`, `iam`.
        """
        babelfish_database_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Babelfish for Aurora PostgreSQL database name for the endpoint.
        """
        capture_ddls: NotRequired[pulumi.Input[_builtins.bool]]
        """
        To capture DDL events, AWS DMS creates various artifacts in the PostgreSQL database when the task starts.
        """
        database_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the default behavior of the replication's handling of PostgreSQL- compatible endpoints that require some additional configuration, such as Babelfish endpoints.
        """
        ddl_artifacts_schema: NotRequired[pulumi.Input[_builtins.str]]
        """
        Sets the schema in which the operational DDL database artifacts are created. Default is `public`.
        """
        execute_timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        Sets the client statement timeout for the PostgreSQL instance, in seconds. Default value is `60`.
        """
        fail_tasks_on_lob_truncation: NotRequired[pulumi.Input[_builtins.bool]]
        """
        When set to `true`, this value causes a task to fail if the actual size of a LOB column is greater than the specified `LobMaxSize`. Default is `false`.
        """
        heartbeat_enable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        The write-ahead log (WAL) heartbeat feature mimics a dummy transaction. By doing this, it prevents idle logical replication slots from holding onto old WAL logs, which can result in storage full situations on the source.
        """
        heartbeat_frequency: NotRequired[pulumi.Input[_builtins.int]]
        """
        Sets the WAL heartbeat frequency (in minutes). Default value is `5`.
        """
        heartbeat_schema: NotRequired[pulumi.Input[_builtins.str]]
        """
        Sets the schema in which the heartbeat artifacts are created. Default value is `public`.
        """
        map_boolean_as_boolean: NotRequired[pulumi.Input[_builtins.bool]]
        """
        You can use PostgreSQL endpoint settings to map a boolean as a boolean from your PostgreSQL source to a Amazon Redshift target. Default value is `false`.
        """
        map_jsonb_as_clob: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Optional When true, DMS migrates JSONB values as CLOB.
        """
        map_long_varchar_as: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional When true, DMS migrates LONG values as VARCHAR.
        """
        max_file_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the maximum size (in KB) of any .csv file used to transfer data to PostgreSQL. Default is `32,768 KB`.
        """
        plugin_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the plugin to use to create a replication slot. Valid values: `pglogical`, `test_decoding`.
        """
        service_access_role_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the IAM role to use to authenticate the connection.
        """
        slot_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Sets the name of a previously created logical replication slot for a CDC load of the PostgreSQL source instance.
        """
elif False:
    EndpointPostgresSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointPostgresSettingsArgs:
    def __init__(__self__, *,
                 after_connect_script: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
                 babelfish_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 capture_ddls: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ddl_artifacts_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 fail_tasks_on_lob_truncation: Optional[pulumi.Input[_builtins.bool]] = None,
                 heartbeat_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 heartbeat_frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 heartbeat_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 map_boolean_as_boolean: Optional[pulumi.Input[_builtins.bool]] = None,
                 map_jsonb_as_clob: Optional[pulumi.Input[_builtins.bool]] = None,
                 map_long_varchar_as: Optional[pulumi.Input[_builtins.str]] = None,
                 max_file_size: Optional[pulumi.Input[_builtins.int]] = None,
                 plugin_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_access_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 slot_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] after_connect_script: For use with change data capture (CDC) only, this attribute has AWS DMS bypass foreign keys and user triggers to reduce the time it takes to bulk load data.
        :param pulumi.Input[_builtins.str] authentication_method: Specifies the authentication method. Valid values: `password`, `iam`.
        :param pulumi.Input[_builtins.str] babelfish_database_name: The Babelfish for Aurora PostgreSQL database name for the endpoint.
        :param pulumi.Input[_builtins.bool] capture_ddls: To capture DDL events, AWS DMS creates various artifacts in the PostgreSQL database when the task starts.
        :param pulumi.Input[_builtins.str] database_mode: Specifies the default behavior of the replication's handling of PostgreSQL- compatible endpoints that require some additional configuration, such as Babelfish endpoints.
        :param pulumi.Input[_builtins.str] ddl_artifacts_schema: Sets the schema in which the operational DDL database artifacts are created. Default is `public`.
        :param pulumi.Input[_builtins.int] execute_timeout: Sets the client statement timeout for the PostgreSQL instance, in seconds. Default value is `60`.
        :param pulumi.Input[_builtins.bool] fail_tasks_on_lob_truncation: When set to `true`, this value causes a task to fail if the actual size of a LOB column is greater than the specified `LobMaxSize`. Default is `false`.
        :param pulumi.Input[_builtins.bool] heartbeat_enable: The write-ahead log (WAL) heartbeat feature mimics a dummy transaction. By doing this, it prevents idle logical replication slots from holding onto old WAL logs, which can result in storage full situations on the source.
        :param pulumi.Input[_builtins.int] heartbeat_frequency: Sets the WAL heartbeat frequency (in minutes). Default value is `5`.
        :param pulumi.Input[_builtins.str] heartbeat_schema: Sets the schema in which the heartbeat artifacts are created. Default value is `public`.
        :param pulumi.Input[_builtins.bool] map_boolean_as_boolean: You can use PostgreSQL endpoint settings to map a boolean as a boolean from your PostgreSQL source to a Amazon Redshift target. Default value is `false`.
        :param pulumi.Input[_builtins.bool] map_jsonb_as_clob: Optional When true, DMS migrates JSONB values as CLOB.
        :param pulumi.Input[_builtins.str] map_long_varchar_as: Optional When true, DMS migrates LONG values as VARCHAR.
        :param pulumi.Input[_builtins.int] max_file_size: Specifies the maximum size (in KB) of any .csv file used to transfer data to PostgreSQL. Default is `32,768 KB`.
        :param pulumi.Input[_builtins.str] plugin_name: Specifies the plugin to use to create a replication slot. Valid values: `pglogical`, `test_decoding`.
        :param pulumi.Input[_builtins.str] service_access_role_arn: Specifies the IAM role to use to authenticate the connection.
        :param pulumi.Input[_builtins.str] slot_name: Sets the name of a previously created logical replication slot for a CDC load of the PostgreSQL source instance.
        """
        if after_connect_script is not None:
            pulumi.set(__self__, "after_connect_script", after_connect_script)
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if babelfish_database_name is not None:
            pulumi.set(__self__, "babelfish_database_name", babelfish_database_name)
        if capture_ddls is not None:
            pulumi.set(__self__, "capture_ddls", capture_ddls)
        if database_mode is not None:
            pulumi.set(__self__, "database_mode", database_mode)
        if ddl_artifacts_schema is not None:
            pulumi.set(__self__, "ddl_artifacts_schema", ddl_artifacts_schema)
        if execute_timeout is not None:
            pulumi.set(__self__, "execute_timeout", execute_timeout)
        if fail_tasks_on_lob_truncation is not None:
            pulumi.set(__self__, "fail_tasks_on_lob_truncation", fail_tasks_on_lob_truncation)
        if heartbeat_enable is not None:
            pulumi.set(__self__, "heartbeat_enable", heartbeat_enable)
        if heartbeat_frequency is not None:
            pulumi.set(__self__, "heartbeat_frequency", heartbeat_frequency)
        if heartbeat_schema is not None:
            pulumi.set(__self__, "heartbeat_schema", heartbeat_schema)
        if map_boolean_as_boolean is not None:
            pulumi.set(__self__, "map_boolean_as_boolean", map_boolean_as_boolean)
        if map_jsonb_as_clob is not None:
            pulumi.set(__self__, "map_jsonb_as_clob", map_jsonb_as_clob)
        if map_long_varchar_as is not None:
            pulumi.set(__self__, "map_long_varchar_as", map_long_varchar_as)
        if max_file_size is not None:
            pulumi.set(__self__, "max_file_size", max_file_size)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if service_access_role_arn is not None:
            pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        if slot_name is not None:
            pulumi.set(__self__, "slot_name", slot_name)

    @_builtins.property
    @pulumi.getter(name="afterConnectScript")
    def after_connect_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For use with change data capture (CDC) only, this attribute has AWS DMS bypass foreign keys and user triggers to reduce the time it takes to bulk load data.
        """
        return pulumi.get(self, "after_connect_script")

    @after_connect_script.setter
    def after_connect_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "after_connect_script", value)

    @_builtins.property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the authentication method. Valid values: `password`, `iam`.
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_method", value)

    @_builtins.property
    @pulumi.getter(name="babelfishDatabaseName")
    def babelfish_database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Babelfish for Aurora PostgreSQL database name for the endpoint.
        """
        return pulumi.get(self, "babelfish_database_name")

    @babelfish_database_name.setter
    def babelfish_database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "babelfish_database_name", value)

    @_builtins.property
    @pulumi.getter(name="captureDdls")
    def capture_ddls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        To capture DDL events, AWS DMS creates various artifacts in the PostgreSQL database when the task starts.
        """
        return pulumi.get(self, "capture_ddls")

    @capture_ddls.setter
    def capture_ddls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "capture_ddls", value)

    @_builtins.property
    @pulumi.getter(name="databaseMode")
    def database_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default behavior of the replication's handling of PostgreSQL- compatible endpoints that require some additional configuration, such as Babelfish endpoints.
        """
        return pulumi.get(self, "database_mode")

    @database_mode.setter
    def database_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_mode", value)

    @_builtins.property
    @pulumi.getter(name="ddlArtifactsSchema")
    def ddl_artifacts_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the schema in which the operational DDL database artifacts are created. Default is `public`.
        """
        return pulumi.get(self, "ddl_artifacts_schema")

    @ddl_artifacts_schema.setter
    def ddl_artifacts_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ddl_artifacts_schema", value)

    @_builtins.property
    @pulumi.getter(name="executeTimeout")
    def execute_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the client statement timeout for the PostgreSQL instance, in seconds. Default value is `60`.
        """
        return pulumi.get(self, "execute_timeout")

    @execute_timeout.setter
    def execute_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "execute_timeout", value)

    @_builtins.property
    @pulumi.getter(name="failTasksOnLobTruncation")
    def fail_tasks_on_lob_truncation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to `true`, this value causes a task to fail if the actual size of a LOB column is greater than the specified `LobMaxSize`. Default is `false`.
        """
        return pulumi.get(self, "fail_tasks_on_lob_truncation")

    @fail_tasks_on_lob_truncation.setter
    def fail_tasks_on_lob_truncation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fail_tasks_on_lob_truncation", value)

    @_builtins.property
    @pulumi.getter(name="heartbeatEnable")
    def heartbeat_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The write-ahead log (WAL) heartbeat feature mimics a dummy transaction. By doing this, it prevents idle logical replication slots from holding onto old WAL logs, which can result in storage full situations on the source.
        """
        return pulumi.get(self, "heartbeat_enable")

    @heartbeat_enable.setter
    def heartbeat_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "heartbeat_enable", value)

    @_builtins.property
    @pulumi.getter(name="heartbeatFrequency")
    def heartbeat_frequency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the WAL heartbeat frequency (in minutes). Default value is `5`.
        """
        return pulumi.get(self, "heartbeat_frequency")

    @heartbeat_frequency.setter
    def heartbeat_frequency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "heartbeat_frequency", value)

    @_builtins.property
    @pulumi.getter(name="heartbeatSchema")
    def heartbeat_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the schema in which the heartbeat artifacts are created. Default value is `public`.
        """
        return pulumi.get(self, "heartbeat_schema")

    @heartbeat_schema.setter
    def heartbeat_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "heartbeat_schema", value)

    @_builtins.property
    @pulumi.getter(name="mapBooleanAsBoolean")
    def map_boolean_as_boolean(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        You can use PostgreSQL endpoint settings to map a boolean as a boolean from your PostgreSQL source to a Amazon Redshift target. Default value is `false`.
        """
        return pulumi.get(self, "map_boolean_as_boolean")

    @map_boolean_as_boolean.setter
    def map_boolean_as_boolean(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "map_boolean_as_boolean", value)

    @_builtins.property
    @pulumi.getter(name="mapJsonbAsClob")
    def map_jsonb_as_clob(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional When true, DMS migrates JSONB values as CLOB.
        """
        return pulumi.get(self, "map_jsonb_as_clob")

    @map_jsonb_as_clob.setter
    def map_jsonb_as_clob(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "map_jsonb_as_clob", value)

    @_builtins.property
    @pulumi.getter(name="mapLongVarcharAs")
    def map_long_varchar_as(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional When true, DMS migrates LONG values as VARCHAR.
        """
        return pulumi.get(self, "map_long_varchar_as")

    @map_long_varchar_as.setter
    def map_long_varchar_as(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "map_long_varchar_as", value)

    @_builtins.property
    @pulumi.getter(name="maxFileSize")
    def max_file_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum size (in KB) of any .csv file used to transfer data to PostgreSQL. Default is `32,768 KB`.
        """
        return pulumi.get(self, "max_file_size")

    @max_file_size.setter
    def max_file_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_file_size", value)

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the plugin to use to create a replication slot. Valid values: `pglogical`, `test_decoding`.
        """
        return pulumi.get(self, "plugin_name")

    @plugin_name.setter
    def plugin_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IAM role to use to authenticate the connection.
        """
        return pulumi.get(self, "service_access_role_arn")

    @service_access_role_arn.setter
    def service_access_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_access_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="slotName")
    def slot_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the name of a previously created logical replication slot for a CDC load of the PostgreSQL source instance.
        """
        return pulumi.get(self, "slot_name")

    @slot_name.setter
    def slot_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slot_name", value)


if not MYPY:
    class EndpointRedisSettingsArgsDict(TypedDict):
        auth_type: pulumi.Input[_builtins.str]
        """
        The type of authentication to perform when connecting to a Redis target. Options include `none`, `auth-token`, and `auth-role`. The `auth-token` option requires an `auth_password` value to be provided. The `auth-role` option requires `auth_user_name` and `auth_password` values to be provided.
        """
        port: pulumi.Input[_builtins.int]
        """
        Transmission Control Protocol (TCP) port for the endpoint.
        """
        server_name: pulumi.Input[_builtins.str]
        """
        Fully qualified domain name of the endpoint.
        """
        auth_password: NotRequired[pulumi.Input[_builtins.str]]
        """
        The password provided with the auth-role and auth-token options of the AuthType setting for a Redis target endpoint.
        """
        auth_user_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The username provided with the `auth-role` option of the AuthType setting for a Redis target endpoint.
        """
        ssl_ca_certificate_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
        """
        ssl_security_protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        The plaintext option doesn't provide Transport Layer Security (TLS) encryption for traffic between endpoint and database. Options include `plaintext`, `ssl-encryption`. The default is `ssl-encryption`.
        """
elif False:
    EndpointRedisSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointRedisSettingsArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[_builtins.str],
                 port: pulumi.Input[_builtins.int],
                 server_name: pulumi.Input[_builtins.str],
                 auth_password: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_ca_certificate_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_security_protocol: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] auth_type: The type of authentication to perform when connecting to a Redis target. Options include `none`, `auth-token`, and `auth-role`. The `auth-token` option requires an `auth_password` value to be provided. The `auth-role` option requires `auth_user_name` and `auth_password` values to be provided.
        :param pulumi.Input[_builtins.int] port: Transmission Control Protocol (TCP) port for the endpoint.
        :param pulumi.Input[_builtins.str] server_name: Fully qualified domain name of the endpoint.
        :param pulumi.Input[_builtins.str] auth_password: The password provided with the auth-role and auth-token options of the AuthType setting for a Redis target endpoint.
        :param pulumi.Input[_builtins.str] auth_user_name: The username provided with the `auth-role` option of the AuthType setting for a Redis target endpoint.
        :param pulumi.Input[_builtins.str] ssl_ca_certificate_arn: The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
        :param pulumi.Input[_builtins.str] ssl_security_protocol: The plaintext option doesn't provide Transport Layer Security (TLS) encryption for traffic between endpoint and database. Options include `plaintext`, `ssl-encryption`. The default is `ssl-encryption`.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        if auth_password is not None:
            pulumi.set(__self__, "auth_password", auth_password)
        if auth_user_name is not None:
            pulumi.set(__self__, "auth_user_name", auth_user_name)
        if ssl_ca_certificate_arn is not None:
            pulumi.set(__self__, "ssl_ca_certificate_arn", ssl_ca_certificate_arn)
        if ssl_security_protocol is not None:
            pulumi.set(__self__, "ssl_security_protocol", ssl_security_protocol)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of authentication to perform when connecting to a Redis target. Options include `none`, `auth-token`, and `auth-role`. The `auth-token` option requires an `auth_password` value to be provided. The `auth-role` option requires `auth_user_name` and `auth_password` values to be provided.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "auth_type", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        Transmission Control Protocol (TCP) port for the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[_builtins.str]:
        """
        Fully qualified domain name of the endpoint.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_name", value)

    @_builtins.property
    @pulumi.getter(name="authPassword")
    def auth_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password provided with the auth-role and auth-token options of the AuthType setting for a Redis target endpoint.
        """
        return pulumi.get(self, "auth_password")

    @auth_password.setter
    def auth_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_password", value)

    @_builtins.property
    @pulumi.getter(name="authUserName")
    def auth_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username provided with the `auth-role` option of the AuthType setting for a Redis target endpoint.
        """
        return pulumi.get(self, "auth_user_name")

    @auth_user_name.setter
    def auth_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_user_name", value)

    @_builtins.property
    @pulumi.getter(name="sslCaCertificateArn")
    def ssl_ca_certificate_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
        """
        return pulumi.get(self, "ssl_ca_certificate_arn")

    @ssl_ca_certificate_arn.setter
    def ssl_ca_certificate_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_ca_certificate_arn", value)

    @_builtins.property
    @pulumi.getter(name="sslSecurityProtocol")
    def ssl_security_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The plaintext option doesn't provide Transport Layer Security (TLS) encryption for traffic between endpoint and database. Options include `plaintext`, `ssl-encryption`. The default is `ssl-encryption`.
        """
        return pulumi.get(self, "ssl_security_protocol")

    @ssl_security_protocol.setter
    def ssl_security_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_security_protocol", value)


if not MYPY:
    class EndpointRedshiftSettingsArgsDict(TypedDict):
        bucket_folder: NotRequired[pulumi.Input[_builtins.str]]
        """
        Custom S3 Bucket Object prefix for intermediate storage.
        """
        bucket_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Custom S3 Bucket name for intermediate storage.
        """
        encryption_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
        """
        server_side_encryption_kms_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
        """
        service_access_role_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        Amazon Resource Name (ARN) of the IAM Role with permissions to read from or write to the S3 Bucket for intermediate storage.
        """
elif False:
    EndpointRedshiftSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointRedshiftSettingsArgs:
    def __init__(__self__, *,
                 bucket_folder: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_access_role_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] bucket_folder: Custom S3 Bucket Object prefix for intermediate storage.
        :param pulumi.Input[_builtins.str] bucket_name: Custom S3 Bucket name for intermediate storage.
        :param pulumi.Input[_builtins.str] encryption_mode: The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
        :param pulumi.Input[_builtins.str] server_side_encryption_kms_key_id: ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
        :param pulumi.Input[_builtins.str] service_access_role_arn: Amazon Resource Name (ARN) of the IAM Role with permissions to read from or write to the S3 Bucket for intermediate storage.
        """
        if bucket_folder is not None:
            pulumi.set(__self__, "bucket_folder", bucket_folder)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if encryption_mode is not None:
            pulumi.set(__self__, "encryption_mode", encryption_mode)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if service_access_role_arn is not None:
            pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)

    @_builtins.property
    @pulumi.getter(name="bucketFolder")
    def bucket_folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom S3 Bucket Object prefix for intermediate storage.
        """
        return pulumi.get(self, "bucket_folder")

    @bucket_folder.setter
    def bucket_folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_folder", value)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom S3 Bucket name for intermediate storage.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
        """
        return pulumi.get(self, "encryption_mode")

    @encryption_mode.setter
    def encryption_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_mode", value)

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @server_side_encryption_kms_key_id.setter
    def server_side_encryption_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_side_encryption_kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the IAM Role with permissions to read from or write to the S3 Bucket for intermediate storage.
        """
        return pulumi.get(self, "service_access_role_arn")

    @service_access_role_arn.setter
    def service_access_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_access_role_arn", value)


if not MYPY:
    class ReplicationConfigComputeConfigArgsDict(TypedDict):
        replication_subnet_group_id: pulumi.Input[_builtins.str]
        """
        Specifies a subnet group identifier to associate with the DMS Serverless replication.
        """
        availability_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Availability Zone where the DMS Serverless replication using this configuration will run. The default value is a random.
        """
        dns_name_servers: NotRequired[pulumi.Input[_builtins.str]]
        """
        A list of custom DNS name servers supported for the DMS Serverless replication to access your source or target database.
        """
        kms_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used to encrypt the data during DMS Serverless replication. If you don't specify a value for the KmsKeyId parameter, DMS uses your default encryption key.
        """
        max_capacity_units: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the maximum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCUs as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384.
        """
        min_capacity_units: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the minimum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. If this value isn't set DMS sets the lowest allowed value, 1.
        """
        multi_az: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies if the replication instance is a multi-az deployment. You cannot set the `availability_zone` parameter if the `multi_az` parameter is set to `true`.
        """
        preferred_maintenance_window: NotRequired[pulumi.Input[_builtins.str]]
        """
        The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

        - Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week.
        - Format: `ddd:hh24:mi-ddd:hh24:mi`
        - Valid Days: `mon, tue, wed, thu, fri, sat, sun`
        - Constraints: Minimum 30-minute window.
        """
        vpc_security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
        """
elif False:
    ReplicationConfigComputeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationConfigComputeConfigArgs:
    def __init__(__self__, *,
                 replication_subnet_group_id: pulumi.Input[_builtins.str],
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_name_servers: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_capacity_units: Optional[pulumi.Input[_builtins.int]] = None,
                 min_capacity_units: Optional[pulumi.Input[_builtins.int]] = None,
                 multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] replication_subnet_group_id: Specifies a subnet group identifier to associate with the DMS Serverless replication.
        :param pulumi.Input[_builtins.str] availability_zone: The Availability Zone where the DMS Serverless replication using this configuration will run. The default value is a random.
        :param pulumi.Input[_builtins.str] dns_name_servers: A list of custom DNS name servers supported for the DMS Serverless replication to access your source or target database.
        :param pulumi.Input[_builtins.str] kms_key_id: An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used to encrypt the data during DMS Serverless replication. If you don't specify a value for the KmsKeyId parameter, DMS uses your default encryption key.
        :param pulumi.Input[_builtins.int] max_capacity_units: Specifies the maximum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCUs as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384.
        :param pulumi.Input[_builtins.int] min_capacity_units: Specifies the minimum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. If this value isn't set DMS sets the lowest allowed value, 1.
        :param pulumi.Input[_builtins.bool] multi_az: Specifies if the replication instance is a multi-az deployment. You cannot set the `availability_zone` parameter if the `multi_az` parameter is set to `true`.
        :param pulumi.Input[_builtins.str] preferred_maintenance_window: The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
               
               - Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week.
               - Format: `ddd:hh24:mi-ddd:hh24:mi`
               - Valid Days: `mon, tue, wed, thu, fri, sat, sun`
               - Constraints: Minimum 30-minute window.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_security_group_ids: Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
        """
        pulumi.set(__self__, "replication_subnet_group_id", replication_subnet_group_id)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if dns_name_servers is not None:
            pulumi.set(__self__, "dns_name_servers", dns_name_servers)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if max_capacity_units is not None:
            pulumi.set(__self__, "max_capacity_units", max_capacity_units)
        if min_capacity_units is not None:
            pulumi.set(__self__, "min_capacity_units", min_capacity_units)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @_builtins.property
    @pulumi.getter(name="replicationSubnetGroupId")
    def replication_subnet_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies a subnet group identifier to associate with the DMS Serverless replication.
        """
        return pulumi.get(self, "replication_subnet_group_id")

    @replication_subnet_group_id.setter
    def replication_subnet_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "replication_subnet_group_id", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Availability Zone where the DMS Serverless replication using this configuration will run. The default value is a random.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="dnsNameServers")
    def dns_name_servers(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A list of custom DNS name servers supported for the DMS Serverless replication to access your source or target database.
        """
        return pulumi.get(self, "dns_name_servers")

    @dns_name_servers.setter
    def dns_name_servers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_name_servers", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used to encrypt the data during DMS Serverless replication. If you don't specify a value for the KmsKeyId parameter, DMS uses your default encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="maxCapacityUnits")
    def max_capacity_units(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCUs as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384.
        """
        return pulumi.get(self, "max_capacity_units")

    @max_capacity_units.setter
    def max_capacity_units(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_capacity_units", value)

    @_builtins.property
    @pulumi.getter(name="minCapacityUnits")
    def min_capacity_units(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. If this value isn't set DMS sets the lowest allowed value, 1.
        """
        return pulumi.get(self, "min_capacity_units")

    @min_capacity_units.setter
    def min_capacity_units(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_capacity_units", value)

    @_builtins.property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the replication instance is a multi-az deployment. You cannot set the `availability_zone` parameter if the `multi_az` parameter is set to `true`.
        """
        return pulumi.get(self, "multi_az")

    @multi_az.setter
    def multi_az(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multi_az", value)

    @_builtins.property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

        - Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week.
        - Format: `ddd:hh24:mi-ddd:hh24:mi`
        - Valid Days: `mon, tue, wed, thu, fri, sat, sun`
        - Constraints: Minimum 30-minute window.
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


if not MYPY:
    class ReplicationInstanceKerberosAuthenticationSettingsArgsDict(TypedDict):
        key_cache_secret_iam_arn: pulumi.Input[_builtins.str]
        """
        ARN of the IAM role that grants AWS DMS access to the secret containing key cache file for the Kerberos authentication.
        """
        key_cache_secret_id: pulumi.Input[_builtins.str]
        """
        Secret ID that stores the key cache file required for Kerberos authentication.
        """
        krb5_file_contents: pulumi.Input[_builtins.str]
        """
        Contents of krb5 configuration file required for Kerberos authentication.
        """
elif False:
    ReplicationInstanceKerberosAuthenticationSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationInstanceKerberosAuthenticationSettingsArgs:
    def __init__(__self__, *,
                 key_cache_secret_iam_arn: pulumi.Input[_builtins.str],
                 key_cache_secret_id: pulumi.Input[_builtins.str],
                 krb5_file_contents: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] key_cache_secret_iam_arn: ARN of the IAM role that grants AWS DMS access to the secret containing key cache file for the Kerberos authentication.
        :param pulumi.Input[_builtins.str] key_cache_secret_id: Secret ID that stores the key cache file required for Kerberos authentication.
        :param pulumi.Input[_builtins.str] krb5_file_contents: Contents of krb5 configuration file required for Kerberos authentication.
        """
        pulumi.set(__self__, "key_cache_secret_iam_arn", key_cache_secret_iam_arn)
        pulumi.set(__self__, "key_cache_secret_id", key_cache_secret_id)
        pulumi.set(__self__, "krb5_file_contents", krb5_file_contents)

    @_builtins.property
    @pulumi.getter(name="keyCacheSecretIamArn")
    def key_cache_secret_iam_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the IAM role that grants AWS DMS access to the secret containing key cache file for the Kerberos authentication.
        """
        return pulumi.get(self, "key_cache_secret_iam_arn")

    @key_cache_secret_iam_arn.setter
    def key_cache_secret_iam_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_cache_secret_iam_arn", value)

    @_builtins.property
    @pulumi.getter(name="keyCacheSecretId")
    def key_cache_secret_id(self) -> pulumi.Input[_builtins.str]:
        """
        Secret ID that stores the key cache file required for Kerberos authentication.
        """
        return pulumi.get(self, "key_cache_secret_id")

    @key_cache_secret_id.setter
    def key_cache_secret_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_cache_secret_id", value)

    @_builtins.property
    @pulumi.getter(name="krb5FileContents")
    def krb5_file_contents(self) -> pulumi.Input[_builtins.str]:
        """
        Contents of krb5 configuration file required for Kerberos authentication.
        """
        return pulumi.get(self, "krb5_file_contents")

    @krb5_file_contents.setter
    def krb5_file_contents(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "krb5_file_contents", value)


