# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'EndpointElasticsearchSettings',
    'EndpointKafkaSettings',
    'EndpointKinesisSettings',
    'EndpointMongodbSettings',
    'EndpointOracleSettings',
    'EndpointPostgresSettings',
    'EndpointRedisSettings',
    'EndpointRedshiftSettings',
    'ReplicationConfigComputeConfig',
    'ReplicationInstanceKerberosAuthenticationSettings',
    'GetEndpointElasticsearchSettingResult',
    'GetEndpointKafkaSettingResult',
    'GetEndpointKinesisSettingResult',
    'GetEndpointMongodbSettingResult',
    'GetEndpointPostgresSettingResult',
    'GetEndpointRedisSettingResult',
    'GetEndpointRedshiftSettingResult',
    'GetEndpointS3SettingResult',
]

@pulumi.output_type
class EndpointElasticsearchSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointUri":
            suggest = "endpoint_uri"
        elif key == "serviceAccessRoleArn":
            suggest = "service_access_role_arn"
        elif key == "errorRetryDuration":
            suggest = "error_retry_duration"
        elif key == "fullLoadErrorPercentage":
            suggest = "full_load_error_percentage"
        elif key == "useNewMappingType":
            suggest = "use_new_mapping_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointElasticsearchSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointElasticsearchSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointElasticsearchSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_uri: _builtins.str,
                 service_access_role_arn: _builtins.str,
                 error_retry_duration: Optional[_builtins.int] = None,
                 full_load_error_percentage: Optional[_builtins.int] = None,
                 use_new_mapping_type: Optional[_builtins.bool] = None):
        """
        :param _builtins.str endpoint_uri: Endpoint for the OpenSearch cluster.
        :param _builtins.str service_access_role_arn: ARN of the IAM Role with permissions to write to the OpenSearch cluster.
        :param _builtins.int error_retry_duration: Maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster. Default is `300`.
        :param _builtins.int full_load_error_percentage: Maximum percentage of records that can fail to be written before a full load operation stops. Default is `10`.
        :param _builtins.bool use_new_mapping_type: Enable to migrate documentation using the documentation type `_doc`. OpenSearch and an Elasticsearch clusters only support the _doc documentation type in versions 7.x and later. The default value is `false`.
        """
        pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        if error_retry_duration is not None:
            pulumi.set(__self__, "error_retry_duration", error_retry_duration)
        if full_load_error_percentage is not None:
            pulumi.set(__self__, "full_load_error_percentage", full_load_error_percentage)
        if use_new_mapping_type is not None:
            pulumi.set(__self__, "use_new_mapping_type", use_new_mapping_type)

    @_builtins.property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> _builtins.str:
        """
        Endpoint for the OpenSearch cluster.
        """
        return pulumi.get(self, "endpoint_uri")

    @_builtins.property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> _builtins.str:
        """
        ARN of the IAM Role with permissions to write to the OpenSearch cluster.
        """
        return pulumi.get(self, "service_access_role_arn")

    @_builtins.property
    @pulumi.getter(name="errorRetryDuration")
    def error_retry_duration(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster. Default is `300`.
        """
        return pulumi.get(self, "error_retry_duration")

    @_builtins.property
    @pulumi.getter(name="fullLoadErrorPercentage")
    def full_load_error_percentage(self) -> Optional[_builtins.int]:
        """
        Maximum percentage of records that can fail to be written before a full load operation stops. Default is `10`.
        """
        return pulumi.get(self, "full_load_error_percentage")

    @_builtins.property
    @pulumi.getter(name="useNewMappingType")
    def use_new_mapping_type(self) -> Optional[_builtins.bool]:
        """
        Enable to migrate documentation using the documentation type `_doc`. OpenSearch and an Elasticsearch clusters only support the _doc documentation type in versions 7.x and later. The default value is `false`.
        """
        return pulumi.get(self, "use_new_mapping_type")


@pulumi.output_type
class EndpointKafkaSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeControlDetails":
            suggest = "include_control_details"
        elif key == "includeNullAndEmpty":
            suggest = "include_null_and_empty"
        elif key == "includePartitionValue":
            suggest = "include_partition_value"
        elif key == "includeTableAlterOperations":
            suggest = "include_table_alter_operations"
        elif key == "includeTransactionDetails":
            suggest = "include_transaction_details"
        elif key == "messageFormat":
            suggest = "message_format"
        elif key == "messageMaxBytes":
            suggest = "message_max_bytes"
        elif key == "noHexPrefix":
            suggest = "no_hex_prefix"
        elif key == "partitionIncludeSchemaTable":
            suggest = "partition_include_schema_table"
        elif key == "saslMechanism":
            suggest = "sasl_mechanism"
        elif key == "saslPassword":
            suggest = "sasl_password"
        elif key == "saslUsername":
            suggest = "sasl_username"
        elif key == "securityProtocol":
            suggest = "security_protocol"
        elif key == "sslCaCertificateArn":
            suggest = "ssl_ca_certificate_arn"
        elif key == "sslClientCertificateArn":
            suggest = "ssl_client_certificate_arn"
        elif key == "sslClientKeyArn":
            suggest = "ssl_client_key_arn"
        elif key == "sslClientKeyPassword":
            suggest = "ssl_client_key_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointKafkaSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointKafkaSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointKafkaSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 broker: _builtins.str,
                 include_control_details: Optional[_builtins.bool] = None,
                 include_null_and_empty: Optional[_builtins.bool] = None,
                 include_partition_value: Optional[_builtins.bool] = None,
                 include_table_alter_operations: Optional[_builtins.bool] = None,
                 include_transaction_details: Optional[_builtins.bool] = None,
                 message_format: Optional[_builtins.str] = None,
                 message_max_bytes: Optional[_builtins.int] = None,
                 no_hex_prefix: Optional[_builtins.bool] = None,
                 partition_include_schema_table: Optional[_builtins.bool] = None,
                 sasl_mechanism: Optional[_builtins.str] = None,
                 sasl_password: Optional[_builtins.str] = None,
                 sasl_username: Optional[_builtins.str] = None,
                 security_protocol: Optional[_builtins.str] = None,
                 ssl_ca_certificate_arn: Optional[_builtins.str] = None,
                 ssl_client_certificate_arn: Optional[_builtins.str] = None,
                 ssl_client_key_arn: Optional[_builtins.str] = None,
                 ssl_client_key_password: Optional[_builtins.str] = None,
                 topic: Optional[_builtins.str] = None):
        """
        :param _builtins.str broker: Kafka broker location. Specify in the form broker-hostname-or-ip:port.
        :param _builtins.bool include_control_details: Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output. Default is `false`.
        :param _builtins.bool include_null_and_empty: Include NULL and empty columns for records migrated to the endpoint. Default is `false`.
        :param _builtins.bool include_partition_value: Shows the partition value within the Kafka message output unless the partition type is `schema-table-type`. Default is `false`.
        :param _builtins.bool include_table_alter_operations: Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table`, `drop-table`, `add-column`, `drop-column`, and `rename-column`. Default is `false`.
        :param _builtins.bool include_transaction_details: Provides detailed transaction information from the source database. This information includes a commit timestamp, a log position, and values for `transaction_id`, previous `transaction_id`, and `transaction_record_id` (the record offset within a transaction). Default is `false`.
        :param _builtins.str message_format: Output format for the records created on the endpoint. Message format is `JSON` (default) or `JSON_UNFORMATTED` (a single line with no tab).
        :param _builtins.int message_max_bytes: Maximum size in bytes for records created on the endpoint Default is `1,000,000`.
        :param _builtins.bool no_hex_prefix: Set this optional parameter to true to avoid adding a '0x' prefix to raw data in hexadecimal format. For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the `no_hex_prefix` endpoint setting to enable migration of RAW data type columns without adding the `'0x'` prefix.
        :param _builtins.bool partition_include_schema_table: Prefixes schema and table names to partition values, when the partition type is `primary-key-type`. Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. Default is `false`.
        :param _builtins.str sasl_mechanism: For SASL/SSL authentication, AWS DMS supports the `scram-sha-512` mechanism by default. AWS DMS versions 3.5.0 and later also support the PLAIN mechanism. To use the PLAIN mechanism, set this parameter to `plain`.
        :param _builtins.str sasl_password: Secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        :param _builtins.str sasl_username: Secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        :param _builtins.str security_protocol: Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include `ssl-encryption`, `ssl-authentication`, and `sasl-ssl`. `sasl-ssl` requires `sasl_username` and `sasl_password`.
        :param _builtins.str ssl_ca_certificate_arn: ARN for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
        :param _builtins.str ssl_client_certificate_arn: ARN of the client certificate used to securely connect to a Kafka target endpoint.
        :param _builtins.str ssl_client_key_arn: ARN for the client private key used to securely connect to a Kafka target endpoint.
        :param _builtins.str ssl_client_key_password: Password for the client private key used to securely connect to a Kafka target endpoint.
        :param _builtins.str topic: Kafka topic for migration. Default is `kafka-default-topic`.
        """
        pulumi.set(__self__, "broker", broker)
        if include_control_details is not None:
            pulumi.set(__self__, "include_control_details", include_control_details)
        if include_null_and_empty is not None:
            pulumi.set(__self__, "include_null_and_empty", include_null_and_empty)
        if include_partition_value is not None:
            pulumi.set(__self__, "include_partition_value", include_partition_value)
        if include_table_alter_operations is not None:
            pulumi.set(__self__, "include_table_alter_operations", include_table_alter_operations)
        if include_transaction_details is not None:
            pulumi.set(__self__, "include_transaction_details", include_transaction_details)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if message_max_bytes is not None:
            pulumi.set(__self__, "message_max_bytes", message_max_bytes)
        if no_hex_prefix is not None:
            pulumi.set(__self__, "no_hex_prefix", no_hex_prefix)
        if partition_include_schema_table is not None:
            pulumi.set(__self__, "partition_include_schema_table", partition_include_schema_table)
        if sasl_mechanism is not None:
            pulumi.set(__self__, "sasl_mechanism", sasl_mechanism)
        if sasl_password is not None:
            pulumi.set(__self__, "sasl_password", sasl_password)
        if sasl_username is not None:
            pulumi.set(__self__, "sasl_username", sasl_username)
        if security_protocol is not None:
            pulumi.set(__self__, "security_protocol", security_protocol)
        if ssl_ca_certificate_arn is not None:
            pulumi.set(__self__, "ssl_ca_certificate_arn", ssl_ca_certificate_arn)
        if ssl_client_certificate_arn is not None:
            pulumi.set(__self__, "ssl_client_certificate_arn", ssl_client_certificate_arn)
        if ssl_client_key_arn is not None:
            pulumi.set(__self__, "ssl_client_key_arn", ssl_client_key_arn)
        if ssl_client_key_password is not None:
            pulumi.set(__self__, "ssl_client_key_password", ssl_client_key_password)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @_builtins.property
    @pulumi.getter
    def broker(self) -> _builtins.str:
        """
        Kafka broker location. Specify in the form broker-hostname-or-ip:port.
        """
        return pulumi.get(self, "broker")

    @_builtins.property
    @pulumi.getter(name="includeControlDetails")
    def include_control_details(self) -> Optional[_builtins.bool]:
        """
        Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output. Default is `false`.
        """
        return pulumi.get(self, "include_control_details")

    @_builtins.property
    @pulumi.getter(name="includeNullAndEmpty")
    def include_null_and_empty(self) -> Optional[_builtins.bool]:
        """
        Include NULL and empty columns for records migrated to the endpoint. Default is `false`.
        """
        return pulumi.get(self, "include_null_and_empty")

    @_builtins.property
    @pulumi.getter(name="includePartitionValue")
    def include_partition_value(self) -> Optional[_builtins.bool]:
        """
        Shows the partition value within the Kafka message output unless the partition type is `schema-table-type`. Default is `false`.
        """
        return pulumi.get(self, "include_partition_value")

    @_builtins.property
    @pulumi.getter(name="includeTableAlterOperations")
    def include_table_alter_operations(self) -> Optional[_builtins.bool]:
        """
        Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table`, `drop-table`, `add-column`, `drop-column`, and `rename-column`. Default is `false`.
        """
        return pulumi.get(self, "include_table_alter_operations")

    @_builtins.property
    @pulumi.getter(name="includeTransactionDetails")
    def include_transaction_details(self) -> Optional[_builtins.bool]:
        """
        Provides detailed transaction information from the source database. This information includes a commit timestamp, a log position, and values for `transaction_id`, previous `transaction_id`, and `transaction_record_id` (the record offset within a transaction). Default is `false`.
        """
        return pulumi.get(self, "include_transaction_details")

    @_builtins.property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[_builtins.str]:
        """
        Output format for the records created on the endpoint. Message format is `JSON` (default) or `JSON_UNFORMATTED` (a single line with no tab).
        """
        return pulumi.get(self, "message_format")

    @_builtins.property
    @pulumi.getter(name="messageMaxBytes")
    def message_max_bytes(self) -> Optional[_builtins.int]:
        """
        Maximum size in bytes for records created on the endpoint Default is `1,000,000`.
        """
        return pulumi.get(self, "message_max_bytes")

    @_builtins.property
    @pulumi.getter(name="noHexPrefix")
    def no_hex_prefix(self) -> Optional[_builtins.bool]:
        """
        Set this optional parameter to true to avoid adding a '0x' prefix to raw data in hexadecimal format. For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the `no_hex_prefix` endpoint setting to enable migration of RAW data type columns without adding the `'0x'` prefix.
        """
        return pulumi.get(self, "no_hex_prefix")

    @_builtins.property
    @pulumi.getter(name="partitionIncludeSchemaTable")
    def partition_include_schema_table(self) -> Optional[_builtins.bool]:
        """
        Prefixes schema and table names to partition values, when the partition type is `primary-key-type`. Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. Default is `false`.
        """
        return pulumi.get(self, "partition_include_schema_table")

    @_builtins.property
    @pulumi.getter(name="saslMechanism")
    def sasl_mechanism(self) -> Optional[_builtins.str]:
        """
        For SASL/SSL authentication, AWS DMS supports the `scram-sha-512` mechanism by default. AWS DMS versions 3.5.0 and later also support the PLAIN mechanism. To use the PLAIN mechanism, set this parameter to `plain`.
        """
        return pulumi.get(self, "sasl_mechanism")

    @_builtins.property
    @pulumi.getter(name="saslPassword")
    def sasl_password(self) -> Optional[_builtins.str]:
        """
        Secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        """
        return pulumi.get(self, "sasl_password")

    @_builtins.property
    @pulumi.getter(name="saslUsername")
    def sasl_username(self) -> Optional[_builtins.str]:
        """
        Secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        """
        return pulumi.get(self, "sasl_username")

    @_builtins.property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> Optional[_builtins.str]:
        """
        Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include `ssl-encryption`, `ssl-authentication`, and `sasl-ssl`. `sasl-ssl` requires `sasl_username` and `sasl_password`.
        """
        return pulumi.get(self, "security_protocol")

    @_builtins.property
    @pulumi.getter(name="sslCaCertificateArn")
    def ssl_ca_certificate_arn(self) -> Optional[_builtins.str]:
        """
        ARN for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_ca_certificate_arn")

    @_builtins.property
    @pulumi.getter(name="sslClientCertificateArn")
    def ssl_client_certificate_arn(self) -> Optional[_builtins.str]:
        """
        ARN of the client certificate used to securely connect to a Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_client_certificate_arn")

    @_builtins.property
    @pulumi.getter(name="sslClientKeyArn")
    def ssl_client_key_arn(self) -> Optional[_builtins.str]:
        """
        ARN for the client private key used to securely connect to a Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_client_key_arn")

    @_builtins.property
    @pulumi.getter(name="sslClientKeyPassword")
    def ssl_client_key_password(self) -> Optional[_builtins.str]:
        """
        Password for the client private key used to securely connect to a Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_client_key_password")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> Optional[_builtins.str]:
        """
        Kafka topic for migration. Default is `kafka-default-topic`.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class EndpointKinesisSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeControlDetails":
            suggest = "include_control_details"
        elif key == "includeNullAndEmpty":
            suggest = "include_null_and_empty"
        elif key == "includePartitionValue":
            suggest = "include_partition_value"
        elif key == "includeTableAlterOperations":
            suggest = "include_table_alter_operations"
        elif key == "includeTransactionDetails":
            suggest = "include_transaction_details"
        elif key == "messageFormat":
            suggest = "message_format"
        elif key == "partitionIncludeSchemaTable":
            suggest = "partition_include_schema_table"
        elif key == "serviceAccessRoleArn":
            suggest = "service_access_role_arn"
        elif key == "streamArn":
            suggest = "stream_arn"
        elif key == "useLargeIntegerValue":
            suggest = "use_large_integer_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointKinesisSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointKinesisSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointKinesisSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 include_control_details: Optional[_builtins.bool] = None,
                 include_null_and_empty: Optional[_builtins.bool] = None,
                 include_partition_value: Optional[_builtins.bool] = None,
                 include_table_alter_operations: Optional[_builtins.bool] = None,
                 include_transaction_details: Optional[_builtins.bool] = None,
                 message_format: Optional[_builtins.str] = None,
                 partition_include_schema_table: Optional[_builtins.bool] = None,
                 service_access_role_arn: Optional[_builtins.str] = None,
                 stream_arn: Optional[_builtins.str] = None,
                 use_large_integer_value: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool include_control_details: Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output. Default is `false`.
        :param _builtins.bool include_null_and_empty: Include NULL and empty columns in the target. Default is `false`.
        :param _builtins.bool include_partition_value: Shows the partition value within the Kinesis message output, unless the partition type is schema-table-type. Default is `false`.
        :param _builtins.bool include_table_alter_operations: Includes any data definition language (DDL) operations that change the table in the control data. Default is `false`.
        :param _builtins.bool include_transaction_details: Provides detailed transaction information from the source database. Default is `false`.
        :param _builtins.str message_format: Output format for the records created. Default is `json`. Valid values are `json` and `json-unformatted` (a single line with no tab).
        :param _builtins.bool partition_include_schema_table: Prefixes schema and table names to partition values, when the partition type is primary-key-type. Default is `false`.
        :param _builtins.str service_access_role_arn: ARN of the IAM Role with permissions to write to the Kinesis data stream.
        :param _builtins.str stream_arn: ARN of the Kinesis data stream.
        :param _builtins.bool use_large_integer_value: Use up to 18 digit int instead of casting ints as doubles, available from AWS DMS version 3.5.4. Default is `false`.
        """
        if include_control_details is not None:
            pulumi.set(__self__, "include_control_details", include_control_details)
        if include_null_and_empty is not None:
            pulumi.set(__self__, "include_null_and_empty", include_null_and_empty)
        if include_partition_value is not None:
            pulumi.set(__self__, "include_partition_value", include_partition_value)
        if include_table_alter_operations is not None:
            pulumi.set(__self__, "include_table_alter_operations", include_table_alter_operations)
        if include_transaction_details is not None:
            pulumi.set(__self__, "include_transaction_details", include_transaction_details)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if partition_include_schema_table is not None:
            pulumi.set(__self__, "partition_include_schema_table", partition_include_schema_table)
        if service_access_role_arn is not None:
            pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        if stream_arn is not None:
            pulumi.set(__self__, "stream_arn", stream_arn)
        if use_large_integer_value is not None:
            pulumi.set(__self__, "use_large_integer_value", use_large_integer_value)

    @_builtins.property
    @pulumi.getter(name="includeControlDetails")
    def include_control_details(self) -> Optional[_builtins.bool]:
        """
        Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output. Default is `false`.
        """
        return pulumi.get(self, "include_control_details")

    @_builtins.property
    @pulumi.getter(name="includeNullAndEmpty")
    def include_null_and_empty(self) -> Optional[_builtins.bool]:
        """
        Include NULL and empty columns in the target. Default is `false`.
        """
        return pulumi.get(self, "include_null_and_empty")

    @_builtins.property
    @pulumi.getter(name="includePartitionValue")
    def include_partition_value(self) -> Optional[_builtins.bool]:
        """
        Shows the partition value within the Kinesis message output, unless the partition type is schema-table-type. Default is `false`.
        """
        return pulumi.get(self, "include_partition_value")

    @_builtins.property
    @pulumi.getter(name="includeTableAlterOperations")
    def include_table_alter_operations(self) -> Optional[_builtins.bool]:
        """
        Includes any data definition language (DDL) operations that change the table in the control data. Default is `false`.
        """
        return pulumi.get(self, "include_table_alter_operations")

    @_builtins.property
    @pulumi.getter(name="includeTransactionDetails")
    def include_transaction_details(self) -> Optional[_builtins.bool]:
        """
        Provides detailed transaction information from the source database. Default is `false`.
        """
        return pulumi.get(self, "include_transaction_details")

    @_builtins.property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[_builtins.str]:
        """
        Output format for the records created. Default is `json`. Valid values are `json` and `json-unformatted` (a single line with no tab).
        """
        return pulumi.get(self, "message_format")

    @_builtins.property
    @pulumi.getter(name="partitionIncludeSchemaTable")
    def partition_include_schema_table(self) -> Optional[_builtins.bool]:
        """
        Prefixes schema and table names to partition values, when the partition type is primary-key-type. Default is `false`.
        """
        return pulumi.get(self, "partition_include_schema_table")

    @_builtins.property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> Optional[_builtins.str]:
        """
        ARN of the IAM Role with permissions to write to the Kinesis data stream.
        """
        return pulumi.get(self, "service_access_role_arn")

    @_builtins.property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> Optional[_builtins.str]:
        """
        ARN of the Kinesis data stream.
        """
        return pulumi.get(self, "stream_arn")

    @_builtins.property
    @pulumi.getter(name="useLargeIntegerValue")
    def use_large_integer_value(self) -> Optional[_builtins.bool]:
        """
        Use up to 18 digit int instead of casting ints as doubles, available from AWS DMS version 3.5.4. Default is `false`.
        """
        return pulumi.get(self, "use_large_integer_value")


@pulumi.output_type
class EndpointMongodbSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMechanism":
            suggest = "auth_mechanism"
        elif key == "authSource":
            suggest = "auth_source"
        elif key == "authType":
            suggest = "auth_type"
        elif key == "docsToInvestigate":
            suggest = "docs_to_investigate"
        elif key == "extractDocId":
            suggest = "extract_doc_id"
        elif key == "nestingLevel":
            suggest = "nesting_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointMongodbSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointMongodbSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointMongodbSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_mechanism: Optional[_builtins.str] = None,
                 auth_source: Optional[_builtins.str] = None,
                 auth_type: Optional[_builtins.str] = None,
                 docs_to_investigate: Optional[_builtins.str] = None,
                 extract_doc_id: Optional[_builtins.str] = None,
                 nesting_level: Optional[_builtins.str] = None):
        """
        :param _builtins.str auth_mechanism: Authentication mechanism to access the MongoDB source endpoint. Default is `default`.
        :param _builtins.str auth_source: Authentication database name. Not used when `auth_type` is `no`. Default is `admin`.
        :param _builtins.str auth_type: Authentication type to access the MongoDB source endpoint. Default is `password`.
        :param _builtins.str docs_to_investigate: Number of documents to preview to determine the document organization. Use this setting when `nesting_level` is set to `one`. Default is `1000`.
        :param _builtins.str extract_doc_id: Document ID. Use this setting when `nesting_level` is set to `none`. Default is `false`.
        :param _builtins.str nesting_level: Specifies either document or table mode. Default is `none`. Valid values are `one` (table mode) and `none` (document mode).
        """
        if auth_mechanism is not None:
            pulumi.set(__self__, "auth_mechanism", auth_mechanism)
        if auth_source is not None:
            pulumi.set(__self__, "auth_source", auth_source)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if docs_to_investigate is not None:
            pulumi.set(__self__, "docs_to_investigate", docs_to_investigate)
        if extract_doc_id is not None:
            pulumi.set(__self__, "extract_doc_id", extract_doc_id)
        if nesting_level is not None:
            pulumi.set(__self__, "nesting_level", nesting_level)

    @_builtins.property
    @pulumi.getter(name="authMechanism")
    def auth_mechanism(self) -> Optional[_builtins.str]:
        """
        Authentication mechanism to access the MongoDB source endpoint. Default is `default`.
        """
        return pulumi.get(self, "auth_mechanism")

    @_builtins.property
    @pulumi.getter(name="authSource")
    def auth_source(self) -> Optional[_builtins.str]:
        """
        Authentication database name. Not used when `auth_type` is `no`. Default is `admin`.
        """
        return pulumi.get(self, "auth_source")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        Authentication type to access the MongoDB source endpoint. Default is `password`.
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="docsToInvestigate")
    def docs_to_investigate(self) -> Optional[_builtins.str]:
        """
        Number of documents to preview to determine the document organization. Use this setting when `nesting_level` is set to `one`. Default is `1000`.
        """
        return pulumi.get(self, "docs_to_investigate")

    @_builtins.property
    @pulumi.getter(name="extractDocId")
    def extract_doc_id(self) -> Optional[_builtins.str]:
        """
        Document ID. Use this setting when `nesting_level` is set to `none`. Default is `false`.
        """
        return pulumi.get(self, "extract_doc_id")

    @_builtins.property
    @pulumi.getter(name="nestingLevel")
    def nesting_level(self) -> Optional[_builtins.str]:
        """
        Specifies either document or table mode. Default is `none`. Valid values are `one` (table mode) and `none` (document mode).
        """
        return pulumi.get(self, "nesting_level")


@pulumi.output_type
class EndpointOracleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationMethod":
            suggest = "authentication_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointOracleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointOracleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointOracleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_method: Optional[_builtins.str] = None):
        """
        :param _builtins.str authentication_method: Authentication mechanism to access the Oracle source endpoint. Default is `password`. Valid values are `password` and `kerberos`.
        """
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)

    @_builtins.property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[_builtins.str]:
        """
        Authentication mechanism to access the Oracle source endpoint. Default is `password`. Valid values are `password` and `kerberos`.
        """
        return pulumi.get(self, "authentication_method")


@pulumi.output_type
class EndpointPostgresSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "afterConnectScript":
            suggest = "after_connect_script"
        elif key == "authenticationMethod":
            suggest = "authentication_method"
        elif key == "babelfishDatabaseName":
            suggest = "babelfish_database_name"
        elif key == "captureDdls":
            suggest = "capture_ddls"
        elif key == "databaseMode":
            suggest = "database_mode"
        elif key == "ddlArtifactsSchema":
            suggest = "ddl_artifacts_schema"
        elif key == "executeTimeout":
            suggest = "execute_timeout"
        elif key == "failTasksOnLobTruncation":
            suggest = "fail_tasks_on_lob_truncation"
        elif key == "heartbeatEnable":
            suggest = "heartbeat_enable"
        elif key == "heartbeatFrequency":
            suggest = "heartbeat_frequency"
        elif key == "heartbeatSchema":
            suggest = "heartbeat_schema"
        elif key == "mapBooleanAsBoolean":
            suggest = "map_boolean_as_boolean"
        elif key == "mapJsonbAsClob":
            suggest = "map_jsonb_as_clob"
        elif key == "mapLongVarcharAs":
            suggest = "map_long_varchar_as"
        elif key == "maxFileSize":
            suggest = "max_file_size"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "serviceAccessRoleArn":
            suggest = "service_access_role_arn"
        elif key == "slotName":
            suggest = "slot_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointPostgresSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointPostgresSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointPostgresSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 after_connect_script: Optional[_builtins.str] = None,
                 authentication_method: Optional[_builtins.str] = None,
                 babelfish_database_name: Optional[_builtins.str] = None,
                 capture_ddls: Optional[_builtins.bool] = None,
                 database_mode: Optional[_builtins.str] = None,
                 ddl_artifacts_schema: Optional[_builtins.str] = None,
                 execute_timeout: Optional[_builtins.int] = None,
                 fail_tasks_on_lob_truncation: Optional[_builtins.bool] = None,
                 heartbeat_enable: Optional[_builtins.bool] = None,
                 heartbeat_frequency: Optional[_builtins.int] = None,
                 heartbeat_schema: Optional[_builtins.str] = None,
                 map_boolean_as_boolean: Optional[_builtins.bool] = None,
                 map_jsonb_as_clob: Optional[_builtins.bool] = None,
                 map_long_varchar_as: Optional[_builtins.str] = None,
                 max_file_size: Optional[_builtins.int] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 service_access_role_arn: Optional[_builtins.str] = None,
                 slot_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str after_connect_script: For use with change data capture (CDC) only, this attribute has AWS DMS bypass foreign keys and user triggers to reduce the time it takes to bulk load data.
        :param _builtins.str authentication_method: Specifies the authentication method. Valid values: `password`, `iam`.
        :param _builtins.str babelfish_database_name: The Babelfish for Aurora PostgreSQL database name for the endpoint.
        :param _builtins.bool capture_ddls: To capture DDL events, AWS DMS creates various artifacts in the PostgreSQL database when the task starts.
        :param _builtins.str database_mode: Specifies the default behavior of the replication's handling of PostgreSQL- compatible endpoints that require some additional configuration, such as Babelfish endpoints.
        :param _builtins.str ddl_artifacts_schema: Sets the schema in which the operational DDL database artifacts are created. Default is `public`.
        :param _builtins.int execute_timeout: Sets the client statement timeout for the PostgreSQL instance, in seconds. Default value is `60`.
        :param _builtins.bool fail_tasks_on_lob_truncation: When set to `true`, this value causes a task to fail if the actual size of a LOB column is greater than the specified `LobMaxSize`. Default is `false`.
        :param _builtins.bool heartbeat_enable: The write-ahead log (WAL) heartbeat feature mimics a dummy transaction. By doing this, it prevents idle logical replication slots from holding onto old WAL logs, which can result in storage full situations on the source.
        :param _builtins.int heartbeat_frequency: Sets the WAL heartbeat frequency (in minutes). Default value is `5`.
        :param _builtins.str heartbeat_schema: Sets the schema in which the heartbeat artifacts are created. Default value is `public`.
        :param _builtins.bool map_boolean_as_boolean: You can use PostgreSQL endpoint settings to map a boolean as a boolean from your PostgreSQL source to a Amazon Redshift target. Default value is `false`.
        :param _builtins.bool map_jsonb_as_clob: Optional When true, DMS migrates JSONB values as CLOB.
        :param _builtins.str map_long_varchar_as: Optional When true, DMS migrates LONG values as VARCHAR.
        :param _builtins.int max_file_size: Specifies the maximum size (in KB) of any .csv file used to transfer data to PostgreSQL. Default is `32,768 KB`.
        :param _builtins.str plugin_name: Specifies the plugin to use to create a replication slot. Valid values: `pglogical`, `test_decoding`.
        :param _builtins.str service_access_role_arn: Specifies the IAM role to use to authenticate the connection.
        :param _builtins.str slot_name: Sets the name of a previously created logical replication slot for a CDC load of the PostgreSQL source instance.
        """
        if after_connect_script is not None:
            pulumi.set(__self__, "after_connect_script", after_connect_script)
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if babelfish_database_name is not None:
            pulumi.set(__self__, "babelfish_database_name", babelfish_database_name)
        if capture_ddls is not None:
            pulumi.set(__self__, "capture_ddls", capture_ddls)
        if database_mode is not None:
            pulumi.set(__self__, "database_mode", database_mode)
        if ddl_artifacts_schema is not None:
            pulumi.set(__self__, "ddl_artifacts_schema", ddl_artifacts_schema)
        if execute_timeout is not None:
            pulumi.set(__self__, "execute_timeout", execute_timeout)
        if fail_tasks_on_lob_truncation is not None:
            pulumi.set(__self__, "fail_tasks_on_lob_truncation", fail_tasks_on_lob_truncation)
        if heartbeat_enable is not None:
            pulumi.set(__self__, "heartbeat_enable", heartbeat_enable)
        if heartbeat_frequency is not None:
            pulumi.set(__self__, "heartbeat_frequency", heartbeat_frequency)
        if heartbeat_schema is not None:
            pulumi.set(__self__, "heartbeat_schema", heartbeat_schema)
        if map_boolean_as_boolean is not None:
            pulumi.set(__self__, "map_boolean_as_boolean", map_boolean_as_boolean)
        if map_jsonb_as_clob is not None:
            pulumi.set(__self__, "map_jsonb_as_clob", map_jsonb_as_clob)
        if map_long_varchar_as is not None:
            pulumi.set(__self__, "map_long_varchar_as", map_long_varchar_as)
        if max_file_size is not None:
            pulumi.set(__self__, "max_file_size", max_file_size)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if service_access_role_arn is not None:
            pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        if slot_name is not None:
            pulumi.set(__self__, "slot_name", slot_name)

    @_builtins.property
    @pulumi.getter(name="afterConnectScript")
    def after_connect_script(self) -> Optional[_builtins.str]:
        """
        For use with change data capture (CDC) only, this attribute has AWS DMS bypass foreign keys and user triggers to reduce the time it takes to bulk load data.
        """
        return pulumi.get(self, "after_connect_script")

    @_builtins.property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[_builtins.str]:
        """
        Specifies the authentication method. Valid values: `password`, `iam`.
        """
        return pulumi.get(self, "authentication_method")

    @_builtins.property
    @pulumi.getter(name="babelfishDatabaseName")
    def babelfish_database_name(self) -> Optional[_builtins.str]:
        """
        The Babelfish for Aurora PostgreSQL database name for the endpoint.
        """
        return pulumi.get(self, "babelfish_database_name")

    @_builtins.property
    @pulumi.getter(name="captureDdls")
    def capture_ddls(self) -> Optional[_builtins.bool]:
        """
        To capture DDL events, AWS DMS creates various artifacts in the PostgreSQL database when the task starts.
        """
        return pulumi.get(self, "capture_ddls")

    @_builtins.property
    @pulumi.getter(name="databaseMode")
    def database_mode(self) -> Optional[_builtins.str]:
        """
        Specifies the default behavior of the replication's handling of PostgreSQL- compatible endpoints that require some additional configuration, such as Babelfish endpoints.
        """
        return pulumi.get(self, "database_mode")

    @_builtins.property
    @pulumi.getter(name="ddlArtifactsSchema")
    def ddl_artifacts_schema(self) -> Optional[_builtins.str]:
        """
        Sets the schema in which the operational DDL database artifacts are created. Default is `public`.
        """
        return pulumi.get(self, "ddl_artifacts_schema")

    @_builtins.property
    @pulumi.getter(name="executeTimeout")
    def execute_timeout(self) -> Optional[_builtins.int]:
        """
        Sets the client statement timeout for the PostgreSQL instance, in seconds. Default value is `60`.
        """
        return pulumi.get(self, "execute_timeout")

    @_builtins.property
    @pulumi.getter(name="failTasksOnLobTruncation")
    def fail_tasks_on_lob_truncation(self) -> Optional[_builtins.bool]:
        """
        When set to `true`, this value causes a task to fail if the actual size of a LOB column is greater than the specified `LobMaxSize`. Default is `false`.
        """
        return pulumi.get(self, "fail_tasks_on_lob_truncation")

    @_builtins.property
    @pulumi.getter(name="heartbeatEnable")
    def heartbeat_enable(self) -> Optional[_builtins.bool]:
        """
        The write-ahead log (WAL) heartbeat feature mimics a dummy transaction. By doing this, it prevents idle logical replication slots from holding onto old WAL logs, which can result in storage full situations on the source.
        """
        return pulumi.get(self, "heartbeat_enable")

    @_builtins.property
    @pulumi.getter(name="heartbeatFrequency")
    def heartbeat_frequency(self) -> Optional[_builtins.int]:
        """
        Sets the WAL heartbeat frequency (in minutes). Default value is `5`.
        """
        return pulumi.get(self, "heartbeat_frequency")

    @_builtins.property
    @pulumi.getter(name="heartbeatSchema")
    def heartbeat_schema(self) -> Optional[_builtins.str]:
        """
        Sets the schema in which the heartbeat artifacts are created. Default value is `public`.
        """
        return pulumi.get(self, "heartbeat_schema")

    @_builtins.property
    @pulumi.getter(name="mapBooleanAsBoolean")
    def map_boolean_as_boolean(self) -> Optional[_builtins.bool]:
        """
        You can use PostgreSQL endpoint settings to map a boolean as a boolean from your PostgreSQL source to a Amazon Redshift target. Default value is `false`.
        """
        return pulumi.get(self, "map_boolean_as_boolean")

    @_builtins.property
    @pulumi.getter(name="mapJsonbAsClob")
    def map_jsonb_as_clob(self) -> Optional[_builtins.bool]:
        """
        Optional When true, DMS migrates JSONB values as CLOB.
        """
        return pulumi.get(self, "map_jsonb_as_clob")

    @_builtins.property
    @pulumi.getter(name="mapLongVarcharAs")
    def map_long_varchar_as(self) -> Optional[_builtins.str]:
        """
        Optional When true, DMS migrates LONG values as VARCHAR.
        """
        return pulumi.get(self, "map_long_varchar_as")

    @_builtins.property
    @pulumi.getter(name="maxFileSize")
    def max_file_size(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum size (in KB) of any .csv file used to transfer data to PostgreSQL. Default is `32,768 KB`.
        """
        return pulumi.get(self, "max_file_size")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the plugin to use to create a replication slot. Valid values: `pglogical`, `test_decoding`.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> Optional[_builtins.str]:
        """
        Specifies the IAM role to use to authenticate the connection.
        """
        return pulumi.get(self, "service_access_role_arn")

    @_builtins.property
    @pulumi.getter(name="slotName")
    def slot_name(self) -> Optional[_builtins.str]:
        """
        Sets the name of a previously created logical replication slot for a CDC load of the PostgreSQL source instance.
        """
        return pulumi.get(self, "slot_name")


@pulumi.output_type
class EndpointRedisSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "authPassword":
            suggest = "auth_password"
        elif key == "authUserName":
            suggest = "auth_user_name"
        elif key == "sslCaCertificateArn":
            suggest = "ssl_ca_certificate_arn"
        elif key == "sslSecurityProtocol":
            suggest = "ssl_security_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointRedisSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointRedisSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointRedisSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: _builtins.str,
                 port: _builtins.int,
                 server_name: _builtins.str,
                 auth_password: Optional[_builtins.str] = None,
                 auth_user_name: Optional[_builtins.str] = None,
                 ssl_ca_certificate_arn: Optional[_builtins.str] = None,
                 ssl_security_protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str auth_type: The type of authentication to perform when connecting to a Redis target. Options include `none`, `auth-token`, and `auth-role`. The `auth-token` option requires an `auth_password` value to be provided. The `auth-role` option requires `auth_user_name` and `auth_password` values to be provided.
        :param _builtins.int port: Transmission Control Protocol (TCP) port for the endpoint.
        :param _builtins.str server_name: Fully qualified domain name of the endpoint.
        :param _builtins.str auth_password: The password provided with the auth-role and auth-token options of the AuthType setting for a Redis target endpoint.
        :param _builtins.str auth_user_name: The username provided with the `auth-role` option of the AuthType setting for a Redis target endpoint.
        :param _builtins.str ssl_ca_certificate_arn: The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
        :param _builtins.str ssl_security_protocol: The plaintext option doesn't provide Transport Layer Security (TLS) encryption for traffic between endpoint and database. Options include `plaintext`, `ssl-encryption`. The default is `ssl-encryption`.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        if auth_password is not None:
            pulumi.set(__self__, "auth_password", auth_password)
        if auth_user_name is not None:
            pulumi.set(__self__, "auth_user_name", auth_user_name)
        if ssl_ca_certificate_arn is not None:
            pulumi.set(__self__, "ssl_ca_certificate_arn", ssl_ca_certificate_arn)
        if ssl_security_protocol is not None:
            pulumi.set(__self__, "ssl_security_protocol", ssl_security_protocol)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        """
        The type of authentication to perform when connecting to a Redis target. Options include `none`, `auth-token`, and `auth-role`. The `auth-token` option requires an `auth_password` value to be provided. The `auth-role` option requires `auth_user_name` and `auth_password` values to be provided.
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Transmission Control Protocol (TCP) port for the endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> _builtins.str:
        """
        Fully qualified domain name of the endpoint.
        """
        return pulumi.get(self, "server_name")

    @_builtins.property
    @pulumi.getter(name="authPassword")
    def auth_password(self) -> Optional[_builtins.str]:
        """
        The password provided with the auth-role and auth-token options of the AuthType setting for a Redis target endpoint.
        """
        return pulumi.get(self, "auth_password")

    @_builtins.property
    @pulumi.getter(name="authUserName")
    def auth_user_name(self) -> Optional[_builtins.str]:
        """
        The username provided with the `auth-role` option of the AuthType setting for a Redis target endpoint.
        """
        return pulumi.get(self, "auth_user_name")

    @_builtins.property
    @pulumi.getter(name="sslCaCertificateArn")
    def ssl_ca_certificate_arn(self) -> Optional[_builtins.str]:
        """
        The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
        """
        return pulumi.get(self, "ssl_ca_certificate_arn")

    @_builtins.property
    @pulumi.getter(name="sslSecurityProtocol")
    def ssl_security_protocol(self) -> Optional[_builtins.str]:
        """
        The plaintext option doesn't provide Transport Layer Security (TLS) encryption for traffic between endpoint and database. Options include `plaintext`, `ssl-encryption`. The default is `ssl-encryption`.
        """
        return pulumi.get(self, "ssl_security_protocol")


@pulumi.output_type
class EndpointRedshiftSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketFolder":
            suggest = "bucket_folder"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "encryptionMode":
            suggest = "encryption_mode"
        elif key == "serverSideEncryptionKmsKeyId":
            suggest = "server_side_encryption_kms_key_id"
        elif key == "serviceAccessRoleArn":
            suggest = "service_access_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointRedshiftSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointRedshiftSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointRedshiftSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_folder: Optional[_builtins.str] = None,
                 bucket_name: Optional[_builtins.str] = None,
                 encryption_mode: Optional[_builtins.str] = None,
                 server_side_encryption_kms_key_id: Optional[_builtins.str] = None,
                 service_access_role_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket_folder: Custom S3 Bucket Object prefix for intermediate storage.
        :param _builtins.str bucket_name: Custom S3 Bucket name for intermediate storage.
        :param _builtins.str encryption_mode: The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
        :param _builtins.str server_side_encryption_kms_key_id: ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
        :param _builtins.str service_access_role_arn: Amazon Resource Name (ARN) of the IAM Role with permissions to read from or write to the S3 Bucket for intermediate storage.
        """
        if bucket_folder is not None:
            pulumi.set(__self__, "bucket_folder", bucket_folder)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if encryption_mode is not None:
            pulumi.set(__self__, "encryption_mode", encryption_mode)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if service_access_role_arn is not None:
            pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)

    @_builtins.property
    @pulumi.getter(name="bucketFolder")
    def bucket_folder(self) -> Optional[_builtins.str]:
        """
        Custom S3 Bucket Object prefix for intermediate storage.
        """
        return pulumi.get(self, "bucket_folder")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[_builtins.str]:
        """
        Custom S3 Bucket name for intermediate storage.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> Optional[_builtins.str]:
        """
        The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
        """
        return pulumi.get(self, "encryption_mode")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[_builtins.str]:
        """
        ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @_builtins.property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> Optional[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the IAM Role with permissions to read from or write to the S3 Bucket for intermediate storage.
        """
        return pulumi.get(self, "service_access_role_arn")


@pulumi.output_type
class ReplicationConfigComputeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationSubnetGroupId":
            suggest = "replication_subnet_group_id"
        elif key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "dnsNameServers":
            suggest = "dns_name_servers"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "maxCapacityUnits":
            suggest = "max_capacity_units"
        elif key == "minCapacityUnits":
            suggest = "min_capacity_units"
        elif key == "multiAz":
            suggest = "multi_az"
        elif key == "preferredMaintenanceWindow":
            suggest = "preferred_maintenance_window"
        elif key == "vpcSecurityGroupIds":
            suggest = "vpc_security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationConfigComputeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationConfigComputeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationConfigComputeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_subnet_group_id: _builtins.str,
                 availability_zone: Optional[_builtins.str] = None,
                 dns_name_servers: Optional[_builtins.str] = None,
                 kms_key_id: Optional[_builtins.str] = None,
                 max_capacity_units: Optional[_builtins.int] = None,
                 min_capacity_units: Optional[_builtins.int] = None,
                 multi_az: Optional[_builtins.bool] = None,
                 preferred_maintenance_window: Optional[_builtins.str] = None,
                 vpc_security_group_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str replication_subnet_group_id: Specifies a subnet group identifier to associate with the DMS Serverless replication.
        :param _builtins.str availability_zone: The Availability Zone where the DMS Serverless replication using this configuration will run. The default value is a random.
        :param _builtins.str dns_name_servers: A list of custom DNS name servers supported for the DMS Serverless replication to access your source or target database.
        :param _builtins.str kms_key_id: An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used to encrypt the data during DMS Serverless replication. If you don't specify a value for the KmsKeyId parameter, DMS uses your default encryption key.
        :param _builtins.int max_capacity_units: Specifies the maximum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCUs as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384.
        :param _builtins.int min_capacity_units: Specifies the minimum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. If this value isn't set DMS sets the lowest allowed value, 1.
        :param _builtins.bool multi_az: Specifies if the replication instance is a multi-az deployment. You cannot set the `availability_zone` parameter if the `multi_az` parameter is set to `true`.
        :param _builtins.str preferred_maintenance_window: The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
               
               - Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week.
               - Format: `ddd:hh24:mi-ddd:hh24:mi`
               - Valid Days: `mon, tue, wed, thu, fri, sat, sun`
               - Constraints: Minimum 30-minute window.
        :param Sequence[_builtins.str] vpc_security_group_ids: Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
        """
        pulumi.set(__self__, "replication_subnet_group_id", replication_subnet_group_id)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if dns_name_servers is not None:
            pulumi.set(__self__, "dns_name_servers", dns_name_servers)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if max_capacity_units is not None:
            pulumi.set(__self__, "max_capacity_units", max_capacity_units)
        if min_capacity_units is not None:
            pulumi.set(__self__, "min_capacity_units", min_capacity_units)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @_builtins.property
    @pulumi.getter(name="replicationSubnetGroupId")
    def replication_subnet_group_id(self) -> _builtins.str:
        """
        Specifies a subnet group identifier to associate with the DMS Serverless replication.
        """
        return pulumi.get(self, "replication_subnet_group_id")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[_builtins.str]:
        """
        The Availability Zone where the DMS Serverless replication using this configuration will run. The default value is a random.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="dnsNameServers")
    def dns_name_servers(self) -> Optional[_builtins.str]:
        """
        A list of custom DNS name servers supported for the DMS Serverless replication to access your source or target database.
        """
        return pulumi.get(self, "dns_name_servers")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        """
        An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used to encrypt the data during DMS Serverless replication. If you don't specify a value for the KmsKeyId parameter, DMS uses your default encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="maxCapacityUnits")
    def max_capacity_units(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCUs as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384.
        """
        return pulumi.get(self, "max_capacity_units")

    @_builtins.property
    @pulumi.getter(name="minCapacityUnits")
    def min_capacity_units(self) -> Optional[_builtins.int]:
        """
        Specifies the minimum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. If this value isn't set DMS sets the lowest allowed value, 1.
        """
        return pulumi.get(self, "min_capacity_units")

    @_builtins.property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[_builtins.bool]:
        """
        Specifies if the replication instance is a multi-az deployment. You cannot set the `availability_zone` parameter if the `multi_az` parameter is set to `true`.
        """
        return pulumi.get(self, "multi_az")

    @_builtins.property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[_builtins.str]:
        """
        The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).

        - Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week.
        - Format: `ddd:hh24:mi-ddd:hh24:mi`
        - Valid Days: `mon, tue, wed, thu, fri, sat, sun`
        - Constraints: Minimum 30-minute window.
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @_builtins.property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
        """
        return pulumi.get(self, "vpc_security_group_ids")


@pulumi.output_type
class ReplicationInstanceKerberosAuthenticationSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyCacheSecretIamArn":
            suggest = "key_cache_secret_iam_arn"
        elif key == "keyCacheSecretId":
            suggest = "key_cache_secret_id"
        elif key == "krb5FileContents":
            suggest = "krb5_file_contents"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationInstanceKerberosAuthenticationSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationInstanceKerberosAuthenticationSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationInstanceKerberosAuthenticationSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_cache_secret_iam_arn: _builtins.str,
                 key_cache_secret_id: _builtins.str,
                 krb5_file_contents: _builtins.str):
        """
        :param _builtins.str key_cache_secret_iam_arn: ARN of the IAM role that grants AWS DMS access to the secret containing key cache file for the Kerberos authentication.
        :param _builtins.str key_cache_secret_id: Secret ID that stores the key cache file required for Kerberos authentication.
        :param _builtins.str krb5_file_contents: Contents of krb5 configuration file required for Kerberos authentication.
        """
        pulumi.set(__self__, "key_cache_secret_iam_arn", key_cache_secret_iam_arn)
        pulumi.set(__self__, "key_cache_secret_id", key_cache_secret_id)
        pulumi.set(__self__, "krb5_file_contents", krb5_file_contents)

    @_builtins.property
    @pulumi.getter(name="keyCacheSecretIamArn")
    def key_cache_secret_iam_arn(self) -> _builtins.str:
        """
        ARN of the IAM role that grants AWS DMS access to the secret containing key cache file for the Kerberos authentication.
        """
        return pulumi.get(self, "key_cache_secret_iam_arn")

    @_builtins.property
    @pulumi.getter(name="keyCacheSecretId")
    def key_cache_secret_id(self) -> _builtins.str:
        """
        Secret ID that stores the key cache file required for Kerberos authentication.
        """
        return pulumi.get(self, "key_cache_secret_id")

    @_builtins.property
    @pulumi.getter(name="krb5FileContents")
    def krb5_file_contents(self) -> _builtins.str:
        """
        Contents of krb5 configuration file required for Kerberos authentication.
        """
        return pulumi.get(self, "krb5_file_contents")


@pulumi.output_type
class GetEndpointElasticsearchSettingResult(dict):
    def __init__(__self__, *,
                 endpoint_uri: _builtins.str,
                 error_retry_duration: _builtins.int,
                 full_load_error_percentage: _builtins.int,
                 service_access_role_arn: _builtins.str):
        pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        pulumi.set(__self__, "error_retry_duration", error_retry_duration)
        pulumi.set(__self__, "full_load_error_percentage", full_load_error_percentage)
        pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)

    @_builtins.property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> _builtins.str:
        return pulumi.get(self, "endpoint_uri")

    @_builtins.property
    @pulumi.getter(name="errorRetryDuration")
    def error_retry_duration(self) -> _builtins.int:
        return pulumi.get(self, "error_retry_duration")

    @_builtins.property
    @pulumi.getter(name="fullLoadErrorPercentage")
    def full_load_error_percentage(self) -> _builtins.int:
        return pulumi.get(self, "full_load_error_percentage")

    @_builtins.property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> _builtins.str:
        return pulumi.get(self, "service_access_role_arn")


@pulumi.output_type
class GetEndpointKafkaSettingResult(dict):
    def __init__(__self__, *,
                 broker: _builtins.str,
                 include_control_details: _builtins.bool,
                 include_null_and_empty: _builtins.bool,
                 include_partition_value: _builtins.bool,
                 include_table_alter_operations: _builtins.bool,
                 include_transaction_details: _builtins.bool,
                 message_format: _builtins.str,
                 message_max_bytes: _builtins.int,
                 no_hex_prefix: _builtins.bool,
                 partition_include_schema_table: _builtins.bool,
                 sasl_mechanism: _builtins.str,
                 sasl_password: _builtins.str,
                 sasl_username: _builtins.str,
                 security_protocol: _builtins.str,
                 ssl_ca_certificate_arn: _builtins.str,
                 ssl_client_certificate_arn: _builtins.str,
                 ssl_client_key_arn: _builtins.str,
                 ssl_client_key_password: _builtins.str,
                 topic: _builtins.str):
        pulumi.set(__self__, "broker", broker)
        pulumi.set(__self__, "include_control_details", include_control_details)
        pulumi.set(__self__, "include_null_and_empty", include_null_and_empty)
        pulumi.set(__self__, "include_partition_value", include_partition_value)
        pulumi.set(__self__, "include_table_alter_operations", include_table_alter_operations)
        pulumi.set(__self__, "include_transaction_details", include_transaction_details)
        pulumi.set(__self__, "message_format", message_format)
        pulumi.set(__self__, "message_max_bytes", message_max_bytes)
        pulumi.set(__self__, "no_hex_prefix", no_hex_prefix)
        pulumi.set(__self__, "partition_include_schema_table", partition_include_schema_table)
        pulumi.set(__self__, "sasl_mechanism", sasl_mechanism)
        pulumi.set(__self__, "sasl_password", sasl_password)
        pulumi.set(__self__, "sasl_username", sasl_username)
        pulumi.set(__self__, "security_protocol", security_protocol)
        pulumi.set(__self__, "ssl_ca_certificate_arn", ssl_ca_certificate_arn)
        pulumi.set(__self__, "ssl_client_certificate_arn", ssl_client_certificate_arn)
        pulumi.set(__self__, "ssl_client_key_arn", ssl_client_key_arn)
        pulumi.set(__self__, "ssl_client_key_password", ssl_client_key_password)
        pulumi.set(__self__, "topic", topic)

    @_builtins.property
    @pulumi.getter
    def broker(self) -> _builtins.str:
        return pulumi.get(self, "broker")

    @_builtins.property
    @pulumi.getter(name="includeControlDetails")
    def include_control_details(self) -> _builtins.bool:
        return pulumi.get(self, "include_control_details")

    @_builtins.property
    @pulumi.getter(name="includeNullAndEmpty")
    def include_null_and_empty(self) -> _builtins.bool:
        return pulumi.get(self, "include_null_and_empty")

    @_builtins.property
    @pulumi.getter(name="includePartitionValue")
    def include_partition_value(self) -> _builtins.bool:
        return pulumi.get(self, "include_partition_value")

    @_builtins.property
    @pulumi.getter(name="includeTableAlterOperations")
    def include_table_alter_operations(self) -> _builtins.bool:
        return pulumi.get(self, "include_table_alter_operations")

    @_builtins.property
    @pulumi.getter(name="includeTransactionDetails")
    def include_transaction_details(self) -> _builtins.bool:
        return pulumi.get(self, "include_transaction_details")

    @_builtins.property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> _builtins.str:
        return pulumi.get(self, "message_format")

    @_builtins.property
    @pulumi.getter(name="messageMaxBytes")
    def message_max_bytes(self) -> _builtins.int:
        return pulumi.get(self, "message_max_bytes")

    @_builtins.property
    @pulumi.getter(name="noHexPrefix")
    def no_hex_prefix(self) -> _builtins.bool:
        return pulumi.get(self, "no_hex_prefix")

    @_builtins.property
    @pulumi.getter(name="partitionIncludeSchemaTable")
    def partition_include_schema_table(self) -> _builtins.bool:
        return pulumi.get(self, "partition_include_schema_table")

    @_builtins.property
    @pulumi.getter(name="saslMechanism")
    def sasl_mechanism(self) -> _builtins.str:
        return pulumi.get(self, "sasl_mechanism")

    @_builtins.property
    @pulumi.getter(name="saslPassword")
    def sasl_password(self) -> _builtins.str:
        return pulumi.get(self, "sasl_password")

    @_builtins.property
    @pulumi.getter(name="saslUsername")
    def sasl_username(self) -> _builtins.str:
        return pulumi.get(self, "sasl_username")

    @_builtins.property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> _builtins.str:
        return pulumi.get(self, "security_protocol")

    @_builtins.property
    @pulumi.getter(name="sslCaCertificateArn")
    def ssl_ca_certificate_arn(self) -> _builtins.str:
        return pulumi.get(self, "ssl_ca_certificate_arn")

    @_builtins.property
    @pulumi.getter(name="sslClientCertificateArn")
    def ssl_client_certificate_arn(self) -> _builtins.str:
        return pulumi.get(self, "ssl_client_certificate_arn")

    @_builtins.property
    @pulumi.getter(name="sslClientKeyArn")
    def ssl_client_key_arn(self) -> _builtins.str:
        return pulumi.get(self, "ssl_client_key_arn")

    @_builtins.property
    @pulumi.getter(name="sslClientKeyPassword")
    def ssl_client_key_password(self) -> _builtins.str:
        return pulumi.get(self, "ssl_client_key_password")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> _builtins.str:
        return pulumi.get(self, "topic")


@pulumi.output_type
class GetEndpointKinesisSettingResult(dict):
    def __init__(__self__, *,
                 include_control_details: _builtins.bool,
                 include_null_and_empty: _builtins.bool,
                 include_partition_value: _builtins.bool,
                 include_table_alter_operations: _builtins.bool,
                 include_transaction_details: _builtins.bool,
                 message_format: _builtins.str,
                 partition_include_schema_table: _builtins.bool,
                 service_access_role_arn: _builtins.str,
                 stream_arn: _builtins.str,
                 use_large_integer_value: _builtins.bool):
        pulumi.set(__self__, "include_control_details", include_control_details)
        pulumi.set(__self__, "include_null_and_empty", include_null_and_empty)
        pulumi.set(__self__, "include_partition_value", include_partition_value)
        pulumi.set(__self__, "include_table_alter_operations", include_table_alter_operations)
        pulumi.set(__self__, "include_transaction_details", include_transaction_details)
        pulumi.set(__self__, "message_format", message_format)
        pulumi.set(__self__, "partition_include_schema_table", partition_include_schema_table)
        pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        pulumi.set(__self__, "stream_arn", stream_arn)
        pulumi.set(__self__, "use_large_integer_value", use_large_integer_value)

    @_builtins.property
    @pulumi.getter(name="includeControlDetails")
    def include_control_details(self) -> _builtins.bool:
        return pulumi.get(self, "include_control_details")

    @_builtins.property
    @pulumi.getter(name="includeNullAndEmpty")
    def include_null_and_empty(self) -> _builtins.bool:
        return pulumi.get(self, "include_null_and_empty")

    @_builtins.property
    @pulumi.getter(name="includePartitionValue")
    def include_partition_value(self) -> _builtins.bool:
        return pulumi.get(self, "include_partition_value")

    @_builtins.property
    @pulumi.getter(name="includeTableAlterOperations")
    def include_table_alter_operations(self) -> _builtins.bool:
        return pulumi.get(self, "include_table_alter_operations")

    @_builtins.property
    @pulumi.getter(name="includeTransactionDetails")
    def include_transaction_details(self) -> _builtins.bool:
        return pulumi.get(self, "include_transaction_details")

    @_builtins.property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> _builtins.str:
        return pulumi.get(self, "message_format")

    @_builtins.property
    @pulumi.getter(name="partitionIncludeSchemaTable")
    def partition_include_schema_table(self) -> _builtins.bool:
        return pulumi.get(self, "partition_include_schema_table")

    @_builtins.property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> _builtins.str:
        return pulumi.get(self, "service_access_role_arn")

    @_builtins.property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> _builtins.str:
        return pulumi.get(self, "stream_arn")

    @_builtins.property
    @pulumi.getter(name="useLargeIntegerValue")
    def use_large_integer_value(self) -> _builtins.bool:
        return pulumi.get(self, "use_large_integer_value")


@pulumi.output_type
class GetEndpointMongodbSettingResult(dict):
    def __init__(__self__, *,
                 auth_mechanism: _builtins.str,
                 auth_source: _builtins.str,
                 auth_type: _builtins.str,
                 docs_to_investigate: _builtins.str,
                 extract_doc_id: _builtins.str,
                 nesting_level: _builtins.str):
        pulumi.set(__self__, "auth_mechanism", auth_mechanism)
        pulumi.set(__self__, "auth_source", auth_source)
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "docs_to_investigate", docs_to_investigate)
        pulumi.set(__self__, "extract_doc_id", extract_doc_id)
        pulumi.set(__self__, "nesting_level", nesting_level)

    @_builtins.property
    @pulumi.getter(name="authMechanism")
    def auth_mechanism(self) -> _builtins.str:
        return pulumi.get(self, "auth_mechanism")

    @_builtins.property
    @pulumi.getter(name="authSource")
    def auth_source(self) -> _builtins.str:
        return pulumi.get(self, "auth_source")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="docsToInvestigate")
    def docs_to_investigate(self) -> _builtins.str:
        return pulumi.get(self, "docs_to_investigate")

    @_builtins.property
    @pulumi.getter(name="extractDocId")
    def extract_doc_id(self) -> _builtins.str:
        return pulumi.get(self, "extract_doc_id")

    @_builtins.property
    @pulumi.getter(name="nestingLevel")
    def nesting_level(self) -> _builtins.str:
        return pulumi.get(self, "nesting_level")


@pulumi.output_type
class GetEndpointPostgresSettingResult(dict):
    def __init__(__self__, *,
                 after_connect_script: _builtins.str,
                 authentication_method: _builtins.str,
                 babelfish_database_name: _builtins.str,
                 capture_ddls: _builtins.bool,
                 database_mode: _builtins.str,
                 ddl_artifacts_schema: _builtins.str,
                 execute_timeout: _builtins.int,
                 fail_tasks_on_lob_truncation: _builtins.bool,
                 heartbeat_enable: _builtins.bool,
                 heartbeat_frequency: _builtins.int,
                 heartbeat_schema: _builtins.str,
                 map_boolean_as_boolean: _builtins.bool,
                 map_jsonb_as_clob: _builtins.bool,
                 map_long_varchar_as: _builtins.str,
                 max_file_size: _builtins.int,
                 plugin_name: _builtins.str,
                 service_access_role_arn: _builtins.str,
                 slot_name: _builtins.str):
        pulumi.set(__self__, "after_connect_script", after_connect_script)
        pulumi.set(__self__, "authentication_method", authentication_method)
        pulumi.set(__self__, "babelfish_database_name", babelfish_database_name)
        pulumi.set(__self__, "capture_ddls", capture_ddls)
        pulumi.set(__self__, "database_mode", database_mode)
        pulumi.set(__self__, "ddl_artifacts_schema", ddl_artifacts_schema)
        pulumi.set(__self__, "execute_timeout", execute_timeout)
        pulumi.set(__self__, "fail_tasks_on_lob_truncation", fail_tasks_on_lob_truncation)
        pulumi.set(__self__, "heartbeat_enable", heartbeat_enable)
        pulumi.set(__self__, "heartbeat_frequency", heartbeat_frequency)
        pulumi.set(__self__, "heartbeat_schema", heartbeat_schema)
        pulumi.set(__self__, "map_boolean_as_boolean", map_boolean_as_boolean)
        pulumi.set(__self__, "map_jsonb_as_clob", map_jsonb_as_clob)
        pulumi.set(__self__, "map_long_varchar_as", map_long_varchar_as)
        pulumi.set(__self__, "max_file_size", max_file_size)
        pulumi.set(__self__, "plugin_name", plugin_name)
        pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        pulumi.set(__self__, "slot_name", slot_name)

    @_builtins.property
    @pulumi.getter(name="afterConnectScript")
    def after_connect_script(self) -> _builtins.str:
        return pulumi.get(self, "after_connect_script")

    @_builtins.property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> _builtins.str:
        return pulumi.get(self, "authentication_method")

    @_builtins.property
    @pulumi.getter(name="babelfishDatabaseName")
    def babelfish_database_name(self) -> _builtins.str:
        return pulumi.get(self, "babelfish_database_name")

    @_builtins.property
    @pulumi.getter(name="captureDdls")
    def capture_ddls(self) -> _builtins.bool:
        return pulumi.get(self, "capture_ddls")

    @_builtins.property
    @pulumi.getter(name="databaseMode")
    def database_mode(self) -> _builtins.str:
        return pulumi.get(self, "database_mode")

    @_builtins.property
    @pulumi.getter(name="ddlArtifactsSchema")
    def ddl_artifacts_schema(self) -> _builtins.str:
        return pulumi.get(self, "ddl_artifacts_schema")

    @_builtins.property
    @pulumi.getter(name="executeTimeout")
    def execute_timeout(self) -> _builtins.int:
        return pulumi.get(self, "execute_timeout")

    @_builtins.property
    @pulumi.getter(name="failTasksOnLobTruncation")
    def fail_tasks_on_lob_truncation(self) -> _builtins.bool:
        return pulumi.get(self, "fail_tasks_on_lob_truncation")

    @_builtins.property
    @pulumi.getter(name="heartbeatEnable")
    def heartbeat_enable(self) -> _builtins.bool:
        return pulumi.get(self, "heartbeat_enable")

    @_builtins.property
    @pulumi.getter(name="heartbeatFrequency")
    def heartbeat_frequency(self) -> _builtins.int:
        return pulumi.get(self, "heartbeat_frequency")

    @_builtins.property
    @pulumi.getter(name="heartbeatSchema")
    def heartbeat_schema(self) -> _builtins.str:
        return pulumi.get(self, "heartbeat_schema")

    @_builtins.property
    @pulumi.getter(name="mapBooleanAsBoolean")
    def map_boolean_as_boolean(self) -> _builtins.bool:
        return pulumi.get(self, "map_boolean_as_boolean")

    @_builtins.property
    @pulumi.getter(name="mapJsonbAsClob")
    def map_jsonb_as_clob(self) -> _builtins.bool:
        return pulumi.get(self, "map_jsonb_as_clob")

    @_builtins.property
    @pulumi.getter(name="mapLongVarcharAs")
    def map_long_varchar_as(self) -> _builtins.str:
        return pulumi.get(self, "map_long_varchar_as")

    @_builtins.property
    @pulumi.getter(name="maxFileSize")
    def max_file_size(self) -> _builtins.int:
        return pulumi.get(self, "max_file_size")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> _builtins.str:
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> _builtins.str:
        return pulumi.get(self, "service_access_role_arn")

    @_builtins.property
    @pulumi.getter(name="slotName")
    def slot_name(self) -> _builtins.str:
        return pulumi.get(self, "slot_name")


@pulumi.output_type
class GetEndpointRedisSettingResult(dict):
    def __init__(__self__, *,
                 auth_password: _builtins.str,
                 auth_type: _builtins.str,
                 auth_user_name: _builtins.str,
                 port: _builtins.int,
                 server_name: _builtins.str,
                 ssl_ca_certificate_arn: _builtins.str,
                 ssl_security_protocol: _builtins.str):
        pulumi.set(__self__, "auth_password", auth_password)
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "auth_user_name", auth_user_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "ssl_ca_certificate_arn", ssl_ca_certificate_arn)
        pulumi.set(__self__, "ssl_security_protocol", ssl_security_protocol)

    @_builtins.property
    @pulumi.getter(name="authPassword")
    def auth_password(self) -> _builtins.str:
        return pulumi.get(self, "auth_password")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="authUserName")
    def auth_user_name(self) -> _builtins.str:
        return pulumi.get(self, "auth_user_name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> _builtins.str:
        return pulumi.get(self, "server_name")

    @_builtins.property
    @pulumi.getter(name="sslCaCertificateArn")
    def ssl_ca_certificate_arn(self) -> _builtins.str:
        return pulumi.get(self, "ssl_ca_certificate_arn")

    @_builtins.property
    @pulumi.getter(name="sslSecurityProtocol")
    def ssl_security_protocol(self) -> _builtins.str:
        return pulumi.get(self, "ssl_security_protocol")


@pulumi.output_type
class GetEndpointRedshiftSettingResult(dict):
    def __init__(__self__, *,
                 bucket_folder: _builtins.str,
                 bucket_name: _builtins.str,
                 encryption_mode: _builtins.str,
                 server_side_encryption_kms_key_id: _builtins.str,
                 service_access_role_arn: _builtins.str):
        pulumi.set(__self__, "bucket_folder", bucket_folder)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "encryption_mode", encryption_mode)
        pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)

    @_builtins.property
    @pulumi.getter(name="bucketFolder")
    def bucket_folder(self) -> _builtins.str:
        return pulumi.get(self, "bucket_folder")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> _builtins.str:
        return pulumi.get(self, "encryption_mode")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> _builtins.str:
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @_builtins.property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> _builtins.str:
        return pulumi.get(self, "service_access_role_arn")


@pulumi.output_type
class GetEndpointS3SettingResult(dict):
    def __init__(__self__, *,
                 add_column_name: _builtins.bool,
                 bucket_folder: _builtins.str,
                 bucket_name: _builtins.str,
                 canned_acl_for_objects: _builtins.str,
                 cdc_inserts_and_updates: _builtins.bool,
                 cdc_inserts_only: _builtins.bool,
                 cdc_max_batch_interval: _builtins.int,
                 cdc_min_file_size: _builtins.int,
                 cdc_path: _builtins.str,
                 compression_type: _builtins.str,
                 csv_delimiter: _builtins.str,
                 csv_no_sup_value: _builtins.str,
                 csv_null_value: _builtins.str,
                 csv_row_delimiter: _builtins.str,
                 data_format: _builtins.str,
                 data_page_size: _builtins.int,
                 date_partition_delimiter: _builtins.str,
                 date_partition_enabled: _builtins.bool,
                 date_partition_sequence: _builtins.str,
                 dict_page_size_limit: _builtins.int,
                 enable_statistics: _builtins.bool,
                 encoding_type: _builtins.str,
                 encryption_mode: _builtins.str,
                 external_table_definition: _builtins.str,
                 glue_catalog_generation: _builtins.bool,
                 ignore_header_rows: _builtins.int,
                 ignore_headers_row: _builtins.int,
                 include_op_for_full_load: _builtins.bool,
                 max_file_size: _builtins.int,
                 parquet_timestamp_in_millisecond: _builtins.bool,
                 parquet_version: _builtins.str,
                 preserve_transactions: _builtins.bool,
                 rfc4180: _builtins.bool,
                 row_group_length: _builtins.int,
                 server_side_encryption_kms_key_id: _builtins.str,
                 service_access_role_arn: _builtins.str,
                 timestamp_column_name: _builtins.str,
                 use_csv_no_sup_value: _builtins.bool,
                 use_task_start_time_for_full_load_timestamp: _builtins.bool):
        pulumi.set(__self__, "add_column_name", add_column_name)
        pulumi.set(__self__, "bucket_folder", bucket_folder)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "canned_acl_for_objects", canned_acl_for_objects)
        pulumi.set(__self__, "cdc_inserts_and_updates", cdc_inserts_and_updates)
        pulumi.set(__self__, "cdc_inserts_only", cdc_inserts_only)
        pulumi.set(__self__, "cdc_max_batch_interval", cdc_max_batch_interval)
        pulumi.set(__self__, "cdc_min_file_size", cdc_min_file_size)
        pulumi.set(__self__, "cdc_path", cdc_path)
        pulumi.set(__self__, "compression_type", compression_type)
        pulumi.set(__self__, "csv_delimiter", csv_delimiter)
        pulumi.set(__self__, "csv_no_sup_value", csv_no_sup_value)
        pulumi.set(__self__, "csv_null_value", csv_null_value)
        pulumi.set(__self__, "csv_row_delimiter", csv_row_delimiter)
        pulumi.set(__self__, "data_format", data_format)
        pulumi.set(__self__, "data_page_size", data_page_size)
        pulumi.set(__self__, "date_partition_delimiter", date_partition_delimiter)
        pulumi.set(__self__, "date_partition_enabled", date_partition_enabled)
        pulumi.set(__self__, "date_partition_sequence", date_partition_sequence)
        pulumi.set(__self__, "dict_page_size_limit", dict_page_size_limit)
        pulumi.set(__self__, "enable_statistics", enable_statistics)
        pulumi.set(__self__, "encoding_type", encoding_type)
        pulumi.set(__self__, "encryption_mode", encryption_mode)
        pulumi.set(__self__, "external_table_definition", external_table_definition)
        pulumi.set(__self__, "glue_catalog_generation", glue_catalog_generation)
        pulumi.set(__self__, "ignore_header_rows", ignore_header_rows)
        pulumi.set(__self__, "ignore_headers_row", ignore_headers_row)
        pulumi.set(__self__, "include_op_for_full_load", include_op_for_full_load)
        pulumi.set(__self__, "max_file_size", max_file_size)
        pulumi.set(__self__, "parquet_timestamp_in_millisecond", parquet_timestamp_in_millisecond)
        pulumi.set(__self__, "parquet_version", parquet_version)
        pulumi.set(__self__, "preserve_transactions", preserve_transactions)
        pulumi.set(__self__, "rfc4180", rfc4180)
        pulumi.set(__self__, "row_group_length", row_group_length)
        pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        pulumi.set(__self__, "timestamp_column_name", timestamp_column_name)
        pulumi.set(__self__, "use_csv_no_sup_value", use_csv_no_sup_value)
        pulumi.set(__self__, "use_task_start_time_for_full_load_timestamp", use_task_start_time_for_full_load_timestamp)

    @_builtins.property
    @pulumi.getter(name="addColumnName")
    def add_column_name(self) -> _builtins.bool:
        return pulumi.get(self, "add_column_name")

    @_builtins.property
    @pulumi.getter(name="bucketFolder")
    def bucket_folder(self) -> _builtins.str:
        return pulumi.get(self, "bucket_folder")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="cannedAclForObjects")
    def canned_acl_for_objects(self) -> _builtins.str:
        return pulumi.get(self, "canned_acl_for_objects")

    @_builtins.property
    @pulumi.getter(name="cdcInsertsAndUpdates")
    def cdc_inserts_and_updates(self) -> _builtins.bool:
        return pulumi.get(self, "cdc_inserts_and_updates")

    @_builtins.property
    @pulumi.getter(name="cdcInsertsOnly")
    def cdc_inserts_only(self) -> _builtins.bool:
        return pulumi.get(self, "cdc_inserts_only")

    @_builtins.property
    @pulumi.getter(name="cdcMaxBatchInterval")
    def cdc_max_batch_interval(self) -> _builtins.int:
        return pulumi.get(self, "cdc_max_batch_interval")

    @_builtins.property
    @pulumi.getter(name="cdcMinFileSize")
    def cdc_min_file_size(self) -> _builtins.int:
        return pulumi.get(self, "cdc_min_file_size")

    @_builtins.property
    @pulumi.getter(name="cdcPath")
    def cdc_path(self) -> _builtins.str:
        return pulumi.get(self, "cdc_path")

    @_builtins.property
    @pulumi.getter(name="compressionType")
    def compression_type(self) -> _builtins.str:
        return pulumi.get(self, "compression_type")

    @_builtins.property
    @pulumi.getter(name="csvDelimiter")
    def csv_delimiter(self) -> _builtins.str:
        return pulumi.get(self, "csv_delimiter")

    @_builtins.property
    @pulumi.getter(name="csvNoSupValue")
    def csv_no_sup_value(self) -> _builtins.str:
        return pulumi.get(self, "csv_no_sup_value")

    @_builtins.property
    @pulumi.getter(name="csvNullValue")
    def csv_null_value(self) -> _builtins.str:
        return pulumi.get(self, "csv_null_value")

    @_builtins.property
    @pulumi.getter(name="csvRowDelimiter")
    def csv_row_delimiter(self) -> _builtins.str:
        return pulumi.get(self, "csv_row_delimiter")

    @_builtins.property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> _builtins.str:
        return pulumi.get(self, "data_format")

    @_builtins.property
    @pulumi.getter(name="dataPageSize")
    def data_page_size(self) -> _builtins.int:
        return pulumi.get(self, "data_page_size")

    @_builtins.property
    @pulumi.getter(name="datePartitionDelimiter")
    def date_partition_delimiter(self) -> _builtins.str:
        return pulumi.get(self, "date_partition_delimiter")

    @_builtins.property
    @pulumi.getter(name="datePartitionEnabled")
    def date_partition_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "date_partition_enabled")

    @_builtins.property
    @pulumi.getter(name="datePartitionSequence")
    def date_partition_sequence(self) -> _builtins.str:
        return pulumi.get(self, "date_partition_sequence")

    @_builtins.property
    @pulumi.getter(name="dictPageSizeLimit")
    def dict_page_size_limit(self) -> _builtins.int:
        return pulumi.get(self, "dict_page_size_limit")

    @_builtins.property
    @pulumi.getter(name="enableStatistics")
    def enable_statistics(self) -> _builtins.bool:
        return pulumi.get(self, "enable_statistics")

    @_builtins.property
    @pulumi.getter(name="encodingType")
    def encoding_type(self) -> _builtins.str:
        return pulumi.get(self, "encoding_type")

    @_builtins.property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> _builtins.str:
        return pulumi.get(self, "encryption_mode")

    @_builtins.property
    @pulumi.getter(name="externalTableDefinition")
    def external_table_definition(self) -> _builtins.str:
        return pulumi.get(self, "external_table_definition")

    @_builtins.property
    @pulumi.getter(name="glueCatalogGeneration")
    def glue_catalog_generation(self) -> _builtins.bool:
        return pulumi.get(self, "glue_catalog_generation")

    @_builtins.property
    @pulumi.getter(name="ignoreHeaderRows")
    def ignore_header_rows(self) -> _builtins.int:
        return pulumi.get(self, "ignore_header_rows")

    @_builtins.property
    @pulumi.getter(name="ignoreHeadersRow")
    def ignore_headers_row(self) -> _builtins.int:
        return pulumi.get(self, "ignore_headers_row")

    @_builtins.property
    @pulumi.getter(name="includeOpForFullLoad")
    def include_op_for_full_load(self) -> _builtins.bool:
        return pulumi.get(self, "include_op_for_full_load")

    @_builtins.property
    @pulumi.getter(name="maxFileSize")
    def max_file_size(self) -> _builtins.int:
        return pulumi.get(self, "max_file_size")

    @_builtins.property
    @pulumi.getter(name="parquetTimestampInMillisecond")
    def parquet_timestamp_in_millisecond(self) -> _builtins.bool:
        return pulumi.get(self, "parquet_timestamp_in_millisecond")

    @_builtins.property
    @pulumi.getter(name="parquetVersion")
    def parquet_version(self) -> _builtins.str:
        return pulumi.get(self, "parquet_version")

    @_builtins.property
    @pulumi.getter(name="preserveTransactions")
    def preserve_transactions(self) -> _builtins.bool:
        return pulumi.get(self, "preserve_transactions")

    @_builtins.property
    @pulumi.getter
    def rfc4180(self) -> _builtins.bool:
        return pulumi.get(self, "rfc4180")

    @_builtins.property
    @pulumi.getter(name="rowGroupLength")
    def row_group_length(self) -> _builtins.int:
        return pulumi.get(self, "row_group_length")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> _builtins.str:
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @_builtins.property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> _builtins.str:
        return pulumi.get(self, "service_access_role_arn")

    @_builtins.property
    @pulumi.getter(name="timestampColumnName")
    def timestamp_column_name(self) -> _builtins.str:
        return pulumi.get(self, "timestamp_column_name")

    @_builtins.property
    @pulumi.getter(name="useCsvNoSupValue")
    def use_csv_no_sup_value(self) -> _builtins.bool:
        return pulumi.get(self, "use_csv_no_sup_value")

    @_builtins.property
    @pulumi.getter(name="useTaskStartTimeForFullLoadTimestamp")
    def use_task_start_time_for_full_load_timestamp(self) -> _builtins.bool:
        return pulumi.get(self, "use_task_start_time_for_full_load_timestamp")


