# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterMasterUserSecret',
    'ClusterParameterGroupParameter',
    'ClusterRestoreToPointInTime',
    'ClusterServerlessV2ScalingConfiguration',
    'ElasticClusterTimeouts',
    'GlobalClusterGlobalClusterMember',
]

@pulumi.output_type
class ClusterMasterUserSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "secretArn":
            suggest = "secret_arn"
        elif key == "secretStatus":
            suggest = "secret_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMasterUserSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMasterUserSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMasterUserSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[_builtins.str] = None,
                 secret_arn: Optional[_builtins.str] = None,
                 secret_status: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_id: The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if secret_status is not None:
            pulumi.set(__self__, "secret_status", secret_status)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        """
        The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "secret_arn")

    @_builtins.property
    @pulumi.getter(name="secretStatus")
    def secret_status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "secret_status")


@pulumi.output_type
class ClusterParameterGroupParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyMethod":
            suggest = "apply_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterParameterGroupParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterParameterGroupParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterParameterGroupParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str,
                 apply_method: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the DocumentDB parameter.
        :param _builtins.str value: The value of the DocumentDB parameter.
        :param _builtins.str apply_method: Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if apply_method is not None:
            pulumi.set(__self__, "apply_method", apply_method)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the DocumentDB parameter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the DocumentDB parameter.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="applyMethod")
    def apply_method(self) -> Optional[_builtins.str]:
        """
        Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
        """
        return pulumi.get(self, "apply_method")


@pulumi.output_type
class ClusterRestoreToPointInTime(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceClusterIdentifier":
            suggest = "source_cluster_identifier"
        elif key == "restoreToTime":
            suggest = "restore_to_time"
        elif key == "restoreType":
            suggest = "restore_type"
        elif key == "useLatestRestorableTime":
            suggest = "use_latest_restorable_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterRestoreToPointInTime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterRestoreToPointInTime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterRestoreToPointInTime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_cluster_identifier: _builtins.str,
                 restore_to_time: Optional[_builtins.str] = None,
                 restore_type: Optional[_builtins.str] = None,
                 use_latest_restorable_time: Optional[_builtins.bool] = None):
        """
        :param _builtins.str source_cluster_identifier: The identifier of the source DB cluster from which to restore. Must match the identifier of an existing DB cluster.
        :param _builtins.str restore_to_time: The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
        :param _builtins.str restore_type: The type of restore to be performed. Valid values are `full-copy`, `copy-on-write`.
        :param _builtins.bool use_latest_restorable_time: A boolean value that indicates whether the DB cluster is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_to_time`.
        """
        pulumi.set(__self__, "source_cluster_identifier", source_cluster_identifier)
        if restore_to_time is not None:
            pulumi.set(__self__, "restore_to_time", restore_to_time)
        if restore_type is not None:
            pulumi.set(__self__, "restore_type", restore_type)
        if use_latest_restorable_time is not None:
            pulumi.set(__self__, "use_latest_restorable_time", use_latest_restorable_time)

    @_builtins.property
    @pulumi.getter(name="sourceClusterIdentifier")
    def source_cluster_identifier(self) -> _builtins.str:
        """
        The identifier of the source DB cluster from which to restore. Must match the identifier of an existing DB cluster.
        """
        return pulumi.get(self, "source_cluster_identifier")

    @_builtins.property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> Optional[_builtins.str]:
        """
        The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
        """
        return pulumi.get(self, "restore_to_time")

    @_builtins.property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> Optional[_builtins.str]:
        """
        The type of restore to be performed. Valid values are `full-copy`, `copy-on-write`.
        """
        return pulumi.get(self, "restore_type")

    @_builtins.property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> Optional[_builtins.bool]:
        """
        A boolean value that indicates whether the DB cluster is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_to_time`.
        """
        return pulumi.get(self, "use_latest_restorable_time")


@pulumi.output_type
class ClusterServerlessV2ScalingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServerlessV2ScalingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServerlessV2ScalingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServerlessV2ScalingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: _builtins.float,
                 min_capacity: _builtins.float):
        """
        :param _builtins.float max_capacity: Maximum number of Amazon DocumentDB capacity units (DCUs) for an instance in an Amazon DocumentDB Serverless cluster. Valid values are multiples of 0.5 between 1 and 256.
        :param _builtins.float min_capacity: Minimum number of Amazon DocumentDB capacity units (DCUs) for an instance in an Amazon DocumentDB Serverless cluster. Valid values are multiples of 0.5 between 0.5 and 256.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> _builtins.float:
        """
        Maximum number of Amazon DocumentDB capacity units (DCUs) for an instance in an Amazon DocumentDB Serverless cluster. Valid values are multiples of 0.5 between 1 and 256.
        """
        return pulumi.get(self, "max_capacity")

    @_builtins.property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> _builtins.float:
        """
        Minimum number of Amazon DocumentDB capacity units (DCUs) for an instance in an Amazon DocumentDB Serverless cluster. Valid values are multiples of 0.5 between 0.5 and 256.
        """
        return pulumi.get(self, "min_capacity")


@pulumi.output_type
class ElasticClusterTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class GlobalClusterGlobalClusterMember(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dbClusterArn":
            suggest = "db_cluster_arn"
        elif key == "isWriter":
            suggest = "is_writer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalClusterGlobalClusterMember. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalClusterGlobalClusterMember.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalClusterGlobalClusterMember.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 db_cluster_arn: Optional[_builtins.str] = None,
                 is_writer: Optional[_builtins.bool] = None):
        """
        :param _builtins.str db_cluster_arn: Amazon Resource Name (ARN) of member DB Cluster.
        :param _builtins.bool is_writer: Whether the member is the primary DB Cluster.
        """
        if db_cluster_arn is not None:
            pulumi.set(__self__, "db_cluster_arn", db_cluster_arn)
        if is_writer is not None:
            pulumi.set(__self__, "is_writer", is_writer)

    @_builtins.property
    @pulumi.getter(name="dbClusterArn")
    def db_cluster_arn(self) -> Optional[_builtins.str]:
        """
        Amazon Resource Name (ARN) of member DB Cluster.
        """
        return pulumi.get(self, "db_cluster_arn")

    @_builtins.property
    @pulumi.getter(name="isWriter")
    def is_writer(self) -> Optional[_builtins.bool]:
        """
        Whether the member is the primary DB Cluster.
        """
        return pulumi.get(self, "is_writer")


