# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TableArgs', 'Table']

@pulumi.input_type
class TableArgs:
    def __init__(__self__, *,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['TableAttributeArgs']]]] = None,
                 billing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input['TableGlobalSecondaryIndexArgs']]]] = None,
                 hash_key: Optional[pulumi.Input[_builtins.str]] = None,
                 import_table: Optional[pulumi.Input['TableImportTableArgs']] = None,
                 local_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input['TableLocalSecondaryIndexArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_throughput: Optional[pulumi.Input['TableOnDemandThroughputArgs']] = None,
                 point_in_time_recovery: Optional[pulumi.Input['TablePointInTimeRecoveryArgs']] = None,
                 range_key: Optional[pulumi.Input[_builtins.str]] = None,
                 read_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input['TableReplicaArgs']]]] = None,
                 restore_date_time: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_source_table_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_to_latest_time: Optional[pulumi.Input[_builtins.bool]] = None,
                 server_side_encryption: Optional[pulumi.Input['TableServerSideEncryptionArgs']] = None,
                 stream_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 stream_view_type: Optional[pulumi.Input[_builtins.str]] = None,
                 table_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input['TableTtlArgs']] = None,
                 write_capacity: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Table resource.
        :param pulumi.Input[Sequence[pulumi.Input['TableAttributeArgs']]] attributes: Set of nested attribute definitions. Only required for `hash_key` and `range_key` attributes. See below.
        :param pulumi.Input[_builtins.str] billing_mode: Controls how you are charged for read and write throughput and how you manage capacity. The valid values are `PROVISIONED` and `PAY_PER_REQUEST`. Defaults to `PROVISIONED`.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Enables deletion protection for table. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['TableGlobalSecondaryIndexArgs']]] global_secondary_indexes: Describe a GSI for the table; subject to the normal limits on the number of GSIs, projected attributes, etc. See below.
        :param pulumi.Input[_builtins.str] hash_key: Attribute to use as the hash (partition) key. Must also be defined as an `attribute`. See below.
        :param pulumi.Input['TableImportTableArgs'] import_table: Import Amazon S3 data into a new table. See below.
        :param pulumi.Input[Sequence[pulumi.Input['TableLocalSecondaryIndexArgs']]] local_secondary_indexes: Describe an LSI on the table; these can only be allocated _at creation_ so you cannot change this definition after you have created the resource. See below.
        :param pulumi.Input[_builtins.str] name: Unique within a region name of the table.
               
               The following arguments are optional:
        :param pulumi.Input['TableOnDemandThroughputArgs'] on_demand_throughput: Sets the maximum number of read and write units for the specified on-demand table. See below.
        :param pulumi.Input['TablePointInTimeRecoveryArgs'] point_in_time_recovery: Enable point-in-time recovery options. See below.
        :param pulumi.Input[_builtins.str] range_key: Attribute to use as the range (sort) key. Must also be defined as an `attribute`, see below.
        :param pulumi.Input[_builtins.int] read_capacity: Number of read units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['TableReplicaArgs']]] replicas: Configuration block(s) with [DynamoDB Global Tables V2 (version 2019.11.21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html) replication configurations. See below.
        :param pulumi.Input[_builtins.str] restore_date_time: Time of the point-in-time recovery point to restore.
        :param pulumi.Input[_builtins.str] restore_source_name: Name of the table to restore. Must match the name of an existing table.
        :param pulumi.Input[_builtins.str] restore_source_table_arn: ARN of the source table to restore. Must be supplied for cross-region restores.
        :param pulumi.Input[_builtins.bool] restore_to_latest_time: If set, restores table to the most recent point-in-time recovery point.
        :param pulumi.Input['TableServerSideEncryptionArgs'] server_side_encryption: Encryption at rest options. AWS DynamoDB tables are automatically encrypted at rest with an AWS-owned Customer Master Key if this argument isn't specified. Must be supplied for cross-region restores. See below.
        :param pulumi.Input[_builtins.bool] stream_enabled: Whether Streams are enabled.
        :param pulumi.Input[_builtins.str] stream_view_type: When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values are `KEYS_ONLY`, `NEW_IMAGE`, `OLD_IMAGE`, `NEW_AND_OLD_IMAGES`.
        :param pulumi.Input[_builtins.str] table_class: Storage class of the table.
               Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`.
               Default value is `STANDARD`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['TableTtlArgs'] ttl: Configuration block for TTL. See below.
        :param pulumi.Input[_builtins.int] write_capacity: Number of write units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if billing_mode is not None:
            pulumi.set(__self__, "billing_mode", billing_mode)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if global_secondary_indexes is not None:
            pulumi.set(__self__, "global_secondary_indexes", global_secondary_indexes)
        if hash_key is not None:
            pulumi.set(__self__, "hash_key", hash_key)
        if import_table is not None:
            pulumi.set(__self__, "import_table", import_table)
        if local_secondary_indexes is not None:
            pulumi.set(__self__, "local_secondary_indexes", local_secondary_indexes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_demand_throughput is not None:
            pulumi.set(__self__, "on_demand_throughput", on_demand_throughput)
        if point_in_time_recovery is not None:
            pulumi.set(__self__, "point_in_time_recovery", point_in_time_recovery)
        if range_key is not None:
            pulumi.set(__self__, "range_key", range_key)
        if read_capacity is not None:
            pulumi.set(__self__, "read_capacity", read_capacity)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if restore_date_time is not None:
            pulumi.set(__self__, "restore_date_time", restore_date_time)
        if restore_source_name is not None:
            pulumi.set(__self__, "restore_source_name", restore_source_name)
        if restore_source_table_arn is not None:
            pulumi.set(__self__, "restore_source_table_arn", restore_source_table_arn)
        if restore_to_latest_time is not None:
            pulumi.set(__self__, "restore_to_latest_time", restore_to_latest_time)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if stream_enabled is not None:
            pulumi.set(__self__, "stream_enabled", stream_enabled)
        if stream_view_type is not None:
            pulumi.set(__self__, "stream_view_type", stream_view_type)
        if table_class is not None:
            pulumi.set(__self__, "table_class", table_class)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if write_capacity is not None:
            pulumi.set(__self__, "write_capacity", write_capacity)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableAttributeArgs']]]]:
        """
        Set of nested attribute definitions. Only required for `hash_key` and `range_key` attributes. See below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how you are charged for read and write throughput and how you manage capacity. The valid values are `PROVISIONED` and `PAY_PER_REQUEST`. Defaults to `PROVISIONED`.
        """
        return pulumi.get(self, "billing_mode")

    @billing_mode.setter
    def billing_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_mode", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables deletion protection for table. Defaults to `false`.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="globalSecondaryIndexes")
    def global_secondary_indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableGlobalSecondaryIndexArgs']]]]:
        """
        Describe a GSI for the table; subject to the normal limits on the number of GSIs, projected attributes, etc. See below.
        """
        return pulumi.get(self, "global_secondary_indexes")

    @global_secondary_indexes.setter
    def global_secondary_indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableGlobalSecondaryIndexArgs']]]]):
        pulumi.set(self, "global_secondary_indexes", value)

    @_builtins.property
    @pulumi.getter(name="hashKey")
    def hash_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute to use as the hash (partition) key. Must also be defined as an `attribute`. See below.
        """
        return pulumi.get(self, "hash_key")

    @hash_key.setter
    def hash_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hash_key", value)

    @_builtins.property
    @pulumi.getter(name="importTable")
    def import_table(self) -> Optional[pulumi.Input['TableImportTableArgs']]:
        """
        Import Amazon S3 data into a new table. See below.
        """
        return pulumi.get(self, "import_table")

    @import_table.setter
    def import_table(self, value: Optional[pulumi.Input['TableImportTableArgs']]):
        pulumi.set(self, "import_table", value)

    @_builtins.property
    @pulumi.getter(name="localSecondaryIndexes")
    def local_secondary_indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableLocalSecondaryIndexArgs']]]]:
        """
        Describe an LSI on the table; these can only be allocated _at creation_ so you cannot change this definition after you have created the resource. See below.
        """
        return pulumi.get(self, "local_secondary_indexes")

    @local_secondary_indexes.setter
    def local_secondary_indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableLocalSecondaryIndexArgs']]]]):
        pulumi.set(self, "local_secondary_indexes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique within a region name of the table.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="onDemandThroughput")
    def on_demand_throughput(self) -> Optional[pulumi.Input['TableOnDemandThroughputArgs']]:
        """
        Sets the maximum number of read and write units for the specified on-demand table. See below.
        """
        return pulumi.get(self, "on_demand_throughput")

    @on_demand_throughput.setter
    def on_demand_throughput(self, value: Optional[pulumi.Input['TableOnDemandThroughputArgs']]):
        pulumi.set(self, "on_demand_throughput", value)

    @_builtins.property
    @pulumi.getter(name="pointInTimeRecovery")
    def point_in_time_recovery(self) -> Optional[pulumi.Input['TablePointInTimeRecoveryArgs']]:
        """
        Enable point-in-time recovery options. See below.
        """
        return pulumi.get(self, "point_in_time_recovery")

    @point_in_time_recovery.setter
    def point_in_time_recovery(self, value: Optional[pulumi.Input['TablePointInTimeRecoveryArgs']]):
        pulumi.set(self, "point_in_time_recovery", value)

    @_builtins.property
    @pulumi.getter(name="rangeKey")
    def range_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute to use as the range (sort) key. Must also be defined as an `attribute`, see below.
        """
        return pulumi.get(self, "range_key")

    @range_key.setter
    def range_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "range_key", value)

    @_builtins.property
    @pulumi.getter(name="readCapacity")
    def read_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of read units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        return pulumi.get(self, "read_capacity")

    @read_capacity.setter
    def read_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_capacity", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableReplicaArgs']]]]:
        """
        Configuration block(s) with [DynamoDB Global Tables V2 (version 2019.11.21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html) replication configurations. See below.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableReplicaArgs']]]]):
        pulumi.set(self, "replicas", value)

    @_builtins.property
    @pulumi.getter(name="restoreDateTime")
    def restore_date_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time of the point-in-time recovery point to restore.
        """
        return pulumi.get(self, "restore_date_time")

    @restore_date_time.setter
    def restore_date_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_date_time", value)

    @_builtins.property
    @pulumi.getter(name="restoreSourceName")
    def restore_source_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the table to restore. Must match the name of an existing table.
        """
        return pulumi.get(self, "restore_source_name")

    @restore_source_name.setter
    def restore_source_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_source_name", value)

    @_builtins.property
    @pulumi.getter(name="restoreSourceTableArn")
    def restore_source_table_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the source table to restore. Must be supplied for cross-region restores.
        """
        return pulumi.get(self, "restore_source_table_arn")

    @restore_source_table_arn.setter
    def restore_source_table_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_source_table_arn", value)

    @_builtins.property
    @pulumi.getter(name="restoreToLatestTime")
    def restore_to_latest_time(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, restores table to the most recent point-in-time recovery point.
        """
        return pulumi.get(self, "restore_to_latest_time")

    @restore_to_latest_time.setter
    def restore_to_latest_time(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restore_to_latest_time", value)

    @_builtins.property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[pulumi.Input['TableServerSideEncryptionArgs']]:
        """
        Encryption at rest options. AWS DynamoDB tables are automatically encrypted at rest with an AWS-owned Customer Master Key if this argument isn't specified. Must be supplied for cross-region restores. See below.
        """
        return pulumi.get(self, "server_side_encryption")

    @server_side_encryption.setter
    def server_side_encryption(self, value: Optional[pulumi.Input['TableServerSideEncryptionArgs']]):
        pulumi.set(self, "server_side_encryption", value)

    @_builtins.property
    @pulumi.getter(name="streamEnabled")
    def stream_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Streams are enabled.
        """
        return pulumi.get(self, "stream_enabled")

    @stream_enabled.setter
    def stream_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stream_enabled", value)

    @_builtins.property
    @pulumi.getter(name="streamViewType")
    def stream_view_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values are `KEYS_ONLY`, `NEW_IMAGE`, `OLD_IMAGE`, `NEW_AND_OLD_IMAGES`.
        """
        return pulumi.get(self, "stream_view_type")

    @stream_view_type.setter
    def stream_view_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_view_type", value)

    @_builtins.property
    @pulumi.getter(name="tableClass")
    def table_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Storage class of the table.
        Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`.
        Default value is `STANDARD`.
        """
        return pulumi.get(self, "table_class")

    @table_class.setter
    def table_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_class", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input['TableTtlArgs']]:
        """
        Configuration block for TTL. See below.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input['TableTtlArgs']]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter(name="writeCapacity")
    def write_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of write units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        return pulumi.get(self, "write_capacity")

    @write_capacity.setter
    def write_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "write_capacity", value)


@pulumi.input_type
class _TableState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['TableAttributeArgs']]]] = None,
                 billing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input['TableGlobalSecondaryIndexArgs']]]] = None,
                 hash_key: Optional[pulumi.Input[_builtins.str]] = None,
                 import_table: Optional[pulumi.Input['TableImportTableArgs']] = None,
                 local_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input['TableLocalSecondaryIndexArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_throughput: Optional[pulumi.Input['TableOnDemandThroughputArgs']] = None,
                 point_in_time_recovery: Optional[pulumi.Input['TablePointInTimeRecoveryArgs']] = None,
                 range_key: Optional[pulumi.Input[_builtins.str]] = None,
                 read_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input['TableReplicaArgs']]]] = None,
                 restore_date_time: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_source_table_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_to_latest_time: Optional[pulumi.Input[_builtins.bool]] = None,
                 server_side_encryption: Optional[pulumi.Input['TableServerSideEncryptionArgs']] = None,
                 stream_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 stream_label: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_view_type: Optional[pulumi.Input[_builtins.str]] = None,
                 table_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input['TableTtlArgs']] = None,
                 write_capacity: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Table resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the table
        :param pulumi.Input[Sequence[pulumi.Input['TableAttributeArgs']]] attributes: Set of nested attribute definitions. Only required for `hash_key` and `range_key` attributes. See below.
        :param pulumi.Input[_builtins.str] billing_mode: Controls how you are charged for read and write throughput and how you manage capacity. The valid values are `PROVISIONED` and `PAY_PER_REQUEST`. Defaults to `PROVISIONED`.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Enables deletion protection for table. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['TableGlobalSecondaryIndexArgs']]] global_secondary_indexes: Describe a GSI for the table; subject to the normal limits on the number of GSIs, projected attributes, etc. See below.
        :param pulumi.Input[_builtins.str] hash_key: Attribute to use as the hash (partition) key. Must also be defined as an `attribute`. See below.
        :param pulumi.Input['TableImportTableArgs'] import_table: Import Amazon S3 data into a new table. See below.
        :param pulumi.Input[Sequence[pulumi.Input['TableLocalSecondaryIndexArgs']]] local_secondary_indexes: Describe an LSI on the table; these can only be allocated _at creation_ so you cannot change this definition after you have created the resource. See below.
        :param pulumi.Input[_builtins.str] name: Unique within a region name of the table.
               
               The following arguments are optional:
        :param pulumi.Input['TableOnDemandThroughputArgs'] on_demand_throughput: Sets the maximum number of read and write units for the specified on-demand table. See below.
        :param pulumi.Input['TablePointInTimeRecoveryArgs'] point_in_time_recovery: Enable point-in-time recovery options. See below.
        :param pulumi.Input[_builtins.str] range_key: Attribute to use as the range (sort) key. Must also be defined as an `attribute`, see below.
        :param pulumi.Input[_builtins.int] read_capacity: Number of read units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['TableReplicaArgs']]] replicas: Configuration block(s) with [DynamoDB Global Tables V2 (version 2019.11.21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html) replication configurations. See below.
        :param pulumi.Input[_builtins.str] restore_date_time: Time of the point-in-time recovery point to restore.
        :param pulumi.Input[_builtins.str] restore_source_name: Name of the table to restore. Must match the name of an existing table.
        :param pulumi.Input[_builtins.str] restore_source_table_arn: ARN of the source table to restore. Must be supplied for cross-region restores.
        :param pulumi.Input[_builtins.bool] restore_to_latest_time: If set, restores table to the most recent point-in-time recovery point.
        :param pulumi.Input['TableServerSideEncryptionArgs'] server_side_encryption: Encryption at rest options. AWS DynamoDB tables are automatically encrypted at rest with an AWS-owned Customer Master Key if this argument isn't specified. Must be supplied for cross-region restores. See below.
        :param pulumi.Input[_builtins.str] stream_arn: ARN of the Table Stream. Only available when `stream_enabled = true`
        :param pulumi.Input[_builtins.bool] stream_enabled: Whether Streams are enabled.
        :param pulumi.Input[_builtins.str] stream_label: Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
        :param pulumi.Input[_builtins.str] stream_view_type: When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values are `KEYS_ONLY`, `NEW_IMAGE`, `OLD_IMAGE`, `NEW_AND_OLD_IMAGES`.
        :param pulumi.Input[_builtins.str] table_class: Storage class of the table.
               Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`.
               Default value is `STANDARD`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['TableTtlArgs'] ttl: Configuration block for TTL. See below.
        :param pulumi.Input[_builtins.int] write_capacity: Number of write units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if billing_mode is not None:
            pulumi.set(__self__, "billing_mode", billing_mode)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if global_secondary_indexes is not None:
            pulumi.set(__self__, "global_secondary_indexes", global_secondary_indexes)
        if hash_key is not None:
            pulumi.set(__self__, "hash_key", hash_key)
        if import_table is not None:
            pulumi.set(__self__, "import_table", import_table)
        if local_secondary_indexes is not None:
            pulumi.set(__self__, "local_secondary_indexes", local_secondary_indexes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_demand_throughput is not None:
            pulumi.set(__self__, "on_demand_throughput", on_demand_throughput)
        if point_in_time_recovery is not None:
            pulumi.set(__self__, "point_in_time_recovery", point_in_time_recovery)
        if range_key is not None:
            pulumi.set(__self__, "range_key", range_key)
        if read_capacity is not None:
            pulumi.set(__self__, "read_capacity", read_capacity)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if restore_date_time is not None:
            pulumi.set(__self__, "restore_date_time", restore_date_time)
        if restore_source_name is not None:
            pulumi.set(__self__, "restore_source_name", restore_source_name)
        if restore_source_table_arn is not None:
            pulumi.set(__self__, "restore_source_table_arn", restore_source_table_arn)
        if restore_to_latest_time is not None:
            pulumi.set(__self__, "restore_to_latest_time", restore_to_latest_time)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if stream_arn is not None:
            pulumi.set(__self__, "stream_arn", stream_arn)
        if stream_enabled is not None:
            pulumi.set(__self__, "stream_enabled", stream_enabled)
        if stream_label is not None:
            pulumi.set(__self__, "stream_label", stream_label)
        if stream_view_type is not None:
            pulumi.set(__self__, "stream_view_type", stream_view_type)
        if table_class is not None:
            pulumi.set(__self__, "table_class", table_class)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if write_capacity is not None:
            pulumi.set(__self__, "write_capacity", write_capacity)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the table
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableAttributeArgs']]]]:
        """
        Set of nested attribute definitions. Only required for `hash_key` and `range_key` attributes. See below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how you are charged for read and write throughput and how you manage capacity. The valid values are `PROVISIONED` and `PAY_PER_REQUEST`. Defaults to `PROVISIONED`.
        """
        return pulumi.get(self, "billing_mode")

    @billing_mode.setter
    def billing_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_mode", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables deletion protection for table. Defaults to `false`.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="globalSecondaryIndexes")
    def global_secondary_indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableGlobalSecondaryIndexArgs']]]]:
        """
        Describe a GSI for the table; subject to the normal limits on the number of GSIs, projected attributes, etc. See below.
        """
        return pulumi.get(self, "global_secondary_indexes")

    @global_secondary_indexes.setter
    def global_secondary_indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableGlobalSecondaryIndexArgs']]]]):
        pulumi.set(self, "global_secondary_indexes", value)

    @_builtins.property
    @pulumi.getter(name="hashKey")
    def hash_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute to use as the hash (partition) key. Must also be defined as an `attribute`. See below.
        """
        return pulumi.get(self, "hash_key")

    @hash_key.setter
    def hash_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hash_key", value)

    @_builtins.property
    @pulumi.getter(name="importTable")
    def import_table(self) -> Optional[pulumi.Input['TableImportTableArgs']]:
        """
        Import Amazon S3 data into a new table. See below.
        """
        return pulumi.get(self, "import_table")

    @import_table.setter
    def import_table(self, value: Optional[pulumi.Input['TableImportTableArgs']]):
        pulumi.set(self, "import_table", value)

    @_builtins.property
    @pulumi.getter(name="localSecondaryIndexes")
    def local_secondary_indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableLocalSecondaryIndexArgs']]]]:
        """
        Describe an LSI on the table; these can only be allocated _at creation_ so you cannot change this definition after you have created the resource. See below.
        """
        return pulumi.get(self, "local_secondary_indexes")

    @local_secondary_indexes.setter
    def local_secondary_indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableLocalSecondaryIndexArgs']]]]):
        pulumi.set(self, "local_secondary_indexes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique within a region name of the table.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="onDemandThroughput")
    def on_demand_throughput(self) -> Optional[pulumi.Input['TableOnDemandThroughputArgs']]:
        """
        Sets the maximum number of read and write units for the specified on-demand table. See below.
        """
        return pulumi.get(self, "on_demand_throughput")

    @on_demand_throughput.setter
    def on_demand_throughput(self, value: Optional[pulumi.Input['TableOnDemandThroughputArgs']]):
        pulumi.set(self, "on_demand_throughput", value)

    @_builtins.property
    @pulumi.getter(name="pointInTimeRecovery")
    def point_in_time_recovery(self) -> Optional[pulumi.Input['TablePointInTimeRecoveryArgs']]:
        """
        Enable point-in-time recovery options. See below.
        """
        return pulumi.get(self, "point_in_time_recovery")

    @point_in_time_recovery.setter
    def point_in_time_recovery(self, value: Optional[pulumi.Input['TablePointInTimeRecoveryArgs']]):
        pulumi.set(self, "point_in_time_recovery", value)

    @_builtins.property
    @pulumi.getter(name="rangeKey")
    def range_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute to use as the range (sort) key. Must also be defined as an `attribute`, see below.
        """
        return pulumi.get(self, "range_key")

    @range_key.setter
    def range_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "range_key", value)

    @_builtins.property
    @pulumi.getter(name="readCapacity")
    def read_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of read units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        return pulumi.get(self, "read_capacity")

    @read_capacity.setter
    def read_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_capacity", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableReplicaArgs']]]]:
        """
        Configuration block(s) with [DynamoDB Global Tables V2 (version 2019.11.21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html) replication configurations. See below.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableReplicaArgs']]]]):
        pulumi.set(self, "replicas", value)

    @_builtins.property
    @pulumi.getter(name="restoreDateTime")
    def restore_date_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time of the point-in-time recovery point to restore.
        """
        return pulumi.get(self, "restore_date_time")

    @restore_date_time.setter
    def restore_date_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_date_time", value)

    @_builtins.property
    @pulumi.getter(name="restoreSourceName")
    def restore_source_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the table to restore. Must match the name of an existing table.
        """
        return pulumi.get(self, "restore_source_name")

    @restore_source_name.setter
    def restore_source_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_source_name", value)

    @_builtins.property
    @pulumi.getter(name="restoreSourceTableArn")
    def restore_source_table_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the source table to restore. Must be supplied for cross-region restores.
        """
        return pulumi.get(self, "restore_source_table_arn")

    @restore_source_table_arn.setter
    def restore_source_table_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_source_table_arn", value)

    @_builtins.property
    @pulumi.getter(name="restoreToLatestTime")
    def restore_to_latest_time(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, restores table to the most recent point-in-time recovery point.
        """
        return pulumi.get(self, "restore_to_latest_time")

    @restore_to_latest_time.setter
    def restore_to_latest_time(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restore_to_latest_time", value)

    @_builtins.property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[pulumi.Input['TableServerSideEncryptionArgs']]:
        """
        Encryption at rest options. AWS DynamoDB tables are automatically encrypted at rest with an AWS-owned Customer Master Key if this argument isn't specified. Must be supplied for cross-region restores. See below.
        """
        return pulumi.get(self, "server_side_encryption")

    @server_side_encryption.setter
    def server_side_encryption(self, value: Optional[pulumi.Input['TableServerSideEncryptionArgs']]):
        pulumi.set(self, "server_side_encryption", value)

    @_builtins.property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Table Stream. Only available when `stream_enabled = true`
        """
        return pulumi.get(self, "stream_arn")

    @stream_arn.setter
    def stream_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_arn", value)

    @_builtins.property
    @pulumi.getter(name="streamEnabled")
    def stream_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Streams are enabled.
        """
        return pulumi.get(self, "stream_enabled")

    @stream_enabled.setter
    def stream_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stream_enabled", value)

    @_builtins.property
    @pulumi.getter(name="streamLabel")
    def stream_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
        """
        return pulumi.get(self, "stream_label")

    @stream_label.setter
    def stream_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_label", value)

    @_builtins.property
    @pulumi.getter(name="streamViewType")
    def stream_view_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values are `KEYS_ONLY`, `NEW_IMAGE`, `OLD_IMAGE`, `NEW_AND_OLD_IMAGES`.
        """
        return pulumi.get(self, "stream_view_type")

    @stream_view_type.setter
    def stream_view_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_view_type", value)

    @_builtins.property
    @pulumi.getter(name="tableClass")
    def table_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Storage class of the table.
        Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`.
        Default value is `STANDARD`.
        """
        return pulumi.get(self, "table_class")

    @table_class.setter
    def table_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_class", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input['TableTtlArgs']]:
        """
        Configuration block for TTL. See below.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input['TableTtlArgs']]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter(name="writeCapacity")
    def write_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of write units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        return pulumi.get(self, "write_capacity")

    @write_capacity.setter
    def write_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "write_capacity", value)


@pulumi.type_token("aws:dynamodb/table:Table")
class Table(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableAttributeArgs', 'TableAttributeArgsDict']]]]] = None,
                 billing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableGlobalSecondaryIndexArgs', 'TableGlobalSecondaryIndexArgsDict']]]]] = None,
                 hash_key: Optional[pulumi.Input[_builtins.str]] = None,
                 import_table: Optional[pulumi.Input[Union['TableImportTableArgs', 'TableImportTableArgsDict']]] = None,
                 local_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableLocalSecondaryIndexArgs', 'TableLocalSecondaryIndexArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_throughput: Optional[pulumi.Input[Union['TableOnDemandThroughputArgs', 'TableOnDemandThroughputArgsDict']]] = None,
                 point_in_time_recovery: Optional[pulumi.Input[Union['TablePointInTimeRecoveryArgs', 'TablePointInTimeRecoveryArgsDict']]] = None,
                 range_key: Optional[pulumi.Input[_builtins.str]] = None,
                 read_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableReplicaArgs', 'TableReplicaArgsDict']]]]] = None,
                 restore_date_time: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_source_table_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_to_latest_time: Optional[pulumi.Input[_builtins.bool]] = None,
                 server_side_encryption: Optional[pulumi.Input[Union['TableServerSideEncryptionArgs', 'TableServerSideEncryptionArgsDict']]] = None,
                 stream_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 stream_view_type: Optional[pulumi.Input[_builtins.str]] = None,
                 table_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[Union['TableTtlArgs', 'TableTtlArgsDict']]] = None,
                 write_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a DynamoDB table resource.

        > **Note:** It is recommended to use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) for `read_capacity` and/or `write_capacity` if there's `autoscaling policy` attached to the table.

        > **Note:** When using dynamodb.TableReplica with this resource, use `lifecycle` `ignore_changes` for `replica`, _e.g._, `lifecycle { ignore_changes = [replica] }`.

        ## DynamoDB Table attributes

        Only define attributes on the table object that are going to be used as:

        * Table hash key or range key
        * LSI or GSI hash key or range key

        The DynamoDB API expects attribute structure (name and type) to be passed along when creating or updating GSI/LSIs or creating the initial table. In these cases it expects the Hash / Range keys to be provided. Because these get re-used in numerous places (i.e the table's range key could be a part of one or more GSIs), they are stored on the table object to prevent duplication and increase consistency. If you add attributes here that are not used in these scenarios it can cause an infinite loop in planning.

        ## Example Usage

        ### Basic Example

        The following dynamodb table description models the table and GSI shown in the [AWS SDK example documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.html)

        ```python
        import pulumi
        import pulumi_aws as aws

        basic_dynamodb_table = aws.dynamodb.Table("basic-dynamodb-table",
            name="GameScores",
            billing_mode="PROVISIONED",
            read_capacity=20,
            write_capacity=20,
            hash_key="UserId",
            range_key="GameTitle",
            attributes=[
                {
                    "name": "UserId",
                    "type": "S",
                },
                {
                    "name": "GameTitle",
                    "type": "S",
                },
                {
                    "name": "TopScore",
                    "type": "N",
                },
            ],
            ttl={
                "attribute_name": "TimeToExist",
                "enabled": True,
            },
            global_secondary_indexes=[{
                "name": "GameTitleIndex",
                "hash_key": "GameTitle",
                "range_key": "TopScore",
                "write_capacity": 10,
                "read_capacity": 10,
                "projection_type": "INCLUDE",
                "non_key_attributes": ["UserId"],
            }],
            tags={
                "Name": "dynamodb-table-1",
                "Environment": "production",
            })
        ```

        ### Global Tables

        This resource implements support for [DynamoDB Global Tables V2 (version 2019.11.21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html) via `replica` configuration blocks. For working with [DynamoDB Global Tables V1 (version 2017.11.29)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html), see the `dynamodb.GlobalTable` resource.

        > **Note:** dynamodb.TableReplica is an alternate way of configuring Global Tables. Do not use `replica` configuration blocks of `dynamodb.Table` together with aws_dynamodb_table_replica.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dynamodb.Table("example",
            name="example",
            hash_key="TestTableHashKey",
            billing_mode="PAY_PER_REQUEST",
            stream_enabled=True,
            stream_view_type="NEW_AND_OLD_IMAGES",
            attributes=[{
                "name": "TestTableHashKey",
                "type": "S",
            }],
            replicas=[
                {
                    "region_name": "us-east-2",
                },
                {
                    "region_name": "us-west-2",
                },
            ])
        ```

        ### Global Tables with Multi-Region Strong Consistency

        A global table configured for Multi-Region strong consistency (MRSC) provides the ability to perform a strongly consistent read with multi-Region scope. Performing a strongly consistent read on an MRSC table ensures you're always reading the latest version of an item, irrespective of the Region in which you're performing the read.

        **Note** Please see detailed information, restrictions, caveats etc on the [AWS Support Page](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/multi-region-strong-consistency-gt.html).

        Consistency Mode (`consistency_mode`) is a new argument on the embedded `replica` that allows you to configure consistency mode for Global Tables.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dynamodb.Table("example",
            name="example",
            hash_key="TestTableHashKey",
            billing_mode="PAY_PER_REQUEST",
            stream_enabled=True,
            stream_view_type="NEW_AND_OLD_IMAGES",
            attributes=[{
                "name": "TestTableHashKey",
                "type": "S",
            }],
            replicas=[
                {
                    "region_name": "us-east-2",
                    "consistency_mode": "STRONG",
                },
                {
                    "region_name": "us-west-2",
                    "consistency_mode": "STRONG",
                },
            ])
        ```

        ### Replica Tagging

        You can manage global table replicas' tags in various ways. This example shows using `replica.*.propagate_tags` for the first replica and the `dynamodb.Tag` resource for the other.

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        current = aws.get_region()
        alternate = aws.get_region()
        third = aws.get_region()
        example = aws.dynamodb.Table("example",
            billing_mode="PAY_PER_REQUEST",
            hash_key="TestTableHashKey",
            name="example-13281",
            stream_enabled=True,
            stream_view_type="NEW_AND_OLD_IMAGES",
            attributes=[{
                "name": "TestTableHashKey",
                "type": "S",
            }],
            replicas=[
                {
                    "region_name": alternate.name,
                },
                {
                    "region_name": third.name,
                    "propagate_tags": True,
                },
            ],
            tags={
                "Architect": "Eleanor",
                "Zone": "SW",
            })
        example_tag = aws.dynamodb.Tag("example",
            resource_arn=example.arn.apply(lambda arn: std.replace(text=arn,
                search=current.region,
                replace=alternate.name)).apply(lambda invoke: invoke.result),
            key="Architect",
            value="Gigi")
        ```

        ## Import

        Using `pulumi import`, import DynamoDB tables using the `name`. For example:

        ```sh
        $ pulumi import aws:dynamodb/table:Table basic-dynamodb-table GameScores
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableAttributeArgs', 'TableAttributeArgsDict']]]] attributes: Set of nested attribute definitions. Only required for `hash_key` and `range_key` attributes. See below.
        :param pulumi.Input[_builtins.str] billing_mode: Controls how you are charged for read and write throughput and how you manage capacity. The valid values are `PROVISIONED` and `PAY_PER_REQUEST`. Defaults to `PROVISIONED`.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Enables deletion protection for table. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableGlobalSecondaryIndexArgs', 'TableGlobalSecondaryIndexArgsDict']]]] global_secondary_indexes: Describe a GSI for the table; subject to the normal limits on the number of GSIs, projected attributes, etc. See below.
        :param pulumi.Input[_builtins.str] hash_key: Attribute to use as the hash (partition) key. Must also be defined as an `attribute`. See below.
        :param pulumi.Input[Union['TableImportTableArgs', 'TableImportTableArgsDict']] import_table: Import Amazon S3 data into a new table. See below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableLocalSecondaryIndexArgs', 'TableLocalSecondaryIndexArgsDict']]]] local_secondary_indexes: Describe an LSI on the table; these can only be allocated _at creation_ so you cannot change this definition after you have created the resource. See below.
        :param pulumi.Input[_builtins.str] name: Unique within a region name of the table.
               
               The following arguments are optional:
        :param pulumi.Input[Union['TableOnDemandThroughputArgs', 'TableOnDemandThroughputArgsDict']] on_demand_throughput: Sets the maximum number of read and write units for the specified on-demand table. See below.
        :param pulumi.Input[Union['TablePointInTimeRecoveryArgs', 'TablePointInTimeRecoveryArgsDict']] point_in_time_recovery: Enable point-in-time recovery options. See below.
        :param pulumi.Input[_builtins.str] range_key: Attribute to use as the range (sort) key. Must also be defined as an `attribute`, see below.
        :param pulumi.Input[_builtins.int] read_capacity: Number of read units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableReplicaArgs', 'TableReplicaArgsDict']]]] replicas: Configuration block(s) with [DynamoDB Global Tables V2 (version 2019.11.21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html) replication configurations. See below.
        :param pulumi.Input[_builtins.str] restore_date_time: Time of the point-in-time recovery point to restore.
        :param pulumi.Input[_builtins.str] restore_source_name: Name of the table to restore. Must match the name of an existing table.
        :param pulumi.Input[_builtins.str] restore_source_table_arn: ARN of the source table to restore. Must be supplied for cross-region restores.
        :param pulumi.Input[_builtins.bool] restore_to_latest_time: If set, restores table to the most recent point-in-time recovery point.
        :param pulumi.Input[Union['TableServerSideEncryptionArgs', 'TableServerSideEncryptionArgsDict']] server_side_encryption: Encryption at rest options. AWS DynamoDB tables are automatically encrypted at rest with an AWS-owned Customer Master Key if this argument isn't specified. Must be supplied for cross-region restores. See below.
        :param pulumi.Input[_builtins.bool] stream_enabled: Whether Streams are enabled.
        :param pulumi.Input[_builtins.str] stream_view_type: When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values are `KEYS_ONLY`, `NEW_IMAGE`, `OLD_IMAGE`, `NEW_AND_OLD_IMAGES`.
        :param pulumi.Input[_builtins.str] table_class: Storage class of the table.
               Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`.
               Default value is `STANDARD`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['TableTtlArgs', 'TableTtlArgsDict']] ttl: Configuration block for TTL. See below.
        :param pulumi.Input[_builtins.int] write_capacity: Number of write units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TableArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DynamoDB table resource.

        > **Note:** It is recommended to use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) for `read_capacity` and/or `write_capacity` if there's `autoscaling policy` attached to the table.

        > **Note:** When using dynamodb.TableReplica with this resource, use `lifecycle` `ignore_changes` for `replica`, _e.g._, `lifecycle { ignore_changes = [replica] }`.

        ## DynamoDB Table attributes

        Only define attributes on the table object that are going to be used as:

        * Table hash key or range key
        * LSI or GSI hash key or range key

        The DynamoDB API expects attribute structure (name and type) to be passed along when creating or updating GSI/LSIs or creating the initial table. In these cases it expects the Hash / Range keys to be provided. Because these get re-used in numerous places (i.e the table's range key could be a part of one or more GSIs), they are stored on the table object to prevent duplication and increase consistency. If you add attributes here that are not used in these scenarios it can cause an infinite loop in planning.

        ## Example Usage

        ### Basic Example

        The following dynamodb table description models the table and GSI shown in the [AWS SDK example documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.html)

        ```python
        import pulumi
        import pulumi_aws as aws

        basic_dynamodb_table = aws.dynamodb.Table("basic-dynamodb-table",
            name="GameScores",
            billing_mode="PROVISIONED",
            read_capacity=20,
            write_capacity=20,
            hash_key="UserId",
            range_key="GameTitle",
            attributes=[
                {
                    "name": "UserId",
                    "type": "S",
                },
                {
                    "name": "GameTitle",
                    "type": "S",
                },
                {
                    "name": "TopScore",
                    "type": "N",
                },
            ],
            ttl={
                "attribute_name": "TimeToExist",
                "enabled": True,
            },
            global_secondary_indexes=[{
                "name": "GameTitleIndex",
                "hash_key": "GameTitle",
                "range_key": "TopScore",
                "write_capacity": 10,
                "read_capacity": 10,
                "projection_type": "INCLUDE",
                "non_key_attributes": ["UserId"],
            }],
            tags={
                "Name": "dynamodb-table-1",
                "Environment": "production",
            })
        ```

        ### Global Tables

        This resource implements support for [DynamoDB Global Tables V2 (version 2019.11.21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html) via `replica` configuration blocks. For working with [DynamoDB Global Tables V1 (version 2017.11.29)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html), see the `dynamodb.GlobalTable` resource.

        > **Note:** dynamodb.TableReplica is an alternate way of configuring Global Tables. Do not use `replica` configuration blocks of `dynamodb.Table` together with aws_dynamodb_table_replica.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dynamodb.Table("example",
            name="example",
            hash_key="TestTableHashKey",
            billing_mode="PAY_PER_REQUEST",
            stream_enabled=True,
            stream_view_type="NEW_AND_OLD_IMAGES",
            attributes=[{
                "name": "TestTableHashKey",
                "type": "S",
            }],
            replicas=[
                {
                    "region_name": "us-east-2",
                },
                {
                    "region_name": "us-west-2",
                },
            ])
        ```

        ### Global Tables with Multi-Region Strong Consistency

        A global table configured for Multi-Region strong consistency (MRSC) provides the ability to perform a strongly consistent read with multi-Region scope. Performing a strongly consistent read on an MRSC table ensures you're always reading the latest version of an item, irrespective of the Region in which you're performing the read.

        **Note** Please see detailed information, restrictions, caveats etc on the [AWS Support Page](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/multi-region-strong-consistency-gt.html).

        Consistency Mode (`consistency_mode`) is a new argument on the embedded `replica` that allows you to configure consistency mode for Global Tables.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dynamodb.Table("example",
            name="example",
            hash_key="TestTableHashKey",
            billing_mode="PAY_PER_REQUEST",
            stream_enabled=True,
            stream_view_type="NEW_AND_OLD_IMAGES",
            attributes=[{
                "name": "TestTableHashKey",
                "type": "S",
            }],
            replicas=[
                {
                    "region_name": "us-east-2",
                    "consistency_mode": "STRONG",
                },
                {
                    "region_name": "us-west-2",
                    "consistency_mode": "STRONG",
                },
            ])
        ```

        ### Replica Tagging

        You can manage global table replicas' tags in various ways. This example shows using `replica.*.propagate_tags` for the first replica and the `dynamodb.Tag` resource for the other.

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        current = aws.get_region()
        alternate = aws.get_region()
        third = aws.get_region()
        example = aws.dynamodb.Table("example",
            billing_mode="PAY_PER_REQUEST",
            hash_key="TestTableHashKey",
            name="example-13281",
            stream_enabled=True,
            stream_view_type="NEW_AND_OLD_IMAGES",
            attributes=[{
                "name": "TestTableHashKey",
                "type": "S",
            }],
            replicas=[
                {
                    "region_name": alternate.name,
                },
                {
                    "region_name": third.name,
                    "propagate_tags": True,
                },
            ],
            tags={
                "Architect": "Eleanor",
                "Zone": "SW",
            })
        example_tag = aws.dynamodb.Tag("example",
            resource_arn=example.arn.apply(lambda arn: std.replace(text=arn,
                search=current.region,
                replace=alternate.name)).apply(lambda invoke: invoke.result),
            key="Architect",
            value="Gigi")
        ```

        ## Import

        Using `pulumi import`, import DynamoDB tables using the `name`. For example:

        ```sh
        $ pulumi import aws:dynamodb/table:Table basic-dynamodb-table GameScores
        ```

        :param str resource_name: The name of the resource.
        :param TableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableAttributeArgs', 'TableAttributeArgsDict']]]]] = None,
                 billing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableGlobalSecondaryIndexArgs', 'TableGlobalSecondaryIndexArgsDict']]]]] = None,
                 hash_key: Optional[pulumi.Input[_builtins.str]] = None,
                 import_table: Optional[pulumi.Input[Union['TableImportTableArgs', 'TableImportTableArgsDict']]] = None,
                 local_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableLocalSecondaryIndexArgs', 'TableLocalSecondaryIndexArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_throughput: Optional[pulumi.Input[Union['TableOnDemandThroughputArgs', 'TableOnDemandThroughputArgsDict']]] = None,
                 point_in_time_recovery: Optional[pulumi.Input[Union['TablePointInTimeRecoveryArgs', 'TablePointInTimeRecoveryArgsDict']]] = None,
                 range_key: Optional[pulumi.Input[_builtins.str]] = None,
                 read_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableReplicaArgs', 'TableReplicaArgsDict']]]]] = None,
                 restore_date_time: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_source_table_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_to_latest_time: Optional[pulumi.Input[_builtins.bool]] = None,
                 server_side_encryption: Optional[pulumi.Input[Union['TableServerSideEncryptionArgs', 'TableServerSideEncryptionArgsDict']]] = None,
                 stream_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 stream_view_type: Optional[pulumi.Input[_builtins.str]] = None,
                 table_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[Union['TableTtlArgs', 'TableTtlArgsDict']]] = None,
                 write_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableArgs.__new__(TableArgs)

            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["billing_mode"] = billing_mode
            __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
            __props__.__dict__["global_secondary_indexes"] = global_secondary_indexes
            __props__.__dict__["hash_key"] = hash_key
            __props__.__dict__["import_table"] = import_table
            __props__.__dict__["local_secondary_indexes"] = local_secondary_indexes
            __props__.__dict__["name"] = name
            __props__.__dict__["on_demand_throughput"] = on_demand_throughput
            __props__.__dict__["point_in_time_recovery"] = point_in_time_recovery
            __props__.__dict__["range_key"] = range_key
            __props__.__dict__["read_capacity"] = read_capacity
            __props__.__dict__["region"] = region
            __props__.__dict__["replicas"] = replicas
            __props__.__dict__["restore_date_time"] = restore_date_time
            __props__.__dict__["restore_source_name"] = restore_source_name
            __props__.__dict__["restore_source_table_arn"] = restore_source_table_arn
            __props__.__dict__["restore_to_latest_time"] = restore_to_latest_time
            __props__.__dict__["server_side_encryption"] = server_side_encryption
            __props__.__dict__["stream_enabled"] = stream_enabled
            __props__.__dict__["stream_view_type"] = stream_view_type
            __props__.__dict__["table_class"] = table_class
            __props__.__dict__["tags"] = tags
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["write_capacity"] = write_capacity
            __props__.__dict__["arn"] = None
            __props__.__dict__["stream_arn"] = None
            __props__.__dict__["stream_label"] = None
            __props__.__dict__["tags_all"] = None
        super(Table, __self__).__init__(
            'aws:dynamodb/table:Table',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableAttributeArgs', 'TableAttributeArgsDict']]]]] = None,
            billing_mode: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            global_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableGlobalSecondaryIndexArgs', 'TableGlobalSecondaryIndexArgsDict']]]]] = None,
            hash_key: Optional[pulumi.Input[_builtins.str]] = None,
            import_table: Optional[pulumi.Input[Union['TableImportTableArgs', 'TableImportTableArgsDict']]] = None,
            local_secondary_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableLocalSecondaryIndexArgs', 'TableLocalSecondaryIndexArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            on_demand_throughput: Optional[pulumi.Input[Union['TableOnDemandThroughputArgs', 'TableOnDemandThroughputArgsDict']]] = None,
            point_in_time_recovery: Optional[pulumi.Input[Union['TablePointInTimeRecoveryArgs', 'TablePointInTimeRecoveryArgsDict']]] = None,
            range_key: Optional[pulumi.Input[_builtins.str]] = None,
            read_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableReplicaArgs', 'TableReplicaArgsDict']]]]] = None,
            restore_date_time: Optional[pulumi.Input[_builtins.str]] = None,
            restore_source_name: Optional[pulumi.Input[_builtins.str]] = None,
            restore_source_table_arn: Optional[pulumi.Input[_builtins.str]] = None,
            restore_to_latest_time: Optional[pulumi.Input[_builtins.bool]] = None,
            server_side_encryption: Optional[pulumi.Input[Union['TableServerSideEncryptionArgs', 'TableServerSideEncryptionArgsDict']]] = None,
            stream_arn: Optional[pulumi.Input[_builtins.str]] = None,
            stream_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            stream_label: Optional[pulumi.Input[_builtins.str]] = None,
            stream_view_type: Optional[pulumi.Input[_builtins.str]] = None,
            table_class: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ttl: Optional[pulumi.Input[Union['TableTtlArgs', 'TableTtlArgsDict']]] = None,
            write_capacity: Optional[pulumi.Input[_builtins.int]] = None) -> 'Table':
        """
        Get an existing Table resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the table
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableAttributeArgs', 'TableAttributeArgsDict']]]] attributes: Set of nested attribute definitions. Only required for `hash_key` and `range_key` attributes. See below.
        :param pulumi.Input[_builtins.str] billing_mode: Controls how you are charged for read and write throughput and how you manage capacity. The valid values are `PROVISIONED` and `PAY_PER_REQUEST`. Defaults to `PROVISIONED`.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Enables deletion protection for table. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableGlobalSecondaryIndexArgs', 'TableGlobalSecondaryIndexArgsDict']]]] global_secondary_indexes: Describe a GSI for the table; subject to the normal limits on the number of GSIs, projected attributes, etc. See below.
        :param pulumi.Input[_builtins.str] hash_key: Attribute to use as the hash (partition) key. Must also be defined as an `attribute`. See below.
        :param pulumi.Input[Union['TableImportTableArgs', 'TableImportTableArgsDict']] import_table: Import Amazon S3 data into a new table. See below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableLocalSecondaryIndexArgs', 'TableLocalSecondaryIndexArgsDict']]]] local_secondary_indexes: Describe an LSI on the table; these can only be allocated _at creation_ so you cannot change this definition after you have created the resource. See below.
        :param pulumi.Input[_builtins.str] name: Unique within a region name of the table.
               
               The following arguments are optional:
        :param pulumi.Input[Union['TableOnDemandThroughputArgs', 'TableOnDemandThroughputArgsDict']] on_demand_throughput: Sets the maximum number of read and write units for the specified on-demand table. See below.
        :param pulumi.Input[Union['TablePointInTimeRecoveryArgs', 'TablePointInTimeRecoveryArgsDict']] point_in_time_recovery: Enable point-in-time recovery options. See below.
        :param pulumi.Input[_builtins.str] range_key: Attribute to use as the range (sort) key. Must also be defined as an `attribute`, see below.
        :param pulumi.Input[_builtins.int] read_capacity: Number of read units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableReplicaArgs', 'TableReplicaArgsDict']]]] replicas: Configuration block(s) with [DynamoDB Global Tables V2 (version 2019.11.21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html) replication configurations. See below.
        :param pulumi.Input[_builtins.str] restore_date_time: Time of the point-in-time recovery point to restore.
        :param pulumi.Input[_builtins.str] restore_source_name: Name of the table to restore. Must match the name of an existing table.
        :param pulumi.Input[_builtins.str] restore_source_table_arn: ARN of the source table to restore. Must be supplied for cross-region restores.
        :param pulumi.Input[_builtins.bool] restore_to_latest_time: If set, restores table to the most recent point-in-time recovery point.
        :param pulumi.Input[Union['TableServerSideEncryptionArgs', 'TableServerSideEncryptionArgsDict']] server_side_encryption: Encryption at rest options. AWS DynamoDB tables are automatically encrypted at rest with an AWS-owned Customer Master Key if this argument isn't specified. Must be supplied for cross-region restores. See below.
        :param pulumi.Input[_builtins.str] stream_arn: ARN of the Table Stream. Only available when `stream_enabled = true`
        :param pulumi.Input[_builtins.bool] stream_enabled: Whether Streams are enabled.
        :param pulumi.Input[_builtins.str] stream_label: Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
        :param pulumi.Input[_builtins.str] stream_view_type: When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values are `KEYS_ONLY`, `NEW_IMAGE`, `OLD_IMAGE`, `NEW_AND_OLD_IMAGES`.
        :param pulumi.Input[_builtins.str] table_class: Storage class of the table.
               Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`.
               Default value is `STANDARD`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['TableTtlArgs', 'TableTtlArgsDict']] ttl: Configuration block for TTL. See below.
        :param pulumi.Input[_builtins.int] write_capacity: Number of write units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TableState.__new__(_TableState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["billing_mode"] = billing_mode
        __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
        __props__.__dict__["global_secondary_indexes"] = global_secondary_indexes
        __props__.__dict__["hash_key"] = hash_key
        __props__.__dict__["import_table"] = import_table
        __props__.__dict__["local_secondary_indexes"] = local_secondary_indexes
        __props__.__dict__["name"] = name
        __props__.__dict__["on_demand_throughput"] = on_demand_throughput
        __props__.__dict__["point_in_time_recovery"] = point_in_time_recovery
        __props__.__dict__["range_key"] = range_key
        __props__.__dict__["read_capacity"] = read_capacity
        __props__.__dict__["region"] = region
        __props__.__dict__["replicas"] = replicas
        __props__.__dict__["restore_date_time"] = restore_date_time
        __props__.__dict__["restore_source_name"] = restore_source_name
        __props__.__dict__["restore_source_table_arn"] = restore_source_table_arn
        __props__.__dict__["restore_to_latest_time"] = restore_to_latest_time
        __props__.__dict__["server_side_encryption"] = server_side_encryption
        __props__.__dict__["stream_arn"] = stream_arn
        __props__.__dict__["stream_enabled"] = stream_enabled
        __props__.__dict__["stream_label"] = stream_label
        __props__.__dict__["stream_view_type"] = stream_view_type
        __props__.__dict__["table_class"] = table_class
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["write_capacity"] = write_capacity
        return Table(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the table
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Sequence['outputs.TableAttribute']]:
        """
        Set of nested attribute definitions. Only required for `hash_key` and `range_key` attributes. See below.
        """
        return pulumi.get(self, "attributes")

    @_builtins.property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Controls how you are charged for read and write throughput and how you manage capacity. The valid values are `PROVISIONED` and `PAY_PER_REQUEST`. Defaults to `PROVISIONED`.
        """
        return pulumi.get(self, "billing_mode")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables deletion protection for table. Defaults to `false`.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="globalSecondaryIndexes")
    def global_secondary_indexes(self) -> pulumi.Output[Optional[Sequence['outputs.TableGlobalSecondaryIndex']]]:
        """
        Describe a GSI for the table; subject to the normal limits on the number of GSIs, projected attributes, etc. See below.
        """
        return pulumi.get(self, "global_secondary_indexes")

    @_builtins.property
    @pulumi.getter(name="hashKey")
    def hash_key(self) -> pulumi.Output[_builtins.str]:
        """
        Attribute to use as the hash (partition) key. Must also be defined as an `attribute`. See below.
        """
        return pulumi.get(self, "hash_key")

    @_builtins.property
    @pulumi.getter(name="importTable")
    def import_table(self) -> pulumi.Output[Optional['outputs.TableImportTable']]:
        """
        Import Amazon S3 data into a new table. See below.
        """
        return pulumi.get(self, "import_table")

    @_builtins.property
    @pulumi.getter(name="localSecondaryIndexes")
    def local_secondary_indexes(self) -> pulumi.Output[Optional[Sequence['outputs.TableLocalSecondaryIndex']]]:
        """
        Describe an LSI on the table; these can only be allocated _at creation_ so you cannot change this definition after you have created the resource. See below.
        """
        return pulumi.get(self, "local_secondary_indexes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Unique within a region name of the table.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="onDemandThroughput")
    def on_demand_throughput(self) -> pulumi.Output[Optional['outputs.TableOnDemandThroughput']]:
        """
        Sets the maximum number of read and write units for the specified on-demand table. See below.
        """
        return pulumi.get(self, "on_demand_throughput")

    @_builtins.property
    @pulumi.getter(name="pointInTimeRecovery")
    def point_in_time_recovery(self) -> pulumi.Output['outputs.TablePointInTimeRecovery']:
        """
        Enable point-in-time recovery options. See below.
        """
        return pulumi.get(self, "point_in_time_recovery")

    @_builtins.property
    @pulumi.getter(name="rangeKey")
    def range_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Attribute to use as the range (sort) key. Must also be defined as an `attribute`, see below.
        """
        return pulumi.get(self, "range_key")

    @_builtins.property
    @pulumi.getter(name="readCapacity")
    def read_capacity(self) -> pulumi.Output[_builtins.int]:
        """
        Number of read units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        return pulumi.get(self, "read_capacity")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> pulumi.Output[Optional[Sequence['outputs.TableReplica']]]:
        """
        Configuration block(s) with [DynamoDB Global Tables V2 (version 2019.11.21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html) replication configurations. See below.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="restoreDateTime")
    def restore_date_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time of the point-in-time recovery point to restore.
        """
        return pulumi.get(self, "restore_date_time")

    @_builtins.property
    @pulumi.getter(name="restoreSourceName")
    def restore_source_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the table to restore. Must match the name of an existing table.
        """
        return pulumi.get(self, "restore_source_name")

    @_builtins.property
    @pulumi.getter(name="restoreSourceTableArn")
    def restore_source_table_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of the source table to restore. Must be supplied for cross-region restores.
        """
        return pulumi.get(self, "restore_source_table_arn")

    @_builtins.property
    @pulumi.getter(name="restoreToLatestTime")
    def restore_to_latest_time(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, restores table to the most recent point-in-time recovery point.
        """
        return pulumi.get(self, "restore_to_latest_time")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> pulumi.Output['outputs.TableServerSideEncryption']:
        """
        Encryption at rest options. AWS DynamoDB tables are automatically encrypted at rest with an AWS-owned Customer Master Key if this argument isn't specified. Must be supplied for cross-region restores. See below.
        """
        return pulumi.get(self, "server_side_encryption")

    @_builtins.property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Table Stream. Only available when `stream_enabled = true`
        """
        return pulumi.get(self, "stream_arn")

    @_builtins.property
    @pulumi.getter(name="streamEnabled")
    def stream_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether Streams are enabled.
        """
        return pulumi.get(self, "stream_enabled")

    @_builtins.property
    @pulumi.getter(name="streamLabel")
    def stream_label(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
        """
        return pulumi.get(self, "stream_label")

    @_builtins.property
    @pulumi.getter(name="streamViewType")
    def stream_view_type(self) -> pulumi.Output[_builtins.str]:
        """
        When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values are `KEYS_ONLY`, `NEW_IMAGE`, `OLD_IMAGE`, `NEW_AND_OLD_IMAGES`.
        """
        return pulumi.get(self, "stream_view_type")

    @_builtins.property
    @pulumi.getter(name="tableClass")
    def table_class(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Storage class of the table.
        Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`.
        Default value is `STANDARD`.
        """
        return pulumi.get(self, "table_class")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output['outputs.TableTtl']:
        """
        Configuration block for TTL. See below.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter(name="writeCapacity")
    def write_capacity(self) -> pulumi.Output[_builtins.int]:
        """
        Number of write units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        return pulumi.get(self, "write_capacity")

