# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TableReplicaInitArgs', 'TableReplica']

@pulumi.input_type
class TableReplicaInitArgs:
    def __init__(__self__, *,
                 global_table_arn: pulumi.Input[_builtins.str],
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 point_in_time_recovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 table_class_override: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a TableReplica resource.
        :param pulumi.Input[_builtins.str] global_table_arn: ARN of the _main_ or global table which this resource will replicate.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Whether deletion protection is enabled (true) or disabled (false) on the table replica.
        :param pulumi.Input[_builtins.str] kms_key_arn: ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        :param pulumi.Input[_builtins.bool] point_in_time_recovery: Whether to enable Point In Time Recovery for the table replica. Default is `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] table_class_override: Storage class of the table replica. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`. If not used, the table replica will use the same class as the global table.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "global_table_arn", global_table_arn)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if point_in_time_recovery is not None:
            pulumi.set(__self__, "point_in_time_recovery", point_in_time_recovery)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if table_class_override is not None:
            pulumi.set(__self__, "table_class_override", table_class_override)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="globalTableArn")
    def global_table_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the _main_ or global table which this resource will replicate.

        The following arguments are optional:
        """
        return pulumi.get(self, "global_table_arn")

    @global_table_arn.setter
    def global_table_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "global_table_arn", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether deletion protection is enabled (true) or disabled (false) on the table replica.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @_builtins.property
    @pulumi.getter(name="pointInTimeRecovery")
    def point_in_time_recovery(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable Point In Time Recovery for the table replica. Default is `false`.
        """
        return pulumi.get(self, "point_in_time_recovery")

    @point_in_time_recovery.setter
    def point_in_time_recovery(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "point_in_time_recovery", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tableClassOverride")
    def table_class_override(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Storage class of the table replica. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`. If not used, the table replica will use the same class as the global table.
        """
        return pulumi.get(self, "table_class_override")

    @table_class_override.setter
    def table_class_override(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_class_override", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _TableReplicaState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_table_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 point_in_time_recovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 table_class_override: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering TableReplica resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the table replica.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Whether deletion protection is enabled (true) or disabled (false) on the table replica.
        :param pulumi.Input[_builtins.str] global_table_arn: ARN of the _main_ or global table which this resource will replicate.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] kms_key_arn: ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        :param pulumi.Input[_builtins.bool] point_in_time_recovery: Whether to enable Point In Time Recovery for the table replica. Default is `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] table_class_override: Storage class of the table replica. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`. If not used, the table replica will use the same class as the global table.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if global_table_arn is not None:
            pulumi.set(__self__, "global_table_arn", global_table_arn)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if point_in_time_recovery is not None:
            pulumi.set(__self__, "point_in_time_recovery", point_in_time_recovery)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if table_class_override is not None:
            pulumi.set(__self__, "table_class_override", table_class_override)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the table replica.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether deletion protection is enabled (true) or disabled (false) on the table replica.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="globalTableArn")
    def global_table_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the _main_ or global table which this resource will replicate.

        The following arguments are optional:
        """
        return pulumi.get(self, "global_table_arn")

    @global_table_arn.setter
    def global_table_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_table_arn", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @_builtins.property
    @pulumi.getter(name="pointInTimeRecovery")
    def point_in_time_recovery(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable Point In Time Recovery for the table replica. Default is `false`.
        """
        return pulumi.get(self, "point_in_time_recovery")

    @point_in_time_recovery.setter
    def point_in_time_recovery(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "point_in_time_recovery", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tableClassOverride")
    def table_class_override(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Storage class of the table replica. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`. If not used, the table replica will use the same class as the global table.
        """
        return pulumi.get(self, "table_class_override")

    @table_class_override.setter
    def table_class_override(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_class_override", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:dynamodb/tableReplica:TableReplica")
class TableReplica(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_table_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 point_in_time_recovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 table_class_override: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a DynamoDB table replica resource for [DynamoDB Global Tables V2 (version 2019.11.21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html).

        > **Note:** Use `lifecycle` `ignore_changes` for `replica` in the associated dynamodb.Table configuration.

        > **Note:** Do not use the `replica` configuration block of dynamodb.Table together with this resource as the two configuration options are mutually exclusive.

        ## Example Usage

        ### Basic Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dynamodb.Table("example",
            name="TestTable",
            hash_key="BrodoBaggins",
            billing_mode="PAY_PER_REQUEST",
            stream_enabled=True,
            stream_view_type="NEW_AND_OLD_IMAGES",
            attributes=[{
                "name": "BrodoBaggins",
                "type": "S",
            }])
        example_table_replica = aws.dynamodb.TableReplica("example",
            global_table_arn=example.arn,
            tags={
                "Name": "IZPAWS",
                "Pozo": "Amargo",
            })
        ```

        ## Import

        Using `pulumi import`, import DynamoDB table replicas using the `table-name:main-region`. For example:

        ~> __Note:__ When importing, use the region where the initial or _main_ global table resides, _not_ the region of the replica.

        ```sh
        $ pulumi import aws:dynamodb/tableReplica:TableReplica example TestTable:us-west-2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Whether deletion protection is enabled (true) or disabled (false) on the table replica.
        :param pulumi.Input[_builtins.str] global_table_arn: ARN of the _main_ or global table which this resource will replicate.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] kms_key_arn: ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        :param pulumi.Input[_builtins.bool] point_in_time_recovery: Whether to enable Point In Time Recovery for the table replica. Default is `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] table_class_override: Storage class of the table replica. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`. If not used, the table replica will use the same class as the global table.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TableReplicaInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DynamoDB table replica resource for [DynamoDB Global Tables V2 (version 2019.11.21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html).

        > **Note:** Use `lifecycle` `ignore_changes` for `replica` in the associated dynamodb.Table configuration.

        > **Note:** Do not use the `replica` configuration block of dynamodb.Table together with this resource as the two configuration options are mutually exclusive.

        ## Example Usage

        ### Basic Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dynamodb.Table("example",
            name="TestTable",
            hash_key="BrodoBaggins",
            billing_mode="PAY_PER_REQUEST",
            stream_enabled=True,
            stream_view_type="NEW_AND_OLD_IMAGES",
            attributes=[{
                "name": "BrodoBaggins",
                "type": "S",
            }])
        example_table_replica = aws.dynamodb.TableReplica("example",
            global_table_arn=example.arn,
            tags={
                "Name": "IZPAWS",
                "Pozo": "Amargo",
            })
        ```

        ## Import

        Using `pulumi import`, import DynamoDB table replicas using the `table-name:main-region`. For example:

        ~> __Note:__ When importing, use the region where the initial or _main_ global table resides, _not_ the region of the replica.

        ```sh
        $ pulumi import aws:dynamodb/tableReplica:TableReplica example TestTable:us-west-2
        ```

        :param str resource_name: The name of the resource.
        :param TableReplicaInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableReplicaInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_table_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 point_in_time_recovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 table_class_override: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableReplicaInitArgs.__new__(TableReplicaInitArgs)

            __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
            if global_table_arn is None and not opts.urn:
                raise TypeError("Missing required property 'global_table_arn'")
            __props__.__dict__["global_table_arn"] = global_table_arn
            __props__.__dict__["kms_key_arn"] = kms_key_arn
            __props__.__dict__["point_in_time_recovery"] = point_in_time_recovery
            __props__.__dict__["region"] = region
            __props__.__dict__["table_class_override"] = table_class_override
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(TableReplica, __self__).__init__(
            'aws:dynamodb/tableReplica:TableReplica',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            global_table_arn: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
            point_in_time_recovery: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            table_class_override: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'TableReplica':
        """
        Get an existing TableReplica resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the table replica.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Whether deletion protection is enabled (true) or disabled (false) on the table replica.
        :param pulumi.Input[_builtins.str] global_table_arn: ARN of the _main_ or global table which this resource will replicate.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] kms_key_arn: ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        :param pulumi.Input[_builtins.bool] point_in_time_recovery: Whether to enable Point In Time Recovery for the table replica. Default is `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] table_class_override: Storage class of the table replica. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`. If not used, the table replica will use the same class as the global table.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TableReplicaState.__new__(_TableReplicaState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
        __props__.__dict__["global_table_arn"] = global_table_arn
        __props__.__dict__["kms_key_arn"] = kms_key_arn
        __props__.__dict__["point_in_time_recovery"] = point_in_time_recovery
        __props__.__dict__["region"] = region
        __props__.__dict__["table_class_override"] = table_class_override
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return TableReplica(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the table replica.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether deletion protection is enabled (true) or disabled (false) on the table replica.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="globalTableArn")
    def global_table_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the _main_ or global table which this resource will replicate.

        The following arguments are optional:
        """
        return pulumi.get(self, "global_table_arn")

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        """
        return pulumi.get(self, "kms_key_arn")

    @_builtins.property
    @pulumi.getter(name="pointInTimeRecovery")
    def point_in_time_recovery(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable Point In Time Recovery for the table replica. Default is `false`.
        """
        return pulumi.get(self, "point_in_time_recovery")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="tableClassOverride")
    def table_class_override(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Storage class of the table replica. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`. If not used, the table replica will use the same class as the global table.
        """
        return pulumi.get(self, "table_class_override")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to populate on the created table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

