# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AmiFromInstanceArgs', 'AmiFromInstance']

@pulumi.input_type
class AmiFromInstanceArgs:
    def __init__(__self__, *,
                 source_instance_id: pulumi.Input[_builtins.str],
                 deprecation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEbsBlockDeviceArgs']]]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEphemeralBlockDeviceArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_without_reboot: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AmiFromInstance resource.
        :param pulumi.Input[_builtins.str] source_instance_id: ID of the instance to use as the basis of the AMI.
        :param pulumi.Input[_builtins.str] deprecation_time: Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        :param pulumi.Input[_builtins.str] description: Longer, human-readable description for the AMI.
        :param pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEbsBlockDeviceArgs']]] ebs_block_devices: Nested block describing an EBS block device that should be
               attached to created instances. The structure of this block is described below.
        :param pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEphemeralBlockDeviceArgs']]] ephemeral_block_devices: Nested block describing an ephemeral block device that
               should be attached to created instances. The structure of this block is described below.
        :param pulumi.Input[_builtins.str] name: Region-unique name for the AMI.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] snapshot_without_reboot: Boolean that overrides the behavior of stopping
               the instance before snapshotting. This is risky since it may cause a snapshot of an
               inconsistent filesystem state, but can be used to avoid downtime if the user otherwise
               guarantees that no filesystem writes will be underway at the time of snapshot.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "source_instance_id", source_instance_id)
        if deprecation_time is not None:
            pulumi.set(__self__, "deprecation_time", deprecation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if snapshot_without_reboot is not None:
            pulumi.set(__self__, "snapshot_without_reboot", snapshot_without_reboot)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="sourceInstanceId")
    def source_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the instance to use as the basis of the AMI.
        """
        return pulumi.get(self, "source_instance_id")

    @source_instance_id.setter
    def source_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="deprecationTime")
    def deprecation_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        """
        return pulumi.get(self, "deprecation_time")

    @deprecation_time.setter
    def deprecation_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deprecation_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Longer, human-readable description for the AMI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEbsBlockDeviceArgs']]]]:
        """
        Nested block describing an EBS block device that should be
        attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEphemeralBlockDeviceArgs']]]]:
        """
        Nested block describing an ephemeral block device that
        should be attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region-unique name for the AMI.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="snapshotWithoutReboot")
    def snapshot_without_reboot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that overrides the behavior of stopping
        the instance before snapshotting. This is risky since it may cause a snapshot of an
        inconsistent filesystem state, but can be used to avoid downtime if the user otherwise
        guarantees that no filesystem writes will be underway at the time of snapshot.
        """
        return pulumi.get(self, "snapshot_without_reboot")

    @snapshot_without_reboot.setter
    def snapshot_without_reboot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "snapshot_without_reboot", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AmiFromInstanceState:
    def __init__(__self__, *,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 deprecation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEbsBlockDeviceArgs']]]] = None,
                 ena_support: Optional[pulumi.Input[_builtins.bool]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEphemeralBlockDeviceArgs']]]] = None,
                 hypervisor: Optional[pulumi.Input[_builtins.str]] = None,
                 image_location: Optional[pulumi.Input[_builtins.str]] = None,
                 image_owner_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 image_type: Optional[pulumi.Input[_builtins.str]] = None,
                 imds_support: Optional[pulumi.Input[_builtins.str]] = None,
                 kernel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_launched_time: Optional[pulumi.Input[_builtins.str]] = None,
                 manage_ebs_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 platform_details: Optional[pulumi.Input[_builtins.str]] = None,
                 public: Optional[pulumi.Input[_builtins.bool]] = None,
                 ramdisk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 root_device_name: Optional[pulumi.Input[_builtins.str]] = None,
                 root_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_without_reboot: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sriov_net_support: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tpm_support: Optional[pulumi.Input[_builtins.str]] = None,
                 uefi_data: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_operation: Optional[pulumi.Input[_builtins.str]] = None,
                 virtualization_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AmiFromInstance resources.
        :param pulumi.Input[_builtins.str] architecture: Machine architecture for created instances. Defaults to `x86_64`.
        :param pulumi.Input[_builtins.str] arn: ARN of the AMI.
        :param pulumi.Input[_builtins.str] boot_mode: Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[_builtins.str] deprecation_time: Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        :param pulumi.Input[_builtins.str] description: Longer, human-readable description for the AMI.
        :param pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEbsBlockDeviceArgs']]] ebs_block_devices: Nested block describing an EBS block device that should be
               attached to created instances. The structure of this block is described below.
        :param pulumi.Input[_builtins.bool] ena_support: Whether enhanced networking with ENA is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEphemeralBlockDeviceArgs']]] ephemeral_block_devices: Nested block describing an ephemeral block device that
               should be attached to created instances. The structure of this block is described below.
        :param pulumi.Input[_builtins.str] image_location: Path to an S3 object containing an image manifest, e.g., created
               by the `ec2-upload-bundle` command in the EC2 command line tools.
        :param pulumi.Input[_builtins.str] imds_support: If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
        :param pulumi.Input[_builtins.str] kernel_id: ID of the kernel image (AKI) that will be used as the paravirtual
               kernel in created instances.
        :param pulumi.Input[_builtins.str] last_launched_time: Date and time, in ISO 8601 date-time format , when the AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay before that usage is reported. For more information, see the following [AWS document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-last-launched-time.html).
        :param pulumi.Input[_builtins.str] name: Region-unique name for the AMI.
        :param pulumi.Input[_builtins.str] ramdisk_id: ID of an initrd image (ARI) that will be used when booting the
               created instances.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] root_device_name: Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        :param pulumi.Input[_builtins.bool] snapshot_without_reboot: Boolean that overrides the behavior of stopping
               the instance before snapshotting. This is risky since it may cause a snapshot of an
               inconsistent filesystem state, but can be used to avoid downtime if the user otherwise
               guarantees that no filesystem writes will be underway at the time of snapshot.
        :param pulumi.Input[_builtins.str] source_instance_id: ID of the instance to use as the basis of the AMI.
        :param pulumi.Input[_builtins.str] sriov_net_support: When set to "simple" (the default), enables enhanced networking
               for created instances. No other value is supported at this time.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] tpm_support: If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[_builtins.str] uefi_data: Base64 representation of the non-volatile UEFI variable store.
        :param pulumi.Input[_builtins.str] virtualization_type: Keyword to choose what virtualization mode created instances
               will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
               changes the set of further arguments that are required, as described below.
        """
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if boot_mode is not None:
            pulumi.set(__self__, "boot_mode", boot_mode)
        if deprecation_time is not None:
            pulumi.set(__self__, "deprecation_time", deprecation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if ena_support is not None:
            pulumi.set(__self__, "ena_support", ena_support)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if hypervisor is not None:
            pulumi.set(__self__, "hypervisor", hypervisor)
        if image_location is not None:
            pulumi.set(__self__, "image_location", image_location)
        if image_owner_alias is not None:
            pulumi.set(__self__, "image_owner_alias", image_owner_alias)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if imds_support is not None:
            pulumi.set(__self__, "imds_support", imds_support)
        if kernel_id is not None:
            pulumi.set(__self__, "kernel_id", kernel_id)
        if last_launched_time is not None:
            pulumi.set(__self__, "last_launched_time", last_launched_time)
        if manage_ebs_snapshots is not None:
            pulumi.set(__self__, "manage_ebs_snapshots", manage_ebs_snapshots)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if platform_details is not None:
            pulumi.set(__self__, "platform_details", platform_details)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if ramdisk_id is not None:
            pulumi.set(__self__, "ramdisk_id", ramdisk_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_device_name is not None:
            pulumi.set(__self__, "root_device_name", root_device_name)
        if root_snapshot_id is not None:
            pulumi.set(__self__, "root_snapshot_id", root_snapshot_id)
        if snapshot_without_reboot is not None:
            pulumi.set(__self__, "snapshot_without_reboot", snapshot_without_reboot)
        if source_instance_id is not None:
            pulumi.set(__self__, "source_instance_id", source_instance_id)
        if sriov_net_support is not None:
            pulumi.set(__self__, "sriov_net_support", sriov_net_support)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if tpm_support is not None:
            pulumi.set(__self__, "tpm_support", tpm_support)
        if uefi_data is not None:
            pulumi.set(__self__, "uefi_data", uefi_data)
        if usage_operation is not None:
            pulumi.set(__self__, "usage_operation", usage_operation)
        if virtualization_type is not None:
            pulumi.set(__self__, "virtualization_type", virtualization_type)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Machine architecture for created instances. Defaults to `x86_64`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "architecture", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the AMI.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="bootMode")
    def boot_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
        """
        return pulumi.get(self, "boot_mode")

    @boot_mode.setter
    def boot_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "boot_mode", value)

    @_builtins.property
    @pulumi.getter(name="deprecationTime")
    def deprecation_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        """
        return pulumi.get(self, "deprecation_time")

    @deprecation_time.setter
    def deprecation_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deprecation_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Longer, human-readable description for the AMI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEbsBlockDeviceArgs']]]]:
        """
        Nested block describing an EBS block device that should be
        attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @_builtins.property
    @pulumi.getter(name="enaSupport")
    def ena_support(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enhanced networking with ENA is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "ena_support")

    @ena_support.setter
    def ena_support(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ena_support", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEphemeralBlockDeviceArgs']]]]:
        """
        Nested block describing an ephemeral block device that
        should be attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AmiFromInstanceEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @_builtins.property
    @pulumi.getter
    def hypervisor(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "hypervisor")

    @hypervisor.setter
    def hypervisor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hypervisor", value)

    @_builtins.property
    @pulumi.getter(name="imageLocation")
    def image_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to an S3 object containing an image manifest, e.g., created
        by the `ec2-upload-bundle` command in the EC2 command line tools.
        """
        return pulumi.get(self, "image_location")

    @image_location.setter
    def image_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_location", value)

    @_builtins.property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "image_owner_alias")

    @image_owner_alias.setter
    def image_owner_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_owner_alias", value)

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_type", value)

    @_builtins.property
    @pulumi.getter(name="imdsSupport")
    def imds_support(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
        """
        return pulumi.get(self, "imds_support")

    @imds_support.setter
    def imds_support(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "imds_support", value)

    @_builtins.property
    @pulumi.getter(name="kernelId")
    def kernel_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the kernel image (AKI) that will be used as the paravirtual
        kernel in created instances.
        """
        return pulumi.get(self, "kernel_id")

    @kernel_id.setter
    def kernel_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kernel_id", value)

    @_builtins.property
    @pulumi.getter(name="lastLaunchedTime")
    def last_launched_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time, in ISO 8601 date-time format , when the AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay before that usage is reported. For more information, see the following [AWS document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-last-launched-time.html).
        """
        return pulumi.get(self, "last_launched_time")

    @last_launched_time.setter
    def last_launched_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_launched_time", value)

    @_builtins.property
    @pulumi.getter(name="manageEbsSnapshots")
    def manage_ebs_snapshots(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "manage_ebs_snapshots")

    @manage_ebs_snapshots.setter
    def manage_ebs_snapshots(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "manage_ebs_snapshots", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region-unique name for the AMI.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_id", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="platformDetails")
    def platform_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "platform_details")

    @platform_details.setter
    def platform_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform_details", value)

    @_builtins.property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public", value)

    @_builtins.property
    @pulumi.getter(name="ramdiskId")
    def ramdisk_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of an initrd image (ARI) that will be used when booting the
        created instances.
        """
        return pulumi.get(self, "ramdisk_id")

    @ramdisk_id.setter
    def ramdisk_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ramdisk_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rootDeviceName")
    def root_device_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        """
        return pulumi.get(self, "root_device_name")

    @root_device_name.setter
    def root_device_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_device_name", value)

    @_builtins.property
    @pulumi.getter(name="rootSnapshotId")
    def root_snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "root_snapshot_id")

    @root_snapshot_id.setter
    def root_snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotWithoutReboot")
    def snapshot_without_reboot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that overrides the behavior of stopping
        the instance before snapshotting. This is risky since it may cause a snapshot of an
        inconsistent filesystem state, but can be used to avoid downtime if the user otherwise
        guarantees that no filesystem writes will be underway at the time of snapshot.
        """
        return pulumi.get(self, "snapshot_without_reboot")

    @snapshot_without_reboot.setter
    def snapshot_without_reboot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "snapshot_without_reboot", value)

    @_builtins.property
    @pulumi.getter(name="sourceInstanceId")
    def source_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the instance to use as the basis of the AMI.
        """
        return pulumi.get(self, "source_instance_id")

    @source_instance_id.setter
    def source_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="sriovNetSupport")
    def sriov_net_support(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When set to "simple" (the default), enables enhanced networking
        for created instances. No other value is supported at this time.
        """
        return pulumi.get(self, "sriov_net_support")

    @sriov_net_support.setter
    def sriov_net_support(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sriov_net_support", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="tpmSupport")
    def tpm_support(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
        """
        return pulumi.get(self, "tpm_support")

    @tpm_support.setter
    def tpm_support(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpm_support", value)

    @_builtins.property
    @pulumi.getter(name="uefiData")
    def uefi_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64 representation of the non-volatile UEFI variable store.
        """
        return pulumi.get(self, "uefi_data")

    @uefi_data.setter
    def uefi_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uefi_data", value)

    @_builtins.property
    @pulumi.getter(name="usageOperation")
    def usage_operation(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "usage_operation")

    @usage_operation.setter
    def usage_operation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usage_operation", value)

    @_builtins.property
    @pulumi.getter(name="virtualizationType")
    def virtualization_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Keyword to choose what virtualization mode created instances
        will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
        changes the set of further arguments that are required, as described below.
        """
        return pulumi.get(self, "virtualization_type")

    @virtualization_type.setter
    def virtualization_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtualization_type", value)


@pulumi.type_token("aws:ec2/amiFromInstance:AmiFromInstance")
class AmiFromInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deprecation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiFromInstanceEbsBlockDeviceArgs', 'AmiFromInstanceEbsBlockDeviceArgsDict']]]]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiFromInstanceEphemeralBlockDeviceArgs', 'AmiFromInstanceEphemeralBlockDeviceArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_without_reboot: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        The "AMI from instance" resource allows the creation of an Amazon Machine
        Image (AMI) modeled after an existing EBS-backed EC2 instance.

        The created AMI will refer to implicitly-created snapshots of the instance's
        EBS volumes and mimick its assigned block device configuration at the time
        the resource is created.

        This resource is best applied to an instance that is stopped when this instance
        is created, so that the contents of the created image are predictable. When
        applied to an instance that is running, *the instance will be stopped before taking
        the snapshots and then started back up again*, resulting in a period of
        downtime.

        Note that the source instance is inspected only at the initial creation of this
        resource. Ongoing updates to the referenced instance will not be propagated into
        the generated AMI. Users may taint or otherwise recreate the resource in order
        to produce a fresh snapshot.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.AmiFromInstance("example",
            name="example",
            source_instance_id="i-xxxxxxxx")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] deprecation_time: Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        :param pulumi.Input[_builtins.str] description: Longer, human-readable description for the AMI.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AmiFromInstanceEbsBlockDeviceArgs', 'AmiFromInstanceEbsBlockDeviceArgsDict']]]] ebs_block_devices: Nested block describing an EBS block device that should be
               attached to created instances. The structure of this block is described below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AmiFromInstanceEphemeralBlockDeviceArgs', 'AmiFromInstanceEphemeralBlockDeviceArgsDict']]]] ephemeral_block_devices: Nested block describing an ephemeral block device that
               should be attached to created instances. The structure of this block is described below.
        :param pulumi.Input[_builtins.str] name: Region-unique name for the AMI.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] snapshot_without_reboot: Boolean that overrides the behavior of stopping
               the instance before snapshotting. This is risky since it may cause a snapshot of an
               inconsistent filesystem state, but can be used to avoid downtime if the user otherwise
               guarantees that no filesystem writes will be underway at the time of snapshot.
        :param pulumi.Input[_builtins.str] source_instance_id: ID of the instance to use as the basis of the AMI.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AmiFromInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The "AMI from instance" resource allows the creation of an Amazon Machine
        Image (AMI) modeled after an existing EBS-backed EC2 instance.

        The created AMI will refer to implicitly-created snapshots of the instance's
        EBS volumes and mimick its assigned block device configuration at the time
        the resource is created.

        This resource is best applied to an instance that is stopped when this instance
        is created, so that the contents of the created image are predictable. When
        applied to an instance that is running, *the instance will be stopped before taking
        the snapshots and then started back up again*, resulting in a period of
        downtime.

        Note that the source instance is inspected only at the initial creation of this
        resource. Ongoing updates to the referenced instance will not be propagated into
        the generated AMI. Users may taint or otherwise recreate the resource in order
        to produce a fresh snapshot.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.AmiFromInstance("example",
            name="example",
            source_instance_id="i-xxxxxxxx")
        ```

        :param str resource_name: The name of the resource.
        :param AmiFromInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AmiFromInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deprecation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiFromInstanceEbsBlockDeviceArgs', 'AmiFromInstanceEbsBlockDeviceArgsDict']]]]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiFromInstanceEphemeralBlockDeviceArgs', 'AmiFromInstanceEphemeralBlockDeviceArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_without_reboot: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AmiFromInstanceArgs.__new__(AmiFromInstanceArgs)

            __props__.__dict__["deprecation_time"] = deprecation_time
            __props__.__dict__["description"] = description
            __props__.__dict__["ebs_block_devices"] = ebs_block_devices
            __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["snapshot_without_reboot"] = snapshot_without_reboot
            if source_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_instance_id'")
            __props__.__dict__["source_instance_id"] = source_instance_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["architecture"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["boot_mode"] = None
            __props__.__dict__["ena_support"] = None
            __props__.__dict__["hypervisor"] = None
            __props__.__dict__["image_location"] = None
            __props__.__dict__["image_owner_alias"] = None
            __props__.__dict__["image_type"] = None
            __props__.__dict__["imds_support"] = None
            __props__.__dict__["kernel_id"] = None
            __props__.__dict__["last_launched_time"] = None
            __props__.__dict__["manage_ebs_snapshots"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["platform"] = None
            __props__.__dict__["platform_details"] = None
            __props__.__dict__["public"] = None
            __props__.__dict__["ramdisk_id"] = None
            __props__.__dict__["root_device_name"] = None
            __props__.__dict__["root_snapshot_id"] = None
            __props__.__dict__["sriov_net_support"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["tpm_support"] = None
            __props__.__dict__["uefi_data"] = None
            __props__.__dict__["usage_operation"] = None
            __props__.__dict__["virtualization_type"] = None
        super(AmiFromInstance, __self__).__init__(
            'aws:ec2/amiFromInstance:AmiFromInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            architecture: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            boot_mode: Optional[pulumi.Input[_builtins.str]] = None,
            deprecation_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiFromInstanceEbsBlockDeviceArgs', 'AmiFromInstanceEbsBlockDeviceArgsDict']]]]] = None,
            ena_support: Optional[pulumi.Input[_builtins.bool]] = None,
            ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiFromInstanceEphemeralBlockDeviceArgs', 'AmiFromInstanceEphemeralBlockDeviceArgsDict']]]]] = None,
            hypervisor: Optional[pulumi.Input[_builtins.str]] = None,
            image_location: Optional[pulumi.Input[_builtins.str]] = None,
            image_owner_alias: Optional[pulumi.Input[_builtins.str]] = None,
            image_type: Optional[pulumi.Input[_builtins.str]] = None,
            imds_support: Optional[pulumi.Input[_builtins.str]] = None,
            kernel_id: Optional[pulumi.Input[_builtins.str]] = None,
            last_launched_time: Optional[pulumi.Input[_builtins.str]] = None,
            manage_ebs_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            platform: Optional[pulumi.Input[_builtins.str]] = None,
            platform_details: Optional[pulumi.Input[_builtins.str]] = None,
            public: Optional[pulumi.Input[_builtins.bool]] = None,
            ramdisk_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            root_device_name: Optional[pulumi.Input[_builtins.str]] = None,
            root_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_without_reboot: Optional[pulumi.Input[_builtins.bool]] = None,
            source_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            sriov_net_support: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tpm_support: Optional[pulumi.Input[_builtins.str]] = None,
            uefi_data: Optional[pulumi.Input[_builtins.str]] = None,
            usage_operation: Optional[pulumi.Input[_builtins.str]] = None,
            virtualization_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AmiFromInstance':
        """
        Get an existing AmiFromInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] architecture: Machine architecture for created instances. Defaults to `x86_64`.
        :param pulumi.Input[_builtins.str] arn: ARN of the AMI.
        :param pulumi.Input[_builtins.str] boot_mode: Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[_builtins.str] deprecation_time: Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        :param pulumi.Input[_builtins.str] description: Longer, human-readable description for the AMI.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AmiFromInstanceEbsBlockDeviceArgs', 'AmiFromInstanceEbsBlockDeviceArgsDict']]]] ebs_block_devices: Nested block describing an EBS block device that should be
               attached to created instances. The structure of this block is described below.
        :param pulumi.Input[_builtins.bool] ena_support: Whether enhanced networking with ENA is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AmiFromInstanceEphemeralBlockDeviceArgs', 'AmiFromInstanceEphemeralBlockDeviceArgsDict']]]] ephemeral_block_devices: Nested block describing an ephemeral block device that
               should be attached to created instances. The structure of this block is described below.
        :param pulumi.Input[_builtins.str] image_location: Path to an S3 object containing an image manifest, e.g., created
               by the `ec2-upload-bundle` command in the EC2 command line tools.
        :param pulumi.Input[_builtins.str] imds_support: If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
        :param pulumi.Input[_builtins.str] kernel_id: ID of the kernel image (AKI) that will be used as the paravirtual
               kernel in created instances.
        :param pulumi.Input[_builtins.str] last_launched_time: Date and time, in ISO 8601 date-time format , when the AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay before that usage is reported. For more information, see the following [AWS document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-last-launched-time.html).
        :param pulumi.Input[_builtins.str] name: Region-unique name for the AMI.
        :param pulumi.Input[_builtins.str] ramdisk_id: ID of an initrd image (ARI) that will be used when booting the
               created instances.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] root_device_name: Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        :param pulumi.Input[_builtins.bool] snapshot_without_reboot: Boolean that overrides the behavior of stopping
               the instance before snapshotting. This is risky since it may cause a snapshot of an
               inconsistent filesystem state, but can be used to avoid downtime if the user otherwise
               guarantees that no filesystem writes will be underway at the time of snapshot.
        :param pulumi.Input[_builtins.str] source_instance_id: ID of the instance to use as the basis of the AMI.
        :param pulumi.Input[_builtins.str] sriov_net_support: When set to "simple" (the default), enables enhanced networking
               for created instances. No other value is supported at this time.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] tpm_support: If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[_builtins.str] uefi_data: Base64 representation of the non-volatile UEFI variable store.
        :param pulumi.Input[_builtins.str] virtualization_type: Keyword to choose what virtualization mode created instances
               will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
               changes the set of further arguments that are required, as described below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AmiFromInstanceState.__new__(_AmiFromInstanceState)

        __props__.__dict__["architecture"] = architecture
        __props__.__dict__["arn"] = arn
        __props__.__dict__["boot_mode"] = boot_mode
        __props__.__dict__["deprecation_time"] = deprecation_time
        __props__.__dict__["description"] = description
        __props__.__dict__["ebs_block_devices"] = ebs_block_devices
        __props__.__dict__["ena_support"] = ena_support
        __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
        __props__.__dict__["hypervisor"] = hypervisor
        __props__.__dict__["image_location"] = image_location
        __props__.__dict__["image_owner_alias"] = image_owner_alias
        __props__.__dict__["image_type"] = image_type
        __props__.__dict__["imds_support"] = imds_support
        __props__.__dict__["kernel_id"] = kernel_id
        __props__.__dict__["last_launched_time"] = last_launched_time
        __props__.__dict__["manage_ebs_snapshots"] = manage_ebs_snapshots
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["platform"] = platform
        __props__.__dict__["platform_details"] = platform_details
        __props__.__dict__["public"] = public
        __props__.__dict__["ramdisk_id"] = ramdisk_id
        __props__.__dict__["region"] = region
        __props__.__dict__["root_device_name"] = root_device_name
        __props__.__dict__["root_snapshot_id"] = root_snapshot_id
        __props__.__dict__["snapshot_without_reboot"] = snapshot_without_reboot
        __props__.__dict__["source_instance_id"] = source_instance_id
        __props__.__dict__["sriov_net_support"] = sriov_net_support
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["tpm_support"] = tpm_support
        __props__.__dict__["uefi_data"] = uefi_data
        __props__.__dict__["usage_operation"] = usage_operation
        __props__.__dict__["virtualization_type"] = virtualization_type
        return AmiFromInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[_builtins.str]:
        """
        Machine architecture for created instances. Defaults to `x86_64`.
        """
        return pulumi.get(self, "architecture")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the AMI.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="bootMode")
    def boot_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
        """
        return pulumi.get(self, "boot_mode")

    @_builtins.property
    @pulumi.getter(name="deprecationTime")
    def deprecation_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        """
        return pulumi.get(self, "deprecation_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Longer, human-readable description for the AMI.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> pulumi.Output[Sequence['outputs.AmiFromInstanceEbsBlockDevice']]:
        """
        Nested block describing an EBS block device that should be
        attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ebs_block_devices")

    @_builtins.property
    @pulumi.getter(name="enaSupport")
    def ena_support(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether enhanced networking with ENA is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "ena_support")

    @_builtins.property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> pulumi.Output[Sequence['outputs.AmiFromInstanceEphemeralBlockDevice']]:
        """
        Nested block describing an ephemeral block device that
        should be attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @_builtins.property
    @pulumi.getter
    def hypervisor(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "hypervisor")

    @_builtins.property
    @pulumi.getter(name="imageLocation")
    def image_location(self) -> pulumi.Output[_builtins.str]:
        """
        Path to an S3 object containing an image manifest, e.g., created
        by the `ec2-upload-bundle` command in the EC2 command line tools.
        """
        return pulumi.get(self, "image_location")

    @_builtins.property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "image_owner_alias")

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "image_type")

    @_builtins.property
    @pulumi.getter(name="imdsSupport")
    def imds_support(self) -> pulumi.Output[_builtins.str]:
        """
        If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
        """
        return pulumi.get(self, "imds_support")

    @_builtins.property
    @pulumi.getter(name="kernelId")
    def kernel_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the kernel image (AKI) that will be used as the paravirtual
        kernel in created instances.
        """
        return pulumi.get(self, "kernel_id")

    @_builtins.property
    @pulumi.getter(name="lastLaunchedTime")
    def last_launched_time(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time, in ISO 8601 date-time format , when the AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay before that usage is reported. For more information, see the following [AWS document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-last-launched-time.html).
        """
        return pulumi.get(self, "last_launched_time")

    @_builtins.property
    @pulumi.getter(name="manageEbsSnapshots")
    def manage_ebs_snapshots(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "manage_ebs_snapshots")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Region-unique name for the AMI.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="platformDetails")
    def platform_details(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "platform_details")

    @_builtins.property
    @pulumi.getter
    def public(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "public")

    @_builtins.property
    @pulumi.getter(name="ramdiskId")
    def ramdisk_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of an initrd image (ARI) that will be used when booting the
        created instances.
        """
        return pulumi.get(self, "ramdisk_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rootDeviceName")
    def root_device_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        """
        return pulumi.get(self, "root_device_name")

    @_builtins.property
    @pulumi.getter(name="rootSnapshotId")
    def root_snapshot_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "root_snapshot_id")

    @_builtins.property
    @pulumi.getter(name="snapshotWithoutReboot")
    def snapshot_without_reboot(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that overrides the behavior of stopping
        the instance before snapshotting. This is risky since it may cause a snapshot of an
        inconsistent filesystem state, but can be used to avoid downtime if the user otherwise
        guarantees that no filesystem writes will be underway at the time of snapshot.
        """
        return pulumi.get(self, "snapshot_without_reboot")

    @_builtins.property
    @pulumi.getter(name="sourceInstanceId")
    def source_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the instance to use as the basis of the AMI.
        """
        return pulumi.get(self, "source_instance_id")

    @_builtins.property
    @pulumi.getter(name="sriovNetSupport")
    def sriov_net_support(self) -> pulumi.Output[_builtins.str]:
        """
        When set to "simple" (the default), enables enhanced networking
        for created instances. No other value is supported at this time.
        """
        return pulumi.get(self, "sriov_net_support")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="tpmSupport")
    def tpm_support(self) -> pulumi.Output[_builtins.str]:
        """
        If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
        """
        return pulumi.get(self, "tpm_support")

    @_builtins.property
    @pulumi.getter(name="uefiData")
    def uefi_data(self) -> pulumi.Output[_builtins.str]:
        """
        Base64 representation of the non-volatile UEFI variable store.
        """
        return pulumi.get(self, "uefi_data")

    @_builtins.property
    @pulumi.getter(name="usageOperation")
    def usage_operation(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "usage_operation")

    @_builtins.property
    @pulumi.getter(name="virtualizationType")
    def virtualization_type(self) -> pulumi.Output[_builtins.str]:
        """
        Keyword to choose what virtualization mode created instances
        will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
        changes the set of further arguments that are required, as described below.
        """
        return pulumi.get(self, "virtualization_type")

