# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCapacityBlockOfferingResult',
    'AwaitableGetCapacityBlockOfferingResult',
    'get_capacity_block_offering',
    'get_capacity_block_offering_output',
]

@pulumi.output_type
class GetCapacityBlockOfferingResult:
    """
    A collection of values returned by getCapacityBlockOffering.
    """
    def __init__(__self__, availability_zone=None, capacity_block_offering_id=None, capacity_duration_hours=None, currency_code=None, end_date_range=None, id=None, instance_count=None, instance_type=None, region=None, start_date_range=None, tenancy=None, upfront_fee=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if capacity_block_offering_id and not isinstance(capacity_block_offering_id, str):
            raise TypeError("Expected argument 'capacity_block_offering_id' to be a str")
        pulumi.set(__self__, "capacity_block_offering_id", capacity_block_offering_id)
        if capacity_duration_hours and not isinstance(capacity_duration_hours, int):
            raise TypeError("Expected argument 'capacity_duration_hours' to be a int")
        pulumi.set(__self__, "capacity_duration_hours", capacity_duration_hours)
        if currency_code and not isinstance(currency_code, str):
            raise TypeError("Expected argument 'currency_code' to be a str")
        pulumi.set(__self__, "currency_code", currency_code)
        if end_date_range and not isinstance(end_date_range, str):
            raise TypeError("Expected argument 'end_date_range' to be a str")
        pulumi.set(__self__, "end_date_range", end_date_range)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_count and not isinstance(instance_count, int):
            raise TypeError("Expected argument 'instance_count' to be a int")
        pulumi.set(__self__, "instance_count", instance_count)
        if instance_type and not isinstance(instance_type, str):
            raise TypeError("Expected argument 'instance_type' to be a str")
        pulumi.set(__self__, "instance_type", instance_type)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if start_date_range and not isinstance(start_date_range, str):
            raise TypeError("Expected argument 'start_date_range' to be a str")
        pulumi.set(__self__, "start_date_range", start_date_range)
        if tenancy and not isinstance(tenancy, str):
            raise TypeError("Expected argument 'tenancy' to be a str")
        pulumi.set(__self__, "tenancy", tenancy)
        if upfront_fee and not isinstance(upfront_fee, str):
            raise TypeError("Expected argument 'upfront_fee' to be a str")
        pulumi.set(__self__, "upfront_fee", upfront_fee)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The Availability Zone in which to create the Capacity Reservation.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="capacityBlockOfferingId")
    def capacity_block_offering_id(self) -> _builtins.str:
        """
        The Capacity Block Reservation ID.
        """
        return pulumi.get(self, "capacity_block_offering_id")

    @_builtins.property
    @pulumi.getter(name="capacityDurationHours")
    def capacity_duration_hours(self) -> _builtins.int:
        return pulumi.get(self, "capacity_duration_hours")

    @_builtins.property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> _builtins.str:
        """
        The currency of the payment for the Capacity Block.
        """
        return pulumi.get(self, "currency_code")

    @_builtins.property
    @pulumi.getter(name="endDateRange")
    def end_date_range(self) -> _builtins.str:
        return pulumi.get(self, "end_date_range")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> _builtins.int:
        return pulumi.get(self, "instance_count")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="startDateRange")
    def start_date_range(self) -> _builtins.str:
        return pulumi.get(self, "start_date_range")

    @_builtins.property
    @pulumi.getter
    def tenancy(self) -> _builtins.str:
        """
        Indicates the tenancy of the Capacity Reservation. Specify either `default` or `dedicated`.
        """
        return pulumi.get(self, "tenancy")

    @_builtins.property
    @pulumi.getter(name="upfrontFee")
    def upfront_fee(self) -> _builtins.str:
        """
        The total price to be paid up front.
        """
        return pulumi.get(self, "upfront_fee")


class AwaitableGetCapacityBlockOfferingResult(GetCapacityBlockOfferingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCapacityBlockOfferingResult(
            availability_zone=self.availability_zone,
            capacity_block_offering_id=self.capacity_block_offering_id,
            capacity_duration_hours=self.capacity_duration_hours,
            currency_code=self.currency_code,
            end_date_range=self.end_date_range,
            id=self.id,
            instance_count=self.instance_count,
            instance_type=self.instance_type,
            region=self.region,
            start_date_range=self.start_date_range,
            tenancy=self.tenancy,
            upfront_fee=self.upfront_fee)


def get_capacity_block_offering(capacity_duration_hours: Optional[_builtins.int] = None,
                                end_date_range: Optional[_builtins.str] = None,
                                instance_count: Optional[_builtins.int] = None,
                                instance_type: Optional[_builtins.str] = None,
                                region: Optional[_builtins.str] = None,
                                start_date_range: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCapacityBlockOfferingResult:
    """
    Information about a single EC2 Capacity Block Offering.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_capacity_block_offering(capacity_duration_hours=24,
        end_date_range="2024-05-30T15:04:05Z",
        instance_count=1,
        instance_type="p4d.24xlarge",
        start_date_range="2024-04-28T15:04:05Z")
    ```


    :param _builtins.int capacity_duration_hours: The amount of time of the Capacity Block reservation in hours.
    :param _builtins.str end_date_range: The date and time at which the Capacity Block Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
    :param _builtins.int instance_count: The number of instances for which to reserve capacity.
    :param _builtins.str instance_type: The instance type for which to reserve capacity.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str start_date_range: The date and time at which the Capacity Block Reservation starts. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
    """
    __args__ = dict()
    __args__['capacityDurationHours'] = capacity_duration_hours
    __args__['endDateRange'] = end_date_range
    __args__['instanceCount'] = instance_count
    __args__['instanceType'] = instance_type
    __args__['region'] = region
    __args__['startDateRange'] = start_date_range
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getCapacityBlockOffering:getCapacityBlockOffering', __args__, opts=opts, typ=GetCapacityBlockOfferingResult).value

    return AwaitableGetCapacityBlockOfferingResult(
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        capacity_block_offering_id=pulumi.get(__ret__, 'capacity_block_offering_id'),
        capacity_duration_hours=pulumi.get(__ret__, 'capacity_duration_hours'),
        currency_code=pulumi.get(__ret__, 'currency_code'),
        end_date_range=pulumi.get(__ret__, 'end_date_range'),
        id=pulumi.get(__ret__, 'id'),
        instance_count=pulumi.get(__ret__, 'instance_count'),
        instance_type=pulumi.get(__ret__, 'instance_type'),
        region=pulumi.get(__ret__, 'region'),
        start_date_range=pulumi.get(__ret__, 'start_date_range'),
        tenancy=pulumi.get(__ret__, 'tenancy'),
        upfront_fee=pulumi.get(__ret__, 'upfront_fee'))
def get_capacity_block_offering_output(capacity_duration_hours: Optional[pulumi.Input[_builtins.int]] = None,
                                       end_date_range: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                                       instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       start_date_range: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCapacityBlockOfferingResult]:
    """
    Information about a single EC2 Capacity Block Offering.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_capacity_block_offering(capacity_duration_hours=24,
        end_date_range="2024-05-30T15:04:05Z",
        instance_count=1,
        instance_type="p4d.24xlarge",
        start_date_range="2024-04-28T15:04:05Z")
    ```


    :param _builtins.int capacity_duration_hours: The amount of time of the Capacity Block reservation in hours.
    :param _builtins.str end_date_range: The date and time at which the Capacity Block Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
    :param _builtins.int instance_count: The number of instances for which to reserve capacity.
    :param _builtins.str instance_type: The instance type for which to reserve capacity.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str start_date_range: The date and time at which the Capacity Block Reservation starts. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
    """
    __args__ = dict()
    __args__['capacityDurationHours'] = capacity_duration_hours
    __args__['endDateRange'] = end_date_range
    __args__['instanceCount'] = instance_count
    __args__['instanceType'] = instance_type
    __args__['region'] = region
    __args__['startDateRange'] = start_date_range
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getCapacityBlockOffering:getCapacityBlockOffering', __args__, opts=opts, typ=GetCapacityBlockOfferingResult)
    return __ret__.apply(lambda __response__: GetCapacityBlockOfferingResult(
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        capacity_block_offering_id=pulumi.get(__response__, 'capacity_block_offering_id'),
        capacity_duration_hours=pulumi.get(__response__, 'capacity_duration_hours'),
        currency_code=pulumi.get(__response__, 'currency_code'),
        end_date_range=pulumi.get(__response__, 'end_date_range'),
        id=pulumi.get(__response__, 'id'),
        instance_count=pulumi.get(__response__, 'instance_count'),
        instance_type=pulumi.get(__response__, 'instance_type'),
        region=pulumi.get(__response__, 'region'),
        start_date_range=pulumi.get(__response__, 'start_date_range'),
        tenancy=pulumi.get(__response__, 'tenancy'),
        upfront_fee=pulumi.get(__response__, 'upfront_fee')))
