# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEipsResult',
    'AwaitableGetEipsResult',
    'get_eips',
    'get_eips_output',
]

@pulumi.output_type
class GetEipsResult:
    """
    A collection of values returned by getEips.
    """
    def __init__(__self__, allocation_ids=None, filters=None, id=None, public_ips=None, region=None, tags=None):
        if allocation_ids and not isinstance(allocation_ids, list):
            raise TypeError("Expected argument 'allocation_ids' to be a list")
        pulumi.set(__self__, "allocation_ids", allocation_ids)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if public_ips and not isinstance(public_ips, list):
            raise TypeError("Expected argument 'public_ips' to be a list")
        pulumi.set(__self__, "public_ips", public_ips)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="allocationIds")
    def allocation_ids(self) -> Sequence[_builtins.str]:
        """
        List of all the allocation IDs for address for use with EC2-VPC.
        """
        return pulumi.get(self, "allocation_ids")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEipsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Sequence[_builtins.str]:
        """
        List of all the Elastic IP addresses.
        """
        return pulumi.get(self, "public_ips")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags")


class AwaitableGetEipsResult(GetEipsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEipsResult(
            allocation_ids=self.allocation_ids,
            filters=self.filters,
            id=self.id,
            public_ips=self.public_ips,
            region=self.region,
            tags=self.tags)


def get_eips(filters: Optional[Sequence[Union['GetEipsFilterArgs', 'GetEipsFilterArgsDict']]] = None,
             region: Optional[_builtins.str] = None,
             tags: Optional[Mapping[str, _builtins.str]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEipsResult:
    """
    Provides a list of Elastic IPs in a region.

    ## Example Usage

    The following shows outputting all Elastic IPs with the a specific tag value.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_eips(tags={
        "Env": "dev",
    })
    pulumi.export("allocationIds", example.allocation_ids)
    pulumi.export("publicIps", example.public_ips)
    ```


    :param Sequence[Union['GetEipsFilterArgs', 'GetEipsFilterArgsDict']] filters: Custom filter block as described below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags, each pair of which must exactly match a pair on the desired Elastic IPs.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getEips:getEips', __args__, opts=opts, typ=GetEipsResult).value

    return AwaitableGetEipsResult(
        allocation_ids=pulumi.get(__ret__, 'allocation_ids'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        public_ips=pulumi.get(__ret__, 'public_ips'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_eips_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetEipsFilterArgs', 'GetEipsFilterArgsDict']]]]] = None,
                    region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEipsResult]:
    """
    Provides a list of Elastic IPs in a region.

    ## Example Usage

    The following shows outputting all Elastic IPs with the a specific tag value.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_eips(tags={
        "Env": "dev",
    })
    pulumi.export("allocationIds", example.allocation_ids)
    pulumi.export("publicIps", example.public_ips)
    ```


    :param Sequence[Union['GetEipsFilterArgs', 'GetEipsFilterArgsDict']] filters: Custom filter block as described below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags, each pair of which must exactly match a pair on the desired Elastic IPs.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getEips:getEips', __args__, opts=opts, typ=GetEipsResult)
    return __ret__.apply(lambda __response__: GetEipsResult(
        allocation_ids=pulumi.get(__response__, 'allocation_ids'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        public_ips=pulumi.get(__response__, 'public_ips'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
