# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInstancesResult',
    'AwaitableGetInstancesResult',
    'get_instances',
    'get_instances_output',
]

@pulumi.output_type
class GetInstancesResult:
    """
    A collection of values returned by getInstances.
    """
    def __init__(__self__, filters=None, id=None, ids=None, instance_state_names=None, instance_tags=None, ipv6_addresses=None, private_ips=None, public_ips=None, region=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_state_names and not isinstance(instance_state_names, list):
            raise TypeError("Expected argument 'instance_state_names' to be a list")
        pulumi.set(__self__, "instance_state_names", instance_state_names)
        if instance_tags and not isinstance(instance_tags, dict):
            raise TypeError("Expected argument 'instance_tags' to be a dict")
        pulumi.set(__self__, "instance_tags", instance_tags)
        if ipv6_addresses and not isinstance(ipv6_addresses, list):
            raise TypeError("Expected argument 'ipv6_addresses' to be a list")
        pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if private_ips and not isinstance(private_ips, list):
            raise TypeError("Expected argument 'private_ips' to be a list")
        pulumi.set(__self__, "private_ips", private_ips)
        if public_ips and not isinstance(public_ips, list):
            raise TypeError("Expected argument 'public_ips' to be a list")
        pulumi.set(__self__, "public_ips", public_ips)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        IDs of instances found through the filter
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="instanceStateNames")
    def instance_state_names(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "instance_state_names")

    @_builtins.property
    @pulumi.getter(name="instanceTags")
    def instance_tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "instance_tags")

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Sequence[_builtins.str]:
        """
        IPv6 addresses of instances found through the filter
        """
        return pulumi.get(self, "ipv6_addresses")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence[_builtins.str]:
        """
        Private IP addresses of instances found through the filter
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Sequence[_builtins.str]:
        """
        Public IP addresses of instances found through the filter
        """
        return pulumi.get(self, "public_ips")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetInstancesResult(GetInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancesResult(
            filters=self.filters,
            id=self.id,
            ids=self.ids,
            instance_state_names=self.instance_state_names,
            instance_tags=self.instance_tags,
            ipv6_addresses=self.ipv6_addresses,
            private_ips=self.private_ips,
            public_ips=self.public_ips,
            region=self.region)


def get_instances(filters: Optional[Sequence[Union['GetInstancesFilterArgs', 'GetInstancesFilterArgsDict']]] = None,
                  instance_state_names: Optional[Sequence[_builtins.str]] = None,
                  instance_tags: Optional[Mapping[str, _builtins.str]] = None,
                  region: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancesResult:
    """
    Use this data source to get IDs or IPs of Amazon EC2 instances to be referenced elsewhere,
    e.g., to allow easier migration from another management solution
    or to make it easier for an operator to connect through bastion host(s).

    > **Note:** It's strongly discouraged to use this data source for querying ephemeral
    instances (e.g., managed via autoscaling group), as the output may change at any time
    and you'd need to re-run `apply` every time an instance comes up or dies.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.ec2.get_instances(instance_tags={
            "Role": "HardWorker",
        },
        filters=[{
            "name": "instance.group-id",
            "values": ["sg-12345678"],
        }],
        instance_state_names=[
            "running",
            "stopped",
        ])
    test_eip = []
    def create_test(range_body):
        for range in [{"value": i} for i in range(0, range_body)]:
            test_eip.append(aws.ec2.Eip(f"test-{range['value']}", instance=test.ids[range["value"]]))

    (len(test.ids)).apply(create_test)
    ```


    :param Sequence[Union['GetInstancesFilterArgs', 'GetInstancesFilterArgsDict']] filters: One or more name/value pairs to use as filters. There are
           several valid keys, for a full reference, check out
           [describe-instances in the AWS CLI reference][1].
    :param Sequence[_builtins.str] instance_state_names: List of instance states that should be applicable to the desired instances. The permitted values are: `pending, running, shutting-down, stopped, stopping, terminated`. The default value is `running`.
    :param Mapping[str, _builtins.str] instance_tags: Map of tags, each pair of which must
           exactly match a pair on desired instances.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['instanceStateNames'] = instance_state_names
    __args__['instanceTags'] = instance_tags
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult).value

    return AwaitableGetInstancesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_state_names=pulumi.get(__ret__, 'instance_state_names'),
        instance_tags=pulumi.get(__ret__, 'instance_tags'),
        ipv6_addresses=pulumi.get(__ret__, 'ipv6_addresses'),
        private_ips=pulumi.get(__ret__, 'private_ips'),
        public_ips=pulumi.get(__ret__, 'public_ips'),
        region=pulumi.get(__ret__, 'region'))
def get_instances_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInstancesFilterArgs', 'GetInstancesFilterArgsDict']]]]] = None,
                         instance_state_names: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                         instance_tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstancesResult]:
    """
    Use this data source to get IDs or IPs of Amazon EC2 instances to be referenced elsewhere,
    e.g., to allow easier migration from another management solution
    or to make it easier for an operator to connect through bastion host(s).

    > **Note:** It's strongly discouraged to use this data source for querying ephemeral
    instances (e.g., managed via autoscaling group), as the output may change at any time
    and you'd need to re-run `apply` every time an instance comes up or dies.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.ec2.get_instances(instance_tags={
            "Role": "HardWorker",
        },
        filters=[{
            "name": "instance.group-id",
            "values": ["sg-12345678"],
        }],
        instance_state_names=[
            "running",
            "stopped",
        ])
    test_eip = []
    def create_test(range_body):
        for range in [{"value": i} for i in range(0, range_body)]:
            test_eip.append(aws.ec2.Eip(f"test-{range['value']}", instance=test.ids[range["value"]]))

    (len(test.ids)).apply(create_test)
    ```


    :param Sequence[Union['GetInstancesFilterArgs', 'GetInstancesFilterArgsDict']] filters: One or more name/value pairs to use as filters. There are
           several valid keys, for a full reference, check out
           [describe-instances in the AWS CLI reference][1].
    :param Sequence[_builtins.str] instance_state_names: List of instance states that should be applicable to the desired instances. The permitted values are: `pending, running, shutting-down, stopped, stopping, terminated`. The default value is `running`.
    :param Mapping[str, _builtins.str] instance_tags: Map of tags, each pair of which must
           exactly match a pair on desired instances.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['instanceStateNames'] = instance_state_names
    __args__['instanceTags'] = instance_tags
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult)
    return __ret__.apply(lambda __response__: GetInstancesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instance_state_names=pulumi.get(__response__, 'instance_state_names'),
        instance_tags=pulumi.get(__response__, 'instance_tags'),
        ipv6_addresses=pulumi.get(__response__, 'ipv6_addresses'),
        private_ips=pulumi.get(__response__, 'private_ips'),
        public_ips=pulumi.get(__response__, 'public_ips'),
        region=pulumi.get(__response__, 'region')))
