# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetKeyPairResult',
    'AwaitableGetKeyPairResult',
    'get_key_pair',
    'get_key_pair_output',
]

@pulumi.output_type
class GetKeyPairResult:
    """
    A collection of values returned by getKeyPair.
    """
    def __init__(__self__, arn=None, create_time=None, filters=None, fingerprint=None, id=None, include_public_key=None, key_name=None, key_pair_id=None, key_type=None, public_key=None, region=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_public_key and not isinstance(include_public_key, bool):
            raise TypeError("Expected argument 'include_public_key' to be a bool")
        pulumi.set(__self__, "include_public_key", include_public_key)
        if key_name and not isinstance(key_name, str):
            raise TypeError("Expected argument 'key_name' to be a str")
        pulumi.set(__self__, "key_name", key_name)
        if key_pair_id and not isinstance(key_pair_id, str):
            raise TypeError("Expected argument 'key_pair_id' to be a str")
        pulumi.set(__self__, "key_pair_id", key_pair_id)
        if key_type and not isinstance(key_type, str):
            raise TypeError("Expected argument 'key_type' to be a str")
        pulumi.set(__self__, "key_type", key_type)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the Key Pair.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Timestamp for when the key pair was created in ISO 8601 format.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetKeyPairFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> _builtins.str:
        """
        SHA-1 digest of the DER encoded private key.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="includePublicKey")
    def include_public_key(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "include_public_key")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="keyPairId")
    def key_pair_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key_pair_id")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> _builtins.str:
        """
        Type of key pair.
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        Public key material.
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Any tags assigned to the Key Pair.
        """
        return pulumi.get(self, "tags")


class AwaitableGetKeyPairResult(GetKeyPairResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyPairResult(
            arn=self.arn,
            create_time=self.create_time,
            filters=self.filters,
            fingerprint=self.fingerprint,
            id=self.id,
            include_public_key=self.include_public_key,
            key_name=self.key_name,
            key_pair_id=self.key_pair_id,
            key_type=self.key_type,
            public_key=self.public_key,
            region=self.region,
            tags=self.tags)


def get_key_pair(filters: Optional[Sequence[Union['GetKeyPairFilterArgs', 'GetKeyPairFilterArgsDict']]] = None,
                 include_public_key: Optional[_builtins.bool] = None,
                 key_name: Optional[_builtins.str] = None,
                 key_pair_id: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyPairResult:
    """
    Use this data source to get information about a specific EC2 Key Pair.

    ## Example Usage

    The following example shows how to get a EC2 Key Pair including the public key material from its name.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_key_pair(key_name="test",
        include_public_key=True,
        filters=[{
            "name": "tag:Component",
            "values": ["web"],
        }])
    pulumi.export("fingerprint", example.fingerprint)
    pulumi.export("name", example.key_name)
    pulumi.export("id", example.id)
    ```


    :param Sequence[Union['GetKeyPairFilterArgs', 'GetKeyPairFilterArgsDict']] filters: Custom filter block as described below.
           
           The arguments of this data source act as filters for querying the available
           Key Pairs. The given filters must match exactly one Key Pair
           whose data will be exported as attributes.
    :param _builtins.bool include_public_key: Whether to include the public key material in the response.
    :param _builtins.str key_name: Key Pair name.
    :param _builtins.str key_pair_id: Key Pair ID.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Any tags assigned to the Key Pair.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['includePublicKey'] = include_public_key
    __args__['keyName'] = key_name
    __args__['keyPairId'] = key_pair_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getKeyPair:getKeyPair', __args__, opts=opts, typ=GetKeyPairResult).value

    return AwaitableGetKeyPairResult(
        arn=pulumi.get(__ret__, 'arn'),
        create_time=pulumi.get(__ret__, 'create_time'),
        filters=pulumi.get(__ret__, 'filters'),
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        id=pulumi.get(__ret__, 'id'),
        include_public_key=pulumi.get(__ret__, 'include_public_key'),
        key_name=pulumi.get(__ret__, 'key_name'),
        key_pair_id=pulumi.get(__ret__, 'key_pair_id'),
        key_type=pulumi.get(__ret__, 'key_type'),
        public_key=pulumi.get(__ret__, 'public_key'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_key_pair_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetKeyPairFilterArgs', 'GetKeyPairFilterArgsDict']]]]] = None,
                        include_public_key: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                        key_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        key_pair_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeyPairResult]:
    """
    Use this data source to get information about a specific EC2 Key Pair.

    ## Example Usage

    The following example shows how to get a EC2 Key Pair including the public key material from its name.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_key_pair(key_name="test",
        include_public_key=True,
        filters=[{
            "name": "tag:Component",
            "values": ["web"],
        }])
    pulumi.export("fingerprint", example.fingerprint)
    pulumi.export("name", example.key_name)
    pulumi.export("id", example.id)
    ```


    :param Sequence[Union['GetKeyPairFilterArgs', 'GetKeyPairFilterArgsDict']] filters: Custom filter block as described below.
           
           The arguments of this data source act as filters for querying the available
           Key Pairs. The given filters must match exactly one Key Pair
           whose data will be exported as attributes.
    :param _builtins.bool include_public_key: Whether to include the public key material in the response.
    :param _builtins.str key_name: Key Pair name.
    :param _builtins.str key_pair_id: Key Pair ID.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Any tags assigned to the Key Pair.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['includePublicKey'] = include_public_key
    __args__['keyName'] = key_name
    __args__['keyPairId'] = key_pair_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getKeyPair:getKeyPair', __args__, opts=opts, typ=GetKeyPairResult)
    return __ret__.apply(lambda __response__: GetKeyPairResult(
        arn=pulumi.get(__response__, 'arn'),
        create_time=pulumi.get(__response__, 'create_time'),
        filters=pulumi.get(__response__, 'filters'),
        fingerprint=pulumi.get(__response__, 'fingerprint'),
        id=pulumi.get(__response__, 'id'),
        include_public_key=pulumi.get(__response__, 'include_public_key'),
        key_name=pulumi.get(__response__, 'key_name'),
        key_pair_id=pulumi.get(__response__, 'key_pair_id'),
        key_type=pulumi.get(__response__, 'key_type'),
        public_key=pulumi.get(__response__, 'public_key'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
