# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVpcDhcpOptionsResult',
    'AwaitableGetVpcDhcpOptionsResult',
    'get_vpc_dhcp_options',
    'get_vpc_dhcp_options_output',
]

@pulumi.output_type
class GetVpcDhcpOptionsResult:
    """
    A collection of values returned by getVpcDhcpOptions.
    """
    def __init__(__self__, arn=None, dhcp_options_id=None, domain_name=None, domain_name_servers=None, filters=None, id=None, ipv6_address_preferred_lease_time=None, netbios_name_servers=None, netbios_node_type=None, ntp_servers=None, owner_id=None, region=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if dhcp_options_id and not isinstance(dhcp_options_id, str):
            raise TypeError("Expected argument 'dhcp_options_id' to be a str")
        pulumi.set(__self__, "dhcp_options_id", dhcp_options_id)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if domain_name_servers and not isinstance(domain_name_servers, list):
            raise TypeError("Expected argument 'domain_name_servers' to be a list")
        pulumi.set(__self__, "domain_name_servers", domain_name_servers)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipv6_address_preferred_lease_time and not isinstance(ipv6_address_preferred_lease_time, str):
            raise TypeError("Expected argument 'ipv6_address_preferred_lease_time' to be a str")
        pulumi.set(__self__, "ipv6_address_preferred_lease_time", ipv6_address_preferred_lease_time)
        if netbios_name_servers and not isinstance(netbios_name_servers, list):
            raise TypeError("Expected argument 'netbios_name_servers' to be a list")
        pulumi.set(__self__, "netbios_name_servers", netbios_name_servers)
        if netbios_node_type and not isinstance(netbios_node_type, str):
            raise TypeError("Expected argument 'netbios_node_type' to be a str")
        pulumi.set(__self__, "netbios_node_type", netbios_node_type)
        if ntp_servers and not isinstance(ntp_servers, list):
            raise TypeError("Expected argument 'ntp_servers' to be a list")
        pulumi.set(__self__, "ntp_servers", ntp_servers)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the DHCP Options Set.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="dhcpOptionsId")
    def dhcp_options_id(self) -> _builtins.str:
        """
        EC2 DHCP Options ID
        """
        return pulumi.get(self, "dhcp_options_id")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        Suffix domain name to used when resolving non Fully Qualified Domain NamesE.g., the `search` value in the `/etc/resolv.conf` file.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="domainNameServers")
    def domain_name_servers(self) -> Sequence[_builtins.str]:
        """
        List of name servers.
        """
        return pulumi.get(self, "domain_name_servers")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVpcDhcpOptionsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressPreferredLeaseTime")
    def ipv6_address_preferred_lease_time(self) -> _builtins.str:
        """
        How frequently, in seconds, a running instance with an IPv6 assigned to it goes through DHCPv6 lease renewal.
        """
        return pulumi.get(self, "ipv6_address_preferred_lease_time")

    @_builtins.property
    @pulumi.getter(name="netbiosNameServers")
    def netbios_name_servers(self) -> Sequence[_builtins.str]:
        """
        List of NETBIOS name servers.
        """
        return pulumi.get(self, "netbios_name_servers")

    @_builtins.property
    @pulumi.getter(name="netbiosNodeType")
    def netbios_node_type(self) -> _builtins.str:
        """
        NetBIOS node type (1, 2, 4, or 8). For more information about these node types, see [RFC 2132](http://www.ietf.org/rfc/rfc2132.txt).
        """
        return pulumi.get(self, "netbios_node_type")

    @_builtins.property
    @pulumi.getter(name="ntpServers")
    def ntp_servers(self) -> Sequence[_builtins.str]:
        """
        List of NTP servers.
        """
        return pulumi.get(self, "ntp_servers")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> _builtins.str:
        """
        ID of the AWS account that owns the DHCP options set.
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Map of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetVpcDhcpOptionsResult(GetVpcDhcpOptionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcDhcpOptionsResult(
            arn=self.arn,
            dhcp_options_id=self.dhcp_options_id,
            domain_name=self.domain_name,
            domain_name_servers=self.domain_name_servers,
            filters=self.filters,
            id=self.id,
            ipv6_address_preferred_lease_time=self.ipv6_address_preferred_lease_time,
            netbios_name_servers=self.netbios_name_servers,
            netbios_node_type=self.netbios_node_type,
            ntp_servers=self.ntp_servers,
            owner_id=self.owner_id,
            region=self.region,
            tags=self.tags)


def get_vpc_dhcp_options(dhcp_options_id: Optional[_builtins.str] = None,
                         filters: Optional[Sequence[Union['GetVpcDhcpOptionsFilterArgs', 'GetVpcDhcpOptionsFilterArgsDict']]] = None,
                         region: Optional[_builtins.str] = None,
                         tags: Optional[Mapping[str, _builtins.str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcDhcpOptionsResult:
    """
    Retrieve information about an EC2 DHCP Options configuration.

    ## Example Usage

    ### Lookup by DHCP Options ID

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpc_dhcp_options(dhcp_options_id="dopts-12345678")
    ```

    ### Lookup by Filter

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpc_dhcp_options(filters=[
        {
            "name": "key",
            "values": ["domain-name"],
        },
        {
            "name": "value",
            "values": ["example.com"],
        },
    ])
    ```


    :param _builtins.str dhcp_options_id: EC2 DHCP Options ID.
    :param Sequence[Union['GetVpcDhcpOptionsFilterArgs', 'GetVpcDhcpOptionsFilterArgsDict']] filters: List of custom filters as described below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags assigned to the resource.
    """
    __args__ = dict()
    __args__['dhcpOptionsId'] = dhcp_options_id
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getVpcDhcpOptions:getVpcDhcpOptions', __args__, opts=opts, typ=GetVpcDhcpOptionsResult).value

    return AwaitableGetVpcDhcpOptionsResult(
        arn=pulumi.get(__ret__, 'arn'),
        dhcp_options_id=pulumi.get(__ret__, 'dhcp_options_id'),
        domain_name=pulumi.get(__ret__, 'domain_name'),
        domain_name_servers=pulumi.get(__ret__, 'domain_name_servers'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ipv6_address_preferred_lease_time=pulumi.get(__ret__, 'ipv6_address_preferred_lease_time'),
        netbios_name_servers=pulumi.get(__ret__, 'netbios_name_servers'),
        netbios_node_type=pulumi.get(__ret__, 'netbios_node_type'),
        ntp_servers=pulumi.get(__ret__, 'ntp_servers'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_vpc_dhcp_options_output(dhcp_options_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVpcDhcpOptionsFilterArgs', 'GetVpcDhcpOptionsFilterArgsDict']]]]] = None,
                                region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcDhcpOptionsResult]:
    """
    Retrieve information about an EC2 DHCP Options configuration.

    ## Example Usage

    ### Lookup by DHCP Options ID

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpc_dhcp_options(dhcp_options_id="dopts-12345678")
    ```

    ### Lookup by Filter

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpc_dhcp_options(filters=[
        {
            "name": "key",
            "values": ["domain-name"],
        },
        {
            "name": "value",
            "values": ["example.com"],
        },
    ])
    ```


    :param _builtins.str dhcp_options_id: EC2 DHCP Options ID.
    :param Sequence[Union['GetVpcDhcpOptionsFilterArgs', 'GetVpcDhcpOptionsFilterArgsDict']] filters: List of custom filters as described below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags assigned to the resource.
    """
    __args__ = dict()
    __args__['dhcpOptionsId'] = dhcp_options_id
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getVpcDhcpOptions:getVpcDhcpOptions', __args__, opts=opts, typ=GetVpcDhcpOptionsResult)
    return __ret__.apply(lambda __response__: GetVpcDhcpOptionsResult(
        arn=pulumi.get(__response__, 'arn'),
        dhcp_options_id=pulumi.get(__response__, 'dhcp_options_id'),
        domain_name=pulumi.get(__response__, 'domain_name'),
        domain_name_servers=pulumi.get(__response__, 'domain_name_servers'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ipv6_address_preferred_lease_time=pulumi.get(__response__, 'ipv6_address_preferred_lease_time'),
        netbios_name_servers=pulumi.get(__response__, 'netbios_name_servers'),
        netbios_node_type=pulumi.get(__response__, 'netbios_node_type'),
        ntp_servers=pulumi.get(__response__, 'ntp_servers'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
