# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVpcPeeringConnectionsResult',
    'AwaitableGetVpcPeeringConnectionsResult',
    'get_vpc_peering_connections',
    'get_vpc_peering_connections_output',
]

@pulumi.output_type
class GetVpcPeeringConnectionsResult:
    """
    A collection of values returned by getVpcPeeringConnections.
    """
    def __init__(__self__, filters=None, id=None, ids=None, region=None, tags=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVpcPeeringConnectionsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        IDs of the VPC Peering Connections.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "tags")


class AwaitableGetVpcPeeringConnectionsResult(GetVpcPeeringConnectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcPeeringConnectionsResult(
            filters=self.filters,
            id=self.id,
            ids=self.ids,
            region=self.region,
            tags=self.tags)


def get_vpc_peering_connections(filters: Optional[Sequence[Union['GetVpcPeeringConnectionsFilterArgs', 'GetVpcPeeringConnectionsFilterArgsDict']]] = None,
                                region: Optional[_builtins.str] = None,
                                tags: Optional[Mapping[str, _builtins.str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcPeeringConnectionsResult:
    """
    Use this data source to get IDs of Amazon VPC peering connections
    To get more details on each connection, use the data resource ec2.VpcPeeringConnection

    Note: To use this data source in a count, the resources should exist before trying to access
    the data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    # Declare the data source
    pcs = aws.ec2.get_vpc_peering_connections(filters=[{
        "name": "requester-vpc-info.vpc-id",
        "values": [foo["id"]],
    }])
    # get the details of each resource
    pc = [aws.ec2.get_vpc_peering_connection(id=pcs.ids[__index]) for __index in len(pcs.ids).apply(lambda length: range(length))]
    ```


    :param Sequence[Union['GetVpcPeeringConnectionsFilterArgs', 'GetVpcPeeringConnectionsFilterArgsDict']] filters: Custom filter block as described below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Mapping of tags, each pair of which must exactly match
           a pair on the desired VPC Peering Connection.
           
           The arguments of this data source act as filters for querying the available VPC peering connections.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getVpcPeeringConnections:getVpcPeeringConnections', __args__, opts=opts, typ=GetVpcPeeringConnectionsResult).value

    return AwaitableGetVpcPeeringConnectionsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_vpc_peering_connections_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVpcPeeringConnectionsFilterArgs', 'GetVpcPeeringConnectionsFilterArgsDict']]]]] = None,
                                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcPeeringConnectionsResult]:
    """
    Use this data source to get IDs of Amazon VPC peering connections
    To get more details on each connection, use the data resource ec2.VpcPeeringConnection

    Note: To use this data source in a count, the resources should exist before trying to access
    the data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    # Declare the data source
    pcs = aws.ec2.get_vpc_peering_connections(filters=[{
        "name": "requester-vpc-info.vpc-id",
        "values": [foo["id"]],
    }])
    # get the details of each resource
    pc = [aws.ec2.get_vpc_peering_connection(id=pcs.ids[__index]) for __index in len(pcs.ids).apply(lambda length: range(length))]
    ```


    :param Sequence[Union['GetVpcPeeringConnectionsFilterArgs', 'GetVpcPeeringConnectionsFilterArgsDict']] filters: Custom filter block as described below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Mapping of tags, each pair of which must exactly match
           a pair on the desired VPC Peering Connection.
           
           The arguments of this data source act as filters for querying the available VPC peering connections.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getVpcPeeringConnections:getVpcPeeringConnections', __args__, opts=opts, typ=GetVpcPeeringConnectionsResult)
    return __ret__.apply(lambda __response__: GetVpcPeeringConnectionsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
