# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkInterfacePermissionArgs', 'NetworkInterfacePermission']

@pulumi.input_type
class NetworkInterfacePermissionArgs:
    def __init__(__self__, *,
                 aws_account_id: pulumi.Input[_builtins.str],
                 network_interface_id: pulumi.Input[_builtins.str],
                 permission: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['NetworkInterfacePermissionTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a NetworkInterfacePermission resource.
        :param pulumi.Input[_builtins.str] aws_account_id: The Amazon Web Services account ID.
        :param pulumi.Input[_builtins.str] network_interface_id: The ID of the network interface.
        :param pulumi.Input[_builtins.str] permission: The type of permission to grant. Valid values are `INSTANCE-ATTACH` or `EIP-ASSOCIATE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "aws_account_id", aws_account_id)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "permission", permission)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Amazon Web Services account ID.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "aws_account_id", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> pulumi.Input[_builtins.str]:
        """
        The type of permission to grant. Valid values are `INSTANCE-ATTACH` or `EIP-ASSOCIATE`.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "permission", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['NetworkInterfacePermissionTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['NetworkInterfacePermissionTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _NetworkInterfacePermissionState:
    def __init__(__self__, *,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_permission_id: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['NetworkInterfacePermissionTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering NetworkInterfacePermission resources.
        :param pulumi.Input[_builtins.str] aws_account_id: The Amazon Web Services account ID.
        :param pulumi.Input[_builtins.str] network_interface_id: The ID of the network interface.
        :param pulumi.Input[_builtins.str] network_interface_permission_id: ENI permission ID.
        :param pulumi.Input[_builtins.str] permission: The type of permission to grant. Valid values are `INSTANCE-ATTACH` or `EIP-ASSOCIATE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if network_interface_permission_id is not None:
            pulumi.set(__self__, "network_interface_permission_id", network_interface_permission_id)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Web Services account ID.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfacePermissionId")
    def network_interface_permission_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ENI permission ID.
        """
        return pulumi.get(self, "network_interface_permission_id")

    @network_interface_permission_id.setter
    def network_interface_permission_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_permission_id", value)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of permission to grant. Valid values are `INSTANCE-ATTACH` or `EIP-ASSOCIATE`.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permission", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['NetworkInterfacePermissionTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['NetworkInterfacePermissionTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:ec2/networkInterfacePermission:NetworkInterfacePermission")
class NetworkInterfacePermission(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['NetworkInterfacePermissionTimeoutsArgs', 'NetworkInterfacePermissionTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Grant cross-account access to an Elastic network interface (ENI).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.NetworkInterface("example",
            subnet_id=example_aws_subnet["id"],
            private_ips=["10.0.0.50"],
            security_groups=[example_aws_security_group["id"]],
            attachments=[{
                "instance": example_aws_instance["id"],
                "device_index": 1,
            }])
        example_network_interface_permission = aws.ec2.NetworkInterfacePermission("example",
            network_interface_id=example.id,
            aws_account_id="123456789012",
            permission="INSTANCE-ATTACH")
        ```

        ## Import

        Using `pulumi import`, import Network Interface Permissions using the `network_interface_permission_id`. For example:

        ```sh
        $ pulumi import aws:ec2/networkInterfacePermission:NetworkInterfacePermission example eni-perm-056ad97ce2ac377ed
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aws_account_id: The Amazon Web Services account ID.
        :param pulumi.Input[_builtins.str] network_interface_id: The ID of the network interface.
        :param pulumi.Input[_builtins.str] permission: The type of permission to grant. Valid values are `INSTANCE-ATTACH` or `EIP-ASSOCIATE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkInterfacePermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Grant cross-account access to an Elastic network interface (ENI).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.NetworkInterface("example",
            subnet_id=example_aws_subnet["id"],
            private_ips=["10.0.0.50"],
            security_groups=[example_aws_security_group["id"]],
            attachments=[{
                "instance": example_aws_instance["id"],
                "device_index": 1,
            }])
        example_network_interface_permission = aws.ec2.NetworkInterfacePermission("example",
            network_interface_id=example.id,
            aws_account_id="123456789012",
            permission="INSTANCE-ATTACH")
        ```

        ## Import

        Using `pulumi import`, import Network Interface Permissions using the `network_interface_permission_id`. For example:

        ```sh
        $ pulumi import aws:ec2/networkInterfacePermission:NetworkInterfacePermission example eni-perm-056ad97ce2ac377ed
        ```

        :param str resource_name: The name of the resource.
        :param NetworkInterfacePermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkInterfacePermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['NetworkInterfacePermissionTimeoutsArgs', 'NetworkInterfacePermissionTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkInterfacePermissionArgs.__new__(NetworkInterfacePermissionArgs)

            if aws_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'aws_account_id'")
            __props__.__dict__["aws_account_id"] = aws_account_id
            if network_interface_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_interface_id'")
            __props__.__dict__["network_interface_id"] = network_interface_id
            if permission is None and not opts.urn:
                raise TypeError("Missing required property 'permission'")
            __props__.__dict__["permission"] = permission
            __props__.__dict__["region"] = region
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["network_interface_permission_id"] = None
        super(NetworkInterfacePermission, __self__).__init__(
            'aws:ec2/networkInterfacePermission:NetworkInterfacePermission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_interface_permission_id: Optional[pulumi.Input[_builtins.str]] = None,
            permission: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['NetworkInterfacePermissionTimeoutsArgs', 'NetworkInterfacePermissionTimeoutsArgsDict']]] = None) -> 'NetworkInterfacePermission':
        """
        Get an existing NetworkInterfacePermission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aws_account_id: The Amazon Web Services account ID.
        :param pulumi.Input[_builtins.str] network_interface_id: The ID of the network interface.
        :param pulumi.Input[_builtins.str] network_interface_permission_id: ENI permission ID.
        :param pulumi.Input[_builtins.str] permission: The type of permission to grant. Valid values are `INSTANCE-ATTACH` or `EIP-ASSOCIATE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkInterfacePermissionState.__new__(_NetworkInterfacePermissionState)

        __props__.__dict__["aws_account_id"] = aws_account_id
        __props__.__dict__["network_interface_id"] = network_interface_id
        __props__.__dict__["network_interface_permission_id"] = network_interface_permission_id
        __props__.__dict__["permission"] = permission
        __props__.__dict__["region"] = region
        __props__.__dict__["timeouts"] = timeouts
        return NetworkInterfacePermission(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Web Services account ID.
        """
        return pulumi.get(self, "aws_account_id")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter(name="networkInterfacePermissionId")
    def network_interface_permission_id(self) -> pulumi.Output[_builtins.str]:
        """
        ENI permission ID.
        """
        return pulumi.get(self, "network_interface_permission_id")

    @_builtins.property
    @pulumi.getter
    def permission(self) -> pulumi.Output[_builtins.str]:
        """
        The type of permission to grant. Valid values are `INSTANCE-ATTACH` or `EIP-ASSOCIATE`.
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.NetworkInterfacePermissionTimeouts']]:
        return pulumi.get(self, "timeouts")

