# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpotInstanceRequestArgs', 'SpotInstanceRequest']

@pulumi.input_type
class SpotInstanceRequestArgs:
    def __init__(__self__, *,
                 ami: Optional[pulumi.Input[_builtins.str]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input['SpotInstanceRequestCapacityReservationSpecificationArgs']] = None,
                 cpu_options: Optional[pulumi.Input['SpotInstanceRequestCpuOptionsArgs']] = None,
                 credit_specification: Optional[pulumi.Input['SpotInstanceRequestCreditSpecificationArgs']] = None,
                 disable_api_stop: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_api_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEbsBlockDeviceArgs']]]] = None,
                 ebs_optimized: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_primary_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 enclave_options: Optional[pulumi.Input['SpotInstanceRequestEnclaveOptionsArgs']] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEphemeralBlockDeviceArgs']]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 get_password_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 hibernation: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_resource_group_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_instance_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_interruption_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_group: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template: Optional[pulumi.Input['SpotInstanceRequestLaunchTemplateArgs']] = None,
                 maintenance_options: Optional[pulumi.Input['SpotInstanceRequestMaintenanceOptionsArgs']] = None,
                 metadata_options: Optional[pulumi.Input['SpotInstanceRequestMetadataOptionsArgs']] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestNetworkInterfaceArgs']]]] = None,
                 placement_group: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_partition_number: Optional[pulumi.Input[_builtins.int]] = None,
                 private_dns_name_options: Optional[pulumi.Input['SpotInstanceRequestPrivateDnsNameOptionsArgs']] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 root_block_device: Optional[pulumi.Input['SpotInstanceRequestRootBlockDeviceArgs']] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 spot_price: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenancy: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_replace_on_change: Optional[pulumi.Input[_builtins.bool]] = None,
                 valid_from: Optional[pulumi.Input[_builtins.str]] = None,
                 valid_until: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 wait_for_fulfillment: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a SpotInstanceRequest resource.
        :param pulumi.Input[_builtins.str] ami: AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        :param pulumi.Input[_builtins.bool] associate_public_ip_address: Whether to associate a public IP address with an instance in a VPC.
        :param pulumi.Input[_builtins.str] availability_zone: AZ to start the instance in.
        :param pulumi.Input['SpotInstanceRequestCapacityReservationSpecificationArgs'] capacity_reservation_specification: Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        :param pulumi.Input['SpotInstanceRequestCpuOptionsArgs'] cpu_options: The CPU options for the instance. See CPU Options below for more details.
        :param pulumi.Input['SpotInstanceRequestCreditSpecificationArgs'] credit_specification: Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        :param pulumi.Input[_builtins.bool] disable_api_stop: If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
        :param pulumi.Input[_builtins.bool] disable_api_termination: If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        :param pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEbsBlockDeviceArgs']]] ebs_block_devices: One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[_builtins.bool] ebs_optimized: If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        :param pulumi.Input[_builtins.bool] enable_primary_ipv6: Whether to assign a primary IPv6 Global Unicast Address (GUA) to the instance when launched in a dual-stack or IPv6-only subnet. A primary IPv6 address ensures a consistent IPv6 address for the instance and is automatically assigned by AWS to the ENI. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains until the instance is terminated or the ENI is detached. Disabling `enable_primary_ipv6` after it has been enabled forces recreation of the instance.
        :param pulumi.Input['SpotInstanceRequestEnclaveOptionsArgs'] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEphemeralBlockDeviceArgs']]] ephemeral_block_devices: One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[_builtins.bool] force_destroy: Destroys instance even if `disable_api_termination` or `disable_api_stop` is set to `true`. Defaults to `false`. Once this parameter is set to `true`, a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the instance or destroying the instance, this flag will not work. Additionally when importing an instance, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        :param pulumi.Input[_builtins.bool] get_password_data: If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[_builtins.bool] hibernation: If true, the launched EC2 instance will support hibernation.
        :param pulumi.Input[_builtins.str] host_id: ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        :param pulumi.Input[_builtins.str] host_resource_group_arn: ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
        :param pulumi.Input[_builtins.str] iam_instance_profile: IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        :param pulumi.Input[_builtins.str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        :param pulumi.Input[_builtins.str] instance_interruption_behavior: Indicates Spot instance behavior when it is interrupted. Valid values are `terminate`, `stop`, or `hibernate`. Default value is `terminate`.
        :param pulumi.Input[_builtins.str] instance_type: Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[_builtins.int] ipv6_address_count: Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        :param pulumi.Input[_builtins.str] key_name: Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        :param pulumi.Input[_builtins.str] launch_group: A launch group is a group of spot instances that launch together and terminate together.
               If left empty instances are launched and terminated individually.
        :param pulumi.Input['SpotInstanceRequestLaunchTemplateArgs'] launch_template: Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
        :param pulumi.Input['SpotInstanceRequestMaintenanceOptionsArgs'] maintenance_options: Maintenance and recovery options for the instance. See Maintenance Options below for more details.
        :param pulumi.Input['SpotInstanceRequestMetadataOptionsArgs'] metadata_options: Customize the metadata options of the instance. See Metadata Options below for more details.
        :param pulumi.Input[_builtins.bool] monitoring: If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        :param pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestNetworkInterfaceArgs']]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        :param pulumi.Input[_builtins.str] placement_group: Placement Group to start the instance in.
        :param pulumi.Input[_builtins.int] placement_partition_number: Number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        :param pulumi.Input['SpotInstanceRequestPrivateDnsNameOptionsArgs'] private_dns_name_options: Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        :param pulumi.Input[_builtins.str] private_ip: Private IP address to associate with the instance in a VPC.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['SpotInstanceRequestRootBlockDeviceArgs'] root_block_device: Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_private_ips: List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: List of security group names to associate with.
               
               > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
        :param pulumi.Input[_builtins.bool] source_dest_check: Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        :param pulumi.Input[_builtins.str] spot_price: The maximum price to request on the spot market.
        :param pulumi.Input[_builtins.str] spot_type: If set to `one-time`, after
               the instance is terminated, the spot request will be closed.
        :param pulumi.Input[_builtins.str] subnet_id: VPC Subnet ID to launch in.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] tenancy: Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
        :param pulumi.Input[_builtins.str] user_data: User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[_builtins.str] user_data_base64: Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[_builtins.bool] user_data_replace_on_change: When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate of the EC2 instance when set to `true`. Defaults to `false` if not set.
        :param pulumi.Input[_builtins.str] valid_from: The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        :param pulumi.Input[_builtins.str] valid_until: The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request. The default end date is 7 days from the current date.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] volume_tags: Map of tags to assign, at instance-creation time, to root and EBS volumes.
               
               > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_security_group_ids: List of security group IDs to associate with.
        :param pulumi.Input[_builtins.bool] wait_for_fulfillment: If set, this provider will
               wait for the Spot Request to be fulfilled, and will throw an error if the
               timeout of 10m is reached.
        """
        if ami is not None:
            pulumi.set(__self__, "ami", ami)
        if associate_public_ip_address is not None:
            pulumi.set(__self__, "associate_public_ip_address", associate_public_ip_address)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if capacity_reservation_specification is not None:
            pulumi.set(__self__, "capacity_reservation_specification", capacity_reservation_specification)
        if cpu_options is not None:
            pulumi.set(__self__, "cpu_options", cpu_options)
        if credit_specification is not None:
            pulumi.set(__self__, "credit_specification", credit_specification)
        if disable_api_stop is not None:
            pulumi.set(__self__, "disable_api_stop", disable_api_stop)
        if disable_api_termination is not None:
            pulumi.set(__self__, "disable_api_termination", disable_api_termination)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if enable_primary_ipv6 is not None:
            pulumi.set(__self__, "enable_primary_ipv6", enable_primary_ipv6)
        if enclave_options is not None:
            pulumi.set(__self__, "enclave_options", enclave_options)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if get_password_data is not None:
            pulumi.set(__self__, "get_password_data", get_password_data)
        if hibernation is not None:
            pulumi.set(__self__, "hibernation", hibernation)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if host_resource_group_arn is not None:
            pulumi.set(__self__, "host_resource_group_arn", host_resource_group_arn)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if instance_initiated_shutdown_behavior is not None:
            pulumi.set(__self__, "instance_initiated_shutdown_behavior", instance_initiated_shutdown_behavior)
        if instance_interruption_behavior is not None:
            pulumi.set(__self__, "instance_interruption_behavior", instance_interruption_behavior)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if launch_group is not None:
            pulumi.set(__self__, "launch_group", launch_group)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if maintenance_options is not None:
            pulumi.set(__self__, "maintenance_options", maintenance_options)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if network_interfaces is not None:
            warnings.warn("""network_interface is deprecated. To specify the primary network interface, use primary_network_interface instead. To attach additional network interfaces, use the ec2.NetworkInterfaceAttachment resource.""", DeprecationWarning)
            pulumi.log.warn("""network_interfaces is deprecated: network_interface is deprecated. To specify the primary network interface, use primary_network_interface instead. To attach additional network interfaces, use the ec2.NetworkInterfaceAttachment resource.""")
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if placement_partition_number is not None:
            pulumi.set(__self__, "placement_partition_number", placement_partition_number)
        if private_dns_name_options is not None:
            pulumi.set(__self__, "private_dns_name_options", private_dns_name_options)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_block_device is not None:
            pulumi.set(__self__, "root_block_device", root_block_device)
        if secondary_private_ips is not None:
            pulumi.set(__self__, "secondary_private_ips", secondary_private_ips)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if spot_price is not None:
            pulumi.set(__self__, "spot_price", spot_price)
        if spot_type is not None:
            pulumi.set(__self__, "spot_type", spot_type)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if user_data_base64 is not None:
            pulumi.set(__self__, "user_data_base64", user_data_base64)
        if user_data_replace_on_change is not None:
            pulumi.set(__self__, "user_data_replace_on_change", user_data_replace_on_change)
        if valid_from is not None:
            pulumi.set(__self__, "valid_from", valid_from)
        if valid_until is not None:
            pulumi.set(__self__, "valid_until", valid_until)
        if volume_tags is not None:
            pulumi.set(__self__, "volume_tags", volume_tags)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)
        if wait_for_fulfillment is not None:
            pulumi.set(__self__, "wait_for_fulfillment", wait_for_fulfillment)

    @_builtins.property
    @pulumi.getter
    def ami(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        """
        return pulumi.get(self, "ami")

    @ami.setter
    def ami(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ami", value)

    @_builtins.property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to associate a public IP address with an instance in a VPC.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @associate_public_ip_address.setter
    def associate_public_ip_address(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "associate_public_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AZ to start the instance in.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="capacityReservationSpecification")
    def capacity_reservation_specification(self) -> Optional[pulumi.Input['SpotInstanceRequestCapacityReservationSpecificationArgs']]:
        """
        Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        """
        return pulumi.get(self, "capacity_reservation_specification")

    @capacity_reservation_specification.setter
    def capacity_reservation_specification(self, value: Optional[pulumi.Input['SpotInstanceRequestCapacityReservationSpecificationArgs']]):
        pulumi.set(self, "capacity_reservation_specification", value)

    @_builtins.property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> Optional[pulumi.Input['SpotInstanceRequestCpuOptionsArgs']]:
        """
        The CPU options for the instance. See CPU Options below for more details.
        """
        return pulumi.get(self, "cpu_options")

    @cpu_options.setter
    def cpu_options(self, value: Optional[pulumi.Input['SpotInstanceRequestCpuOptionsArgs']]):
        pulumi.set(self, "cpu_options", value)

    @_builtins.property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional[pulumi.Input['SpotInstanceRequestCreditSpecificationArgs']]:
        """
        Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        """
        return pulumi.get(self, "credit_specification")

    @credit_specification.setter
    def credit_specification(self, value: Optional[pulumi.Input['SpotInstanceRequestCreditSpecificationArgs']]):
        pulumi.set(self, "credit_specification", value)

    @_builtins.property
    @pulumi.getter(name="disableApiStop")
    def disable_api_stop(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
        """
        return pulumi.get(self, "disable_api_stop")

    @disable_api_stop.setter
    def disable_api_stop(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_api_stop", value)

    @_builtins.property
    @pulumi.getter(name="disableApiTermination")
    def disable_api_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        """
        return pulumi.get(self, "disable_api_termination")

    @disable_api_termination.setter
    def disable_api_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_api_termination", value)

    @_builtins.property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEbsBlockDeviceArgs']]]]:
        """
        One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @_builtins.property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @_builtins.property
    @pulumi.getter(name="enablePrimaryIpv6")
    def enable_primary_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to assign a primary IPv6 Global Unicast Address (GUA) to the instance when launched in a dual-stack or IPv6-only subnet. A primary IPv6 address ensures a consistent IPv6 address for the instance and is automatically assigned by AWS to the ENI. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains until the instance is terminated or the ENI is detached. Disabling `enable_primary_ipv6` after it has been enabled forces recreation of the instance.
        """
        return pulumi.get(self, "enable_primary_ipv6")

    @enable_primary_ipv6.setter
    def enable_primary_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_primary_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="enclaveOptions")
    def enclave_options(self) -> Optional[pulumi.Input['SpotInstanceRequestEnclaveOptionsArgs']]:
        """
        Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        """
        return pulumi.get(self, "enclave_options")

    @enclave_options.setter
    def enclave_options(self, value: Optional[pulumi.Input['SpotInstanceRequestEnclaveOptionsArgs']]):
        pulumi.set(self, "enclave_options", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEphemeralBlockDeviceArgs']]]]:
        """
        One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Destroys instance even if `disable_api_termination` or `disable_api_stop` is set to `true`. Defaults to `false`. Once this parameter is set to `true`, a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the instance or destroying the instance, this flag will not work. Additionally when importing an instance, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="getPasswordData")
    def get_password_data(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        """
        return pulumi.get(self, "get_password_data")

    @get_password_data.setter
    def get_password_data(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "get_password_data", value)

    @_builtins.property
    @pulumi.getter
    def hibernation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the launched EC2 instance will support hibernation.
        """
        return pulumi.get(self, "hibernation")

    @hibernation.setter
    def hibernation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hibernation", value)

    @_builtins.property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_id", value)

    @_builtins.property
    @pulumi.getter(name="hostResourceGroupArn")
    def host_resource_group_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
        """
        return pulumi.get(self, "host_resource_group_arn")

    @host_resource_group_arn.setter
    def host_resource_group_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_resource_group_arn", value)

    @_builtins.property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_instance_profile", value)

    @_builtins.property
    @pulumi.getter(name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        """
        return pulumi.get(self, "instance_initiated_shutdown_behavior")

    @instance_initiated_shutdown_behavior.setter
    def instance_initiated_shutdown_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_initiated_shutdown_behavior", value)

    @_builtins.property
    @pulumi.getter(name="instanceInterruptionBehavior")
    def instance_interruption_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates Spot instance behavior when it is interrupted. Valid values are `terminate`, `stop`, or `hibernate`. Default value is `terminate`.
        """
        return pulumi.get(self, "instance_interruption_behavior")

    @instance_interruption_behavior.setter
    def instance_interruption_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_interruption_behavior", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="launchGroup")
    def launch_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A launch group is a group of spot instances that launch together and terminate together.
        If left empty instances are launched and terminated individually.
        """
        return pulumi.get(self, "launch_group")

    @launch_group.setter
    def launch_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_group", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['SpotInstanceRequestLaunchTemplateArgs']]:
        """
        Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['SpotInstanceRequestLaunchTemplateArgs']]):
        pulumi.set(self, "launch_template", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceOptions")
    def maintenance_options(self) -> Optional[pulumi.Input['SpotInstanceRequestMaintenanceOptionsArgs']]:
        """
        Maintenance and recovery options for the instance. See Maintenance Options below for more details.
        """
        return pulumi.get(self, "maintenance_options")

    @maintenance_options.setter
    def maintenance_options(self, value: Optional[pulumi.Input['SpotInstanceRequestMaintenanceOptionsArgs']]):
        pulumi.set(self, "maintenance_options", value)

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['SpotInstanceRequestMetadataOptionsArgs']]:
        """
        Customize the metadata options of the instance. See Metadata Options below for more details.
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['SpotInstanceRequestMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "monitoring", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    @_utilities.deprecated("""network_interface is deprecated. To specify the primary network interface, use primary_network_interface instead. To attach additional network interfaces, use the ec2.NetworkInterfaceAttachment resource.""")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestNetworkInterfaceArgs']]]]:
        """
        Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Placement Group to start the instance in.
        """
        return pulumi.get(self, "placement_group")

    @placement_group.setter
    def placement_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "placement_group", value)

    @_builtins.property
    @pulumi.getter(name="placementPartitionNumber")
    def placement_partition_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        """
        return pulumi.get(self, "placement_partition_number")

    @placement_partition_number.setter
    def placement_partition_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "placement_partition_number", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsNameOptions")
    def private_dns_name_options(self) -> Optional[pulumi.Input['SpotInstanceRequestPrivateDnsNameOptionsArgs']]:
        """
        Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        """
        return pulumi.get(self, "private_dns_name_options")

    @private_dns_name_options.setter
    def private_dns_name_options(self, value: Optional[pulumi.Input['SpotInstanceRequestPrivateDnsNameOptionsArgs']]):
        pulumi.set(self, "private_dns_name_options", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private IP address to associate with the instance in a VPC.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rootBlockDevice")
    def root_block_device(self) -> Optional[pulumi.Input['SpotInstanceRequestRootBlockDeviceArgs']]:
        """
        Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        """
        return pulumi.get(self, "root_block_device")

    @root_block_device.setter
    def root_block_device(self, value: Optional[pulumi.Input['SpotInstanceRequestRootBlockDeviceArgs']]):
        pulumi.set(self, "root_block_device", value)

    @_builtins.property
    @pulumi.getter(name="secondaryPrivateIps")
    def secondary_private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        """
        return pulumi.get(self, "secondary_private_ips")

    @secondary_private_ips.setter
    def secondary_private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secondary_private_ips", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of security group names to associate with.

        > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        """
        return pulumi.get(self, "source_dest_check")

    @source_dest_check.setter
    def source_dest_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "source_dest_check", value)

    @_builtins.property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum price to request on the spot market.
        """
        return pulumi.get(self, "spot_price")

    @spot_price.setter
    def spot_price(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_price", value)

    @_builtins.property
    @pulumi.getter(name="spotType")
    def spot_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If set to `one-time`, after
        the instance is terminated, the spot request will be closed.
        """
        return pulumi.get(self, "spot_type")

    @spot_type.setter
    def spot_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_type", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC Subnet ID to launch in.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def tenancy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
        """
        return pulumi.get(self, "tenancy")

    @tenancy.setter
    def tenancy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenancy", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="userDataBase64")
    def user_data_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        """
        return pulumi.get(self, "user_data_base64")

    @user_data_base64.setter
    def user_data_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data_base64", value)

    @_builtins.property
    @pulumi.getter(name="userDataReplaceOnChange")
    def user_data_replace_on_change(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate of the EC2 instance when set to `true`. Defaults to `false` if not set.
        """
        return pulumi.get(self, "user_data_replace_on_change")

    @user_data_replace_on_change.setter
    def user_data_replace_on_change(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "user_data_replace_on_change", value)

    @_builtins.property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        """
        return pulumi.get(self, "valid_from")

    @valid_from.setter
    def valid_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "valid_from", value)

    @_builtins.property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request. The default end date is 7 days from the current date.
        """
        return pulumi.get(self, "valid_until")

    @valid_until.setter
    def valid_until(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "valid_until", value)

    @_builtins.property
    @pulumi.getter(name="volumeTags")
    def volume_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign, at instance-creation time, to root and EBS volumes.

        > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
        """
        return pulumi.get(self, "volume_tags")

    @volume_tags.setter
    def volume_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "volume_tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of security group IDs to associate with.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="waitForFulfillment")
    def wait_for_fulfillment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, this provider will
        wait for the Spot Request to be fulfilled, and will throw an error if the
        timeout of 10m is reached.
        """
        return pulumi.get(self, "wait_for_fulfillment")

    @wait_for_fulfillment.setter
    def wait_for_fulfillment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_fulfillment", value)


@pulumi.input_type
class _SpotInstanceRequestState:
    def __init__(__self__, *,
                 ami: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input['SpotInstanceRequestCapacityReservationSpecificationArgs']] = None,
                 cpu_options: Optional[pulumi.Input['SpotInstanceRequestCpuOptionsArgs']] = None,
                 credit_specification: Optional[pulumi.Input['SpotInstanceRequestCreditSpecificationArgs']] = None,
                 disable_api_stop: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_api_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEbsBlockDeviceArgs']]]] = None,
                 ebs_optimized: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_primary_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 enclave_options: Optional[pulumi.Input['SpotInstanceRequestEnclaveOptionsArgs']] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEphemeralBlockDeviceArgs']]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 get_password_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 hibernation: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_resource_group_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_instance_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_interruption_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_state: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_group: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template: Optional[pulumi.Input['SpotInstanceRequestLaunchTemplateArgs']] = None,
                 maintenance_options: Optional[pulumi.Input['SpotInstanceRequestMaintenanceOptionsArgs']] = None,
                 metadata_options: Optional[pulumi.Input['SpotInstanceRequestMetadataOptionsArgs']] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestNetworkInterfaceArgs']]]] = None,
                 outpost_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 password_data: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_group: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_partition_number: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestPrimaryNetworkInterfaceArgs']]]] = None,
                 private_dns: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_name_options: Optional[pulumi.Input['SpotInstanceRequestPrivateDnsNameOptionsArgs']] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_dns: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 root_block_device: Optional[pulumi.Input['SpotInstanceRequestRootBlockDeviceArgs']] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 spot_bid_status: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_price: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_request_state: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenancy: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_replace_on_change: Optional[pulumi.Input[_builtins.bool]] = None,
                 valid_from: Optional[pulumi.Input[_builtins.str]] = None,
                 valid_until: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 wait_for_fulfillment: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering SpotInstanceRequest resources.
        :param pulumi.Input[_builtins.str] ami: AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        :param pulumi.Input[_builtins.bool] associate_public_ip_address: Whether to associate a public IP address with an instance in a VPC.
        :param pulumi.Input[_builtins.str] availability_zone: AZ to start the instance in.
        :param pulumi.Input['SpotInstanceRequestCapacityReservationSpecificationArgs'] capacity_reservation_specification: Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        :param pulumi.Input['SpotInstanceRequestCpuOptionsArgs'] cpu_options: The CPU options for the instance. See CPU Options below for more details.
        :param pulumi.Input['SpotInstanceRequestCreditSpecificationArgs'] credit_specification: Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        :param pulumi.Input[_builtins.bool] disable_api_stop: If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
        :param pulumi.Input[_builtins.bool] disable_api_termination: If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        :param pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEbsBlockDeviceArgs']]] ebs_block_devices: One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[_builtins.bool] ebs_optimized: If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        :param pulumi.Input[_builtins.bool] enable_primary_ipv6: Whether to assign a primary IPv6 Global Unicast Address (GUA) to the instance when launched in a dual-stack or IPv6-only subnet. A primary IPv6 address ensures a consistent IPv6 address for the instance and is automatically assigned by AWS to the ENI. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains until the instance is terminated or the ENI is detached. Disabling `enable_primary_ipv6` after it has been enabled forces recreation of the instance.
        :param pulumi.Input['SpotInstanceRequestEnclaveOptionsArgs'] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEphemeralBlockDeviceArgs']]] ephemeral_block_devices: One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[_builtins.bool] force_destroy: Destroys instance even if `disable_api_termination` or `disable_api_stop` is set to `true`. Defaults to `false`. Once this parameter is set to `true`, a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the instance or destroying the instance, this flag will not work. Additionally when importing an instance, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        :param pulumi.Input[_builtins.bool] get_password_data: If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[_builtins.bool] hibernation: If true, the launched EC2 instance will support hibernation.
        :param pulumi.Input[_builtins.str] host_id: ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        :param pulumi.Input[_builtins.str] host_resource_group_arn: ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
        :param pulumi.Input[_builtins.str] iam_instance_profile: IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        :param pulumi.Input[_builtins.str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        :param pulumi.Input[_builtins.str] instance_interruption_behavior: Indicates Spot instance behavior when it is interrupted. Valid values are `terminate`, `stop`, or `hibernate`. Default value is `terminate`.
        :param pulumi.Input[_builtins.str] instance_type: Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[_builtins.int] ipv6_address_count: Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        :param pulumi.Input[_builtins.str] key_name: Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        :param pulumi.Input[_builtins.str] launch_group: A launch group is a group of spot instances that launch together and terminate together.
               If left empty instances are launched and terminated individually.
        :param pulumi.Input['SpotInstanceRequestLaunchTemplateArgs'] launch_template: Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
        :param pulumi.Input['SpotInstanceRequestMaintenanceOptionsArgs'] maintenance_options: Maintenance and recovery options for the instance. See Maintenance Options below for more details.
        :param pulumi.Input['SpotInstanceRequestMetadataOptionsArgs'] metadata_options: Customize the metadata options of the instance. See Metadata Options below for more details.
        :param pulumi.Input[_builtins.bool] monitoring: If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        :param pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestNetworkInterfaceArgs']]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        :param pulumi.Input[_builtins.str] placement_group: Placement Group to start the instance in.
        :param pulumi.Input[_builtins.int] placement_partition_number: Number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        :param pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestPrimaryNetworkInterfaceArgs']]] primary_network_interfaces: The primary network interface. See Primary Network Interface below.
        :param pulumi.Input[_builtins.str] private_dns: The private DNS name assigned to the instance. Can only be
               used inside the Amazon EC2, and only available if you've enabled DNS hostnames
               for your VPC
        :param pulumi.Input['SpotInstanceRequestPrivateDnsNameOptionsArgs'] private_dns_name_options: Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        :param pulumi.Input[_builtins.str] private_ip: Private IP address to associate with the instance in a VPC.
        :param pulumi.Input[_builtins.str] public_dns: The public DNS name assigned to the instance. For EC2-VPC, this
               is only available if you've enabled DNS hostnames for your VPC
        :param pulumi.Input[_builtins.str] public_ip: The public IP address assigned to the instance, if applicable.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['SpotInstanceRequestRootBlockDeviceArgs'] root_block_device: Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_private_ips: List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: List of security group names to associate with.
               
               > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
        :param pulumi.Input[_builtins.bool] source_dest_check: Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        :param pulumi.Input[_builtins.str] spot_bid_status: The current [bid
               status](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html)
               of the Spot Instance Request.
        :param pulumi.Input[_builtins.str] spot_instance_id: The Instance ID (if any) that is currently fulfilling
               the Spot Instance request.
        :param pulumi.Input[_builtins.str] spot_price: The maximum price to request on the spot market.
        :param pulumi.Input[_builtins.str] spot_request_state: The current [request
               state](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html#creating-spot-request-status)
               of the Spot Instance Request.
        :param pulumi.Input[_builtins.str] spot_type: If set to `one-time`, after
               the instance is terminated, the spot request will be closed.
        :param pulumi.Input[_builtins.str] subnet_id: VPC Subnet ID to launch in.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] tenancy: Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
        :param pulumi.Input[_builtins.str] user_data: User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[_builtins.str] user_data_base64: Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[_builtins.bool] user_data_replace_on_change: When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate of the EC2 instance when set to `true`. Defaults to `false` if not set.
        :param pulumi.Input[_builtins.str] valid_from: The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        :param pulumi.Input[_builtins.str] valid_until: The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request. The default end date is 7 days from the current date.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] volume_tags: Map of tags to assign, at instance-creation time, to root and EBS volumes.
               
               > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_security_group_ids: List of security group IDs to associate with.
        :param pulumi.Input[_builtins.bool] wait_for_fulfillment: If set, this provider will
               wait for the Spot Request to be fulfilled, and will throw an error if the
               timeout of 10m is reached.
        """
        if ami is not None:
            pulumi.set(__self__, "ami", ami)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if associate_public_ip_address is not None:
            pulumi.set(__self__, "associate_public_ip_address", associate_public_ip_address)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if capacity_reservation_specification is not None:
            pulumi.set(__self__, "capacity_reservation_specification", capacity_reservation_specification)
        if cpu_options is not None:
            pulumi.set(__self__, "cpu_options", cpu_options)
        if credit_specification is not None:
            pulumi.set(__self__, "credit_specification", credit_specification)
        if disable_api_stop is not None:
            pulumi.set(__self__, "disable_api_stop", disable_api_stop)
        if disable_api_termination is not None:
            pulumi.set(__self__, "disable_api_termination", disable_api_termination)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if enable_primary_ipv6 is not None:
            pulumi.set(__self__, "enable_primary_ipv6", enable_primary_ipv6)
        if enclave_options is not None:
            pulumi.set(__self__, "enclave_options", enclave_options)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if get_password_data is not None:
            pulumi.set(__self__, "get_password_data", get_password_data)
        if hibernation is not None:
            pulumi.set(__self__, "hibernation", hibernation)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if host_resource_group_arn is not None:
            pulumi.set(__self__, "host_resource_group_arn", host_resource_group_arn)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if instance_initiated_shutdown_behavior is not None:
            pulumi.set(__self__, "instance_initiated_shutdown_behavior", instance_initiated_shutdown_behavior)
        if instance_interruption_behavior is not None:
            pulumi.set(__self__, "instance_interruption_behavior", instance_interruption_behavior)
        if instance_state is not None:
            pulumi.set(__self__, "instance_state", instance_state)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if launch_group is not None:
            pulumi.set(__self__, "launch_group", launch_group)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if maintenance_options is not None:
            pulumi.set(__self__, "maintenance_options", maintenance_options)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if network_interfaces is not None:
            warnings.warn("""network_interface is deprecated. To specify the primary network interface, use primary_network_interface instead. To attach additional network interfaces, use the ec2.NetworkInterfaceAttachment resource.""", DeprecationWarning)
            pulumi.log.warn("""network_interfaces is deprecated: network_interface is deprecated. To specify the primary network interface, use primary_network_interface instead. To attach additional network interfaces, use the ec2.NetworkInterfaceAttachment resource.""")
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if outpost_arn is not None:
            pulumi.set(__self__, "outpost_arn", outpost_arn)
        if password_data is not None:
            pulumi.set(__self__, "password_data", password_data)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if placement_partition_number is not None:
            pulumi.set(__self__, "placement_partition_number", placement_partition_number)
        if primary_network_interface_id is not None:
            pulumi.set(__self__, "primary_network_interface_id", primary_network_interface_id)
        if primary_network_interfaces is not None:
            pulumi.set(__self__, "primary_network_interfaces", primary_network_interfaces)
        if private_dns is not None:
            pulumi.set(__self__, "private_dns", private_dns)
        if private_dns_name_options is not None:
            pulumi.set(__self__, "private_dns_name_options", private_dns_name_options)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_dns is not None:
            pulumi.set(__self__, "public_dns", public_dns)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_block_device is not None:
            pulumi.set(__self__, "root_block_device", root_block_device)
        if secondary_private_ips is not None:
            pulumi.set(__self__, "secondary_private_ips", secondary_private_ips)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if spot_bid_status is not None:
            pulumi.set(__self__, "spot_bid_status", spot_bid_status)
        if spot_instance_id is not None:
            pulumi.set(__self__, "spot_instance_id", spot_instance_id)
        if spot_price is not None:
            pulumi.set(__self__, "spot_price", spot_price)
        if spot_request_state is not None:
            pulumi.set(__self__, "spot_request_state", spot_request_state)
        if spot_type is not None:
            pulumi.set(__self__, "spot_type", spot_type)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if user_data_base64 is not None:
            pulumi.set(__self__, "user_data_base64", user_data_base64)
        if user_data_replace_on_change is not None:
            pulumi.set(__self__, "user_data_replace_on_change", user_data_replace_on_change)
        if valid_from is not None:
            pulumi.set(__self__, "valid_from", valid_from)
        if valid_until is not None:
            pulumi.set(__self__, "valid_until", valid_until)
        if volume_tags is not None:
            pulumi.set(__self__, "volume_tags", volume_tags)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)
        if wait_for_fulfillment is not None:
            pulumi.set(__self__, "wait_for_fulfillment", wait_for_fulfillment)

    @_builtins.property
    @pulumi.getter
    def ami(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        """
        return pulumi.get(self, "ami")

    @ami.setter
    def ami(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ami", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to associate a public IP address with an instance in a VPC.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @associate_public_ip_address.setter
    def associate_public_ip_address(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "associate_public_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AZ to start the instance in.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="capacityReservationSpecification")
    def capacity_reservation_specification(self) -> Optional[pulumi.Input['SpotInstanceRequestCapacityReservationSpecificationArgs']]:
        """
        Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        """
        return pulumi.get(self, "capacity_reservation_specification")

    @capacity_reservation_specification.setter
    def capacity_reservation_specification(self, value: Optional[pulumi.Input['SpotInstanceRequestCapacityReservationSpecificationArgs']]):
        pulumi.set(self, "capacity_reservation_specification", value)

    @_builtins.property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> Optional[pulumi.Input['SpotInstanceRequestCpuOptionsArgs']]:
        """
        The CPU options for the instance. See CPU Options below for more details.
        """
        return pulumi.get(self, "cpu_options")

    @cpu_options.setter
    def cpu_options(self, value: Optional[pulumi.Input['SpotInstanceRequestCpuOptionsArgs']]):
        pulumi.set(self, "cpu_options", value)

    @_builtins.property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional[pulumi.Input['SpotInstanceRequestCreditSpecificationArgs']]:
        """
        Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        """
        return pulumi.get(self, "credit_specification")

    @credit_specification.setter
    def credit_specification(self, value: Optional[pulumi.Input['SpotInstanceRequestCreditSpecificationArgs']]):
        pulumi.set(self, "credit_specification", value)

    @_builtins.property
    @pulumi.getter(name="disableApiStop")
    def disable_api_stop(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
        """
        return pulumi.get(self, "disable_api_stop")

    @disable_api_stop.setter
    def disable_api_stop(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_api_stop", value)

    @_builtins.property
    @pulumi.getter(name="disableApiTermination")
    def disable_api_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        """
        return pulumi.get(self, "disable_api_termination")

    @disable_api_termination.setter
    def disable_api_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_api_termination", value)

    @_builtins.property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEbsBlockDeviceArgs']]]]:
        """
        One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @_builtins.property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @_builtins.property
    @pulumi.getter(name="enablePrimaryIpv6")
    def enable_primary_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to assign a primary IPv6 Global Unicast Address (GUA) to the instance when launched in a dual-stack or IPv6-only subnet. A primary IPv6 address ensures a consistent IPv6 address for the instance and is automatically assigned by AWS to the ENI. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains until the instance is terminated or the ENI is detached. Disabling `enable_primary_ipv6` after it has been enabled forces recreation of the instance.
        """
        return pulumi.get(self, "enable_primary_ipv6")

    @enable_primary_ipv6.setter
    def enable_primary_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_primary_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="enclaveOptions")
    def enclave_options(self) -> Optional[pulumi.Input['SpotInstanceRequestEnclaveOptionsArgs']]:
        """
        Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        """
        return pulumi.get(self, "enclave_options")

    @enclave_options.setter
    def enclave_options(self, value: Optional[pulumi.Input['SpotInstanceRequestEnclaveOptionsArgs']]):
        pulumi.set(self, "enclave_options", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEphemeralBlockDeviceArgs']]]]:
        """
        One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Destroys instance even if `disable_api_termination` or `disable_api_stop` is set to `true`. Defaults to `false`. Once this parameter is set to `true`, a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the instance or destroying the instance, this flag will not work. Additionally when importing an instance, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="getPasswordData")
    def get_password_data(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        """
        return pulumi.get(self, "get_password_data")

    @get_password_data.setter
    def get_password_data(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "get_password_data", value)

    @_builtins.property
    @pulumi.getter
    def hibernation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the launched EC2 instance will support hibernation.
        """
        return pulumi.get(self, "hibernation")

    @hibernation.setter
    def hibernation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hibernation", value)

    @_builtins.property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_id", value)

    @_builtins.property
    @pulumi.getter(name="hostResourceGroupArn")
    def host_resource_group_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
        """
        return pulumi.get(self, "host_resource_group_arn")

    @host_resource_group_arn.setter
    def host_resource_group_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_resource_group_arn", value)

    @_builtins.property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_instance_profile", value)

    @_builtins.property
    @pulumi.getter(name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        """
        return pulumi.get(self, "instance_initiated_shutdown_behavior")

    @instance_initiated_shutdown_behavior.setter
    def instance_initiated_shutdown_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_initiated_shutdown_behavior", value)

    @_builtins.property
    @pulumi.getter(name="instanceInterruptionBehavior")
    def instance_interruption_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates Spot instance behavior when it is interrupted. Valid values are `terminate`, `stop`, or `hibernate`. Default value is `terminate`.
        """
        return pulumi.get(self, "instance_interruption_behavior")

    @instance_interruption_behavior.setter
    def instance_interruption_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_interruption_behavior", value)

    @_builtins.property
    @pulumi.getter(name="instanceState")
    def instance_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "instance_state")

    @instance_state.setter
    def instance_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_state", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="launchGroup")
    def launch_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A launch group is a group of spot instances that launch together and terminate together.
        If left empty instances are launched and terminated individually.
        """
        return pulumi.get(self, "launch_group")

    @launch_group.setter
    def launch_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_group", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['SpotInstanceRequestLaunchTemplateArgs']]:
        """
        Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['SpotInstanceRequestLaunchTemplateArgs']]):
        pulumi.set(self, "launch_template", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceOptions")
    def maintenance_options(self) -> Optional[pulumi.Input['SpotInstanceRequestMaintenanceOptionsArgs']]:
        """
        Maintenance and recovery options for the instance. See Maintenance Options below for more details.
        """
        return pulumi.get(self, "maintenance_options")

    @maintenance_options.setter
    def maintenance_options(self, value: Optional[pulumi.Input['SpotInstanceRequestMaintenanceOptionsArgs']]):
        pulumi.set(self, "maintenance_options", value)

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['SpotInstanceRequestMetadataOptionsArgs']]:
        """
        Customize the metadata options of the instance. See Metadata Options below for more details.
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['SpotInstanceRequestMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "monitoring", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    @_utilities.deprecated("""network_interface is deprecated. To specify the primary network interface, use primary_network_interface instead. To attach additional network interfaces, use the ec2.NetworkInterfaceAttachment resource.""")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestNetworkInterfaceArgs']]]]:
        """
        Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "outpost_arn")

    @outpost_arn.setter
    def outpost_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "outpost_arn", value)

    @_builtins.property
    @pulumi.getter(name="passwordData")
    def password_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "password_data")

    @password_data.setter
    def password_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_data", value)

    @_builtins.property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Placement Group to start the instance in.
        """
        return pulumi.get(self, "placement_group")

    @placement_group.setter
    def placement_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "placement_group", value)

    @_builtins.property
    @pulumi.getter(name="placementPartitionNumber")
    def placement_partition_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        """
        return pulumi.get(self, "placement_partition_number")

    @placement_partition_number.setter
    def placement_partition_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "placement_partition_number", value)

    @_builtins.property
    @pulumi.getter(name="primaryNetworkInterfaceId")
    def primary_network_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "primary_network_interface_id")

    @primary_network_interface_id.setter
    def primary_network_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_network_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="primaryNetworkInterfaces")
    def primary_network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestPrimaryNetworkInterfaceArgs']]]]:
        """
        The primary network interface. See Primary Network Interface below.
        """
        return pulumi.get(self, "primary_network_interfaces")

    @primary_network_interfaces.setter
    def primary_network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpotInstanceRequestPrimaryNetworkInterfaceArgs']]]]):
        pulumi.set(self, "primary_network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="privateDns")
    def private_dns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private DNS name assigned to the instance. Can only be
        used inside the Amazon EC2, and only available if you've enabled DNS hostnames
        for your VPC
        """
        return pulumi.get(self, "private_dns")

    @private_dns.setter
    def private_dns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_dns", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsNameOptions")
    def private_dns_name_options(self) -> Optional[pulumi.Input['SpotInstanceRequestPrivateDnsNameOptionsArgs']]:
        """
        Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        """
        return pulumi.get(self, "private_dns_name_options")

    @private_dns_name_options.setter
    def private_dns_name_options(self, value: Optional[pulumi.Input['SpotInstanceRequestPrivateDnsNameOptionsArgs']]):
        pulumi.set(self, "private_dns_name_options", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private IP address to associate with the instance in a VPC.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="publicDns")
    def public_dns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public DNS name assigned to the instance. For EC2-VPC, this
        is only available if you've enabled DNS hostnames for your VPC
        """
        return pulumi.get(self, "public_dns")

    @public_dns.setter
    def public_dns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_dns", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public IP address assigned to the instance, if applicable.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rootBlockDevice")
    def root_block_device(self) -> Optional[pulumi.Input['SpotInstanceRequestRootBlockDeviceArgs']]:
        """
        Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        """
        return pulumi.get(self, "root_block_device")

    @root_block_device.setter
    def root_block_device(self, value: Optional[pulumi.Input['SpotInstanceRequestRootBlockDeviceArgs']]):
        pulumi.set(self, "root_block_device", value)

    @_builtins.property
    @pulumi.getter(name="secondaryPrivateIps")
    def secondary_private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        """
        return pulumi.get(self, "secondary_private_ips")

    @secondary_private_ips.setter
    def secondary_private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secondary_private_ips", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of security group names to associate with.

        > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        """
        return pulumi.get(self, "source_dest_check")

    @source_dest_check.setter
    def source_dest_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "source_dest_check", value)

    @_builtins.property
    @pulumi.getter(name="spotBidStatus")
    def spot_bid_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current [bid
        status](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html)
        of the Spot Instance Request.
        """
        return pulumi.get(self, "spot_bid_status")

    @spot_bid_status.setter
    def spot_bid_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_bid_status", value)

    @_builtins.property
    @pulumi.getter(name="spotInstanceId")
    def spot_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Instance ID (if any) that is currently fulfilling
        the Spot Instance request.
        """
        return pulumi.get(self, "spot_instance_id")

    @spot_instance_id.setter
    def spot_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum price to request on the spot market.
        """
        return pulumi.get(self, "spot_price")

    @spot_price.setter
    def spot_price(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_price", value)

    @_builtins.property
    @pulumi.getter(name="spotRequestState")
    def spot_request_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current [request
        state](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html#creating-spot-request-status)
        of the Spot Instance Request.
        """
        return pulumi.get(self, "spot_request_state")

    @spot_request_state.setter
    def spot_request_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_request_state", value)

    @_builtins.property
    @pulumi.getter(name="spotType")
    def spot_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If set to `one-time`, after
        the instance is terminated, the spot request will be closed.
        """
        return pulumi.get(self, "spot_type")

    @spot_type.setter
    def spot_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_type", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC Subnet ID to launch in.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def tenancy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
        """
        return pulumi.get(self, "tenancy")

    @tenancy.setter
    def tenancy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenancy", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="userDataBase64")
    def user_data_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        """
        return pulumi.get(self, "user_data_base64")

    @user_data_base64.setter
    def user_data_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data_base64", value)

    @_builtins.property
    @pulumi.getter(name="userDataReplaceOnChange")
    def user_data_replace_on_change(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate of the EC2 instance when set to `true`. Defaults to `false` if not set.
        """
        return pulumi.get(self, "user_data_replace_on_change")

    @user_data_replace_on_change.setter
    def user_data_replace_on_change(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "user_data_replace_on_change", value)

    @_builtins.property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        """
        return pulumi.get(self, "valid_from")

    @valid_from.setter
    def valid_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "valid_from", value)

    @_builtins.property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request. The default end date is 7 days from the current date.
        """
        return pulumi.get(self, "valid_until")

    @valid_until.setter
    def valid_until(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "valid_until", value)

    @_builtins.property
    @pulumi.getter(name="volumeTags")
    def volume_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign, at instance-creation time, to root and EBS volumes.

        > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
        """
        return pulumi.get(self, "volume_tags")

    @volume_tags.setter
    def volume_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "volume_tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of security group IDs to associate with.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="waitForFulfillment")
    def wait_for_fulfillment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, this provider will
        wait for the Spot Request to be fulfilled, and will throw an error if the
        timeout of 10m is reached.
        """
        return pulumi.get(self, "wait_for_fulfillment")

    @wait_for_fulfillment.setter
    def wait_for_fulfillment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_fulfillment", value)


@pulumi.type_token("aws:ec2/spotInstanceRequest:SpotInstanceRequest")
class SpotInstanceRequest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami: Optional[pulumi.Input[_builtins.str]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input[Union['SpotInstanceRequestCapacityReservationSpecificationArgs', 'SpotInstanceRequestCapacityReservationSpecificationArgsDict']]] = None,
                 cpu_options: Optional[pulumi.Input[Union['SpotInstanceRequestCpuOptionsArgs', 'SpotInstanceRequestCpuOptionsArgsDict']]] = None,
                 credit_specification: Optional[pulumi.Input[Union['SpotInstanceRequestCreditSpecificationArgs', 'SpotInstanceRequestCreditSpecificationArgsDict']]] = None,
                 disable_api_stop: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_api_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestEbsBlockDeviceArgs', 'SpotInstanceRequestEbsBlockDeviceArgsDict']]]]] = None,
                 ebs_optimized: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_primary_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 enclave_options: Optional[pulumi.Input[Union['SpotInstanceRequestEnclaveOptionsArgs', 'SpotInstanceRequestEnclaveOptionsArgsDict']]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestEphemeralBlockDeviceArgs', 'SpotInstanceRequestEphemeralBlockDeviceArgsDict']]]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 get_password_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 hibernation: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_resource_group_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_instance_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_interruption_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_group: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template: Optional[pulumi.Input[Union['SpotInstanceRequestLaunchTemplateArgs', 'SpotInstanceRequestLaunchTemplateArgsDict']]] = None,
                 maintenance_options: Optional[pulumi.Input[Union['SpotInstanceRequestMaintenanceOptionsArgs', 'SpotInstanceRequestMaintenanceOptionsArgsDict']]] = None,
                 metadata_options: Optional[pulumi.Input[Union['SpotInstanceRequestMetadataOptionsArgs', 'SpotInstanceRequestMetadataOptionsArgsDict']]] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestNetworkInterfaceArgs', 'SpotInstanceRequestNetworkInterfaceArgsDict']]]]] = None,
                 placement_group: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_partition_number: Optional[pulumi.Input[_builtins.int]] = None,
                 private_dns_name_options: Optional[pulumi.Input[Union['SpotInstanceRequestPrivateDnsNameOptionsArgs', 'SpotInstanceRequestPrivateDnsNameOptionsArgsDict']]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 root_block_device: Optional[pulumi.Input[Union['SpotInstanceRequestRootBlockDeviceArgs', 'SpotInstanceRequestRootBlockDeviceArgsDict']]] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 spot_price: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenancy: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_replace_on_change: Optional[pulumi.Input[_builtins.bool]] = None,
                 valid_from: Optional[pulumi.Input[_builtins.str]] = None,
                 valid_until: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 wait_for_fulfillment: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        # Request a spot instance at $0.03
        cheap_worker = aws.ec2.SpotInstanceRequest("cheap_worker",
            ami="ami-1234",
            spot_price="0.03",
            instance_type="c4.xlarge",
            tags={
                "Name": "CheapWorker",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ami: AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        :param pulumi.Input[_builtins.bool] associate_public_ip_address: Whether to associate a public IP address with an instance in a VPC.
        :param pulumi.Input[_builtins.str] availability_zone: AZ to start the instance in.
        :param pulumi.Input[Union['SpotInstanceRequestCapacityReservationSpecificationArgs', 'SpotInstanceRequestCapacityReservationSpecificationArgsDict']] capacity_reservation_specification: Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        :param pulumi.Input[Union['SpotInstanceRequestCpuOptionsArgs', 'SpotInstanceRequestCpuOptionsArgsDict']] cpu_options: The CPU options for the instance. See CPU Options below for more details.
        :param pulumi.Input[Union['SpotInstanceRequestCreditSpecificationArgs', 'SpotInstanceRequestCreditSpecificationArgsDict']] credit_specification: Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        :param pulumi.Input[_builtins.bool] disable_api_stop: If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
        :param pulumi.Input[_builtins.bool] disable_api_termination: If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestEbsBlockDeviceArgs', 'SpotInstanceRequestEbsBlockDeviceArgsDict']]]] ebs_block_devices: One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[_builtins.bool] ebs_optimized: If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        :param pulumi.Input[_builtins.bool] enable_primary_ipv6: Whether to assign a primary IPv6 Global Unicast Address (GUA) to the instance when launched in a dual-stack or IPv6-only subnet. A primary IPv6 address ensures a consistent IPv6 address for the instance and is automatically assigned by AWS to the ENI. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains until the instance is terminated or the ENI is detached. Disabling `enable_primary_ipv6` after it has been enabled forces recreation of the instance.
        :param pulumi.Input[Union['SpotInstanceRequestEnclaveOptionsArgs', 'SpotInstanceRequestEnclaveOptionsArgsDict']] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestEphemeralBlockDeviceArgs', 'SpotInstanceRequestEphemeralBlockDeviceArgsDict']]]] ephemeral_block_devices: One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[_builtins.bool] force_destroy: Destroys instance even if `disable_api_termination` or `disable_api_stop` is set to `true`. Defaults to `false`. Once this parameter is set to `true`, a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the instance or destroying the instance, this flag will not work. Additionally when importing an instance, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        :param pulumi.Input[_builtins.bool] get_password_data: If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[_builtins.bool] hibernation: If true, the launched EC2 instance will support hibernation.
        :param pulumi.Input[_builtins.str] host_id: ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        :param pulumi.Input[_builtins.str] host_resource_group_arn: ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
        :param pulumi.Input[_builtins.str] iam_instance_profile: IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        :param pulumi.Input[_builtins.str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        :param pulumi.Input[_builtins.str] instance_interruption_behavior: Indicates Spot instance behavior when it is interrupted. Valid values are `terminate`, `stop`, or `hibernate`. Default value is `terminate`.
        :param pulumi.Input[_builtins.str] instance_type: Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[_builtins.int] ipv6_address_count: Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        :param pulumi.Input[_builtins.str] key_name: Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        :param pulumi.Input[_builtins.str] launch_group: A launch group is a group of spot instances that launch together and terminate together.
               If left empty instances are launched and terminated individually.
        :param pulumi.Input[Union['SpotInstanceRequestLaunchTemplateArgs', 'SpotInstanceRequestLaunchTemplateArgsDict']] launch_template: Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
        :param pulumi.Input[Union['SpotInstanceRequestMaintenanceOptionsArgs', 'SpotInstanceRequestMaintenanceOptionsArgsDict']] maintenance_options: Maintenance and recovery options for the instance. See Maintenance Options below for more details.
        :param pulumi.Input[Union['SpotInstanceRequestMetadataOptionsArgs', 'SpotInstanceRequestMetadataOptionsArgsDict']] metadata_options: Customize the metadata options of the instance. See Metadata Options below for more details.
        :param pulumi.Input[_builtins.bool] monitoring: If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestNetworkInterfaceArgs', 'SpotInstanceRequestNetworkInterfaceArgsDict']]]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        :param pulumi.Input[_builtins.str] placement_group: Placement Group to start the instance in.
        :param pulumi.Input[_builtins.int] placement_partition_number: Number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        :param pulumi.Input[Union['SpotInstanceRequestPrivateDnsNameOptionsArgs', 'SpotInstanceRequestPrivateDnsNameOptionsArgsDict']] private_dns_name_options: Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        :param pulumi.Input[_builtins.str] private_ip: Private IP address to associate with the instance in a VPC.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['SpotInstanceRequestRootBlockDeviceArgs', 'SpotInstanceRequestRootBlockDeviceArgsDict']] root_block_device: Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_private_ips: List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: List of security group names to associate with.
               
               > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
        :param pulumi.Input[_builtins.bool] source_dest_check: Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        :param pulumi.Input[_builtins.str] spot_price: The maximum price to request on the spot market.
        :param pulumi.Input[_builtins.str] spot_type: If set to `one-time`, after
               the instance is terminated, the spot request will be closed.
        :param pulumi.Input[_builtins.str] subnet_id: VPC Subnet ID to launch in.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] tenancy: Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
        :param pulumi.Input[_builtins.str] user_data: User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[_builtins.str] user_data_base64: Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[_builtins.bool] user_data_replace_on_change: When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate of the EC2 instance when set to `true`. Defaults to `false` if not set.
        :param pulumi.Input[_builtins.str] valid_from: The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        :param pulumi.Input[_builtins.str] valid_until: The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request. The default end date is 7 days from the current date.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] volume_tags: Map of tags to assign, at instance-creation time, to root and EBS volumes.
               
               > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_security_group_ids: List of security group IDs to associate with.
        :param pulumi.Input[_builtins.bool] wait_for_fulfillment: If set, this provider will
               wait for the Spot Request to be fulfilled, and will throw an error if the
               timeout of 10m is reached.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SpotInstanceRequestArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        # Request a spot instance at $0.03
        cheap_worker = aws.ec2.SpotInstanceRequest("cheap_worker",
            ami="ami-1234",
            spot_price="0.03",
            instance_type="c4.xlarge",
            tags={
                "Name": "CheapWorker",
            })
        ```

        :param str resource_name: The name of the resource.
        :param SpotInstanceRequestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpotInstanceRequestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami: Optional[pulumi.Input[_builtins.str]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input[Union['SpotInstanceRequestCapacityReservationSpecificationArgs', 'SpotInstanceRequestCapacityReservationSpecificationArgsDict']]] = None,
                 cpu_options: Optional[pulumi.Input[Union['SpotInstanceRequestCpuOptionsArgs', 'SpotInstanceRequestCpuOptionsArgsDict']]] = None,
                 credit_specification: Optional[pulumi.Input[Union['SpotInstanceRequestCreditSpecificationArgs', 'SpotInstanceRequestCreditSpecificationArgsDict']]] = None,
                 disable_api_stop: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_api_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestEbsBlockDeviceArgs', 'SpotInstanceRequestEbsBlockDeviceArgsDict']]]]] = None,
                 ebs_optimized: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_primary_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 enclave_options: Optional[pulumi.Input[Union['SpotInstanceRequestEnclaveOptionsArgs', 'SpotInstanceRequestEnclaveOptionsArgsDict']]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestEphemeralBlockDeviceArgs', 'SpotInstanceRequestEphemeralBlockDeviceArgsDict']]]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 get_password_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 hibernation: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_resource_group_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_instance_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_interruption_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_group: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template: Optional[pulumi.Input[Union['SpotInstanceRequestLaunchTemplateArgs', 'SpotInstanceRequestLaunchTemplateArgsDict']]] = None,
                 maintenance_options: Optional[pulumi.Input[Union['SpotInstanceRequestMaintenanceOptionsArgs', 'SpotInstanceRequestMaintenanceOptionsArgsDict']]] = None,
                 metadata_options: Optional[pulumi.Input[Union['SpotInstanceRequestMetadataOptionsArgs', 'SpotInstanceRequestMetadataOptionsArgsDict']]] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestNetworkInterfaceArgs', 'SpotInstanceRequestNetworkInterfaceArgsDict']]]]] = None,
                 placement_group: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_partition_number: Optional[pulumi.Input[_builtins.int]] = None,
                 private_dns_name_options: Optional[pulumi.Input[Union['SpotInstanceRequestPrivateDnsNameOptionsArgs', 'SpotInstanceRequestPrivateDnsNameOptionsArgsDict']]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 root_block_device: Optional[pulumi.Input[Union['SpotInstanceRequestRootBlockDeviceArgs', 'SpotInstanceRequestRootBlockDeviceArgsDict']]] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 spot_price: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenancy: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_replace_on_change: Optional[pulumi.Input[_builtins.bool]] = None,
                 valid_from: Optional[pulumi.Input[_builtins.str]] = None,
                 valid_until: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 wait_for_fulfillment: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpotInstanceRequestArgs.__new__(SpotInstanceRequestArgs)

            __props__.__dict__["ami"] = ami
            __props__.__dict__["associate_public_ip_address"] = associate_public_ip_address
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["capacity_reservation_specification"] = capacity_reservation_specification
            __props__.__dict__["cpu_options"] = cpu_options
            __props__.__dict__["credit_specification"] = credit_specification
            __props__.__dict__["disable_api_stop"] = disable_api_stop
            __props__.__dict__["disable_api_termination"] = disable_api_termination
            __props__.__dict__["ebs_block_devices"] = ebs_block_devices
            __props__.__dict__["ebs_optimized"] = ebs_optimized
            __props__.__dict__["enable_primary_ipv6"] = enable_primary_ipv6
            __props__.__dict__["enclave_options"] = enclave_options
            __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["get_password_data"] = get_password_data
            __props__.__dict__["hibernation"] = hibernation
            __props__.__dict__["host_id"] = host_id
            __props__.__dict__["host_resource_group_arn"] = host_resource_group_arn
            __props__.__dict__["iam_instance_profile"] = iam_instance_profile
            __props__.__dict__["instance_initiated_shutdown_behavior"] = instance_initiated_shutdown_behavior
            __props__.__dict__["instance_interruption_behavior"] = instance_interruption_behavior
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["ipv6_address_count"] = ipv6_address_count
            __props__.__dict__["ipv6_addresses"] = ipv6_addresses
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["launch_group"] = launch_group
            __props__.__dict__["launch_template"] = launch_template
            __props__.__dict__["maintenance_options"] = maintenance_options
            __props__.__dict__["metadata_options"] = metadata_options
            __props__.__dict__["monitoring"] = monitoring
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["placement_group"] = placement_group
            __props__.__dict__["placement_partition_number"] = placement_partition_number
            __props__.__dict__["private_dns_name_options"] = private_dns_name_options
            __props__.__dict__["private_ip"] = private_ip
            __props__.__dict__["region"] = region
            __props__.__dict__["root_block_device"] = root_block_device
            __props__.__dict__["secondary_private_ips"] = secondary_private_ips
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["source_dest_check"] = source_dest_check
            __props__.__dict__["spot_price"] = spot_price
            __props__.__dict__["spot_type"] = spot_type
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenancy"] = tenancy
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["user_data_base64"] = user_data_base64
            __props__.__dict__["user_data_replace_on_change"] = user_data_replace_on_change
            __props__.__dict__["valid_from"] = valid_from
            __props__.__dict__["valid_until"] = valid_until
            __props__.__dict__["volume_tags"] = volume_tags
            __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
            __props__.__dict__["wait_for_fulfillment"] = wait_for_fulfillment
            __props__.__dict__["arn"] = None
            __props__.__dict__["instance_state"] = None
            __props__.__dict__["outpost_arn"] = None
            __props__.__dict__["password_data"] = None
            __props__.__dict__["primary_network_interface_id"] = None
            __props__.__dict__["primary_network_interfaces"] = None
            __props__.__dict__["private_dns"] = None
            __props__.__dict__["public_dns"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["spot_bid_status"] = None
            __props__.__dict__["spot_instance_id"] = None
            __props__.__dict__["spot_request_state"] = None
            __props__.__dict__["tags_all"] = None
        super(SpotInstanceRequest, __self__).__init__(
            'aws:ec2/spotInstanceRequest:SpotInstanceRequest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ami: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            associate_public_ip_address: Optional[pulumi.Input[_builtins.bool]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            capacity_reservation_specification: Optional[pulumi.Input[Union['SpotInstanceRequestCapacityReservationSpecificationArgs', 'SpotInstanceRequestCapacityReservationSpecificationArgsDict']]] = None,
            cpu_options: Optional[pulumi.Input[Union['SpotInstanceRequestCpuOptionsArgs', 'SpotInstanceRequestCpuOptionsArgsDict']]] = None,
            credit_specification: Optional[pulumi.Input[Union['SpotInstanceRequestCreditSpecificationArgs', 'SpotInstanceRequestCreditSpecificationArgsDict']]] = None,
            disable_api_stop: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_api_termination: Optional[pulumi.Input[_builtins.bool]] = None,
            ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestEbsBlockDeviceArgs', 'SpotInstanceRequestEbsBlockDeviceArgsDict']]]]] = None,
            ebs_optimized: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_primary_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
            enclave_options: Optional[pulumi.Input[Union['SpotInstanceRequestEnclaveOptionsArgs', 'SpotInstanceRequestEnclaveOptionsArgsDict']]] = None,
            ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestEphemeralBlockDeviceArgs', 'SpotInstanceRequestEphemeralBlockDeviceArgsDict']]]]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            get_password_data: Optional[pulumi.Input[_builtins.bool]] = None,
            hibernation: Optional[pulumi.Input[_builtins.bool]] = None,
            host_id: Optional[pulumi.Input[_builtins.str]] = None,
            host_resource_group_arn: Optional[pulumi.Input[_builtins.str]] = None,
            iam_instance_profile: Optional[pulumi.Input[_builtins.str]] = None,
            instance_initiated_shutdown_behavior: Optional[pulumi.Input[_builtins.str]] = None,
            instance_interruption_behavior: Optional[pulumi.Input[_builtins.str]] = None,
            instance_state: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
            ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            key_name: Optional[pulumi.Input[_builtins.str]] = None,
            launch_group: Optional[pulumi.Input[_builtins.str]] = None,
            launch_template: Optional[pulumi.Input[Union['SpotInstanceRequestLaunchTemplateArgs', 'SpotInstanceRequestLaunchTemplateArgsDict']]] = None,
            maintenance_options: Optional[pulumi.Input[Union['SpotInstanceRequestMaintenanceOptionsArgs', 'SpotInstanceRequestMaintenanceOptionsArgsDict']]] = None,
            metadata_options: Optional[pulumi.Input[Union['SpotInstanceRequestMetadataOptionsArgs', 'SpotInstanceRequestMetadataOptionsArgsDict']]] = None,
            monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestNetworkInterfaceArgs', 'SpotInstanceRequestNetworkInterfaceArgsDict']]]]] = None,
            outpost_arn: Optional[pulumi.Input[_builtins.str]] = None,
            password_data: Optional[pulumi.Input[_builtins.str]] = None,
            placement_group: Optional[pulumi.Input[_builtins.str]] = None,
            placement_partition_number: Optional[pulumi.Input[_builtins.int]] = None,
            primary_network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            primary_network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestPrimaryNetworkInterfaceArgs', 'SpotInstanceRequestPrimaryNetworkInterfaceArgsDict']]]]] = None,
            private_dns: Optional[pulumi.Input[_builtins.str]] = None,
            private_dns_name_options: Optional[pulumi.Input[Union['SpotInstanceRequestPrivateDnsNameOptionsArgs', 'SpotInstanceRequestPrivateDnsNameOptionsArgsDict']]] = None,
            private_ip: Optional[pulumi.Input[_builtins.str]] = None,
            public_dns: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            root_block_device: Optional[pulumi.Input[Union['SpotInstanceRequestRootBlockDeviceArgs', 'SpotInstanceRequestRootBlockDeviceArgsDict']]] = None,
            secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            source_dest_check: Optional[pulumi.Input[_builtins.bool]] = None,
            spot_bid_status: Optional[pulumi.Input[_builtins.str]] = None,
            spot_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            spot_price: Optional[pulumi.Input[_builtins.str]] = None,
            spot_request_state: Optional[pulumi.Input[_builtins.str]] = None,
            spot_type: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tenancy: Optional[pulumi.Input[_builtins.str]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            user_data_base64: Optional[pulumi.Input[_builtins.str]] = None,
            user_data_replace_on_change: Optional[pulumi.Input[_builtins.bool]] = None,
            valid_from: Optional[pulumi.Input[_builtins.str]] = None,
            valid_until: Optional[pulumi.Input[_builtins.str]] = None,
            volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            wait_for_fulfillment: Optional[pulumi.Input[_builtins.bool]] = None) -> 'SpotInstanceRequest':
        """
        Get an existing SpotInstanceRequest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ami: AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        :param pulumi.Input[_builtins.bool] associate_public_ip_address: Whether to associate a public IP address with an instance in a VPC.
        :param pulumi.Input[_builtins.str] availability_zone: AZ to start the instance in.
        :param pulumi.Input[Union['SpotInstanceRequestCapacityReservationSpecificationArgs', 'SpotInstanceRequestCapacityReservationSpecificationArgsDict']] capacity_reservation_specification: Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        :param pulumi.Input[Union['SpotInstanceRequestCpuOptionsArgs', 'SpotInstanceRequestCpuOptionsArgsDict']] cpu_options: The CPU options for the instance. See CPU Options below for more details.
        :param pulumi.Input[Union['SpotInstanceRequestCreditSpecificationArgs', 'SpotInstanceRequestCreditSpecificationArgsDict']] credit_specification: Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        :param pulumi.Input[_builtins.bool] disable_api_stop: If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
        :param pulumi.Input[_builtins.bool] disable_api_termination: If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestEbsBlockDeviceArgs', 'SpotInstanceRequestEbsBlockDeviceArgsDict']]]] ebs_block_devices: One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[_builtins.bool] ebs_optimized: If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        :param pulumi.Input[_builtins.bool] enable_primary_ipv6: Whether to assign a primary IPv6 Global Unicast Address (GUA) to the instance when launched in a dual-stack or IPv6-only subnet. A primary IPv6 address ensures a consistent IPv6 address for the instance and is automatically assigned by AWS to the ENI. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains until the instance is terminated or the ENI is detached. Disabling `enable_primary_ipv6` after it has been enabled forces recreation of the instance.
        :param pulumi.Input[Union['SpotInstanceRequestEnclaveOptionsArgs', 'SpotInstanceRequestEnclaveOptionsArgsDict']] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestEphemeralBlockDeviceArgs', 'SpotInstanceRequestEphemeralBlockDeviceArgsDict']]]] ephemeral_block_devices: One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[_builtins.bool] force_destroy: Destroys instance even if `disable_api_termination` or `disable_api_stop` is set to `true`. Defaults to `false`. Once this parameter is set to `true`, a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the instance or destroying the instance, this flag will not work. Additionally when importing an instance, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        :param pulumi.Input[_builtins.bool] get_password_data: If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[_builtins.bool] hibernation: If true, the launched EC2 instance will support hibernation.
        :param pulumi.Input[_builtins.str] host_id: ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        :param pulumi.Input[_builtins.str] host_resource_group_arn: ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
        :param pulumi.Input[_builtins.str] iam_instance_profile: IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        :param pulumi.Input[_builtins.str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        :param pulumi.Input[_builtins.str] instance_interruption_behavior: Indicates Spot instance behavior when it is interrupted. Valid values are `terminate`, `stop`, or `hibernate`. Default value is `terminate`.
        :param pulumi.Input[_builtins.str] instance_type: Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[_builtins.int] ipv6_address_count: Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        :param pulumi.Input[_builtins.str] key_name: Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        :param pulumi.Input[_builtins.str] launch_group: A launch group is a group of spot instances that launch together and terminate together.
               If left empty instances are launched and terminated individually.
        :param pulumi.Input[Union['SpotInstanceRequestLaunchTemplateArgs', 'SpotInstanceRequestLaunchTemplateArgsDict']] launch_template: Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
        :param pulumi.Input[Union['SpotInstanceRequestMaintenanceOptionsArgs', 'SpotInstanceRequestMaintenanceOptionsArgsDict']] maintenance_options: Maintenance and recovery options for the instance. See Maintenance Options below for more details.
        :param pulumi.Input[Union['SpotInstanceRequestMetadataOptionsArgs', 'SpotInstanceRequestMetadataOptionsArgsDict']] metadata_options: Customize the metadata options of the instance. See Metadata Options below for more details.
        :param pulumi.Input[_builtins.bool] monitoring: If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestNetworkInterfaceArgs', 'SpotInstanceRequestNetworkInterfaceArgsDict']]]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        :param pulumi.Input[_builtins.str] placement_group: Placement Group to start the instance in.
        :param pulumi.Input[_builtins.int] placement_partition_number: Number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpotInstanceRequestPrimaryNetworkInterfaceArgs', 'SpotInstanceRequestPrimaryNetworkInterfaceArgsDict']]]] primary_network_interfaces: The primary network interface. See Primary Network Interface below.
        :param pulumi.Input[_builtins.str] private_dns: The private DNS name assigned to the instance. Can only be
               used inside the Amazon EC2, and only available if you've enabled DNS hostnames
               for your VPC
        :param pulumi.Input[Union['SpotInstanceRequestPrivateDnsNameOptionsArgs', 'SpotInstanceRequestPrivateDnsNameOptionsArgsDict']] private_dns_name_options: Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        :param pulumi.Input[_builtins.str] private_ip: Private IP address to associate with the instance in a VPC.
        :param pulumi.Input[_builtins.str] public_dns: The public DNS name assigned to the instance. For EC2-VPC, this
               is only available if you've enabled DNS hostnames for your VPC
        :param pulumi.Input[_builtins.str] public_ip: The public IP address assigned to the instance, if applicable.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['SpotInstanceRequestRootBlockDeviceArgs', 'SpotInstanceRequestRootBlockDeviceArgsDict']] root_block_device: Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_private_ips: List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: List of security group names to associate with.
               
               > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
        :param pulumi.Input[_builtins.bool] source_dest_check: Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        :param pulumi.Input[_builtins.str] spot_bid_status: The current [bid
               status](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html)
               of the Spot Instance Request.
        :param pulumi.Input[_builtins.str] spot_instance_id: The Instance ID (if any) that is currently fulfilling
               the Spot Instance request.
        :param pulumi.Input[_builtins.str] spot_price: The maximum price to request on the spot market.
        :param pulumi.Input[_builtins.str] spot_request_state: The current [request
               state](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html#creating-spot-request-status)
               of the Spot Instance Request.
        :param pulumi.Input[_builtins.str] spot_type: If set to `one-time`, after
               the instance is terminated, the spot request will be closed.
        :param pulumi.Input[_builtins.str] subnet_id: VPC Subnet ID to launch in.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] tenancy: Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
        :param pulumi.Input[_builtins.str] user_data: User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[_builtins.str] user_data_base64: Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[_builtins.bool] user_data_replace_on_change: When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate of the EC2 instance when set to `true`. Defaults to `false` if not set.
        :param pulumi.Input[_builtins.str] valid_from: The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        :param pulumi.Input[_builtins.str] valid_until: The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request. The default end date is 7 days from the current date.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] volume_tags: Map of tags to assign, at instance-creation time, to root and EBS volumes.
               
               > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_security_group_ids: List of security group IDs to associate with.
        :param pulumi.Input[_builtins.bool] wait_for_fulfillment: If set, this provider will
               wait for the Spot Request to be fulfilled, and will throw an error if the
               timeout of 10m is reached.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpotInstanceRequestState.__new__(_SpotInstanceRequestState)

        __props__.__dict__["ami"] = ami
        __props__.__dict__["arn"] = arn
        __props__.__dict__["associate_public_ip_address"] = associate_public_ip_address
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["capacity_reservation_specification"] = capacity_reservation_specification
        __props__.__dict__["cpu_options"] = cpu_options
        __props__.__dict__["credit_specification"] = credit_specification
        __props__.__dict__["disable_api_stop"] = disable_api_stop
        __props__.__dict__["disable_api_termination"] = disable_api_termination
        __props__.__dict__["ebs_block_devices"] = ebs_block_devices
        __props__.__dict__["ebs_optimized"] = ebs_optimized
        __props__.__dict__["enable_primary_ipv6"] = enable_primary_ipv6
        __props__.__dict__["enclave_options"] = enclave_options
        __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["get_password_data"] = get_password_data
        __props__.__dict__["hibernation"] = hibernation
        __props__.__dict__["host_id"] = host_id
        __props__.__dict__["host_resource_group_arn"] = host_resource_group_arn
        __props__.__dict__["iam_instance_profile"] = iam_instance_profile
        __props__.__dict__["instance_initiated_shutdown_behavior"] = instance_initiated_shutdown_behavior
        __props__.__dict__["instance_interruption_behavior"] = instance_interruption_behavior
        __props__.__dict__["instance_state"] = instance_state
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["ipv6_address_count"] = ipv6_address_count
        __props__.__dict__["ipv6_addresses"] = ipv6_addresses
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["launch_group"] = launch_group
        __props__.__dict__["launch_template"] = launch_template
        __props__.__dict__["maintenance_options"] = maintenance_options
        __props__.__dict__["metadata_options"] = metadata_options
        __props__.__dict__["monitoring"] = monitoring
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["outpost_arn"] = outpost_arn
        __props__.__dict__["password_data"] = password_data
        __props__.__dict__["placement_group"] = placement_group
        __props__.__dict__["placement_partition_number"] = placement_partition_number
        __props__.__dict__["primary_network_interface_id"] = primary_network_interface_id
        __props__.__dict__["primary_network_interfaces"] = primary_network_interfaces
        __props__.__dict__["private_dns"] = private_dns
        __props__.__dict__["private_dns_name_options"] = private_dns_name_options
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["public_dns"] = public_dns
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["root_block_device"] = root_block_device
        __props__.__dict__["secondary_private_ips"] = secondary_private_ips
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["source_dest_check"] = source_dest_check
        __props__.__dict__["spot_bid_status"] = spot_bid_status
        __props__.__dict__["spot_instance_id"] = spot_instance_id
        __props__.__dict__["spot_price"] = spot_price
        __props__.__dict__["spot_request_state"] = spot_request_state
        __props__.__dict__["spot_type"] = spot_type
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["tenancy"] = tenancy
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["user_data_base64"] = user_data_base64
        __props__.__dict__["user_data_replace_on_change"] = user_data_replace_on_change
        __props__.__dict__["valid_from"] = valid_from
        __props__.__dict__["valid_until"] = valid_until
        __props__.__dict__["volume_tags"] = volume_tags
        __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
        __props__.__dict__["wait_for_fulfillment"] = wait_for_fulfillment
        return SpotInstanceRequest(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def ami(self) -> pulumi.Output[_builtins.str]:
        """
        AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        """
        return pulumi.get(self, "ami")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to associate a public IP address with an instance in a VPC.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        AZ to start the instance in.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="capacityReservationSpecification")
    def capacity_reservation_specification(self) -> pulumi.Output['outputs.SpotInstanceRequestCapacityReservationSpecification']:
        """
        Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        """
        return pulumi.get(self, "capacity_reservation_specification")

    @_builtins.property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> pulumi.Output['outputs.SpotInstanceRequestCpuOptions']:
        """
        The CPU options for the instance. See CPU Options below for more details.
        """
        return pulumi.get(self, "cpu_options")

    @_builtins.property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> pulumi.Output[Optional['outputs.SpotInstanceRequestCreditSpecification']]:
        """
        Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        """
        return pulumi.get(self, "credit_specification")

    @_builtins.property
    @pulumi.getter(name="disableApiStop")
    def disable_api_stop(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
        """
        return pulumi.get(self, "disable_api_stop")

    @_builtins.property
    @pulumi.getter(name="disableApiTermination")
    def disable_api_termination(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        """
        return pulumi.get(self, "disable_api_termination")

    @_builtins.property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> pulumi.Output[Sequence['outputs.SpotInstanceRequestEbsBlockDevice']]:
        """
        One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ebs_block_devices")

    @_builtins.property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        """
        return pulumi.get(self, "ebs_optimized")

    @_builtins.property
    @pulumi.getter(name="enablePrimaryIpv6")
    def enable_primary_ipv6(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to assign a primary IPv6 Global Unicast Address (GUA) to the instance when launched in a dual-stack or IPv6-only subnet. A primary IPv6 address ensures a consistent IPv6 address for the instance and is automatically assigned by AWS to the ENI. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains until the instance is terminated or the ENI is detached. Disabling `enable_primary_ipv6` after it has been enabled forces recreation of the instance.
        """
        return pulumi.get(self, "enable_primary_ipv6")

    @_builtins.property
    @pulumi.getter(name="enclaveOptions")
    def enclave_options(self) -> pulumi.Output['outputs.SpotInstanceRequestEnclaveOptions']:
        """
        Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        """
        return pulumi.get(self, "enclave_options")

    @_builtins.property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> pulumi.Output[Sequence['outputs.SpotInstanceRequestEphemeralBlockDevice']]:
        """
        One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Destroys instance even if `disable_api_termination` or `disable_api_stop` is set to `true`. Defaults to `false`. Once this parameter is set to `true`, a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the instance or destroying the instance, this flag will not work. Additionally when importing an instance, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter(name="getPasswordData")
    def get_password_data(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        """
        return pulumi.get(self, "get_password_data")

    @_builtins.property
    @pulumi.getter
    def hibernation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, the launched EC2 instance will support hibernation.
        """
        return pulumi.get(self, "hibernation")

    @_builtins.property
    @pulumi.getter(name="hostId")
    def host_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        """
        return pulumi.get(self, "host_id")

    @_builtins.property
    @pulumi.getter(name="hostResourceGroupArn")
    def host_resource_group_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
        """
        return pulumi.get(self, "host_resource_group_arn")

    @_builtins.property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> pulumi.Output[_builtins.str]:
        """
        IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        """
        return pulumi.get(self, "iam_instance_profile")

    @_builtins.property
    @pulumi.getter(name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> pulumi.Output[_builtins.str]:
        """
        Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        """
        return pulumi.get(self, "instance_initiated_shutdown_behavior")

    @_builtins.property
    @pulumi.getter(name="instanceInterruptionBehavior")
    def instance_interruption_behavior(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates Spot instance behavior when it is interrupted. Valid values are `terminate`, `stop`, or `hibernate`. Default value is `terminate`.
        """
        return pulumi.get(self, "instance_interruption_behavior")

    @_builtins.property
    @pulumi.getter(name="instanceState")
    def instance_state(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "instance_state")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        """
        return pulumi.get(self, "ipv6_address_count")

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        """
        return pulumi.get(self, "ipv6_addresses")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[_builtins.str]:
        """
        Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="launchGroup")
    def launch_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A launch group is a group of spot instances that launch together and terminate together.
        If left empty instances are launched and terminated individually.
        """
        return pulumi.get(self, "launch_group")

    @_builtins.property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> pulumi.Output[Optional['outputs.SpotInstanceRequestLaunchTemplate']]:
        """
        Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
        """
        return pulumi.get(self, "launch_template")

    @_builtins.property
    @pulumi.getter(name="maintenanceOptions")
    def maintenance_options(self) -> pulumi.Output['outputs.SpotInstanceRequestMaintenanceOptions']:
        """
        Maintenance and recovery options for the instance. See Maintenance Options below for more details.
        """
        return pulumi.get(self, "maintenance_options")

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> pulumi.Output['outputs.SpotInstanceRequestMetadataOptions']:
        """
        Customize the metadata options of the instance. See Metadata Options below for more details.
        """
        return pulumi.get(self, "metadata_options")

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        """
        return pulumi.get(self, "monitoring")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    @_utilities.deprecated("""network_interface is deprecated. To specify the primary network interface, use primary_network_interface instead. To attach additional network interfaces, use the ec2.NetworkInterfaceAttachment resource.""")
    def network_interfaces(self) -> pulumi.Output[Sequence['outputs.SpotInstanceRequestNetworkInterface']]:
        """
        Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "outpost_arn")

    @_builtins.property
    @pulumi.getter(name="passwordData")
    def password_data(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "password_data")

    @_builtins.property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> pulumi.Output[_builtins.str]:
        """
        Placement Group to start the instance in.
        """
        return pulumi.get(self, "placement_group")

    @_builtins.property
    @pulumi.getter(name="placementPartitionNumber")
    def placement_partition_number(self) -> pulumi.Output[_builtins.int]:
        """
        Number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        """
        return pulumi.get(self, "placement_partition_number")

    @_builtins.property
    @pulumi.getter(name="primaryNetworkInterfaceId")
    def primary_network_interface_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "primary_network_interface_id")

    @_builtins.property
    @pulumi.getter(name="primaryNetworkInterfaces")
    def primary_network_interfaces(self) -> pulumi.Output[Sequence['outputs.SpotInstanceRequestPrimaryNetworkInterface']]:
        """
        The primary network interface. See Primary Network Interface below.
        """
        return pulumi.get(self, "primary_network_interfaces")

    @_builtins.property
    @pulumi.getter(name="privateDns")
    def private_dns(self) -> pulumi.Output[_builtins.str]:
        """
        The private DNS name assigned to the instance. Can only be
        used inside the Amazon EC2, and only available if you've enabled DNS hostnames
        for your VPC
        """
        return pulumi.get(self, "private_dns")

    @_builtins.property
    @pulumi.getter(name="privateDnsNameOptions")
    def private_dns_name_options(self) -> pulumi.Output['outputs.SpotInstanceRequestPrivateDnsNameOptions']:
        """
        Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        """
        return pulumi.get(self, "private_dns_name_options")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Private IP address to associate with the instance in a VPC.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="publicDns")
    def public_dns(self) -> pulumi.Output[_builtins.str]:
        """
        The public DNS name assigned to the instance. For EC2-VPC, this
        is only available if you've enabled DNS hostnames for your VPC
        """
        return pulumi.get(self, "public_dns")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The public IP address assigned to the instance, if applicable.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rootBlockDevice")
    def root_block_device(self) -> pulumi.Output['outputs.SpotInstanceRequestRootBlockDevice']:
        """
        Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        """
        return pulumi.get(self, "root_block_device")

    @_builtins.property
    @pulumi.getter(name="secondaryPrivateIps")
    def secondary_private_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        """
        return pulumi.get(self, "secondary_private_ips")

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of security group names to associate with.

        > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
        """
        return pulumi.get(self, "security_groups")

    @_builtins.property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        """
        return pulumi.get(self, "source_dest_check")

    @_builtins.property
    @pulumi.getter(name="spotBidStatus")
    def spot_bid_status(self) -> pulumi.Output[_builtins.str]:
        """
        The current [bid
        status](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html)
        of the Spot Instance Request.
        """
        return pulumi.get(self, "spot_bid_status")

    @_builtins.property
    @pulumi.getter(name="spotInstanceId")
    def spot_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Instance ID (if any) that is currently fulfilling
        the Spot Instance request.
        """
        return pulumi.get(self, "spot_instance_id")

    @_builtins.property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> pulumi.Output[_builtins.str]:
        """
        The maximum price to request on the spot market.
        """
        return pulumi.get(self, "spot_price")

    @_builtins.property
    @pulumi.getter(name="spotRequestState")
    def spot_request_state(self) -> pulumi.Output[_builtins.str]:
        """
        The current [request
        state](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html#creating-spot-request-status)
        of the Spot Instance Request.
        """
        return pulumi.get(self, "spot_request_state")

    @_builtins.property
    @pulumi.getter(name="spotType")
    def spot_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If set to `one-time`, after
        the instance is terminated, the spot request will be closed.
        """
        return pulumi.get(self, "spot_type")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        VPC Subnet ID to launch in.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def tenancy(self) -> pulumi.Output[_builtins.str]:
        """
        Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
        """
        return pulumi.get(self, "tenancy")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="userDataBase64")
    def user_data_base64(self) -> pulumi.Output[_builtins.str]:
        """
        Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        """
        return pulumi.get(self, "user_data_base64")

    @_builtins.property
    @pulumi.getter(name="userDataReplaceOnChange")
    def user_data_replace_on_change(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate of the EC2 instance when set to `true`. Defaults to `false` if not set.
        """
        return pulumi.get(self, "user_data_replace_on_change")

    @_builtins.property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> pulumi.Output[_builtins.str]:
        """
        The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        """
        return pulumi.get(self, "valid_from")

    @_builtins.property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> pulumi.Output[_builtins.str]:
        """
        The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request. The default end date is 7 days from the current date.
        """
        return pulumi.get(self, "valid_until")

    @_builtins.property
    @pulumi.getter(name="volumeTags")
    def volume_tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign, at instance-creation time, to root and EBS volumes.

        > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
        """
        return pulumi.get(self, "volume_tags")

    @_builtins.property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of security group IDs to associate with.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="waitForFulfillment")
    def wait_for_fulfillment(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, this provider will
        wait for the Spot Request to be fulfilled, and will throw an error if the
        timeout of 10m is reached.
        """
        return pulumi.get(self, "wait_for_fulfillment")

