# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VpnConnectionRouteInitArgs', 'VpnConnectionRoute']

@pulumi.input_type
class VpnConnectionRouteInitArgs:
    def __init__(__self__, *,
                 destination_cidr_block: pulumi.Input[_builtins.str],
                 vpn_connection_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VpnConnectionRoute resource.
        :param pulumi.Input[_builtins.str] destination_cidr_block: The CIDR block associated with the local subnet of the customer network.
        :param pulumi.Input[_builtins.str] vpn_connection_id: The ID of the VPN connection.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        pulumi.set(__self__, "vpn_connection_id", vpn_connection_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> pulumi.Input[_builtins.str]:
        """
        The CIDR block associated with the local subnet of the customer network.
        """
        return pulumi.get(self, "destination_cidr_block")

    @destination_cidr_block.setter
    def destination_cidr_block(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPN connection.
        """
        return pulumi.get(self, "vpn_connection_id")

    @vpn_connection_id.setter
    def vpn_connection_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpn_connection_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _VpnConnectionRouteState:
    def __init__(__self__, *,
                 destination_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_connection_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpnConnectionRoute resources.
        :param pulumi.Input[_builtins.str] destination_cidr_block: The CIDR block associated with the local subnet of the customer network.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] vpn_connection_id: The ID of the VPN connection.
        """
        if destination_cidr_block is not None:
            pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if vpn_connection_id is not None:
            pulumi.set(__self__, "vpn_connection_id", vpn_connection_id)

    @_builtins.property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR block associated with the local subnet of the customer network.
        """
        return pulumi.get(self, "destination_cidr_block")

    @destination_cidr_block.setter
    def destination_cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_cidr_block", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPN connection.
        """
        return pulumi.get(self, "vpn_connection_id")

    @vpn_connection_id.setter
    def vpn_connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_connection_id", value)


@pulumi.type_token("aws:ec2/vpnConnectionRoute:VpnConnectionRoute")
class VpnConnectionRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a static route between a VPN connection and a customer gateway.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        vpc = aws.ec2.Vpc("vpc", cidr_block="10.0.0.0/16")
        vpn_gateway = aws.ec2.VpnGateway("vpn_gateway", vpc_id=vpc.id)
        customer_gateway = aws.ec2.CustomerGateway("customer_gateway",
            bgp_asn="65000",
            ip_address="172.0.0.1",
            type="ipsec.1")
        main = aws.ec2.VpnConnection("main",
            vpn_gateway_id=vpn_gateway.id,
            customer_gateway_id=customer_gateway.id,
            type="ipsec.1",
            static_routes_only=True)
        office = aws.ec2.VpnConnectionRoute("office",
            destination_cidr_block="192.168.10.0/24",
            vpn_connection_id=main.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] destination_cidr_block: The CIDR block associated with the local subnet of the customer network.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] vpn_connection_id: The ID of the VPN connection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpnConnectionRouteInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a static route between a VPN connection and a customer gateway.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        vpc = aws.ec2.Vpc("vpc", cidr_block="10.0.0.0/16")
        vpn_gateway = aws.ec2.VpnGateway("vpn_gateway", vpc_id=vpc.id)
        customer_gateway = aws.ec2.CustomerGateway("customer_gateway",
            bgp_asn="65000",
            ip_address="172.0.0.1",
            type="ipsec.1")
        main = aws.ec2.VpnConnection("main",
            vpn_gateway_id=vpn_gateway.id,
            customer_gateway_id=customer_gateway.id,
            type="ipsec.1",
            static_routes_only=True)
        office = aws.ec2.VpnConnectionRoute("office",
            destination_cidr_block="192.168.10.0/24",
            vpn_connection_id=main.id)
        ```

        :param str resource_name: The name of the resource.
        :param VpnConnectionRouteInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpnConnectionRouteInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpnConnectionRouteInitArgs.__new__(VpnConnectionRouteInitArgs)

            if destination_cidr_block is None and not opts.urn:
                raise TypeError("Missing required property 'destination_cidr_block'")
            __props__.__dict__["destination_cidr_block"] = destination_cidr_block
            __props__.__dict__["region"] = region
            if vpn_connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpn_connection_id'")
            __props__.__dict__["vpn_connection_id"] = vpn_connection_id
        super(VpnConnectionRoute, __self__).__init__(
            'aws:ec2/vpnConnectionRoute:VpnConnectionRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destination_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            vpn_connection_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VpnConnectionRoute':
        """
        Get an existing VpnConnectionRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] destination_cidr_block: The CIDR block associated with the local subnet of the customer network.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] vpn_connection_id: The ID of the VPN connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpnConnectionRouteState.__new__(_VpnConnectionRouteState)

        __props__.__dict__["destination_cidr_block"] = destination_cidr_block
        __props__.__dict__["region"] = region
        __props__.__dict__["vpn_connection_id"] = vpn_connection_id
        return VpnConnectionRoute(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> pulumi.Output[_builtins.str]:
        """
        The CIDR block associated with the local subnet of the customer network.
        """
        return pulumi.get(self, "destination_cidr_block")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPN connection.
        """
        return pulumi.get(self, "vpn_connection_id")

