# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetImagesResult',
    'AwaitableGetImagesResult',
    'get_images',
    'get_images_output',
]

@pulumi.output_type
class GetImagesResult:
    """
    A collection of values returned by getImages.
    """
    def __init__(__self__, id=None, image_ids=None, region=None, registry_id=None, repository_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_ids and not isinstance(image_ids, list):
            raise TypeError("Expected argument 'image_ids' to be a list")
        pulumi.set(__self__, "image_ids", image_ids)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if registry_id and not isinstance(registry_id, str):
            raise TypeError("Expected argument 'registry_id' to be a str")
        pulumi.set(__self__, "registry_id", registry_id)
        if repository_name and not isinstance(repository_name, str):
            raise TypeError("Expected argument 'repository_name' to be a str")
        pulumi.set(__self__, "repository_name", repository_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageIds")
    def image_ids(self) -> Sequence['outputs.GetImagesImageIdResult']:
        """
        List of image objects containing image digest and tags. Each object has the following attributes:
        """
        return pulumi.get(self, "image_ids")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "registry_id")

    @_builtins.property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> _builtins.str:
        return pulumi.get(self, "repository_name")


class AwaitableGetImagesResult(GetImagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImagesResult(
            id=self.id,
            image_ids=self.image_ids,
            region=self.region,
            registry_id=self.registry_id,
            repository_name=self.repository_name)


def get_images(region: Optional[_builtins.str] = None,
               registry_id: Optional[_builtins.str] = None,
               repository_name: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImagesResult:
    """
    The ECR Images data source allows the list of images in a specified repository to be retrieved.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ecr.get_images(repository_name="my-repository")
    pulumi.export("imageDigests", [img.image_digest for img in example.image_ids if img.image_digest != None])
    pulumi.export("imageTags", [img.image_tag for img in example.image_ids if img.image_tag != None])
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str registry_id: ID of the Registry where the repository resides.
    :param _builtins.str repository_name: Name of the ECR Repository.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['registryId'] = registry_id
    __args__['repositoryName'] = repository_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ecr/getImages:getImages', __args__, opts=opts, typ=GetImagesResult).value

    return AwaitableGetImagesResult(
        id=pulumi.get(__ret__, 'id'),
        image_ids=pulumi.get(__ret__, 'image_ids'),
        region=pulumi.get(__ret__, 'region'),
        registry_id=pulumi.get(__ret__, 'registry_id'),
        repository_name=pulumi.get(__ret__, 'repository_name'))
def get_images_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      registry_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      repository_name: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImagesResult]:
    """
    The ECR Images data source allows the list of images in a specified repository to be retrieved.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ecr.get_images(repository_name="my-repository")
    pulumi.export("imageDigests", [img.image_digest for img in example.image_ids if img.image_digest != None])
    pulumi.export("imageTags", [img.image_tag for img in example.image_ids if img.image_tag != None])
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str registry_id: ID of the Registry where the repository resides.
    :param _builtins.str repository_name: Name of the ECR Repository.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['registryId'] = registry_id
    __args__['repositoryName'] = repository_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ecr/getImages:getImages', __args__, opts=opts, typ=GetImagesResult)
    return __ret__.apply(lambda __response__: GetImagesResult(
        id=pulumi.get(__response__, 'id'),
        image_ids=pulumi.get(__response__, 'image_ids'),
        region=pulumi.get(__response__, 'region'),
        registry_id=pulumi.get(__response__, 'registry_id'),
        repository_name=pulumi.get(__response__, 'repository_name')))
