# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReplicationConfigurationArgs', 'ReplicationConfiguration']

@pulumi.input_type
class ReplicationConfigurationArgs:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_configuration: Optional[pulumi.Input['ReplicationConfigurationReplicationConfigurationArgs']] = None):
        """
        The set of arguments for constructing a ReplicationConfiguration resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ReplicationConfigurationReplicationConfigurationArgs'] replication_configuration: Replication configuration for a registry. See Replication Configuration.
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_configuration is not None:
            pulumi.set(__self__, "replication_configuration", replication_configuration)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicationConfiguration")
    def replication_configuration(self) -> Optional[pulumi.Input['ReplicationConfigurationReplicationConfigurationArgs']]:
        """
        Replication configuration for a registry. See Replication Configuration.
        """
        return pulumi.get(self, "replication_configuration")

    @replication_configuration.setter
    def replication_configuration(self, value: Optional[pulumi.Input['ReplicationConfigurationReplicationConfigurationArgs']]):
        pulumi.set(self, "replication_configuration", value)


@pulumi.input_type
class _ReplicationConfigurationState:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_configuration: Optional[pulumi.Input['ReplicationConfigurationReplicationConfigurationArgs']] = None):
        """
        Input properties used for looking up and filtering ReplicationConfiguration resources.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] registry_id: The registry ID where the replication configuration was created.
        :param pulumi.Input['ReplicationConfigurationReplicationConfigurationArgs'] replication_configuration: Replication configuration for a registry. See Replication Configuration.
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if registry_id is not None:
            pulumi.set(__self__, "registry_id", registry_id)
        if replication_configuration is not None:
            pulumi.set(__self__, "replication_configuration", replication_configuration)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The registry ID where the replication configuration was created.
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "registry_id", value)

    @_builtins.property
    @pulumi.getter(name="replicationConfiguration")
    def replication_configuration(self) -> Optional[pulumi.Input['ReplicationConfigurationReplicationConfigurationArgs']]:
        """
        Replication configuration for a registry. See Replication Configuration.
        """
        return pulumi.get(self, "replication_configuration")

    @replication_configuration.setter
    def replication_configuration(self, value: Optional[pulumi.Input['ReplicationConfigurationReplicationConfigurationArgs']]):
        pulumi.set(self, "replication_configuration", value)


@pulumi.type_token("aws:ecr/replicationConfiguration:ReplicationConfiguration")
class ReplicationConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_configuration: Optional[pulumi.Input[Union['ReplicationConfigurationReplicationConfigurationArgs', 'ReplicationConfigurationReplicationConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        Provides an Elastic Container Registry Replication Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.get_regions()
        example_replication_configuration = aws.ecr.ReplicationConfiguration("example", replication_configuration={
            "rules": [{
                "destinations": [{
                    "region": example.names[0],
                    "registry_id": current.account_id,
                }],
            }],
        })
        ```

        ## Multiple Region Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.get_regions()
        example_replication_configuration = aws.ecr.ReplicationConfiguration("example", replication_configuration={
            "rules": [{
                "destinations": [
                    {
                        "region": example.names[0],
                        "registry_id": current.account_id,
                    },
                    {
                        "region": example.names[1],
                        "registry_id": current.account_id,
                    },
                ],
            }],
        })
        ```

        ## Repository Filter Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.get_regions()
        example_replication_configuration = aws.ecr.ReplicationConfiguration("example", replication_configuration={
            "rules": [{
                "destinations": [{
                    "region": example.names[0],
                    "registry_id": current.account_id,
                }],
                "repository_filters": [{
                    "filter": "prod-microservice",
                    "filter_type": "PREFIX_MATCH",
                }],
            }],
        })
        ```

        ## Import

        Using `pulumi import`, import ECR Replication Configuration using the `registry_id`. For example:

        ```sh
        $ pulumi import aws:ecr/replicationConfiguration:ReplicationConfiguration service 012345678912
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ReplicationConfigurationReplicationConfigurationArgs', 'ReplicationConfigurationReplicationConfigurationArgsDict']] replication_configuration: Replication configuration for a registry. See Replication Configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ReplicationConfigurationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Elastic Container Registry Replication Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.get_regions()
        example_replication_configuration = aws.ecr.ReplicationConfiguration("example", replication_configuration={
            "rules": [{
                "destinations": [{
                    "region": example.names[0],
                    "registry_id": current.account_id,
                }],
            }],
        })
        ```

        ## Multiple Region Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.get_regions()
        example_replication_configuration = aws.ecr.ReplicationConfiguration("example", replication_configuration={
            "rules": [{
                "destinations": [
                    {
                        "region": example.names[0],
                        "registry_id": current.account_id,
                    },
                    {
                        "region": example.names[1],
                        "registry_id": current.account_id,
                    },
                ],
            }],
        })
        ```

        ## Repository Filter Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.get_regions()
        example_replication_configuration = aws.ecr.ReplicationConfiguration("example", replication_configuration={
            "rules": [{
                "destinations": [{
                    "region": example.names[0],
                    "registry_id": current.account_id,
                }],
                "repository_filters": [{
                    "filter": "prod-microservice",
                    "filter_type": "PREFIX_MATCH",
                }],
            }],
        })
        ```

        ## Import

        Using `pulumi import`, import ECR Replication Configuration using the `registry_id`. For example:

        ```sh
        $ pulumi import aws:ecr/replicationConfiguration:ReplicationConfiguration service 012345678912
        ```

        :param str resource_name: The name of the resource.
        :param ReplicationConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReplicationConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_configuration: Optional[pulumi.Input[Union['ReplicationConfigurationReplicationConfigurationArgs', 'ReplicationConfigurationReplicationConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReplicationConfigurationArgs.__new__(ReplicationConfigurationArgs)

            __props__.__dict__["region"] = region
            __props__.__dict__["replication_configuration"] = replication_configuration
            __props__.__dict__["registry_id"] = None
        super(ReplicationConfiguration, __self__).__init__(
            'aws:ecr/replicationConfiguration:ReplicationConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            registry_id: Optional[pulumi.Input[_builtins.str]] = None,
            replication_configuration: Optional[pulumi.Input[Union['ReplicationConfigurationReplicationConfigurationArgs', 'ReplicationConfigurationReplicationConfigurationArgsDict']]] = None) -> 'ReplicationConfiguration':
        """
        Get an existing ReplicationConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] registry_id: The registry ID where the replication configuration was created.
        :param pulumi.Input[Union['ReplicationConfigurationReplicationConfigurationArgs', 'ReplicationConfigurationReplicationConfigurationArgsDict']] replication_configuration: Replication configuration for a registry. See Replication Configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReplicationConfigurationState.__new__(_ReplicationConfigurationState)

        __props__.__dict__["region"] = region
        __props__.__dict__["registry_id"] = registry_id
        __props__.__dict__["replication_configuration"] = replication_configuration
        return ReplicationConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> pulumi.Output[_builtins.str]:
        """
        The registry ID where the replication configuration was created.
        """
        return pulumi.get(self, "registry_id")

    @_builtins.property
    @pulumi.getter(name="replicationConfiguration")
    def replication_configuration(self) -> pulumi.Output[Optional['outputs.ReplicationConfigurationReplicationConfiguration']]:
        """
        Replication configuration for a registry. See Replication Configuration.
        """
        return pulumi.get(self, "replication_configuration")

