# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RepositoryCreationTemplateArgs', 'RepositoryCreationTemplate']

@pulumi.input_type
class RepositoryCreationTemplateArgs:
    def __init__(__self__, *,
                 applied_fors: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 prefix: pulumi.Input[_builtins.str],
                 custom_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateEncryptionConfigurationArgs']]]] = None,
                 image_tag_mutability: Optional[pulumi.Input[_builtins.str]] = None,
                 image_tag_mutability_exclusion_filters: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgs']]]] = None,
                 lifecycle_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RepositoryCreationTemplate resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applied_fors: Which features this template applies to. Must contain one or more of `PULL_THROUGH_CACHE` or `REPLICATION`.
        :param pulumi.Input[_builtins.str] prefix: The repository name prefix to match against. Use `ROOT` to match any prefix that doesn't explicitly match another template.
        :param pulumi.Input[_builtins.str] custom_role_arn: A custom IAM role to use for repository creation. Required if using repository tags or KMS encryption.
        :param pulumi.Input[_builtins.str] description: The description for this template.
        :param pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateEncryptionConfigurationArgs']]] encryption_configurations: Encryption configuration for any created repositories. See below for schema.
        :param pulumi.Input[_builtins.str] image_tag_mutability: The tag mutability setting for any created repositories. Must be one of: `MUTABLE` or `IMMUTABLE`. Defaults to `MUTABLE`.
        :param pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgs']]] image_tag_mutability_exclusion_filters: Configuration block that defines filters to specify which image tags can override the default tag mutability setting. Only applicable when `image_tag_mutability` is set to `IMMUTABLE_WITH_EXCLUSION` or `MUTABLE_WITH_EXCLUSION`. See below for schema.
        :param pulumi.Input[_builtins.str] lifecycle_policy: The lifecycle policy document to apply to any created repositories. See more details about [Policy Parameters](http://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html#lifecycle_policy_parameters) in the official AWS docs. Consider using the `ecr_get_lifecycle_policy_document` data_source to generate/manage the JSON document used for the `lifecycle_policy` argument.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: A map of tags to assign to any created repositories.
        """
        pulumi.set(__self__, "applied_fors", applied_fors)
        pulumi.set(__self__, "prefix", prefix)
        if custom_role_arn is not None:
            pulumi.set(__self__, "custom_role_arn", custom_role_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_configurations is not None:
            pulumi.set(__self__, "encryption_configurations", encryption_configurations)
        if image_tag_mutability is not None:
            pulumi.set(__self__, "image_tag_mutability", image_tag_mutability)
        if image_tag_mutability_exclusion_filters is not None:
            pulumi.set(__self__, "image_tag_mutability_exclusion_filters", image_tag_mutability_exclusion_filters)
        if lifecycle_policy is not None:
            pulumi.set(__self__, "lifecycle_policy", lifecycle_policy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if repository_policy is not None:
            pulumi.set(__self__, "repository_policy", repository_policy)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)

    @_builtins.property
    @pulumi.getter(name="appliedFors")
    def applied_fors(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Which features this template applies to. Must contain one or more of `PULL_THROUGH_CACHE` or `REPLICATION`.
        """
        return pulumi.get(self, "applied_fors")

    @applied_fors.setter
    def applied_fors(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "applied_fors", value)

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[_builtins.str]:
        """
        The repository name prefix to match against. Use `ROOT` to match any prefix that doesn't explicitly match another template.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "prefix", value)

    @_builtins.property
    @pulumi.getter(name="customRoleArn")
    def custom_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A custom IAM role to use for repository creation. Required if using repository tags or KMS encryption.
        """
        return pulumi.get(self, "custom_role_arn")

    @custom_role_arn.setter
    def custom_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for this template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptionConfigurations")
    def encryption_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateEncryptionConfigurationArgs']]]]:
        """
        Encryption configuration for any created repositories. See below for schema.
        """
        return pulumi.get(self, "encryption_configurations")

    @encryption_configurations.setter
    def encryption_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateEncryptionConfigurationArgs']]]]):
        pulumi.set(self, "encryption_configurations", value)

    @_builtins.property
    @pulumi.getter(name="imageTagMutability")
    def image_tag_mutability(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag mutability setting for any created repositories. Must be one of: `MUTABLE` or `IMMUTABLE`. Defaults to `MUTABLE`.
        """
        return pulumi.get(self, "image_tag_mutability")

    @image_tag_mutability.setter
    def image_tag_mutability(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_tag_mutability", value)

    @_builtins.property
    @pulumi.getter(name="imageTagMutabilityExclusionFilters")
    def image_tag_mutability_exclusion_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgs']]]]:
        """
        Configuration block that defines filters to specify which image tags can override the default tag mutability setting. Only applicable when `image_tag_mutability` is set to `IMMUTABLE_WITH_EXCLUSION` or `MUTABLE_WITH_EXCLUSION`. See below for schema.
        """
        return pulumi.get(self, "image_tag_mutability_exclusion_filters")

    @image_tag_mutability_exclusion_filters.setter
    def image_tag_mutability_exclusion_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgs']]]]):
        pulumi.set(self, "image_tag_mutability_exclusion_filters", value)

    @_builtins.property
    @pulumi.getter(name="lifecyclePolicy")
    def lifecycle_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lifecycle policy document to apply to any created repositories. See more details about [Policy Parameters](http://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html#lifecycle_policy_parameters) in the official AWS docs. Consider using the `ecr_get_lifecycle_policy_document` data_source to generate/manage the JSON document used for the `lifecycle_policy` argument.
        """
        return pulumi.get(self, "lifecycle_policy")

    @lifecycle_policy.setter
    def lifecycle_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_policy", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="repositoryPolicy")
    def repository_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "repository_policy")

    @repository_policy.setter
    def repository_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_policy", value)

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to any created repositories.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_tags", value)


@pulumi.input_type
class _RepositoryCreationTemplateState:
    def __init__(__self__, *,
                 applied_fors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateEncryptionConfigurationArgs']]]] = None,
                 image_tag_mutability: Optional[pulumi.Input[_builtins.str]] = None,
                 image_tag_mutability_exclusion_filters: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgs']]]] = None,
                 lifecycle_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering RepositoryCreationTemplate resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applied_fors: Which features this template applies to. Must contain one or more of `PULL_THROUGH_CACHE` or `REPLICATION`.
        :param pulumi.Input[_builtins.str] custom_role_arn: A custom IAM role to use for repository creation. Required if using repository tags or KMS encryption.
        :param pulumi.Input[_builtins.str] description: The description for this template.
        :param pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateEncryptionConfigurationArgs']]] encryption_configurations: Encryption configuration for any created repositories. See below for schema.
        :param pulumi.Input[_builtins.str] image_tag_mutability: The tag mutability setting for any created repositories. Must be one of: `MUTABLE` or `IMMUTABLE`. Defaults to `MUTABLE`.
        :param pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgs']]] image_tag_mutability_exclusion_filters: Configuration block that defines filters to specify which image tags can override the default tag mutability setting. Only applicable when `image_tag_mutability` is set to `IMMUTABLE_WITH_EXCLUSION` or `MUTABLE_WITH_EXCLUSION`. See below for schema.
        :param pulumi.Input[_builtins.str] lifecycle_policy: The lifecycle policy document to apply to any created repositories. See more details about [Policy Parameters](http://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html#lifecycle_policy_parameters) in the official AWS docs. Consider using the `ecr_get_lifecycle_policy_document` data_source to generate/manage the JSON document used for the `lifecycle_policy` argument.
        :param pulumi.Input[_builtins.str] prefix: The repository name prefix to match against. Use `ROOT` to match any prefix that doesn't explicitly match another template.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] registry_id: The registry ID the repository creation template applies to.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: A map of tags to assign to any created repositories.
        """
        if applied_fors is not None:
            pulumi.set(__self__, "applied_fors", applied_fors)
        if custom_role_arn is not None:
            pulumi.set(__self__, "custom_role_arn", custom_role_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_configurations is not None:
            pulumi.set(__self__, "encryption_configurations", encryption_configurations)
        if image_tag_mutability is not None:
            pulumi.set(__self__, "image_tag_mutability", image_tag_mutability)
        if image_tag_mutability_exclusion_filters is not None:
            pulumi.set(__self__, "image_tag_mutability_exclusion_filters", image_tag_mutability_exclusion_filters)
        if lifecycle_policy is not None:
            pulumi.set(__self__, "lifecycle_policy", lifecycle_policy)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if registry_id is not None:
            pulumi.set(__self__, "registry_id", registry_id)
        if repository_policy is not None:
            pulumi.set(__self__, "repository_policy", repository_policy)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)

    @_builtins.property
    @pulumi.getter(name="appliedFors")
    def applied_fors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Which features this template applies to. Must contain one or more of `PULL_THROUGH_CACHE` or `REPLICATION`.
        """
        return pulumi.get(self, "applied_fors")

    @applied_fors.setter
    def applied_fors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applied_fors", value)

    @_builtins.property
    @pulumi.getter(name="customRoleArn")
    def custom_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A custom IAM role to use for repository creation. Required if using repository tags or KMS encryption.
        """
        return pulumi.get(self, "custom_role_arn")

    @custom_role_arn.setter
    def custom_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for this template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptionConfigurations")
    def encryption_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateEncryptionConfigurationArgs']]]]:
        """
        Encryption configuration for any created repositories. See below for schema.
        """
        return pulumi.get(self, "encryption_configurations")

    @encryption_configurations.setter
    def encryption_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateEncryptionConfigurationArgs']]]]):
        pulumi.set(self, "encryption_configurations", value)

    @_builtins.property
    @pulumi.getter(name="imageTagMutability")
    def image_tag_mutability(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag mutability setting for any created repositories. Must be one of: `MUTABLE` or `IMMUTABLE`. Defaults to `MUTABLE`.
        """
        return pulumi.get(self, "image_tag_mutability")

    @image_tag_mutability.setter
    def image_tag_mutability(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_tag_mutability", value)

    @_builtins.property
    @pulumi.getter(name="imageTagMutabilityExclusionFilters")
    def image_tag_mutability_exclusion_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgs']]]]:
        """
        Configuration block that defines filters to specify which image tags can override the default tag mutability setting. Only applicable when `image_tag_mutability` is set to `IMMUTABLE_WITH_EXCLUSION` or `MUTABLE_WITH_EXCLUSION`. See below for schema.
        """
        return pulumi.get(self, "image_tag_mutability_exclusion_filters")

    @image_tag_mutability_exclusion_filters.setter
    def image_tag_mutability_exclusion_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgs']]]]):
        pulumi.set(self, "image_tag_mutability_exclusion_filters", value)

    @_builtins.property
    @pulumi.getter(name="lifecyclePolicy")
    def lifecycle_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lifecycle policy document to apply to any created repositories. See more details about [Policy Parameters](http://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html#lifecycle_policy_parameters) in the official AWS docs. Consider using the `ecr_get_lifecycle_policy_document` data_source to generate/manage the JSON document used for the `lifecycle_policy` argument.
        """
        return pulumi.get(self, "lifecycle_policy")

    @lifecycle_policy.setter
    def lifecycle_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_policy", value)

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The repository name prefix to match against. Use `ROOT` to match any prefix that doesn't explicitly match another template.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "prefix", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The registry ID the repository creation template applies to.
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "registry_id", value)

    @_builtins.property
    @pulumi.getter(name="repositoryPolicy")
    def repository_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "repository_policy")

    @repository_policy.setter
    def repository_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_policy", value)

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to any created repositories.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_tags", value)


@pulumi.type_token("aws:ecr/repositoryCreationTemplate:RepositoryCreationTemplate")
class RepositoryCreationTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applied_fors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RepositoryCreationTemplateEncryptionConfigurationArgs', 'RepositoryCreationTemplateEncryptionConfigurationArgsDict']]]]] = None,
                 image_tag_mutability: Optional[pulumi.Input[_builtins.str]] = None,
                 image_tag_mutability_exclusion_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgs', 'RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgsDict']]]]] = None,
                 lifecycle_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an Elastic Container Registry Repository Creation Template.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.get_policy_document(statements=[{
            "sid": "new policy",
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": ["123456789012"],
            }],
            "actions": [
                "ecr:GetDownloadUrlForLayer",
                "ecr:BatchGetImage",
                "ecr:BatchCheckLayerAvailability",
                "ecr:PutImage",
                "ecr:InitiateLayerUpload",
                "ecr:UploadLayerPart",
                "ecr:CompleteLayerUpload",
                "ecr:DescribeRepositories",
                "ecr:GetRepositoryPolicy",
                "ecr:ListImages",
                "ecr:DeleteRepository",
                "ecr:BatchDeleteImage",
                "ecr:SetRepositoryPolicy",
                "ecr:DeleteRepositoryPolicy",
            ],
        }])
        example_repository_creation_template = aws.ecr.RepositoryCreationTemplate("example",
            prefix="example",
            description="An example template",
            image_tag_mutability="IMMUTABLE",
            custom_role_arn="arn:aws:iam::123456789012:role/example",
            applied_fors=["PULL_THROUGH_CACHE"],
            encryption_configurations=[{
                "encryption_type": "AES256",
            }],
            repository_policy=example.json,
            lifecycle_policy=\"\"\"{
          "rules": [
            {
              "rulePriority": 1,
              "description": "Expire images older than 14 days",
              "selection": {
                "tagStatus": "untagged",
                "countType": "sinceImagePushed",
                "countUnit": "days",
                "countNumber": 14
              },
              "action": {
                "type": "expire"
              }
            }
          ]
        }
        \"\"\",
            resource_tags={
                "Foo": "Bar",
            })
        ```

        ## Import

        Using `pulumi import`, import the ECR Repository Creating Templates using the `prefix`. For example:

        ```sh
        $ pulumi import aws:ecr/repositoryCreationTemplate:RepositoryCreationTemplate example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applied_fors: Which features this template applies to. Must contain one or more of `PULL_THROUGH_CACHE` or `REPLICATION`.
        :param pulumi.Input[_builtins.str] custom_role_arn: A custom IAM role to use for repository creation. Required if using repository tags or KMS encryption.
        :param pulumi.Input[_builtins.str] description: The description for this template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RepositoryCreationTemplateEncryptionConfigurationArgs', 'RepositoryCreationTemplateEncryptionConfigurationArgsDict']]]] encryption_configurations: Encryption configuration for any created repositories. See below for schema.
        :param pulumi.Input[_builtins.str] image_tag_mutability: The tag mutability setting for any created repositories. Must be one of: `MUTABLE` or `IMMUTABLE`. Defaults to `MUTABLE`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgs', 'RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgsDict']]]] image_tag_mutability_exclusion_filters: Configuration block that defines filters to specify which image tags can override the default tag mutability setting. Only applicable when `image_tag_mutability` is set to `IMMUTABLE_WITH_EXCLUSION` or `MUTABLE_WITH_EXCLUSION`. See below for schema.
        :param pulumi.Input[_builtins.str] lifecycle_policy: The lifecycle policy document to apply to any created repositories. See more details about [Policy Parameters](http://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html#lifecycle_policy_parameters) in the official AWS docs. Consider using the `ecr_get_lifecycle_policy_document` data_source to generate/manage the JSON document used for the `lifecycle_policy` argument.
        :param pulumi.Input[_builtins.str] prefix: The repository name prefix to match against. Use `ROOT` to match any prefix that doesn't explicitly match another template.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: A map of tags to assign to any created repositories.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryCreationTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Elastic Container Registry Repository Creation Template.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.get_policy_document(statements=[{
            "sid": "new policy",
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": ["123456789012"],
            }],
            "actions": [
                "ecr:GetDownloadUrlForLayer",
                "ecr:BatchGetImage",
                "ecr:BatchCheckLayerAvailability",
                "ecr:PutImage",
                "ecr:InitiateLayerUpload",
                "ecr:UploadLayerPart",
                "ecr:CompleteLayerUpload",
                "ecr:DescribeRepositories",
                "ecr:GetRepositoryPolicy",
                "ecr:ListImages",
                "ecr:DeleteRepository",
                "ecr:BatchDeleteImage",
                "ecr:SetRepositoryPolicy",
                "ecr:DeleteRepositoryPolicy",
            ],
        }])
        example_repository_creation_template = aws.ecr.RepositoryCreationTemplate("example",
            prefix="example",
            description="An example template",
            image_tag_mutability="IMMUTABLE",
            custom_role_arn="arn:aws:iam::123456789012:role/example",
            applied_fors=["PULL_THROUGH_CACHE"],
            encryption_configurations=[{
                "encryption_type": "AES256",
            }],
            repository_policy=example.json,
            lifecycle_policy=\"\"\"{
          "rules": [
            {
              "rulePriority": 1,
              "description": "Expire images older than 14 days",
              "selection": {
                "tagStatus": "untagged",
                "countType": "sinceImagePushed",
                "countUnit": "days",
                "countNumber": 14
              },
              "action": {
                "type": "expire"
              }
            }
          ]
        }
        \"\"\",
            resource_tags={
                "Foo": "Bar",
            })
        ```

        ## Import

        Using `pulumi import`, import the ECR Repository Creating Templates using the `prefix`. For example:

        ```sh
        $ pulumi import aws:ecr/repositoryCreationTemplate:RepositoryCreationTemplate example example
        ```

        :param str resource_name: The name of the resource.
        :param RepositoryCreationTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryCreationTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applied_fors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RepositoryCreationTemplateEncryptionConfigurationArgs', 'RepositoryCreationTemplateEncryptionConfigurationArgsDict']]]]] = None,
                 image_tag_mutability: Optional[pulumi.Input[_builtins.str]] = None,
                 image_tag_mutability_exclusion_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgs', 'RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgsDict']]]]] = None,
                 lifecycle_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryCreationTemplateArgs.__new__(RepositoryCreationTemplateArgs)

            if applied_fors is None and not opts.urn:
                raise TypeError("Missing required property 'applied_fors'")
            __props__.__dict__["applied_fors"] = applied_fors
            __props__.__dict__["custom_role_arn"] = custom_role_arn
            __props__.__dict__["description"] = description
            __props__.__dict__["encryption_configurations"] = encryption_configurations
            __props__.__dict__["image_tag_mutability"] = image_tag_mutability
            __props__.__dict__["image_tag_mutability_exclusion_filters"] = image_tag_mutability_exclusion_filters
            __props__.__dict__["lifecycle_policy"] = lifecycle_policy
            if prefix is None and not opts.urn:
                raise TypeError("Missing required property 'prefix'")
            __props__.__dict__["prefix"] = prefix
            __props__.__dict__["region"] = region
            __props__.__dict__["repository_policy"] = repository_policy
            __props__.__dict__["resource_tags"] = resource_tags
            __props__.__dict__["registry_id"] = None
        super(RepositoryCreationTemplate, __self__).__init__(
            'aws:ecr/repositoryCreationTemplate:RepositoryCreationTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            applied_fors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            custom_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RepositoryCreationTemplateEncryptionConfigurationArgs', 'RepositoryCreationTemplateEncryptionConfigurationArgsDict']]]]] = None,
            image_tag_mutability: Optional[pulumi.Input[_builtins.str]] = None,
            image_tag_mutability_exclusion_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgs', 'RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgsDict']]]]] = None,
            lifecycle_policy: Optional[pulumi.Input[_builtins.str]] = None,
            prefix: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            registry_id: Optional[pulumi.Input[_builtins.str]] = None,
            repository_policy: Optional[pulumi.Input[_builtins.str]] = None,
            resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'RepositoryCreationTemplate':
        """
        Get an existing RepositoryCreationTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applied_fors: Which features this template applies to. Must contain one or more of `PULL_THROUGH_CACHE` or `REPLICATION`.
        :param pulumi.Input[_builtins.str] custom_role_arn: A custom IAM role to use for repository creation. Required if using repository tags or KMS encryption.
        :param pulumi.Input[_builtins.str] description: The description for this template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RepositoryCreationTemplateEncryptionConfigurationArgs', 'RepositoryCreationTemplateEncryptionConfigurationArgsDict']]]] encryption_configurations: Encryption configuration for any created repositories. See below for schema.
        :param pulumi.Input[_builtins.str] image_tag_mutability: The tag mutability setting for any created repositories. Must be one of: `MUTABLE` or `IMMUTABLE`. Defaults to `MUTABLE`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgs', 'RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgsDict']]]] image_tag_mutability_exclusion_filters: Configuration block that defines filters to specify which image tags can override the default tag mutability setting. Only applicable when `image_tag_mutability` is set to `IMMUTABLE_WITH_EXCLUSION` or `MUTABLE_WITH_EXCLUSION`. See below for schema.
        :param pulumi.Input[_builtins.str] lifecycle_policy: The lifecycle policy document to apply to any created repositories. See more details about [Policy Parameters](http://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html#lifecycle_policy_parameters) in the official AWS docs. Consider using the `ecr_get_lifecycle_policy_document` data_source to generate/manage the JSON document used for the `lifecycle_policy` argument.
        :param pulumi.Input[_builtins.str] prefix: The repository name prefix to match against. Use `ROOT` to match any prefix that doesn't explicitly match another template.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] registry_id: The registry ID the repository creation template applies to.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: A map of tags to assign to any created repositories.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryCreationTemplateState.__new__(_RepositoryCreationTemplateState)

        __props__.__dict__["applied_fors"] = applied_fors
        __props__.__dict__["custom_role_arn"] = custom_role_arn
        __props__.__dict__["description"] = description
        __props__.__dict__["encryption_configurations"] = encryption_configurations
        __props__.__dict__["image_tag_mutability"] = image_tag_mutability
        __props__.__dict__["image_tag_mutability_exclusion_filters"] = image_tag_mutability_exclusion_filters
        __props__.__dict__["lifecycle_policy"] = lifecycle_policy
        __props__.__dict__["prefix"] = prefix
        __props__.__dict__["region"] = region
        __props__.__dict__["registry_id"] = registry_id
        __props__.__dict__["repository_policy"] = repository_policy
        __props__.__dict__["resource_tags"] = resource_tags
        return RepositoryCreationTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appliedFors")
    def applied_fors(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Which features this template applies to. Must contain one or more of `PULL_THROUGH_CACHE` or `REPLICATION`.
        """
        return pulumi.get(self, "applied_fors")

    @_builtins.property
    @pulumi.getter(name="customRoleArn")
    def custom_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A custom IAM role to use for repository creation. Required if using repository tags or KMS encryption.
        """
        return pulumi.get(self, "custom_role_arn")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for this template.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="encryptionConfigurations")
    def encryption_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.RepositoryCreationTemplateEncryptionConfiguration']]]:
        """
        Encryption configuration for any created repositories. See below for schema.
        """
        return pulumi.get(self, "encryption_configurations")

    @_builtins.property
    @pulumi.getter(name="imageTagMutability")
    def image_tag_mutability(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The tag mutability setting for any created repositories. Must be one of: `MUTABLE` or `IMMUTABLE`. Defaults to `MUTABLE`.
        """
        return pulumi.get(self, "image_tag_mutability")

    @_builtins.property
    @pulumi.getter(name="imageTagMutabilityExclusionFilters")
    def image_tag_mutability_exclusion_filters(self) -> pulumi.Output[Optional[Sequence['outputs.RepositoryCreationTemplateImageTagMutabilityExclusionFilter']]]:
        """
        Configuration block that defines filters to specify which image tags can override the default tag mutability setting. Only applicable when `image_tag_mutability` is set to `IMMUTABLE_WITH_EXCLUSION` or `MUTABLE_WITH_EXCLUSION`. See below for schema.
        """
        return pulumi.get(self, "image_tag_mutability_exclusion_filters")

    @_builtins.property
    @pulumi.getter(name="lifecyclePolicy")
    def lifecycle_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The lifecycle policy document to apply to any created repositories. See more details about [Policy Parameters](http://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html#lifecycle_policy_parameters) in the official AWS docs. Consider using the `ecr_get_lifecycle_policy_document` data_source to generate/manage the JSON document used for the `lifecycle_policy` argument.
        """
        return pulumi.get(self, "lifecycle_policy")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The repository name prefix to match against. Use `ROOT` to match any prefix that doesn't explicitly match another template.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> pulumi.Output[_builtins.str]:
        """
        The registry ID the repository creation template applies to.
        """
        return pulumi.get(self, "registry_id")

    @_builtins.property
    @pulumi.getter(name="repositoryPolicy")
    def repository_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "repository_policy")

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to any created repositories.
        """
        return pulumi.get(self, "resource_tags")

