# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 alarms: Optional[pulumi.Input['ServiceAlarmsArgs']] = None,
                 availability_zone_rebalancing: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCapacityProviderStrategyArgs']]]] = None,
                 cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_circuit_breaker: Optional[pulumi.Input['ServiceDeploymentCircuitBreakerArgs']] = None,
                 deployment_configuration: Optional[pulumi.Input['ServiceDeploymentConfigurationArgs']] = None,
                 deployment_controller: Optional[pulumi.Input['ServiceDeploymentControllerArgs']] = None,
                 deployment_maximum_percent: Optional[pulumi.Input[_builtins.int]] = None,
                 deployment_minimum_healthy_percent: Optional[pulumi.Input[_builtins.int]] = None,
                 desired_count: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_ecs_managed_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_execute_command: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_new_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLoadBalancerArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input['ServiceNetworkConfigurationArgs']] = None,
                 ordered_placement_strategies: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceOrderedPlacementStrategyArgs']]]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePlacementConstraintArgs']]]] = None,
                 platform_version: Optional[pulumi.Input[_builtins.str]] = None,
                 propagate_tags: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 service_connect_configuration: Optional[pulumi.Input['ServiceServiceConnectConfigurationArgs']] = None,
                 service_registries: Optional[pulumi.Input['ServiceServiceRegistriesArgs']] = None,
                 sigint_rollback: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 task_definition: Optional[pulumi.Input[_builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 volume_configuration: Optional[pulumi.Input['ServiceVolumeConfigurationArgs']] = None,
                 vpc_lattice_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceVpcLatticeConfigurationArgs']]]] = None,
                 wait_for_steady_state: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input['ServiceAlarmsArgs'] alarms: Information about the CloudWatch alarms. See below.
        :param pulumi.Input[_builtins.str] availability_zone_rebalancing: ECS automatically redistributes tasks within a service across Availability Zones (AZs) to mitigate the risk of impaired application availability due to underlying infrastructure failures and task lifecycle activities. The valid values are `ENABLED` and `DISABLED`. Defaults to `DISABLED`.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceCapacityProviderStrategyArgs']]] capacity_provider_strategies: Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
        :param pulumi.Input[_builtins.str] cluster: ARN of an ECS cluster.
        :param pulumi.Input['ServiceDeploymentCircuitBreakerArgs'] deployment_circuit_breaker: Configuration block for deployment circuit breaker. See below.
        :param pulumi.Input['ServiceDeploymentConfigurationArgs'] deployment_configuration: Configuration block for deployment settings. See below.
        :param pulumi.Input['ServiceDeploymentControllerArgs'] deployment_controller: Configuration block for deployment controller configuration. See below.
        :param pulumi.Input[_builtins.int] deployment_maximum_percent: Upper limit (as a percentage of the service's desiredCount) of the number of running tasks that can be running in a service during a deployment. Not valid when using the `DAEMON` scheduling strategy.
        :param pulumi.Input[_builtins.int] deployment_minimum_healthy_percent: Lower limit (as a percentage of the service's desiredCount) of the number of running tasks that must remain running and healthy in a service during a deployment.
        :param pulumi.Input[_builtins.int] desired_count: Number of instances of the task definition to place and keep running. Defaults to 0. Do not specify if using the `DAEMON` scheduling strategy.
        :param pulumi.Input[_builtins.bool] enable_ecs_managed_tags: Whether to enable Amazon ECS managed tags for the tasks within the service.
        :param pulumi.Input[_builtins.bool] enable_execute_command: Whether to enable Amazon ECS Exec for the tasks within the service.
        :param pulumi.Input[_builtins.bool] force_delete: Enable to delete a service even if it wasn't scaled down to zero tasks. It's only necessary to use this if the service uses the `REPLICA` scheduling strategy.
        :param pulumi.Input[_builtins.bool] force_new_deployment: Enable to force a new task deployment of the service. This can be used to update tasks to use a newer Docker image with same image/tag combination (e.g., `myimage:latest`), roll Fargate tasks onto a newer platform version, or immediately deploy `ordered_placement_strategy` and `placement_constraints` updates.
               When using the forceNewDeployment property you also need to configure the triggers property.
        :param pulumi.Input[_builtins.int] health_check_grace_period_seconds: Seconds to ignore failing load balancer health checks on newly instantiated tasks to prevent premature shutdown, up to 2147483647. Only valid for services configured to use load balancers.
        :param pulumi.Input[_builtins.str] iam_role: ARN of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required if you are using a load balancer with your service, but only if your task definition does not use the `awsvpc` network mode. If using `awsvpc` network mode, do not specify this role. If your account has already created the Amazon ECS service-linked role, that role is used by default for your service unless you specify a role here.
        :param pulumi.Input[_builtins.str] launch_type: Launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`. Conflicts with `capacity_provider_strategy`.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLoadBalancerArgs']]] load_balancers: Configuration block for load balancers. See below.
        :param pulumi.Input[_builtins.str] name: Name of the service (up to 255 letters, numbers, hyphens, and underscores)
               
               The following arguments are optional:
        :param pulumi.Input['ServiceNetworkConfigurationArgs'] network_configuration: Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceOrderedPlacementStrategyArgs']]] ordered_placement_strategies: Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
        :param pulumi.Input[Sequence[pulumi.Input['ServicePlacementConstraintArgs']]] placement_constraints: Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
        :param pulumi.Input[_builtins.str] platform_version: Platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        :param pulumi.Input[_builtins.str] propagate_tags: Whether to propagate the tags from the task definition or the service to the tasks. The valid values are `SERVICE` and `TASK_DEFINITION`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] scheduling_strategy: Scheduling strategy to use for the service. The valid values are `REPLICA` and `DAEMON`. Defaults to `REPLICA`. Note that [*Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy*](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html).
        :param pulumi.Input['ServiceServiceConnectConfigurationArgs'] service_connect_configuration: ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
        :param pulumi.Input['ServiceServiceRegistriesArgs'] service_registries: Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
        :param pulumi.Input[_builtins.bool] sigint_rollback: Whether to enable graceful termination of deployments using SIGINT signals. When enabled, allows customers to safely cancel an in-progress deployment and automatically trigger a rollback to the previous stable state. Defaults to `false`. Only applicable when using `ECS` deployment controller and requires `wait_for_steady_state = true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] task_definition: Family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service. Required unless using the `EXTERNAL` deployment controller. If a revision is not specified, the latest `ACTIVE` revision is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] triggers: Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `"plantimestamp()"`. When using the triggers property you also need to set the forceNewDeployment property to True.
        :param pulumi.Input['ServiceVolumeConfigurationArgs'] volume_configuration: Configuration for a volume specified in the task definition as a volume that is configured at launch time. Currently, the only supported volume type is an Amazon EBS volume. See below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceVpcLatticeConfigurationArgs']]] vpc_lattice_configurations: The VPC Lattice configuration for your service that allows Lattice to connect, secure, and monitor your service across multiple accounts and VPCs. See below.
        :param pulumi.Input[_builtins.bool] wait_for_steady_state: If `true`, this provider will wait for the service to reach a steady state (like [`aws ecs wait services-stable`](https://docs.aws.amazon.com/cli/latest/reference/ecs/wait/services-stable.html)) before continuing. Default `false`.
        """
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if availability_zone_rebalancing is not None:
            pulumi.set(__self__, "availability_zone_rebalancing", availability_zone_rebalancing)
        if capacity_provider_strategies is not None:
            pulumi.set(__self__, "capacity_provider_strategies", capacity_provider_strategies)
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if deployment_circuit_breaker is not None:
            pulumi.set(__self__, "deployment_circuit_breaker", deployment_circuit_breaker)
        if deployment_configuration is not None:
            pulumi.set(__self__, "deployment_configuration", deployment_configuration)
        if deployment_controller is not None:
            pulumi.set(__self__, "deployment_controller", deployment_controller)
        if deployment_maximum_percent is not None:
            pulumi.set(__self__, "deployment_maximum_percent", deployment_maximum_percent)
        if deployment_minimum_healthy_percent is not None:
            pulumi.set(__self__, "deployment_minimum_healthy_percent", deployment_minimum_healthy_percent)
        if desired_count is not None:
            pulumi.set(__self__, "desired_count", desired_count)
        if enable_ecs_managed_tags is not None:
            pulumi.set(__self__, "enable_ecs_managed_tags", enable_ecs_managed_tags)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if force_new_deployment is not None:
            pulumi.set(__self__, "force_new_deployment", force_new_deployment)
        if health_check_grace_period_seconds is not None:
            pulumi.set(__self__, "health_check_grace_period_seconds", health_check_grace_period_seconds)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if launch_type is not None:
            pulumi.set(__self__, "launch_type", launch_type)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if ordered_placement_strategies is not None:
            pulumi.set(__self__, "ordered_placement_strategies", ordered_placement_strategies)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scheduling_strategy is not None:
            pulumi.set(__self__, "scheduling_strategy", scheduling_strategy)
        if service_connect_configuration is not None:
            pulumi.set(__self__, "service_connect_configuration", service_connect_configuration)
        if service_registries is not None:
            pulumi.set(__self__, "service_registries", service_registries)
        if sigint_rollback is not None:
            pulumi.set(__self__, "sigint_rollback", sigint_rollback)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_definition is not None:
            pulumi.set(__self__, "task_definition", task_definition)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if volume_configuration is not None:
            pulumi.set(__self__, "volume_configuration", volume_configuration)
        if vpc_lattice_configurations is not None:
            pulumi.set(__self__, "vpc_lattice_configurations", vpc_lattice_configurations)
        if wait_for_steady_state is not None:
            pulumi.set(__self__, "wait_for_steady_state", wait_for_steady_state)

    @_builtins.property
    @pulumi.getter
    def alarms(self) -> Optional[pulumi.Input['ServiceAlarmsArgs']]:
        """
        Information about the CloudWatch alarms. See below.
        """
        return pulumi.get(self, "alarms")

    @alarms.setter
    def alarms(self, value: Optional[pulumi.Input['ServiceAlarmsArgs']]):
        pulumi.set(self, "alarms", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneRebalancing")
    def availability_zone_rebalancing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ECS automatically redistributes tasks within a service across Availability Zones (AZs) to mitigate the risk of impaired application availability due to underlying infrastructure failures and task lifecycle activities. The valid values are `ENABLED` and `DISABLED`. Defaults to `DISABLED`.
        """
        return pulumi.get(self, "availability_zone_rebalancing")

    @availability_zone_rebalancing.setter
    def availability_zone_rebalancing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone_rebalancing", value)

    @_builtins.property
    @pulumi.getter(name="capacityProviderStrategies")
    def capacity_provider_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCapacityProviderStrategyArgs']]]]:
        """
        Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
        """
        return pulumi.get(self, "capacity_provider_strategies")

    @capacity_provider_strategies.setter
    def capacity_provider_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCapacityProviderStrategyArgs']]]]):
        pulumi.set(self, "capacity_provider_strategies", value)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of an ECS cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster", value)

    @_builtins.property
    @pulumi.getter(name="deploymentCircuitBreaker")
    def deployment_circuit_breaker(self) -> Optional[pulumi.Input['ServiceDeploymentCircuitBreakerArgs']]:
        """
        Configuration block for deployment circuit breaker. See below.
        """
        return pulumi.get(self, "deployment_circuit_breaker")

    @deployment_circuit_breaker.setter
    def deployment_circuit_breaker(self, value: Optional[pulumi.Input['ServiceDeploymentCircuitBreakerArgs']]):
        pulumi.set(self, "deployment_circuit_breaker", value)

    @_builtins.property
    @pulumi.getter(name="deploymentConfiguration")
    def deployment_configuration(self) -> Optional[pulumi.Input['ServiceDeploymentConfigurationArgs']]:
        """
        Configuration block for deployment settings. See below.
        """
        return pulumi.get(self, "deployment_configuration")

    @deployment_configuration.setter
    def deployment_configuration(self, value: Optional[pulumi.Input['ServiceDeploymentConfigurationArgs']]):
        pulumi.set(self, "deployment_configuration", value)

    @_builtins.property
    @pulumi.getter(name="deploymentController")
    def deployment_controller(self) -> Optional[pulumi.Input['ServiceDeploymentControllerArgs']]:
        """
        Configuration block for deployment controller configuration. See below.
        """
        return pulumi.get(self, "deployment_controller")

    @deployment_controller.setter
    def deployment_controller(self, value: Optional[pulumi.Input['ServiceDeploymentControllerArgs']]):
        pulumi.set(self, "deployment_controller", value)

    @_builtins.property
    @pulumi.getter(name="deploymentMaximumPercent")
    def deployment_maximum_percent(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Upper limit (as a percentage of the service's desiredCount) of the number of running tasks that can be running in a service during a deployment. Not valid when using the `DAEMON` scheduling strategy.
        """
        return pulumi.get(self, "deployment_maximum_percent")

    @deployment_maximum_percent.setter
    def deployment_maximum_percent(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deployment_maximum_percent", value)

    @_builtins.property
    @pulumi.getter(name="deploymentMinimumHealthyPercent")
    def deployment_minimum_healthy_percent(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lower limit (as a percentage of the service's desiredCount) of the number of running tasks that must remain running and healthy in a service during a deployment.
        """
        return pulumi.get(self, "deployment_minimum_healthy_percent")

    @deployment_minimum_healthy_percent.setter
    def deployment_minimum_healthy_percent(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deployment_minimum_healthy_percent", value)

    @_builtins.property
    @pulumi.getter(name="desiredCount")
    def desired_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of instances of the task definition to place and keep running. Defaults to 0. Do not specify if using the `DAEMON` scheduling strategy.
        """
        return pulumi.get(self, "desired_count")

    @desired_count.setter
    def desired_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "desired_count", value)

    @_builtins.property
    @pulumi.getter(name="enableEcsManagedTags")
    def enable_ecs_managed_tags(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable Amazon ECS managed tags for the tasks within the service.
        """
        return pulumi.get(self, "enable_ecs_managed_tags")

    @enable_ecs_managed_tags.setter
    def enable_ecs_managed_tags(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ecs_managed_tags", value)

    @_builtins.property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable Amazon ECS Exec for the tasks within the service.
        """
        return pulumi.get(self, "enable_execute_command")

    @enable_execute_command.setter
    def enable_execute_command(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_execute_command", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to delete a service even if it wasn't scaled down to zero tasks. It's only necessary to use this if the service uses the `REPLICA` scheduling strategy.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="forceNewDeployment")
    def force_new_deployment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to force a new task deployment of the service. This can be used to update tasks to use a newer Docker image with same image/tag combination (e.g., `myimage:latest`), roll Fargate tasks onto a newer platform version, or immediately deploy `ordered_placement_strategy` and `placement_constraints` updates.
        When using the forceNewDeployment property you also need to configure the triggers property.
        """
        return pulumi.get(self, "force_new_deployment")

    @force_new_deployment.setter
    def force_new_deployment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_new_deployment", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckGracePeriodSeconds")
    def health_check_grace_period_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds to ignore failing load balancer health checks on newly instantiated tasks to prevent premature shutdown, up to 2147483647. Only valid for services configured to use load balancers.
        """
        return pulumi.get(self, "health_check_grace_period_seconds")

    @health_check_grace_period_seconds.setter
    def health_check_grace_period_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_grace_period_seconds", value)

    @_builtins.property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required if you are using a load balancer with your service, but only if your task definition does not use the `awsvpc` network mode. If using `awsvpc` network mode, do not specify this role. If your account has already created the Amazon ECS service-linked role, that role is used by default for your service unless you specify a role here.
        """
        return pulumi.get(self, "iam_role")

    @iam_role.setter
    def iam_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_role", value)

    @_builtins.property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`. Conflicts with `capacity_provider_strategy`.
        """
        return pulumi.get(self, "launch_type")

    @launch_type.setter
    def launch_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_type", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLoadBalancerArgs']]]]:
        """
        Configuration block for load balancers. See below.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the service (up to 255 letters, numbers, hyphens, and underscores)

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['ServiceNetworkConfigurationArgs']]:
        """
        Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['ServiceNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @_builtins.property
    @pulumi.getter(name="orderedPlacementStrategies")
    def ordered_placement_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceOrderedPlacementStrategyArgs']]]]:
        """
        Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
        """
        return pulumi.get(self, "ordered_placement_strategies")

    @ordered_placement_strategies.setter
    def ordered_placement_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceOrderedPlacementStrategyArgs']]]]):
        pulumi.set(self, "ordered_placement_strategies", value)

    @_builtins.property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServicePlacementConstraintArgs']]]]:
        """
        Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
        """
        return pulumi.get(self, "placement_constraints")

    @placement_constraints.setter
    def placement_constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePlacementConstraintArgs']]]]):
        pulumi.set(self, "placement_constraints", value)

    @_builtins.property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform_version", value)

    @_builtins.property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to propagate the tags from the task definition or the service to the tasks. The valid values are `SERVICE` and `TASK_DEFINITION`.
        """
        return pulumi.get(self, "propagate_tags")

    @propagate_tags.setter
    def propagate_tags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "propagate_tags", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schedulingStrategy")
    def scheduling_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scheduling strategy to use for the service. The valid values are `REPLICA` and `DAEMON`. Defaults to `REPLICA`. Note that [*Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy*](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html).
        """
        return pulumi.get(self, "scheduling_strategy")

    @scheduling_strategy.setter
    def scheduling_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduling_strategy", value)

    @_builtins.property
    @pulumi.getter(name="serviceConnectConfiguration")
    def service_connect_configuration(self) -> Optional[pulumi.Input['ServiceServiceConnectConfigurationArgs']]:
        """
        ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
        """
        return pulumi.get(self, "service_connect_configuration")

    @service_connect_configuration.setter
    def service_connect_configuration(self, value: Optional[pulumi.Input['ServiceServiceConnectConfigurationArgs']]):
        pulumi.set(self, "service_connect_configuration", value)

    @_builtins.property
    @pulumi.getter(name="serviceRegistries")
    def service_registries(self) -> Optional[pulumi.Input['ServiceServiceRegistriesArgs']]:
        """
        Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
        """
        return pulumi.get(self, "service_registries")

    @service_registries.setter
    def service_registries(self, value: Optional[pulumi.Input['ServiceServiceRegistriesArgs']]):
        pulumi.set(self, "service_registries", value)

    @_builtins.property
    @pulumi.getter(name="sigintRollback")
    def sigint_rollback(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable graceful termination of deployments using SIGINT signals. When enabled, allows customers to safely cancel an in-progress deployment and automatically trigger a rollback to the previous stable state. Defaults to `false`. Only applicable when using `ECS` deployment controller and requires `wait_for_steady_state = true`.
        """
        return pulumi.get(self, "sigint_rollback")

    @sigint_rollback.setter
    def sigint_rollback(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sigint_rollback", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="taskDefinition")
    def task_definition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service. Required unless using the `EXTERNAL` deployment controller. If a revision is not specified, the latest `ACTIVE` revision is used.
        """
        return pulumi.get(self, "task_definition")

    @task_definition.setter
    def task_definition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task_definition", value)

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `"plantimestamp()"`. When using the triggers property you also need to set the forceNewDeployment property to True.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "triggers", value)

    @_builtins.property
    @pulumi.getter(name="volumeConfiguration")
    def volume_configuration(self) -> Optional[pulumi.Input['ServiceVolumeConfigurationArgs']]:
        """
        Configuration for a volume specified in the task definition as a volume that is configured at launch time. Currently, the only supported volume type is an Amazon EBS volume. See below.
        """
        return pulumi.get(self, "volume_configuration")

    @volume_configuration.setter
    def volume_configuration(self, value: Optional[pulumi.Input['ServiceVolumeConfigurationArgs']]):
        pulumi.set(self, "volume_configuration", value)

    @_builtins.property
    @pulumi.getter(name="vpcLatticeConfigurations")
    def vpc_lattice_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceVpcLatticeConfigurationArgs']]]]:
        """
        The VPC Lattice configuration for your service that allows Lattice to connect, secure, and monitor your service across multiple accounts and VPCs. See below.
        """
        return pulumi.get(self, "vpc_lattice_configurations")

    @vpc_lattice_configurations.setter
    def vpc_lattice_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceVpcLatticeConfigurationArgs']]]]):
        pulumi.set(self, "vpc_lattice_configurations", value)

    @_builtins.property
    @pulumi.getter(name="waitForSteadyState")
    def wait_for_steady_state(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, this provider will wait for the service to reach a steady state (like [`aws ecs wait services-stable`](https://docs.aws.amazon.com/cli/latest/reference/ecs/wait/services-stable.html)) before continuing. Default `false`.
        """
        return pulumi.get(self, "wait_for_steady_state")

    @wait_for_steady_state.setter
    def wait_for_steady_state(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_steady_state", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 alarms: Optional[pulumi.Input['ServiceAlarmsArgs']] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone_rebalancing: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCapacityProviderStrategyArgs']]]] = None,
                 cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_circuit_breaker: Optional[pulumi.Input['ServiceDeploymentCircuitBreakerArgs']] = None,
                 deployment_configuration: Optional[pulumi.Input['ServiceDeploymentConfigurationArgs']] = None,
                 deployment_controller: Optional[pulumi.Input['ServiceDeploymentControllerArgs']] = None,
                 deployment_maximum_percent: Optional[pulumi.Input[_builtins.int]] = None,
                 deployment_minimum_healthy_percent: Optional[pulumi.Input[_builtins.int]] = None,
                 desired_count: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_ecs_managed_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_execute_command: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_new_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLoadBalancerArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input['ServiceNetworkConfigurationArgs']] = None,
                 ordered_placement_strategies: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceOrderedPlacementStrategyArgs']]]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePlacementConstraintArgs']]]] = None,
                 platform_version: Optional[pulumi.Input[_builtins.str]] = None,
                 propagate_tags: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 service_connect_configuration: Optional[pulumi.Input['ServiceServiceConnectConfigurationArgs']] = None,
                 service_registries: Optional[pulumi.Input['ServiceServiceRegistriesArgs']] = None,
                 sigint_rollback: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 task_definition: Optional[pulumi.Input[_builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 volume_configuration: Optional[pulumi.Input['ServiceVolumeConfigurationArgs']] = None,
                 vpc_lattice_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceVpcLatticeConfigurationArgs']]]] = None,
                 wait_for_steady_state: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input['ServiceAlarmsArgs'] alarms: Information about the CloudWatch alarms. See below.
        :param pulumi.Input[_builtins.str] arn: ARN that identifies the service.
        :param pulumi.Input[_builtins.str] availability_zone_rebalancing: ECS automatically redistributes tasks within a service across Availability Zones (AZs) to mitigate the risk of impaired application availability due to underlying infrastructure failures and task lifecycle activities. The valid values are `ENABLED` and `DISABLED`. Defaults to `DISABLED`.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceCapacityProviderStrategyArgs']]] capacity_provider_strategies: Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
        :param pulumi.Input[_builtins.str] cluster: ARN of an ECS cluster.
        :param pulumi.Input['ServiceDeploymentCircuitBreakerArgs'] deployment_circuit_breaker: Configuration block for deployment circuit breaker. See below.
        :param pulumi.Input['ServiceDeploymentConfigurationArgs'] deployment_configuration: Configuration block for deployment settings. See below.
        :param pulumi.Input['ServiceDeploymentControllerArgs'] deployment_controller: Configuration block for deployment controller configuration. See below.
        :param pulumi.Input[_builtins.int] deployment_maximum_percent: Upper limit (as a percentage of the service's desiredCount) of the number of running tasks that can be running in a service during a deployment. Not valid when using the `DAEMON` scheduling strategy.
        :param pulumi.Input[_builtins.int] deployment_minimum_healthy_percent: Lower limit (as a percentage of the service's desiredCount) of the number of running tasks that must remain running and healthy in a service during a deployment.
        :param pulumi.Input[_builtins.int] desired_count: Number of instances of the task definition to place and keep running. Defaults to 0. Do not specify if using the `DAEMON` scheduling strategy.
        :param pulumi.Input[_builtins.bool] enable_ecs_managed_tags: Whether to enable Amazon ECS managed tags for the tasks within the service.
        :param pulumi.Input[_builtins.bool] enable_execute_command: Whether to enable Amazon ECS Exec for the tasks within the service.
        :param pulumi.Input[_builtins.bool] force_delete: Enable to delete a service even if it wasn't scaled down to zero tasks. It's only necessary to use this if the service uses the `REPLICA` scheduling strategy.
        :param pulumi.Input[_builtins.bool] force_new_deployment: Enable to force a new task deployment of the service. This can be used to update tasks to use a newer Docker image with same image/tag combination (e.g., `myimage:latest`), roll Fargate tasks onto a newer platform version, or immediately deploy `ordered_placement_strategy` and `placement_constraints` updates.
               When using the forceNewDeployment property you also need to configure the triggers property.
        :param pulumi.Input[_builtins.int] health_check_grace_period_seconds: Seconds to ignore failing load balancer health checks on newly instantiated tasks to prevent premature shutdown, up to 2147483647. Only valid for services configured to use load balancers.
        :param pulumi.Input[_builtins.str] iam_role: ARN of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required if you are using a load balancer with your service, but only if your task definition does not use the `awsvpc` network mode. If using `awsvpc` network mode, do not specify this role. If your account has already created the Amazon ECS service-linked role, that role is used by default for your service unless you specify a role here.
        :param pulumi.Input[_builtins.str] launch_type: Launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`. Conflicts with `capacity_provider_strategy`.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLoadBalancerArgs']]] load_balancers: Configuration block for load balancers. See below.
        :param pulumi.Input[_builtins.str] name: Name of the service (up to 255 letters, numbers, hyphens, and underscores)
               
               The following arguments are optional:
        :param pulumi.Input['ServiceNetworkConfigurationArgs'] network_configuration: Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceOrderedPlacementStrategyArgs']]] ordered_placement_strategies: Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
        :param pulumi.Input[Sequence[pulumi.Input['ServicePlacementConstraintArgs']]] placement_constraints: Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
        :param pulumi.Input[_builtins.str] platform_version: Platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        :param pulumi.Input[_builtins.str] propagate_tags: Whether to propagate the tags from the task definition or the service to the tasks. The valid values are `SERVICE` and `TASK_DEFINITION`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] scheduling_strategy: Scheduling strategy to use for the service. The valid values are `REPLICA` and `DAEMON`. Defaults to `REPLICA`. Note that [*Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy*](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html).
        :param pulumi.Input['ServiceServiceConnectConfigurationArgs'] service_connect_configuration: ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
        :param pulumi.Input['ServiceServiceRegistriesArgs'] service_registries: Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
        :param pulumi.Input[_builtins.bool] sigint_rollback: Whether to enable graceful termination of deployments using SIGINT signals. When enabled, allows customers to safely cancel an in-progress deployment and automatically trigger a rollback to the previous stable state. Defaults to `false`. Only applicable when using `ECS` deployment controller and requires `wait_for_steady_state = true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] task_definition: Family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service. Required unless using the `EXTERNAL` deployment controller. If a revision is not specified, the latest `ACTIVE` revision is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] triggers: Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `"plantimestamp()"`. When using the triggers property you also need to set the forceNewDeployment property to True.
        :param pulumi.Input['ServiceVolumeConfigurationArgs'] volume_configuration: Configuration for a volume specified in the task definition as a volume that is configured at launch time. Currently, the only supported volume type is an Amazon EBS volume. See below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceVpcLatticeConfigurationArgs']]] vpc_lattice_configurations: The VPC Lattice configuration for your service that allows Lattice to connect, secure, and monitor your service across multiple accounts and VPCs. See below.
        :param pulumi.Input[_builtins.bool] wait_for_steady_state: If `true`, this provider will wait for the service to reach a steady state (like [`aws ecs wait services-stable`](https://docs.aws.amazon.com/cli/latest/reference/ecs/wait/services-stable.html)) before continuing. Default `false`.
        """
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if availability_zone_rebalancing is not None:
            pulumi.set(__self__, "availability_zone_rebalancing", availability_zone_rebalancing)
        if capacity_provider_strategies is not None:
            pulumi.set(__self__, "capacity_provider_strategies", capacity_provider_strategies)
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if deployment_circuit_breaker is not None:
            pulumi.set(__self__, "deployment_circuit_breaker", deployment_circuit_breaker)
        if deployment_configuration is not None:
            pulumi.set(__self__, "deployment_configuration", deployment_configuration)
        if deployment_controller is not None:
            pulumi.set(__self__, "deployment_controller", deployment_controller)
        if deployment_maximum_percent is not None:
            pulumi.set(__self__, "deployment_maximum_percent", deployment_maximum_percent)
        if deployment_minimum_healthy_percent is not None:
            pulumi.set(__self__, "deployment_minimum_healthy_percent", deployment_minimum_healthy_percent)
        if desired_count is not None:
            pulumi.set(__self__, "desired_count", desired_count)
        if enable_ecs_managed_tags is not None:
            pulumi.set(__self__, "enable_ecs_managed_tags", enable_ecs_managed_tags)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if force_new_deployment is not None:
            pulumi.set(__self__, "force_new_deployment", force_new_deployment)
        if health_check_grace_period_seconds is not None:
            pulumi.set(__self__, "health_check_grace_period_seconds", health_check_grace_period_seconds)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if launch_type is not None:
            pulumi.set(__self__, "launch_type", launch_type)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if ordered_placement_strategies is not None:
            pulumi.set(__self__, "ordered_placement_strategies", ordered_placement_strategies)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scheduling_strategy is not None:
            pulumi.set(__self__, "scheduling_strategy", scheduling_strategy)
        if service_connect_configuration is not None:
            pulumi.set(__self__, "service_connect_configuration", service_connect_configuration)
        if service_registries is not None:
            pulumi.set(__self__, "service_registries", service_registries)
        if sigint_rollback is not None:
            pulumi.set(__self__, "sigint_rollback", sigint_rollback)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if task_definition is not None:
            pulumi.set(__self__, "task_definition", task_definition)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if volume_configuration is not None:
            pulumi.set(__self__, "volume_configuration", volume_configuration)
        if vpc_lattice_configurations is not None:
            pulumi.set(__self__, "vpc_lattice_configurations", vpc_lattice_configurations)
        if wait_for_steady_state is not None:
            pulumi.set(__self__, "wait_for_steady_state", wait_for_steady_state)

    @_builtins.property
    @pulumi.getter
    def alarms(self) -> Optional[pulumi.Input['ServiceAlarmsArgs']]:
        """
        Information about the CloudWatch alarms. See below.
        """
        return pulumi.get(self, "alarms")

    @alarms.setter
    def alarms(self, value: Optional[pulumi.Input['ServiceAlarmsArgs']]):
        pulumi.set(self, "alarms", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN that identifies the service.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneRebalancing")
    def availability_zone_rebalancing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ECS automatically redistributes tasks within a service across Availability Zones (AZs) to mitigate the risk of impaired application availability due to underlying infrastructure failures and task lifecycle activities. The valid values are `ENABLED` and `DISABLED`. Defaults to `DISABLED`.
        """
        return pulumi.get(self, "availability_zone_rebalancing")

    @availability_zone_rebalancing.setter
    def availability_zone_rebalancing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone_rebalancing", value)

    @_builtins.property
    @pulumi.getter(name="capacityProviderStrategies")
    def capacity_provider_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCapacityProviderStrategyArgs']]]]:
        """
        Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
        """
        return pulumi.get(self, "capacity_provider_strategies")

    @capacity_provider_strategies.setter
    def capacity_provider_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCapacityProviderStrategyArgs']]]]):
        pulumi.set(self, "capacity_provider_strategies", value)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of an ECS cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster", value)

    @_builtins.property
    @pulumi.getter(name="deploymentCircuitBreaker")
    def deployment_circuit_breaker(self) -> Optional[pulumi.Input['ServiceDeploymentCircuitBreakerArgs']]:
        """
        Configuration block for deployment circuit breaker. See below.
        """
        return pulumi.get(self, "deployment_circuit_breaker")

    @deployment_circuit_breaker.setter
    def deployment_circuit_breaker(self, value: Optional[pulumi.Input['ServiceDeploymentCircuitBreakerArgs']]):
        pulumi.set(self, "deployment_circuit_breaker", value)

    @_builtins.property
    @pulumi.getter(name="deploymentConfiguration")
    def deployment_configuration(self) -> Optional[pulumi.Input['ServiceDeploymentConfigurationArgs']]:
        """
        Configuration block for deployment settings. See below.
        """
        return pulumi.get(self, "deployment_configuration")

    @deployment_configuration.setter
    def deployment_configuration(self, value: Optional[pulumi.Input['ServiceDeploymentConfigurationArgs']]):
        pulumi.set(self, "deployment_configuration", value)

    @_builtins.property
    @pulumi.getter(name="deploymentController")
    def deployment_controller(self) -> Optional[pulumi.Input['ServiceDeploymentControllerArgs']]:
        """
        Configuration block for deployment controller configuration. See below.
        """
        return pulumi.get(self, "deployment_controller")

    @deployment_controller.setter
    def deployment_controller(self, value: Optional[pulumi.Input['ServiceDeploymentControllerArgs']]):
        pulumi.set(self, "deployment_controller", value)

    @_builtins.property
    @pulumi.getter(name="deploymentMaximumPercent")
    def deployment_maximum_percent(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Upper limit (as a percentage of the service's desiredCount) of the number of running tasks that can be running in a service during a deployment. Not valid when using the `DAEMON` scheduling strategy.
        """
        return pulumi.get(self, "deployment_maximum_percent")

    @deployment_maximum_percent.setter
    def deployment_maximum_percent(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deployment_maximum_percent", value)

    @_builtins.property
    @pulumi.getter(name="deploymentMinimumHealthyPercent")
    def deployment_minimum_healthy_percent(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lower limit (as a percentage of the service's desiredCount) of the number of running tasks that must remain running and healthy in a service during a deployment.
        """
        return pulumi.get(self, "deployment_minimum_healthy_percent")

    @deployment_minimum_healthy_percent.setter
    def deployment_minimum_healthy_percent(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deployment_minimum_healthy_percent", value)

    @_builtins.property
    @pulumi.getter(name="desiredCount")
    def desired_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of instances of the task definition to place and keep running. Defaults to 0. Do not specify if using the `DAEMON` scheduling strategy.
        """
        return pulumi.get(self, "desired_count")

    @desired_count.setter
    def desired_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "desired_count", value)

    @_builtins.property
    @pulumi.getter(name="enableEcsManagedTags")
    def enable_ecs_managed_tags(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable Amazon ECS managed tags for the tasks within the service.
        """
        return pulumi.get(self, "enable_ecs_managed_tags")

    @enable_ecs_managed_tags.setter
    def enable_ecs_managed_tags(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ecs_managed_tags", value)

    @_builtins.property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable Amazon ECS Exec for the tasks within the service.
        """
        return pulumi.get(self, "enable_execute_command")

    @enable_execute_command.setter
    def enable_execute_command(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_execute_command", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to delete a service even if it wasn't scaled down to zero tasks. It's only necessary to use this if the service uses the `REPLICA` scheduling strategy.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="forceNewDeployment")
    def force_new_deployment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to force a new task deployment of the service. This can be used to update tasks to use a newer Docker image with same image/tag combination (e.g., `myimage:latest`), roll Fargate tasks onto a newer platform version, or immediately deploy `ordered_placement_strategy` and `placement_constraints` updates.
        When using the forceNewDeployment property you also need to configure the triggers property.
        """
        return pulumi.get(self, "force_new_deployment")

    @force_new_deployment.setter
    def force_new_deployment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_new_deployment", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckGracePeriodSeconds")
    def health_check_grace_period_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds to ignore failing load balancer health checks on newly instantiated tasks to prevent premature shutdown, up to 2147483647. Only valid for services configured to use load balancers.
        """
        return pulumi.get(self, "health_check_grace_period_seconds")

    @health_check_grace_period_seconds.setter
    def health_check_grace_period_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_grace_period_seconds", value)

    @_builtins.property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required if you are using a load balancer with your service, but only if your task definition does not use the `awsvpc` network mode. If using `awsvpc` network mode, do not specify this role. If your account has already created the Amazon ECS service-linked role, that role is used by default for your service unless you specify a role here.
        """
        return pulumi.get(self, "iam_role")

    @iam_role.setter
    def iam_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_role", value)

    @_builtins.property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`. Conflicts with `capacity_provider_strategy`.
        """
        return pulumi.get(self, "launch_type")

    @launch_type.setter
    def launch_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_type", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLoadBalancerArgs']]]]:
        """
        Configuration block for load balancers. See below.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the service (up to 255 letters, numbers, hyphens, and underscores)

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['ServiceNetworkConfigurationArgs']]:
        """
        Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['ServiceNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @_builtins.property
    @pulumi.getter(name="orderedPlacementStrategies")
    def ordered_placement_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceOrderedPlacementStrategyArgs']]]]:
        """
        Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
        """
        return pulumi.get(self, "ordered_placement_strategies")

    @ordered_placement_strategies.setter
    def ordered_placement_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceOrderedPlacementStrategyArgs']]]]):
        pulumi.set(self, "ordered_placement_strategies", value)

    @_builtins.property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServicePlacementConstraintArgs']]]]:
        """
        Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
        """
        return pulumi.get(self, "placement_constraints")

    @placement_constraints.setter
    def placement_constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePlacementConstraintArgs']]]]):
        pulumi.set(self, "placement_constraints", value)

    @_builtins.property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform_version", value)

    @_builtins.property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to propagate the tags from the task definition or the service to the tasks. The valid values are `SERVICE` and `TASK_DEFINITION`.
        """
        return pulumi.get(self, "propagate_tags")

    @propagate_tags.setter
    def propagate_tags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "propagate_tags", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schedulingStrategy")
    def scheduling_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scheduling strategy to use for the service. The valid values are `REPLICA` and `DAEMON`. Defaults to `REPLICA`. Note that [*Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy*](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html).
        """
        return pulumi.get(self, "scheduling_strategy")

    @scheduling_strategy.setter
    def scheduling_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduling_strategy", value)

    @_builtins.property
    @pulumi.getter(name="serviceConnectConfiguration")
    def service_connect_configuration(self) -> Optional[pulumi.Input['ServiceServiceConnectConfigurationArgs']]:
        """
        ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
        """
        return pulumi.get(self, "service_connect_configuration")

    @service_connect_configuration.setter
    def service_connect_configuration(self, value: Optional[pulumi.Input['ServiceServiceConnectConfigurationArgs']]):
        pulumi.set(self, "service_connect_configuration", value)

    @_builtins.property
    @pulumi.getter(name="serviceRegistries")
    def service_registries(self) -> Optional[pulumi.Input['ServiceServiceRegistriesArgs']]:
        """
        Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
        """
        return pulumi.get(self, "service_registries")

    @service_registries.setter
    def service_registries(self, value: Optional[pulumi.Input['ServiceServiceRegistriesArgs']]):
        pulumi.set(self, "service_registries", value)

    @_builtins.property
    @pulumi.getter(name="sigintRollback")
    def sigint_rollback(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable graceful termination of deployments using SIGINT signals. When enabled, allows customers to safely cancel an in-progress deployment and automatically trigger a rollback to the previous stable state. Defaults to `false`. Only applicable when using `ECS` deployment controller and requires `wait_for_steady_state = true`.
        """
        return pulumi.get(self, "sigint_rollback")

    @sigint_rollback.setter
    def sigint_rollback(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sigint_rollback", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="taskDefinition")
    def task_definition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service. Required unless using the `EXTERNAL` deployment controller. If a revision is not specified, the latest `ACTIVE` revision is used.
        """
        return pulumi.get(self, "task_definition")

    @task_definition.setter
    def task_definition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task_definition", value)

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `"plantimestamp()"`. When using the triggers property you also need to set the forceNewDeployment property to True.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "triggers", value)

    @_builtins.property
    @pulumi.getter(name="volumeConfiguration")
    def volume_configuration(self) -> Optional[pulumi.Input['ServiceVolumeConfigurationArgs']]:
        """
        Configuration for a volume specified in the task definition as a volume that is configured at launch time. Currently, the only supported volume type is an Amazon EBS volume. See below.
        """
        return pulumi.get(self, "volume_configuration")

    @volume_configuration.setter
    def volume_configuration(self, value: Optional[pulumi.Input['ServiceVolumeConfigurationArgs']]):
        pulumi.set(self, "volume_configuration", value)

    @_builtins.property
    @pulumi.getter(name="vpcLatticeConfigurations")
    def vpc_lattice_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceVpcLatticeConfigurationArgs']]]]:
        """
        The VPC Lattice configuration for your service that allows Lattice to connect, secure, and monitor your service across multiple accounts and VPCs. See below.
        """
        return pulumi.get(self, "vpc_lattice_configurations")

    @vpc_lattice_configurations.setter
    def vpc_lattice_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceVpcLatticeConfigurationArgs']]]]):
        pulumi.set(self, "vpc_lattice_configurations", value)

    @_builtins.property
    @pulumi.getter(name="waitForSteadyState")
    def wait_for_steady_state(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, this provider will wait for the service to reach a steady state (like [`aws ecs wait services-stable`](https://docs.aws.amazon.com/cli/latest/reference/ecs/wait/services-stable.html)) before continuing. Default `false`.
        """
        return pulumi.get(self, "wait_for_steady_state")

    @wait_for_steady_state.setter
    def wait_for_steady_state(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_steady_state", value)


@pulumi.type_token("aws:ecs/service:Service")
class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarms: Optional[pulumi.Input[Union['ServiceAlarmsArgs', 'ServiceAlarmsArgsDict']]] = None,
                 availability_zone_rebalancing: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCapacityProviderStrategyArgs', 'ServiceCapacityProviderStrategyArgsDict']]]]] = None,
                 cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_circuit_breaker: Optional[pulumi.Input[Union['ServiceDeploymentCircuitBreakerArgs', 'ServiceDeploymentCircuitBreakerArgsDict']]] = None,
                 deployment_configuration: Optional[pulumi.Input[Union['ServiceDeploymentConfigurationArgs', 'ServiceDeploymentConfigurationArgsDict']]] = None,
                 deployment_controller: Optional[pulumi.Input[Union['ServiceDeploymentControllerArgs', 'ServiceDeploymentControllerArgsDict']]] = None,
                 deployment_maximum_percent: Optional[pulumi.Input[_builtins.int]] = None,
                 deployment_minimum_healthy_percent: Optional[pulumi.Input[_builtins.int]] = None,
                 desired_count: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_ecs_managed_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_execute_command: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_new_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLoadBalancerArgs', 'ServiceLoadBalancerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input[Union['ServiceNetworkConfigurationArgs', 'ServiceNetworkConfigurationArgsDict']]] = None,
                 ordered_placement_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceOrderedPlacementStrategyArgs', 'ServiceOrderedPlacementStrategyArgsDict']]]]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePlacementConstraintArgs', 'ServicePlacementConstraintArgsDict']]]]] = None,
                 platform_version: Optional[pulumi.Input[_builtins.str]] = None,
                 propagate_tags: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 service_connect_configuration: Optional[pulumi.Input[Union['ServiceServiceConnectConfigurationArgs', 'ServiceServiceConnectConfigurationArgsDict']]] = None,
                 service_registries: Optional[pulumi.Input[Union['ServiceServiceRegistriesArgs', 'ServiceServiceRegistriesArgsDict']]] = None,
                 sigint_rollback: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 task_definition: Optional[pulumi.Input[_builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 volume_configuration: Optional[pulumi.Input[Union['ServiceVolumeConfigurationArgs', 'ServiceVolumeConfigurationArgsDict']]] = None,
                 vpc_lattice_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceVpcLatticeConfigurationArgs', 'ServiceVpcLatticeConfigurationArgsDict']]]]] = None,
                 wait_for_steady_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        > **Note:** To prevent a race condition during service deletion, make sure to set `depends_on` to the related `iam.RolePolicy`; otherwise, the policy may be destroyed too soon and the ECS service will then get stuck in the `DRAINING` state.

        Provides an ECS service - effectively a task that is expected to run until an error occurs or a user terminates it (typically a webserver or a database).

        See [ECS Services section in AWS developer guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        mongo = aws.ecs.Service("mongo",
            name="mongodb",
            cluster=foo_aws_ecs_cluster["id"],
            task_definition=mongo_aws_ecs_task_definition["arn"],
            desired_count=3,
            iam_role=foo_aws_iam_role["arn"],
            ordered_placement_strategies=[{
                "type": "binpack",
                "field": "cpu",
            }],
            load_balancers=[{
                "target_group_arn": foo_aws_lb_target_group["arn"],
                "container_name": "mongo",
                "container_port": 8080,
            }],
            placement_constraints=[{
                "type": "memberOf",
                "expression": "attribute:ecs.availability-zone in [us-west-2a, us-west-2b]",
            }],
            opts = pulumi.ResourceOptions(depends_on=[foo]))
        ```

        ### Ignoring Changes to Desired Count

        You can use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to create an ECS service with an initial count of running instances, then ignore any changes to that count caused externally (e.g. Application Autoscaling).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecs.Service("example", desired_count=2)
        ```

        ### Daemon Scheduling Strategy

        ```python
        import pulumi
        import pulumi_aws as aws

        bar = aws.ecs.Service("bar",
            name="bar",
            cluster=foo["id"],
            task_definition=bar_aws_ecs_task_definition["arn"],
            scheduling_strategy="DAEMON")
        ```

        ### CloudWatch Deployment Alarms

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecs.Service("example",
            name="example",
            cluster=example_aws_ecs_cluster["id"],
            alarms={
                "enable": True,
                "rollback": True,
                "alarm_names": [example_aws_cloudwatch_metric_alarm["alarmName"]],
            })
        ```

        ### External Deployment Controller

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecs.Service("example",
            name="example",
            cluster=example_aws_ecs_cluster["id"],
            deployment_controller={
                "type": "EXTERNAL",
            })
        ```

        ### Blue/Green Deployment with SIGINT Rollback

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecs.Service("example",
            name="example",
            cluster=example_aws_ecs_cluster["id"],
            deployment_configuration={
                "strategy": "BLUE_GREEN",
            },
            sigint_rollback=True,
            wait_for_steady_state=True)
        ```

        ### Redeploy Service On Every Apply

        The key used with `triggers` is arbitrary.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecs.Service("example",
            force_new_deployment=True,
            triggers={
                "redeployment": "plantimestamp()",
            })
        ```

        ## Import

        Using `pulumi import`, import ECS services using the `name` together with ecs cluster `name`. For example:

        ```sh
        $ pulumi import aws:ecs/service:Service imported cluster-name/service-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServiceAlarmsArgs', 'ServiceAlarmsArgsDict']] alarms: Information about the CloudWatch alarms. See below.
        :param pulumi.Input[_builtins.str] availability_zone_rebalancing: ECS automatically redistributes tasks within a service across Availability Zones (AZs) to mitigate the risk of impaired application availability due to underlying infrastructure failures and task lifecycle activities. The valid values are `ENABLED` and `DISABLED`. Defaults to `DISABLED`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceCapacityProviderStrategyArgs', 'ServiceCapacityProviderStrategyArgsDict']]]] capacity_provider_strategies: Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
        :param pulumi.Input[_builtins.str] cluster: ARN of an ECS cluster.
        :param pulumi.Input[Union['ServiceDeploymentCircuitBreakerArgs', 'ServiceDeploymentCircuitBreakerArgsDict']] deployment_circuit_breaker: Configuration block for deployment circuit breaker. See below.
        :param pulumi.Input[Union['ServiceDeploymentConfigurationArgs', 'ServiceDeploymentConfigurationArgsDict']] deployment_configuration: Configuration block for deployment settings. See below.
        :param pulumi.Input[Union['ServiceDeploymentControllerArgs', 'ServiceDeploymentControllerArgsDict']] deployment_controller: Configuration block for deployment controller configuration. See below.
        :param pulumi.Input[_builtins.int] deployment_maximum_percent: Upper limit (as a percentage of the service's desiredCount) of the number of running tasks that can be running in a service during a deployment. Not valid when using the `DAEMON` scheduling strategy.
        :param pulumi.Input[_builtins.int] deployment_minimum_healthy_percent: Lower limit (as a percentage of the service's desiredCount) of the number of running tasks that must remain running and healthy in a service during a deployment.
        :param pulumi.Input[_builtins.int] desired_count: Number of instances of the task definition to place and keep running. Defaults to 0. Do not specify if using the `DAEMON` scheduling strategy.
        :param pulumi.Input[_builtins.bool] enable_ecs_managed_tags: Whether to enable Amazon ECS managed tags for the tasks within the service.
        :param pulumi.Input[_builtins.bool] enable_execute_command: Whether to enable Amazon ECS Exec for the tasks within the service.
        :param pulumi.Input[_builtins.bool] force_delete: Enable to delete a service even if it wasn't scaled down to zero tasks. It's only necessary to use this if the service uses the `REPLICA` scheduling strategy.
        :param pulumi.Input[_builtins.bool] force_new_deployment: Enable to force a new task deployment of the service. This can be used to update tasks to use a newer Docker image with same image/tag combination (e.g., `myimage:latest`), roll Fargate tasks onto a newer platform version, or immediately deploy `ordered_placement_strategy` and `placement_constraints` updates.
               When using the forceNewDeployment property you also need to configure the triggers property.
        :param pulumi.Input[_builtins.int] health_check_grace_period_seconds: Seconds to ignore failing load balancer health checks on newly instantiated tasks to prevent premature shutdown, up to 2147483647. Only valid for services configured to use load balancers.
        :param pulumi.Input[_builtins.str] iam_role: ARN of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required if you are using a load balancer with your service, but only if your task definition does not use the `awsvpc` network mode. If using `awsvpc` network mode, do not specify this role. If your account has already created the Amazon ECS service-linked role, that role is used by default for your service unless you specify a role here.
        :param pulumi.Input[_builtins.str] launch_type: Launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`. Conflicts with `capacity_provider_strategy`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLoadBalancerArgs', 'ServiceLoadBalancerArgsDict']]]] load_balancers: Configuration block for load balancers. See below.
        :param pulumi.Input[_builtins.str] name: Name of the service (up to 255 letters, numbers, hyphens, and underscores)
               
               The following arguments are optional:
        :param pulumi.Input[Union['ServiceNetworkConfigurationArgs', 'ServiceNetworkConfigurationArgsDict']] network_configuration: Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceOrderedPlacementStrategyArgs', 'ServiceOrderedPlacementStrategyArgsDict']]]] ordered_placement_strategies: Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicePlacementConstraintArgs', 'ServicePlacementConstraintArgsDict']]]] placement_constraints: Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
        :param pulumi.Input[_builtins.str] platform_version: Platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        :param pulumi.Input[_builtins.str] propagate_tags: Whether to propagate the tags from the task definition or the service to the tasks. The valid values are `SERVICE` and `TASK_DEFINITION`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] scheduling_strategy: Scheduling strategy to use for the service. The valid values are `REPLICA` and `DAEMON`. Defaults to `REPLICA`. Note that [*Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy*](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html).
        :param pulumi.Input[Union['ServiceServiceConnectConfigurationArgs', 'ServiceServiceConnectConfigurationArgsDict']] service_connect_configuration: ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
        :param pulumi.Input[Union['ServiceServiceRegistriesArgs', 'ServiceServiceRegistriesArgsDict']] service_registries: Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
        :param pulumi.Input[_builtins.bool] sigint_rollback: Whether to enable graceful termination of deployments using SIGINT signals. When enabled, allows customers to safely cancel an in-progress deployment and automatically trigger a rollback to the previous stable state. Defaults to `false`. Only applicable when using `ECS` deployment controller and requires `wait_for_steady_state = true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] task_definition: Family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service. Required unless using the `EXTERNAL` deployment controller. If a revision is not specified, the latest `ACTIVE` revision is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] triggers: Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `"plantimestamp()"`. When using the triggers property you also need to set the forceNewDeployment property to True.
        :param pulumi.Input[Union['ServiceVolumeConfigurationArgs', 'ServiceVolumeConfigurationArgsDict']] volume_configuration: Configuration for a volume specified in the task definition as a volume that is configured at launch time. Currently, the only supported volume type is an Amazon EBS volume. See below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceVpcLatticeConfigurationArgs', 'ServiceVpcLatticeConfigurationArgsDict']]]] vpc_lattice_configurations: The VPC Lattice configuration for your service that allows Lattice to connect, secure, and monitor your service across multiple accounts and VPCs. See below.
        :param pulumi.Input[_builtins.bool] wait_for_steady_state: If `true`, this provider will wait for the service to reach a steady state (like [`aws ecs wait services-stable`](https://docs.aws.amazon.com/cli/latest/reference/ecs/wait/services-stable.html)) before continuing. Default `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServiceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Note:** To prevent a race condition during service deletion, make sure to set `depends_on` to the related `iam.RolePolicy`; otherwise, the policy may be destroyed too soon and the ECS service will then get stuck in the `DRAINING` state.

        Provides an ECS service - effectively a task that is expected to run until an error occurs or a user terminates it (typically a webserver or a database).

        See [ECS Services section in AWS developer guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        mongo = aws.ecs.Service("mongo",
            name="mongodb",
            cluster=foo_aws_ecs_cluster["id"],
            task_definition=mongo_aws_ecs_task_definition["arn"],
            desired_count=3,
            iam_role=foo_aws_iam_role["arn"],
            ordered_placement_strategies=[{
                "type": "binpack",
                "field": "cpu",
            }],
            load_balancers=[{
                "target_group_arn": foo_aws_lb_target_group["arn"],
                "container_name": "mongo",
                "container_port": 8080,
            }],
            placement_constraints=[{
                "type": "memberOf",
                "expression": "attribute:ecs.availability-zone in [us-west-2a, us-west-2b]",
            }],
            opts = pulumi.ResourceOptions(depends_on=[foo]))
        ```

        ### Ignoring Changes to Desired Count

        You can use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to create an ECS service with an initial count of running instances, then ignore any changes to that count caused externally (e.g. Application Autoscaling).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecs.Service("example", desired_count=2)
        ```

        ### Daemon Scheduling Strategy

        ```python
        import pulumi
        import pulumi_aws as aws

        bar = aws.ecs.Service("bar",
            name="bar",
            cluster=foo["id"],
            task_definition=bar_aws_ecs_task_definition["arn"],
            scheduling_strategy="DAEMON")
        ```

        ### CloudWatch Deployment Alarms

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecs.Service("example",
            name="example",
            cluster=example_aws_ecs_cluster["id"],
            alarms={
                "enable": True,
                "rollback": True,
                "alarm_names": [example_aws_cloudwatch_metric_alarm["alarmName"]],
            })
        ```

        ### External Deployment Controller

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecs.Service("example",
            name="example",
            cluster=example_aws_ecs_cluster["id"],
            deployment_controller={
                "type": "EXTERNAL",
            })
        ```

        ### Blue/Green Deployment with SIGINT Rollback

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecs.Service("example",
            name="example",
            cluster=example_aws_ecs_cluster["id"],
            deployment_configuration={
                "strategy": "BLUE_GREEN",
            },
            sigint_rollback=True,
            wait_for_steady_state=True)
        ```

        ### Redeploy Service On Every Apply

        The key used with `triggers` is arbitrary.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecs.Service("example",
            force_new_deployment=True,
            triggers={
                "redeployment": "plantimestamp()",
            })
        ```

        ## Import

        Using `pulumi import`, import ECS services using the `name` together with ecs cluster `name`. For example:

        ```sh
        $ pulumi import aws:ecs/service:Service imported cluster-name/service-name
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarms: Optional[pulumi.Input[Union['ServiceAlarmsArgs', 'ServiceAlarmsArgsDict']]] = None,
                 availability_zone_rebalancing: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCapacityProviderStrategyArgs', 'ServiceCapacityProviderStrategyArgsDict']]]]] = None,
                 cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_circuit_breaker: Optional[pulumi.Input[Union['ServiceDeploymentCircuitBreakerArgs', 'ServiceDeploymentCircuitBreakerArgsDict']]] = None,
                 deployment_configuration: Optional[pulumi.Input[Union['ServiceDeploymentConfigurationArgs', 'ServiceDeploymentConfigurationArgsDict']]] = None,
                 deployment_controller: Optional[pulumi.Input[Union['ServiceDeploymentControllerArgs', 'ServiceDeploymentControllerArgsDict']]] = None,
                 deployment_maximum_percent: Optional[pulumi.Input[_builtins.int]] = None,
                 deployment_minimum_healthy_percent: Optional[pulumi.Input[_builtins.int]] = None,
                 desired_count: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_ecs_managed_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_execute_command: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_new_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLoadBalancerArgs', 'ServiceLoadBalancerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input[Union['ServiceNetworkConfigurationArgs', 'ServiceNetworkConfigurationArgsDict']]] = None,
                 ordered_placement_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceOrderedPlacementStrategyArgs', 'ServiceOrderedPlacementStrategyArgsDict']]]]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePlacementConstraintArgs', 'ServicePlacementConstraintArgsDict']]]]] = None,
                 platform_version: Optional[pulumi.Input[_builtins.str]] = None,
                 propagate_tags: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 service_connect_configuration: Optional[pulumi.Input[Union['ServiceServiceConnectConfigurationArgs', 'ServiceServiceConnectConfigurationArgsDict']]] = None,
                 service_registries: Optional[pulumi.Input[Union['ServiceServiceRegistriesArgs', 'ServiceServiceRegistriesArgsDict']]] = None,
                 sigint_rollback: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 task_definition: Optional[pulumi.Input[_builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 volume_configuration: Optional[pulumi.Input[Union['ServiceVolumeConfigurationArgs', 'ServiceVolumeConfigurationArgsDict']]] = None,
                 vpc_lattice_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceVpcLatticeConfigurationArgs', 'ServiceVpcLatticeConfigurationArgsDict']]]]] = None,
                 wait_for_steady_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["alarms"] = alarms
            __props__.__dict__["availability_zone_rebalancing"] = availability_zone_rebalancing
            __props__.__dict__["capacity_provider_strategies"] = capacity_provider_strategies
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["deployment_circuit_breaker"] = deployment_circuit_breaker
            __props__.__dict__["deployment_configuration"] = deployment_configuration
            __props__.__dict__["deployment_controller"] = deployment_controller
            __props__.__dict__["deployment_maximum_percent"] = deployment_maximum_percent
            __props__.__dict__["deployment_minimum_healthy_percent"] = deployment_minimum_healthy_percent
            __props__.__dict__["desired_count"] = desired_count
            __props__.__dict__["enable_ecs_managed_tags"] = enable_ecs_managed_tags
            __props__.__dict__["enable_execute_command"] = enable_execute_command
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["force_new_deployment"] = force_new_deployment
            __props__.__dict__["health_check_grace_period_seconds"] = health_check_grace_period_seconds
            __props__.__dict__["iam_role"] = iam_role
            __props__.__dict__["launch_type"] = launch_type
            __props__.__dict__["load_balancers"] = load_balancers
            __props__.__dict__["name"] = name
            __props__.__dict__["network_configuration"] = network_configuration
            __props__.__dict__["ordered_placement_strategies"] = ordered_placement_strategies
            __props__.__dict__["placement_constraints"] = placement_constraints
            __props__.__dict__["platform_version"] = platform_version
            __props__.__dict__["propagate_tags"] = propagate_tags
            __props__.__dict__["region"] = region
            __props__.__dict__["scheduling_strategy"] = scheduling_strategy
            __props__.__dict__["service_connect_configuration"] = service_connect_configuration
            __props__.__dict__["service_registries"] = service_registries
            __props__.__dict__["sigint_rollback"] = sigint_rollback
            __props__.__dict__["tags"] = tags
            __props__.__dict__["task_definition"] = task_definition
            __props__.__dict__["triggers"] = triggers
            __props__.__dict__["volume_configuration"] = volume_configuration
            __props__.__dict__["vpc_lattice_configurations"] = vpc_lattice_configurations
            __props__.__dict__["wait_for_steady_state"] = wait_for_steady_state
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Service, __self__).__init__(
            'aws:ecs/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alarms: Optional[pulumi.Input[Union['ServiceAlarmsArgs', 'ServiceAlarmsArgsDict']]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone_rebalancing: Optional[pulumi.Input[_builtins.str]] = None,
            capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCapacityProviderStrategyArgs', 'ServiceCapacityProviderStrategyArgsDict']]]]] = None,
            cluster: Optional[pulumi.Input[_builtins.str]] = None,
            deployment_circuit_breaker: Optional[pulumi.Input[Union['ServiceDeploymentCircuitBreakerArgs', 'ServiceDeploymentCircuitBreakerArgsDict']]] = None,
            deployment_configuration: Optional[pulumi.Input[Union['ServiceDeploymentConfigurationArgs', 'ServiceDeploymentConfigurationArgsDict']]] = None,
            deployment_controller: Optional[pulumi.Input[Union['ServiceDeploymentControllerArgs', 'ServiceDeploymentControllerArgsDict']]] = None,
            deployment_maximum_percent: Optional[pulumi.Input[_builtins.int]] = None,
            deployment_minimum_healthy_percent: Optional[pulumi.Input[_builtins.int]] = None,
            desired_count: Optional[pulumi.Input[_builtins.int]] = None,
            enable_ecs_managed_tags: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_execute_command: Optional[pulumi.Input[_builtins.bool]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            force_new_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
            health_check_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            iam_role: Optional[pulumi.Input[_builtins.str]] = None,
            launch_type: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLoadBalancerArgs', 'ServiceLoadBalancerArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_configuration: Optional[pulumi.Input[Union['ServiceNetworkConfigurationArgs', 'ServiceNetworkConfigurationArgsDict']]] = None,
            ordered_placement_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceOrderedPlacementStrategyArgs', 'ServiceOrderedPlacementStrategyArgsDict']]]]] = None,
            placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePlacementConstraintArgs', 'ServicePlacementConstraintArgsDict']]]]] = None,
            platform_version: Optional[pulumi.Input[_builtins.str]] = None,
            propagate_tags: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            scheduling_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            service_connect_configuration: Optional[pulumi.Input[Union['ServiceServiceConnectConfigurationArgs', 'ServiceServiceConnectConfigurationArgsDict']]] = None,
            service_registries: Optional[pulumi.Input[Union['ServiceServiceRegistriesArgs', 'ServiceServiceRegistriesArgsDict']]] = None,
            sigint_rollback: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            task_definition: Optional[pulumi.Input[_builtins.str]] = None,
            triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            volume_configuration: Optional[pulumi.Input[Union['ServiceVolumeConfigurationArgs', 'ServiceVolumeConfigurationArgsDict']]] = None,
            vpc_lattice_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceVpcLatticeConfigurationArgs', 'ServiceVpcLatticeConfigurationArgsDict']]]]] = None,
            wait_for_steady_state: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServiceAlarmsArgs', 'ServiceAlarmsArgsDict']] alarms: Information about the CloudWatch alarms. See below.
        :param pulumi.Input[_builtins.str] arn: ARN that identifies the service.
        :param pulumi.Input[_builtins.str] availability_zone_rebalancing: ECS automatically redistributes tasks within a service across Availability Zones (AZs) to mitigate the risk of impaired application availability due to underlying infrastructure failures and task lifecycle activities. The valid values are `ENABLED` and `DISABLED`. Defaults to `DISABLED`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceCapacityProviderStrategyArgs', 'ServiceCapacityProviderStrategyArgsDict']]]] capacity_provider_strategies: Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
        :param pulumi.Input[_builtins.str] cluster: ARN of an ECS cluster.
        :param pulumi.Input[Union['ServiceDeploymentCircuitBreakerArgs', 'ServiceDeploymentCircuitBreakerArgsDict']] deployment_circuit_breaker: Configuration block for deployment circuit breaker. See below.
        :param pulumi.Input[Union['ServiceDeploymentConfigurationArgs', 'ServiceDeploymentConfigurationArgsDict']] deployment_configuration: Configuration block for deployment settings. See below.
        :param pulumi.Input[Union['ServiceDeploymentControllerArgs', 'ServiceDeploymentControllerArgsDict']] deployment_controller: Configuration block for deployment controller configuration. See below.
        :param pulumi.Input[_builtins.int] deployment_maximum_percent: Upper limit (as a percentage of the service's desiredCount) of the number of running tasks that can be running in a service during a deployment. Not valid when using the `DAEMON` scheduling strategy.
        :param pulumi.Input[_builtins.int] deployment_minimum_healthy_percent: Lower limit (as a percentage of the service's desiredCount) of the number of running tasks that must remain running and healthy in a service during a deployment.
        :param pulumi.Input[_builtins.int] desired_count: Number of instances of the task definition to place and keep running. Defaults to 0. Do not specify if using the `DAEMON` scheduling strategy.
        :param pulumi.Input[_builtins.bool] enable_ecs_managed_tags: Whether to enable Amazon ECS managed tags for the tasks within the service.
        :param pulumi.Input[_builtins.bool] enable_execute_command: Whether to enable Amazon ECS Exec for the tasks within the service.
        :param pulumi.Input[_builtins.bool] force_delete: Enable to delete a service even if it wasn't scaled down to zero tasks. It's only necessary to use this if the service uses the `REPLICA` scheduling strategy.
        :param pulumi.Input[_builtins.bool] force_new_deployment: Enable to force a new task deployment of the service. This can be used to update tasks to use a newer Docker image with same image/tag combination (e.g., `myimage:latest`), roll Fargate tasks onto a newer platform version, or immediately deploy `ordered_placement_strategy` and `placement_constraints` updates.
               When using the forceNewDeployment property you also need to configure the triggers property.
        :param pulumi.Input[_builtins.int] health_check_grace_period_seconds: Seconds to ignore failing load balancer health checks on newly instantiated tasks to prevent premature shutdown, up to 2147483647. Only valid for services configured to use load balancers.
        :param pulumi.Input[_builtins.str] iam_role: ARN of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required if you are using a load balancer with your service, but only if your task definition does not use the `awsvpc` network mode. If using `awsvpc` network mode, do not specify this role. If your account has already created the Amazon ECS service-linked role, that role is used by default for your service unless you specify a role here.
        :param pulumi.Input[_builtins.str] launch_type: Launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`. Conflicts with `capacity_provider_strategy`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLoadBalancerArgs', 'ServiceLoadBalancerArgsDict']]]] load_balancers: Configuration block for load balancers. See below.
        :param pulumi.Input[_builtins.str] name: Name of the service (up to 255 letters, numbers, hyphens, and underscores)
               
               The following arguments are optional:
        :param pulumi.Input[Union['ServiceNetworkConfigurationArgs', 'ServiceNetworkConfigurationArgsDict']] network_configuration: Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceOrderedPlacementStrategyArgs', 'ServiceOrderedPlacementStrategyArgsDict']]]] ordered_placement_strategies: Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicePlacementConstraintArgs', 'ServicePlacementConstraintArgsDict']]]] placement_constraints: Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
        :param pulumi.Input[_builtins.str] platform_version: Platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        :param pulumi.Input[_builtins.str] propagate_tags: Whether to propagate the tags from the task definition or the service to the tasks. The valid values are `SERVICE` and `TASK_DEFINITION`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] scheduling_strategy: Scheduling strategy to use for the service. The valid values are `REPLICA` and `DAEMON`. Defaults to `REPLICA`. Note that [*Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy*](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html).
        :param pulumi.Input[Union['ServiceServiceConnectConfigurationArgs', 'ServiceServiceConnectConfigurationArgsDict']] service_connect_configuration: ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
        :param pulumi.Input[Union['ServiceServiceRegistriesArgs', 'ServiceServiceRegistriesArgsDict']] service_registries: Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
        :param pulumi.Input[_builtins.bool] sigint_rollback: Whether to enable graceful termination of deployments using SIGINT signals. When enabled, allows customers to safely cancel an in-progress deployment and automatically trigger a rollback to the previous stable state. Defaults to `false`. Only applicable when using `ECS` deployment controller and requires `wait_for_steady_state = true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] task_definition: Family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service. Required unless using the `EXTERNAL` deployment controller. If a revision is not specified, the latest `ACTIVE` revision is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] triggers: Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `"plantimestamp()"`. When using the triggers property you also need to set the forceNewDeployment property to True.
        :param pulumi.Input[Union['ServiceVolumeConfigurationArgs', 'ServiceVolumeConfigurationArgsDict']] volume_configuration: Configuration for a volume specified in the task definition as a volume that is configured at launch time. Currently, the only supported volume type is an Amazon EBS volume. See below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceVpcLatticeConfigurationArgs', 'ServiceVpcLatticeConfigurationArgsDict']]]] vpc_lattice_configurations: The VPC Lattice configuration for your service that allows Lattice to connect, secure, and monitor your service across multiple accounts and VPCs. See below.
        :param pulumi.Input[_builtins.bool] wait_for_steady_state: If `true`, this provider will wait for the service to reach a steady state (like [`aws ecs wait services-stable`](https://docs.aws.amazon.com/cli/latest/reference/ecs/wait/services-stable.html)) before continuing. Default `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["alarms"] = alarms
        __props__.__dict__["arn"] = arn
        __props__.__dict__["availability_zone_rebalancing"] = availability_zone_rebalancing
        __props__.__dict__["capacity_provider_strategies"] = capacity_provider_strategies
        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["deployment_circuit_breaker"] = deployment_circuit_breaker
        __props__.__dict__["deployment_configuration"] = deployment_configuration
        __props__.__dict__["deployment_controller"] = deployment_controller
        __props__.__dict__["deployment_maximum_percent"] = deployment_maximum_percent
        __props__.__dict__["deployment_minimum_healthy_percent"] = deployment_minimum_healthy_percent
        __props__.__dict__["desired_count"] = desired_count
        __props__.__dict__["enable_ecs_managed_tags"] = enable_ecs_managed_tags
        __props__.__dict__["enable_execute_command"] = enable_execute_command
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["force_new_deployment"] = force_new_deployment
        __props__.__dict__["health_check_grace_period_seconds"] = health_check_grace_period_seconds
        __props__.__dict__["iam_role"] = iam_role
        __props__.__dict__["launch_type"] = launch_type
        __props__.__dict__["load_balancers"] = load_balancers
        __props__.__dict__["name"] = name
        __props__.__dict__["network_configuration"] = network_configuration
        __props__.__dict__["ordered_placement_strategies"] = ordered_placement_strategies
        __props__.__dict__["placement_constraints"] = placement_constraints
        __props__.__dict__["platform_version"] = platform_version
        __props__.__dict__["propagate_tags"] = propagate_tags
        __props__.__dict__["region"] = region
        __props__.__dict__["scheduling_strategy"] = scheduling_strategy
        __props__.__dict__["service_connect_configuration"] = service_connect_configuration
        __props__.__dict__["service_registries"] = service_registries
        __props__.__dict__["sigint_rollback"] = sigint_rollback
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["task_definition"] = task_definition
        __props__.__dict__["triggers"] = triggers
        __props__.__dict__["volume_configuration"] = volume_configuration
        __props__.__dict__["vpc_lattice_configurations"] = vpc_lattice_configurations
        __props__.__dict__["wait_for_steady_state"] = wait_for_steady_state
        return Service(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def alarms(self) -> pulumi.Output[Optional['outputs.ServiceAlarms']]:
        """
        Information about the CloudWatch alarms. See below.
        """
        return pulumi.get(self, "alarms")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN that identifies the service.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneRebalancing")
    def availability_zone_rebalancing(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ECS automatically redistributes tasks within a service across Availability Zones (AZs) to mitigate the risk of impaired application availability due to underlying infrastructure failures and task lifecycle activities. The valid values are `ENABLED` and `DISABLED`. Defaults to `DISABLED`.
        """
        return pulumi.get(self, "availability_zone_rebalancing")

    @_builtins.property
    @pulumi.getter(name="capacityProviderStrategies")
    def capacity_provider_strategies(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceCapacityProviderStrategy']]]:
        """
        Capacity provider strategies to use for the service. Can be one or more. These can be updated without destroying and recreating the service only if `force_new_deployment = true` and not changing from 0 `capacity_provider_strategy` blocks to greater than 0, or vice versa. See below. Conflicts with `launch_type`.
        """
        return pulumi.get(self, "capacity_provider_strategies")

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of an ECS cluster.
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter(name="deploymentCircuitBreaker")
    def deployment_circuit_breaker(self) -> pulumi.Output[Optional['outputs.ServiceDeploymentCircuitBreaker']]:
        """
        Configuration block for deployment circuit breaker. See below.
        """
        return pulumi.get(self, "deployment_circuit_breaker")

    @_builtins.property
    @pulumi.getter(name="deploymentConfiguration")
    def deployment_configuration(self) -> pulumi.Output['outputs.ServiceDeploymentConfiguration']:
        """
        Configuration block for deployment settings. See below.
        """
        return pulumi.get(self, "deployment_configuration")

    @_builtins.property
    @pulumi.getter(name="deploymentController")
    def deployment_controller(self) -> pulumi.Output[Optional['outputs.ServiceDeploymentController']]:
        """
        Configuration block for deployment controller configuration. See below.
        """
        return pulumi.get(self, "deployment_controller")

    @_builtins.property
    @pulumi.getter(name="deploymentMaximumPercent")
    def deployment_maximum_percent(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Upper limit (as a percentage of the service's desiredCount) of the number of running tasks that can be running in a service during a deployment. Not valid when using the `DAEMON` scheduling strategy.
        """
        return pulumi.get(self, "deployment_maximum_percent")

    @_builtins.property
    @pulumi.getter(name="deploymentMinimumHealthyPercent")
    def deployment_minimum_healthy_percent(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Lower limit (as a percentage of the service's desiredCount) of the number of running tasks that must remain running and healthy in a service during a deployment.
        """
        return pulumi.get(self, "deployment_minimum_healthy_percent")

    @_builtins.property
    @pulumi.getter(name="desiredCount")
    def desired_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of instances of the task definition to place and keep running. Defaults to 0. Do not specify if using the `DAEMON` scheduling strategy.
        """
        return pulumi.get(self, "desired_count")

    @_builtins.property
    @pulumi.getter(name="enableEcsManagedTags")
    def enable_ecs_managed_tags(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable Amazon ECS managed tags for the tasks within the service.
        """
        return pulumi.get(self, "enable_ecs_managed_tags")

    @_builtins.property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable Amazon ECS Exec for the tasks within the service.
        """
        return pulumi.get(self, "enable_execute_command")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable to delete a service even if it wasn't scaled down to zero tasks. It's only necessary to use this if the service uses the `REPLICA` scheduling strategy.
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="forceNewDeployment")
    def force_new_deployment(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable to force a new task deployment of the service. This can be used to update tasks to use a newer Docker image with same image/tag combination (e.g., `myimage:latest`), roll Fargate tasks onto a newer platform version, or immediately deploy `ordered_placement_strategy` and `placement_constraints` updates.
        When using the forceNewDeployment property you also need to configure the triggers property.
        """
        return pulumi.get(self, "force_new_deployment")

    @_builtins.property
    @pulumi.getter(name="healthCheckGracePeriodSeconds")
    def health_check_grace_period_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Seconds to ignore failing load balancer health checks on newly instantiated tasks to prevent premature shutdown, up to 2147483647. Only valid for services configured to use load balancers.
        """
        return pulumi.get(self, "health_check_grace_period_seconds")

    @_builtins.property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required if you are using a load balancer with your service, but only if your task definition does not use the `awsvpc` network mode. If using `awsvpc` network mode, do not specify this role. If your account has already created the Amazon ECS service-linked role, that role is used by default for your service unless you specify a role here.
        """
        return pulumi.get(self, "iam_role")

    @_builtins.property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> pulumi.Output[_builtins.str]:
        """
        Launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`. Conflicts with `capacity_provider_strategy`.
        """
        return pulumi.get(self, "launch_type")

    @_builtins.property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLoadBalancer']]]:
        """
        Configuration block for load balancers. See below.
        """
        return pulumi.get(self, "load_balancers")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the service (up to 255 letters, numbers, hyphens, and underscores)

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output[Optional['outputs.ServiceNetworkConfiguration']]:
        """
        Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
        """
        return pulumi.get(self, "network_configuration")

    @_builtins.property
    @pulumi.getter(name="orderedPlacementStrategies")
    def ordered_placement_strategies(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceOrderedPlacementStrategy']]]:
        """
        Service level strategy rules that are taken into consideration during task placement. List from top to bottom in order of precedence. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. The maximum number of `ordered_placement_strategy` blocks is `5`. See below.
        """
        return pulumi.get(self, "ordered_placement_strategies")

    @_builtins.property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> pulumi.Output[Optional[Sequence['outputs.ServicePlacementConstraint']]]:
        """
        Rules that are taken into consideration during task placement. Updates to this configuration will take effect next task deployment unless `force_new_deployment` is enabled. Maximum number of `placement_constraints` is `10`. See below.
        """
        return pulumi.get(self, "placement_constraints")

    @_builtins.property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> pulumi.Output[_builtins.str]:
        """
        Platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        """
        return pulumi.get(self, "platform_version")

    @_builtins.property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to propagate the tags from the task definition or the service to the tasks. The valid values are `SERVICE` and `TASK_DEFINITION`.
        """
        return pulumi.get(self, "propagate_tags")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="schedulingStrategy")
    def scheduling_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Scheduling strategy to use for the service. The valid values are `REPLICA` and `DAEMON`. Defaults to `REPLICA`. Note that [*Tasks using the Fargate launch type or the `CODE_DEPLOY` or `EXTERNAL` deployment controller types don't support the `DAEMON` scheduling strategy*](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html).
        """
        return pulumi.get(self, "scheduling_strategy")

    @_builtins.property
    @pulumi.getter(name="serviceConnectConfiguration")
    def service_connect_configuration(self) -> pulumi.Output[Optional['outputs.ServiceServiceConnectConfiguration']]:
        """
        ECS Service Connect configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. See below.
        """
        return pulumi.get(self, "service_connect_configuration")

    @_builtins.property
    @pulumi.getter(name="serviceRegistries")
    def service_registries(self) -> pulumi.Output[Optional['outputs.ServiceServiceRegistries']]:
        """
        Service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. See below.
        """
        return pulumi.get(self, "service_registries")

    @_builtins.property
    @pulumi.getter(name="sigintRollback")
    def sigint_rollback(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable graceful termination of deployments using SIGINT signals. When enabled, allows customers to safely cancel an in-progress deployment and automatically trigger a rollback to the previous stable state. Defaults to `false`. Only applicable when using `ECS` deployment controller and requires `wait_for_steady_state = true`.
        """
        return pulumi.get(self, "sigint_rollback")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="taskDefinition")
    def task_definition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service. Required unless using the `EXTERNAL` deployment controller. If a revision is not specified, the latest `ACTIVE` revision is used.
        """
        return pulumi.get(self, "task_definition")

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of arbitrary keys and values that, when changed, will trigger an in-place update (redeployment). Useful with `"plantimestamp()"`. When using the triggers property you also need to set the forceNewDeployment property to True.
        """
        return pulumi.get(self, "triggers")

    @_builtins.property
    @pulumi.getter(name="volumeConfiguration")
    def volume_configuration(self) -> pulumi.Output[Optional['outputs.ServiceVolumeConfiguration']]:
        """
        Configuration for a volume specified in the task definition as a volume that is configured at launch time. Currently, the only supported volume type is an Amazon EBS volume. See below.
        """
        return pulumi.get(self, "volume_configuration")

    @_builtins.property
    @pulumi.getter(name="vpcLatticeConfigurations")
    def vpc_lattice_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceVpcLatticeConfiguration']]]:
        """
        The VPC Lattice configuration for your service that allows Lattice to connect, secure, and monitor your service across multiple accounts and VPCs. See below.
        """
        return pulumi.get(self, "vpc_lattice_configurations")

    @_builtins.property
    @pulumi.getter(name="waitForSteadyState")
    def wait_for_steady_state(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If `true`, this provider will wait for the service to reach a steady state (like [`aws ecs wait services-stable`](https://docs.aws.amazon.com/cli/latest/reference/ecs/wait/services-stable.html)) before continuing. Default `false`.
        """
        return pulumi.get(self, "wait_for_steady_state")

