# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccessEntryArgs', 'AccessEntry']

@pulumi.input_type
class AccessEntryArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[_builtins.str],
                 principal_arn: pulumi.Input[_builtins.str],
                 kubernetes_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccessEntry resource.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the EKS Cluster.
        :param pulumi.Input[_builtins.str] principal_arn: The IAM Principal ARN which requires Authentication access to the EKS cluster.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] kubernetes_groups: List of string which can optionally specify the Kubernetes groups the user would belong to when creating an access entry.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] type: Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or groups, and prevent associations.
        :param pulumi.Input[_builtins.str] user_name: Defaults to principal ARN if user is principal else defaults to assume-role/session-name is role is used.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "principal_arn", principal_arn)
        if kubernetes_groups is not None:
            pulumi.set(__self__, "kubernetes_groups", kubernetes_groups)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the EKS Cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The IAM Principal ARN which requires Authentication access to the EKS cluster.

        The following arguments are optional:
        """
        return pulumi.get(self, "principal_arn")

    @principal_arn.setter
    def principal_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_arn", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesGroups")
    def kubernetes_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of string which can optionally specify the Kubernetes groups the user would belong to when creating an access entry.
        """
        return pulumi.get(self, "kubernetes_groups")

    @kubernetes_groups.setter
    def kubernetes_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kubernetes_groups", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or groups, and prevent associations.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defaults to principal ARN if user is principal else defaults to assume-role/session-name is role is used.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class _AccessEntryState:
    def __init__(__self__, *,
                 access_entry_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 modified_at: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccessEntry resources.
        :param pulumi.Input[_builtins.str] access_entry_arn: Amazon Resource Name (ARN) of the Access Entry.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the EKS Cluster.
        :param pulumi.Input[_builtins.str] created_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] kubernetes_groups: List of string which can optionally specify the Kubernetes groups the user would belong to when creating an access entry.
        :param pulumi.Input[_builtins.str] modified_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
        :param pulumi.Input[_builtins.str] principal_arn: The IAM Principal ARN which requires Authentication access to the EKS cluster.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: (Optional) Key-value map of resource tags, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] type: Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or groups, and prevent associations.
        :param pulumi.Input[_builtins.str] user_name: Defaults to principal ARN if user is principal else defaults to assume-role/session-name is role is used.
        """
        if access_entry_arn is not None:
            pulumi.set(__self__, "access_entry_arn", access_entry_arn)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if kubernetes_groups is not None:
            pulumi.set(__self__, "kubernetes_groups", kubernetes_groups)
        if modified_at is not None:
            pulumi.set(__self__, "modified_at", modified_at)
        if principal_arn is not None:
            pulumi.set(__self__, "principal_arn", principal_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="accessEntryArn")
    def access_entry_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the Access Entry.
        """
        return pulumi.get(self, "access_entry_arn")

    @access_entry_arn.setter
    def access_entry_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_entry_arn", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the EKS Cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesGroups")
    def kubernetes_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of string which can optionally specify the Kubernetes groups the user would belong to when creating an access entry.
        """
        return pulumi.get(self, "kubernetes_groups")

    @kubernetes_groups.setter
    def kubernetes_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kubernetes_groups", value)

    @_builtins.property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
        """
        return pulumi.get(self, "modified_at")

    @modified_at.setter
    def modified_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_at", value)

    @_builtins.property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IAM Principal ARN which requires Authentication access to the EKS cluster.

        The following arguments are optional:
        """
        return pulumi.get(self, "principal_arn")

    @principal_arn.setter
    def principal_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Optional) Key-value map of resource tags, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or groups, and prevent associations.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defaults to principal ARN if user is principal else defaults to assume-role/session-name is role is used.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.type_token("aws:eks/accessEntry:AccessEntry")
class AccessEntry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Access Entry Configurations for an EKS Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.AccessEntry("example",
            cluster_name=example_aws_eks_cluster["name"],
            principal_arn=example_aws_iam_role["arn"],
            kubernetes_groups=[
                "group-1",
                "group-2",
            ],
            type="STANDARD")
        ```

        ## Import

        Using `pulumi import`, import EKS access entry using the `cluster_name` and `principal_arn` separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:eks/accessEntry:AccessEntry my_eks_access_entry my_cluster_name:my_principal_arn
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the EKS Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] kubernetes_groups: List of string which can optionally specify the Kubernetes groups the user would belong to when creating an access entry.
        :param pulumi.Input[_builtins.str] principal_arn: The IAM Principal ARN which requires Authentication access to the EKS cluster.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] type: Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or groups, and prevent associations.
        :param pulumi.Input[_builtins.str] user_name: Defaults to principal ARN if user is principal else defaults to assume-role/session-name is role is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessEntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Access Entry Configurations for an EKS Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.AccessEntry("example",
            cluster_name=example_aws_eks_cluster["name"],
            principal_arn=example_aws_iam_role["arn"],
            kubernetes_groups=[
                "group-1",
                "group-2",
            ],
            type="STANDARD")
        ```

        ## Import

        Using `pulumi import`, import EKS access entry using the `cluster_name` and `principal_arn` separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:eks/accessEntry:AccessEntry my_eks_access_entry my_cluster_name:my_principal_arn
        ```

        :param str resource_name: The name of the resource.
        :param AccessEntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessEntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessEntryArgs.__new__(AccessEntryArgs)

            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["kubernetes_groups"] = kubernetes_groups
            if principal_arn is None and not opts.urn:
                raise TypeError("Missing required property 'principal_arn'")
            __props__.__dict__["principal_arn"] = principal_arn
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["access_entry_arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["modified_at"] = None
            __props__.__dict__["tags_all"] = None
        super(AccessEntry, __self__).__init__(
            'aws:eks/accessEntry:AccessEntry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_entry_arn: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            kubernetes_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            modified_at: Optional[pulumi.Input[_builtins.str]] = None,
            principal_arn: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccessEntry':
        """
        Get an existing AccessEntry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_entry_arn: Amazon Resource Name (ARN) of the Access Entry.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the EKS Cluster.
        :param pulumi.Input[_builtins.str] created_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] kubernetes_groups: List of string which can optionally specify the Kubernetes groups the user would belong to when creating an access entry.
        :param pulumi.Input[_builtins.str] modified_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
        :param pulumi.Input[_builtins.str] principal_arn: The IAM Principal ARN which requires Authentication access to the EKS cluster.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: (Optional) Key-value map of resource tags, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] type: Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or groups, and prevent associations.
        :param pulumi.Input[_builtins.str] user_name: Defaults to principal ARN if user is principal else defaults to assume-role/session-name is role is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessEntryState.__new__(_AccessEntryState)

        __props__.__dict__["access_entry_arn"] = access_entry_arn
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["kubernetes_groups"] = kubernetes_groups
        __props__.__dict__["modified_at"] = modified_at
        __props__.__dict__["principal_arn"] = principal_arn
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["type"] = type
        __props__.__dict__["user_name"] = user_name
        return AccessEntry(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessEntryArn")
    def access_entry_arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the Access Entry.
        """
        return pulumi.get(self, "access_entry_arn")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the EKS Cluster.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="kubernetesGroups")
    def kubernetes_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of string which can optionally specify the Kubernetes groups the user would belong to when creating an access entry.
        """
        return pulumi.get(self, "kubernetes_groups")

    @_builtins.property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
        """
        return pulumi.get(self, "modified_at")

    @_builtins.property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The IAM Principal ARN which requires Authentication access to the EKS cluster.

        The following arguments are optional:
        """
        return pulumi.get(self, "principal_arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Optional) Key-value map of resource tags, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or groups, and prevent associations.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[_builtins.str]:
        """
        Defaults to principal ARN if user is principal else defaults to assume-role/session-name is role is used.
        """
        return pulumi.get(self, "user_name")

