# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AddonArgs', 'Addon']

@pulumi.input_type
class AddonArgs:
    def __init__(__self__, *,
                 addon_name: pulumi.Input[_builtins.str],
                 cluster_name: pulumi.Input[_builtins.str],
                 addon_version: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_values: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_identity_associations: Optional[pulumi.Input[Sequence[pulumi.Input['AddonPodIdentityAssociationArgs']]]] = None,
                 preserve: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resolve_conflicts_on_create: Optional[pulumi.Input[_builtins.str]] = None,
                 resolve_conflicts_on_update: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Addon resource.
        :param pulumi.Input[_builtins.str] addon_name: Name of the EKS add-on. The name must match one of
               the names returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[_builtins.str] cluster_name: Name of the EKS Cluster.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] addon_version: The version of the EKS add-on. The version must
               match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[_builtins.str] configuration_values: custom configuration values for addons with single JSON string. This JSON string value must match the JSON schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        :param pulumi.Input[Sequence[pulumi.Input['AddonPodIdentityAssociationArgs']]] pod_identity_associations: Configuration block with EKS Pod Identity association settings. See `pod_identity_association` below for details.
        :param pulumi.Input[_builtins.bool] preserve: Indicates if you want to preserve the created resources when deleting the EKS add-on.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resolve_conflicts_on_create: How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Documentation.
        :param pulumi.Input[_builtins.str] resolve_conflicts_on_update: How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Documentation.
        :param pulumi.Input[_builtins.str] service_account_role_arn: The Amazon Resource Name (ARN) of an
               existing IAM role to bind to the add-on's service account. The role must be
               assigned the IAM permissions required by the add-on. If you don't specify
               an existing IAM role, then the add-on uses the permissions assigned to the node
               IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
               in the Amazon EKS User Guide.
               
               > **Note:** To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
               provider created for your cluster. For more information, [see Enabling IAM roles
               for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
               in the Amazon EKS User Guide.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "addon_name", addon_name)
        pulumi.set(__self__, "cluster_name", cluster_name)
        if addon_version is not None:
            pulumi.set(__self__, "addon_version", addon_version)
        if configuration_values is not None:
            pulumi.set(__self__, "configuration_values", configuration_values)
        if pod_identity_associations is not None:
            pulumi.set(__self__, "pod_identity_associations", pod_identity_associations)
        if preserve is not None:
            pulumi.set(__self__, "preserve", preserve)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resolve_conflicts_on_create is not None:
            pulumi.set(__self__, "resolve_conflicts_on_create", resolve_conflicts_on_create)
        if resolve_conflicts_on_update is not None:
            pulumi.set(__self__, "resolve_conflicts_on_update", resolve_conflicts_on_update)
        if service_account_role_arn is not None:
            pulumi.set(__self__, "service_account_role_arn", service_account_role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the EKS add-on. The name must match one of
        the names returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        return pulumi.get(self, "addon_name")

    @addon_name.setter
    def addon_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "addon_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the EKS Cluster.

        The following arguments are optional:
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the EKS add-on. The version must
        match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        return pulumi.get(self, "addon_version")

    @addon_version.setter
    def addon_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "addon_version", value)

    @_builtins.property
    @pulumi.getter(name="configurationValues")
    def configuration_values(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        custom configuration values for addons with single JSON string. This JSON string value must match the JSON schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        """
        return pulumi.get(self, "configuration_values")

    @configuration_values.setter
    def configuration_values(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration_values", value)

    @_builtins.property
    @pulumi.getter(name="podIdentityAssociations")
    def pod_identity_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AddonPodIdentityAssociationArgs']]]]:
        """
        Configuration block with EKS Pod Identity association settings. See `pod_identity_association` below for details.
        """
        return pulumi.get(self, "pod_identity_associations")

    @pod_identity_associations.setter
    def pod_identity_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AddonPodIdentityAssociationArgs']]]]):
        pulumi.set(self, "pod_identity_associations", value)

    @_builtins.property
    @pulumi.getter
    def preserve(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if you want to preserve the created resources when deleting the EKS add-on.
        """
        return pulumi.get(self, "preserve")

    @preserve.setter
    def preserve(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "preserve", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resolveConflictsOnCreate")
    def resolve_conflicts_on_create(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Documentation.
        """
        return pulumi.get(self, "resolve_conflicts_on_create")

    @resolve_conflicts_on_create.setter
    def resolve_conflicts_on_create(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resolve_conflicts_on_create", value)

    @_builtins.property
    @pulumi.getter(name="resolveConflictsOnUpdate")
    def resolve_conflicts_on_update(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Documentation.
        """
        return pulumi.get(self, "resolve_conflicts_on_update")

    @resolve_conflicts_on_update.setter
    def resolve_conflicts_on_update(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resolve_conflicts_on_update", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountRoleArn")
    def service_account_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of an
        existing IAM role to bind to the add-on's service account. The role must be
        assigned the IAM permissions required by the add-on. If you don't specify
        an existing IAM role, then the add-on uses the permissions assigned to the node
        IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
        in the Amazon EKS User Guide.

        > **Note:** To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
        provider created for your cluster. For more information, [see Enabling IAM roles
        for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
        in the Amazon EKS User Guide.
        """
        return pulumi.get(self, "service_account_role_arn")

    @service_account_role_arn.setter
    def service_account_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AddonState:
    def __init__(__self__, *,
                 addon_name: Optional[pulumi.Input[_builtins.str]] = None,
                 addon_version: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_values: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_at: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_identity_associations: Optional[pulumi.Input[Sequence[pulumi.Input['AddonPodIdentityAssociationArgs']]]] = None,
                 preserve: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resolve_conflicts_on_create: Optional[pulumi.Input[_builtins.str]] = None,
                 resolve_conflicts_on_update: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Addon resources.
        :param pulumi.Input[_builtins.str] addon_name: Name of the EKS add-on. The name must match one of
               the names returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[_builtins.str] addon_version: The version of the EKS add-on. The version must
               match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the EKS add-on.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the EKS Cluster.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] configuration_values: custom configuration values for addons with single JSON string. This JSON string value must match the JSON schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        :param pulumi.Input[_builtins.str] created_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
        :param pulumi.Input[_builtins.str] modified_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
        :param pulumi.Input[Sequence[pulumi.Input['AddonPodIdentityAssociationArgs']]] pod_identity_associations: Configuration block with EKS Pod Identity association settings. See `pod_identity_association` below for details.
        :param pulumi.Input[_builtins.bool] preserve: Indicates if you want to preserve the created resources when deleting the EKS add-on.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resolve_conflicts_on_create: How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Documentation.
        :param pulumi.Input[_builtins.str] resolve_conflicts_on_update: How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Documentation.
        :param pulumi.Input[_builtins.str] service_account_role_arn: The Amazon Resource Name (ARN) of an
               existing IAM role to bind to the add-on's service account. The role must be
               assigned the IAM permissions required by the add-on. If you don't specify
               an existing IAM role, then the add-on uses the permissions assigned to the node
               IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
               in the Amazon EKS User Guide.
               
               > **Note:** To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
               provider created for your cluster. For more information, [see Enabling IAM roles
               for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
               in the Amazon EKS User Guide.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: (Optional) Key-value map of resource tags, including those inherited from the provider `default_tags` configuration block.
        """
        if addon_name is not None:
            pulumi.set(__self__, "addon_name", addon_name)
        if addon_version is not None:
            pulumi.set(__self__, "addon_version", addon_version)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if configuration_values is not None:
            pulumi.set(__self__, "configuration_values", configuration_values)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if modified_at is not None:
            pulumi.set(__self__, "modified_at", modified_at)
        if pod_identity_associations is not None:
            pulumi.set(__self__, "pod_identity_associations", pod_identity_associations)
        if preserve is not None:
            pulumi.set(__self__, "preserve", preserve)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resolve_conflicts_on_create is not None:
            pulumi.set(__self__, "resolve_conflicts_on_create", resolve_conflicts_on_create)
        if resolve_conflicts_on_update is not None:
            pulumi.set(__self__, "resolve_conflicts_on_update", resolve_conflicts_on_update)
        if service_account_role_arn is not None:
            pulumi.set(__self__, "service_account_role_arn", service_account_role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the EKS add-on. The name must match one of
        the names returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        return pulumi.get(self, "addon_name")

    @addon_name.setter
    def addon_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "addon_name", value)

    @_builtins.property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the EKS add-on. The version must
        match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        return pulumi.get(self, "addon_version")

    @addon_version.setter
    def addon_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "addon_version", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the EKS add-on.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the EKS Cluster.

        The following arguments are optional:
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="configurationValues")
    def configuration_values(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        custom configuration values for addons with single JSON string. This JSON string value must match the JSON schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        """
        return pulumi.get(self, "configuration_values")

    @configuration_values.setter
    def configuration_values(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration_values", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
        """
        return pulumi.get(self, "modified_at")

    @modified_at.setter
    def modified_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_at", value)

    @_builtins.property
    @pulumi.getter(name="podIdentityAssociations")
    def pod_identity_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AddonPodIdentityAssociationArgs']]]]:
        """
        Configuration block with EKS Pod Identity association settings. See `pod_identity_association` below for details.
        """
        return pulumi.get(self, "pod_identity_associations")

    @pod_identity_associations.setter
    def pod_identity_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AddonPodIdentityAssociationArgs']]]]):
        pulumi.set(self, "pod_identity_associations", value)

    @_builtins.property
    @pulumi.getter
    def preserve(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if you want to preserve the created resources when deleting the EKS add-on.
        """
        return pulumi.get(self, "preserve")

    @preserve.setter
    def preserve(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "preserve", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resolveConflictsOnCreate")
    def resolve_conflicts_on_create(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Documentation.
        """
        return pulumi.get(self, "resolve_conflicts_on_create")

    @resolve_conflicts_on_create.setter
    def resolve_conflicts_on_create(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resolve_conflicts_on_create", value)

    @_builtins.property
    @pulumi.getter(name="resolveConflictsOnUpdate")
    def resolve_conflicts_on_update(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Documentation.
        """
        return pulumi.get(self, "resolve_conflicts_on_update")

    @resolve_conflicts_on_update.setter
    def resolve_conflicts_on_update(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resolve_conflicts_on_update", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountRoleArn")
    def service_account_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of an
        existing IAM role to bind to the add-on's service account. The role must be
        assigned the IAM permissions required by the add-on. If you don't specify
        an existing IAM role, then the add-on uses the permissions assigned to the node
        IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
        in the Amazon EKS User Guide.

        > **Note:** To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
        provider created for your cluster. For more information, [see Enabling IAM roles
        for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
        in the Amazon EKS User Guide.
        """
        return pulumi.get(self, "service_account_role_arn")

    @service_account_role_arn.setter
    def service_account_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Optional) Key-value map of resource tags, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:eks/addon:Addon")
class Addon(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_name: Optional[pulumi.Input[_builtins.str]] = None,
                 addon_version: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_values: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_identity_associations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddonPodIdentityAssociationArgs', 'AddonPodIdentityAssociationArgsDict']]]]] = None,
                 preserve: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resolve_conflicts_on_create: Optional[pulumi.Input[_builtins.str]] = None,
                 resolve_conflicts_on_update: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an EKS add-on.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.Addon("example",
            cluster_name=example_aws_eks_cluster["name"],
            addon_name="vpc-cni")
        ```

        ## Example Update add-on usage with resolve_conflicts_on_update and PRESERVE

        `resolve_conflicts_on_update` with `PRESERVE` can be used to retain the config changes applied to the add-on with kubectl while upgrading to a newer version of the add-on.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.Addon("example",
            cluster_name=example_aws_eks_cluster["name"],
            addon_name="coredns",
            addon_version="v1.10.1-eksbuild.1",
            resolve_conflicts_on_update="PRESERVE")
        ```

        ## Example add-on usage with custom configuration_values

        Custom add-on configuration can be passed using `configuration_values` as a single JSON string while creating or updating the add-on.

        > **Note:** `configuration_values` is a single JSON string should match the valid JSON schema for each add-on with specific version.

        To find the correct JSON schema for each add-on can be extracted using [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html) call.
        This below is an example for extracting the `configuration_values` schema for `coredns`.

        Example to create a `coredns` managed addon with custom `configuration_values`.

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.eks.Addon("example",
            cluster_name="mycluster",
            addon_name="coredns",
            addon_version="v1.10.1-eksbuild.1",
            resolve_conflicts_on_create="OVERWRITE",
            configuration_values=json.dumps({
                "replicaCount": 4,
                "resources": {
                    "limits": {
                        "cpu": "100m",
                        "memory": "150Mi",
                    },
                    "requests": {
                        "cpu": "100m",
                        "memory": "150Mi",
                    },
                },
            }))
        ```

        ## Import

        Using `pulumi import`, import EKS add-on using the `cluster_name` and `addon_name` separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:eks/addon:Addon my_eks_addon my_cluster_name:my_addon_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] addon_name: Name of the EKS add-on. The name must match one of
               the names returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[_builtins.str] addon_version: The version of the EKS add-on. The version must
               match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[_builtins.str] cluster_name: Name of the EKS Cluster.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] configuration_values: custom configuration values for addons with single JSON string. This JSON string value must match the JSON schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        :param pulumi.Input[Sequence[pulumi.Input[Union['AddonPodIdentityAssociationArgs', 'AddonPodIdentityAssociationArgsDict']]]] pod_identity_associations: Configuration block with EKS Pod Identity association settings. See `pod_identity_association` below for details.
        :param pulumi.Input[_builtins.bool] preserve: Indicates if you want to preserve the created resources when deleting the EKS add-on.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resolve_conflicts_on_create: How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Documentation.
        :param pulumi.Input[_builtins.str] resolve_conflicts_on_update: How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Documentation.
        :param pulumi.Input[_builtins.str] service_account_role_arn: The Amazon Resource Name (ARN) of an
               existing IAM role to bind to the add-on's service account. The role must be
               assigned the IAM permissions required by the add-on. If you don't specify
               an existing IAM role, then the add-on uses the permissions assigned to the node
               IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
               in the Amazon EKS User Guide.
               
               > **Note:** To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
               provider created for your cluster. For more information, [see Enabling IAM roles
               for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
               in the Amazon EKS User Guide.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AddonArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an EKS add-on.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.Addon("example",
            cluster_name=example_aws_eks_cluster["name"],
            addon_name="vpc-cni")
        ```

        ## Example Update add-on usage with resolve_conflicts_on_update and PRESERVE

        `resolve_conflicts_on_update` with `PRESERVE` can be used to retain the config changes applied to the add-on with kubectl while upgrading to a newer version of the add-on.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.Addon("example",
            cluster_name=example_aws_eks_cluster["name"],
            addon_name="coredns",
            addon_version="v1.10.1-eksbuild.1",
            resolve_conflicts_on_update="PRESERVE")
        ```

        ## Example add-on usage with custom configuration_values

        Custom add-on configuration can be passed using `configuration_values` as a single JSON string while creating or updating the add-on.

        > **Note:** `configuration_values` is a single JSON string should match the valid JSON schema for each add-on with specific version.

        To find the correct JSON schema for each add-on can be extracted using [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html) call.
        This below is an example for extracting the `configuration_values` schema for `coredns`.

        Example to create a `coredns` managed addon with custom `configuration_values`.

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.eks.Addon("example",
            cluster_name="mycluster",
            addon_name="coredns",
            addon_version="v1.10.1-eksbuild.1",
            resolve_conflicts_on_create="OVERWRITE",
            configuration_values=json.dumps({
                "replicaCount": 4,
                "resources": {
                    "limits": {
                        "cpu": "100m",
                        "memory": "150Mi",
                    },
                    "requests": {
                        "cpu": "100m",
                        "memory": "150Mi",
                    },
                },
            }))
        ```

        ## Import

        Using `pulumi import`, import EKS add-on using the `cluster_name` and `addon_name` separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:eks/addon:Addon my_eks_addon my_cluster_name:my_addon_name
        ```

        :param str resource_name: The name of the resource.
        :param AddonArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddonArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_name: Optional[pulumi.Input[_builtins.str]] = None,
                 addon_version: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_values: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_identity_associations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddonPodIdentityAssociationArgs', 'AddonPodIdentityAssociationArgsDict']]]]] = None,
                 preserve: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resolve_conflicts_on_create: Optional[pulumi.Input[_builtins.str]] = None,
                 resolve_conflicts_on_update: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddonArgs.__new__(AddonArgs)

            if addon_name is None and not opts.urn:
                raise TypeError("Missing required property 'addon_name'")
            __props__.__dict__["addon_name"] = addon_name
            __props__.__dict__["addon_version"] = addon_version
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["configuration_values"] = configuration_values
            __props__.__dict__["pod_identity_associations"] = pod_identity_associations
            __props__.__dict__["preserve"] = preserve
            __props__.__dict__["region"] = region
            __props__.__dict__["resolve_conflicts_on_create"] = resolve_conflicts_on_create
            __props__.__dict__["resolve_conflicts_on_update"] = resolve_conflicts_on_update
            __props__.__dict__["service_account_role_arn"] = service_account_role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["modified_at"] = None
            __props__.__dict__["tags_all"] = None
        super(Addon, __self__).__init__(
            'aws:eks/addon:Addon',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addon_name: Optional[pulumi.Input[_builtins.str]] = None,
            addon_version: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            configuration_values: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            modified_at: Optional[pulumi.Input[_builtins.str]] = None,
            pod_identity_associations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddonPodIdentityAssociationArgs', 'AddonPodIdentityAssociationArgsDict']]]]] = None,
            preserve: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resolve_conflicts_on_create: Optional[pulumi.Input[_builtins.str]] = None,
            resolve_conflicts_on_update: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Addon':
        """
        Get an existing Addon resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] addon_name: Name of the EKS add-on. The name must match one of
               the names returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[_builtins.str] addon_version: The version of the EKS add-on. The version must
               match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the EKS add-on.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the EKS Cluster.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] configuration_values: custom configuration values for addons with single JSON string. This JSON string value must match the JSON schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        :param pulumi.Input[_builtins.str] created_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
        :param pulumi.Input[_builtins.str] modified_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AddonPodIdentityAssociationArgs', 'AddonPodIdentityAssociationArgsDict']]]] pod_identity_associations: Configuration block with EKS Pod Identity association settings. See `pod_identity_association` below for details.
        :param pulumi.Input[_builtins.bool] preserve: Indicates if you want to preserve the created resources when deleting the EKS add-on.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resolve_conflicts_on_create: How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Documentation.
        :param pulumi.Input[_builtins.str] resolve_conflicts_on_update: How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Documentation.
        :param pulumi.Input[_builtins.str] service_account_role_arn: The Amazon Resource Name (ARN) of an
               existing IAM role to bind to the add-on's service account. The role must be
               assigned the IAM permissions required by the add-on. If you don't specify
               an existing IAM role, then the add-on uses the permissions assigned to the node
               IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
               in the Amazon EKS User Guide.
               
               > **Note:** To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
               provider created for your cluster. For more information, [see Enabling IAM roles
               for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
               in the Amazon EKS User Guide.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: (Optional) Key-value map of resource tags, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddonState.__new__(_AddonState)

        __props__.__dict__["addon_name"] = addon_name
        __props__.__dict__["addon_version"] = addon_version
        __props__.__dict__["arn"] = arn
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["configuration_values"] = configuration_values
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["modified_at"] = modified_at
        __props__.__dict__["pod_identity_associations"] = pod_identity_associations
        __props__.__dict__["preserve"] = preserve
        __props__.__dict__["region"] = region
        __props__.__dict__["resolve_conflicts_on_create"] = resolve_conflicts_on_create
        __props__.__dict__["resolve_conflicts_on_update"] = resolve_conflicts_on_update
        __props__.__dict__["service_account_role_arn"] = service_account_role_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Addon(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the EKS add-on. The name must match one of
        the names returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        return pulumi.get(self, "addon_name")

    @_builtins.property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the EKS add-on. The version must
        match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        return pulumi.get(self, "addon_version")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the EKS add-on.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the EKS Cluster.

        The following arguments are optional:
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="configurationValues")
    def configuration_values(self) -> pulumi.Output[_builtins.str]:
        """
        custom configuration values for addons with single JSON string. This JSON string value must match the JSON schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        """
        return pulumi.get(self, "configuration_values")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
        """
        return pulumi.get(self, "modified_at")

    @_builtins.property
    @pulumi.getter(name="podIdentityAssociations")
    def pod_identity_associations(self) -> pulumi.Output[Optional[Sequence['outputs.AddonPodIdentityAssociation']]]:
        """
        Configuration block with EKS Pod Identity association settings. See `pod_identity_association` below for details.
        """
        return pulumi.get(self, "pod_identity_associations")

    @_builtins.property
    @pulumi.getter
    def preserve(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if you want to preserve the created resources when deleting the EKS add-on.
        """
        return pulumi.get(self, "preserve")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resolveConflictsOnCreate")
    def resolve_conflicts_on_create(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Documentation.
        """
        return pulumi.get(self, "resolve_conflicts_on_create")

    @_builtins.property
    @pulumi.getter(name="resolveConflictsOnUpdate")
    def resolve_conflicts_on_update(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Documentation.
        """
        return pulumi.get(self, "resolve_conflicts_on_update")

    @_builtins.property
    @pulumi.getter(name="serviceAccountRoleArn")
    def service_account_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of an
        existing IAM role to bind to the add-on's service account. The role must be
        assigned the IAM permissions required by the add-on. If you don't specify
        an existing IAM role, then the add-on uses the permissions assigned to the node
        IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
        in the Amazon EKS User Guide.

        > **Note:** To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
        provider created for your cluster. For more information, [see Enabling IAM roles
        for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
        in the Amazon EKS User Guide.
        """
        return pulumi.get(self, "service_account_role_arn")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Optional) Key-value map of resource tags, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

