# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[_builtins.str],
                 vpc_config: pulumi.Input['ClusterVpcConfigArgs'],
                 access_config: Optional[pulumi.Input['ClusterAccessConfigArgs']] = None,
                 bootstrap_self_managed_addons: Optional[pulumi.Input[_builtins.bool]] = None,
                 compute_config: Optional[pulumi.Input['ClusterComputeConfigArgs']] = None,
                 default_addons_to_removes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_cluster_log_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 encryption_config: Optional[pulumi.Input['ClusterEncryptionConfigArgs']] = None,
                 force_update_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 kubernetes_network_config: Optional[pulumi.Input['ClusterKubernetesNetworkConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 outpost_config: Optional[pulumi.Input['ClusterOutpostConfigArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_network_config: Optional[pulumi.Input['ClusterRemoteNetworkConfigArgs']] = None,
                 storage_config: Optional[pulumi.Input['ClusterStorageConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_policy: Optional[pulumi.Input['ClusterUpgradePolicyArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 zonal_shift_config: Optional[pulumi.Input['ClusterZonalShiftConfigArgs']] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf. Ensure the resource configuration includes explicit dependencies on the IAM Role permissions by adding `depends_on` if using the `iam.RolePolicy` resource or `iam.RolePolicyAttachment` resource, otherwise EKS cannot delete EKS managed EC2 infrastructure such as Security Groups on EKS Cluster deletion.
        :param pulumi.Input['ClusterVpcConfigArgs'] vpc_config: Configuration block for the VPC associated with your cluster. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) and [Cluster Security Group Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the Amazon EKS User Guide. Detailed below. Also contains attributes detailed in the Attributes section.
               
               The following arguments are optional:
        :param pulumi.Input['ClusterAccessConfigArgs'] access_config: Configuration block for the access config associated with your cluster, see [Amazon EKS Access Entries](https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html). Detailed below.
        :param pulumi.Input[_builtins.bool] bootstrap_self_managed_addons: Install default unmanaged add-ons, such as `aws-cni`, `kube-proxy`, and CoreDNS during cluster creation. If `false`, you must manually install desired add-ons. Changing this value will force a new cluster to be created. Defaults to `true`.
        :param pulumi.Input['ClusterComputeConfigArgs'] compute_config: Configuration block with compute configuration for EKS Auto Mode. Detailed below.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether to enable deletion protection for the cluster. When enabled, the cluster cannot be deleted unless deletion protection is first disabled. Default: `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_cluster_log_types: List of the desired control plane logging to enable. For more information, see [Amazon EKS Control Plane Logging](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html).
        :param pulumi.Input['ClusterEncryptionConfigArgs'] encryption_config: Configuration block with encryption configuration for the cluster. Detailed below.
        :param pulumi.Input[_builtins.bool] force_update_version: Force version update by overriding upgrade-blocking readiness checks when updating a cluster.
        :param pulumi.Input['ClusterKubernetesNetworkConfigArgs'] kubernetes_network_config: Configuration block with kubernetes network configuration for the cluster. Detailed below. If removed, the provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[_builtins.str] name: Name of the cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\\-_]*$`).
        :param pulumi.Input['ClusterOutpostConfigArgs'] outpost_config: Configuration block representing the configuration of your local Amazon EKS cluster on an AWS Outpost. This block isn't available for creating Amazon EKS clusters on the AWS cloud.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ClusterRemoteNetworkConfigArgs'] remote_network_config: Configuration block with remote network configuration for EKS Hybrid Nodes. Detailed below.
        :param pulumi.Input['ClusterStorageConfigArgs'] storage_config: Configuration block with storage configuration for EKS Auto Mode. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['ClusterUpgradePolicyArgs'] upgrade_policy: Configuration block for the support policy to use for the cluster.  See upgrade_policy for details.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes master version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except those automatically triggered by EKS. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by EKS.
        :param pulumi.Input['ClusterZonalShiftConfigArgs'] zonal_shift_config: Configuration block with zonal shift configuration for the cluster. Detailed below.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "vpc_config", vpc_config)
        if access_config is not None:
            pulumi.set(__self__, "access_config", access_config)
        if bootstrap_self_managed_addons is not None:
            pulumi.set(__self__, "bootstrap_self_managed_addons", bootstrap_self_managed_addons)
        if compute_config is not None:
            pulumi.set(__self__, "compute_config", compute_config)
        if default_addons_to_removes is not None:
            warnings.warn("""Configure bootstrap_self_managed_addons instead. This attribute will be removed in the next major version of the provider""", DeprecationWarning)
            pulumi.log.warn("""default_addons_to_removes is deprecated: Configure bootstrap_self_managed_addons instead. This attribute will be removed in the next major version of the provider""")
        if default_addons_to_removes is not None:
            pulumi.set(__self__, "default_addons_to_removes", default_addons_to_removes)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enabled_cluster_log_types is not None:
            pulumi.set(__self__, "enabled_cluster_log_types", enabled_cluster_log_types)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if force_update_version is not None:
            pulumi.set(__self__, "force_update_version", force_update_version)
        if kubernetes_network_config is not None:
            pulumi.set(__self__, "kubernetes_network_config", kubernetes_network_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outpost_config is not None:
            pulumi.set(__self__, "outpost_config", outpost_config)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remote_network_config is not None:
            pulumi.set(__self__, "remote_network_config", remote_network_config)
        if storage_config is not None:
            pulumi.set(__self__, "storage_config", storage_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if upgrade_policy is not None:
            pulumi.set(__self__, "upgrade_policy", upgrade_policy)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if zonal_shift_config is not None:
            pulumi.set(__self__, "zonal_shift_config", zonal_shift_config)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf. Ensure the resource configuration includes explicit dependencies on the IAM Role permissions by adding `depends_on` if using the `iam.RolePolicy` resource or `iam.RolePolicyAttachment` resource, otherwise EKS cannot delete EKS managed EC2 infrastructure such as Security Groups on EKS Cluster deletion.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Input['ClusterVpcConfigArgs']:
        """
        Configuration block for the VPC associated with your cluster. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) and [Cluster Security Group Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the Amazon EKS User Guide. Detailed below. Also contains attributes detailed in the Attributes section.

        The following arguments are optional:
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: pulumi.Input['ClusterVpcConfigArgs']):
        pulumi.set(self, "vpc_config", value)

    @_builtins.property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> Optional[pulumi.Input['ClusterAccessConfigArgs']]:
        """
        Configuration block for the access config associated with your cluster, see [Amazon EKS Access Entries](https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html). Detailed below.
        """
        return pulumi.get(self, "access_config")

    @access_config.setter
    def access_config(self, value: Optional[pulumi.Input['ClusterAccessConfigArgs']]):
        pulumi.set(self, "access_config", value)

    @_builtins.property
    @pulumi.getter(name="bootstrapSelfManagedAddons")
    def bootstrap_self_managed_addons(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Install default unmanaged add-ons, such as `aws-cni`, `kube-proxy`, and CoreDNS during cluster creation. If `false`, you must manually install desired add-ons. Changing this value will force a new cluster to be created. Defaults to `true`.
        """
        return pulumi.get(self, "bootstrap_self_managed_addons")

    @bootstrap_self_managed_addons.setter
    def bootstrap_self_managed_addons(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bootstrap_self_managed_addons", value)

    @_builtins.property
    @pulumi.getter(name="computeConfig")
    def compute_config(self) -> Optional[pulumi.Input['ClusterComputeConfigArgs']]:
        """
        Configuration block with compute configuration for EKS Auto Mode. Detailed below.
        """
        return pulumi.get(self, "compute_config")

    @compute_config.setter
    def compute_config(self, value: Optional[pulumi.Input['ClusterComputeConfigArgs']]):
        pulumi.set(self, "compute_config", value)

    @_builtins.property
    @pulumi.getter(name="defaultAddonsToRemoves")
    @_utilities.deprecated("""Configure bootstrap_self_managed_addons instead. This attribute will be removed in the next major version of the provider""")
    def default_addons_to_removes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "default_addons_to_removes")

    @default_addons_to_removes.setter
    def default_addons_to_removes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "default_addons_to_removes", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable deletion protection for the cluster. When enabled, the cluster cannot be deleted unless deletion protection is first disabled. Default: `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="enabledClusterLogTypes")
    def enabled_cluster_log_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the desired control plane logging to enable. For more information, see [Amazon EKS Control Plane Logging](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html).
        """
        return pulumi.get(self, "enabled_cluster_log_types")

    @enabled_cluster_log_types.setter
    def enabled_cluster_log_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_cluster_log_types", value)

    @_builtins.property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['ClusterEncryptionConfigArgs']]:
        """
        Configuration block with encryption configuration for the cluster. Detailed below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['ClusterEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @_builtins.property
    @pulumi.getter(name="forceUpdateVersion")
    def force_update_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Force version update by overriding upgrade-blocking readiness checks when updating a cluster.
        """
        return pulumi.get(self, "force_update_version")

    @force_update_version.setter
    def force_update_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_update_version", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesNetworkConfig")
    def kubernetes_network_config(self) -> Optional[pulumi.Input['ClusterKubernetesNetworkConfigArgs']]:
        """
        Configuration block with kubernetes network configuration for the cluster. Detailed below. If removed, the provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "kubernetes_network_config")

    @kubernetes_network_config.setter
    def kubernetes_network_config(self, value: Optional[pulumi.Input['ClusterKubernetesNetworkConfigArgs']]):
        pulumi.set(self, "kubernetes_network_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\\-_]*$`).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outpostConfig")
    def outpost_config(self) -> Optional[pulumi.Input['ClusterOutpostConfigArgs']]:
        """
        Configuration block representing the configuration of your local Amazon EKS cluster on an AWS Outpost. This block isn't available for creating Amazon EKS clusters on the AWS cloud.
        """
        return pulumi.get(self, "outpost_config")

    @outpost_config.setter
    def outpost_config(self, value: Optional[pulumi.Input['ClusterOutpostConfigArgs']]):
        pulumi.set(self, "outpost_config", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="remoteNetworkConfig")
    def remote_network_config(self) -> Optional[pulumi.Input['ClusterRemoteNetworkConfigArgs']]:
        """
        Configuration block with remote network configuration for EKS Hybrid Nodes. Detailed below.
        """
        return pulumi.get(self, "remote_network_config")

    @remote_network_config.setter
    def remote_network_config(self, value: Optional[pulumi.Input['ClusterRemoteNetworkConfigArgs']]):
        pulumi.set(self, "remote_network_config", value)

    @_builtins.property
    @pulumi.getter(name="storageConfig")
    def storage_config(self) -> Optional[pulumi.Input['ClusterStorageConfigArgs']]:
        """
        Configuration block with storage configuration for EKS Auto Mode. Detailed below.
        """
        return pulumi.get(self, "storage_config")

    @storage_config.setter
    def storage_config(self, value: Optional[pulumi.Input['ClusterStorageConfigArgs']]):
        pulumi.set(self, "storage_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> Optional[pulumi.Input['ClusterUpgradePolicyArgs']]:
        """
        Configuration block for the support policy to use for the cluster.  See upgrade_policy for details.
        """
        return pulumi.get(self, "upgrade_policy")

    @upgrade_policy.setter
    def upgrade_policy(self, value: Optional[pulumi.Input['ClusterUpgradePolicyArgs']]):
        pulumi.set(self, "upgrade_policy", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired Kubernetes master version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except those automatically triggered by EKS. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by EKS.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="zonalShiftConfig")
    def zonal_shift_config(self) -> Optional[pulumi.Input['ClusterZonalShiftConfigArgs']]:
        """
        Configuration block with zonal shift configuration for the cluster. Detailed below.
        """
        return pulumi.get(self, "zonal_shift_config")

    @zonal_shift_config.setter
    def zonal_shift_config(self, value: Optional[pulumi.Input['ClusterZonalShiftConfigArgs']]):
        pulumi.set(self, "zonal_shift_config", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 access_config: Optional[pulumi.Input['ClusterAccessConfigArgs']] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 bootstrap_self_managed_addons: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate_authority: Optional[pulumi.Input['ClusterCertificateAuthorityArgs']] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_config: Optional[pulumi.Input['ClusterComputeConfigArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 default_addons_to_removes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_cluster_log_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 encryption_config: Optional[pulumi.Input['ClusterEncryptionConfigArgs']] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 force_update_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterIdentityArgs']]]] = None,
                 kubernetes_network_config: Optional[pulumi.Input['ClusterKubernetesNetworkConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 outpost_config: Optional[pulumi.Input['ClusterOutpostConfigArgs']] = None,
                 platform_version: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_network_config: Optional[pulumi.Input['ClusterRemoteNetworkConfigArgs']] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_config: Optional[pulumi.Input['ClusterStorageConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_policy: Optional[pulumi.Input['ClusterUpgradePolicyArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_config: Optional[pulumi.Input['ClusterVpcConfigArgs']] = None,
                 zonal_shift_config: Optional[pulumi.Input['ClusterZonalShiftConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input['ClusterAccessConfigArgs'] access_config: Configuration block for the access config associated with your cluster, see [Amazon EKS Access Entries](https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html). Detailed below.
        :param pulumi.Input[_builtins.str] arn: ARN of the cluster.
        :param pulumi.Input[_builtins.bool] bootstrap_self_managed_addons: Install default unmanaged add-ons, such as `aws-cni`, `kube-proxy`, and CoreDNS during cluster creation. If `false`, you must manually install desired add-ons. Changing this value will force a new cluster to be created. Defaults to `true`.
        :param pulumi.Input['ClusterCertificateAuthorityArgs'] certificate_authority: Attribute block containing `certificate-authority-data` for your cluster. Detailed below.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of your local Amazon EKS cluster on the AWS Outpost. This attribute isn't available for an AWS EKS cluster on AWS cloud.
        :param pulumi.Input['ClusterComputeConfigArgs'] compute_config: Configuration block with compute configuration for EKS Auto Mode. Detailed below.
        :param pulumi.Input[_builtins.str] created_at: Unix epoch timestamp in seconds for when the cluster was created.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether to enable deletion protection for the cluster. When enabled, the cluster cannot be deleted unless deletion protection is first disabled. Default: `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_cluster_log_types: List of the desired control plane logging to enable. For more information, see [Amazon EKS Control Plane Logging](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html).
        :param pulumi.Input['ClusterEncryptionConfigArgs'] encryption_config: Configuration block with encryption configuration for the cluster. Detailed below.
        :param pulumi.Input[_builtins.str] endpoint: Endpoint for your Kubernetes API server.
        :param pulumi.Input[_builtins.bool] force_update_version: Force version update by overriding upgrade-blocking readiness checks when updating a cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterIdentityArgs']]] identities: Attribute block containing identity provider information for your cluster. Only available on Kubernetes version 1.13 and 1.14 clusters created or upgraded on or after September 3, 2019. Detailed below.
        :param pulumi.Input['ClusterKubernetesNetworkConfigArgs'] kubernetes_network_config: Configuration block with kubernetes network configuration for the cluster. Detailed below. If removed, the provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[_builtins.str] name: Name of the cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\\-_]*$`).
        :param pulumi.Input['ClusterOutpostConfigArgs'] outpost_config: Configuration block representing the configuration of your local Amazon EKS cluster on an AWS Outpost. This block isn't available for creating Amazon EKS clusters on the AWS cloud.
        :param pulumi.Input[_builtins.str] platform_version: Platform version for the cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ClusterRemoteNetworkConfigArgs'] remote_network_config: Configuration block with remote network configuration for EKS Hybrid Nodes. Detailed below.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf. Ensure the resource configuration includes explicit dependencies on the IAM Role permissions by adding `depends_on` if using the `iam.RolePolicy` resource or `iam.RolePolicyAttachment` resource, otherwise EKS cannot delete EKS managed EC2 infrastructure such as Security Groups on EKS Cluster deletion.
        :param pulumi.Input[_builtins.str] status: Status of the EKS cluster. One of `CREATING`, `ACTIVE`, `DELETING`, `FAILED`.
        :param pulumi.Input['ClusterStorageConfigArgs'] storage_config: Configuration block with storage configuration for EKS Auto Mode. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['ClusterUpgradePolicyArgs'] upgrade_policy: Configuration block for the support policy to use for the cluster.  See upgrade_policy for details.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes master version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except those automatically triggered by EKS. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by EKS.
        :param pulumi.Input['ClusterVpcConfigArgs'] vpc_config: Configuration block for the VPC associated with your cluster. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) and [Cluster Security Group Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the Amazon EKS User Guide. Detailed below. Also contains attributes detailed in the Attributes section.
               
               The following arguments are optional:
        :param pulumi.Input['ClusterZonalShiftConfigArgs'] zonal_shift_config: Configuration block with zonal shift configuration for the cluster. Detailed below.
        """
        if access_config is not None:
            pulumi.set(__self__, "access_config", access_config)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if bootstrap_self_managed_addons is not None:
            pulumi.set(__self__, "bootstrap_self_managed_addons", bootstrap_self_managed_addons)
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if compute_config is not None:
            pulumi.set(__self__, "compute_config", compute_config)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if default_addons_to_removes is not None:
            warnings.warn("""Configure bootstrap_self_managed_addons instead. This attribute will be removed in the next major version of the provider""", DeprecationWarning)
            pulumi.log.warn("""default_addons_to_removes is deprecated: Configure bootstrap_self_managed_addons instead. This attribute will be removed in the next major version of the provider""")
        if default_addons_to_removes is not None:
            pulumi.set(__self__, "default_addons_to_removes", default_addons_to_removes)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enabled_cluster_log_types is not None:
            pulumi.set(__self__, "enabled_cluster_log_types", enabled_cluster_log_types)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if force_update_version is not None:
            pulumi.set(__self__, "force_update_version", force_update_version)
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if kubernetes_network_config is not None:
            pulumi.set(__self__, "kubernetes_network_config", kubernetes_network_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outpost_config is not None:
            pulumi.set(__self__, "outpost_config", outpost_config)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remote_network_config is not None:
            pulumi.set(__self__, "remote_network_config", remote_network_config)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_config is not None:
            pulumi.set(__self__, "storage_config", storage_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if upgrade_policy is not None:
            pulumi.set(__self__, "upgrade_policy", upgrade_policy)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)
        if zonal_shift_config is not None:
            pulumi.set(__self__, "zonal_shift_config", zonal_shift_config)

    @_builtins.property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> Optional[pulumi.Input['ClusterAccessConfigArgs']]:
        """
        Configuration block for the access config associated with your cluster, see [Amazon EKS Access Entries](https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html). Detailed below.
        """
        return pulumi.get(self, "access_config")

    @access_config.setter
    def access_config(self, value: Optional[pulumi.Input['ClusterAccessConfigArgs']]):
        pulumi.set(self, "access_config", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the cluster.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="bootstrapSelfManagedAddons")
    def bootstrap_self_managed_addons(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Install default unmanaged add-ons, such as `aws-cni`, `kube-proxy`, and CoreDNS during cluster creation. If `false`, you must manually install desired add-ons. Changing this value will force a new cluster to be created. Defaults to `true`.
        """
        return pulumi.get(self, "bootstrap_self_managed_addons")

    @bootstrap_self_managed_addons.setter
    def bootstrap_self_managed_addons(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bootstrap_self_managed_addons", value)

    @_builtins.property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> Optional[pulumi.Input['ClusterCertificateAuthorityArgs']]:
        """
        Attribute block containing `certificate-authority-data` for your cluster. Detailed below.
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: Optional[pulumi.Input['ClusterCertificateAuthorityArgs']]):
        pulumi.set(self, "certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of your local Amazon EKS cluster on the AWS Outpost. This attribute isn't available for an AWS EKS cluster on AWS cloud.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="computeConfig")
    def compute_config(self) -> Optional[pulumi.Input['ClusterComputeConfigArgs']]:
        """
        Configuration block with compute configuration for EKS Auto Mode. Detailed below.
        """
        return pulumi.get(self, "compute_config")

    @compute_config.setter
    def compute_config(self, value: Optional[pulumi.Input['ClusterComputeConfigArgs']]):
        pulumi.set(self, "compute_config", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unix epoch timestamp in seconds for when the cluster was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="defaultAddonsToRemoves")
    @_utilities.deprecated("""Configure bootstrap_self_managed_addons instead. This attribute will be removed in the next major version of the provider""")
    def default_addons_to_removes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "default_addons_to_removes")

    @default_addons_to_removes.setter
    def default_addons_to_removes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "default_addons_to_removes", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable deletion protection for the cluster. When enabled, the cluster cannot be deleted unless deletion protection is first disabled. Default: `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="enabledClusterLogTypes")
    def enabled_cluster_log_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the desired control plane logging to enable. For more information, see [Amazon EKS Control Plane Logging](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html).
        """
        return pulumi.get(self, "enabled_cluster_log_types")

    @enabled_cluster_log_types.setter
    def enabled_cluster_log_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_cluster_log_types", value)

    @_builtins.property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['ClusterEncryptionConfigArgs']]:
        """
        Configuration block with encryption configuration for the cluster. Detailed below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['ClusterEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Endpoint for your Kubernetes API server.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="forceUpdateVersion")
    def force_update_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Force version update by overriding upgrade-blocking readiness checks when updating a cluster.
        """
        return pulumi.get(self, "force_update_version")

    @force_update_version.setter
    def force_update_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_update_version", value)

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterIdentityArgs']]]]:
        """
        Attribute block containing identity provider information for your cluster. Only available on Kubernetes version 1.13 and 1.14 clusters created or upgraded on or after September 3, 2019. Detailed below.
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterIdentityArgs']]]]):
        pulumi.set(self, "identities", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesNetworkConfig")
    def kubernetes_network_config(self) -> Optional[pulumi.Input['ClusterKubernetesNetworkConfigArgs']]:
        """
        Configuration block with kubernetes network configuration for the cluster. Detailed below. If removed, the provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "kubernetes_network_config")

    @kubernetes_network_config.setter
    def kubernetes_network_config(self, value: Optional[pulumi.Input['ClusterKubernetesNetworkConfigArgs']]):
        pulumi.set(self, "kubernetes_network_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\\-_]*$`).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outpostConfig")
    def outpost_config(self) -> Optional[pulumi.Input['ClusterOutpostConfigArgs']]:
        """
        Configuration block representing the configuration of your local Amazon EKS cluster on an AWS Outpost. This block isn't available for creating Amazon EKS clusters on the AWS cloud.
        """
        return pulumi.get(self, "outpost_config")

    @outpost_config.setter
    def outpost_config(self, value: Optional[pulumi.Input['ClusterOutpostConfigArgs']]):
        pulumi.set(self, "outpost_config", value)

    @_builtins.property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Platform version for the cluster.
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform_version", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="remoteNetworkConfig")
    def remote_network_config(self) -> Optional[pulumi.Input['ClusterRemoteNetworkConfigArgs']]:
        """
        Configuration block with remote network configuration for EKS Hybrid Nodes. Detailed below.
        """
        return pulumi.get(self, "remote_network_config")

    @remote_network_config.setter
    def remote_network_config(self, value: Optional[pulumi.Input['ClusterRemoteNetworkConfigArgs']]):
        pulumi.set(self, "remote_network_config", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf. Ensure the resource configuration includes explicit dependencies on the IAM Role permissions by adding `depends_on` if using the `iam.RolePolicy` resource or `iam.RolePolicyAttachment` resource, otherwise EKS cannot delete EKS managed EC2 infrastructure such as Security Groups on EKS Cluster deletion.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the EKS cluster. One of `CREATING`, `ACTIVE`, `DELETING`, `FAILED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageConfig")
    def storage_config(self) -> Optional[pulumi.Input['ClusterStorageConfigArgs']]:
        """
        Configuration block with storage configuration for EKS Auto Mode. Detailed below.
        """
        return pulumi.get(self, "storage_config")

    @storage_config.setter
    def storage_config(self, value: Optional[pulumi.Input['ClusterStorageConfigArgs']]):
        pulumi.set(self, "storage_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> Optional[pulumi.Input['ClusterUpgradePolicyArgs']]:
        """
        Configuration block for the support policy to use for the cluster.  See upgrade_policy for details.
        """
        return pulumi.get(self, "upgrade_policy")

    @upgrade_policy.setter
    def upgrade_policy(self, value: Optional[pulumi.Input['ClusterUpgradePolicyArgs']]):
        pulumi.set(self, "upgrade_policy", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired Kubernetes master version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except those automatically triggered by EKS. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by EKS.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['ClusterVpcConfigArgs']]:
        """
        Configuration block for the VPC associated with your cluster. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) and [Cluster Security Group Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the Amazon EKS User Guide. Detailed below. Also contains attributes detailed in the Attributes section.

        The following arguments are optional:
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['ClusterVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)

    @_builtins.property
    @pulumi.getter(name="zonalShiftConfig")
    def zonal_shift_config(self) -> Optional[pulumi.Input['ClusterZonalShiftConfigArgs']]:
        """
        Configuration block with zonal shift configuration for the cluster. Detailed below.
        """
        return pulumi.get(self, "zonal_shift_config")

    @zonal_shift_config.setter
    def zonal_shift_config(self, value: Optional[pulumi.Input['ClusterZonalShiftConfigArgs']]):
        pulumi.set(self, "zonal_shift_config", value)


@pulumi.type_token("aws:eks/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_config: Optional[pulumi.Input[Union['ClusterAccessConfigArgs', 'ClusterAccessConfigArgsDict']]] = None,
                 bootstrap_self_managed_addons: Optional[pulumi.Input[_builtins.bool]] = None,
                 compute_config: Optional[pulumi.Input[Union['ClusterComputeConfigArgs', 'ClusterComputeConfigArgsDict']]] = None,
                 default_addons_to_removes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_cluster_log_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 encryption_config: Optional[pulumi.Input[Union['ClusterEncryptionConfigArgs', 'ClusterEncryptionConfigArgsDict']]] = None,
                 force_update_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 kubernetes_network_config: Optional[pulumi.Input[Union['ClusterKubernetesNetworkConfigArgs', 'ClusterKubernetesNetworkConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 outpost_config: Optional[pulumi.Input[Union['ClusterOutpostConfigArgs', 'ClusterOutpostConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_network_config: Optional[pulumi.Input[Union['ClusterRemoteNetworkConfigArgs', 'ClusterRemoteNetworkConfigArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_config: Optional[pulumi.Input[Union['ClusterStorageConfigArgs', 'ClusterStorageConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_policy: Optional[pulumi.Input[Union['ClusterUpgradePolicyArgs', 'ClusterUpgradePolicyArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_config: Optional[pulumi.Input[Union['ClusterVpcConfigArgs', 'ClusterVpcConfigArgsDict']]] = None,
                 zonal_shift_config: Optional[pulumi.Input[Union['ClusterZonalShiftConfigArgs', 'ClusterZonalShiftConfigArgsDict']]] = None,
                 __props__=None):
        """
        Manages an EKS Cluster.

        ## Example Usage

        ### EKS Cluster

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        cluster = aws.iam.Role("cluster",
            name="eks-cluster-example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": [
                        "sts:AssumeRole",
                        "sts:TagSession",
                    ],
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "eks.amazonaws.com",
                    },
                }],
            }))
        cluster_amazon_eks_cluster_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSClusterPolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSClusterPolicy",
            role=cluster.name)
        example = aws.eks.Cluster("example",
            name="example",
            access_config={
                "authentication_mode": "API",
            },
            role_arn=cluster.arn,
            version="1.31",
            vpc_config={
                "subnet_ids": [
                    az1["id"],
                    az2["id"],
                    az3["id"],
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[cluster_amazon_eks_cluster_policy]))
        ```

        ### EKS Cluster with EKS Auto Mode

        > **NOTE:** When using EKS Auto Mode `compute_config.enabled`, `kubernetes_network_config.elastic_load_balancing.enabled`, and `storage_config.block_storage.enabled` must *ALL be set to `true`. Likewise for disabling EKS Auto Mode, all three arguments must be set to `false`. Enabling EKS Auto Mode also requires that `bootstrap_self_managed_addons` is set to `false`.

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        node = aws.iam.Role("node",
            name="eks-auto-node-example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": ["sts:AssumeRole"],
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "ec2.amazonaws.com",
                    },
                }],
            }))
        cluster = aws.iam.Role("cluster",
            name="eks-cluster-example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": [
                        "sts:AssumeRole",
                        "sts:TagSession",
                    ],
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "eks.amazonaws.com",
                    },
                }],
            }))
        cluster_amazon_eks_cluster_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSClusterPolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSClusterPolicy",
            role=cluster.name)
        cluster_amazon_eks_compute_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSComputePolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSComputePolicy",
            role=cluster.name)
        cluster_amazon_eks_block_storage_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSBlockStoragePolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSBlockStoragePolicy",
            role=cluster.name)
        cluster_amazon_eks_load_balancing_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSLoadBalancingPolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSLoadBalancingPolicy",
            role=cluster.name)
        cluster_amazon_eks_networking_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSNetworkingPolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSNetworkingPolicy",
            role=cluster.name)
        example = aws.eks.Cluster("example",
            name="example",
            access_config={
                "authentication_mode": "API",
            },
            role_arn=cluster.arn,
            version="1.31",
            bootstrap_self_managed_addons=False,
            compute_config={
                "enabled": True,
                "node_pools": ["general-purpose"],
                "node_role_arn": node.arn,
            },
            kubernetes_network_config={
                "elastic_load_balancing": {
                    "enabled": True,
                },
            },
            storage_config={
                "block_storage": {
                    "enabled": True,
                },
            },
            vpc_config={
                "endpoint_private_access": True,
                "endpoint_public_access": True,
                "subnet_ids": [
                    az1["id"],
                    az2["id"],
                    az3["id"],
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    cluster_amazon_eks_cluster_policy,
                    cluster_amazon_eks_compute_policy,
                    cluster_amazon_eks_block_storage_policy,
                    cluster_amazon_eks_load_balancing_policy,
                    cluster_amazon_eks_networking_policy,
                ]))
        node_amazon_eks_worker_node_minimal_policy = aws.iam.RolePolicyAttachment("node_AmazonEKSWorkerNodeMinimalPolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSWorkerNodeMinimalPolicy",
            role=node.name)
        node_amazon_ec2_container_registry_pull_only = aws.iam.RolePolicyAttachment("node_AmazonEC2ContainerRegistryPullOnly",
            policy_arn="arn:aws:iam::aws:policy/AmazonEC2ContainerRegistryPullOnly",
            role=node.name)
        ```

        ### EKS Cluster with EKS Hybrid Nodes

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        cluster = aws.iam.Role("cluster",
            name="eks-cluster-example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": [
                        "sts:AssumeRole",
                        "sts:TagSession",
                    ],
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "eks.amazonaws.com",
                    },
                }],
            }))
        cluster_amazon_eks_cluster_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSClusterPolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSClusterPolicy",
            role=cluster.name)
        example = aws.eks.Cluster("example",
            name="example",
            access_config={
                "authentication_mode": "API",
            },
            role_arn=cluster.arn,
            version="1.31",
            remote_network_config={
                "remote_node_networks": {
                    "cidrs": ["172.16.0.0/18"],
                },
                "remote_pod_networks": {
                    "cidrs": ["172.16.64.0/18"],
                },
            },
            vpc_config={
                "endpoint_private_access": True,
                "endpoint_public_access": True,
                "subnet_ids": [
                    az1["id"],
                    az2["id"],
                    az3["id"],
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[cluster_amazon_eks_cluster_policy]))
        ```

        ### Local EKS Cluster on AWS Outpost

        [Creating a local Amazon EKS cluster on an AWS Outpost](https://docs.aws.amazon.com/eks/latest/userguide/create-cluster-outpost.html)

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.outposts.get_outpost(name="example")
        cluster = aws.iam.Role("cluster",
            name="eks-cluster-example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": [
                        "sts:AssumeRole",
                        "sts:TagSession",
                    ],
                    "Effect": "Allow",
                    "Principal": {
                        "Service": [
                            "eks.amazonaws.com",
                            "ec2.amazonaws.com",
                        ],
                    },
                }],
            }))
        cluster_amazon_eks_local_outpost_cluster_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSLocalOutpostClusterPolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSLocalOutpostClusterPolicy",
            role=cluster.name)
        example_cluster = aws.eks.Cluster("example",
            name="example",
            access_config={
                "authentication_mode": "CONFIG_MAP",
            },
            role_arn=cluster.arn,
            version="1.31",
            vpc_config={
                "endpoint_private_access": True,
                "endpoint_public_access": False,
                "subnet_ids": [
                    az1["id"],
                    az2["id"],
                    az3["id"],
                ],
            },
            outpost_config={
                "control_plane_instance_type": "m5.large",
                "outpost_arns": [example.arn],
            },
            opts = pulumi.ResourceOptions(depends_on=[cluster_amazon_eks_local_outpost_cluster_policy]))
        ```

        ## Import

        Using `pulumi import`, import EKS Clusters using the `name`. For example:

        ```sh
        $ pulumi import aws:eks/cluster:Cluster my_cluster my_cluster
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ClusterAccessConfigArgs', 'ClusterAccessConfigArgsDict']] access_config: Configuration block for the access config associated with your cluster, see [Amazon EKS Access Entries](https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html). Detailed below.
        :param pulumi.Input[_builtins.bool] bootstrap_self_managed_addons: Install default unmanaged add-ons, such as `aws-cni`, `kube-proxy`, and CoreDNS during cluster creation. If `false`, you must manually install desired add-ons. Changing this value will force a new cluster to be created. Defaults to `true`.
        :param pulumi.Input[Union['ClusterComputeConfigArgs', 'ClusterComputeConfigArgsDict']] compute_config: Configuration block with compute configuration for EKS Auto Mode. Detailed below.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether to enable deletion protection for the cluster. When enabled, the cluster cannot be deleted unless deletion protection is first disabled. Default: `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_cluster_log_types: List of the desired control plane logging to enable. For more information, see [Amazon EKS Control Plane Logging](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html).
        :param pulumi.Input[Union['ClusterEncryptionConfigArgs', 'ClusterEncryptionConfigArgsDict']] encryption_config: Configuration block with encryption configuration for the cluster. Detailed below.
        :param pulumi.Input[_builtins.bool] force_update_version: Force version update by overriding upgrade-blocking readiness checks when updating a cluster.
        :param pulumi.Input[Union['ClusterKubernetesNetworkConfigArgs', 'ClusterKubernetesNetworkConfigArgsDict']] kubernetes_network_config: Configuration block with kubernetes network configuration for the cluster. Detailed below. If removed, the provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[_builtins.str] name: Name of the cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\\-_]*$`).
        :param pulumi.Input[Union['ClusterOutpostConfigArgs', 'ClusterOutpostConfigArgsDict']] outpost_config: Configuration block representing the configuration of your local Amazon EKS cluster on an AWS Outpost. This block isn't available for creating Amazon EKS clusters on the AWS cloud.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ClusterRemoteNetworkConfigArgs', 'ClusterRemoteNetworkConfigArgsDict']] remote_network_config: Configuration block with remote network configuration for EKS Hybrid Nodes. Detailed below.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf. Ensure the resource configuration includes explicit dependencies on the IAM Role permissions by adding `depends_on` if using the `iam.RolePolicy` resource or `iam.RolePolicyAttachment` resource, otherwise EKS cannot delete EKS managed EC2 infrastructure such as Security Groups on EKS Cluster deletion.
        :param pulumi.Input[Union['ClusterStorageConfigArgs', 'ClusterStorageConfigArgsDict']] storage_config: Configuration block with storage configuration for EKS Auto Mode. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['ClusterUpgradePolicyArgs', 'ClusterUpgradePolicyArgsDict']] upgrade_policy: Configuration block for the support policy to use for the cluster.  See upgrade_policy for details.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes master version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except those automatically triggered by EKS. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by EKS.
        :param pulumi.Input[Union['ClusterVpcConfigArgs', 'ClusterVpcConfigArgsDict']] vpc_config: Configuration block for the VPC associated with your cluster. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) and [Cluster Security Group Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the Amazon EKS User Guide. Detailed below. Also contains attributes detailed in the Attributes section.
               
               The following arguments are optional:
        :param pulumi.Input[Union['ClusterZonalShiftConfigArgs', 'ClusterZonalShiftConfigArgsDict']] zonal_shift_config: Configuration block with zonal shift configuration for the cluster. Detailed below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an EKS Cluster.

        ## Example Usage

        ### EKS Cluster

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        cluster = aws.iam.Role("cluster",
            name="eks-cluster-example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": [
                        "sts:AssumeRole",
                        "sts:TagSession",
                    ],
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "eks.amazonaws.com",
                    },
                }],
            }))
        cluster_amazon_eks_cluster_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSClusterPolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSClusterPolicy",
            role=cluster.name)
        example = aws.eks.Cluster("example",
            name="example",
            access_config={
                "authentication_mode": "API",
            },
            role_arn=cluster.arn,
            version="1.31",
            vpc_config={
                "subnet_ids": [
                    az1["id"],
                    az2["id"],
                    az3["id"],
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[cluster_amazon_eks_cluster_policy]))
        ```

        ### EKS Cluster with EKS Auto Mode

        > **NOTE:** When using EKS Auto Mode `compute_config.enabled`, `kubernetes_network_config.elastic_load_balancing.enabled`, and `storage_config.block_storage.enabled` must *ALL be set to `true`. Likewise for disabling EKS Auto Mode, all three arguments must be set to `false`. Enabling EKS Auto Mode also requires that `bootstrap_self_managed_addons` is set to `false`.

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        node = aws.iam.Role("node",
            name="eks-auto-node-example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": ["sts:AssumeRole"],
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "ec2.amazonaws.com",
                    },
                }],
            }))
        cluster = aws.iam.Role("cluster",
            name="eks-cluster-example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": [
                        "sts:AssumeRole",
                        "sts:TagSession",
                    ],
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "eks.amazonaws.com",
                    },
                }],
            }))
        cluster_amazon_eks_cluster_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSClusterPolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSClusterPolicy",
            role=cluster.name)
        cluster_amazon_eks_compute_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSComputePolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSComputePolicy",
            role=cluster.name)
        cluster_amazon_eks_block_storage_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSBlockStoragePolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSBlockStoragePolicy",
            role=cluster.name)
        cluster_amazon_eks_load_balancing_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSLoadBalancingPolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSLoadBalancingPolicy",
            role=cluster.name)
        cluster_amazon_eks_networking_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSNetworkingPolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSNetworkingPolicy",
            role=cluster.name)
        example = aws.eks.Cluster("example",
            name="example",
            access_config={
                "authentication_mode": "API",
            },
            role_arn=cluster.arn,
            version="1.31",
            bootstrap_self_managed_addons=False,
            compute_config={
                "enabled": True,
                "node_pools": ["general-purpose"],
                "node_role_arn": node.arn,
            },
            kubernetes_network_config={
                "elastic_load_balancing": {
                    "enabled": True,
                },
            },
            storage_config={
                "block_storage": {
                    "enabled": True,
                },
            },
            vpc_config={
                "endpoint_private_access": True,
                "endpoint_public_access": True,
                "subnet_ids": [
                    az1["id"],
                    az2["id"],
                    az3["id"],
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    cluster_amazon_eks_cluster_policy,
                    cluster_amazon_eks_compute_policy,
                    cluster_amazon_eks_block_storage_policy,
                    cluster_amazon_eks_load_balancing_policy,
                    cluster_amazon_eks_networking_policy,
                ]))
        node_amazon_eks_worker_node_minimal_policy = aws.iam.RolePolicyAttachment("node_AmazonEKSWorkerNodeMinimalPolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSWorkerNodeMinimalPolicy",
            role=node.name)
        node_amazon_ec2_container_registry_pull_only = aws.iam.RolePolicyAttachment("node_AmazonEC2ContainerRegistryPullOnly",
            policy_arn="arn:aws:iam::aws:policy/AmazonEC2ContainerRegistryPullOnly",
            role=node.name)
        ```

        ### EKS Cluster with EKS Hybrid Nodes

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        cluster = aws.iam.Role("cluster",
            name="eks-cluster-example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": [
                        "sts:AssumeRole",
                        "sts:TagSession",
                    ],
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "eks.amazonaws.com",
                    },
                }],
            }))
        cluster_amazon_eks_cluster_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSClusterPolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSClusterPolicy",
            role=cluster.name)
        example = aws.eks.Cluster("example",
            name="example",
            access_config={
                "authentication_mode": "API",
            },
            role_arn=cluster.arn,
            version="1.31",
            remote_network_config={
                "remote_node_networks": {
                    "cidrs": ["172.16.0.0/18"],
                },
                "remote_pod_networks": {
                    "cidrs": ["172.16.64.0/18"],
                },
            },
            vpc_config={
                "endpoint_private_access": True,
                "endpoint_public_access": True,
                "subnet_ids": [
                    az1["id"],
                    az2["id"],
                    az3["id"],
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[cluster_amazon_eks_cluster_policy]))
        ```

        ### Local EKS Cluster on AWS Outpost

        [Creating a local Amazon EKS cluster on an AWS Outpost](https://docs.aws.amazon.com/eks/latest/userguide/create-cluster-outpost.html)

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.outposts.get_outpost(name="example")
        cluster = aws.iam.Role("cluster",
            name="eks-cluster-example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": [
                        "sts:AssumeRole",
                        "sts:TagSession",
                    ],
                    "Effect": "Allow",
                    "Principal": {
                        "Service": [
                            "eks.amazonaws.com",
                            "ec2.amazonaws.com",
                        ],
                    },
                }],
            }))
        cluster_amazon_eks_local_outpost_cluster_policy = aws.iam.RolePolicyAttachment("cluster_AmazonEKSLocalOutpostClusterPolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSLocalOutpostClusterPolicy",
            role=cluster.name)
        example_cluster = aws.eks.Cluster("example",
            name="example",
            access_config={
                "authentication_mode": "CONFIG_MAP",
            },
            role_arn=cluster.arn,
            version="1.31",
            vpc_config={
                "endpoint_private_access": True,
                "endpoint_public_access": False,
                "subnet_ids": [
                    az1["id"],
                    az2["id"],
                    az3["id"],
                ],
            },
            outpost_config={
                "control_plane_instance_type": "m5.large",
                "outpost_arns": [example.arn],
            },
            opts = pulumi.ResourceOptions(depends_on=[cluster_amazon_eks_local_outpost_cluster_policy]))
        ```

        ## Import

        Using `pulumi import`, import EKS Clusters using the `name`. For example:

        ```sh
        $ pulumi import aws:eks/cluster:Cluster my_cluster my_cluster
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_config: Optional[pulumi.Input[Union['ClusterAccessConfigArgs', 'ClusterAccessConfigArgsDict']]] = None,
                 bootstrap_self_managed_addons: Optional[pulumi.Input[_builtins.bool]] = None,
                 compute_config: Optional[pulumi.Input[Union['ClusterComputeConfigArgs', 'ClusterComputeConfigArgsDict']]] = None,
                 default_addons_to_removes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_cluster_log_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 encryption_config: Optional[pulumi.Input[Union['ClusterEncryptionConfigArgs', 'ClusterEncryptionConfigArgsDict']]] = None,
                 force_update_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 kubernetes_network_config: Optional[pulumi.Input[Union['ClusterKubernetesNetworkConfigArgs', 'ClusterKubernetesNetworkConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 outpost_config: Optional[pulumi.Input[Union['ClusterOutpostConfigArgs', 'ClusterOutpostConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_network_config: Optional[pulumi.Input[Union['ClusterRemoteNetworkConfigArgs', 'ClusterRemoteNetworkConfigArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_config: Optional[pulumi.Input[Union['ClusterStorageConfigArgs', 'ClusterStorageConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_policy: Optional[pulumi.Input[Union['ClusterUpgradePolicyArgs', 'ClusterUpgradePolicyArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_config: Optional[pulumi.Input[Union['ClusterVpcConfigArgs', 'ClusterVpcConfigArgsDict']]] = None,
                 zonal_shift_config: Optional[pulumi.Input[Union['ClusterZonalShiftConfigArgs', 'ClusterZonalShiftConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["access_config"] = access_config
            __props__.__dict__["bootstrap_self_managed_addons"] = bootstrap_self_managed_addons
            __props__.__dict__["compute_config"] = compute_config
            __props__.__dict__["default_addons_to_removes"] = default_addons_to_removes
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["enabled_cluster_log_types"] = enabled_cluster_log_types
            __props__.__dict__["encryption_config"] = encryption_config
            __props__.__dict__["force_update_version"] = force_update_version
            __props__.__dict__["kubernetes_network_config"] = kubernetes_network_config
            __props__.__dict__["name"] = name
            __props__.__dict__["outpost_config"] = outpost_config
            __props__.__dict__["region"] = region
            __props__.__dict__["remote_network_config"] = remote_network_config
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["storage_config"] = storage_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["upgrade_policy"] = upgrade_policy
            __props__.__dict__["version"] = version
            if vpc_config is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_config'")
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["zonal_shift_config"] = zonal_shift_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["certificate_authority"] = None
            __props__.__dict__["cluster_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["identities"] = None
            __props__.__dict__["platform_version"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        super(Cluster, __self__).__init__(
            'aws:eks/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_config: Optional[pulumi.Input[Union['ClusterAccessConfigArgs', 'ClusterAccessConfigArgsDict']]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            bootstrap_self_managed_addons: Optional[pulumi.Input[_builtins.bool]] = None,
            certificate_authority: Optional[pulumi.Input[Union['ClusterCertificateAuthorityArgs', 'ClusterCertificateAuthorityArgsDict']]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            compute_config: Optional[pulumi.Input[Union['ClusterComputeConfigArgs', 'ClusterComputeConfigArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            default_addons_to_removes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            enabled_cluster_log_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            encryption_config: Optional[pulumi.Input[Union['ClusterEncryptionConfigArgs', 'ClusterEncryptionConfigArgsDict']]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            force_update_version: Optional[pulumi.Input[_builtins.bool]] = None,
            identities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterIdentityArgs', 'ClusterIdentityArgsDict']]]]] = None,
            kubernetes_network_config: Optional[pulumi.Input[Union['ClusterKubernetesNetworkConfigArgs', 'ClusterKubernetesNetworkConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            outpost_config: Optional[pulumi.Input[Union['ClusterOutpostConfigArgs', 'ClusterOutpostConfigArgsDict']]] = None,
            platform_version: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            remote_network_config: Optional[pulumi.Input[Union['ClusterRemoteNetworkConfigArgs', 'ClusterRemoteNetworkConfigArgsDict']]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_config: Optional[pulumi.Input[Union['ClusterStorageConfigArgs', 'ClusterStorageConfigArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            upgrade_policy: Optional[pulumi.Input[Union['ClusterUpgradePolicyArgs', 'ClusterUpgradePolicyArgsDict']]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_config: Optional[pulumi.Input[Union['ClusterVpcConfigArgs', 'ClusterVpcConfigArgsDict']]] = None,
            zonal_shift_config: Optional[pulumi.Input[Union['ClusterZonalShiftConfigArgs', 'ClusterZonalShiftConfigArgsDict']]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ClusterAccessConfigArgs', 'ClusterAccessConfigArgsDict']] access_config: Configuration block for the access config associated with your cluster, see [Amazon EKS Access Entries](https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html). Detailed below.
        :param pulumi.Input[_builtins.str] arn: ARN of the cluster.
        :param pulumi.Input[_builtins.bool] bootstrap_self_managed_addons: Install default unmanaged add-ons, such as `aws-cni`, `kube-proxy`, and CoreDNS during cluster creation. If `false`, you must manually install desired add-ons. Changing this value will force a new cluster to be created. Defaults to `true`.
        :param pulumi.Input[Union['ClusterCertificateAuthorityArgs', 'ClusterCertificateAuthorityArgsDict']] certificate_authority: Attribute block containing `certificate-authority-data` for your cluster. Detailed below.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of your local Amazon EKS cluster on the AWS Outpost. This attribute isn't available for an AWS EKS cluster on AWS cloud.
        :param pulumi.Input[Union['ClusterComputeConfigArgs', 'ClusterComputeConfigArgsDict']] compute_config: Configuration block with compute configuration for EKS Auto Mode. Detailed below.
        :param pulumi.Input[_builtins.str] created_at: Unix epoch timestamp in seconds for when the cluster was created.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether to enable deletion protection for the cluster. When enabled, the cluster cannot be deleted unless deletion protection is first disabled. Default: `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_cluster_log_types: List of the desired control plane logging to enable. For more information, see [Amazon EKS Control Plane Logging](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html).
        :param pulumi.Input[Union['ClusterEncryptionConfigArgs', 'ClusterEncryptionConfigArgsDict']] encryption_config: Configuration block with encryption configuration for the cluster. Detailed below.
        :param pulumi.Input[_builtins.str] endpoint: Endpoint for your Kubernetes API server.
        :param pulumi.Input[_builtins.bool] force_update_version: Force version update by overriding upgrade-blocking readiness checks when updating a cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterIdentityArgs', 'ClusterIdentityArgsDict']]]] identities: Attribute block containing identity provider information for your cluster. Only available on Kubernetes version 1.13 and 1.14 clusters created or upgraded on or after September 3, 2019. Detailed below.
        :param pulumi.Input[Union['ClusterKubernetesNetworkConfigArgs', 'ClusterKubernetesNetworkConfigArgsDict']] kubernetes_network_config: Configuration block with kubernetes network configuration for the cluster. Detailed below. If removed, the provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[_builtins.str] name: Name of the cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\\-_]*$`).
        :param pulumi.Input[Union['ClusterOutpostConfigArgs', 'ClusterOutpostConfigArgsDict']] outpost_config: Configuration block representing the configuration of your local Amazon EKS cluster on an AWS Outpost. This block isn't available for creating Amazon EKS clusters on the AWS cloud.
        :param pulumi.Input[_builtins.str] platform_version: Platform version for the cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ClusterRemoteNetworkConfigArgs', 'ClusterRemoteNetworkConfigArgsDict']] remote_network_config: Configuration block with remote network configuration for EKS Hybrid Nodes. Detailed below.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf. Ensure the resource configuration includes explicit dependencies on the IAM Role permissions by adding `depends_on` if using the `iam.RolePolicy` resource or `iam.RolePolicyAttachment` resource, otherwise EKS cannot delete EKS managed EC2 infrastructure such as Security Groups on EKS Cluster deletion.
        :param pulumi.Input[_builtins.str] status: Status of the EKS cluster. One of `CREATING`, `ACTIVE`, `DELETING`, `FAILED`.
        :param pulumi.Input[Union['ClusterStorageConfigArgs', 'ClusterStorageConfigArgsDict']] storage_config: Configuration block with storage configuration for EKS Auto Mode. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['ClusterUpgradePolicyArgs', 'ClusterUpgradePolicyArgsDict']] upgrade_policy: Configuration block for the support policy to use for the cluster.  See upgrade_policy for details.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes master version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except those automatically triggered by EKS. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by EKS.
        :param pulumi.Input[Union['ClusterVpcConfigArgs', 'ClusterVpcConfigArgsDict']] vpc_config: Configuration block for the VPC associated with your cluster. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) and [Cluster Security Group Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the Amazon EKS User Guide. Detailed below. Also contains attributes detailed in the Attributes section.
               
               The following arguments are optional:
        :param pulumi.Input[Union['ClusterZonalShiftConfigArgs', 'ClusterZonalShiftConfigArgsDict']] zonal_shift_config: Configuration block with zonal shift configuration for the cluster. Detailed below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["access_config"] = access_config
        __props__.__dict__["arn"] = arn
        __props__.__dict__["bootstrap_self_managed_addons"] = bootstrap_self_managed_addons
        __props__.__dict__["certificate_authority"] = certificate_authority
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["compute_config"] = compute_config
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["default_addons_to_removes"] = default_addons_to_removes
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["enabled_cluster_log_types"] = enabled_cluster_log_types
        __props__.__dict__["encryption_config"] = encryption_config
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["force_update_version"] = force_update_version
        __props__.__dict__["identities"] = identities
        __props__.__dict__["kubernetes_network_config"] = kubernetes_network_config
        __props__.__dict__["name"] = name
        __props__.__dict__["outpost_config"] = outpost_config
        __props__.__dict__["platform_version"] = platform_version
        __props__.__dict__["region"] = region
        __props__.__dict__["remote_network_config"] = remote_network_config
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_config"] = storage_config
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["upgrade_policy"] = upgrade_policy
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_config"] = vpc_config
        __props__.__dict__["zonal_shift_config"] = zonal_shift_config
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> pulumi.Output['outputs.ClusterAccessConfig']:
        """
        Configuration block for the access config associated with your cluster, see [Amazon EKS Access Entries](https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html). Detailed below.
        """
        return pulumi.get(self, "access_config")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the cluster.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="bootstrapSelfManagedAddons")
    def bootstrap_self_managed_addons(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Install default unmanaged add-ons, such as `aws-cni`, `kube-proxy`, and CoreDNS during cluster creation. If `false`, you must manually install desired add-ons. Changing this value will force a new cluster to be created. Defaults to `true`.
        """
        return pulumi.get(self, "bootstrap_self_managed_addons")

    @_builtins.property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> pulumi.Output['outputs.ClusterCertificateAuthority']:
        """
        Attribute block containing `certificate-authority-data` for your cluster. Detailed below.
        """
        return pulumi.get(self, "certificate_authority")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of your local Amazon EKS cluster on the AWS Outpost. This attribute isn't available for an AWS EKS cluster on AWS cloud.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="computeConfig")
    def compute_config(self) -> pulumi.Output[Optional['outputs.ClusterComputeConfig']]:
        """
        Configuration block with compute configuration for EKS Auto Mode. Detailed below.
        """
        return pulumi.get(self, "compute_config")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Unix epoch timestamp in seconds for when the cluster was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="defaultAddonsToRemoves")
    @_utilities.deprecated("""Configure bootstrap_self_managed_addons instead. This attribute will be removed in the next major version of the provider""")
    def default_addons_to_removes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "default_addons_to_removes")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable deletion protection for the cluster. When enabled, the cluster cannot be deleted unless deletion protection is first disabled. Default: `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="enabledClusterLogTypes")
    def enabled_cluster_log_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of the desired control plane logging to enable. For more information, see [Amazon EKS Control Plane Logging](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html).
        """
        return pulumi.get(self, "enabled_cluster_log_types")

    @_builtins.property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> pulumi.Output[Optional['outputs.ClusterEncryptionConfig']]:
        """
        Configuration block with encryption configuration for the cluster. Detailed below.
        """
        return pulumi.get(self, "encryption_config")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Endpoint for your Kubernetes API server.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="forceUpdateVersion")
    def force_update_version(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Force version update by overriding upgrade-blocking readiness checks when updating a cluster.
        """
        return pulumi.get(self, "force_update_version")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> pulumi.Output[Sequence['outputs.ClusterIdentity']]:
        """
        Attribute block containing identity provider information for your cluster. Only available on Kubernetes version 1.13 and 1.14 clusters created or upgraded on or after September 3, 2019. Detailed below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter(name="kubernetesNetworkConfig")
    def kubernetes_network_config(self) -> pulumi.Output['outputs.ClusterKubernetesNetworkConfig']:
        """
        Configuration block with kubernetes network configuration for the cluster. Detailed below. If removed, the provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "kubernetes_network_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\\-_]*$`).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outpostConfig")
    def outpost_config(self) -> pulumi.Output[Optional['outputs.ClusterOutpostConfig']]:
        """
        Configuration block representing the configuration of your local Amazon EKS cluster on an AWS Outpost. This block isn't available for creating Amazon EKS clusters on the AWS cloud.
        """
        return pulumi.get(self, "outpost_config")

    @_builtins.property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> pulumi.Output[_builtins.str]:
        """
        Platform version for the cluster.
        """
        return pulumi.get(self, "platform_version")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="remoteNetworkConfig")
    def remote_network_config(self) -> pulumi.Output[Optional['outputs.ClusterRemoteNetworkConfig']]:
        """
        Configuration block with remote network configuration for EKS Hybrid Nodes. Detailed below.
        """
        return pulumi.get(self, "remote_network_config")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf. Ensure the resource configuration includes explicit dependencies on the IAM Role permissions by adding `depends_on` if using the `iam.RolePolicy` resource or `iam.RolePolicyAttachment` resource, otherwise EKS cannot delete EKS managed EC2 infrastructure such as Security Groups on EKS Cluster deletion.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the EKS cluster. One of `CREATING`, `ACTIVE`, `DELETING`, `FAILED`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageConfig")
    def storage_config(self) -> pulumi.Output[Optional['outputs.ClusterStorageConfig']]:
        """
        Configuration block with storage configuration for EKS Auto Mode. Detailed below.
        """
        return pulumi.get(self, "storage_config")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> pulumi.Output['outputs.ClusterUpgradePolicy']:
        """
        Configuration block for the support policy to use for the cluster.  See upgrade_policy for details.
        """
        return pulumi.get(self, "upgrade_policy")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Desired Kubernetes master version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except those automatically triggered by EKS. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by EKS.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output['outputs.ClusterVpcConfig']:
        """
        Configuration block for the VPC associated with your cluster. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) and [Cluster Security Group Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the Amazon EKS User Guide. Detailed below. Also contains attributes detailed in the Attributes section.

        The following arguments are optional:
        """
        return pulumi.get(self, "vpc_config")

    @_builtins.property
    @pulumi.getter(name="zonalShiftConfig")
    def zonal_shift_config(self) -> pulumi.Output[Optional['outputs.ClusterZonalShiftConfig']]:
        """
        Configuration block with zonal shift configuration for the cluster. Detailed below.
        """
        return pulumi.get(self, "zonal_shift_config")

