# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PipelineArgs', 'Pipeline']

@pulumi.input_type
class PipelineArgs:
    def __init__(__self__, *,
                 input_bucket: pulumi.Input[_builtins.str],
                 role: pulumi.Input[_builtins.str],
                 aws_kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 content_config: Optional[pulumi.Input['PipelineContentConfigArgs']] = None,
                 content_config_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineContentConfigPermissionArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input['PipelineNotificationsArgs']] = None,
                 output_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbnail_config: Optional[pulumi.Input['PipelineThumbnailConfigArgs']] = None,
                 thumbnail_config_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineThumbnailConfigPermissionArgs']]]] = None):
        """
        The set of arguments for constructing a Pipeline resource.
        :param pulumi.Input[_builtins.str] input_bucket: The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
        :param pulumi.Input[_builtins.str] role: The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
        :param pulumi.Input[_builtins.str] aws_kms_key_arn: The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
        :param pulumi.Input['PipelineContentConfigArgs'] content_config: The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
        :param pulumi.Input[Sequence[pulumi.Input['PipelineContentConfigPermissionArgs']]] content_config_permissions: The permissions for the `content_config` object. (documented below)
        :param pulumi.Input[_builtins.str] name: The name of the pipeline. Maximum 40 characters
        :param pulumi.Input['PipelineNotificationsArgs'] notifications: The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
        :param pulumi.Input[_builtins.str] output_bucket: The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['PipelineThumbnailConfigArgs'] thumbnail_config: The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
        :param pulumi.Input[Sequence[pulumi.Input['PipelineThumbnailConfigPermissionArgs']]] thumbnail_config_permissions: The permissions for the `thumbnail_config` object. (documented below)
               
               See ["Create Pipeline"](http://docs.aws.amazon.com/elastictranscoder/latest/developerguide/create-pipeline.html) in the AWS docs for reference.
               
               The `content_config` object specifies information about the Amazon S3 bucket in
               which you want Elastic Transcoder to save transcoded files and playlists: which
               bucket to use, and the storage class that you want to assign to the files. If
               you specify values for `content_config`, you must also specify values for
               `thumbnail_config`. If you specify values for `content_config` and
               `thumbnail_config`, omit the `output_bucket` object.
        """
        pulumi.set(__self__, "input_bucket", input_bucket)
        pulumi.set(__self__, "role", role)
        if aws_kms_key_arn is not None:
            pulumi.set(__self__, "aws_kms_key_arn", aws_kms_key_arn)
        if content_config is not None:
            pulumi.set(__self__, "content_config", content_config)
        if content_config_permissions is not None:
            pulumi.set(__self__, "content_config_permissions", content_config_permissions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if output_bucket is not None:
            pulumi.set(__self__, "output_bucket", output_bucket)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if thumbnail_config is not None:
            pulumi.set(__self__, "thumbnail_config", thumbnail_config)
        if thumbnail_config_permissions is not None:
            pulumi.set(__self__, "thumbnail_config_permissions", thumbnail_config_permissions)

    @_builtins.property
    @pulumi.getter(name="inputBucket")
    def input_bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
        """
        return pulumi.get(self, "input_bucket")

    @input_bucket.setter
    def input_bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "input_bucket", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="awsKmsKeyArn")
    def aws_kms_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
        """
        return pulumi.get(self, "aws_kms_key_arn")

    @aws_kms_key_arn.setter
    def aws_kms_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_kms_key_arn", value)

    @_builtins.property
    @pulumi.getter(name="contentConfig")
    def content_config(self) -> Optional[pulumi.Input['PipelineContentConfigArgs']]:
        """
        The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
        """
        return pulumi.get(self, "content_config")

    @content_config.setter
    def content_config(self, value: Optional[pulumi.Input['PipelineContentConfigArgs']]):
        pulumi.set(self, "content_config", value)

    @_builtins.property
    @pulumi.getter(name="contentConfigPermissions")
    def content_config_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineContentConfigPermissionArgs']]]]:
        """
        The permissions for the `content_config` object. (documented below)
        """
        return pulumi.get(self, "content_config_permissions")

    @content_config_permissions.setter
    def content_config_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineContentConfigPermissionArgs']]]]):
        pulumi.set(self, "content_config_permissions", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the pipeline. Maximum 40 characters
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input['PipelineNotificationsArgs']]:
        """
        The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input['PipelineNotificationsArgs']]):
        pulumi.set(self, "notifications", value)

    @_builtins.property
    @pulumi.getter(name="outputBucket")
    def output_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files.
        """
        return pulumi.get(self, "output_bucket")

    @output_bucket.setter
    def output_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_bucket", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="thumbnailConfig")
    def thumbnail_config(self) -> Optional[pulumi.Input['PipelineThumbnailConfigArgs']]:
        """
        The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
        """
        return pulumi.get(self, "thumbnail_config")

    @thumbnail_config.setter
    def thumbnail_config(self, value: Optional[pulumi.Input['PipelineThumbnailConfigArgs']]):
        pulumi.set(self, "thumbnail_config", value)

    @_builtins.property
    @pulumi.getter(name="thumbnailConfigPermissions")
    def thumbnail_config_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineThumbnailConfigPermissionArgs']]]]:
        """
        The permissions for the `thumbnail_config` object. (documented below)

        See ["Create Pipeline"](http://docs.aws.amazon.com/elastictranscoder/latest/developerguide/create-pipeline.html) in the AWS docs for reference.

        The `content_config` object specifies information about the Amazon S3 bucket in
        which you want Elastic Transcoder to save transcoded files and playlists: which
        bucket to use, and the storage class that you want to assign to the files. If
        you specify values for `content_config`, you must also specify values for
        `thumbnail_config`. If you specify values for `content_config` and
        `thumbnail_config`, omit the `output_bucket` object.
        """
        return pulumi.get(self, "thumbnail_config_permissions")

    @thumbnail_config_permissions.setter
    def thumbnail_config_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineThumbnailConfigPermissionArgs']]]]):
        pulumi.set(self, "thumbnail_config_permissions", value)


@pulumi.input_type
class _PipelineState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 content_config: Optional[pulumi.Input['PipelineContentConfigArgs']] = None,
                 content_config_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineContentConfigPermissionArgs']]]] = None,
                 input_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input['PipelineNotificationsArgs']] = None,
                 output_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbnail_config: Optional[pulumi.Input['PipelineThumbnailConfigArgs']] = None,
                 thumbnail_config_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineThumbnailConfigPermissionArgs']]]] = None):
        """
        Input properties used for looking up and filtering Pipeline resources.
        :param pulumi.Input[_builtins.str] arn: The ARN of the Elastictranscoder pipeline.
        :param pulumi.Input[_builtins.str] aws_kms_key_arn: The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
        :param pulumi.Input['PipelineContentConfigArgs'] content_config: The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
        :param pulumi.Input[Sequence[pulumi.Input['PipelineContentConfigPermissionArgs']]] content_config_permissions: The permissions for the `content_config` object. (documented below)
        :param pulumi.Input[_builtins.str] input_bucket: The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
        :param pulumi.Input[_builtins.str] name: The name of the pipeline. Maximum 40 characters
        :param pulumi.Input['PipelineNotificationsArgs'] notifications: The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
        :param pulumi.Input[_builtins.str] output_bucket: The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role: The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
        :param pulumi.Input['PipelineThumbnailConfigArgs'] thumbnail_config: The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
        :param pulumi.Input[Sequence[pulumi.Input['PipelineThumbnailConfigPermissionArgs']]] thumbnail_config_permissions: The permissions for the `thumbnail_config` object. (documented below)
               
               See ["Create Pipeline"](http://docs.aws.amazon.com/elastictranscoder/latest/developerguide/create-pipeline.html) in the AWS docs for reference.
               
               The `content_config` object specifies information about the Amazon S3 bucket in
               which you want Elastic Transcoder to save transcoded files and playlists: which
               bucket to use, and the storage class that you want to assign to the files. If
               you specify values for `content_config`, you must also specify values for
               `thumbnail_config`. If you specify values for `content_config` and
               `thumbnail_config`, omit the `output_bucket` object.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if aws_kms_key_arn is not None:
            pulumi.set(__self__, "aws_kms_key_arn", aws_kms_key_arn)
        if content_config is not None:
            pulumi.set(__self__, "content_config", content_config)
        if content_config_permissions is not None:
            pulumi.set(__self__, "content_config_permissions", content_config_permissions)
        if input_bucket is not None:
            pulumi.set(__self__, "input_bucket", input_bucket)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if output_bucket is not None:
            pulumi.set(__self__, "output_bucket", output_bucket)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if thumbnail_config is not None:
            pulumi.set(__self__, "thumbnail_config", thumbnail_config)
        if thumbnail_config_permissions is not None:
            pulumi.set(__self__, "thumbnail_config_permissions", thumbnail_config_permissions)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the Elastictranscoder pipeline.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="awsKmsKeyArn")
    def aws_kms_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
        """
        return pulumi.get(self, "aws_kms_key_arn")

    @aws_kms_key_arn.setter
    def aws_kms_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_kms_key_arn", value)

    @_builtins.property
    @pulumi.getter(name="contentConfig")
    def content_config(self) -> Optional[pulumi.Input['PipelineContentConfigArgs']]:
        """
        The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
        """
        return pulumi.get(self, "content_config")

    @content_config.setter
    def content_config(self, value: Optional[pulumi.Input['PipelineContentConfigArgs']]):
        pulumi.set(self, "content_config", value)

    @_builtins.property
    @pulumi.getter(name="contentConfigPermissions")
    def content_config_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineContentConfigPermissionArgs']]]]:
        """
        The permissions for the `content_config` object. (documented below)
        """
        return pulumi.get(self, "content_config_permissions")

    @content_config_permissions.setter
    def content_config_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineContentConfigPermissionArgs']]]]):
        pulumi.set(self, "content_config_permissions", value)

    @_builtins.property
    @pulumi.getter(name="inputBucket")
    def input_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
        """
        return pulumi.get(self, "input_bucket")

    @input_bucket.setter
    def input_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "input_bucket", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the pipeline. Maximum 40 characters
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input['PipelineNotificationsArgs']]:
        """
        The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input['PipelineNotificationsArgs']]):
        pulumi.set(self, "notifications", value)

    @_builtins.property
    @pulumi.getter(name="outputBucket")
    def output_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files.
        """
        return pulumi.get(self, "output_bucket")

    @output_bucket.setter
    def output_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_bucket", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="thumbnailConfig")
    def thumbnail_config(self) -> Optional[pulumi.Input['PipelineThumbnailConfigArgs']]:
        """
        The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
        """
        return pulumi.get(self, "thumbnail_config")

    @thumbnail_config.setter
    def thumbnail_config(self, value: Optional[pulumi.Input['PipelineThumbnailConfigArgs']]):
        pulumi.set(self, "thumbnail_config", value)

    @_builtins.property
    @pulumi.getter(name="thumbnailConfigPermissions")
    def thumbnail_config_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineThumbnailConfigPermissionArgs']]]]:
        """
        The permissions for the `thumbnail_config` object. (documented below)

        See ["Create Pipeline"](http://docs.aws.amazon.com/elastictranscoder/latest/developerguide/create-pipeline.html) in the AWS docs for reference.

        The `content_config` object specifies information about the Amazon S3 bucket in
        which you want Elastic Transcoder to save transcoded files and playlists: which
        bucket to use, and the storage class that you want to assign to the files. If
        you specify values for `content_config`, you must also specify values for
        `thumbnail_config`. If you specify values for `content_config` and
        `thumbnail_config`, omit the `output_bucket` object.
        """
        return pulumi.get(self, "thumbnail_config_permissions")

    @thumbnail_config_permissions.setter
    def thumbnail_config_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineThumbnailConfigPermissionArgs']]]]):
        pulumi.set(self, "thumbnail_config_permissions", value)


@pulumi.type_token("aws:elastictranscoder/pipeline:Pipeline")
class Pipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 content_config: Optional[pulumi.Input[Union['PipelineContentConfigArgs', 'PipelineContentConfigArgsDict']]] = None,
                 content_config_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineContentConfigPermissionArgs', 'PipelineContentConfigPermissionArgsDict']]]]] = None,
                 input_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Union['PipelineNotificationsArgs', 'PipelineNotificationsArgsDict']]] = None,
                 output_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbnail_config: Optional[pulumi.Input[Union['PipelineThumbnailConfigArgs', 'PipelineThumbnailConfigArgsDict']]] = None,
                 thumbnail_config_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineThumbnailConfigPermissionArgs', 'PipelineThumbnailConfigPermissionArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides an Elastic Transcoder pipeline resource.

        > **Warning:** This resource is deprecated. Use [AWS Elemental MediaConvert](https://aws.amazon.com/blogs/media/migrating-workflows-from-amazon-elastic-transcoder-to-aws-elemental-mediaconvert/) instead. AWS will [discontinue support for Amazon Elastic Transcoder](https://aws.amazon.com/blogs/media/support-for-amazon-elastic-transcoder-ending-soon/), effective November 13, 2025.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        bar = aws.elastictranscoder.Pipeline("bar",
            input_bucket=input_bucket["id"],
            name="aws_elastictranscoder_pipeline_my_test_",
            role=test_role["arn"],
            content_config={
                "bucket": content_bucket["id"],
                "storage_class": "Standard",
            },
            thumbnail_config={
                "bucket": thumb_bucket["id"],
                "storage_class": "Standard",
            })
        ```

        ## Import

        Using `pulumi import`, import Elastic Transcoder pipelines using the `id`. For example:

        ```sh
        $ pulumi import aws:elastictranscoder/pipeline:Pipeline basic_pipeline 1407981661351-cttk8b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aws_kms_key_arn: The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
        :param pulumi.Input[Union['PipelineContentConfigArgs', 'PipelineContentConfigArgsDict']] content_config: The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineContentConfigPermissionArgs', 'PipelineContentConfigPermissionArgsDict']]]] content_config_permissions: The permissions for the `content_config` object. (documented below)
        :param pulumi.Input[_builtins.str] input_bucket: The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
        :param pulumi.Input[_builtins.str] name: The name of the pipeline. Maximum 40 characters
        :param pulumi.Input[Union['PipelineNotificationsArgs', 'PipelineNotificationsArgsDict']] notifications: The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
        :param pulumi.Input[_builtins.str] output_bucket: The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role: The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
        :param pulumi.Input[Union['PipelineThumbnailConfigArgs', 'PipelineThumbnailConfigArgsDict']] thumbnail_config: The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineThumbnailConfigPermissionArgs', 'PipelineThumbnailConfigPermissionArgsDict']]]] thumbnail_config_permissions: The permissions for the `thumbnail_config` object. (documented below)
               
               See ["Create Pipeline"](http://docs.aws.amazon.com/elastictranscoder/latest/developerguide/create-pipeline.html) in the AWS docs for reference.
               
               The `content_config` object specifies information about the Amazon S3 bucket in
               which you want Elastic Transcoder to save transcoded files and playlists: which
               bucket to use, and the storage class that you want to assign to the files. If
               you specify values for `content_config`, you must also specify values for
               `thumbnail_config`. If you specify values for `content_config` and
               `thumbnail_config`, omit the `output_bucket` object.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Elastic Transcoder pipeline resource.

        > **Warning:** This resource is deprecated. Use [AWS Elemental MediaConvert](https://aws.amazon.com/blogs/media/migrating-workflows-from-amazon-elastic-transcoder-to-aws-elemental-mediaconvert/) instead. AWS will [discontinue support for Amazon Elastic Transcoder](https://aws.amazon.com/blogs/media/support-for-amazon-elastic-transcoder-ending-soon/), effective November 13, 2025.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        bar = aws.elastictranscoder.Pipeline("bar",
            input_bucket=input_bucket["id"],
            name="aws_elastictranscoder_pipeline_my_test_",
            role=test_role["arn"],
            content_config={
                "bucket": content_bucket["id"],
                "storage_class": "Standard",
            },
            thumbnail_config={
                "bucket": thumb_bucket["id"],
                "storage_class": "Standard",
            })
        ```

        ## Import

        Using `pulumi import`, import Elastic Transcoder pipelines using the `id`. For example:

        ```sh
        $ pulumi import aws:elastictranscoder/pipeline:Pipeline basic_pipeline 1407981661351-cttk8b
        ```

        :param str resource_name: The name of the resource.
        :param PipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 content_config: Optional[pulumi.Input[Union['PipelineContentConfigArgs', 'PipelineContentConfigArgsDict']]] = None,
                 content_config_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineContentConfigPermissionArgs', 'PipelineContentConfigPermissionArgsDict']]]]] = None,
                 input_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Union['PipelineNotificationsArgs', 'PipelineNotificationsArgsDict']]] = None,
                 output_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbnail_config: Optional[pulumi.Input[Union['PipelineThumbnailConfigArgs', 'PipelineThumbnailConfigArgsDict']]] = None,
                 thumbnail_config_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineThumbnailConfigPermissionArgs', 'PipelineThumbnailConfigPermissionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineArgs.__new__(PipelineArgs)

            __props__.__dict__["aws_kms_key_arn"] = aws_kms_key_arn
            __props__.__dict__["content_config"] = content_config
            __props__.__dict__["content_config_permissions"] = content_config_permissions
            if input_bucket is None and not opts.urn:
                raise TypeError("Missing required property 'input_bucket'")
            __props__.__dict__["input_bucket"] = input_bucket
            __props__.__dict__["name"] = name
            __props__.__dict__["notifications"] = notifications
            __props__.__dict__["output_bucket"] = output_bucket
            __props__.__dict__["region"] = region
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["thumbnail_config"] = thumbnail_config
            __props__.__dict__["thumbnail_config_permissions"] = thumbnail_config_permissions
            __props__.__dict__["arn"] = None
        super(Pipeline, __self__).__init__(
            'aws:elastictranscoder/pipeline:Pipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            aws_kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
            content_config: Optional[pulumi.Input[Union['PipelineContentConfigArgs', 'PipelineContentConfigArgsDict']]] = None,
            content_config_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineContentConfigPermissionArgs', 'PipelineContentConfigPermissionArgsDict']]]]] = None,
            input_bucket: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notifications: Optional[pulumi.Input[Union['PipelineNotificationsArgs', 'PipelineNotificationsArgsDict']]] = None,
            output_bucket: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            thumbnail_config: Optional[pulumi.Input[Union['PipelineThumbnailConfigArgs', 'PipelineThumbnailConfigArgsDict']]] = None,
            thumbnail_config_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineThumbnailConfigPermissionArgs', 'PipelineThumbnailConfigPermissionArgsDict']]]]] = None) -> 'Pipeline':
        """
        Get an existing Pipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of the Elastictranscoder pipeline.
        :param pulumi.Input[_builtins.str] aws_kms_key_arn: The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
        :param pulumi.Input[Union['PipelineContentConfigArgs', 'PipelineContentConfigArgsDict']] content_config: The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineContentConfigPermissionArgs', 'PipelineContentConfigPermissionArgsDict']]]] content_config_permissions: The permissions for the `content_config` object. (documented below)
        :param pulumi.Input[_builtins.str] input_bucket: The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
        :param pulumi.Input[_builtins.str] name: The name of the pipeline. Maximum 40 characters
        :param pulumi.Input[Union['PipelineNotificationsArgs', 'PipelineNotificationsArgsDict']] notifications: The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
        :param pulumi.Input[_builtins.str] output_bucket: The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role: The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
        :param pulumi.Input[Union['PipelineThumbnailConfigArgs', 'PipelineThumbnailConfigArgsDict']] thumbnail_config: The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineThumbnailConfigPermissionArgs', 'PipelineThumbnailConfigPermissionArgsDict']]]] thumbnail_config_permissions: The permissions for the `thumbnail_config` object. (documented below)
               
               See ["Create Pipeline"](http://docs.aws.amazon.com/elastictranscoder/latest/developerguide/create-pipeline.html) in the AWS docs for reference.
               
               The `content_config` object specifies information about the Amazon S3 bucket in
               which you want Elastic Transcoder to save transcoded files and playlists: which
               bucket to use, and the storage class that you want to assign to the files. If
               you specify values for `content_config`, you must also specify values for
               `thumbnail_config`. If you specify values for `content_config` and
               `thumbnail_config`, omit the `output_bucket` object.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipelineState.__new__(_PipelineState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["aws_kms_key_arn"] = aws_kms_key_arn
        __props__.__dict__["content_config"] = content_config
        __props__.__dict__["content_config_permissions"] = content_config_permissions
        __props__.__dict__["input_bucket"] = input_bucket
        __props__.__dict__["name"] = name
        __props__.__dict__["notifications"] = notifications
        __props__.__dict__["output_bucket"] = output_bucket
        __props__.__dict__["region"] = region
        __props__.__dict__["role"] = role
        __props__.__dict__["thumbnail_config"] = thumbnail_config
        __props__.__dict__["thumbnail_config_permissions"] = thumbnail_config_permissions
        return Pipeline(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the Elastictranscoder pipeline.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="awsKmsKeyArn")
    def aws_kms_key_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
        """
        return pulumi.get(self, "aws_kms_key_arn")

    @_builtins.property
    @pulumi.getter(name="contentConfig")
    def content_config(self) -> pulumi.Output['outputs.PipelineContentConfig']:
        """
        The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
        """
        return pulumi.get(self, "content_config")

    @_builtins.property
    @pulumi.getter(name="contentConfigPermissions")
    def content_config_permissions(self) -> pulumi.Output[Optional[Sequence['outputs.PipelineContentConfigPermission']]]:
        """
        The permissions for the `content_config` object. (documented below)
        """
        return pulumi.get(self, "content_config_permissions")

    @_builtins.property
    @pulumi.getter(name="inputBucket")
    def input_bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
        """
        return pulumi.get(self, "input_bucket")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the pipeline. Maximum 40 characters
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Optional['outputs.PipelineNotifications']]:
        """
        The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
        """
        return pulumi.get(self, "notifications")

    @_builtins.property
    @pulumi.getter(name="outputBucket")
    def output_bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files.
        """
        return pulumi.get(self, "output_bucket")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="thumbnailConfig")
    def thumbnail_config(self) -> pulumi.Output['outputs.PipelineThumbnailConfig']:
        """
        The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
        """
        return pulumi.get(self, "thumbnail_config")

    @_builtins.property
    @pulumi.getter(name="thumbnailConfigPermissions")
    def thumbnail_config_permissions(self) -> pulumi.Output[Optional[Sequence['outputs.PipelineThumbnailConfigPermission']]]:
        """
        The permissions for the `thumbnail_config` object. (documented below)

        See ["Create Pipeline"](http://docs.aws.amazon.com/elastictranscoder/latest/developerguide/create-pipeline.html) in the AWS docs for reference.

        The `content_config` object specifies information about the Amazon S3 bucket in
        which you want Elastic Transcoder to save transcoded files and playlists: which
        bucket to use, and the storage class that you want to assign to the files. If
        you specify values for `content_config`, you must also specify values for
        `thumbnail_config`. If you specify values for `content_config` and
        `thumbnail_config`, omit the `output_bucket` object.
        """
        return pulumi.get(self, "thumbnail_config_permissions")

