# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 release_label: pulumi.Input[_builtins.str],
                 service_role: pulumi.Input[_builtins.str],
                 additional_info: Optional[pulumi.Input[_builtins.str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_termination_policy: Optional[pulumi.Input['ClusterAutoTerminationPolicyArgs']] = None,
                 autoscaling_role: Optional[pulumi.Input[_builtins.str]] = None,
                 bootstrap_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]] = None,
                 configurations: Optional[pulumi.Input[_builtins.str]] = None,
                 configurations_json: Optional[pulumi.Input[_builtins.str]] = None,
                 core_instance_fleet: Optional[pulumi.Input['ClusterCoreInstanceFleetArgs']] = None,
                 core_instance_group: Optional[pulumi.Input['ClusterCoreInstanceGroupArgs']] = None,
                 custom_ami_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ebs_root_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 ec2_attributes: Optional[pulumi.Input['ClusterEc2AttributesArgs']] = None,
                 keep_job_flow_alive_when_no_steps: Optional[pulumi.Input[_builtins.bool]] = None,
                 kerberos_attributes: Optional[pulumi.Input['ClusterKerberosAttributesArgs']] = None,
                 list_steps_states: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_encryption_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 master_instance_fleet: Optional[pulumi.Input['ClusterMasterInstanceFleetArgs']] = None,
                 master_instance_group: Optional[pulumi.Input['ClusterMasterInstanceGroupArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_release_label: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_group_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPlacementGroupConfigArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_down_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 security_configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 step_concurrency_level: Optional[pulumi.Input[_builtins.int]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 unhealthy_node_replacement: Optional[pulumi.Input[_builtins.bool]] = None,
                 visible_to_all_users: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] release_label: Release label for the Amazon EMR release.
        :param pulumi.Input[_builtins.str] service_role: IAM role that will be assumed by the Amazon EMR service to access AWS resources.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] additional_info: JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore the provider cannot detect drift from the actual EMR cluster if its value is changed outside the provider.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
        :param pulumi.Input['ClusterAutoTerminationPolicyArgs'] auto_termination_policy: An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
        :param pulumi.Input[_builtins.str] autoscaling_role: IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]] bootstrap_actions: Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
        :param pulumi.Input[_builtins.str] configurations: List of configurations supplied for the EMR cluster you are creating. Supply a configuration object for applications to override their default configuration. See [AWS Documentation](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html) for more information.
        :param pulumi.Input[_builtins.str] configurations_json: JSON string for supplying list of configurations for the EMR cluster.
               
               > **NOTE on `configurations_json`:** If the `Configurations` value is empty then you should skip the `Configurations` field instead of providing an empty list as a value, `"Configurations": []`.
               
               ```python
               import pulumi
               import pulumi_aws as aws
               
               cluster = aws.emr.Cluster("cluster", configurations_json=\"\"\"[
               {
               "Classification": "hadoop-env",
               "Configurations": [
               {
               "Classification": "export",
               "Properties": {
               "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
               }
               }
               ],
               "Properties": {}
               }
               ]
               \"\"\")
               ```
        :param pulumi.Input['ClusterCoreInstanceFleetArgs'] core_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input['ClusterCoreInstanceGroupArgs'] core_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
        :param pulumi.Input[_builtins.str] custom_ami_id: Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
        :param pulumi.Input[_builtins.int] ebs_root_volume_size: Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
        :param pulumi.Input['ClusterEc2AttributesArgs'] ec2_attributes: Attributes for the EC2 instances running the job flow. See below.
        :param pulumi.Input[_builtins.bool] keep_job_flow_alive_when_no_steps: Switch on/off run cluster with no steps or when all steps are complete (default is on)
        :param pulumi.Input['ClusterKerberosAttributesArgs'] kerberos_attributes: Kerberos configuration for the cluster. See below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] list_steps_states: List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
        :param pulumi.Input[_builtins.str] log_encryption_kms_key_id: AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
        :param pulumi.Input[_builtins.str] log_uri: S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
        :param pulumi.Input['ClusterMasterInstanceFleetArgs'] master_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input['ClusterMasterInstanceGroupArgs'] master_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
        :param pulumi.Input[_builtins.str] name: Name of the job flow.
        :param pulumi.Input[_builtins.str] os_release_label: Amazon Linux release for all nodes in a cluster launch RunJobFlow request. If not specified, Amazon EMR uses the latest validated Amazon Linux release for cluster launch.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPlacementGroupConfigArgs']]] placement_group_configs: The specified placement group configuration for an Amazon EMR cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] scale_down_behavior: Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
        :param pulumi.Input[_builtins.str] security_configuration: Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
        :param pulumi.Input[_builtins.int] step_concurrency_level: Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
        :param pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]] steps: List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.bool] termination_protection: Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
        :param pulumi.Input[_builtins.bool] unhealthy_node_replacement: Whether whether Amazon EMR should gracefully replace core nodes that have degraded within the cluster. Default value is `false`.
        :param pulumi.Input[_builtins.bool] visible_to_all_users: Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
               
               **NOTE:** As per the [Amazon EMR API Reference](https://docs.aws.amazon.com/emr/latest/APIReference/API_RunJobFlow.html#EMR-RunJobFlow-request-VisibleToAllUsers), this argument is no longer supported. Do not set this argument, particularly to `false`, as it would lead to perpetual differences.
        """
        pulumi.set(__self__, "release_label", release_label)
        pulumi.set(__self__, "service_role", service_role)
        if additional_info is not None:
            pulumi.set(__self__, "additional_info", additional_info)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if auto_termination_policy is not None:
            pulumi.set(__self__, "auto_termination_policy", auto_termination_policy)
        if autoscaling_role is not None:
            pulumi.set(__self__, "autoscaling_role", autoscaling_role)
        if bootstrap_actions is not None:
            pulumi.set(__self__, "bootstrap_actions", bootstrap_actions)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if configurations_json is not None:
            pulumi.set(__self__, "configurations_json", configurations_json)
        if core_instance_fleet is not None:
            pulumi.set(__self__, "core_instance_fleet", core_instance_fleet)
        if core_instance_group is not None:
            pulumi.set(__self__, "core_instance_group", core_instance_group)
        if custom_ami_id is not None:
            pulumi.set(__self__, "custom_ami_id", custom_ami_id)
        if ebs_root_volume_size is not None:
            pulumi.set(__self__, "ebs_root_volume_size", ebs_root_volume_size)
        if ec2_attributes is not None:
            pulumi.set(__self__, "ec2_attributes", ec2_attributes)
        if keep_job_flow_alive_when_no_steps is not None:
            pulumi.set(__self__, "keep_job_flow_alive_when_no_steps", keep_job_flow_alive_when_no_steps)
        if kerberos_attributes is not None:
            pulumi.set(__self__, "kerberos_attributes", kerberos_attributes)
        if list_steps_states is not None:
            pulumi.set(__self__, "list_steps_states", list_steps_states)
        if log_encryption_kms_key_id is not None:
            pulumi.set(__self__, "log_encryption_kms_key_id", log_encryption_kms_key_id)
        if log_uri is not None:
            pulumi.set(__self__, "log_uri", log_uri)
        if master_instance_fleet is not None:
            pulumi.set(__self__, "master_instance_fleet", master_instance_fleet)
        if master_instance_group is not None:
            pulumi.set(__self__, "master_instance_group", master_instance_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_release_label is not None:
            pulumi.set(__self__, "os_release_label", os_release_label)
        if placement_group_configs is not None:
            pulumi.set(__self__, "placement_group_configs", placement_group_configs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scale_down_behavior is not None:
            pulumi.set(__self__, "scale_down_behavior", scale_down_behavior)
        if security_configuration is not None:
            pulumi.set(__self__, "security_configuration", security_configuration)
        if step_concurrency_level is not None:
            pulumi.set(__self__, "step_concurrency_level", step_concurrency_level)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)
        if unhealthy_node_replacement is not None:
            pulumi.set(__self__, "unhealthy_node_replacement", unhealthy_node_replacement)
        if visible_to_all_users is not None:
            pulumi.set(__self__, "visible_to_all_users", visible_to_all_users)

    @_builtins.property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> pulumi.Input[_builtins.str]:
        """
        Release label for the Amazon EMR release.
        """
        return pulumi.get(self, "release_label")

    @release_label.setter
    def release_label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "release_label", value)

    @_builtins.property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> pulumi.Input[_builtins.str]:
        """
        IAM role that will be assumed by the Amazon EMR service to access AWS resources.

        The following arguments are optional:
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_role", value)

    @_builtins.property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore the provider cannot detect drift from the actual EMR cluster if its value is changed outside the provider.
        """
        return pulumi.get(self, "additional_info")

    @additional_info.setter
    def additional_info(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "additional_info", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter(name="autoTerminationPolicy")
    def auto_termination_policy(self) -> Optional[pulumi.Input['ClusterAutoTerminationPolicyArgs']]:
        """
        An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
        """
        return pulumi.get(self, "auto_termination_policy")

    @auto_termination_policy.setter
    def auto_termination_policy(self, value: Optional[pulumi.Input['ClusterAutoTerminationPolicyArgs']]):
        pulumi.set(self, "auto_termination_policy", value)

    @_builtins.property
    @pulumi.getter(name="autoscalingRole")
    def autoscaling_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
        """
        return pulumi.get(self, "autoscaling_role")

    @autoscaling_role.setter
    def autoscaling_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "autoscaling_role", value)

    @_builtins.property
    @pulumi.getter(name="bootstrapActions")
    def bootstrap_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]]:
        """
        Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
        """
        return pulumi.get(self, "bootstrap_actions")

    @bootstrap_actions.setter
    def bootstrap_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]]):
        pulumi.set(self, "bootstrap_actions", value)

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of configurations supplied for the EMR cluster you are creating. Supply a configuration object for applications to override their default configuration. See [AWS Documentation](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html) for more information.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configurations", value)

    @_builtins.property
    @pulumi.getter(name="configurationsJson")
    def configurations_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON string for supplying list of configurations for the EMR cluster.

        > **NOTE on `configurations_json`:** If the `Configurations` value is empty then you should skip the `Configurations` field instead of providing an empty list as a value, `"Configurations": []`.

        ```python
        import pulumi
        import pulumi_aws as aws

        cluster = aws.emr.Cluster("cluster", configurations_json=\"\"\"[
        {
        "Classification": "hadoop-env",
        "Configurations": [
        {
        "Classification": "export",
        "Properties": {
        "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
        }
        }
        ],
        "Properties": {}
        }
        ]
        \"\"\")
        ```
        """
        return pulumi.get(self, "configurations_json")

    @configurations_json.setter
    def configurations_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configurations_json", value)

    @_builtins.property
    @pulumi.getter(name="coreInstanceFleet")
    def core_instance_fleet(self) -> Optional[pulumi.Input['ClusterCoreInstanceFleetArgs']]:
        """
        Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
        """
        return pulumi.get(self, "core_instance_fleet")

    @core_instance_fleet.setter
    def core_instance_fleet(self, value: Optional[pulumi.Input['ClusterCoreInstanceFleetArgs']]):
        pulumi.set(self, "core_instance_fleet", value)

    @_builtins.property
    @pulumi.getter(name="coreInstanceGroup")
    def core_instance_group(self) -> Optional[pulumi.Input['ClusterCoreInstanceGroupArgs']]:
        """
        Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
        """
        return pulumi.get(self, "core_instance_group")

    @core_instance_group.setter
    def core_instance_group(self, value: Optional[pulumi.Input['ClusterCoreInstanceGroupArgs']]):
        pulumi.set(self, "core_instance_group", value)

    @_builtins.property
    @pulumi.getter(name="customAmiId")
    def custom_ami_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
        """
        return pulumi.get(self, "custom_ami_id")

    @custom_ami_id.setter
    def custom_ami_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_ami_id", value)

    @_builtins.property
    @pulumi.getter(name="ebsRootVolumeSize")
    def ebs_root_volume_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
        """
        return pulumi.get(self, "ebs_root_volume_size")

    @ebs_root_volume_size.setter
    def ebs_root_volume_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ebs_root_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="ec2Attributes")
    def ec2_attributes(self) -> Optional[pulumi.Input['ClusterEc2AttributesArgs']]:
        """
        Attributes for the EC2 instances running the job flow. See below.
        """
        return pulumi.get(self, "ec2_attributes")

    @ec2_attributes.setter
    def ec2_attributes(self, value: Optional[pulumi.Input['ClusterEc2AttributesArgs']]):
        pulumi.set(self, "ec2_attributes", value)

    @_builtins.property
    @pulumi.getter(name="keepJobFlowAliveWhenNoSteps")
    def keep_job_flow_alive_when_no_steps(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Switch on/off run cluster with no steps or when all steps are complete (default is on)
        """
        return pulumi.get(self, "keep_job_flow_alive_when_no_steps")

    @keep_job_flow_alive_when_no_steps.setter
    def keep_job_flow_alive_when_no_steps(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keep_job_flow_alive_when_no_steps", value)

    @_builtins.property
    @pulumi.getter(name="kerberosAttributes")
    def kerberos_attributes(self) -> Optional[pulumi.Input['ClusterKerberosAttributesArgs']]:
        """
        Kerberos configuration for the cluster. See below.
        """
        return pulumi.get(self, "kerberos_attributes")

    @kerberos_attributes.setter
    def kerberos_attributes(self, value: Optional[pulumi.Input['ClusterKerberosAttributesArgs']]):
        pulumi.set(self, "kerberos_attributes", value)

    @_builtins.property
    @pulumi.getter(name="listStepsStates")
    def list_steps_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
        """
        return pulumi.get(self, "list_steps_states")

    @list_steps_states.setter
    def list_steps_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "list_steps_states", value)

    @_builtins.property
    @pulumi.getter(name="logEncryptionKmsKeyId")
    def log_encryption_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
        """
        return pulumi.get(self, "log_encryption_kms_key_id")

    @log_encryption_kms_key_id.setter
    def log_encryption_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_encryption_kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="logUri")
    def log_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
        """
        return pulumi.get(self, "log_uri")

    @log_uri.setter
    def log_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_uri", value)

    @_builtins.property
    @pulumi.getter(name="masterInstanceFleet")
    def master_instance_fleet(self) -> Optional[pulumi.Input['ClusterMasterInstanceFleetArgs']]:
        """
        Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
        """
        return pulumi.get(self, "master_instance_fleet")

    @master_instance_fleet.setter
    def master_instance_fleet(self, value: Optional[pulumi.Input['ClusterMasterInstanceFleetArgs']]):
        pulumi.set(self, "master_instance_fleet", value)

    @_builtins.property
    @pulumi.getter(name="masterInstanceGroup")
    def master_instance_group(self) -> Optional[pulumi.Input['ClusterMasterInstanceGroupArgs']]:
        """
        Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
        """
        return pulumi.get(self, "master_instance_group")

    @master_instance_group.setter
    def master_instance_group(self, value: Optional[pulumi.Input['ClusterMasterInstanceGroupArgs']]):
        pulumi.set(self, "master_instance_group", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the job flow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osReleaseLabel")
    def os_release_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Linux release for all nodes in a cluster launch RunJobFlow request. If not specified, Amazon EMR uses the latest validated Amazon Linux release for cluster launch.
        """
        return pulumi.get(self, "os_release_label")

    @os_release_label.setter
    def os_release_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_release_label", value)

    @_builtins.property
    @pulumi.getter(name="placementGroupConfigs")
    def placement_group_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPlacementGroupConfigArgs']]]]:
        """
        The specified placement group configuration for an Amazon EMR cluster.
        """
        return pulumi.get(self, "placement_group_configs")

    @placement_group_configs.setter
    def placement_group_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPlacementGroupConfigArgs']]]]):
        pulumi.set(self, "placement_group_configs", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scaleDownBehavior")
    def scale_down_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
        """
        return pulumi.get(self, "scale_down_behavior")

    @scale_down_behavior.setter
    def scale_down_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scale_down_behavior", value)

    @_builtins.property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
        """
        return pulumi.get(self, "security_configuration")

    @security_configuration.setter
    def security_configuration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_configuration", value)

    @_builtins.property
    @pulumi.getter(name="stepConcurrencyLevel")
    def step_concurrency_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
        """
        return pulumi.get(self, "step_concurrency_level")

    @step_concurrency_level.setter
    def step_concurrency_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "step_concurrency_level", value)

    @_builtins.property
    @pulumi.getter
    def steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]]]:
        """
        List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]]]):
        pulumi.set(self, "steps", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "termination_protection", value)

    @_builtins.property
    @pulumi.getter(name="unhealthyNodeReplacement")
    def unhealthy_node_replacement(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether whether Amazon EMR should gracefully replace core nodes that have degraded within the cluster. Default value is `false`.
        """
        return pulumi.get(self, "unhealthy_node_replacement")

    @unhealthy_node_replacement.setter
    def unhealthy_node_replacement(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unhealthy_node_replacement", value)

    @_builtins.property
    @pulumi.getter(name="visibleToAllUsers")
    def visible_to_all_users(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.

        **NOTE:** As per the [Amazon EMR API Reference](https://docs.aws.amazon.com/emr/latest/APIReference/API_RunJobFlow.html#EMR-RunJobFlow-request-VisibleToAllUsers), this argument is no longer supported. Do not set this argument, particularly to `false`, as it would lead to perpetual differences.
        """
        return pulumi.get(self, "visible_to_all_users")

    @visible_to_all_users.setter
    def visible_to_all_users(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "visible_to_all_users", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 additional_info: Optional[pulumi.Input[_builtins.str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_termination_policy: Optional[pulumi.Input['ClusterAutoTerminationPolicyArgs']] = None,
                 autoscaling_role: Optional[pulumi.Input[_builtins.str]] = None,
                 bootstrap_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]] = None,
                 cluster_state: Optional[pulumi.Input[_builtins.str]] = None,
                 configurations: Optional[pulumi.Input[_builtins.str]] = None,
                 configurations_json: Optional[pulumi.Input[_builtins.str]] = None,
                 core_instance_fleet: Optional[pulumi.Input['ClusterCoreInstanceFleetArgs']] = None,
                 core_instance_group: Optional[pulumi.Input['ClusterCoreInstanceGroupArgs']] = None,
                 custom_ami_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ebs_root_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 ec2_attributes: Optional[pulumi.Input['ClusterEc2AttributesArgs']] = None,
                 keep_job_flow_alive_when_no_steps: Optional[pulumi.Input[_builtins.bool]] = None,
                 kerberos_attributes: Optional[pulumi.Input['ClusterKerberosAttributesArgs']] = None,
                 list_steps_states: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_encryption_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 master_instance_fleet: Optional[pulumi.Input['ClusterMasterInstanceFleetArgs']] = None,
                 master_instance_group: Optional[pulumi.Input['ClusterMasterInstanceGroupArgs']] = None,
                 master_public_dns: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_release_label: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_group_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPlacementGroupConfigArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 release_label: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_down_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 security_configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 service_role: Optional[pulumi.Input[_builtins.str]] = None,
                 step_concurrency_level: Optional[pulumi.Input[_builtins.int]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 unhealthy_node_replacement: Optional[pulumi.Input[_builtins.bool]] = None,
                 visible_to_all_users: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[_builtins.str] additional_info: JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore the provider cannot detect drift from the actual EMR cluster if its value is changed outside the provider.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
        :param pulumi.Input[_builtins.str] arn: ARN of the cluster.
        :param pulumi.Input['ClusterAutoTerminationPolicyArgs'] auto_termination_policy: An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
        :param pulumi.Input[_builtins.str] autoscaling_role: IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]] bootstrap_actions: Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
        :param pulumi.Input[_builtins.str] configurations: List of configurations supplied for the EMR cluster you are creating. Supply a configuration object for applications to override their default configuration. See [AWS Documentation](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html) for more information.
        :param pulumi.Input[_builtins.str] configurations_json: JSON string for supplying list of configurations for the EMR cluster.
               
               > **NOTE on `configurations_json`:** If the `Configurations` value is empty then you should skip the `Configurations` field instead of providing an empty list as a value, `"Configurations": []`.
               
               ```python
               import pulumi
               import pulumi_aws as aws
               
               cluster = aws.emr.Cluster("cluster", configurations_json=\"\"\"[
               {
               "Classification": "hadoop-env",
               "Configurations": [
               {
               "Classification": "export",
               "Properties": {
               "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
               }
               }
               ],
               "Properties": {}
               }
               ]
               \"\"\")
               ```
        :param pulumi.Input['ClusterCoreInstanceFleetArgs'] core_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input['ClusterCoreInstanceGroupArgs'] core_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
        :param pulumi.Input[_builtins.str] custom_ami_id: Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
        :param pulumi.Input[_builtins.int] ebs_root_volume_size: Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
        :param pulumi.Input['ClusterEc2AttributesArgs'] ec2_attributes: Attributes for the EC2 instances running the job flow. See below.
        :param pulumi.Input[_builtins.bool] keep_job_flow_alive_when_no_steps: Switch on/off run cluster with no steps or when all steps are complete (default is on)
        :param pulumi.Input['ClusterKerberosAttributesArgs'] kerberos_attributes: Kerberos configuration for the cluster. See below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] list_steps_states: List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
        :param pulumi.Input[_builtins.str] log_encryption_kms_key_id: AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
        :param pulumi.Input[_builtins.str] log_uri: S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
        :param pulumi.Input['ClusterMasterInstanceFleetArgs'] master_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input['ClusterMasterInstanceGroupArgs'] master_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
        :param pulumi.Input[_builtins.str] master_public_dns: The DNS name of the master node. If the cluster is on a private subnet, this is the private DNS name. On a public subnet, this is the public DNS name.
        :param pulumi.Input[_builtins.str] name: Name of the job flow.
        :param pulumi.Input[_builtins.str] os_release_label: Amazon Linux release for all nodes in a cluster launch RunJobFlow request. If not specified, Amazon EMR uses the latest validated Amazon Linux release for cluster launch.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPlacementGroupConfigArgs']]] placement_group_configs: The specified placement group configuration for an Amazon EMR cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] release_label: Release label for the Amazon EMR release.
        :param pulumi.Input[_builtins.str] scale_down_behavior: Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
        :param pulumi.Input[_builtins.str] security_configuration: Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
        :param pulumi.Input[_builtins.str] service_role: IAM role that will be assumed by the Amazon EMR service to access AWS resources.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] step_concurrency_level: Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
        :param pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]] steps: List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] termination_protection: Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
        :param pulumi.Input[_builtins.bool] unhealthy_node_replacement: Whether whether Amazon EMR should gracefully replace core nodes that have degraded within the cluster. Default value is `false`.
        :param pulumi.Input[_builtins.bool] visible_to_all_users: Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
               
               **NOTE:** As per the [Amazon EMR API Reference](https://docs.aws.amazon.com/emr/latest/APIReference/API_RunJobFlow.html#EMR-RunJobFlow-request-VisibleToAllUsers), this argument is no longer supported. Do not set this argument, particularly to `false`, as it would lead to perpetual differences.
        """
        if additional_info is not None:
            pulumi.set(__self__, "additional_info", additional_info)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_termination_policy is not None:
            pulumi.set(__self__, "auto_termination_policy", auto_termination_policy)
        if autoscaling_role is not None:
            pulumi.set(__self__, "autoscaling_role", autoscaling_role)
        if bootstrap_actions is not None:
            pulumi.set(__self__, "bootstrap_actions", bootstrap_actions)
        if cluster_state is not None:
            pulumi.set(__self__, "cluster_state", cluster_state)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if configurations_json is not None:
            pulumi.set(__self__, "configurations_json", configurations_json)
        if core_instance_fleet is not None:
            pulumi.set(__self__, "core_instance_fleet", core_instance_fleet)
        if core_instance_group is not None:
            pulumi.set(__self__, "core_instance_group", core_instance_group)
        if custom_ami_id is not None:
            pulumi.set(__self__, "custom_ami_id", custom_ami_id)
        if ebs_root_volume_size is not None:
            pulumi.set(__self__, "ebs_root_volume_size", ebs_root_volume_size)
        if ec2_attributes is not None:
            pulumi.set(__self__, "ec2_attributes", ec2_attributes)
        if keep_job_flow_alive_when_no_steps is not None:
            pulumi.set(__self__, "keep_job_flow_alive_when_no_steps", keep_job_flow_alive_when_no_steps)
        if kerberos_attributes is not None:
            pulumi.set(__self__, "kerberos_attributes", kerberos_attributes)
        if list_steps_states is not None:
            pulumi.set(__self__, "list_steps_states", list_steps_states)
        if log_encryption_kms_key_id is not None:
            pulumi.set(__self__, "log_encryption_kms_key_id", log_encryption_kms_key_id)
        if log_uri is not None:
            pulumi.set(__self__, "log_uri", log_uri)
        if master_instance_fleet is not None:
            pulumi.set(__self__, "master_instance_fleet", master_instance_fleet)
        if master_instance_group is not None:
            pulumi.set(__self__, "master_instance_group", master_instance_group)
        if master_public_dns is not None:
            pulumi.set(__self__, "master_public_dns", master_public_dns)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_release_label is not None:
            pulumi.set(__self__, "os_release_label", os_release_label)
        if placement_group_configs is not None:
            pulumi.set(__self__, "placement_group_configs", placement_group_configs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if release_label is not None:
            pulumi.set(__self__, "release_label", release_label)
        if scale_down_behavior is not None:
            pulumi.set(__self__, "scale_down_behavior", scale_down_behavior)
        if security_configuration is not None:
            pulumi.set(__self__, "security_configuration", security_configuration)
        if service_role is not None:
            pulumi.set(__self__, "service_role", service_role)
        if step_concurrency_level is not None:
            pulumi.set(__self__, "step_concurrency_level", step_concurrency_level)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)
        if unhealthy_node_replacement is not None:
            pulumi.set(__self__, "unhealthy_node_replacement", unhealthy_node_replacement)
        if visible_to_all_users is not None:
            pulumi.set(__self__, "visible_to_all_users", visible_to_all_users)

    @_builtins.property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore the provider cannot detect drift from the actual EMR cluster if its value is changed outside the provider.
        """
        return pulumi.get(self, "additional_info")

    @additional_info.setter
    def additional_info(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "additional_info", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the cluster.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="autoTerminationPolicy")
    def auto_termination_policy(self) -> Optional[pulumi.Input['ClusterAutoTerminationPolicyArgs']]:
        """
        An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
        """
        return pulumi.get(self, "auto_termination_policy")

    @auto_termination_policy.setter
    def auto_termination_policy(self, value: Optional[pulumi.Input['ClusterAutoTerminationPolicyArgs']]):
        pulumi.set(self, "auto_termination_policy", value)

    @_builtins.property
    @pulumi.getter(name="autoscalingRole")
    def autoscaling_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
        """
        return pulumi.get(self, "autoscaling_role")

    @autoscaling_role.setter
    def autoscaling_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "autoscaling_role", value)

    @_builtins.property
    @pulumi.getter(name="bootstrapActions")
    def bootstrap_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]]:
        """
        Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
        """
        return pulumi.get(self, "bootstrap_actions")

    @bootstrap_actions.setter
    def bootstrap_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]]):
        pulumi.set(self, "bootstrap_actions", value)

    @_builtins.property
    @pulumi.getter(name="clusterState")
    def cluster_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_state")

    @cluster_state.setter
    def cluster_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_state", value)

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of configurations supplied for the EMR cluster you are creating. Supply a configuration object for applications to override their default configuration. See [AWS Documentation](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html) for more information.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configurations", value)

    @_builtins.property
    @pulumi.getter(name="configurationsJson")
    def configurations_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON string for supplying list of configurations for the EMR cluster.

        > **NOTE on `configurations_json`:** If the `Configurations` value is empty then you should skip the `Configurations` field instead of providing an empty list as a value, `"Configurations": []`.

        ```python
        import pulumi
        import pulumi_aws as aws

        cluster = aws.emr.Cluster("cluster", configurations_json=\"\"\"[
        {
        "Classification": "hadoop-env",
        "Configurations": [
        {
        "Classification": "export",
        "Properties": {
        "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
        }
        }
        ],
        "Properties": {}
        }
        ]
        \"\"\")
        ```
        """
        return pulumi.get(self, "configurations_json")

    @configurations_json.setter
    def configurations_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configurations_json", value)

    @_builtins.property
    @pulumi.getter(name="coreInstanceFleet")
    def core_instance_fleet(self) -> Optional[pulumi.Input['ClusterCoreInstanceFleetArgs']]:
        """
        Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
        """
        return pulumi.get(self, "core_instance_fleet")

    @core_instance_fleet.setter
    def core_instance_fleet(self, value: Optional[pulumi.Input['ClusterCoreInstanceFleetArgs']]):
        pulumi.set(self, "core_instance_fleet", value)

    @_builtins.property
    @pulumi.getter(name="coreInstanceGroup")
    def core_instance_group(self) -> Optional[pulumi.Input['ClusterCoreInstanceGroupArgs']]:
        """
        Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
        """
        return pulumi.get(self, "core_instance_group")

    @core_instance_group.setter
    def core_instance_group(self, value: Optional[pulumi.Input['ClusterCoreInstanceGroupArgs']]):
        pulumi.set(self, "core_instance_group", value)

    @_builtins.property
    @pulumi.getter(name="customAmiId")
    def custom_ami_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
        """
        return pulumi.get(self, "custom_ami_id")

    @custom_ami_id.setter
    def custom_ami_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_ami_id", value)

    @_builtins.property
    @pulumi.getter(name="ebsRootVolumeSize")
    def ebs_root_volume_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
        """
        return pulumi.get(self, "ebs_root_volume_size")

    @ebs_root_volume_size.setter
    def ebs_root_volume_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ebs_root_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="ec2Attributes")
    def ec2_attributes(self) -> Optional[pulumi.Input['ClusterEc2AttributesArgs']]:
        """
        Attributes for the EC2 instances running the job flow. See below.
        """
        return pulumi.get(self, "ec2_attributes")

    @ec2_attributes.setter
    def ec2_attributes(self, value: Optional[pulumi.Input['ClusterEc2AttributesArgs']]):
        pulumi.set(self, "ec2_attributes", value)

    @_builtins.property
    @pulumi.getter(name="keepJobFlowAliveWhenNoSteps")
    def keep_job_flow_alive_when_no_steps(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Switch on/off run cluster with no steps or when all steps are complete (default is on)
        """
        return pulumi.get(self, "keep_job_flow_alive_when_no_steps")

    @keep_job_flow_alive_when_no_steps.setter
    def keep_job_flow_alive_when_no_steps(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keep_job_flow_alive_when_no_steps", value)

    @_builtins.property
    @pulumi.getter(name="kerberosAttributes")
    def kerberos_attributes(self) -> Optional[pulumi.Input['ClusterKerberosAttributesArgs']]:
        """
        Kerberos configuration for the cluster. See below.
        """
        return pulumi.get(self, "kerberos_attributes")

    @kerberos_attributes.setter
    def kerberos_attributes(self, value: Optional[pulumi.Input['ClusterKerberosAttributesArgs']]):
        pulumi.set(self, "kerberos_attributes", value)

    @_builtins.property
    @pulumi.getter(name="listStepsStates")
    def list_steps_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
        """
        return pulumi.get(self, "list_steps_states")

    @list_steps_states.setter
    def list_steps_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "list_steps_states", value)

    @_builtins.property
    @pulumi.getter(name="logEncryptionKmsKeyId")
    def log_encryption_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
        """
        return pulumi.get(self, "log_encryption_kms_key_id")

    @log_encryption_kms_key_id.setter
    def log_encryption_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_encryption_kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="logUri")
    def log_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
        """
        return pulumi.get(self, "log_uri")

    @log_uri.setter
    def log_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_uri", value)

    @_builtins.property
    @pulumi.getter(name="masterInstanceFleet")
    def master_instance_fleet(self) -> Optional[pulumi.Input['ClusterMasterInstanceFleetArgs']]:
        """
        Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
        """
        return pulumi.get(self, "master_instance_fleet")

    @master_instance_fleet.setter
    def master_instance_fleet(self, value: Optional[pulumi.Input['ClusterMasterInstanceFleetArgs']]):
        pulumi.set(self, "master_instance_fleet", value)

    @_builtins.property
    @pulumi.getter(name="masterInstanceGroup")
    def master_instance_group(self) -> Optional[pulumi.Input['ClusterMasterInstanceGroupArgs']]:
        """
        Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
        """
        return pulumi.get(self, "master_instance_group")

    @master_instance_group.setter
    def master_instance_group(self, value: Optional[pulumi.Input['ClusterMasterInstanceGroupArgs']]):
        pulumi.set(self, "master_instance_group", value)

    @_builtins.property
    @pulumi.getter(name="masterPublicDns")
    def master_public_dns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DNS name of the master node. If the cluster is on a private subnet, this is the private DNS name. On a public subnet, this is the public DNS name.
        """
        return pulumi.get(self, "master_public_dns")

    @master_public_dns.setter
    def master_public_dns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_public_dns", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the job flow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osReleaseLabel")
    def os_release_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Linux release for all nodes in a cluster launch RunJobFlow request. If not specified, Amazon EMR uses the latest validated Amazon Linux release for cluster launch.
        """
        return pulumi.get(self, "os_release_label")

    @os_release_label.setter
    def os_release_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_release_label", value)

    @_builtins.property
    @pulumi.getter(name="placementGroupConfigs")
    def placement_group_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPlacementGroupConfigArgs']]]]:
        """
        The specified placement group configuration for an Amazon EMR cluster.
        """
        return pulumi.get(self, "placement_group_configs")

    @placement_group_configs.setter
    def placement_group_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPlacementGroupConfigArgs']]]]):
        pulumi.set(self, "placement_group_configs", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Release label for the Amazon EMR release.
        """
        return pulumi.get(self, "release_label")

    @release_label.setter
    def release_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_label", value)

    @_builtins.property
    @pulumi.getter(name="scaleDownBehavior")
    def scale_down_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
        """
        return pulumi.get(self, "scale_down_behavior")

    @scale_down_behavior.setter
    def scale_down_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scale_down_behavior", value)

    @_builtins.property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
        """
        return pulumi.get(self, "security_configuration")

    @security_configuration.setter
    def security_configuration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_configuration", value)

    @_builtins.property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IAM role that will be assumed by the Amazon EMR service to access AWS resources.

        The following arguments are optional:
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_role", value)

    @_builtins.property
    @pulumi.getter(name="stepConcurrencyLevel")
    def step_concurrency_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
        """
        return pulumi.get(self, "step_concurrency_level")

    @step_concurrency_level.setter
    def step_concurrency_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "step_concurrency_level", value)

    @_builtins.property
    @pulumi.getter
    def steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]]]:
        """
        List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]]]):
        pulumi.set(self, "steps", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "termination_protection", value)

    @_builtins.property
    @pulumi.getter(name="unhealthyNodeReplacement")
    def unhealthy_node_replacement(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether whether Amazon EMR should gracefully replace core nodes that have degraded within the cluster. Default value is `false`.
        """
        return pulumi.get(self, "unhealthy_node_replacement")

    @unhealthy_node_replacement.setter
    def unhealthy_node_replacement(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unhealthy_node_replacement", value)

    @_builtins.property
    @pulumi.getter(name="visibleToAllUsers")
    def visible_to_all_users(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.

        **NOTE:** As per the [Amazon EMR API Reference](https://docs.aws.amazon.com/emr/latest/APIReference/API_RunJobFlow.html#EMR-RunJobFlow-request-VisibleToAllUsers), this argument is no longer supported. Do not set this argument, particularly to `false`, as it would lead to perpetual differences.
        """
        return pulumi.get(self, "visible_to_all_users")

    @visible_to_all_users.setter
    def visible_to_all_users(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "visible_to_all_users", value)


@pulumi.type_token("aws:emr/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_info: Optional[pulumi.Input[_builtins.str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_termination_policy: Optional[pulumi.Input[Union['ClusterAutoTerminationPolicyArgs', 'ClusterAutoTerminationPolicyArgsDict']]] = None,
                 autoscaling_role: Optional[pulumi.Input[_builtins.str]] = None,
                 bootstrap_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterBootstrapActionArgs', 'ClusterBootstrapActionArgsDict']]]]] = None,
                 configurations: Optional[pulumi.Input[_builtins.str]] = None,
                 configurations_json: Optional[pulumi.Input[_builtins.str]] = None,
                 core_instance_fleet: Optional[pulumi.Input[Union['ClusterCoreInstanceFleetArgs', 'ClusterCoreInstanceFleetArgsDict']]] = None,
                 core_instance_group: Optional[pulumi.Input[Union['ClusterCoreInstanceGroupArgs', 'ClusterCoreInstanceGroupArgsDict']]] = None,
                 custom_ami_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ebs_root_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 ec2_attributes: Optional[pulumi.Input[Union['ClusterEc2AttributesArgs', 'ClusterEc2AttributesArgsDict']]] = None,
                 keep_job_flow_alive_when_no_steps: Optional[pulumi.Input[_builtins.bool]] = None,
                 kerberos_attributes: Optional[pulumi.Input[Union['ClusterKerberosAttributesArgs', 'ClusterKerberosAttributesArgsDict']]] = None,
                 list_steps_states: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_encryption_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 master_instance_fleet: Optional[pulumi.Input[Union['ClusterMasterInstanceFleetArgs', 'ClusterMasterInstanceFleetArgsDict']]] = None,
                 master_instance_group: Optional[pulumi.Input[Union['ClusterMasterInstanceGroupArgs', 'ClusterMasterInstanceGroupArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_release_label: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_group_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPlacementGroupConfigArgs', 'ClusterPlacementGroupConfigArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 release_label: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_down_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 security_configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 service_role: Optional[pulumi.Input[_builtins.str]] = None,
                 step_concurrency_level: Optional[pulumi.Input[_builtins.int]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterStepArgs', 'ClusterStepArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 unhealthy_node_replacement: Optional[pulumi.Input[_builtins.bool]] = None,
                 visible_to_all_users: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides an Elastic MapReduce Cluster, a web service that makes it easy to process large amounts of data efficiently. See [Amazon Elastic MapReduce Documentation](https://aws.amazon.com/documentation/elastic-mapreduce/) for more information.

        To configure [Instance Groups](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for [task nodes](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-task), see the `emr.InstanceGroup` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        cluster = aws.emr.Cluster("cluster",
            name="emr-test-arn",
            release_label="emr-4.6.0",
            applications=["Spark"],
            additional_info=\"\"\"{
          "instanceAwsClientConfiguration": {
            "proxyPort": 8099,
            "proxyHost": "myproxy.example.com"
          }
        }
        \"\"\",
            termination_protection=False,
            keep_job_flow_alive_when_no_steps=True,
            ec2_attributes={
                "subnet_id": main["id"],
                "emr_managed_master_security_group": sg["id"],
                "emr_managed_slave_security_group": sg["id"],
                "instance_profile": emr_profile["arn"],
            },
            master_instance_group={
                "instance_type": "m4.large",
            },
            core_instance_group={
                "instance_type": "c4.large",
                "instance_count": 1,
                "ebs_configs": [{
                    "size": 40,
                    "type": "gp2",
                    "volumes_per_instance": 1,
                }],
                "bid_price": "0.30",
                "autoscaling_policy": \"\"\"{
        "Constraints": {
          "MinCapacity": 1,
          "MaxCapacity": 2
        },
        "Rules": [
          {
            "Name": "ScaleOutMemoryPercentage",
            "Description": "Scale out if YARNMemoryAvailablePercentage is less than 15",
            "Action": {
              "SimpleScalingPolicyConfiguration": {
                "AdjustmentType": "CHANGE_IN_CAPACITY",
                "ScalingAdjustment": 1,
                "CoolDown": 300
              }
            },
            "Trigger": {
              "CloudWatchAlarmDefinition": {
                "ComparisonOperator": "LESS_THAN",
                "EvaluationPeriods": 1,
                "MetricName": "YARNMemoryAvailablePercentage",
                "Namespace": "AWS/ElasticMapReduce",
                "Period": 300,
                "Statistic": "AVERAGE",
                "Threshold": 15.0,
                "Unit": "PERCENT"
              }
            }
          }
        ]
        }
        \"\"\",
            },
            ebs_root_volume_size=100,
            tags={
                "role": "rolename",
                "env": "env",
            },
            bootstrap_actions=[{
                "path": "s3://elasticmapreduce/bootstrap-actions/run-if",
                "name": "runif",
                "args": [
                    "instance.isMaster=true",
                    "echo running on master node",
                ],
            }],
            configurations_json=\"\"\"  [
            {
              "Classification": "hadoop-env",
              "Configurations": [
                {
                  "Classification": "export",
                  "Properties": {
                    "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
                  }
                }
              ],
              "Properties": {}
            },
            {
              "Classification": "spark-env",
              "Configurations": [
                {
                  "Classification": "export",
                  "Properties": {
                    "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
                  }
                }
              ],
              "Properties": {}
            }
          ]
        \"\"\",
            service_role=iam_emr_service_role["arn"])
        ```

        The `emr.Cluster` resource typically requires two IAM roles, one for the EMR Cluster to use as a service role, and another is assigned to every EC2 instance in a cluster and each application process that runs on a cluster assumes this role for permissions to interact with other AWS services. An additional role, the Auto Scaling role, is required if your cluster uses automatic scaling in Amazon EMR.

        The default AWS managed EMR service role is called `EMR_DefaultRole` with Amazon managed policy `AmazonEMRServicePolicy_v2` attached. The name of default instance profile role is `EMR_EC2_DefaultRole` with default managed policy `AmazonElasticMapReduceforEC2Role` attached, but it is on the path to deprecation and will not be replaced with another default managed policy. You'll need to create and specify an instance profile to replace the deprecated role and default policy. See the [Configure IAM service roles for Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-iam-roles.html) guide for more information on these IAM roles. There is also a fully-bootable example Pulumi configuration at the bottom of this page.

        ### Instance Fleet

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emr.Cluster("example",
            master_instance_fleet={
                "instance_type_configs": [{
                    "instance_type": "m4.xlarge",
                }],
                "target_on_demand_capacity": 1,
            },
            core_instance_fleet={
                "instance_type_configs": [
                    {
                        "bid_price_as_percentage_of_on_demand_price": 80,
                        "ebs_configs": [{
                            "size": 100,
                            "type": "gp2",
                            "volumes_per_instance": 1,
                        }],
                        "instance_type": "m3.xlarge",
                        "weighted_capacity": 1,
                    },
                    {
                        "bid_price_as_percentage_of_on_demand_price": 100,
                        "ebs_configs": [{
                            "size": 100,
                            "type": "gp2",
                            "volumes_per_instance": 1,
                        }],
                        "instance_type": "m4.xlarge",
                        "weighted_capacity": 1,
                    },
                    {
                        "bid_price_as_percentage_of_on_demand_price": 100,
                        "ebs_configs": [{
                            "size": 100,
                            "type": "gp2",
                            "volumes_per_instance": 1,
                        }],
                        "instance_type": "m4.2xlarge",
                        "weighted_capacity": 2,
                    },
                ],
                "launch_specifications": {
                    "spot_specifications": [{
                        "allocation_strategy": "capacity-optimized",
                        "block_duration_minutes": 0,
                        "timeout_action": "SWITCH_TO_ON_DEMAND",
                        "timeout_duration_minutes": 10,
                    }],
                },
                "name": "core fleet",
                "target_on_demand_capacity": 2,
                "target_spot_capacity": 2,
            })
        task = aws.emr.InstanceFleet("task",
            cluster_id=example.id,
            instance_type_configs=[
                {
                    "bid_price_as_percentage_of_on_demand_price": 100,
                    "ebs_configs": [{
                        "size": 100,
                        "type": "gp2",
                        "volumes_per_instance": 1,
                    }],
                    "instance_type": "m4.xlarge",
                    "weighted_capacity": 1,
                },
                {
                    "bid_price_as_percentage_of_on_demand_price": 100,
                    "ebs_configs": [{
                        "size": 100,
                        "type": "gp2",
                        "volumes_per_instance": 1,
                    }],
                    "instance_type": "m4.2xlarge",
                    "weighted_capacity": 2,
                },
            ],
            launch_specifications={
                "spot_specifications": [{
                    "allocation_strategy": "capacity-optimized",
                    "block_duration_minutes": 0,
                    "timeout_action": "TERMINATE_CLUSTER",
                    "timeout_duration_minutes": 10,
                }],
            },
            name="task fleet",
            target_on_demand_capacity=1,
            target_spot_capacity=1)
        ```

        ### Enable Debug Logging

        [Debug logging in EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-debugging.html) is implemented as a step. It is highly recommended that you utilize the resource options configuration with `ignoreChanges` if other steps are being managed outside of this provider.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emr.Cluster("example", steps=[{
            "action_on_failure": "TERMINATE_CLUSTER",
            "name": "Setup Hadoop Debugging",
            "hadoop_jar_step": {
                "jar": "command-runner.jar",
                "args": ["state-pusher-script"],
            },
        }])
        ```

        ### Multiple Node Master Instance Group

        Available in EMR version 5.23.0 and later, an EMR Cluster can be launched with three master nodes for high availability. Additional information about this functionality and its requirements can be found in the [EMR Management Guide](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-ha.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        # This configuration is for illustrative purposes and highlights
        # only relevant configurations for working with this functionality.
        # Map public IP on launch must be enabled for public (Internet accessible) subnets
        example = aws.ec2.Subnet("example", map_public_ip_on_launch=True)
        example_cluster = aws.emr.Cluster("example",
            release_label="emr-5.24.1",
            termination_protection=True,
            ec2_attributes={
                "subnet_id": example.id,
            },
            master_instance_group={
                "instance_count": 3,
            },
            core_instance_group={})
        ```

        ## Import

        Using `pulumi import`, import EMR clusters using the `id`. For example:

        ```sh
        $ pulumi import aws:emr/cluster:Cluster cluster j-123456ABCDEF
        ```
        Since the API does not return the actual values for Kerberos configurations, environments with those options set will need to use the `lifecycle` configuration block `ignore_changes` argument available to all Pulumi resources to prevent perpetual differences. For example:

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] additional_info: JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore the provider cannot detect drift from the actual EMR cluster if its value is changed outside the provider.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
        :param pulumi.Input[Union['ClusterAutoTerminationPolicyArgs', 'ClusterAutoTerminationPolicyArgsDict']] auto_termination_policy: An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
        :param pulumi.Input[_builtins.str] autoscaling_role: IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterBootstrapActionArgs', 'ClusterBootstrapActionArgsDict']]]] bootstrap_actions: Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
        :param pulumi.Input[_builtins.str] configurations: List of configurations supplied for the EMR cluster you are creating. Supply a configuration object for applications to override their default configuration. See [AWS Documentation](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html) for more information.
        :param pulumi.Input[_builtins.str] configurations_json: JSON string for supplying list of configurations for the EMR cluster.
               
               > **NOTE on `configurations_json`:** If the `Configurations` value is empty then you should skip the `Configurations` field instead of providing an empty list as a value, `"Configurations": []`.
               
               ```python
               import pulumi
               import pulumi_aws as aws
               
               cluster = aws.emr.Cluster("cluster", configurations_json=\"\"\"[
               {
               "Classification": "hadoop-env",
               "Configurations": [
               {
               "Classification": "export",
               "Properties": {
               "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
               }
               }
               ],
               "Properties": {}
               }
               ]
               \"\"\")
               ```
        :param pulumi.Input[Union['ClusterCoreInstanceFleetArgs', 'ClusterCoreInstanceFleetArgsDict']] core_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input[Union['ClusterCoreInstanceGroupArgs', 'ClusterCoreInstanceGroupArgsDict']] core_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
        :param pulumi.Input[_builtins.str] custom_ami_id: Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
        :param pulumi.Input[_builtins.int] ebs_root_volume_size: Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
        :param pulumi.Input[Union['ClusterEc2AttributesArgs', 'ClusterEc2AttributesArgsDict']] ec2_attributes: Attributes for the EC2 instances running the job flow. See below.
        :param pulumi.Input[_builtins.bool] keep_job_flow_alive_when_no_steps: Switch on/off run cluster with no steps or when all steps are complete (default is on)
        :param pulumi.Input[Union['ClusterKerberosAttributesArgs', 'ClusterKerberosAttributesArgsDict']] kerberos_attributes: Kerberos configuration for the cluster. See below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] list_steps_states: List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
        :param pulumi.Input[_builtins.str] log_encryption_kms_key_id: AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
        :param pulumi.Input[_builtins.str] log_uri: S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
        :param pulumi.Input[Union['ClusterMasterInstanceFleetArgs', 'ClusterMasterInstanceFleetArgsDict']] master_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input[Union['ClusterMasterInstanceGroupArgs', 'ClusterMasterInstanceGroupArgsDict']] master_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
        :param pulumi.Input[_builtins.str] name: Name of the job flow.
        :param pulumi.Input[_builtins.str] os_release_label: Amazon Linux release for all nodes in a cluster launch RunJobFlow request. If not specified, Amazon EMR uses the latest validated Amazon Linux release for cluster launch.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPlacementGroupConfigArgs', 'ClusterPlacementGroupConfigArgsDict']]]] placement_group_configs: The specified placement group configuration for an Amazon EMR cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] release_label: Release label for the Amazon EMR release.
        :param pulumi.Input[_builtins.str] scale_down_behavior: Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
        :param pulumi.Input[_builtins.str] security_configuration: Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
        :param pulumi.Input[_builtins.str] service_role: IAM role that will be assumed by the Amazon EMR service to access AWS resources.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] step_concurrency_level: Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterStepArgs', 'ClusterStepArgsDict']]]] steps: List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.bool] termination_protection: Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
        :param pulumi.Input[_builtins.bool] unhealthy_node_replacement: Whether whether Amazon EMR should gracefully replace core nodes that have degraded within the cluster. Default value is `false`.
        :param pulumi.Input[_builtins.bool] visible_to_all_users: Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
               
               **NOTE:** As per the [Amazon EMR API Reference](https://docs.aws.amazon.com/emr/latest/APIReference/API_RunJobFlow.html#EMR-RunJobFlow-request-VisibleToAllUsers), this argument is no longer supported. Do not set this argument, particularly to `false`, as it would lead to perpetual differences.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Elastic MapReduce Cluster, a web service that makes it easy to process large amounts of data efficiently. See [Amazon Elastic MapReduce Documentation](https://aws.amazon.com/documentation/elastic-mapreduce/) for more information.

        To configure [Instance Groups](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for [task nodes](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-task), see the `emr.InstanceGroup` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        cluster = aws.emr.Cluster("cluster",
            name="emr-test-arn",
            release_label="emr-4.6.0",
            applications=["Spark"],
            additional_info=\"\"\"{
          "instanceAwsClientConfiguration": {
            "proxyPort": 8099,
            "proxyHost": "myproxy.example.com"
          }
        }
        \"\"\",
            termination_protection=False,
            keep_job_flow_alive_when_no_steps=True,
            ec2_attributes={
                "subnet_id": main["id"],
                "emr_managed_master_security_group": sg["id"],
                "emr_managed_slave_security_group": sg["id"],
                "instance_profile": emr_profile["arn"],
            },
            master_instance_group={
                "instance_type": "m4.large",
            },
            core_instance_group={
                "instance_type": "c4.large",
                "instance_count": 1,
                "ebs_configs": [{
                    "size": 40,
                    "type": "gp2",
                    "volumes_per_instance": 1,
                }],
                "bid_price": "0.30",
                "autoscaling_policy": \"\"\"{
        "Constraints": {
          "MinCapacity": 1,
          "MaxCapacity": 2
        },
        "Rules": [
          {
            "Name": "ScaleOutMemoryPercentage",
            "Description": "Scale out if YARNMemoryAvailablePercentage is less than 15",
            "Action": {
              "SimpleScalingPolicyConfiguration": {
                "AdjustmentType": "CHANGE_IN_CAPACITY",
                "ScalingAdjustment": 1,
                "CoolDown": 300
              }
            },
            "Trigger": {
              "CloudWatchAlarmDefinition": {
                "ComparisonOperator": "LESS_THAN",
                "EvaluationPeriods": 1,
                "MetricName": "YARNMemoryAvailablePercentage",
                "Namespace": "AWS/ElasticMapReduce",
                "Period": 300,
                "Statistic": "AVERAGE",
                "Threshold": 15.0,
                "Unit": "PERCENT"
              }
            }
          }
        ]
        }
        \"\"\",
            },
            ebs_root_volume_size=100,
            tags={
                "role": "rolename",
                "env": "env",
            },
            bootstrap_actions=[{
                "path": "s3://elasticmapreduce/bootstrap-actions/run-if",
                "name": "runif",
                "args": [
                    "instance.isMaster=true",
                    "echo running on master node",
                ],
            }],
            configurations_json=\"\"\"  [
            {
              "Classification": "hadoop-env",
              "Configurations": [
                {
                  "Classification": "export",
                  "Properties": {
                    "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
                  }
                }
              ],
              "Properties": {}
            },
            {
              "Classification": "spark-env",
              "Configurations": [
                {
                  "Classification": "export",
                  "Properties": {
                    "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
                  }
                }
              ],
              "Properties": {}
            }
          ]
        \"\"\",
            service_role=iam_emr_service_role["arn"])
        ```

        The `emr.Cluster` resource typically requires two IAM roles, one for the EMR Cluster to use as a service role, and another is assigned to every EC2 instance in a cluster and each application process that runs on a cluster assumes this role for permissions to interact with other AWS services. An additional role, the Auto Scaling role, is required if your cluster uses automatic scaling in Amazon EMR.

        The default AWS managed EMR service role is called `EMR_DefaultRole` with Amazon managed policy `AmazonEMRServicePolicy_v2` attached. The name of default instance profile role is `EMR_EC2_DefaultRole` with default managed policy `AmazonElasticMapReduceforEC2Role` attached, but it is on the path to deprecation and will not be replaced with another default managed policy. You'll need to create and specify an instance profile to replace the deprecated role and default policy. See the [Configure IAM service roles for Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-iam-roles.html) guide for more information on these IAM roles. There is also a fully-bootable example Pulumi configuration at the bottom of this page.

        ### Instance Fleet

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emr.Cluster("example",
            master_instance_fleet={
                "instance_type_configs": [{
                    "instance_type": "m4.xlarge",
                }],
                "target_on_demand_capacity": 1,
            },
            core_instance_fleet={
                "instance_type_configs": [
                    {
                        "bid_price_as_percentage_of_on_demand_price": 80,
                        "ebs_configs": [{
                            "size": 100,
                            "type": "gp2",
                            "volumes_per_instance": 1,
                        }],
                        "instance_type": "m3.xlarge",
                        "weighted_capacity": 1,
                    },
                    {
                        "bid_price_as_percentage_of_on_demand_price": 100,
                        "ebs_configs": [{
                            "size": 100,
                            "type": "gp2",
                            "volumes_per_instance": 1,
                        }],
                        "instance_type": "m4.xlarge",
                        "weighted_capacity": 1,
                    },
                    {
                        "bid_price_as_percentage_of_on_demand_price": 100,
                        "ebs_configs": [{
                            "size": 100,
                            "type": "gp2",
                            "volumes_per_instance": 1,
                        }],
                        "instance_type": "m4.2xlarge",
                        "weighted_capacity": 2,
                    },
                ],
                "launch_specifications": {
                    "spot_specifications": [{
                        "allocation_strategy": "capacity-optimized",
                        "block_duration_minutes": 0,
                        "timeout_action": "SWITCH_TO_ON_DEMAND",
                        "timeout_duration_minutes": 10,
                    }],
                },
                "name": "core fleet",
                "target_on_demand_capacity": 2,
                "target_spot_capacity": 2,
            })
        task = aws.emr.InstanceFleet("task",
            cluster_id=example.id,
            instance_type_configs=[
                {
                    "bid_price_as_percentage_of_on_demand_price": 100,
                    "ebs_configs": [{
                        "size": 100,
                        "type": "gp2",
                        "volumes_per_instance": 1,
                    }],
                    "instance_type": "m4.xlarge",
                    "weighted_capacity": 1,
                },
                {
                    "bid_price_as_percentage_of_on_demand_price": 100,
                    "ebs_configs": [{
                        "size": 100,
                        "type": "gp2",
                        "volumes_per_instance": 1,
                    }],
                    "instance_type": "m4.2xlarge",
                    "weighted_capacity": 2,
                },
            ],
            launch_specifications={
                "spot_specifications": [{
                    "allocation_strategy": "capacity-optimized",
                    "block_duration_minutes": 0,
                    "timeout_action": "TERMINATE_CLUSTER",
                    "timeout_duration_minutes": 10,
                }],
            },
            name="task fleet",
            target_on_demand_capacity=1,
            target_spot_capacity=1)
        ```

        ### Enable Debug Logging

        [Debug logging in EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-debugging.html) is implemented as a step. It is highly recommended that you utilize the resource options configuration with `ignoreChanges` if other steps are being managed outside of this provider.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emr.Cluster("example", steps=[{
            "action_on_failure": "TERMINATE_CLUSTER",
            "name": "Setup Hadoop Debugging",
            "hadoop_jar_step": {
                "jar": "command-runner.jar",
                "args": ["state-pusher-script"],
            },
        }])
        ```

        ### Multiple Node Master Instance Group

        Available in EMR version 5.23.0 and later, an EMR Cluster can be launched with three master nodes for high availability. Additional information about this functionality and its requirements can be found in the [EMR Management Guide](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-ha.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        # This configuration is for illustrative purposes and highlights
        # only relevant configurations for working with this functionality.
        # Map public IP on launch must be enabled for public (Internet accessible) subnets
        example = aws.ec2.Subnet("example", map_public_ip_on_launch=True)
        example_cluster = aws.emr.Cluster("example",
            release_label="emr-5.24.1",
            termination_protection=True,
            ec2_attributes={
                "subnet_id": example.id,
            },
            master_instance_group={
                "instance_count": 3,
            },
            core_instance_group={})
        ```

        ## Import

        Using `pulumi import`, import EMR clusters using the `id`. For example:

        ```sh
        $ pulumi import aws:emr/cluster:Cluster cluster j-123456ABCDEF
        ```
        Since the API does not return the actual values for Kerberos configurations, environments with those options set will need to use the `lifecycle` configuration block `ignore_changes` argument available to all Pulumi resources to prevent perpetual differences. For example:

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_info: Optional[pulumi.Input[_builtins.str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_termination_policy: Optional[pulumi.Input[Union['ClusterAutoTerminationPolicyArgs', 'ClusterAutoTerminationPolicyArgsDict']]] = None,
                 autoscaling_role: Optional[pulumi.Input[_builtins.str]] = None,
                 bootstrap_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterBootstrapActionArgs', 'ClusterBootstrapActionArgsDict']]]]] = None,
                 configurations: Optional[pulumi.Input[_builtins.str]] = None,
                 configurations_json: Optional[pulumi.Input[_builtins.str]] = None,
                 core_instance_fleet: Optional[pulumi.Input[Union['ClusterCoreInstanceFleetArgs', 'ClusterCoreInstanceFleetArgsDict']]] = None,
                 core_instance_group: Optional[pulumi.Input[Union['ClusterCoreInstanceGroupArgs', 'ClusterCoreInstanceGroupArgsDict']]] = None,
                 custom_ami_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ebs_root_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 ec2_attributes: Optional[pulumi.Input[Union['ClusterEc2AttributesArgs', 'ClusterEc2AttributesArgsDict']]] = None,
                 keep_job_flow_alive_when_no_steps: Optional[pulumi.Input[_builtins.bool]] = None,
                 kerberos_attributes: Optional[pulumi.Input[Union['ClusterKerberosAttributesArgs', 'ClusterKerberosAttributesArgsDict']]] = None,
                 list_steps_states: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_encryption_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 master_instance_fleet: Optional[pulumi.Input[Union['ClusterMasterInstanceFleetArgs', 'ClusterMasterInstanceFleetArgsDict']]] = None,
                 master_instance_group: Optional[pulumi.Input[Union['ClusterMasterInstanceGroupArgs', 'ClusterMasterInstanceGroupArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_release_label: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_group_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPlacementGroupConfigArgs', 'ClusterPlacementGroupConfigArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 release_label: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_down_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 security_configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 service_role: Optional[pulumi.Input[_builtins.str]] = None,
                 step_concurrency_level: Optional[pulumi.Input[_builtins.int]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterStepArgs', 'ClusterStepArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 unhealthy_node_replacement: Optional[pulumi.Input[_builtins.bool]] = None,
                 visible_to_all_users: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["additional_info"] = additional_info
            __props__.__dict__["applications"] = applications
            __props__.__dict__["auto_termination_policy"] = auto_termination_policy
            __props__.__dict__["autoscaling_role"] = autoscaling_role
            __props__.__dict__["bootstrap_actions"] = bootstrap_actions
            __props__.__dict__["configurations"] = configurations
            __props__.__dict__["configurations_json"] = configurations_json
            __props__.__dict__["core_instance_fleet"] = core_instance_fleet
            __props__.__dict__["core_instance_group"] = core_instance_group
            __props__.__dict__["custom_ami_id"] = custom_ami_id
            __props__.__dict__["ebs_root_volume_size"] = ebs_root_volume_size
            __props__.__dict__["ec2_attributes"] = ec2_attributes
            __props__.__dict__["keep_job_flow_alive_when_no_steps"] = keep_job_flow_alive_when_no_steps
            __props__.__dict__["kerberos_attributes"] = kerberos_attributes
            __props__.__dict__["list_steps_states"] = list_steps_states
            __props__.__dict__["log_encryption_kms_key_id"] = log_encryption_kms_key_id
            __props__.__dict__["log_uri"] = log_uri
            __props__.__dict__["master_instance_fleet"] = master_instance_fleet
            __props__.__dict__["master_instance_group"] = master_instance_group
            __props__.__dict__["name"] = name
            __props__.__dict__["os_release_label"] = os_release_label
            __props__.__dict__["placement_group_configs"] = placement_group_configs
            __props__.__dict__["region"] = region
            if release_label is None and not opts.urn:
                raise TypeError("Missing required property 'release_label'")
            __props__.__dict__["release_label"] = release_label
            __props__.__dict__["scale_down_behavior"] = scale_down_behavior
            __props__.__dict__["security_configuration"] = security_configuration
            if service_role is None and not opts.urn:
                raise TypeError("Missing required property 'service_role'")
            __props__.__dict__["service_role"] = service_role
            __props__.__dict__["step_concurrency_level"] = step_concurrency_level
            __props__.__dict__["steps"] = steps
            __props__.__dict__["tags"] = tags
            __props__.__dict__["termination_protection"] = termination_protection
            __props__.__dict__["unhealthy_node_replacement"] = unhealthy_node_replacement
            __props__.__dict__["visible_to_all_users"] = visible_to_all_users
            __props__.__dict__["arn"] = None
            __props__.__dict__["cluster_state"] = None
            __props__.__dict__["master_public_dns"] = None
            __props__.__dict__["tags_all"] = None
        super(Cluster, __self__).__init__(
            'aws:emr/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_info: Optional[pulumi.Input[_builtins.str]] = None,
            applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            auto_termination_policy: Optional[pulumi.Input[Union['ClusterAutoTerminationPolicyArgs', 'ClusterAutoTerminationPolicyArgsDict']]] = None,
            autoscaling_role: Optional[pulumi.Input[_builtins.str]] = None,
            bootstrap_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterBootstrapActionArgs', 'ClusterBootstrapActionArgsDict']]]]] = None,
            cluster_state: Optional[pulumi.Input[_builtins.str]] = None,
            configurations: Optional[pulumi.Input[_builtins.str]] = None,
            configurations_json: Optional[pulumi.Input[_builtins.str]] = None,
            core_instance_fleet: Optional[pulumi.Input[Union['ClusterCoreInstanceFleetArgs', 'ClusterCoreInstanceFleetArgsDict']]] = None,
            core_instance_group: Optional[pulumi.Input[Union['ClusterCoreInstanceGroupArgs', 'ClusterCoreInstanceGroupArgsDict']]] = None,
            custom_ami_id: Optional[pulumi.Input[_builtins.str]] = None,
            ebs_root_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
            ec2_attributes: Optional[pulumi.Input[Union['ClusterEc2AttributesArgs', 'ClusterEc2AttributesArgsDict']]] = None,
            keep_job_flow_alive_when_no_steps: Optional[pulumi.Input[_builtins.bool]] = None,
            kerberos_attributes: Optional[pulumi.Input[Union['ClusterKerberosAttributesArgs', 'ClusterKerberosAttributesArgsDict']]] = None,
            list_steps_states: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            log_encryption_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            log_uri: Optional[pulumi.Input[_builtins.str]] = None,
            master_instance_fleet: Optional[pulumi.Input[Union['ClusterMasterInstanceFleetArgs', 'ClusterMasterInstanceFleetArgsDict']]] = None,
            master_instance_group: Optional[pulumi.Input[Union['ClusterMasterInstanceGroupArgs', 'ClusterMasterInstanceGroupArgsDict']]] = None,
            master_public_dns: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            os_release_label: Optional[pulumi.Input[_builtins.str]] = None,
            placement_group_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPlacementGroupConfigArgs', 'ClusterPlacementGroupConfigArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            release_label: Optional[pulumi.Input[_builtins.str]] = None,
            scale_down_behavior: Optional[pulumi.Input[_builtins.str]] = None,
            security_configuration: Optional[pulumi.Input[_builtins.str]] = None,
            service_role: Optional[pulumi.Input[_builtins.str]] = None,
            step_concurrency_level: Optional[pulumi.Input[_builtins.int]] = None,
            steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterStepArgs', 'ClusterStepArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            termination_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            unhealthy_node_replacement: Optional[pulumi.Input[_builtins.bool]] = None,
            visible_to_all_users: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] additional_info: JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore the provider cannot detect drift from the actual EMR cluster if its value is changed outside the provider.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
        :param pulumi.Input[_builtins.str] arn: ARN of the cluster.
        :param pulumi.Input[Union['ClusterAutoTerminationPolicyArgs', 'ClusterAutoTerminationPolicyArgsDict']] auto_termination_policy: An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
        :param pulumi.Input[_builtins.str] autoscaling_role: IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterBootstrapActionArgs', 'ClusterBootstrapActionArgsDict']]]] bootstrap_actions: Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
        :param pulumi.Input[_builtins.str] configurations: List of configurations supplied for the EMR cluster you are creating. Supply a configuration object for applications to override their default configuration. See [AWS Documentation](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html) for more information.
        :param pulumi.Input[_builtins.str] configurations_json: JSON string for supplying list of configurations for the EMR cluster.
               
               > **NOTE on `configurations_json`:** If the `Configurations` value is empty then you should skip the `Configurations` field instead of providing an empty list as a value, `"Configurations": []`.
               
               ```python
               import pulumi
               import pulumi_aws as aws
               
               cluster = aws.emr.Cluster("cluster", configurations_json=\"\"\"[
               {
               "Classification": "hadoop-env",
               "Configurations": [
               {
               "Classification": "export",
               "Properties": {
               "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
               }
               }
               ],
               "Properties": {}
               }
               ]
               \"\"\")
               ```
        :param pulumi.Input[Union['ClusterCoreInstanceFleetArgs', 'ClusterCoreInstanceFleetArgsDict']] core_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input[Union['ClusterCoreInstanceGroupArgs', 'ClusterCoreInstanceGroupArgsDict']] core_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
        :param pulumi.Input[_builtins.str] custom_ami_id: Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
        :param pulumi.Input[_builtins.int] ebs_root_volume_size: Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
        :param pulumi.Input[Union['ClusterEc2AttributesArgs', 'ClusterEc2AttributesArgsDict']] ec2_attributes: Attributes for the EC2 instances running the job flow. See below.
        :param pulumi.Input[_builtins.bool] keep_job_flow_alive_when_no_steps: Switch on/off run cluster with no steps or when all steps are complete (default is on)
        :param pulumi.Input[Union['ClusterKerberosAttributesArgs', 'ClusterKerberosAttributesArgsDict']] kerberos_attributes: Kerberos configuration for the cluster. See below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] list_steps_states: List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
        :param pulumi.Input[_builtins.str] log_encryption_kms_key_id: AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
        :param pulumi.Input[_builtins.str] log_uri: S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
        :param pulumi.Input[Union['ClusterMasterInstanceFleetArgs', 'ClusterMasterInstanceFleetArgsDict']] master_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input[Union['ClusterMasterInstanceGroupArgs', 'ClusterMasterInstanceGroupArgsDict']] master_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
        :param pulumi.Input[_builtins.str] master_public_dns: The DNS name of the master node. If the cluster is on a private subnet, this is the private DNS name. On a public subnet, this is the public DNS name.
        :param pulumi.Input[_builtins.str] name: Name of the job flow.
        :param pulumi.Input[_builtins.str] os_release_label: Amazon Linux release for all nodes in a cluster launch RunJobFlow request. If not specified, Amazon EMR uses the latest validated Amazon Linux release for cluster launch.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPlacementGroupConfigArgs', 'ClusterPlacementGroupConfigArgsDict']]]] placement_group_configs: The specified placement group configuration for an Amazon EMR cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] release_label: Release label for the Amazon EMR release.
        :param pulumi.Input[_builtins.str] scale_down_behavior: Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
        :param pulumi.Input[_builtins.str] security_configuration: Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
        :param pulumi.Input[_builtins.str] service_role: IAM role that will be assumed by the Amazon EMR service to access AWS resources.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] step_concurrency_level: Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterStepArgs', 'ClusterStepArgsDict']]]] steps: List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] termination_protection: Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
        :param pulumi.Input[_builtins.bool] unhealthy_node_replacement: Whether whether Amazon EMR should gracefully replace core nodes that have degraded within the cluster. Default value is `false`.
        :param pulumi.Input[_builtins.bool] visible_to_all_users: Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
               
               **NOTE:** As per the [Amazon EMR API Reference](https://docs.aws.amazon.com/emr/latest/APIReference/API_RunJobFlow.html#EMR-RunJobFlow-request-VisibleToAllUsers), this argument is no longer supported. Do not set this argument, particularly to `false`, as it would lead to perpetual differences.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["additional_info"] = additional_info
        __props__.__dict__["applications"] = applications
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_termination_policy"] = auto_termination_policy
        __props__.__dict__["autoscaling_role"] = autoscaling_role
        __props__.__dict__["bootstrap_actions"] = bootstrap_actions
        __props__.__dict__["cluster_state"] = cluster_state
        __props__.__dict__["configurations"] = configurations
        __props__.__dict__["configurations_json"] = configurations_json
        __props__.__dict__["core_instance_fleet"] = core_instance_fleet
        __props__.__dict__["core_instance_group"] = core_instance_group
        __props__.__dict__["custom_ami_id"] = custom_ami_id
        __props__.__dict__["ebs_root_volume_size"] = ebs_root_volume_size
        __props__.__dict__["ec2_attributes"] = ec2_attributes
        __props__.__dict__["keep_job_flow_alive_when_no_steps"] = keep_job_flow_alive_when_no_steps
        __props__.__dict__["kerberos_attributes"] = kerberos_attributes
        __props__.__dict__["list_steps_states"] = list_steps_states
        __props__.__dict__["log_encryption_kms_key_id"] = log_encryption_kms_key_id
        __props__.__dict__["log_uri"] = log_uri
        __props__.__dict__["master_instance_fleet"] = master_instance_fleet
        __props__.__dict__["master_instance_group"] = master_instance_group
        __props__.__dict__["master_public_dns"] = master_public_dns
        __props__.__dict__["name"] = name
        __props__.__dict__["os_release_label"] = os_release_label
        __props__.__dict__["placement_group_configs"] = placement_group_configs
        __props__.__dict__["region"] = region
        __props__.__dict__["release_label"] = release_label
        __props__.__dict__["scale_down_behavior"] = scale_down_behavior
        __props__.__dict__["security_configuration"] = security_configuration
        __props__.__dict__["service_role"] = service_role
        __props__.__dict__["step_concurrency_level"] = step_concurrency_level
        __props__.__dict__["steps"] = steps
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["termination_protection"] = termination_protection
        __props__.__dict__["unhealthy_node_replacement"] = unhealthy_node_replacement
        __props__.__dict__["visible_to_all_users"] = visible_to_all_users
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore the provider cannot detect drift from the actual EMR cluster if its value is changed outside the provider.
        """
        return pulumi.get(self, "additional_info")

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the cluster.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="autoTerminationPolicy")
    def auto_termination_policy(self) -> pulumi.Output[Optional['outputs.ClusterAutoTerminationPolicy']]:
        """
        An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
        """
        return pulumi.get(self, "auto_termination_policy")

    @_builtins.property
    @pulumi.getter(name="autoscalingRole")
    def autoscaling_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
        """
        return pulumi.get(self, "autoscaling_role")

    @_builtins.property
    @pulumi.getter(name="bootstrapActions")
    def bootstrap_actions(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterBootstrapAction']]]:
        """
        Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
        """
        return pulumi.get(self, "bootstrap_actions")

    @_builtins.property
    @pulumi.getter(name="clusterState")
    def cluster_state(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cluster_state")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        List of configurations supplied for the EMR cluster you are creating. Supply a configuration object for applications to override their default configuration. See [AWS Documentation](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html) for more information.
        """
        return pulumi.get(self, "configurations")

    @_builtins.property
    @pulumi.getter(name="configurationsJson")
    def configurations_json(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        JSON string for supplying list of configurations for the EMR cluster.

        > **NOTE on `configurations_json`:** If the `Configurations` value is empty then you should skip the `Configurations` field instead of providing an empty list as a value, `"Configurations": []`.

        ```python
        import pulumi
        import pulumi_aws as aws

        cluster = aws.emr.Cluster("cluster", configurations_json=\"\"\"[
        {
        "Classification": "hadoop-env",
        "Configurations": [
        {
        "Classification": "export",
        "Properties": {
        "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
        }
        }
        ],
        "Properties": {}
        }
        ]
        \"\"\")
        ```
        """
        return pulumi.get(self, "configurations_json")

    @_builtins.property
    @pulumi.getter(name="coreInstanceFleet")
    def core_instance_fleet(self) -> pulumi.Output['outputs.ClusterCoreInstanceFleet']:
        """
        Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
        """
        return pulumi.get(self, "core_instance_fleet")

    @_builtins.property
    @pulumi.getter(name="coreInstanceGroup")
    def core_instance_group(self) -> pulumi.Output['outputs.ClusterCoreInstanceGroup']:
        """
        Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
        """
        return pulumi.get(self, "core_instance_group")

    @_builtins.property
    @pulumi.getter(name="customAmiId")
    def custom_ami_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
        """
        return pulumi.get(self, "custom_ami_id")

    @_builtins.property
    @pulumi.getter(name="ebsRootVolumeSize")
    def ebs_root_volume_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
        """
        return pulumi.get(self, "ebs_root_volume_size")

    @_builtins.property
    @pulumi.getter(name="ec2Attributes")
    def ec2_attributes(self) -> pulumi.Output[Optional['outputs.ClusterEc2Attributes']]:
        """
        Attributes for the EC2 instances running the job flow. See below.
        """
        return pulumi.get(self, "ec2_attributes")

    @_builtins.property
    @pulumi.getter(name="keepJobFlowAliveWhenNoSteps")
    def keep_job_flow_alive_when_no_steps(self) -> pulumi.Output[_builtins.bool]:
        """
        Switch on/off run cluster with no steps or when all steps are complete (default is on)
        """
        return pulumi.get(self, "keep_job_flow_alive_when_no_steps")

    @_builtins.property
    @pulumi.getter(name="kerberosAttributes")
    def kerberos_attributes(self) -> pulumi.Output[Optional['outputs.ClusterKerberosAttributes']]:
        """
        Kerberos configuration for the cluster. See below.
        """
        return pulumi.get(self, "kerberos_attributes")

    @_builtins.property
    @pulumi.getter(name="listStepsStates")
    def list_steps_states(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
        """
        return pulumi.get(self, "list_steps_states")

    @_builtins.property
    @pulumi.getter(name="logEncryptionKmsKeyId")
    def log_encryption_kms_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
        """
        return pulumi.get(self, "log_encryption_kms_key_id")

    @_builtins.property
    @pulumi.getter(name="logUri")
    def log_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
        """
        return pulumi.get(self, "log_uri")

    @_builtins.property
    @pulumi.getter(name="masterInstanceFleet")
    def master_instance_fleet(self) -> pulumi.Output['outputs.ClusterMasterInstanceFleet']:
        """
        Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
        """
        return pulumi.get(self, "master_instance_fleet")

    @_builtins.property
    @pulumi.getter(name="masterInstanceGroup")
    def master_instance_group(self) -> pulumi.Output['outputs.ClusterMasterInstanceGroup']:
        """
        Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
        """
        return pulumi.get(self, "master_instance_group")

    @_builtins.property
    @pulumi.getter(name="masterPublicDns")
    def master_public_dns(self) -> pulumi.Output[_builtins.str]:
        """
        The DNS name of the master node. If the cluster is on a private subnet, this is the private DNS name. On a public subnet, this is the public DNS name.
        """
        return pulumi.get(self, "master_public_dns")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the job flow.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osReleaseLabel")
    def os_release_label(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Amazon Linux release for all nodes in a cluster launch RunJobFlow request. If not specified, Amazon EMR uses the latest validated Amazon Linux release for cluster launch.
        """
        return pulumi.get(self, "os_release_label")

    @_builtins.property
    @pulumi.getter(name="placementGroupConfigs")
    def placement_group_configs(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterPlacementGroupConfig']]]:
        """
        The specified placement group configuration for an Amazon EMR cluster.
        """
        return pulumi.get(self, "placement_group_configs")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> pulumi.Output[_builtins.str]:
        """
        Release label for the Amazon EMR release.
        """
        return pulumi.get(self, "release_label")

    @_builtins.property
    @pulumi.getter(name="scaleDownBehavior")
    def scale_down_behavior(self) -> pulumi.Output[_builtins.str]:
        """
        Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
        """
        return pulumi.get(self, "scale_down_behavior")

    @_builtins.property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
        """
        return pulumi.get(self, "security_configuration")

    @_builtins.property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> pulumi.Output[_builtins.str]:
        """
        IAM role that will be assumed by the Amazon EMR service to access AWS resources.

        The following arguments are optional:
        """
        return pulumi.get(self, "service_role")

    @_builtins.property
    @pulumi.getter(name="stepConcurrencyLevel")
    def step_concurrency_level(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
        """
        return pulumi.get(self, "step_concurrency_level")

    @_builtins.property
    @pulumi.getter
    def steps(self) -> pulumi.Output[Sequence['outputs.ClusterStep']]:
        """
        List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
        """
        return pulumi.get(self, "steps")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
        """
        return pulumi.get(self, "termination_protection")

    @_builtins.property
    @pulumi.getter(name="unhealthyNodeReplacement")
    def unhealthy_node_replacement(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether whether Amazon EMR should gracefully replace core nodes that have degraded within the cluster. Default value is `false`.
        """
        return pulumi.get(self, "unhealthy_node_replacement")

    @_builtins.property
    @pulumi.getter(name="visibleToAllUsers")
    def visible_to_all_users(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.

        **NOTE:** As per the [Amazon EMR API Reference](https://docs.aws.amazon.com/emr/latest/APIReference/API_RunJobFlow.html#EMR-RunJobFlow-request-VisibleToAllUsers), this argument is no longer supported. Do not set this argument, particularly to `false`, as it would lead to perpetual differences.
        """
        return pulumi.get(self, "visible_to_all_users")

