# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetServicePrincipalResult',
    'AwaitableGetServicePrincipalResult',
    'get_service_principal',
    'get_service_principal_output',
]

@pulumi.output_type
class GetServicePrincipalResult:
    """
    A collection of values returned by getServicePrincipal.
    """
    def __init__(__self__, id=None, name=None, region=None, service_name=None, suffix=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if suffix and not isinstance(suffix, str):
            raise TypeError("Expected argument 'suffix' to be a str")
        pulumi.set(__self__, "suffix", suffix)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier of the current Service Principal (compound of service, Region and suffix). (e.g. `logs.us-east-1.amazonaws.com`in AWS Commercial, `logs.cn-north-1.amazonaws.com.cn` in AWS China).
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Service Principal Name (e.g., `logs.amazonaws.com` in AWS Commercial, `logs.amazonaws.com.cn` in AWS China).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def suffix(self) -> _builtins.str:
        """
        Suffix of the SPN (e.g., `amazonaws.com` in AWS Commercial, `amazonaws.com.cn` in AWS China).
        """
        return pulumi.get(self, "suffix")


class AwaitableGetServicePrincipalResult(GetServicePrincipalResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServicePrincipalResult(
            id=self.id,
            name=self.name,
            region=self.region,
            service_name=self.service_name,
            suffix=self.suffix)


def get_service_principal(region: Optional[_builtins.str] = None,
                          service_name: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServicePrincipalResult:
    """
    Use this data source to create a Service Principal Name for a service in a given region. Service Principal Names should always end in the standard global format: `{servicename}.amazonaws.com`. However, in some AWS partitions, AWS may expect a different format.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    current = aws.get_service_principal(service_name="s3")
    test = aws.get_service_principal(service_name="s3",
        region="us-iso-east-1")
    ```


    :param _builtins.str region: Region you'd like the SPN for. Defaults to the Region set in the provider configuration.
    :param _builtins.str service_name: Name of the service you want to generate a Service Principal Name for.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:index/getServicePrincipal:getServicePrincipal', __args__, opts=opts, typ=GetServicePrincipalResult).value

    return AwaitableGetServicePrincipalResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        service_name=pulumi.get(__ret__, 'service_name'),
        suffix=pulumi.get(__ret__, 'suffix'))
def get_service_principal_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServicePrincipalResult]:
    """
    Use this data source to create a Service Principal Name for a service in a given region. Service Principal Names should always end in the standard global format: `{servicename}.amazonaws.com`. However, in some AWS partitions, AWS may expect a different format.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    current = aws.get_service_principal(service_name="s3")
    test = aws.get_service_principal(service_name="s3",
        region="us-iso-east-1")
    ```


    :param _builtins.str region: Region you'd like the SPN for. Defaults to the Region set in the provider configuration.
    :param _builtins.str service_name: Name of the service you want to generate a Service Principal Name for.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:index/getServicePrincipal:getServicePrincipal', __args__, opts=opts, typ=GetServicePrincipalResult)
    return __ret__.apply(lambda __response__: GetServicePrincipalResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        service_name=pulumi.get(__response__, 'service_name'),
        suffix=pulumi.get(__response__, 'suffix')))
