# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CatalogTableOptimizerArgs', 'CatalogTableOptimizer']

@pulumi.input_type
class CatalogTableOptimizerArgs:
    def __init__(__self__, *,
                 catalog_id: pulumi.Input[_builtins.str],
                 database_name: pulumi.Input[_builtins.str],
                 table_name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 configuration: Optional[pulumi.Input['CatalogTableOptimizerConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CatalogTableOptimizer resource.
        :param pulumi.Input[_builtins.str] catalog_id: The Catalog ID of the table.
        :param pulumi.Input[_builtins.str] database_name: The name of the database in the catalog in which the table resides.
        :param pulumi.Input[_builtins.str] table_name: The name of the table.
        :param pulumi.Input[_builtins.str] type: The type of table optimizer. Valid values are `compaction`, `retention`, and `orphan_file_deletion`.
        :param pulumi.Input['CatalogTableOptimizerConfigurationArgs'] configuration: A configuration block that defines the table optimizer settings. See Configuration for additional details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "type", type)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Catalog ID of the table.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "catalog_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the database in the catalog in which the table resides.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the table.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "table_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of table optimizer. Valid values are `compaction`, `retention`, and `orphan_file_deletion`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['CatalogTableOptimizerConfigurationArgs']]:
        """
        A configuration block that defines the table optimizer settings. See Configuration for additional details.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['CatalogTableOptimizerConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _CatalogTableOptimizerState:
    def __init__(__self__, *,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input['CatalogTableOptimizerConfigurationArgs']] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CatalogTableOptimizer resources.
        :param pulumi.Input[_builtins.str] catalog_id: The Catalog ID of the table.
        :param pulumi.Input['CatalogTableOptimizerConfigurationArgs'] configuration: A configuration block that defines the table optimizer settings. See Configuration for additional details.
        :param pulumi.Input[_builtins.str] database_name: The name of the database in the catalog in which the table resides.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] table_name: The name of the table.
        :param pulumi.Input[_builtins.str] type: The type of table optimizer. Valid values are `compaction`, `retention`, and `orphan_file_deletion`.
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Catalog ID of the table.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['CatalogTableOptimizerConfigurationArgs']]:
        """
        A configuration block that defines the table optimizer settings. See Configuration for additional details.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['CatalogTableOptimizerConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database in the catalog in which the table resides.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the table.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of table optimizer. Valid values are `compaction`, `retention`, and `orphan_file_deletion`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("aws:glue/catalogTableOptimizer:CatalogTableOptimizer")
class CatalogTableOptimizer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union['CatalogTableOptimizerConfigurationArgs', 'CatalogTableOptimizerConfigurationArgsDict']]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Glue Catalog Table Optimizer.

        ## Example Usage

        ### Compaction Optimizer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.CatalogTableOptimizer("example",
            catalog_id="123456789012",
            database_name="example_database",
            table_name="example_table",
            configuration={
                "role_arn": "arn:aws:iam::123456789012:role/example-role",
                "enabled": True,
            },
            type="compaction")
        ```

        ### Snapshot Retention Optimizer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.CatalogTableOptimizer("example",
            catalog_id="123456789012",
            database_name="example_database",
            table_name="example_table",
            configuration={
                "role_arn": "arn:aws:iam::123456789012:role/example-role",
                "enabled": True,
                "retention_configuration": {
                    "iceberg_configuration": {
                        "snapshot_retention_period_in_days": 7,
                        "number_of_snapshots_to_retain": 3,
                        "clean_expired_files": True,
                    },
                },
            },
            type="retention")
        ```

        ### Orphan File Deletion Optimizer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.CatalogTableOptimizer("example",
            catalog_id="123456789012",
            database_name="example_database",
            table_name="example_table",
            configuration={
                "role_arn": "arn:aws:iam::123456789012:role/example-role",
                "enabled": True,
                "orphan_file_deletion_configuration": {
                    "iceberg_configuration": {
                        "orphan_file_retention_period_in_days": 7,
                        "location": "s3://example-bucket/example_table/",
                    },
                },
            },
            type="orphan_file_deletion")
        ```

        ## Import

        Using `pulumi import`, import Glue Catalog Table Optimizer using the `catalog_id,database_name,table_name,type`. For example:

        ```sh
        $ pulumi import aws:glue/catalogTableOptimizer:CatalogTableOptimizer example 123456789012,example_database,example_table,compaction
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_id: The Catalog ID of the table.
        :param pulumi.Input[Union['CatalogTableOptimizerConfigurationArgs', 'CatalogTableOptimizerConfigurationArgsDict']] configuration: A configuration block that defines the table optimizer settings. See Configuration for additional details.
        :param pulumi.Input[_builtins.str] database_name: The name of the database in the catalog in which the table resides.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] table_name: The name of the table.
        :param pulumi.Input[_builtins.str] type: The type of table optimizer. Valid values are `compaction`, `retention`, and `orphan_file_deletion`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CatalogTableOptimizerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Glue Catalog Table Optimizer.

        ## Example Usage

        ### Compaction Optimizer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.CatalogTableOptimizer("example",
            catalog_id="123456789012",
            database_name="example_database",
            table_name="example_table",
            configuration={
                "role_arn": "arn:aws:iam::123456789012:role/example-role",
                "enabled": True,
            },
            type="compaction")
        ```

        ### Snapshot Retention Optimizer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.CatalogTableOptimizer("example",
            catalog_id="123456789012",
            database_name="example_database",
            table_name="example_table",
            configuration={
                "role_arn": "arn:aws:iam::123456789012:role/example-role",
                "enabled": True,
                "retention_configuration": {
                    "iceberg_configuration": {
                        "snapshot_retention_period_in_days": 7,
                        "number_of_snapshots_to_retain": 3,
                        "clean_expired_files": True,
                    },
                },
            },
            type="retention")
        ```

        ### Orphan File Deletion Optimizer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.CatalogTableOptimizer("example",
            catalog_id="123456789012",
            database_name="example_database",
            table_name="example_table",
            configuration={
                "role_arn": "arn:aws:iam::123456789012:role/example-role",
                "enabled": True,
                "orphan_file_deletion_configuration": {
                    "iceberg_configuration": {
                        "orphan_file_retention_period_in_days": 7,
                        "location": "s3://example-bucket/example_table/",
                    },
                },
            },
            type="orphan_file_deletion")
        ```

        ## Import

        Using `pulumi import`, import Glue Catalog Table Optimizer using the `catalog_id,database_name,table_name,type`. For example:

        ```sh
        $ pulumi import aws:glue/catalogTableOptimizer:CatalogTableOptimizer example 123456789012,example_database,example_table,compaction
        ```

        :param str resource_name: The name of the resource.
        :param CatalogTableOptimizerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CatalogTableOptimizerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union['CatalogTableOptimizerConfigurationArgs', 'CatalogTableOptimizerConfigurationArgsDict']]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CatalogTableOptimizerArgs.__new__(CatalogTableOptimizerArgs)

            if catalog_id is None and not opts.urn:
                raise TypeError("Missing required property 'catalog_id'")
            __props__.__dict__["catalog_id"] = catalog_id
            __props__.__dict__["configuration"] = configuration
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["region"] = region
            if table_name is None and not opts.urn:
                raise TypeError("Missing required property 'table_name'")
            __props__.__dict__["table_name"] = table_name
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(CatalogTableOptimizer, __self__).__init__(
            'aws:glue/catalogTableOptimizer:CatalogTableOptimizer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
            configuration: Optional[pulumi.Input[Union['CatalogTableOptimizerConfigurationArgs', 'CatalogTableOptimizerConfigurationArgsDict']]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            table_name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'CatalogTableOptimizer':
        """
        Get an existing CatalogTableOptimizer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_id: The Catalog ID of the table.
        :param pulumi.Input[Union['CatalogTableOptimizerConfigurationArgs', 'CatalogTableOptimizerConfigurationArgsDict']] configuration: A configuration block that defines the table optimizer settings. See Configuration for additional details.
        :param pulumi.Input[_builtins.str] database_name: The name of the database in the catalog in which the table resides.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] table_name: The name of the table.
        :param pulumi.Input[_builtins.str] type: The type of table optimizer. Valid values are `compaction`, `retention`, and `orphan_file_deletion`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CatalogTableOptimizerState.__new__(_CatalogTableOptimizerState)

        __props__.__dict__["catalog_id"] = catalog_id
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["region"] = region
        __props__.__dict__["table_name"] = table_name
        __props__.__dict__["type"] = type
        return CatalogTableOptimizer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Catalog ID of the table.
        """
        return pulumi.get(self, "catalog_id")

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Optional['outputs.CatalogTableOptimizerConfiguration']]:
        """
        A configuration block that defines the table optimizer settings. See Configuration for additional details.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the database in the catalog in which the table resides.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the table.
        """
        return pulumi.get(self, "table_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of table optimizer. Valid values are `compaction`, `retention`, and `orphan_file_deletion`.
        """
        return pulumi.get(self, "type")

