# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceArgs', 'Workspace']

@pulumi.input_type
class WorkspaceArgs:
    def __init__(__self__, *,
                 account_access_type: pulumi.Input[_builtins.str],
                 authentication_providers: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 permission_type: pulumi.Input[_builtins.str],
                 configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 data_sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_access_control: Optional[pulumi.Input['WorkspaceNetworkAccessControlArgs']] = None,
                 notification_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 organization_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_configuration: Optional[pulumi.Input['WorkspaceVpcConfigurationArgs']] = None):
        """
        The set of arguments for constructing a Workspace resource.
        :param pulumi.Input[_builtins.str] account_access_type: The type of account access for the workspace. Valid values are `CURRENT_ACCOUNT` and `ORGANIZATION`. If `ORGANIZATION` is specified, then `organizational_units` must also be present.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authentication_providers: The authentication providers for the workspace. Valid values are `AWS_SSO`, `SAML`, or both.
        :param pulumi.Input[_builtins.str] permission_type: The permission type of the workspace. If `SERVICE_MANAGED` is specified, the IAM roles and IAM policy attachments are generated automatically. If `CUSTOMER_MANAGED` is specified, the IAM roles and IAM policy attachments will not be created.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] configuration: The configuration string for the workspace that you create. For more information about the format and configuration options available, see [Working in your Grafana workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_sources: The data sources for the workspace. Valid values are `AMAZON_OPENSEARCH_SERVICE`, `ATHENA`, `CLOUDWATCH`, `PROMETHEUS`, `REDSHIFT`, `SITEWISE`, `TIMESTREAM`, `TWINMAKER`, XRAY`
        :param pulumi.Input[_builtins.str] description: The workspace description.
        :param pulumi.Input[_builtins.str] grafana_version: Specifies the version of Grafana to support in the new workspace. Supported values are `8.4`, `9.4` and `10.4`. If not specified, defaults to the latest version.
        :param pulumi.Input[_builtins.str] name: The Grafana workspace name.
        :param pulumi.Input['WorkspaceNetworkAccessControlArgs'] network_access_control: Configuration for network access to your workspace.See Network Access Control below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_destinations: The notification destinations. If a data source is specified here, Amazon Managed Grafana will create IAM roles and permissions needed to use these destinations. Must be set to `SNS`.
        :param pulumi.Input[_builtins.str] organization_role_name: The role name that the workspace uses to access resources through Amazon Organizations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizational_units: The Amazon Organizations organizational units that the workspace is authorized to use data sources from.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: The IAM role ARN that the workspace assumes.
        :param pulumi.Input[_builtins.str] stack_set_name: The AWS CloudFormation stack set name that provisions IAM roles to be used by the workspace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        :param pulumi.Input['WorkspaceVpcConfigurationArgs'] vpc_configuration: The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to. See VPC Configuration below.
        """
        pulumi.set(__self__, "account_access_type", account_access_type)
        pulumi.set(__self__, "authentication_providers", authentication_providers)
        pulumi.set(__self__, "permission_type", permission_type)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if data_sources is not None:
            pulumi.set(__self__, "data_sources", data_sources)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if grafana_version is not None:
            pulumi.set(__self__, "grafana_version", grafana_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_access_control is not None:
            pulumi.set(__self__, "network_access_control", network_access_control)
        if notification_destinations is not None:
            pulumi.set(__self__, "notification_destinations", notification_destinations)
        if organization_role_name is not None:
            pulumi.set(__self__, "organization_role_name", organization_role_name)
        if organizational_units is not None:
            pulumi.set(__self__, "organizational_units", organizational_units)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if stack_set_name is not None:
            pulumi.set(__self__, "stack_set_name", stack_set_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_configuration is not None:
            pulumi.set(__self__, "vpc_configuration", vpc_configuration)

    @_builtins.property
    @pulumi.getter(name="accountAccessType")
    def account_access_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of account access for the workspace. Valid values are `CURRENT_ACCOUNT` and `ORGANIZATION`. If `ORGANIZATION` is specified, then `organizational_units` must also be present.
        """
        return pulumi.get(self, "account_access_type")

    @account_access_type.setter
    def account_access_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_access_type", value)

    @_builtins.property
    @pulumi.getter(name="authenticationProviders")
    def authentication_providers(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The authentication providers for the workspace. Valid values are `AWS_SSO`, `SAML`, or both.
        """
        return pulumi.get(self, "authentication_providers")

    @authentication_providers.setter
    def authentication_providers(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "authentication_providers", value)

    @_builtins.property
    @pulumi.getter(name="permissionType")
    def permission_type(self) -> pulumi.Input[_builtins.str]:
        """
        The permission type of the workspace. If `SERVICE_MANAGED` is specified, the IAM roles and IAM policy attachments are generated automatically. If `CUSTOMER_MANAGED` is specified, the IAM roles and IAM policy attachments will not be created.

        The following arguments are optional:
        """
        return pulumi.get(self, "permission_type")

    @permission_type.setter
    def permission_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "permission_type", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration string for the workspace that you create. For more information about the format and configuration options available, see [Working in your Grafana workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The data sources for the workspace. Valid values are `AMAZON_OPENSEARCH_SERVICE`, `ATHENA`, `CLOUDWATCH`, `PROMETHEUS`, `REDSHIFT`, `SITEWISE`, `TIMESTREAM`, `TWINMAKER`, XRAY`
        """
        return pulumi.get(self, "data_sources")

    @data_sources.setter
    def data_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "data_sources", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workspace description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="grafanaVersion")
    def grafana_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of Grafana to support in the new workspace. Supported values are `8.4`, `9.4` and `10.4`. If not specified, defaults to the latest version.
        """
        return pulumi.get(self, "grafana_version")

    @grafana_version.setter
    def grafana_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Grafana workspace name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAccessControl")
    def network_access_control(self) -> Optional[pulumi.Input['WorkspaceNetworkAccessControlArgs']]:
        """
        Configuration for network access to your workspace.See Network Access Control below.
        """
        return pulumi.get(self, "network_access_control")

    @network_access_control.setter
    def network_access_control(self, value: Optional[pulumi.Input['WorkspaceNetworkAccessControlArgs']]):
        pulumi.set(self, "network_access_control", value)

    @_builtins.property
    @pulumi.getter(name="notificationDestinations")
    def notification_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The notification destinations. If a data source is specified here, Amazon Managed Grafana will create IAM roles and permissions needed to use these destinations. Must be set to `SNS`.
        """
        return pulumi.get(self, "notification_destinations")

    @notification_destinations.setter
    def notification_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notification_destinations", value)

    @_builtins.property
    @pulumi.getter(name="organizationRoleName")
    def organization_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role name that the workspace uses to access resources through Amazon Organizations.
        """
        return pulumi.get(self, "organization_role_name")

    @organization_role_name.setter
    def organization_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_role_name", value)

    @_builtins.property
    @pulumi.getter(name="organizationalUnits")
    def organizational_units(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Amazon Organizations organizational units that the workspace is authorized to use data sources from.
        """
        return pulumi.get(self, "organizational_units")

    @organizational_units.setter
    def organizational_units(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "organizational_units", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IAM role ARN that the workspace assumes.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="stackSetName")
    def stack_set_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS CloudFormation stack set name that provisions IAM roles to be used by the workspace.
        """
        return pulumi.get(self, "stack_set_name")

    @stack_set_name.setter
    def stack_set_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_set_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> Optional[pulumi.Input['WorkspaceVpcConfigurationArgs']]:
        """
        The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to. See VPC Configuration below.
        """
        return pulumi.get(self, "vpc_configuration")

    @vpc_configuration.setter
    def vpc_configuration(self, value: Optional[pulumi.Input['WorkspaceVpcConfigurationArgs']]):
        pulumi.set(self, "vpc_configuration", value)


@pulumi.input_type
class _WorkspaceState:
    def __init__(__self__, *,
                 account_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_providers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 data_sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_access_control: Optional[pulumi.Input['WorkspaceNetworkAccessControlArgs']] = None,
                 notification_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 organization_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permission_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_configuration_status: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_configuration: Optional[pulumi.Input['WorkspaceVpcConfigurationArgs']] = None):
        """
        Input properties used for looking up and filtering Workspace resources.
        :param pulumi.Input[_builtins.str] account_access_type: The type of account access for the workspace. Valid values are `CURRENT_ACCOUNT` and `ORGANIZATION`. If `ORGANIZATION` is specified, then `organizational_units` must also be present.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) of the Grafana workspace.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authentication_providers: The authentication providers for the workspace. Valid values are `AWS_SSO`, `SAML`, or both.
        :param pulumi.Input[_builtins.str] configuration: The configuration string for the workspace that you create. For more information about the format and configuration options available, see [Working in your Grafana workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_sources: The data sources for the workspace. Valid values are `AMAZON_OPENSEARCH_SERVICE`, `ATHENA`, `CLOUDWATCH`, `PROMETHEUS`, `REDSHIFT`, `SITEWISE`, `TIMESTREAM`, `TWINMAKER`, XRAY`
        :param pulumi.Input[_builtins.str] description: The workspace description.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint of the Grafana workspace.
        :param pulumi.Input[_builtins.str] grafana_version: Specifies the version of Grafana to support in the new workspace. Supported values are `8.4`, `9.4` and `10.4`. If not specified, defaults to the latest version.
        :param pulumi.Input[_builtins.str] name: The Grafana workspace name.
        :param pulumi.Input['WorkspaceNetworkAccessControlArgs'] network_access_control: Configuration for network access to your workspace.See Network Access Control below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_destinations: The notification destinations. If a data source is specified here, Amazon Managed Grafana will create IAM roles and permissions needed to use these destinations. Must be set to `SNS`.
        :param pulumi.Input[_builtins.str] organization_role_name: The role name that the workspace uses to access resources through Amazon Organizations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizational_units: The Amazon Organizations organizational units that the workspace is authorized to use data sources from.
        :param pulumi.Input[_builtins.str] permission_type: The permission type of the workspace. If `SERVICE_MANAGED` is specified, the IAM roles and IAM policy attachments are generated automatically. If `CUSTOMER_MANAGED` is specified, the IAM roles and IAM policy attachments will not be created.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: The IAM role ARN that the workspace assumes.
        :param pulumi.Input[_builtins.str] stack_set_name: The AWS CloudFormation stack set name that provisions IAM roles to be used by the workspace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['WorkspaceVpcConfigurationArgs'] vpc_configuration: The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to. See VPC Configuration below.
        """
        if account_access_type is not None:
            pulumi.set(__self__, "account_access_type", account_access_type)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if authentication_providers is not None:
            pulumi.set(__self__, "authentication_providers", authentication_providers)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if data_sources is not None:
            pulumi.set(__self__, "data_sources", data_sources)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if grafana_version is not None:
            pulumi.set(__self__, "grafana_version", grafana_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_access_control is not None:
            pulumi.set(__self__, "network_access_control", network_access_control)
        if notification_destinations is not None:
            pulumi.set(__self__, "notification_destinations", notification_destinations)
        if organization_role_name is not None:
            pulumi.set(__self__, "organization_role_name", organization_role_name)
        if organizational_units is not None:
            pulumi.set(__self__, "organizational_units", organizational_units)
        if permission_type is not None:
            pulumi.set(__self__, "permission_type", permission_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if saml_configuration_status is not None:
            pulumi.set(__self__, "saml_configuration_status", saml_configuration_status)
        if stack_set_name is not None:
            pulumi.set(__self__, "stack_set_name", stack_set_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_configuration is not None:
            pulumi.set(__self__, "vpc_configuration", vpc_configuration)

    @_builtins.property
    @pulumi.getter(name="accountAccessType")
    def account_access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of account access for the workspace. Valid values are `CURRENT_ACCOUNT` and `ORGANIZATION`. If `ORGANIZATION` is specified, then `organizational_units` must also be present.
        """
        return pulumi.get(self, "account_access_type")

    @account_access_type.setter
    def account_access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_access_type", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Grafana workspace.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="authenticationProviders")
    def authentication_providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The authentication providers for the workspace. Valid values are `AWS_SSO`, `SAML`, or both.
        """
        return pulumi.get(self, "authentication_providers")

    @authentication_providers.setter
    def authentication_providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authentication_providers", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration string for the workspace that you create. For more information about the format and configuration options available, see [Working in your Grafana workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The data sources for the workspace. Valid values are `AMAZON_OPENSEARCH_SERVICE`, `ATHENA`, `CLOUDWATCH`, `PROMETHEUS`, `REDSHIFT`, `SITEWISE`, `TIMESTREAM`, `TWINMAKER`, XRAY`
        """
        return pulumi.get(self, "data_sources")

    @data_sources.setter
    def data_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "data_sources", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workspace description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint of the Grafana workspace.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="grafanaVersion")
    def grafana_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of Grafana to support in the new workspace. Supported values are `8.4`, `9.4` and `10.4`. If not specified, defaults to the latest version.
        """
        return pulumi.get(self, "grafana_version")

    @grafana_version.setter
    def grafana_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Grafana workspace name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAccessControl")
    def network_access_control(self) -> Optional[pulumi.Input['WorkspaceNetworkAccessControlArgs']]:
        """
        Configuration for network access to your workspace.See Network Access Control below.
        """
        return pulumi.get(self, "network_access_control")

    @network_access_control.setter
    def network_access_control(self, value: Optional[pulumi.Input['WorkspaceNetworkAccessControlArgs']]):
        pulumi.set(self, "network_access_control", value)

    @_builtins.property
    @pulumi.getter(name="notificationDestinations")
    def notification_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The notification destinations. If a data source is specified here, Amazon Managed Grafana will create IAM roles and permissions needed to use these destinations. Must be set to `SNS`.
        """
        return pulumi.get(self, "notification_destinations")

    @notification_destinations.setter
    def notification_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notification_destinations", value)

    @_builtins.property
    @pulumi.getter(name="organizationRoleName")
    def organization_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role name that the workspace uses to access resources through Amazon Organizations.
        """
        return pulumi.get(self, "organization_role_name")

    @organization_role_name.setter
    def organization_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_role_name", value)

    @_builtins.property
    @pulumi.getter(name="organizationalUnits")
    def organizational_units(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Amazon Organizations organizational units that the workspace is authorized to use data sources from.
        """
        return pulumi.get(self, "organizational_units")

    @organizational_units.setter
    def organizational_units(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "organizational_units", value)

    @_builtins.property
    @pulumi.getter(name="permissionType")
    def permission_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The permission type of the workspace. If `SERVICE_MANAGED` is specified, the IAM roles and IAM policy attachments are generated automatically. If `CUSTOMER_MANAGED` is specified, the IAM roles and IAM policy attachments will not be created.

        The following arguments are optional:
        """
        return pulumi.get(self, "permission_type")

    @permission_type.setter
    def permission_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permission_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IAM role ARN that the workspace assumes.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="samlConfigurationStatus")
    def saml_configuration_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "saml_configuration_status")

    @saml_configuration_status.setter
    def saml_configuration_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_configuration_status", value)

    @_builtins.property
    @pulumi.getter(name="stackSetName")
    def stack_set_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS CloudFormation stack set name that provisions IAM roles to be used by the workspace.
        """
        return pulumi.get(self, "stack_set_name")

    @stack_set_name.setter
    def stack_set_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_set_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> Optional[pulumi.Input['WorkspaceVpcConfigurationArgs']]:
        """
        The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to. See VPC Configuration below.
        """
        return pulumi.get(self, "vpc_configuration")

    @vpc_configuration.setter
    def vpc_configuration(self, value: Optional[pulumi.Input['WorkspaceVpcConfigurationArgs']]):
        pulumi.set(self, "vpc_configuration", value)


@pulumi.type_token("aws:grafana/workspace:Workspace")
class Workspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_providers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 data_sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_access_control: Optional[pulumi.Input[Union['WorkspaceNetworkAccessControlArgs', 'WorkspaceNetworkAccessControlArgsDict']]] = None,
                 notification_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 organization_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permission_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_configuration: Optional[pulumi.Input[Union['WorkspaceVpcConfigurationArgs', 'WorkspaceVpcConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        Provides an Amazon Managed Grafana workspace resource.

        ## Example Usage

        ### Basic configuration

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        assume = aws.iam.Role("assume",
            name="grafana-assume",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Sid": "",
                    "Principal": {
                        "Service": "grafana.amazonaws.com",
                    },
                }],
            }))
        example = aws.grafana.Workspace("example",
            account_access_type="CURRENT_ACCOUNT",
            authentication_providers=["SAML"],
            permission_type="SERVICE_MANAGED",
            role_arn=assume.arn)
        ```

        ### Workspace configuration options

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.grafana.Workspace("example",
            account_access_type="CURRENT_ACCOUNT",
            authentication_providers=["SAML"],
            permission_type="SERVICE_MANAGED",
            role_arn=assume["arn"],
            configuration=json.dumps({
                "plugins": {
                    "pluginAdminEnabled": True,
                },
                "unifiedAlerting": {
                    "enabled": False,
                },
            }))
        ```

        The optional argument `configuration` is a JSON string that disables the unified `Grafana Alerting` (Grafana version 10 or newer) and enables `Plugin Management` (Grafana version 9 or newer) on the Grafana Workspaces.

        For more information about using Grafana alerting, and the effects of turning it on or off, see [Alerts in Grafana version 10](https://docs.aws.amazon.com/grafana/latest/userguide/v10-alerts.html).

        ## Import

        Using `pulumi import`, import Grafana Workspace using the workspace's `id`. For example:

        ```sh
        $ pulumi import aws:grafana/workspace:Workspace example g-2054c75a02
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_access_type: The type of account access for the workspace. Valid values are `CURRENT_ACCOUNT` and `ORGANIZATION`. If `ORGANIZATION` is specified, then `organizational_units` must also be present.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authentication_providers: The authentication providers for the workspace. Valid values are `AWS_SSO`, `SAML`, or both.
        :param pulumi.Input[_builtins.str] configuration: The configuration string for the workspace that you create. For more information about the format and configuration options available, see [Working in your Grafana workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_sources: The data sources for the workspace. Valid values are `AMAZON_OPENSEARCH_SERVICE`, `ATHENA`, `CLOUDWATCH`, `PROMETHEUS`, `REDSHIFT`, `SITEWISE`, `TIMESTREAM`, `TWINMAKER`, XRAY`
        :param pulumi.Input[_builtins.str] description: The workspace description.
        :param pulumi.Input[_builtins.str] grafana_version: Specifies the version of Grafana to support in the new workspace. Supported values are `8.4`, `9.4` and `10.4`. If not specified, defaults to the latest version.
        :param pulumi.Input[_builtins.str] name: The Grafana workspace name.
        :param pulumi.Input[Union['WorkspaceNetworkAccessControlArgs', 'WorkspaceNetworkAccessControlArgsDict']] network_access_control: Configuration for network access to your workspace.See Network Access Control below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_destinations: The notification destinations. If a data source is specified here, Amazon Managed Grafana will create IAM roles and permissions needed to use these destinations. Must be set to `SNS`.
        :param pulumi.Input[_builtins.str] organization_role_name: The role name that the workspace uses to access resources through Amazon Organizations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizational_units: The Amazon Organizations organizational units that the workspace is authorized to use data sources from.
        :param pulumi.Input[_builtins.str] permission_type: The permission type of the workspace. If `SERVICE_MANAGED` is specified, the IAM roles and IAM policy attachments are generated automatically. If `CUSTOMER_MANAGED` is specified, the IAM roles and IAM policy attachments will not be created.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: The IAM role ARN that the workspace assumes.
        :param pulumi.Input[_builtins.str] stack_set_name: The AWS CloudFormation stack set name that provisions IAM roles to be used by the workspace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        :param pulumi.Input[Union['WorkspaceVpcConfigurationArgs', 'WorkspaceVpcConfigurationArgsDict']] vpc_configuration: The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to. See VPC Configuration below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Amazon Managed Grafana workspace resource.

        ## Example Usage

        ### Basic configuration

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        assume = aws.iam.Role("assume",
            name="grafana-assume",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Sid": "",
                    "Principal": {
                        "Service": "grafana.amazonaws.com",
                    },
                }],
            }))
        example = aws.grafana.Workspace("example",
            account_access_type="CURRENT_ACCOUNT",
            authentication_providers=["SAML"],
            permission_type="SERVICE_MANAGED",
            role_arn=assume.arn)
        ```

        ### Workspace configuration options

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.grafana.Workspace("example",
            account_access_type="CURRENT_ACCOUNT",
            authentication_providers=["SAML"],
            permission_type="SERVICE_MANAGED",
            role_arn=assume["arn"],
            configuration=json.dumps({
                "plugins": {
                    "pluginAdminEnabled": True,
                },
                "unifiedAlerting": {
                    "enabled": False,
                },
            }))
        ```

        The optional argument `configuration` is a JSON string that disables the unified `Grafana Alerting` (Grafana version 10 or newer) and enables `Plugin Management` (Grafana version 9 or newer) on the Grafana Workspaces.

        For more information about using Grafana alerting, and the effects of turning it on or off, see [Alerts in Grafana version 10](https://docs.aws.amazon.com/grafana/latest/userguide/v10-alerts.html).

        ## Import

        Using `pulumi import`, import Grafana Workspace using the workspace's `id`. For example:

        ```sh
        $ pulumi import aws:grafana/workspace:Workspace example g-2054c75a02
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_providers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 data_sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_access_control: Optional[pulumi.Input[Union['WorkspaceNetworkAccessControlArgs', 'WorkspaceNetworkAccessControlArgsDict']]] = None,
                 notification_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 organization_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permission_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_configuration: Optional[pulumi.Input[Union['WorkspaceVpcConfigurationArgs', 'WorkspaceVpcConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceArgs.__new__(WorkspaceArgs)

            if account_access_type is None and not opts.urn:
                raise TypeError("Missing required property 'account_access_type'")
            __props__.__dict__["account_access_type"] = account_access_type
            if authentication_providers is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_providers'")
            __props__.__dict__["authentication_providers"] = authentication_providers
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["data_sources"] = data_sources
            __props__.__dict__["description"] = description
            __props__.__dict__["grafana_version"] = grafana_version
            __props__.__dict__["name"] = name
            __props__.__dict__["network_access_control"] = network_access_control
            __props__.__dict__["notification_destinations"] = notification_destinations
            __props__.__dict__["organization_role_name"] = organization_role_name
            __props__.__dict__["organizational_units"] = organizational_units
            if permission_type is None and not opts.urn:
                raise TypeError("Missing required property 'permission_type'")
            __props__.__dict__["permission_type"] = permission_type
            __props__.__dict__["region"] = region
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["stack_set_name"] = stack_set_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_configuration"] = vpc_configuration
            __props__.__dict__["arn"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["saml_configuration_status"] = None
            __props__.__dict__["tags_all"] = None
        super(Workspace, __self__).__init__(
            'aws:grafana/workspace:Workspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_access_type: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            authentication_providers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            configuration: Optional[pulumi.Input[_builtins.str]] = None,
            data_sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            grafana_version: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_access_control: Optional[pulumi.Input[Union['WorkspaceNetworkAccessControlArgs', 'WorkspaceNetworkAccessControlArgsDict']]] = None,
            notification_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            organization_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            permission_type: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            saml_configuration_status: Optional[pulumi.Input[_builtins.str]] = None,
            stack_set_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_configuration: Optional[pulumi.Input[Union['WorkspaceVpcConfigurationArgs', 'WorkspaceVpcConfigurationArgsDict']]] = None) -> 'Workspace':
        """
        Get an existing Workspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_access_type: The type of account access for the workspace. Valid values are `CURRENT_ACCOUNT` and `ORGANIZATION`. If `ORGANIZATION` is specified, then `organizational_units` must also be present.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) of the Grafana workspace.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authentication_providers: The authentication providers for the workspace. Valid values are `AWS_SSO`, `SAML`, or both.
        :param pulumi.Input[_builtins.str] configuration: The configuration string for the workspace that you create. For more information about the format and configuration options available, see [Working in your Grafana workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_sources: The data sources for the workspace. Valid values are `AMAZON_OPENSEARCH_SERVICE`, `ATHENA`, `CLOUDWATCH`, `PROMETHEUS`, `REDSHIFT`, `SITEWISE`, `TIMESTREAM`, `TWINMAKER`, XRAY`
        :param pulumi.Input[_builtins.str] description: The workspace description.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint of the Grafana workspace.
        :param pulumi.Input[_builtins.str] grafana_version: Specifies the version of Grafana to support in the new workspace. Supported values are `8.4`, `9.4` and `10.4`. If not specified, defaults to the latest version.
        :param pulumi.Input[_builtins.str] name: The Grafana workspace name.
        :param pulumi.Input[Union['WorkspaceNetworkAccessControlArgs', 'WorkspaceNetworkAccessControlArgsDict']] network_access_control: Configuration for network access to your workspace.See Network Access Control below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_destinations: The notification destinations. If a data source is specified here, Amazon Managed Grafana will create IAM roles and permissions needed to use these destinations. Must be set to `SNS`.
        :param pulumi.Input[_builtins.str] organization_role_name: The role name that the workspace uses to access resources through Amazon Organizations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizational_units: The Amazon Organizations organizational units that the workspace is authorized to use data sources from.
        :param pulumi.Input[_builtins.str] permission_type: The permission type of the workspace. If `SERVICE_MANAGED` is specified, the IAM roles and IAM policy attachments are generated automatically. If `CUSTOMER_MANAGED` is specified, the IAM roles and IAM policy attachments will not be created.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: The IAM role ARN that the workspace assumes.
        :param pulumi.Input[_builtins.str] stack_set_name: The AWS CloudFormation stack set name that provisions IAM roles to be used by the workspace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['WorkspaceVpcConfigurationArgs', 'WorkspaceVpcConfigurationArgsDict']] vpc_configuration: The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to. See VPC Configuration below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceState.__new__(_WorkspaceState)

        __props__.__dict__["account_access_type"] = account_access_type
        __props__.__dict__["arn"] = arn
        __props__.__dict__["authentication_providers"] = authentication_providers
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["data_sources"] = data_sources
        __props__.__dict__["description"] = description
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["grafana_version"] = grafana_version
        __props__.__dict__["name"] = name
        __props__.__dict__["network_access_control"] = network_access_control
        __props__.__dict__["notification_destinations"] = notification_destinations
        __props__.__dict__["organization_role_name"] = organization_role_name
        __props__.__dict__["organizational_units"] = organizational_units
        __props__.__dict__["permission_type"] = permission_type
        __props__.__dict__["region"] = region
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["saml_configuration_status"] = saml_configuration_status
        __props__.__dict__["stack_set_name"] = stack_set_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_configuration"] = vpc_configuration
        return Workspace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountAccessType")
    def account_access_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of account access for the workspace. Valid values are `CURRENT_ACCOUNT` and `ORGANIZATION`. If `ORGANIZATION` is specified, then `organizational_units` must also be present.
        """
        return pulumi.get(self, "account_access_type")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Grafana workspace.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="authenticationProviders")
    def authentication_providers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The authentication providers for the workspace. Valid values are `AWS_SSO`, `SAML`, or both.
        """
        return pulumi.get(self, "authentication_providers")

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[_builtins.str]:
        """
        The configuration string for the workspace that you create. For more information about the format and configuration options available, see [Working in your Grafana workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The data sources for the workspace. Valid values are `AMAZON_OPENSEARCH_SERVICE`, `ATHENA`, `CLOUDWATCH`, `PROMETHEUS`, `REDSHIFT`, `SITEWISE`, `TIMESTREAM`, `TWINMAKER`, XRAY`
        """
        return pulumi.get(self, "data_sources")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The workspace description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint of the Grafana workspace.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="grafanaVersion")
    def grafana_version(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the version of Grafana to support in the new workspace. Supported values are `8.4`, `9.4` and `10.4`. If not specified, defaults to the latest version.
        """
        return pulumi.get(self, "grafana_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The Grafana workspace name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkAccessControl")
    def network_access_control(self) -> pulumi.Output[Optional['outputs.WorkspaceNetworkAccessControl']]:
        """
        Configuration for network access to your workspace.See Network Access Control below.
        """
        return pulumi.get(self, "network_access_control")

    @_builtins.property
    @pulumi.getter(name="notificationDestinations")
    def notification_destinations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The notification destinations. If a data source is specified here, Amazon Managed Grafana will create IAM roles and permissions needed to use these destinations. Must be set to `SNS`.
        """
        return pulumi.get(self, "notification_destinations")

    @_builtins.property
    @pulumi.getter(name="organizationRoleName")
    def organization_role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The role name that the workspace uses to access resources through Amazon Organizations.
        """
        return pulumi.get(self, "organization_role_name")

    @_builtins.property
    @pulumi.getter(name="organizationalUnits")
    def organizational_units(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The Amazon Organizations organizational units that the workspace is authorized to use data sources from.
        """
        return pulumi.get(self, "organizational_units")

    @_builtins.property
    @pulumi.getter(name="permissionType")
    def permission_type(self) -> pulumi.Output[_builtins.str]:
        """
        The permission type of the workspace. If `SERVICE_MANAGED` is specified, the IAM roles and IAM policy attachments are generated automatically. If `CUSTOMER_MANAGED` is specified, the IAM roles and IAM policy attachments will not be created.

        The following arguments are optional:
        """
        return pulumi.get(self, "permission_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IAM role ARN that the workspace assumes.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="samlConfigurationStatus")
    def saml_configuration_status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "saml_configuration_status")

    @_builtins.property
    @pulumi.getter(name="stackSetName")
    def stack_set_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The AWS CloudFormation stack set name that provisions IAM roles to be used by the workspace.
        """
        return pulumi.get(self, "stack_set_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> pulumi.Output[Optional['outputs.WorkspaceVpcConfiguration']]:
        """
        The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to. See VPC Configuration below.
        """
        return pulumi.get(self, "vpc_configuration")

