# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OrganizationsFeaturesArgs', 'OrganizationsFeatures']

@pulumi.input_type
class OrganizationsFeaturesArgs:
    def __init__(__self__, *,
                 enabled_features: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        The set of arguments for constructing a OrganizationsFeatures resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_features: List of IAM features to enable. Valid values are `RootCredentialsManagement` and `RootSessions`.
        """
        pulumi.set(__self__, "enabled_features", enabled_features)

    @_builtins.property
    @pulumi.getter(name="enabledFeatures")
    def enabled_features(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of IAM features to enable. Valid values are `RootCredentialsManagement` and `RootSessions`.
        """
        return pulumi.get(self, "enabled_features")

    @enabled_features.setter
    def enabled_features(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "enabled_features", value)


@pulumi.input_type
class _OrganizationsFeaturesState:
    def __init__(__self__, *,
                 enabled_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering OrganizationsFeatures resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_features: List of IAM features to enable. Valid values are `RootCredentialsManagement` and `RootSessions`.
        """
        if enabled_features is not None:
            pulumi.set(__self__, "enabled_features", enabled_features)

    @_builtins.property
    @pulumi.getter(name="enabledFeatures")
    def enabled_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IAM features to enable. Valid values are `RootCredentialsManagement` and `RootSessions`.
        """
        return pulumi.get(self, "enabled_features")

    @enabled_features.setter
    def enabled_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_features", value)


@pulumi.type_token("aws:iam/organizationsFeatures:OrganizationsFeatures")
class OrganizationsFeatures(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages centralized root access features across AWS member accounts managed using AWS Organizations. More information about managing root access in IAM can be found in the [Centralize root access for member accounts](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-enable-root-access.html).

        > **NOTE:** The AWS account utilizing this resource must be an Organizations management account. Also, you must enable trusted access for AWS Identity and Access Management in AWS Organizations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.organizations.Organization("example",
            aws_service_access_principals=["iam.amazonaws.com"],
            feature_set="ALL")
        example_organizations_features = aws.iam.OrganizationsFeatures("example", enabled_features=[
            "RootCredentialsManagement",
            "RootSessions",
        ])
        ```

        ## Import

        Using `pulumi import`, import root access features using the `id`. For example:

        ```sh
        $ pulumi import aws:iam/organizationsFeatures:OrganizationsFeatures example o-1234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_features: List of IAM features to enable. Valid values are `RootCredentialsManagement` and `RootSessions`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationsFeaturesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages centralized root access features across AWS member accounts managed using AWS Organizations. More information about managing root access in IAM can be found in the [Centralize root access for member accounts](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-enable-root-access.html).

        > **NOTE:** The AWS account utilizing this resource must be an Organizations management account. Also, you must enable trusted access for AWS Identity and Access Management in AWS Organizations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.organizations.Organization("example",
            aws_service_access_principals=["iam.amazonaws.com"],
            feature_set="ALL")
        example_organizations_features = aws.iam.OrganizationsFeatures("example", enabled_features=[
            "RootCredentialsManagement",
            "RootSessions",
        ])
        ```

        ## Import

        Using `pulumi import`, import root access features using the `id`. For example:

        ```sh
        $ pulumi import aws:iam/organizationsFeatures:OrganizationsFeatures example o-1234567
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationsFeaturesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationsFeaturesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationsFeaturesArgs.__new__(OrganizationsFeaturesArgs)

            if enabled_features is None and not opts.urn:
                raise TypeError("Missing required property 'enabled_features'")
            __props__.__dict__["enabled_features"] = enabled_features
        super(OrganizationsFeatures, __self__).__init__(
            'aws:iam/organizationsFeatures:OrganizationsFeatures',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'OrganizationsFeatures':
        """
        Get an existing OrganizationsFeatures resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_features: List of IAM features to enable. Valid values are `RootCredentialsManagement` and `RootSessions`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationsFeaturesState.__new__(_OrganizationsFeaturesState)

        __props__.__dict__["enabled_features"] = enabled_features
        return OrganizationsFeatures(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="enabledFeatures")
    def enabled_features(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of IAM features to enable. Valid values are `RootCredentialsManagement` and `RootSessions`.
        """
        return pulumi.get(self, "enabled_features")

