# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserPoliciesExclusiveArgs', 'UserPoliciesExclusive']

@pulumi.input_type
class UserPoliciesExclusiveArgs:
    def __init__(__self__, *,
                 policy_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 user_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a UserPoliciesExclusive resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_names: A list of inline policy names to be assigned to the user. Policies attached to this user but not configured in this argument will be removed.
        :param pulumi.Input[_builtins.str] user_name: IAM user name.
        """
        pulumi.set(__self__, "policy_names", policy_names)
        pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="policyNames")
    def policy_names(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of inline policy names to be assigned to the user. Policies attached to this user but not configured in this argument will be removed.
        """
        return pulumi.get(self, "policy_names")

    @policy_names.setter
    def policy_names(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "policy_names", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[_builtins.str]:
        """
        IAM user name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class _UserPoliciesExclusiveState:
    def __init__(__self__, *,
                 policy_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserPoliciesExclusive resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_names: A list of inline policy names to be assigned to the user. Policies attached to this user but not configured in this argument will be removed.
        :param pulumi.Input[_builtins.str] user_name: IAM user name.
        """
        if policy_names is not None:
            pulumi.set(__self__, "policy_names", policy_names)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="policyNames")
    def policy_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of inline policy names to be assigned to the user. Policies attached to this user but not configured in this argument will be removed.
        """
        return pulumi.get(self, "policy_names")

    @policy_names.setter
    def policy_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policy_names", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IAM user name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.type_token("aws:iam/userPoliciesExclusive:UserPoliciesExclusive")
class UserPoliciesExclusive(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Using `pulumi import`, import exclusive management of inline policy assignments using the `user_name`. For example:

        ```sh
        $ pulumi import aws:iam/userPoliciesExclusive:UserPoliciesExclusive example MyUser
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_names: A list of inline policy names to be assigned to the user. Policies attached to this user but not configured in this argument will be removed.
        :param pulumi.Input[_builtins.str] user_name: IAM user name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserPoliciesExclusiveArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Using `pulumi import`, import exclusive management of inline policy assignments using the `user_name`. For example:

        ```sh
        $ pulumi import aws:iam/userPoliciesExclusive:UserPoliciesExclusive example MyUser
        ```

        :param str resource_name: The name of the resource.
        :param UserPoliciesExclusiveArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserPoliciesExclusiveArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserPoliciesExclusiveArgs.__new__(UserPoliciesExclusiveArgs)

            if policy_names is None and not opts.urn:
                raise TypeError("Missing required property 'policy_names'")
            __props__.__dict__["policy_names"] = policy_names
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
        super(UserPoliciesExclusive, __self__).__init__(
            'aws:iam/userPoliciesExclusive:UserPoliciesExclusive',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            policy_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserPoliciesExclusive':
        """
        Get an existing UserPoliciesExclusive resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_names: A list of inline policy names to be assigned to the user. Policies attached to this user but not configured in this argument will be removed.
        :param pulumi.Input[_builtins.str] user_name: IAM user name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserPoliciesExclusiveState.__new__(_UserPoliciesExclusiveState)

        __props__.__dict__["policy_names"] = policy_names
        __props__.__dict__["user_name"] = user_name
        return UserPoliciesExclusive(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="policyNames")
    def policy_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of inline policy names to be assigned to the user. Policies attached to this user but not configured in this argument will be removed.
        """
        return pulumi.get(self, "policy_names")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[_builtins.str]:
        """
        IAM user name.
        """
        return pulumi.get(self, "user_name")

