# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetGroupMembershipsResult',
    'AwaitableGetGroupMembershipsResult',
    'get_group_memberships',
    'get_group_memberships_output',
]

@pulumi.output_type
class GetGroupMembershipsResult:
    """
    A collection of values returned by getGroupMemberships.
    """
    def __init__(__self__, group_id=None, group_memberships=None, id=None, identity_store_id=None, region=None):
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if group_memberships and not isinstance(group_memberships, list):
            raise TypeError("Expected argument 'group_memberships' to be a list")
        pulumi.set(__self__, "group_memberships", group_memberships)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity_store_id and not isinstance(identity_store_id, str):
            raise TypeError("Expected argument 'identity_store_id' to be a str")
        pulumi.set(__self__, "identity_store_id", identity_store_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        """
        Group identifier.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="groupMemberships")
    def group_memberships(self) -> Sequence['outputs.GetGroupMembershipsGroupMembershipResult']:
        """
        A list of group membership objects. See `group_memberships` below.
        """
        return pulumi.get(self, "group_memberships")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="identityStoreId")
    def identity_store_id(self) -> _builtins.str:
        """
        Identity store identifier.
        """
        return pulumi.get(self, "identity_store_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetGroupMembershipsResult(GetGroupMembershipsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupMembershipsResult(
            group_id=self.group_id,
            group_memberships=self.group_memberships,
            id=self.id,
            identity_store_id=self.identity_store_id,
            region=self.region)


def get_group_memberships(group_id: Optional[_builtins.str] = None,
                          identity_store_id: Optional[_builtins.str] = None,
                          region: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupMembershipsResult:
    """
    Use this data source to get a list of members in an Identity Store Group.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssoadmin.get_instances()
    example_get_group = aws.identitystore.get_group(identity_store_id=example.identity_store_ids[0],
        alternate_identifier={
            "unique_attribute": {
                "attribute_path": "DisplayName",
                "attribute_value": "ExampleGroup",
            },
        })
    example_get_group_memberships = aws.identitystore.get_group_memberships(identity_store_id=example.identity_store_ids[0],
        group_id=example_get_group.group_id)
    ```


    :param _builtins.str group_id: The identifier for a group in the Identity Store.
    :param _builtins.str identity_store_id: Identity Store ID associated with the Single Sign-On Instance.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['groupId'] = group_id
    __args__['identityStoreId'] = identity_store_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:identitystore/getGroupMemberships:getGroupMemberships', __args__, opts=opts, typ=GetGroupMembershipsResult).value

    return AwaitableGetGroupMembershipsResult(
        group_id=pulumi.get(__ret__, 'group_id'),
        group_memberships=pulumi.get(__ret__, 'group_memberships'),
        id=pulumi.get(__ret__, 'id'),
        identity_store_id=pulumi.get(__ret__, 'identity_store_id'),
        region=pulumi.get(__ret__, 'region'))
def get_group_memberships_output(group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 identity_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupMembershipsResult]:
    """
    Use this data source to get a list of members in an Identity Store Group.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssoadmin.get_instances()
    example_get_group = aws.identitystore.get_group(identity_store_id=example.identity_store_ids[0],
        alternate_identifier={
            "unique_attribute": {
                "attribute_path": "DisplayName",
                "attribute_value": "ExampleGroup",
            },
        })
    example_get_group_memberships = aws.identitystore.get_group_memberships(identity_store_id=example.identity_store_ids[0],
        group_id=example_get_group.group_id)
    ```


    :param _builtins.str group_id: The identifier for a group in the Identity Store.
    :param _builtins.str identity_store_id: Identity Store ID associated with the Single Sign-On Instance.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['groupId'] = group_id
    __args__['identityStoreId'] = identity_store_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:identitystore/getGroupMemberships:getGroupMemberships', __args__, opts=opts, typ=GetGroupMembershipsResult)
    return __ret__.apply(lambda __response__: GetGroupMembershipsResult(
        group_id=pulumi.get(__response__, 'group_id'),
        group_memberships=pulumi.get(__response__, 'group_memberships'),
        id=pulumi.get(__response__, 'id'),
        identity_store_id=pulumi.get(__response__, 'identity_store_id'),
        region=pulumi.get(__response__, 'region')))
