# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetImageRecipeResult',
    'AwaitableGetImageRecipeResult',
    'get_image_recipe',
    'get_image_recipe_output',
]

@pulumi.output_type
class GetImageRecipeResult:
    """
    A collection of values returned by getImageRecipe.
    """
    def __init__(__self__, arn=None, block_device_mappings=None, components=None, date_created=None, description=None, id=None, name=None, owner=None, parent_image=None, platform=None, region=None, tags=None, user_data_base64=None, version=None, working_directory=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if block_device_mappings and not isinstance(block_device_mappings, list):
            raise TypeError("Expected argument 'block_device_mappings' to be a list")
        pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if components and not isinstance(components, list):
            raise TypeError("Expected argument 'components' to be a list")
        pulumi.set(__self__, "components", components)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if parent_image and not isinstance(parent_image, str):
            raise TypeError("Expected argument 'parent_image' to be a str")
        pulumi.set(__self__, "parent_image", parent_image)
        if platform and not isinstance(platform, str):
            raise TypeError("Expected argument 'platform' to be a str")
        pulumi.set(__self__, "platform", platform)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if user_data_base64 and not isinstance(user_data_base64, str):
            raise TypeError("Expected argument 'user_data_base64' to be a str")
        pulumi.set(__self__, "user_data_base64", user_data_base64)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if working_directory and not isinstance(working_directory, str):
            raise TypeError("Expected argument 'working_directory' to be a str")
        pulumi.set(__self__, "working_directory", working_directory)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Sequence['outputs.GetImageRecipeBlockDeviceMappingResult']:
        """
        Set of objects with block device mappings for the image recipe.
        """
        return pulumi.get(self, "block_device_mappings")

    @_builtins.property
    @pulumi.getter
    def components(self) -> Sequence['outputs.GetImageRecipeComponentResult']:
        """
        List of objects with components for the image recipe.
        """
        return pulumi.get(self, "components")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        Date the image recipe was created.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the image recipe.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the image recipe.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        """
        Owner of the image recipe.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="parentImage")
    def parent_image(self) -> _builtins.str:
        """
        Base image of the image recipe.
        """
        return pulumi.get(self, "parent_image")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> _builtins.str:
        """
        Platform of the image recipe.
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Key-value map of resource tags for the image recipe.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userDataBase64")
    def user_data_base64(self) -> _builtins.str:
        """
        Base64 encoded contents of user data. Commands or a command script to run when build instance is launched.
        """
        return pulumi.get(self, "user_data_base64")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version of the image recipe.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> _builtins.str:
        """
        Working directory used during build and test workflows.
        """
        return pulumi.get(self, "working_directory")


class AwaitableGetImageRecipeResult(GetImageRecipeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageRecipeResult(
            arn=self.arn,
            block_device_mappings=self.block_device_mappings,
            components=self.components,
            date_created=self.date_created,
            description=self.description,
            id=self.id,
            name=self.name,
            owner=self.owner,
            parent_image=self.parent_image,
            platform=self.platform,
            region=self.region,
            tags=self.tags,
            user_data_base64=self.user_data_base64,
            version=self.version,
            working_directory=self.working_directory)


def get_image_recipe(arn: Optional[_builtins.str] = None,
                     region: Optional[_builtins.str] = None,
                     tags: Optional[Mapping[str, _builtins.str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageRecipeResult:
    """
    Provides details about an Image Builder Image Recipe.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.imagebuilder.get_image_recipe(arn="arn:aws:imagebuilder:us-east-1:aws:image-recipe/example/1.0.0")
    ```


    :param _builtins.str arn: ARN of the image recipe.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Key-value map of resource tags for the image recipe.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:imagebuilder/getImageRecipe:getImageRecipe', __args__, opts=opts, typ=GetImageRecipeResult).value

    return AwaitableGetImageRecipeResult(
        arn=pulumi.get(__ret__, 'arn'),
        block_device_mappings=pulumi.get(__ret__, 'block_device_mappings'),
        components=pulumi.get(__ret__, 'components'),
        date_created=pulumi.get(__ret__, 'date_created'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        owner=pulumi.get(__ret__, 'owner'),
        parent_image=pulumi.get(__ret__, 'parent_image'),
        platform=pulumi.get(__ret__, 'platform'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        user_data_base64=pulumi.get(__ret__, 'user_data_base64'),
        version=pulumi.get(__ret__, 'version'),
        working_directory=pulumi.get(__ret__, 'working_directory'))
def get_image_recipe_output(arn: Optional[pulumi.Input[_builtins.str]] = None,
                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImageRecipeResult]:
    """
    Provides details about an Image Builder Image Recipe.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.imagebuilder.get_image_recipe(arn="arn:aws:imagebuilder:us-east-1:aws:image-recipe/example/1.0.0")
    ```


    :param _builtins.str arn: ARN of the image recipe.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Key-value map of resource tags for the image recipe.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:imagebuilder/getImageRecipe:getImageRecipe', __args__, opts=opts, typ=GetImageRecipeResult)
    return __ret__.apply(lambda __response__: GetImageRecipeResult(
        arn=pulumi.get(__response__, 'arn'),
        block_device_mappings=pulumi.get(__response__, 'block_device_mappings'),
        components=pulumi.get(__response__, 'components'),
        date_created=pulumi.get(__response__, 'date_created'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        owner=pulumi.get(__response__, 'owner'),
        parent_image=pulumi.get(__response__, 'parent_image'),
        platform=pulumi.get(__response__, 'platform'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        user_data_base64=pulumi.get(__response__, 'user_data_base64'),
        version=pulumi.get(__response__, 'version'),
        working_directory=pulumi.get(__response__, 'working_directory')))
