# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInfrastructureConfigurationResult',
    'AwaitableGetInfrastructureConfigurationResult',
    'get_infrastructure_configuration',
    'get_infrastructure_configuration_output',
]

@pulumi.output_type
class GetInfrastructureConfigurationResult:
    """
    A collection of values returned by getInfrastructureConfiguration.
    """
    def __init__(__self__, arn=None, date_created=None, date_updated=None, description=None, id=None, instance_metadata_options=None, instance_profile_name=None, instance_types=None, key_pair=None, loggings=None, name=None, placements=None, region=None, resource_tags=None, security_group_ids=None, sns_topic_arn=None, subnet_id=None, tags=None, terminate_instance_on_failure=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if date_updated and not isinstance(date_updated, str):
            raise TypeError("Expected argument 'date_updated' to be a str")
        pulumi.set(__self__, "date_updated", date_updated)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_metadata_options and not isinstance(instance_metadata_options, list):
            raise TypeError("Expected argument 'instance_metadata_options' to be a list")
        pulumi.set(__self__, "instance_metadata_options", instance_metadata_options)
        if instance_profile_name and not isinstance(instance_profile_name, str):
            raise TypeError("Expected argument 'instance_profile_name' to be a str")
        pulumi.set(__self__, "instance_profile_name", instance_profile_name)
        if instance_types and not isinstance(instance_types, list):
            raise TypeError("Expected argument 'instance_types' to be a list")
        pulumi.set(__self__, "instance_types", instance_types)
        if key_pair and not isinstance(key_pair, str):
            raise TypeError("Expected argument 'key_pair' to be a str")
        pulumi.set(__self__, "key_pair", key_pair)
        if loggings and not isinstance(loggings, list):
            raise TypeError("Expected argument 'loggings' to be a list")
        pulumi.set(__self__, "loggings", loggings)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if placements and not isinstance(placements, list):
            raise TypeError("Expected argument 'placements' to be a list")
        pulumi.set(__self__, "placements", placements)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource_tags and not isinstance(resource_tags, dict):
            raise TypeError("Expected argument 'resource_tags' to be a dict")
        pulumi.set(__self__, "resource_tags", resource_tags)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if sns_topic_arn and not isinstance(sns_topic_arn, str):
            raise TypeError("Expected argument 'sns_topic_arn' to be a str")
        pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if terminate_instance_on_failure and not isinstance(terminate_instance_on_failure, bool):
            raise TypeError("Expected argument 'terminate_instance_on_failure' to be a bool")
        pulumi.set(__self__, "terminate_instance_on_failure", terminate_instance_on_failure)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        Date the infrastructure configuration was updated.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateUpdated")
    def date_updated(self) -> _builtins.str:
        return pulumi.get(self, "date_updated")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the infrastructure configuration.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceMetadataOptions")
    def instance_metadata_options(self) -> Sequence['outputs.GetInfrastructureConfigurationInstanceMetadataOptionResult']:
        """
        Nested list of instance metadata options for the HTTP requests that pipeline builds use to launch EC2 build and test instances.
        """
        return pulumi.get(self, "instance_metadata_options")

    @_builtins.property
    @pulumi.getter(name="instanceProfileName")
    def instance_profile_name(self) -> _builtins.str:
        """
        Name of the IAM Instance Profile associated with the configuration.
        """
        return pulumi.get(self, "instance_profile_name")

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Sequence[_builtins.str]:
        """
        Set of EC2 Instance Types associated with the configuration.
        """
        return pulumi.get(self, "instance_types")

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> _builtins.str:
        """
        Name of the EC2 Key Pair associated with the configuration.
        """
        return pulumi.get(self, "key_pair")

    @_builtins.property
    @pulumi.getter
    def loggings(self) -> Sequence['outputs.GetInfrastructureConfigurationLoggingResult']:
        """
        Nested list of logging settings.
        """
        return pulumi.get(self, "loggings")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the infrastructure configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def placements(self) -> Sequence['outputs.GetInfrastructureConfigurationPlacementResult']:
        """
        Placement settings that define where the instances that are launched from your image will run.
        """
        return pulumi.get(self, "placements")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Mapping[str, _builtins.str]:
        """
        Key-value map of resource tags for the infrastructure created by the infrastructure configuration.
        """
        return pulumi.get(self, "resource_tags")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[_builtins.str]:
        """
        Set of EC2 Security Group identifiers associated with the configuration.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> _builtins.str:
        """
        ARN of the SNS Topic associated with the configuration.
        """
        return pulumi.get(self, "sns_topic_arn")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        Identifier of the EC2 Subnet associated with the configuration.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Key-value map of resource tags for the infrastructure configuration.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="terminateInstanceOnFailure")
    def terminate_instance_on_failure(self) -> _builtins.bool:
        """
        Whether instances are terminated on failure.
        """
        return pulumi.get(self, "terminate_instance_on_failure")


class AwaitableGetInfrastructureConfigurationResult(GetInfrastructureConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInfrastructureConfigurationResult(
            arn=self.arn,
            date_created=self.date_created,
            date_updated=self.date_updated,
            description=self.description,
            id=self.id,
            instance_metadata_options=self.instance_metadata_options,
            instance_profile_name=self.instance_profile_name,
            instance_types=self.instance_types,
            key_pair=self.key_pair,
            loggings=self.loggings,
            name=self.name,
            placements=self.placements,
            region=self.region,
            resource_tags=self.resource_tags,
            security_group_ids=self.security_group_ids,
            sns_topic_arn=self.sns_topic_arn,
            subnet_id=self.subnet_id,
            tags=self.tags,
            terminate_instance_on_failure=self.terminate_instance_on_failure)


def get_infrastructure_configuration(arn: Optional[_builtins.str] = None,
                                     region: Optional[_builtins.str] = None,
                                     resource_tags: Optional[Mapping[str, _builtins.str]] = None,
                                     tags: Optional[Mapping[str, _builtins.str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInfrastructureConfigurationResult:
    """
    Provides details about an Image Builder Infrastructure Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.imagebuilder.get_infrastructure_configuration(arn="arn:aws:imagebuilder:us-west-2:aws:infrastructure-configuration/example")
    ```


    :param _builtins.str arn: ARN of the infrastructure configuration.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] resource_tags: Key-value map of resource tags for the infrastructure created by the infrastructure configuration.
    :param Mapping[str, _builtins.str] tags: Key-value map of resource tags for the infrastructure configuration.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['region'] = region
    __args__['resourceTags'] = resource_tags
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:imagebuilder/getInfrastructureConfiguration:getInfrastructureConfiguration', __args__, opts=opts, typ=GetInfrastructureConfigurationResult).value

    return AwaitableGetInfrastructureConfigurationResult(
        arn=pulumi.get(__ret__, 'arn'),
        date_created=pulumi.get(__ret__, 'date_created'),
        date_updated=pulumi.get(__ret__, 'date_updated'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        instance_metadata_options=pulumi.get(__ret__, 'instance_metadata_options'),
        instance_profile_name=pulumi.get(__ret__, 'instance_profile_name'),
        instance_types=pulumi.get(__ret__, 'instance_types'),
        key_pair=pulumi.get(__ret__, 'key_pair'),
        loggings=pulumi.get(__ret__, 'loggings'),
        name=pulumi.get(__ret__, 'name'),
        placements=pulumi.get(__ret__, 'placements'),
        region=pulumi.get(__ret__, 'region'),
        resource_tags=pulumi.get(__ret__, 'resource_tags'),
        security_group_ids=pulumi.get(__ret__, 'security_group_ids'),
        sns_topic_arn=pulumi.get(__ret__, 'sns_topic_arn'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        tags=pulumi.get(__ret__, 'tags'),
        terminate_instance_on_failure=pulumi.get(__ret__, 'terminate_instance_on_failure'))
def get_infrastructure_configuration_output(arn: Optional[pulumi.Input[_builtins.str]] = None,
                                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            resource_tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                            tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInfrastructureConfigurationResult]:
    """
    Provides details about an Image Builder Infrastructure Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.imagebuilder.get_infrastructure_configuration(arn="arn:aws:imagebuilder:us-west-2:aws:infrastructure-configuration/example")
    ```


    :param _builtins.str arn: ARN of the infrastructure configuration.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] resource_tags: Key-value map of resource tags for the infrastructure created by the infrastructure configuration.
    :param Mapping[str, _builtins.str] tags: Key-value map of resource tags for the infrastructure configuration.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['region'] = region
    __args__['resourceTags'] = resource_tags
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:imagebuilder/getInfrastructureConfiguration:getInfrastructureConfiguration', __args__, opts=opts, typ=GetInfrastructureConfigurationResult)
    return __ret__.apply(lambda __response__: GetInfrastructureConfigurationResult(
        arn=pulumi.get(__response__, 'arn'),
        date_created=pulumi.get(__response__, 'date_created'),
        date_updated=pulumi.get(__response__, 'date_updated'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        instance_metadata_options=pulumi.get(__response__, 'instance_metadata_options'),
        instance_profile_name=pulumi.get(__response__, 'instance_profile_name'),
        instance_types=pulumi.get(__response__, 'instance_types'),
        key_pair=pulumi.get(__response__, 'key_pair'),
        loggings=pulumi.get(__response__, 'loggings'),
        name=pulumi.get(__response__, 'name'),
        placements=pulumi.get(__response__, 'placements'),
        region=pulumi.get(__response__, 'region'),
        resource_tags=pulumi.get(__response__, 'resource_tags'),
        security_group_ids=pulumi.get(__response__, 'security_group_ids'),
        sns_topic_arn=pulumi.get(__response__, 'sns_topic_arn'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        tags=pulumi.get(__response__, 'tags'),
        terminate_instance_on_failure=pulumi.get(__response__, 'terminate_instance_on_failure')))
