# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InfrastructureConfigurationArgs', 'InfrastructureConfiguration']

@pulumi.input_type
class InfrastructureConfigurationArgs:
    def __init__(__self__, *,
                 instance_profile_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_metadata_options: Optional[pulumi.Input['InfrastructureConfigurationInstanceMetadataOptionsArgs']] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 logging: Optional[pulumi.Input['InfrastructureConfigurationLoggingArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 placement: Optional[pulumi.Input['InfrastructureConfigurationPlacementArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sns_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 terminate_instance_on_failure: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a InfrastructureConfiguration resource.
        :param pulumi.Input[_builtins.str] instance_profile_name: Name of IAM Instance Profile.
        :param pulumi.Input[_builtins.str] description: Description for the configuration.
        :param pulumi.Input['InfrastructureConfigurationInstanceMetadataOptionsArgs'] instance_metadata_options: Configuration block with instance metadata options for the HTTP requests that pipeline builds use to launch EC2 build and test instances. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: Set of EC2 Instance Types.
        :param pulumi.Input[_builtins.str] key_pair: Name of EC2 Key Pair.
        :param pulumi.Input['InfrastructureConfigurationLoggingArgs'] logging: Configuration block with logging settings. Detailed below.
        :param pulumi.Input[_builtins.str] name: Name for the configuration.
               
               The following arguments are optional:
        :param pulumi.Input['InfrastructureConfigurationPlacementArgs'] placement: Configuration block with placement settings that define where the instances that are launched from your image will run. Detailed below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: Key-value map of resource tags to assign to infrastructure created by the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Set of EC2 Security Group identifiers.
        :param pulumi.Input[_builtins.str] sns_topic_arn: Amazon Resource Name (ARN) of SNS Topic.
        :param pulumi.Input[_builtins.str] subnet_id: EC2 Subnet identifier. Also requires `security_group_ids` argument.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags to assign to the configuration. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.bool] terminate_instance_on_failure: Enable if the instance should be terminated when the pipeline fails. Defaults to `false`.
        """
        pulumi.set(__self__, "instance_profile_name", instance_profile_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_metadata_options is not None:
            pulumi.set(__self__, "instance_metadata_options", instance_metadata_options)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if sns_topic_arn is not None:
            pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if terminate_instance_on_failure is not None:
            pulumi.set(__self__, "terminate_instance_on_failure", terminate_instance_on_failure)

    @_builtins.property
    @pulumi.getter(name="instanceProfileName")
    def instance_profile_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of IAM Instance Profile.
        """
        return pulumi.get(self, "instance_profile_name")

    @instance_profile_name.setter
    def instance_profile_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_profile_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceMetadataOptions")
    def instance_metadata_options(self) -> Optional[pulumi.Input['InfrastructureConfigurationInstanceMetadataOptionsArgs']]:
        """
        Configuration block with instance metadata options for the HTTP requests that pipeline builds use to launch EC2 build and test instances. Detailed below.
        """
        return pulumi.get(self, "instance_metadata_options")

    @instance_metadata_options.setter
    def instance_metadata_options(self, value: Optional[pulumi.Input['InfrastructureConfigurationInstanceMetadataOptionsArgs']]):
        pulumi.set(self, "instance_metadata_options", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of EC2 Instance Types.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of EC2 Key Pair.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['InfrastructureConfigurationLoggingArgs']]:
        """
        Configuration block with logging settings. Detailed below.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['InfrastructureConfigurationLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the configuration.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input['InfrastructureConfigurationPlacementArgs']]:
        """
        Configuration block with placement settings that define where the instances that are launched from your image will run. Detailed below.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input['InfrastructureConfigurationPlacementArgs']]):
        pulumi.set(self, "placement", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags to assign to infrastructure created by the configuration.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_tags", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of EC2 Security Group identifiers.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of SNS Topic.
        """
        return pulumi.get(self, "sns_topic_arn")

    @sns_topic_arn.setter
    def sns_topic_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sns_topic_arn", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EC2 Subnet identifier. Also requires `security_group_ids` argument.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags to assign to the configuration. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminateInstanceOnFailure")
    def terminate_instance_on_failure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable if the instance should be terminated when the pipeline fails. Defaults to `false`.
        """
        return pulumi.get(self, "terminate_instance_on_failure")

    @terminate_instance_on_failure.setter
    def terminate_instance_on_failure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "terminate_instance_on_failure", value)


@pulumi.input_type
class _InfrastructureConfigurationState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 date_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_metadata_options: Optional[pulumi.Input['InfrastructureConfigurationInstanceMetadataOptionsArgs']] = None,
                 instance_profile_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 logging: Optional[pulumi.Input['InfrastructureConfigurationLoggingArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 placement: Optional[pulumi.Input['InfrastructureConfigurationPlacementArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sns_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 terminate_instance_on_failure: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering InfrastructureConfiguration resources.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the configuration.
        :param pulumi.Input[_builtins.str] date_created: Date when the configuration was created.
        :param pulumi.Input[_builtins.str] date_updated: Date when the configuration was updated.
        :param pulumi.Input[_builtins.str] description: Description for the configuration.
        :param pulumi.Input['InfrastructureConfigurationInstanceMetadataOptionsArgs'] instance_metadata_options: Configuration block with instance metadata options for the HTTP requests that pipeline builds use to launch EC2 build and test instances. Detailed below.
        :param pulumi.Input[_builtins.str] instance_profile_name: Name of IAM Instance Profile.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: Set of EC2 Instance Types.
        :param pulumi.Input[_builtins.str] key_pair: Name of EC2 Key Pair.
        :param pulumi.Input['InfrastructureConfigurationLoggingArgs'] logging: Configuration block with logging settings. Detailed below.
        :param pulumi.Input[_builtins.str] name: Name for the configuration.
               
               The following arguments are optional:
        :param pulumi.Input['InfrastructureConfigurationPlacementArgs'] placement: Configuration block with placement settings that define where the instances that are launched from your image will run. Detailed below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: Key-value map of resource tags to assign to infrastructure created by the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Set of EC2 Security Group identifiers.
        :param pulumi.Input[_builtins.str] sns_topic_arn: Amazon Resource Name (ARN) of SNS Topic.
        :param pulumi.Input[_builtins.str] subnet_id: EC2 Subnet identifier. Also requires `security_group_ids` argument.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags to assign to the configuration. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] terminate_instance_on_failure: Enable if the instance should be terminated when the pipeline fails. Defaults to `false`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_updated is not None:
            pulumi.set(__self__, "date_updated", date_updated)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_metadata_options is not None:
            pulumi.set(__self__, "instance_metadata_options", instance_metadata_options)
        if instance_profile_name is not None:
            pulumi.set(__self__, "instance_profile_name", instance_profile_name)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if sns_topic_arn is not None:
            pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if terminate_instance_on_failure is not None:
            pulumi.set(__self__, "terminate_instance_on_failure", terminate_instance_on_failure)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the configuration.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date when the configuration was created.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="dateUpdated")
    def date_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date when the configuration was updated.
        """
        return pulumi.get(self, "date_updated")

    @date_updated.setter
    def date_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_updated", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceMetadataOptions")
    def instance_metadata_options(self) -> Optional[pulumi.Input['InfrastructureConfigurationInstanceMetadataOptionsArgs']]:
        """
        Configuration block with instance metadata options for the HTTP requests that pipeline builds use to launch EC2 build and test instances. Detailed below.
        """
        return pulumi.get(self, "instance_metadata_options")

    @instance_metadata_options.setter
    def instance_metadata_options(self, value: Optional[pulumi.Input['InfrastructureConfigurationInstanceMetadataOptionsArgs']]):
        pulumi.set(self, "instance_metadata_options", value)

    @_builtins.property
    @pulumi.getter(name="instanceProfileName")
    def instance_profile_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of IAM Instance Profile.
        """
        return pulumi.get(self, "instance_profile_name")

    @instance_profile_name.setter
    def instance_profile_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_profile_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of EC2 Instance Types.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of EC2 Key Pair.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['InfrastructureConfigurationLoggingArgs']]:
        """
        Configuration block with logging settings. Detailed below.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['InfrastructureConfigurationLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the configuration.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input['InfrastructureConfigurationPlacementArgs']]:
        """
        Configuration block with placement settings that define where the instances that are launched from your image will run. Detailed below.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input['InfrastructureConfigurationPlacementArgs']]):
        pulumi.set(self, "placement", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags to assign to infrastructure created by the configuration.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_tags", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of EC2 Security Group identifiers.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of SNS Topic.
        """
        return pulumi.get(self, "sns_topic_arn")

    @sns_topic_arn.setter
    def sns_topic_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sns_topic_arn", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EC2 Subnet identifier. Also requires `security_group_ids` argument.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags to assign to the configuration. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="terminateInstanceOnFailure")
    def terminate_instance_on_failure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable if the instance should be terminated when the pipeline fails. Defaults to `false`.
        """
        return pulumi.get(self, "terminate_instance_on_failure")

    @terminate_instance_on_failure.setter
    def terminate_instance_on_failure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "terminate_instance_on_failure", value)


@pulumi.type_token("aws:imagebuilder/infrastructureConfiguration:InfrastructureConfiguration")
class InfrastructureConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_metadata_options: Optional[pulumi.Input[Union['InfrastructureConfigurationInstanceMetadataOptionsArgs', 'InfrastructureConfigurationInstanceMetadataOptionsArgsDict']]] = None,
                 instance_profile_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 logging: Optional[pulumi.Input[Union['InfrastructureConfigurationLoggingArgs', 'InfrastructureConfigurationLoggingArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 placement: Optional[pulumi.Input[Union['InfrastructureConfigurationPlacementArgs', 'InfrastructureConfigurationPlacementArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sns_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 terminate_instance_on_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages an Image Builder Infrastructure Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.imagebuilder.InfrastructureConfiguration("example",
            description="example description",
            instance_profile_name=example_aws_iam_instance_profile["name"],
            instance_types=[
                "t2.nano",
                "t3.micro",
            ],
            key_pair=example_aws_key_pair["keyName"],
            name="example",
            security_group_ids=[example_aws_security_group["id"]],
            sns_topic_arn=example_aws_sns_topic["arn"],
            subnet_id=main["id"],
            terminate_instance_on_failure=True,
            logging={
                "s3_logs": {
                    "s3_bucket_name": example_aws_s3_bucket["bucket"],
                    "s3_key_prefix": "logs",
                },
            },
            tags={
                "foo": "bar",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_imagebuilder_infrastructure_configuration` using the Amazon Resource Name (ARN). For example:

        ```sh
        $ pulumi import aws:imagebuilder/infrastructureConfiguration:InfrastructureConfiguration example arn:aws:imagebuilder:us-east-1:123456789012:infrastructure-configuration/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description for the configuration.
        :param pulumi.Input[Union['InfrastructureConfigurationInstanceMetadataOptionsArgs', 'InfrastructureConfigurationInstanceMetadataOptionsArgsDict']] instance_metadata_options: Configuration block with instance metadata options for the HTTP requests that pipeline builds use to launch EC2 build and test instances. Detailed below.
        :param pulumi.Input[_builtins.str] instance_profile_name: Name of IAM Instance Profile.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: Set of EC2 Instance Types.
        :param pulumi.Input[_builtins.str] key_pair: Name of EC2 Key Pair.
        :param pulumi.Input[Union['InfrastructureConfigurationLoggingArgs', 'InfrastructureConfigurationLoggingArgsDict']] logging: Configuration block with logging settings. Detailed below.
        :param pulumi.Input[_builtins.str] name: Name for the configuration.
               
               The following arguments are optional:
        :param pulumi.Input[Union['InfrastructureConfigurationPlacementArgs', 'InfrastructureConfigurationPlacementArgsDict']] placement: Configuration block with placement settings that define where the instances that are launched from your image will run. Detailed below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: Key-value map of resource tags to assign to infrastructure created by the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Set of EC2 Security Group identifiers.
        :param pulumi.Input[_builtins.str] sns_topic_arn: Amazon Resource Name (ARN) of SNS Topic.
        :param pulumi.Input[_builtins.str] subnet_id: EC2 Subnet identifier. Also requires `security_group_ids` argument.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags to assign to the configuration. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.bool] terminate_instance_on_failure: Enable if the instance should be terminated when the pipeline fails. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InfrastructureConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Image Builder Infrastructure Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.imagebuilder.InfrastructureConfiguration("example",
            description="example description",
            instance_profile_name=example_aws_iam_instance_profile["name"],
            instance_types=[
                "t2.nano",
                "t3.micro",
            ],
            key_pair=example_aws_key_pair["keyName"],
            name="example",
            security_group_ids=[example_aws_security_group["id"]],
            sns_topic_arn=example_aws_sns_topic["arn"],
            subnet_id=main["id"],
            terminate_instance_on_failure=True,
            logging={
                "s3_logs": {
                    "s3_bucket_name": example_aws_s3_bucket["bucket"],
                    "s3_key_prefix": "logs",
                },
            },
            tags={
                "foo": "bar",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_imagebuilder_infrastructure_configuration` using the Amazon Resource Name (ARN). For example:

        ```sh
        $ pulumi import aws:imagebuilder/infrastructureConfiguration:InfrastructureConfiguration example arn:aws:imagebuilder:us-east-1:123456789012:infrastructure-configuration/example
        ```

        :param str resource_name: The name of the resource.
        :param InfrastructureConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InfrastructureConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_metadata_options: Optional[pulumi.Input[Union['InfrastructureConfigurationInstanceMetadataOptionsArgs', 'InfrastructureConfigurationInstanceMetadataOptionsArgsDict']]] = None,
                 instance_profile_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 logging: Optional[pulumi.Input[Union['InfrastructureConfigurationLoggingArgs', 'InfrastructureConfigurationLoggingArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 placement: Optional[pulumi.Input[Union['InfrastructureConfigurationPlacementArgs', 'InfrastructureConfigurationPlacementArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sns_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 terminate_instance_on_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InfrastructureConfigurationArgs.__new__(InfrastructureConfigurationArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["instance_metadata_options"] = instance_metadata_options
            if instance_profile_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_profile_name'")
            __props__.__dict__["instance_profile_name"] = instance_profile_name
            __props__.__dict__["instance_types"] = instance_types
            __props__.__dict__["key_pair"] = key_pair
            __props__.__dict__["logging"] = logging
            __props__.__dict__["name"] = name
            __props__.__dict__["placement"] = placement
            __props__.__dict__["region"] = region
            __props__.__dict__["resource_tags"] = resource_tags
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["sns_topic_arn"] = sns_topic_arn
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["terminate_instance_on_failure"] = terminate_instance_on_failure
            __props__.__dict__["arn"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["date_updated"] = None
            __props__.__dict__["tags_all"] = None
        super(InfrastructureConfiguration, __self__).__init__(
            'aws:imagebuilder/infrastructureConfiguration:InfrastructureConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            date_updated: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_metadata_options: Optional[pulumi.Input[Union['InfrastructureConfigurationInstanceMetadataOptionsArgs', 'InfrastructureConfigurationInstanceMetadataOptionsArgsDict']]] = None,
            instance_profile_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            key_pair: Optional[pulumi.Input[_builtins.str]] = None,
            logging: Optional[pulumi.Input[Union['InfrastructureConfigurationLoggingArgs', 'InfrastructureConfigurationLoggingArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            placement: Optional[pulumi.Input[Union['InfrastructureConfigurationPlacementArgs', 'InfrastructureConfigurationPlacementArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sns_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            terminate_instance_on_failure: Optional[pulumi.Input[_builtins.bool]] = None) -> 'InfrastructureConfiguration':
        """
        Get an existing InfrastructureConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the configuration.
        :param pulumi.Input[_builtins.str] date_created: Date when the configuration was created.
        :param pulumi.Input[_builtins.str] date_updated: Date when the configuration was updated.
        :param pulumi.Input[_builtins.str] description: Description for the configuration.
        :param pulumi.Input[Union['InfrastructureConfigurationInstanceMetadataOptionsArgs', 'InfrastructureConfigurationInstanceMetadataOptionsArgsDict']] instance_metadata_options: Configuration block with instance metadata options for the HTTP requests that pipeline builds use to launch EC2 build and test instances. Detailed below.
        :param pulumi.Input[_builtins.str] instance_profile_name: Name of IAM Instance Profile.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: Set of EC2 Instance Types.
        :param pulumi.Input[_builtins.str] key_pair: Name of EC2 Key Pair.
        :param pulumi.Input[Union['InfrastructureConfigurationLoggingArgs', 'InfrastructureConfigurationLoggingArgsDict']] logging: Configuration block with logging settings. Detailed below.
        :param pulumi.Input[_builtins.str] name: Name for the configuration.
               
               The following arguments are optional:
        :param pulumi.Input[Union['InfrastructureConfigurationPlacementArgs', 'InfrastructureConfigurationPlacementArgsDict']] placement: Configuration block with placement settings that define where the instances that are launched from your image will run. Detailed below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: Key-value map of resource tags to assign to infrastructure created by the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Set of EC2 Security Group identifiers.
        :param pulumi.Input[_builtins.str] sns_topic_arn: Amazon Resource Name (ARN) of SNS Topic.
        :param pulumi.Input[_builtins.str] subnet_id: EC2 Subnet identifier. Also requires `security_group_ids` argument.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags to assign to the configuration. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] terminate_instance_on_failure: Enable if the instance should be terminated when the pipeline fails. Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InfrastructureConfigurationState.__new__(_InfrastructureConfigurationState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["date_updated"] = date_updated
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_metadata_options"] = instance_metadata_options
        __props__.__dict__["instance_profile_name"] = instance_profile_name
        __props__.__dict__["instance_types"] = instance_types
        __props__.__dict__["key_pair"] = key_pair
        __props__.__dict__["logging"] = logging
        __props__.__dict__["name"] = name
        __props__.__dict__["placement"] = placement
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_tags"] = resource_tags
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["sns_topic_arn"] = sns_topic_arn
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["terminate_instance_on_failure"] = terminate_instance_on_failure
        return InfrastructureConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the configuration.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        Date when the configuration was created.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateUpdated")
    def date_updated(self) -> pulumi.Output[_builtins.str]:
        """
        Date when the configuration was updated.
        """
        return pulumi.get(self, "date_updated")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description for the configuration.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceMetadataOptions")
    def instance_metadata_options(self) -> pulumi.Output[Optional['outputs.InfrastructureConfigurationInstanceMetadataOptions']]:
        """
        Configuration block with instance metadata options for the HTTP requests that pipeline builds use to launch EC2 build and test instances. Detailed below.
        """
        return pulumi.get(self, "instance_metadata_options")

    @_builtins.property
    @pulumi.getter(name="instanceProfileName")
    def instance_profile_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of IAM Instance Profile.
        """
        return pulumi.get(self, "instance_profile_name")

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of EC2 Instance Types.
        """
        return pulumi.get(self, "instance_types")

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of EC2 Key Pair.
        """
        return pulumi.get(self, "key_pair")

    @_builtins.property
    @pulumi.getter
    def logging(self) -> pulumi.Output[Optional['outputs.InfrastructureConfigurationLogging']]:
        """
        Configuration block with logging settings. Detailed below.
        """
        return pulumi.get(self, "logging")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name for the configuration.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> pulumi.Output[Optional['outputs.InfrastructureConfigurationPlacement']]:
        """
        Configuration block with placement settings that define where the instances that are launched from your image will run. Detailed below.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags to assign to infrastructure created by the configuration.
        """
        return pulumi.get(self, "resource_tags")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of EC2 Security Group identifiers.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of SNS Topic.
        """
        return pulumi.get(self, "sns_topic_arn")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        EC2 Subnet identifier. Also requires `security_group_ids` argument.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags to assign to the configuration. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="terminateInstanceOnFailure")
    def terminate_instance_on_failure(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable if the instance should be terminated when the pipeline fails. Defaults to `false`.
        """
        return pulumi.get(self, "terminate_instance_on_failure")

