# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ThingPrincipalAttachmentArgs', 'ThingPrincipalAttachment']

@pulumi.input_type
class ThingPrincipalAttachmentArgs:
    def __init__(__self__, *,
                 principal: pulumi.Input[_builtins.str],
                 thing: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 thing_principal_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ThingPrincipalAttachment resource.
        :param pulumi.Input[_builtins.str] principal: The AWS IoT Certificate ARN or Amazon Cognito Identity ID.
        :param pulumi.Input[_builtins.str] thing: The name of the thing.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] thing_principal_type: The type of relationship to specify when attaching a principal to a thing. Valid values are `EXCLUSIVE_THING` (the thing will be the only one attached to the principal) or `NON_EXCLUSIVE_THING` (multiple things can be attached to the principal). Defaults to `NON_EXCLUSIVE_THING`.
        """
        pulumi.set(__self__, "principal", principal)
        pulumi.set(__self__, "thing", thing)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if thing_principal_type is not None:
            pulumi.set(__self__, "thing_principal_type", thing_principal_type)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Input[_builtins.str]:
        """
        The AWS IoT Certificate ARN or Amazon Cognito Identity ID.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter
    def thing(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the thing.
        """
        return pulumi.get(self, "thing")

    @thing.setter
    def thing(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "thing", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="thingPrincipalType")
    def thing_principal_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of relationship to specify when attaching a principal to a thing. Valid values are `EXCLUSIVE_THING` (the thing will be the only one attached to the principal) or `NON_EXCLUSIVE_THING` (multiple things can be attached to the principal). Defaults to `NON_EXCLUSIVE_THING`.
        """
        return pulumi.get(self, "thing_principal_type")

    @thing_principal_type.setter
    def thing_principal_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "thing_principal_type", value)


@pulumi.input_type
class _ThingPrincipalAttachmentState:
    def __init__(__self__, *,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 thing: Optional[pulumi.Input[_builtins.str]] = None,
                 thing_principal_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ThingPrincipalAttachment resources.
        :param pulumi.Input[_builtins.str] principal: The AWS IoT Certificate ARN or Amazon Cognito Identity ID.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] thing: The name of the thing.
        :param pulumi.Input[_builtins.str] thing_principal_type: The type of relationship to specify when attaching a principal to a thing. Valid values are `EXCLUSIVE_THING` (the thing will be the only one attached to the principal) or `NON_EXCLUSIVE_THING` (multiple things can be attached to the principal). Defaults to `NON_EXCLUSIVE_THING`.
        """
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if thing is not None:
            pulumi.set(__self__, "thing", thing)
        if thing_principal_type is not None:
            pulumi.set(__self__, "thing_principal_type", thing_principal_type)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS IoT Certificate ARN or Amazon Cognito Identity ID.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def thing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the thing.
        """
        return pulumi.get(self, "thing")

    @thing.setter
    def thing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "thing", value)

    @_builtins.property
    @pulumi.getter(name="thingPrincipalType")
    def thing_principal_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of relationship to specify when attaching a principal to a thing. Valid values are `EXCLUSIVE_THING` (the thing will be the only one attached to the principal) or `NON_EXCLUSIVE_THING` (multiple things can be attached to the principal). Defaults to `NON_EXCLUSIVE_THING`.
        """
        return pulumi.get(self, "thing_principal_type")

    @thing_principal_type.setter
    def thing_principal_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "thing_principal_type", value)


@pulumi.type_token("aws:iot/thingPrincipalAttachment:ThingPrincipalAttachment")
class ThingPrincipalAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 thing: Optional[pulumi.Input[_builtins.str]] = None,
                 thing_principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Attaches Principal to AWS IoT Thing.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.iot.Thing("example", name="example")
        cert = aws.iot.Certificate("cert",
            csr=std.file(input="csr.pem").result,
            active=True)
        att = aws.iot.ThingPrincipalAttachment("att",
            principal=cert.arn,
            thing=example.name)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] principal: The AWS IoT Certificate ARN or Amazon Cognito Identity ID.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] thing: The name of the thing.
        :param pulumi.Input[_builtins.str] thing_principal_type: The type of relationship to specify when attaching a principal to a thing. Valid values are `EXCLUSIVE_THING` (the thing will be the only one attached to the principal) or `NON_EXCLUSIVE_THING` (multiple things can be attached to the principal). Defaults to `NON_EXCLUSIVE_THING`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ThingPrincipalAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Attaches Principal to AWS IoT Thing.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.iot.Thing("example", name="example")
        cert = aws.iot.Certificate("cert",
            csr=std.file(input="csr.pem").result,
            active=True)
        att = aws.iot.ThingPrincipalAttachment("att",
            principal=cert.arn,
            thing=example.name)
        ```

        :param str resource_name: The name of the resource.
        :param ThingPrincipalAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ThingPrincipalAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 thing: Optional[pulumi.Input[_builtins.str]] = None,
                 thing_principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ThingPrincipalAttachmentArgs.__new__(ThingPrincipalAttachmentArgs)

            if principal is None and not opts.urn:
                raise TypeError("Missing required property 'principal'")
            __props__.__dict__["principal"] = principal
            __props__.__dict__["region"] = region
            if thing is None and not opts.urn:
                raise TypeError("Missing required property 'thing'")
            __props__.__dict__["thing"] = thing
            __props__.__dict__["thing_principal_type"] = thing_principal_type
        super(ThingPrincipalAttachment, __self__).__init__(
            'aws:iot/thingPrincipalAttachment:ThingPrincipalAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            principal: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            thing: Optional[pulumi.Input[_builtins.str]] = None,
            thing_principal_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'ThingPrincipalAttachment':
        """
        Get an existing ThingPrincipalAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] principal: The AWS IoT Certificate ARN or Amazon Cognito Identity ID.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] thing: The name of the thing.
        :param pulumi.Input[_builtins.str] thing_principal_type: The type of relationship to specify when attaching a principal to a thing. Valid values are `EXCLUSIVE_THING` (the thing will be the only one attached to the principal) or `NON_EXCLUSIVE_THING` (multiple things can be attached to the principal). Defaults to `NON_EXCLUSIVE_THING`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ThingPrincipalAttachmentState.__new__(_ThingPrincipalAttachmentState)

        __props__.__dict__["principal"] = principal
        __props__.__dict__["region"] = region
        __props__.__dict__["thing"] = thing
        __props__.__dict__["thing_principal_type"] = thing_principal_type
        return ThingPrincipalAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Output[_builtins.str]:
        """
        The AWS IoT Certificate ARN or Amazon Cognito Identity ID.
        """
        return pulumi.get(self, "principal")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def thing(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the thing.
        """
        return pulumi.get(self, "thing")

    @_builtins.property
    @pulumi.getter(name="thingPrincipalType")
    def thing_principal_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of relationship to specify when attaching a principal to a thing. Valid values are `EXCLUSIVE_THING` (the thing will be the only one attached to the principal) or `NON_EXCLUSIVE_THING` (multiple things can be attached to the principal). Defaults to `NON_EXCLUSIVE_THING`.
        """
        return pulumi.get(self, "thing_principal_type")

