# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'CustomKeyStoreXksProxyAuthenticationCredentialArgs',
    'CustomKeyStoreXksProxyAuthenticationCredentialArgsDict',
    'GrantConstraintArgs',
    'GrantConstraintArgsDict',
    'GetSecretSecretArgs',
    'GetSecretSecretArgsDict',
    'GetSecretsSecretArgs',
    'GetSecretsSecretArgsDict',
]

MYPY = False

if not MYPY:
    class CustomKeyStoreXksProxyAuthenticationCredentialArgsDict(TypedDict):
        access_key_id: pulumi.Input[_builtins.str]
        """
        A unique identifier for the raw secret access key.
        """
        raw_secret_access_key: pulumi.Input[_builtins.str]
        """
        A secret string of 43-64 characters.
        """
elif False:
    CustomKeyStoreXksProxyAuthenticationCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CustomKeyStoreXksProxyAuthenticationCredentialArgs:
    def __init__(__self__, *,
                 access_key_id: pulumi.Input[_builtins.str],
                 raw_secret_access_key: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] access_key_id: A unique identifier for the raw secret access key.
        :param pulumi.Input[_builtins.str] raw_secret_access_key: A secret string of 43-64 characters.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "raw_secret_access_key", raw_secret_access_key)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> pulumi.Input[_builtins.str]:
        """
        A unique identifier for the raw secret access key.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="rawSecretAccessKey")
    def raw_secret_access_key(self) -> pulumi.Input[_builtins.str]:
        """
        A secret string of 43-64 characters.
        """
        return pulumi.get(self, "raw_secret_access_key")

    @raw_secret_access_key.setter
    def raw_secret_access_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "raw_secret_access_key", value)


if not MYPY:
    class GrantConstraintArgsDict(TypedDict):
        encryption_context_equals: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A list of key-value pairs that must match the encryption context in subsequent cryptographic operation requests. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint. Conflicts with `encryption_context_subset`.
        """
        encryption_context_subset: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A list of key-value pairs that must be included in the encryption context of subsequent cryptographic operation requests. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs. Conflicts with `encryption_context_equals`.
        """
elif False:
    GrantConstraintArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GrantConstraintArgs:
    def __init__(__self__, *,
                 encryption_context_equals: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 encryption_context_subset: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] encryption_context_equals: A list of key-value pairs that must match the encryption context in subsequent cryptographic operation requests. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint. Conflicts with `encryption_context_subset`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] encryption_context_subset: A list of key-value pairs that must be included in the encryption context of subsequent cryptographic operation requests. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs. Conflicts with `encryption_context_equals`.
        """
        if encryption_context_equals is not None:
            pulumi.set(__self__, "encryption_context_equals", encryption_context_equals)
        if encryption_context_subset is not None:
            pulumi.set(__self__, "encryption_context_subset", encryption_context_subset)

    @_builtins.property
    @pulumi.getter(name="encryptionContextEquals")
    def encryption_context_equals(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A list of key-value pairs that must match the encryption context in subsequent cryptographic operation requests. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint. Conflicts with `encryption_context_subset`.
        """
        return pulumi.get(self, "encryption_context_equals")

    @encryption_context_equals.setter
    def encryption_context_equals(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "encryption_context_equals", value)

    @_builtins.property
    @pulumi.getter(name="encryptionContextSubset")
    def encryption_context_subset(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A list of key-value pairs that must be included in the encryption context of subsequent cryptographic operation requests. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs. Conflicts with `encryption_context_equals`.
        """
        return pulumi.get(self, "encryption_context_subset")

    @encryption_context_subset.setter
    def encryption_context_subset(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "encryption_context_subset", value)


if not MYPY:
    class GetSecretSecretArgsDict(TypedDict):
        name: _builtins.str
        payload: _builtins.str
        context: NotRequired[Mapping[str, _builtins.str]]
        grant_tokens: NotRequired[Sequence[_builtins.str]]
elif False:
    GetSecretSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetSecretSecretArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 payload: _builtins.str,
                 context: Optional[Mapping[str, _builtins.str]] = None,
                 grant_tokens: Optional[Sequence[_builtins.str]] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "payload", payload)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if grant_tokens is not None:
            pulumi.set(__self__, "grant_tokens", grant_tokens)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def payload(self) -> _builtins.str:
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: _builtins.str):
        pulumi.set(self, "payload", value)

    @_builtins.property
    @pulumi.getter
    def context(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[Mapping[str, _builtins.str]]):
        pulumi.set(self, "context", value)

    @_builtins.property
    @pulumi.getter(name="grantTokens")
    def grant_tokens(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "grant_tokens")

    @grant_tokens.setter
    def grant_tokens(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "grant_tokens", value)


if not MYPY:
    class GetSecretsSecretArgsDict(TypedDict):
        name: _builtins.str
        """
        Name to export this secret under in the attributes.
        """
        payload: _builtins.str
        """
        Base64 encoded payload, as returned from a KMS encrypt operation.
        """
        context: NotRequired[Mapping[str, _builtins.str]]
        """
        An optional mapping that makes up the Encryption Context for the secret.
        """
        encryption_algorithm: NotRequired[_builtins.str]
        """
        The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
        """
        grant_tokens: NotRequired[Sequence[_builtins.str]]
        """
        An optional list of Grant Tokens for the secret.
        """
        key_id: NotRequired[_builtins.str]
        """
        Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.

        For more information on `context` and `grant_tokens` see the [KMS
        Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
        """
elif False:
    GetSecretsSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetSecretsSecretArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 payload: _builtins.str,
                 context: Optional[Mapping[str, _builtins.str]] = None,
                 encryption_algorithm: Optional[_builtins.str] = None,
                 grant_tokens: Optional[Sequence[_builtins.str]] = None,
                 key_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name to export this secret under in the attributes.
        :param _builtins.str payload: Base64 encoded payload, as returned from a KMS encrypt operation.
        :param Mapping[str, _builtins.str] context: An optional mapping that makes up the Encryption Context for the secret.
        :param _builtins.str encryption_algorithm: The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
        :param Sequence[_builtins.str] grant_tokens: An optional list of Grant Tokens for the secret.
        :param _builtins.str key_id: Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.
               
               For more information on `context` and `grant_tokens` see the [KMS
               Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "payload", payload)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if encryption_algorithm is not None:
            pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        if grant_tokens is not None:
            pulumi.set(__self__, "grant_tokens", grant_tokens)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name to export this secret under in the attributes.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def payload(self) -> _builtins.str:
        """
        Base64 encoded payload, as returned from a KMS encrypt operation.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: _builtins.str):
        pulumi.set(self, "payload", value)

    @_builtins.property
    @pulumi.getter
    def context(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        An optional mapping that makes up the Encryption Context for the secret.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[Mapping[str, _builtins.str]]):
        pulumi.set(self, "context", value)

    @_builtins.property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> Optional[_builtins.str]:
        """
        The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
        """
        return pulumi.get(self, "encryption_algorithm")

    @encryption_algorithm.setter
    def encryption_algorithm(self, value: Optional[_builtins.str]):
        pulumi.set(self, "encryption_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="grantTokens")
    def grant_tokens(self) -> Optional[Sequence[_builtins.str]]:
        """
        An optional list of Grant Tokens for the secret.
        """
        return pulumi.get(self, "grant_tokens")

    @grant_tokens.setter
    def grant_tokens(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "grant_tokens", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[_builtins.str]:
        """
        Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.

        For more information on `context` and `grant_tokens` see the [KMS
        Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[_builtins.str]):
        pulumi.set(self, "key_id", value)


