# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CustomKeyStoreXksProxyAuthenticationCredential',
    'GrantConstraint',
    'GetKeyMultiRegionConfigurationResult',
    'GetKeyMultiRegionConfigurationPrimaryKeyResult',
    'GetKeyMultiRegionConfigurationReplicaKeyResult',
    'GetKeyXksKeyConfigurationResult',
    'GetSecretSecretResult',
    'GetSecretsSecretResult',
]

@pulumi.output_type
class CustomKeyStoreXksProxyAuthenticationCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "rawSecretAccessKey":
            suggest = "raw_secret_access_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomKeyStoreXksProxyAuthenticationCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomKeyStoreXksProxyAuthenticationCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomKeyStoreXksProxyAuthenticationCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_id: _builtins.str,
                 raw_secret_access_key: _builtins.str):
        """
        :param _builtins.str access_key_id: A unique identifier for the raw secret access key.
        :param _builtins.str raw_secret_access_key: A secret string of 43-64 characters.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "raw_secret_access_key", raw_secret_access_key)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> _builtins.str:
        """
        A unique identifier for the raw secret access key.
        """
        return pulumi.get(self, "access_key_id")

    @_builtins.property
    @pulumi.getter(name="rawSecretAccessKey")
    def raw_secret_access_key(self) -> _builtins.str:
        """
        A secret string of 43-64 characters.
        """
        return pulumi.get(self, "raw_secret_access_key")


@pulumi.output_type
class GrantConstraint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionContextEquals":
            suggest = "encryption_context_equals"
        elif key == "encryptionContextSubset":
            suggest = "encryption_context_subset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GrantConstraint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GrantConstraint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GrantConstraint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_context_equals: Optional[Mapping[str, _builtins.str]] = None,
                 encryption_context_subset: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] encryption_context_equals: A list of key-value pairs that must match the encryption context in subsequent cryptographic operation requests. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint. Conflicts with `encryption_context_subset`.
        :param Mapping[str, _builtins.str] encryption_context_subset: A list of key-value pairs that must be included in the encryption context of subsequent cryptographic operation requests. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs. Conflicts with `encryption_context_equals`.
        """
        if encryption_context_equals is not None:
            pulumi.set(__self__, "encryption_context_equals", encryption_context_equals)
        if encryption_context_subset is not None:
            pulumi.set(__self__, "encryption_context_subset", encryption_context_subset)

    @_builtins.property
    @pulumi.getter(name="encryptionContextEquals")
    def encryption_context_equals(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A list of key-value pairs that must match the encryption context in subsequent cryptographic operation requests. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint. Conflicts with `encryption_context_subset`.
        """
        return pulumi.get(self, "encryption_context_equals")

    @_builtins.property
    @pulumi.getter(name="encryptionContextSubset")
    def encryption_context_subset(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A list of key-value pairs that must be included in the encryption context of subsequent cryptographic operation requests. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs. Conflicts with `encryption_context_equals`.
        """
        return pulumi.get(self, "encryption_context_subset")


@pulumi.output_type
class GetKeyMultiRegionConfigurationResult(dict):
    def __init__(__self__, *,
                 multi_region_key_type: _builtins.str,
                 primary_keys: Sequence['outputs.GetKeyMultiRegionConfigurationPrimaryKeyResult'],
                 replica_keys: Sequence['outputs.GetKeyMultiRegionConfigurationReplicaKeyResult']):
        """
        :param _builtins.str multi_region_key_type: Indicates whether the KMS key is a `PRIMARY` or `REPLICA` key.
        :param Sequence['GetKeyMultiRegionConfigurationPrimaryKeyArgs'] primary_keys: The key ARN and Region of the primary key. This is the current KMS key if it is the primary key.
        :param Sequence['GetKeyMultiRegionConfigurationReplicaKeyArgs'] replica_keys: The key ARNs and Regions of all replica keys. Includes the current KMS key if it is a replica key.
        """
        pulumi.set(__self__, "multi_region_key_type", multi_region_key_type)
        pulumi.set(__self__, "primary_keys", primary_keys)
        pulumi.set(__self__, "replica_keys", replica_keys)

    @_builtins.property
    @pulumi.getter(name="multiRegionKeyType")
    def multi_region_key_type(self) -> _builtins.str:
        """
        Indicates whether the KMS key is a `PRIMARY` or `REPLICA` key.
        """
        return pulumi.get(self, "multi_region_key_type")

    @_builtins.property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Sequence['outputs.GetKeyMultiRegionConfigurationPrimaryKeyResult']:
        """
        The key ARN and Region of the primary key. This is the current KMS key if it is the primary key.
        """
        return pulumi.get(self, "primary_keys")

    @_builtins.property
    @pulumi.getter(name="replicaKeys")
    def replica_keys(self) -> Sequence['outputs.GetKeyMultiRegionConfigurationReplicaKeyResult']:
        """
        The key ARNs and Regions of all replica keys. Includes the current KMS key if it is a replica key.
        """
        return pulumi.get(self, "replica_keys")


@pulumi.output_type
class GetKeyMultiRegionConfigurationPrimaryKeyResult(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 region: _builtins.str):
        """
        :param _builtins.str arn: The key ARN of a primary or replica key of a multi-Region key.
        :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The key ARN of a primary or replica key of a multi-Region key.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetKeyMultiRegionConfigurationReplicaKeyResult(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 region: _builtins.str):
        """
        :param _builtins.str arn: The key ARN of a primary or replica key of a multi-Region key.
        :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The key ARN of a primary or replica key of a multi-Region key.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetKeyXksKeyConfigurationResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The globally unique identifier for the key
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The globally unique identifier for the key
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetSecretSecretResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 payload: _builtins.str,
                 context: Optional[Mapping[str, _builtins.str]] = None,
                 grant_tokens: Optional[Sequence[_builtins.str]] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "payload", payload)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if grant_tokens is not None:
            pulumi.set(__self__, "grant_tokens", grant_tokens)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def payload(self) -> _builtins.str:
        return pulumi.get(self, "payload")

    @_builtins.property
    @pulumi.getter
    def context(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "context")

    @_builtins.property
    @pulumi.getter(name="grantTokens")
    def grant_tokens(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "grant_tokens")


@pulumi.output_type
class GetSecretsSecretResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 payload: _builtins.str,
                 context: Optional[Mapping[str, _builtins.str]] = None,
                 encryption_algorithm: Optional[_builtins.str] = None,
                 grant_tokens: Optional[Sequence[_builtins.str]] = None,
                 key_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name to export this secret under in the attributes.
        :param _builtins.str payload: Base64 encoded payload, as returned from a KMS encrypt operation.
        :param Mapping[str, _builtins.str] context: An optional mapping that makes up the Encryption Context for the secret.
        :param _builtins.str encryption_algorithm: The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
        :param Sequence[_builtins.str] grant_tokens: An optional list of Grant Tokens for the secret.
        :param _builtins.str key_id: Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.
               
               For more information on `context` and `grant_tokens` see the [KMS
               Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "payload", payload)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if encryption_algorithm is not None:
            pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        if grant_tokens is not None:
            pulumi.set(__self__, "grant_tokens", grant_tokens)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name to export this secret under in the attributes.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def payload(self) -> _builtins.str:
        """
        Base64 encoded payload, as returned from a KMS encrypt operation.
        """
        return pulumi.get(self, "payload")

    @_builtins.property
    @pulumi.getter
    def context(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        An optional mapping that makes up the Encryption Context for the secret.
        """
        return pulumi.get(self, "context")

    @_builtins.property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> Optional[_builtins.str]:
        """
        The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
        """
        return pulumi.get(self, "encryption_algorithm")

    @_builtins.property
    @pulumi.getter(name="grantTokens")
    def grant_tokens(self) -> Optional[Sequence[_builtins.str]]:
        """
        An optional list of Grant Tokens for the secret.
        """
        return pulumi.get(self, "grant_tokens")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[_builtins.str]:
        """
        Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.

        For more information on `context` and `grant_tokens` see the [KMS
        Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
        """
        return pulumi.get(self, "key_id")


