# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetResourceResult',
    'AwaitableGetResourceResult',
    'get_resource',
    'get_resource_output',
]

@pulumi.output_type
class GetResourceResult:
    """
    A collection of values returned by getResource.
    """
    def __init__(__self__, arn=None, hybrid_access_enabled=None, id=None, last_modified=None, region=None, role_arn=None, with_federation=None, with_privileged_access=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if hybrid_access_enabled and not isinstance(hybrid_access_enabled, bool):
            raise TypeError("Expected argument 'hybrid_access_enabled' to be a bool")
        pulumi.set(__self__, "hybrid_access_enabled", hybrid_access_enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_modified and not isinstance(last_modified, str):
            raise TypeError("Expected argument 'last_modified' to be a str")
        pulumi.set(__self__, "last_modified", last_modified)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if with_federation and not isinstance(with_federation, bool):
            raise TypeError("Expected argument 'with_federation' to be a bool")
        pulumi.set(__self__, "with_federation", with_federation)
        if with_privileged_access and not isinstance(with_privileged_access, bool):
            raise TypeError("Expected argument 'with_privileged_access' to be a bool")
        pulumi.set(__self__, "with_privileged_access", with_privileged_access)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="hybridAccessEnabled")
    def hybrid_access_enabled(self) -> _builtins.bool:
        """
        Flag to enable AWS LakeFormation hybrid access permission mode.
        """
        return pulumi.get(self, "hybrid_access_enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> _builtins.str:
        """
        Date and time the resource was last modified in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "last_modified")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        Role that the resource was registered with.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="withFederation")
    def with_federation(self) -> _builtins.bool:
        """
        Whether the resource is a federated resource.
        """
        return pulumi.get(self, "with_federation")

    @_builtins.property
    @pulumi.getter(name="withPrivilegedAccess")
    def with_privileged_access(self) -> _builtins.bool:
        """
        Boolean to grant the calling principal the permissions to perform all supported Lake Formation operations on the registered data location.
        """
        return pulumi.get(self, "with_privileged_access")


class AwaitableGetResourceResult(GetResourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceResult(
            arn=self.arn,
            hybrid_access_enabled=self.hybrid_access_enabled,
            id=self.id,
            last_modified=self.last_modified,
            region=self.region,
            role_arn=self.role_arn,
            with_federation=self.with_federation,
            with_privileged_access=self.with_privileged_access)


def get_resource(arn: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceResult:
    """
    Provides details about a Lake Formation resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lakeformation.get_resource(arn="arn:aws:s3:::tf-acc-test-9151654063908211878")
    ```


    :param _builtins.str arn: ARN of the resource, an S3 path.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lakeformation/getResource:getResource', __args__, opts=opts, typ=GetResourceResult).value

    return AwaitableGetResourceResult(
        arn=pulumi.get(__ret__, 'arn'),
        hybrid_access_enabled=pulumi.get(__ret__, 'hybrid_access_enabled'),
        id=pulumi.get(__ret__, 'id'),
        last_modified=pulumi.get(__ret__, 'last_modified'),
        region=pulumi.get(__ret__, 'region'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        with_federation=pulumi.get(__ret__, 'with_federation'),
        with_privileged_access=pulumi.get(__ret__, 'with_privileged_access'))
def get_resource_output(arn: Optional[pulumi.Input[_builtins.str]] = None,
                        region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceResult]:
    """
    Provides details about a Lake Formation resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lakeformation.get_resource(arn="arn:aws:s3:::tf-acc-test-9151654063908211878")
    ```


    :param _builtins.str arn: ARN of the resource, an S3 path.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:lakeformation/getResource:getResource', __args__, opts=opts, typ=GetResourceResult)
    return __ret__.apply(lambda __response__: GetResourceResult(
        arn=pulumi.get(__response__, 'arn'),
        hybrid_access_enabled=pulumi.get(__response__, 'hybrid_access_enabled'),
        id=pulumi.get(__response__, 'id'),
        last_modified=pulumi.get(__response__, 'last_modified'),
        region=pulumi.get(__response__, 'region'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        with_federation=pulumi.get(__response__, 'with_federation'),
        with_privileged_access=pulumi.get(__response__, 'with_privileged_access')))
