# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OptInArgs', 'OptIn']

@pulumi.input_type
class OptInArgs:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['OptInConditionArgs']]]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input['OptInPrincipalArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_datas: Optional[pulumi.Input[Sequence[pulumi.Input['OptInResourceDataArgs']]]] = None):
        """
        The set of arguments for constructing a OptIn resource.
        :param pulumi.Input[Sequence[pulumi.Input['OptInConditionArgs']]] conditions: Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
        :param pulumi.Input[Sequence[pulumi.Input['OptInPrincipalArgs']]] principals: Lake Formation principal. Supported principals are IAM users or IAM roles. See Principal for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['OptInResourceDataArgs']]] resource_datas: Structure for the resource. See Resource for more details.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if principals is not None:
            pulumi.set(__self__, "principals", principals)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_datas is not None:
            pulumi.set(__self__, "resource_datas", resource_datas)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptInConditionArgs']]]]:
        """
        Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptInConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter
    def principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptInPrincipalArgs']]]]:
        """
        Lake Formation principal. Supported principals are IAM users or IAM roles. See Principal for more details.
        """
        return pulumi.get(self, "principals")

    @principals.setter
    def principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptInPrincipalArgs']]]]):
        pulumi.set(self, "principals", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceDatas")
    def resource_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptInResourceDataArgs']]]]:
        """
        Structure for the resource. See Resource for more details.
        """
        return pulumi.get(self, "resource_datas")

    @resource_datas.setter
    def resource_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptInResourceDataArgs']]]]):
        pulumi.set(self, "resource_datas", value)


@pulumi.input_type
class _OptInState:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['OptInConditionArgs']]]] = None,
                 last_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input['OptInPrincipalArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_datas: Optional[pulumi.Input[Sequence[pulumi.Input['OptInResourceDataArgs']]]] = None):
        """
        Input properties used for looking up and filtering OptIn resources.
        :param pulumi.Input[Sequence[pulumi.Input['OptInConditionArgs']]] conditions: Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
        :param pulumi.Input[_builtins.str] last_modified: Last modified date and time of the record.
        :param pulumi.Input[Sequence[pulumi.Input['OptInPrincipalArgs']]] principals: Lake Formation principal. Supported principals are IAM users or IAM roles. See Principal for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['OptInResourceDataArgs']]] resource_datas: Structure for the resource. See Resource for more details.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if last_updated_by is not None:
            pulumi.set(__self__, "last_updated_by", last_updated_by)
        if principals is not None:
            pulumi.set(__self__, "principals", principals)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_datas is not None:
            pulumi.set(__self__, "resource_datas", resource_datas)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptInConditionArgs']]]]:
        """
        Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptInConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last modified date and time of the record.
        """
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "last_updated_by")

    @last_updated_by.setter
    def last_updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_by", value)

    @_builtins.property
    @pulumi.getter
    def principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptInPrincipalArgs']]]]:
        """
        Lake Formation principal. Supported principals are IAM users or IAM roles. See Principal for more details.
        """
        return pulumi.get(self, "principals")

    @principals.setter
    def principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptInPrincipalArgs']]]]):
        pulumi.set(self, "principals", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceDatas")
    def resource_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptInResourceDataArgs']]]]:
        """
        Structure for the resource. See Resource for more details.
        """
        return pulumi.get(self, "resource_datas")

    @resource_datas.setter
    def resource_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptInResourceDataArgs']]]]):
        pulumi.set(self, "resource_datas", value)


@pulumi.type_token("aws:lakeformation/optIn:OptIn")
class OptIn(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OptInConditionArgs', 'OptInConditionArgsDict']]]]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OptInPrincipalArgs', 'OptInPrincipalArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OptInResourceDataArgs', 'OptInResourceDataArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Lake Formation Opt In.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.OptIn("example")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OptInConditionArgs', 'OptInConditionArgsDict']]]] conditions: Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OptInPrincipalArgs', 'OptInPrincipalArgsDict']]]] principals: Lake Formation principal. Supported principals are IAM users or IAM roles. See Principal for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OptInResourceDataArgs', 'OptInResourceDataArgsDict']]]] resource_datas: Structure for the resource. See Resource for more details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[OptInArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Lake Formation Opt In.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.OptIn("example")
        ```

        :param str resource_name: The name of the resource.
        :param OptInArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OptInArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OptInConditionArgs', 'OptInConditionArgsDict']]]]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OptInPrincipalArgs', 'OptInPrincipalArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OptInResourceDataArgs', 'OptInResourceDataArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OptInArgs.__new__(OptInArgs)

            __props__.__dict__["conditions"] = conditions
            __props__.__dict__["principals"] = principals
            __props__.__dict__["region"] = region
            __props__.__dict__["resource_datas"] = resource_datas
            __props__.__dict__["last_modified"] = None
            __props__.__dict__["last_updated_by"] = None
        super(OptIn, __self__).__init__(
            'aws:lakeformation/optIn:OptIn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OptInConditionArgs', 'OptInConditionArgsDict']]]]] = None,
            last_modified: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
            principals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OptInPrincipalArgs', 'OptInPrincipalArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OptInResourceDataArgs', 'OptInResourceDataArgsDict']]]]] = None) -> 'OptIn':
        """
        Get an existing OptIn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OptInConditionArgs', 'OptInConditionArgsDict']]]] conditions: Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
        :param pulumi.Input[_builtins.str] last_modified: Last modified date and time of the record.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OptInPrincipalArgs', 'OptInPrincipalArgsDict']]]] principals: Lake Formation principal. Supported principals are IAM users or IAM roles. See Principal for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OptInResourceDataArgs', 'OptInResourceDataArgsDict']]]] resource_datas: Structure for the resource. See Resource for more details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OptInState.__new__(_OptInState)

        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["last_modified"] = last_modified
        __props__.__dict__["last_updated_by"] = last_updated_by
        __props__.__dict__["principals"] = principals
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_datas"] = resource_datas
        return OptIn(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional[Sequence['outputs.OptInCondition']]]:
        """
        Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[_builtins.str]:
        """
        Last modified date and time of the record.
        """
        return pulumi.get(self, "last_modified")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter
    def principals(self) -> pulumi.Output[Optional[Sequence['outputs.OptInPrincipal']]]:
        """
        Lake Formation principal. Supported principals are IAM users or IAM roles. See Principal for more details.
        """
        return pulumi.get(self, "principals")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceDatas")
    def resource_datas(self) -> pulumi.Output[Optional[Sequence['outputs.OptInResourceData']]]:
        """
        Structure for the resource. See Resource for more details.
        """
        return pulumi.get(self, "resource_datas")

