# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResourceLfTagArgs', 'ResourceLfTag']

@pulumi.input_type
class ResourceLfTagArgs:
    def __init__(__self__, *,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input['ResourceLfTagDatabaseArgs']] = None,
                 lf_tag: Optional[pulumi.Input['ResourceLfTagLfTagArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input['ResourceLfTagTableArgs']] = None,
                 table_with_columns: Optional[pulumi.Input['ResourceLfTagTableWithColumnsArgs']] = None,
                 timeouts: Optional[pulumi.Input['ResourceLfTagTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a ResourceLfTag resource.
        :param pulumi.Input[_builtins.str] catalog_id: Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        :param pulumi.Input['ResourceLfTagDatabaseArgs'] database: Configuration block for a database resource. See Database for more details.
        :param pulumi.Input['ResourceLfTagLfTagArgs'] lf_tag: Set of LF-tags to attach to the resource. See LF Tag for more details.
               
               Exactly one of the following is required:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ResourceLfTagTableArgs'] table: Configuration block for a table resource. See Table for more details.
        :param pulumi.Input['ResourceLfTagTableWithColumnsArgs'] table_with_columns: Configuration block for a table with columns resource. See Table With Columns for more details.
               
               The following arguments are optional:
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if lf_tag is not None:
            pulumi.set(__self__, "lf_tag", lf_tag)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if table_with_columns is not None:
            pulumi.set(__self__, "table_with_columns", table_with_columns)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input['ResourceLfTagDatabaseArgs']]:
        """
        Configuration block for a database resource. See Database for more details.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input['ResourceLfTagDatabaseArgs']]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="lfTag")
    def lf_tag(self) -> Optional[pulumi.Input['ResourceLfTagLfTagArgs']]:
        """
        Set of LF-tags to attach to the resource. See LF Tag for more details.

        Exactly one of the following is required:
        """
        return pulumi.get(self, "lf_tag")

    @lf_tag.setter
    def lf_tag(self, value: Optional[pulumi.Input['ResourceLfTagLfTagArgs']]):
        pulumi.set(self, "lf_tag", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input['ResourceLfTagTableArgs']]:
        """
        Configuration block for a table resource. See Table for more details.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input['ResourceLfTagTableArgs']]):
        pulumi.set(self, "table", value)

    @_builtins.property
    @pulumi.getter(name="tableWithColumns")
    def table_with_columns(self) -> Optional[pulumi.Input['ResourceLfTagTableWithColumnsArgs']]:
        """
        Configuration block for a table with columns resource. See Table With Columns for more details.

        The following arguments are optional:
        """
        return pulumi.get(self, "table_with_columns")

    @table_with_columns.setter
    def table_with_columns(self, value: Optional[pulumi.Input['ResourceLfTagTableWithColumnsArgs']]):
        pulumi.set(self, "table_with_columns", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ResourceLfTagTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ResourceLfTagTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ResourceLfTagState:
    def __init__(__self__, *,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input['ResourceLfTagDatabaseArgs']] = None,
                 lf_tag: Optional[pulumi.Input['ResourceLfTagLfTagArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input['ResourceLfTagTableArgs']] = None,
                 table_with_columns: Optional[pulumi.Input['ResourceLfTagTableWithColumnsArgs']] = None,
                 timeouts: Optional[pulumi.Input['ResourceLfTagTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering ResourceLfTag resources.
        :param pulumi.Input[_builtins.str] catalog_id: Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        :param pulumi.Input['ResourceLfTagDatabaseArgs'] database: Configuration block for a database resource. See Database for more details.
        :param pulumi.Input['ResourceLfTagLfTagArgs'] lf_tag: Set of LF-tags to attach to the resource. See LF Tag for more details.
               
               Exactly one of the following is required:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ResourceLfTagTableArgs'] table: Configuration block for a table resource. See Table for more details.
        :param pulumi.Input['ResourceLfTagTableWithColumnsArgs'] table_with_columns: Configuration block for a table with columns resource. See Table With Columns for more details.
               
               The following arguments are optional:
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if lf_tag is not None:
            pulumi.set(__self__, "lf_tag", lf_tag)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if table_with_columns is not None:
            pulumi.set(__self__, "table_with_columns", table_with_columns)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input['ResourceLfTagDatabaseArgs']]:
        """
        Configuration block for a database resource. See Database for more details.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input['ResourceLfTagDatabaseArgs']]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="lfTag")
    def lf_tag(self) -> Optional[pulumi.Input['ResourceLfTagLfTagArgs']]:
        """
        Set of LF-tags to attach to the resource. See LF Tag for more details.

        Exactly one of the following is required:
        """
        return pulumi.get(self, "lf_tag")

    @lf_tag.setter
    def lf_tag(self, value: Optional[pulumi.Input['ResourceLfTagLfTagArgs']]):
        pulumi.set(self, "lf_tag", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input['ResourceLfTagTableArgs']]:
        """
        Configuration block for a table resource. See Table for more details.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input['ResourceLfTagTableArgs']]):
        pulumi.set(self, "table", value)

    @_builtins.property
    @pulumi.getter(name="tableWithColumns")
    def table_with_columns(self) -> Optional[pulumi.Input['ResourceLfTagTableWithColumnsArgs']]:
        """
        Configuration block for a table with columns resource. See Table With Columns for more details.

        The following arguments are optional:
        """
        return pulumi.get(self, "table_with_columns")

    @table_with_columns.setter
    def table_with_columns(self, value: Optional[pulumi.Input['ResourceLfTagTableWithColumnsArgs']]):
        pulumi.set(self, "table_with_columns", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ResourceLfTagTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ResourceLfTagTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:lakeformation/resourceLfTag:ResourceLfTag")
class ResourceLfTag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[Union['ResourceLfTagDatabaseArgs', 'ResourceLfTagDatabaseArgsDict']]] = None,
                 lf_tag: Optional[pulumi.Input[Union['ResourceLfTagLfTagArgs', 'ResourceLfTagLfTagArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input[Union['ResourceLfTagTableArgs', 'ResourceLfTagTableArgsDict']]] = None,
                 table_with_columns: Optional[pulumi.Input[Union['ResourceLfTagTableWithColumnsArgs', 'ResourceLfTagTableWithColumnsArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['ResourceLfTagTimeoutsArgs', 'ResourceLfTagTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Lake Formation Resource LF Tag.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.ResourceLfTag("example",
            database={
                "name": example_aws_glue_catalog_database["name"],
            },
            lf_tag={
                "key": example_aws_lakeformation_lf_tag["key"],
                "value": "stowe",
            })
        ```

        ## Import

        You cannot import this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_id: Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        :param pulumi.Input[Union['ResourceLfTagDatabaseArgs', 'ResourceLfTagDatabaseArgsDict']] database: Configuration block for a database resource. See Database for more details.
        :param pulumi.Input[Union['ResourceLfTagLfTagArgs', 'ResourceLfTagLfTagArgsDict']] lf_tag: Set of LF-tags to attach to the resource. See LF Tag for more details.
               
               Exactly one of the following is required:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ResourceLfTagTableArgs', 'ResourceLfTagTableArgsDict']] table: Configuration block for a table resource. See Table for more details.
        :param pulumi.Input[Union['ResourceLfTagTableWithColumnsArgs', 'ResourceLfTagTableWithColumnsArgsDict']] table_with_columns: Configuration block for a table with columns resource. See Table With Columns for more details.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ResourceLfTagArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Lake Formation Resource LF Tag.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.ResourceLfTag("example",
            database={
                "name": example_aws_glue_catalog_database["name"],
            },
            lf_tag={
                "key": example_aws_lakeformation_lf_tag["key"],
                "value": "stowe",
            })
        ```

        ## Import

        You cannot import this resource.

        :param str resource_name: The name of the resource.
        :param ResourceLfTagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceLfTagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[Union['ResourceLfTagDatabaseArgs', 'ResourceLfTagDatabaseArgsDict']]] = None,
                 lf_tag: Optional[pulumi.Input[Union['ResourceLfTagLfTagArgs', 'ResourceLfTagLfTagArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input[Union['ResourceLfTagTableArgs', 'ResourceLfTagTableArgsDict']]] = None,
                 table_with_columns: Optional[pulumi.Input[Union['ResourceLfTagTableWithColumnsArgs', 'ResourceLfTagTableWithColumnsArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['ResourceLfTagTimeoutsArgs', 'ResourceLfTagTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceLfTagArgs.__new__(ResourceLfTagArgs)

            __props__.__dict__["catalog_id"] = catalog_id
            __props__.__dict__["database"] = database
            __props__.__dict__["lf_tag"] = lf_tag
            __props__.__dict__["region"] = region
            __props__.__dict__["table"] = table
            __props__.__dict__["table_with_columns"] = table_with_columns
            __props__.__dict__["timeouts"] = timeouts
        super(ResourceLfTag, __self__).__init__(
            'aws:lakeformation/resourceLfTag:ResourceLfTag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[Union['ResourceLfTagDatabaseArgs', 'ResourceLfTagDatabaseArgsDict']]] = None,
            lf_tag: Optional[pulumi.Input[Union['ResourceLfTagLfTagArgs', 'ResourceLfTagLfTagArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            table: Optional[pulumi.Input[Union['ResourceLfTagTableArgs', 'ResourceLfTagTableArgsDict']]] = None,
            table_with_columns: Optional[pulumi.Input[Union['ResourceLfTagTableWithColumnsArgs', 'ResourceLfTagTableWithColumnsArgsDict']]] = None,
            timeouts: Optional[pulumi.Input[Union['ResourceLfTagTimeoutsArgs', 'ResourceLfTagTimeoutsArgsDict']]] = None) -> 'ResourceLfTag':
        """
        Get an existing ResourceLfTag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_id: Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        :param pulumi.Input[Union['ResourceLfTagDatabaseArgs', 'ResourceLfTagDatabaseArgsDict']] database: Configuration block for a database resource. See Database for more details.
        :param pulumi.Input[Union['ResourceLfTagLfTagArgs', 'ResourceLfTagLfTagArgsDict']] lf_tag: Set of LF-tags to attach to the resource. See LF Tag for more details.
               
               Exactly one of the following is required:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ResourceLfTagTableArgs', 'ResourceLfTagTableArgsDict']] table: Configuration block for a table resource. See Table for more details.
        :param pulumi.Input[Union['ResourceLfTagTableWithColumnsArgs', 'ResourceLfTagTableWithColumnsArgsDict']] table_with_columns: Configuration block for a table with columns resource. See Table With Columns for more details.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceLfTagState.__new__(_ResourceLfTagState)

        __props__.__dict__["catalog_id"] = catalog_id
        __props__.__dict__["database"] = database
        __props__.__dict__["lf_tag"] = lf_tag
        __props__.__dict__["region"] = region
        __props__.__dict__["table"] = table
        __props__.__dict__["table_with_columns"] = table_with_columns
        __props__.__dict__["timeouts"] = timeouts
        return ResourceLfTag(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        """
        return pulumi.get(self, "catalog_id")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[Optional['outputs.ResourceLfTagDatabase']]:
        """
        Configuration block for a database resource. See Database for more details.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="lfTag")
    def lf_tag(self) -> pulumi.Output[Optional['outputs.ResourceLfTagLfTag']]:
        """
        Set of LF-tags to attach to the resource. See LF Tag for more details.

        Exactly one of the following is required:
        """
        return pulumi.get(self, "lf_tag")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def table(self) -> pulumi.Output[Optional['outputs.ResourceLfTagTable']]:
        """
        Configuration block for a table resource. See Table for more details.
        """
        return pulumi.get(self, "table")

    @_builtins.property
    @pulumi.getter(name="tableWithColumns")
    def table_with_columns(self) -> pulumi.Output[Optional['outputs.ResourceLfTagTableWithColumns']]:
        """
        Configuration block for a table with columns resource. See Table With Columns for more details.

        The following arguments are optional:
        """
        return pulumi.get(self, "table_with_columns")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ResourceLfTagTimeouts']]:
        return pulumi.get(self, "timeouts")

