# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionUrlArgs', 'FunctionUrl']

@pulumi.input_type
class FunctionUrlArgs:
    def __init__(__self__, *,
                 authorization_type: pulumi.Input[_builtins.str],
                 function_name: pulumi.Input[_builtins.str],
                 cors: Optional[pulumi.Input['FunctionUrlCorsArgs']] = None,
                 invoke_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FunctionUrl resource.
        :param pulumi.Input[_builtins.str] authorization_type: Type of authentication that the function URL uses. Valid values are `AWS_IAM` and `NONE`.
        :param pulumi.Input[_builtins.str] function_name: Name or ARN of the Lambda function.
               
               The following arguments are optional:
        :param pulumi.Input['FunctionUrlCorsArgs'] cors: Cross-origin resource sharing (CORS) settings for the function URL. See below.
        :param pulumi.Input[_builtins.str] invoke_mode: How the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`.
        :param pulumi.Input[_builtins.str] qualifier: Alias name or `$LATEST`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "authorization_type", authorization_type)
        pulumi.set(__self__, "function_name", function_name)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if invoke_mode is not None:
            pulumi.set(__self__, "invoke_mode", invoke_mode)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of authentication that the function URL uses. Valid values are `AWS_IAM` and `NONE`.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authorization_type", value)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name or ARN of the Lambda function.

        The following arguments are optional:
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['FunctionUrlCorsArgs']]:
        """
        Cross-origin resource sharing (CORS) settings for the function URL. See below.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['FunctionUrlCorsArgs']]):
        pulumi.set(self, "cors", value)

    @_builtins.property
    @pulumi.getter(name="invokeMode")
    def invoke_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`.
        """
        return pulumi.get(self, "invoke_mode")

    @invoke_mode.setter
    def invoke_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "invoke_mode", value)

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alias name or `$LATEST`.
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualifier", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _FunctionUrlState:
    def __init__(__self__, *,
                 authorization_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cors: Optional[pulumi.Input['FunctionUrlCorsArgs']] = None,
                 function_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 function_url: Optional[pulumi.Input[_builtins.str]] = None,
                 invoke_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 url_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FunctionUrl resources.
        :param pulumi.Input[_builtins.str] authorization_type: Type of authentication that the function URL uses. Valid values are `AWS_IAM` and `NONE`.
        :param pulumi.Input['FunctionUrlCorsArgs'] cors: Cross-origin resource sharing (CORS) settings for the function URL. See below.
        :param pulumi.Input[_builtins.str] function_arn: ARN of the Lambda function.
        :param pulumi.Input[_builtins.str] function_name: Name or ARN of the Lambda function.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] function_url: HTTP URL endpoint for the function in the format `https://<url_id>.lambda-url.<region>.on.aws/`.
        :param pulumi.Input[_builtins.str] invoke_mode: How the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`.
        :param pulumi.Input[_builtins.str] qualifier: Alias name or `$LATEST`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] url_id: Generated ID for the endpoint.
        """
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if function_url is not None:
            pulumi.set(__self__, "function_url", function_url)
        if invoke_mode is not None:
            pulumi.set(__self__, "invoke_mode", invoke_mode)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if url_id is not None:
            pulumi.set(__self__, "url_id", url_id)

    @_builtins.property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of authentication that the function URL uses. Valid values are `AWS_IAM` and `NONE`.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_type", value)

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['FunctionUrlCorsArgs']]:
        """
        Cross-origin resource sharing (CORS) settings for the function URL. See below.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['FunctionUrlCorsArgs']]):
        pulumi.set(self, "cors", value)

    @_builtins.property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Lambda function.
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_arn", value)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name or ARN of the Lambda function.

        The following arguments are optional:
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="functionUrl")
    def function_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        HTTP URL endpoint for the function in the format `https://<url_id>.lambda-url.<region>.on.aws/`.
        """
        return pulumi.get(self, "function_url")

    @function_url.setter
    def function_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_url", value)

    @_builtins.property
    @pulumi.getter(name="invokeMode")
    def invoke_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`.
        """
        return pulumi.get(self, "invoke_mode")

    @invoke_mode.setter
    def invoke_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "invoke_mode", value)

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alias name or `$LATEST`.
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualifier", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="urlId")
    def url_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Generated ID for the endpoint.
        """
        return pulumi.get(self, "url_id")

    @url_id.setter
    def url_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url_id", value)


@pulumi.type_token("aws:lambda/functionUrl:FunctionUrl")
class FunctionUrl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cors: Optional[pulumi.Input[Union['FunctionUrlCorsArgs', 'FunctionUrlCorsArgsDict']]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 invoke_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Lambda function URL. Creates a dedicated HTTP(S) endpoint for a Lambda function to enable direct invocation via HTTP requests.

        ## Example Usage

        ### Basic Function URL with No Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.FunctionUrl("example",
            function_name=example_aws_lambda_function["functionName"],
            authorization_type="NONE")
        ```

        ### Function URL with IAM Authentication and CORS Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.FunctionUrl("example",
            function_name=example_aws_lambda_function["functionName"],
            qualifier="my_alias",
            authorization_type="AWS_IAM",
            invoke_mode="RESPONSE_STREAM",
            cors={
                "allow_credentials": True,
                "allow_origins": ["https://example.com"],
                "allow_methods": [
                    "GET",
                    "POST",
                ],
                "allow_headers": [
                    "date",
                    "keep-alive",
                ],
                "expose_headers": [
                    "keep-alive",
                    "date",
                ],
                "max_age": 86400,
            })
        ```

        ## Import

        Using `pulumi import`, import Lambda function URLs using the `function_name` or `function_name/qualifier`. For example:

        ```sh
        $ pulumi import aws:lambda/functionUrl:FunctionUrl example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorization_type: Type of authentication that the function URL uses. Valid values are `AWS_IAM` and `NONE`.
        :param pulumi.Input[Union['FunctionUrlCorsArgs', 'FunctionUrlCorsArgsDict']] cors: Cross-origin resource sharing (CORS) settings for the function URL. See below.
        :param pulumi.Input[_builtins.str] function_name: Name or ARN of the Lambda function.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] invoke_mode: How the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`.
        :param pulumi.Input[_builtins.str] qualifier: Alias name or `$LATEST`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionUrlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Lambda function URL. Creates a dedicated HTTP(S) endpoint for a Lambda function to enable direct invocation via HTTP requests.

        ## Example Usage

        ### Basic Function URL with No Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.FunctionUrl("example",
            function_name=example_aws_lambda_function["functionName"],
            authorization_type="NONE")
        ```

        ### Function URL with IAM Authentication and CORS Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.FunctionUrl("example",
            function_name=example_aws_lambda_function["functionName"],
            qualifier="my_alias",
            authorization_type="AWS_IAM",
            invoke_mode="RESPONSE_STREAM",
            cors={
                "allow_credentials": True,
                "allow_origins": ["https://example.com"],
                "allow_methods": [
                    "GET",
                    "POST",
                ],
                "allow_headers": [
                    "date",
                    "keep-alive",
                ],
                "expose_headers": [
                    "keep-alive",
                    "date",
                ],
                "max_age": 86400,
            })
        ```

        ## Import

        Using `pulumi import`, import Lambda function URLs using the `function_name` or `function_name/qualifier`. For example:

        ```sh
        $ pulumi import aws:lambda/functionUrl:FunctionUrl example example
        ```

        :param str resource_name: The name of the resource.
        :param FunctionUrlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionUrlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cors: Optional[pulumi.Input[Union['FunctionUrlCorsArgs', 'FunctionUrlCorsArgsDict']]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 invoke_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionUrlArgs.__new__(FunctionUrlArgs)

            if authorization_type is None and not opts.urn:
                raise TypeError("Missing required property 'authorization_type'")
            __props__.__dict__["authorization_type"] = authorization_type
            __props__.__dict__["cors"] = cors
            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["invoke_mode"] = invoke_mode
            __props__.__dict__["qualifier"] = qualifier
            __props__.__dict__["region"] = region
            __props__.__dict__["function_arn"] = None
            __props__.__dict__["function_url"] = None
            __props__.__dict__["url_id"] = None
        super(FunctionUrl, __self__).__init__(
            'aws:lambda/functionUrl:FunctionUrl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization_type: Optional[pulumi.Input[_builtins.str]] = None,
            cors: Optional[pulumi.Input[Union['FunctionUrlCorsArgs', 'FunctionUrlCorsArgsDict']]] = None,
            function_arn: Optional[pulumi.Input[_builtins.str]] = None,
            function_name: Optional[pulumi.Input[_builtins.str]] = None,
            function_url: Optional[pulumi.Input[_builtins.str]] = None,
            invoke_mode: Optional[pulumi.Input[_builtins.str]] = None,
            qualifier: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            url_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'FunctionUrl':
        """
        Get an existing FunctionUrl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorization_type: Type of authentication that the function URL uses. Valid values are `AWS_IAM` and `NONE`.
        :param pulumi.Input[Union['FunctionUrlCorsArgs', 'FunctionUrlCorsArgsDict']] cors: Cross-origin resource sharing (CORS) settings for the function URL. See below.
        :param pulumi.Input[_builtins.str] function_arn: ARN of the Lambda function.
        :param pulumi.Input[_builtins.str] function_name: Name or ARN of the Lambda function.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] function_url: HTTP URL endpoint for the function in the format `https://<url_id>.lambda-url.<region>.on.aws/`.
        :param pulumi.Input[_builtins.str] invoke_mode: How the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`.
        :param pulumi.Input[_builtins.str] qualifier: Alias name or `$LATEST`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] url_id: Generated ID for the endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionUrlState.__new__(_FunctionUrlState)

        __props__.__dict__["authorization_type"] = authorization_type
        __props__.__dict__["cors"] = cors
        __props__.__dict__["function_arn"] = function_arn
        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["function_url"] = function_url
        __props__.__dict__["invoke_mode"] = invoke_mode
        __props__.__dict__["qualifier"] = qualifier
        __props__.__dict__["region"] = region
        __props__.__dict__["url_id"] = url_id
        return FunctionUrl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of authentication that the function URL uses. Valid values are `AWS_IAM` and `NONE`.
        """
        return pulumi.get(self, "authorization_type")

    @_builtins.property
    @pulumi.getter
    def cors(self) -> pulumi.Output[Optional['outputs.FunctionUrlCors']]:
        """
        Cross-origin resource sharing (CORS) settings for the function URL. See below.
        """
        return pulumi.get(self, "cors")

    @_builtins.property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Lambda function.
        """
        return pulumi.get(self, "function_arn")

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name or ARN of the Lambda function.

        The following arguments are optional:
        """
        return pulumi.get(self, "function_name")

    @_builtins.property
    @pulumi.getter(name="functionUrl")
    def function_url(self) -> pulumi.Output[_builtins.str]:
        """
        HTTP URL endpoint for the function in the format `https://<url_id>.lambda-url.<region>.on.aws/`.
        """
        return pulumi.get(self, "function_url")

    @_builtins.property
    @pulumi.getter(name="invokeMode")
    def invoke_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        How the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`.
        """
        return pulumi.get(self, "invoke_mode")

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Alias name or `$LATEST`.
        """
        return pulumi.get(self, "qualifier")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="urlId")
    def url_id(self) -> pulumi.Output[_builtins.str]:
        """
        Generated ID for the endpoint.
        """
        return pulumi.get(self, "url_id")

