# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFunctionUrlResult',
    'AwaitableGetFunctionUrlResult',
    'get_function_url',
    'get_function_url_output',
]

@pulumi.output_type
class GetFunctionUrlResult:
    """
    A collection of values returned by getFunctionUrl.
    """
    def __init__(__self__, authorization_type=None, cors=None, creation_time=None, function_arn=None, function_name=None, function_url=None, id=None, invoke_mode=None, last_modified_time=None, qualifier=None, region=None, url_id=None):
        if authorization_type and not isinstance(authorization_type, str):
            raise TypeError("Expected argument 'authorization_type' to be a str")
        pulumi.set(__self__, "authorization_type", authorization_type)
        if cors and not isinstance(cors, list):
            raise TypeError("Expected argument 'cors' to be a list")
        pulumi.set(__self__, "cors", cors)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if function_arn and not isinstance(function_arn, str):
            raise TypeError("Expected argument 'function_arn' to be a str")
        pulumi.set(__self__, "function_arn", function_arn)
        if function_name and not isinstance(function_name, str):
            raise TypeError("Expected argument 'function_name' to be a str")
        pulumi.set(__self__, "function_name", function_name)
        if function_url and not isinstance(function_url, str):
            raise TypeError("Expected argument 'function_url' to be a str")
        pulumi.set(__self__, "function_url", function_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if invoke_mode and not isinstance(invoke_mode, str):
            raise TypeError("Expected argument 'invoke_mode' to be a str")
        pulumi.set(__self__, "invoke_mode", invoke_mode)
        if last_modified_time and not isinstance(last_modified_time, str):
            raise TypeError("Expected argument 'last_modified_time' to be a str")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if qualifier and not isinstance(qualifier, str):
            raise TypeError("Expected argument 'qualifier' to be a str")
        pulumi.set(__self__, "qualifier", qualifier)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if url_id and not isinstance(url_id, str):
            raise TypeError("Expected argument 'url_id' to be a str")
        pulumi.set(__self__, "url_id", url_id)

    @_builtins.property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> _builtins.str:
        """
        Type of authentication that the function URL uses.
        """
        return pulumi.get(self, "authorization_type")

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Sequence['outputs.GetFunctionUrlCorResult']:
        """
        Cross-origin resource sharing (CORS) settings for the function URL. See below.
        """
        return pulumi.get(self, "cors")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        When the function URL was created, in [ISO-8601 format](https://www.w3.org/TR/NOTE-datetime).
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> _builtins.str:
        """
        ARN of the function.
        """
        return pulumi.get(self, "function_arn")

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> _builtins.str:
        return pulumi.get(self, "function_name")

    @_builtins.property
    @pulumi.getter(name="functionUrl")
    def function_url(self) -> _builtins.str:
        """
        HTTP URL endpoint for the function in the format `https://<url_id>.lambda-url.<region>.on.aws/`.
        """
        return pulumi.get(self, "function_url")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="invokeMode")
    def invoke_mode(self) -> _builtins.str:
        """
        Whether the Lambda function responds in `BUFFERED` or `RESPONSE_STREAM` mode.
        """
        return pulumi.get(self, "invoke_mode")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> _builtins.str:
        """
        When the function URL configuration was last updated, in [ISO-8601 format](https://www.w3.org/TR/NOTE-datetime).
        """
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "qualifier")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="urlId")
    def url_id(self) -> _builtins.str:
        """
        Generated ID for the endpoint.
        """
        return pulumi.get(self, "url_id")


class AwaitableGetFunctionUrlResult(GetFunctionUrlResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFunctionUrlResult(
            authorization_type=self.authorization_type,
            cors=self.cors,
            creation_time=self.creation_time,
            function_arn=self.function_arn,
            function_name=self.function_name,
            function_url=self.function_url,
            id=self.id,
            invoke_mode=self.invoke_mode,
            last_modified_time=self.last_modified_time,
            qualifier=self.qualifier,
            region=self.region,
            url_id=self.url_id)


def get_function_url(function_name: Optional[_builtins.str] = None,
                     qualifier: Optional[_builtins.str] = None,
                     region: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFunctionUrlResult:
    """
    Provides details about an AWS Lambda Function URL. Use this data source to retrieve information about an existing function URL configuration.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lambda.get_function_url(function_name="my_lambda_function")
    pulumi.export("functionUrl", example.function_url)
    ```

    ### With Qualifier

    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_std as std

    example = aws.lambda.get_function_url(function_name=example_aws_lambda_function["functionName"],
        qualifier="production")
    # Use the URL in other resources
    lambda_alias = aws.route53.Record("lambda_alias",
        zone_id=example_aws_route53_zone["zoneId"],
        name="api.example.com",
        type=aws.route53.RecordType.CNAME,
        ttl=300,
        records=[std.replace(text=example.function_url,
            search="https://",
            replace="").result])
    ```

    ### Retrieve CORS Configuration

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lambda.get_function_url(function_name="api_function")
    cors_config = len(example.cors).apply(lambda length: example.cors[0] if length > 0 else None)
    allowed_origins = cors_config["allowOrigins"] if cors_config != None else []
    pulumi.export("corsAllowedOrigins", allowed_origins)
    ```


    :param _builtins.str function_name: Name or ARN of the Lambda function.
           
           The following arguments are optional:
    :param _builtins.str qualifier: Alias name or `$LATEST`.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['functionName'] = function_name
    __args__['qualifier'] = qualifier
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lambda/getFunctionUrl:getFunctionUrl', __args__, opts=opts, typ=GetFunctionUrlResult).value

    return AwaitableGetFunctionUrlResult(
        authorization_type=pulumi.get(__ret__, 'authorization_type'),
        cors=pulumi.get(__ret__, 'cors'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        function_arn=pulumi.get(__ret__, 'function_arn'),
        function_name=pulumi.get(__ret__, 'function_name'),
        function_url=pulumi.get(__ret__, 'function_url'),
        id=pulumi.get(__ret__, 'id'),
        invoke_mode=pulumi.get(__ret__, 'invoke_mode'),
        last_modified_time=pulumi.get(__ret__, 'last_modified_time'),
        qualifier=pulumi.get(__ret__, 'qualifier'),
        region=pulumi.get(__ret__, 'region'),
        url_id=pulumi.get(__ret__, 'url_id'))
def get_function_url_output(function_name: Optional[pulumi.Input[_builtins.str]] = None,
                            qualifier: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFunctionUrlResult]:
    """
    Provides details about an AWS Lambda Function URL. Use this data source to retrieve information about an existing function URL configuration.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lambda.get_function_url(function_name="my_lambda_function")
    pulumi.export("functionUrl", example.function_url)
    ```

    ### With Qualifier

    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_std as std

    example = aws.lambda.get_function_url(function_name=example_aws_lambda_function["functionName"],
        qualifier="production")
    # Use the URL in other resources
    lambda_alias = aws.route53.Record("lambda_alias",
        zone_id=example_aws_route53_zone["zoneId"],
        name="api.example.com",
        type=aws.route53.RecordType.CNAME,
        ttl=300,
        records=[std.replace(text=example.function_url,
            search="https://",
            replace="").result])
    ```

    ### Retrieve CORS Configuration

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lambda.get_function_url(function_name="api_function")
    cors_config = len(example.cors).apply(lambda length: example.cors[0] if length > 0 else None)
    allowed_origins = cors_config["allowOrigins"] if cors_config != None else []
    pulumi.export("corsAllowedOrigins", allowed_origins)
    ```


    :param _builtins.str function_name: Name or ARN of the Lambda function.
           
           The following arguments are optional:
    :param _builtins.str qualifier: Alias name or `$LATEST`.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['functionName'] = function_name
    __args__['qualifier'] = qualifier
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:lambda/getFunctionUrl:getFunctionUrl', __args__, opts=opts, typ=GetFunctionUrlResult)
    return __ret__.apply(lambda __response__: GetFunctionUrlResult(
        authorization_type=pulumi.get(__response__, 'authorization_type'),
        cors=pulumi.get(__response__, 'cors'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        function_arn=pulumi.get(__response__, 'function_arn'),
        function_name=pulumi.get(__response__, 'function_name'),
        function_url=pulumi.get(__response__, 'function_url'),
        id=pulumi.get(__response__, 'id'),
        invoke_mode=pulumi.get(__response__, 'invoke_mode'),
        last_modified_time=pulumi.get(__response__, 'last_modified_time'),
        qualifier=pulumi.get(__response__, 'qualifier'),
        region=pulumi.get(__response__, 'region'),
        url_id=pulumi.get(__response__, 'url_id')))
