# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLayerVersionResult',
    'AwaitableGetLayerVersionResult',
    'get_layer_version',
    'get_layer_version_output',
]

@pulumi.output_type
class GetLayerVersionResult:
    """
    A collection of values returned by getLayerVersion.
    """
    def __init__(__self__, arn=None, code_sha256=None, compatible_architecture=None, compatible_architectures=None, compatible_runtime=None, compatible_runtimes=None, created_date=None, description=None, id=None, layer_arn=None, layer_name=None, license_info=None, region=None, signing_job_arn=None, signing_profile_version_arn=None, source_code_hash=None, source_code_size=None, version=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if code_sha256 and not isinstance(code_sha256, str):
            raise TypeError("Expected argument 'code_sha256' to be a str")
        pulumi.set(__self__, "code_sha256", code_sha256)
        if compatible_architecture and not isinstance(compatible_architecture, str):
            raise TypeError("Expected argument 'compatible_architecture' to be a str")
        pulumi.set(__self__, "compatible_architecture", compatible_architecture)
        if compatible_architectures and not isinstance(compatible_architectures, list):
            raise TypeError("Expected argument 'compatible_architectures' to be a list")
        pulumi.set(__self__, "compatible_architectures", compatible_architectures)
        if compatible_runtime and not isinstance(compatible_runtime, str):
            raise TypeError("Expected argument 'compatible_runtime' to be a str")
        pulumi.set(__self__, "compatible_runtime", compatible_runtime)
        if compatible_runtimes and not isinstance(compatible_runtimes, list):
            raise TypeError("Expected argument 'compatible_runtimes' to be a list")
        pulumi.set(__self__, "compatible_runtimes", compatible_runtimes)
        if created_date and not isinstance(created_date, str):
            raise TypeError("Expected argument 'created_date' to be a str")
        pulumi.set(__self__, "created_date", created_date)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if layer_arn and not isinstance(layer_arn, str):
            raise TypeError("Expected argument 'layer_arn' to be a str")
        pulumi.set(__self__, "layer_arn", layer_arn)
        if layer_name and not isinstance(layer_name, str):
            raise TypeError("Expected argument 'layer_name' to be a str")
        pulumi.set(__self__, "layer_name", layer_name)
        if license_info and not isinstance(license_info, str):
            raise TypeError("Expected argument 'license_info' to be a str")
        pulumi.set(__self__, "license_info", license_info)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if signing_job_arn and not isinstance(signing_job_arn, str):
            raise TypeError("Expected argument 'signing_job_arn' to be a str")
        pulumi.set(__self__, "signing_job_arn", signing_job_arn)
        if signing_profile_version_arn and not isinstance(signing_profile_version_arn, str):
            raise TypeError("Expected argument 'signing_profile_version_arn' to be a str")
        pulumi.set(__self__, "signing_profile_version_arn", signing_profile_version_arn)
        if source_code_hash and not isinstance(source_code_hash, str):
            raise TypeError("Expected argument 'source_code_hash' to be a str")
        pulumi.set(__self__, "source_code_hash", source_code_hash)
        if source_code_size and not isinstance(source_code_size, int):
            raise TypeError("Expected argument 'source_code_size' to be a int")
        pulumi.set(__self__, "source_code_size", source_code_size)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the Lambda Layer with version.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="codeSha256")
    def code_sha256(self) -> _builtins.str:
        """
        Base64-encoded representation of raw SHA-256 sum of the zip file.
        """
        return pulumi.get(self, "code_sha256")

    @_builtins.property
    @pulumi.getter(name="compatibleArchitecture")
    def compatible_architecture(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compatible_architecture")

    @_builtins.property
    @pulumi.getter(name="compatibleArchitectures")
    def compatible_architectures(self) -> Sequence[_builtins.str]:
        """
        List of [Architectures](https://docs.aws.amazon.com/lambda/latest/dg/API_GetLayerVersion.html#SSS-GetLayerVersion-response-CompatibleArchitectures) the specific Lambda Layer version is compatible with.
        """
        return pulumi.get(self, "compatible_architectures")

    @_builtins.property
    @pulumi.getter(name="compatibleRuntime")
    def compatible_runtime(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compatible_runtime")

    @_builtins.property
    @pulumi.getter(name="compatibleRuntimes")
    def compatible_runtimes(self) -> Sequence[_builtins.str]:
        """
        List of [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_GetLayerVersion.html#SSS-GetLayerVersion-response-CompatibleRuntimes) the specific Lambda Layer version is compatible with.
        """
        return pulumi.get(self, "compatible_runtimes")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> _builtins.str:
        """
        Date this resource was created.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the specific Lambda Layer version.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="layerArn")
    def layer_arn(self) -> _builtins.str:
        """
        ARN of the Lambda Layer without version.
        """
        return pulumi.get(self, "layer_arn")

    @_builtins.property
    @pulumi.getter(name="layerName")
    def layer_name(self) -> _builtins.str:
        return pulumi.get(self, "layer_name")

    @_builtins.property
    @pulumi.getter(name="licenseInfo")
    def license_info(self) -> _builtins.str:
        """
        License info associated with the specific Lambda Layer version.
        """
        return pulumi.get(self, "license_info")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="signingJobArn")
    def signing_job_arn(self) -> _builtins.str:
        """
        ARN of a signing job.
        """
        return pulumi.get(self, "signing_job_arn")

    @_builtins.property
    @pulumi.getter(name="signingProfileVersionArn")
    def signing_profile_version_arn(self) -> _builtins.str:
        """
        ARN for a signing profile version.
        """
        return pulumi.get(self, "signing_profile_version_arn")

    @_builtins.property
    @pulumi.getter(name="sourceCodeHash")
    @_utilities.deprecated("""source_code_hash is deprecated. Use code_sha256 instead.""")
    def source_code_hash(self) -> _builtins.str:
        """
        (**Deprecated** use `code_sha256` instead) Base64-encoded representation of raw SHA-256 sum of the zip file.
        """
        return pulumi.get(self, "source_code_hash")

    @_builtins.property
    @pulumi.getter(name="sourceCodeSize")
    def source_code_size(self) -> _builtins.int:
        """
        Size in bytes of the function .zip file.
        """
        return pulumi.get(self, "source_code_size")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        Lambda Layer version.
        """
        return pulumi.get(self, "version")


class AwaitableGetLayerVersionResult(GetLayerVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLayerVersionResult(
            arn=self.arn,
            code_sha256=self.code_sha256,
            compatible_architecture=self.compatible_architecture,
            compatible_architectures=self.compatible_architectures,
            compatible_runtime=self.compatible_runtime,
            compatible_runtimes=self.compatible_runtimes,
            created_date=self.created_date,
            description=self.description,
            id=self.id,
            layer_arn=self.layer_arn,
            layer_name=self.layer_name,
            license_info=self.license_info,
            region=self.region,
            signing_job_arn=self.signing_job_arn,
            signing_profile_version_arn=self.signing_profile_version_arn,
            source_code_hash=self.source_code_hash,
            source_code_size=self.source_code_size,
            version=self.version)


def get_layer_version(compatible_architecture: Optional[_builtins.str] = None,
                      compatible_runtime: Optional[_builtins.str] = None,
                      layer_name: Optional[_builtins.str] = None,
                      region: Optional[_builtins.str] = None,
                      version: Optional[_builtins.int] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLayerVersionResult:
    """
    Provides details about an AWS Lambda Layer Version. Use this data source to retrieve information about a specific layer version or find the latest version compatible with your runtime and architecture requirements.

    ## Example Usage

    ### Get Latest Layer Version

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lambda.get_layer_version(layer_name="my-shared-utilities")
    # Use the layer in a Lambda function
    example_function = aws.lambda_.Function("example",
        code=pulumi.FileArchive("function.zip"),
        name="example_function",
        role=lambda_role["arn"],
        handler="index.handler",
        runtime=aws.lambda_.Runtime.NODE_JS20D_X,
        layers=[example.arn])
    ```

    ### Get Specific Layer Version

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lambda.get_layer_version(layer_name="production-utilities",
        version=5)
    pulumi.export("layerInfo", {
        "arn": example.arn,
        "version": example.version,
        "description": example.description,
    })
    ```

    ### Get Latest Compatible Layer Version

    ```python
    import pulumi
    import pulumi_aws as aws

    # Find latest layer version compatible with Python 3.12
    python_layer = aws.lambda.get_layer_version(layer_name="python-dependencies",
        compatible_runtime="python3.12")
    # Find latest layer version compatible with ARM64 architecture
    arm_layer = aws.lambda.get_layer_version(layer_name="optimized-libraries",
        compatible_architecture="arm64")
    # Use both layers in a function
    example = aws.lambda_.Function("example",
        code=pulumi.FileArchive("function.zip"),
        name="multi_layer_function",
        role=lambda_role["arn"],
        handler="app.handler",
        runtime=aws.lambda_.Runtime.PYTHON3D12,
        architectures=["arm64"],
        layers=[
            python_layer.arn,
            arm_layer.arn,
        ])
    ```

    ### Compare Layer Versions

    ```python
    import pulumi
    import pulumi_aws as aws

    # Get latest version
    latest = aws.lambda.get_layer_version(layer_name="shared-layer")
    # Get specific version for comparison
    stable = aws.lambda.get_layer_version(layer_name="shared-layer",
        version=3)
    use_latest_layer = latest.version > 5
    selected_layer = latest.arn if use_latest_layer else stable.arn
    pulumi.export("selectedLayerVersion", latest.version if use_latest_layer else stable.version)
    ```


    :param _builtins.str compatible_architecture: Specific architecture the layer version must support. Conflicts with `version`. If specified, the latest available layer version supporting the provided architecture will be used.
    :param _builtins.str compatible_runtime: Specific runtime the layer version must support. Conflicts with `version`. If specified, the latest available layer version supporting the provided runtime will be used.
    :param _builtins.str layer_name: Name of the Lambda layer.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.int version: Specific layer version. Conflicts with `compatible_runtime` and `compatible_architecture`. If omitted, the latest available layer version will be used.
    """
    __args__ = dict()
    __args__['compatibleArchitecture'] = compatible_architecture
    __args__['compatibleRuntime'] = compatible_runtime
    __args__['layerName'] = layer_name
    __args__['region'] = region
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lambda/getLayerVersion:getLayerVersion', __args__, opts=opts, typ=GetLayerVersionResult).value

    return AwaitableGetLayerVersionResult(
        arn=pulumi.get(__ret__, 'arn'),
        code_sha256=pulumi.get(__ret__, 'code_sha256'),
        compatible_architecture=pulumi.get(__ret__, 'compatible_architecture'),
        compatible_architectures=pulumi.get(__ret__, 'compatible_architectures'),
        compatible_runtime=pulumi.get(__ret__, 'compatible_runtime'),
        compatible_runtimes=pulumi.get(__ret__, 'compatible_runtimes'),
        created_date=pulumi.get(__ret__, 'created_date'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        layer_arn=pulumi.get(__ret__, 'layer_arn'),
        layer_name=pulumi.get(__ret__, 'layer_name'),
        license_info=pulumi.get(__ret__, 'license_info'),
        region=pulumi.get(__ret__, 'region'),
        signing_job_arn=pulumi.get(__ret__, 'signing_job_arn'),
        signing_profile_version_arn=pulumi.get(__ret__, 'signing_profile_version_arn'),
        source_code_hash=pulumi.get(__ret__, 'source_code_hash'),
        source_code_size=pulumi.get(__ret__, 'source_code_size'),
        version=pulumi.get(__ret__, 'version'))
def get_layer_version_output(compatible_architecture: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             compatible_runtime: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             layer_name: Optional[pulumi.Input[_builtins.str]] = None,
                             region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             version: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLayerVersionResult]:
    """
    Provides details about an AWS Lambda Layer Version. Use this data source to retrieve information about a specific layer version or find the latest version compatible with your runtime and architecture requirements.

    ## Example Usage

    ### Get Latest Layer Version

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lambda.get_layer_version(layer_name="my-shared-utilities")
    # Use the layer in a Lambda function
    example_function = aws.lambda_.Function("example",
        code=pulumi.FileArchive("function.zip"),
        name="example_function",
        role=lambda_role["arn"],
        handler="index.handler",
        runtime=aws.lambda_.Runtime.NODE_JS20D_X,
        layers=[example.arn])
    ```

    ### Get Specific Layer Version

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lambda.get_layer_version(layer_name="production-utilities",
        version=5)
    pulumi.export("layerInfo", {
        "arn": example.arn,
        "version": example.version,
        "description": example.description,
    })
    ```

    ### Get Latest Compatible Layer Version

    ```python
    import pulumi
    import pulumi_aws as aws

    # Find latest layer version compatible with Python 3.12
    python_layer = aws.lambda.get_layer_version(layer_name="python-dependencies",
        compatible_runtime="python3.12")
    # Find latest layer version compatible with ARM64 architecture
    arm_layer = aws.lambda.get_layer_version(layer_name="optimized-libraries",
        compatible_architecture="arm64")
    # Use both layers in a function
    example = aws.lambda_.Function("example",
        code=pulumi.FileArchive("function.zip"),
        name="multi_layer_function",
        role=lambda_role["arn"],
        handler="app.handler",
        runtime=aws.lambda_.Runtime.PYTHON3D12,
        architectures=["arm64"],
        layers=[
            python_layer.arn,
            arm_layer.arn,
        ])
    ```

    ### Compare Layer Versions

    ```python
    import pulumi
    import pulumi_aws as aws

    # Get latest version
    latest = aws.lambda.get_layer_version(layer_name="shared-layer")
    # Get specific version for comparison
    stable = aws.lambda.get_layer_version(layer_name="shared-layer",
        version=3)
    use_latest_layer = latest.version > 5
    selected_layer = latest.arn if use_latest_layer else stable.arn
    pulumi.export("selectedLayerVersion", latest.version if use_latest_layer else stable.version)
    ```


    :param _builtins.str compatible_architecture: Specific architecture the layer version must support. Conflicts with `version`. If specified, the latest available layer version supporting the provided architecture will be used.
    :param _builtins.str compatible_runtime: Specific runtime the layer version must support. Conflicts with `version`. If specified, the latest available layer version supporting the provided runtime will be used.
    :param _builtins.str layer_name: Name of the Lambda layer.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.int version: Specific layer version. Conflicts with `compatible_runtime` and `compatible_architecture`. If omitted, the latest available layer version will be used.
    """
    __args__ = dict()
    __args__['compatibleArchitecture'] = compatible_architecture
    __args__['compatibleRuntime'] = compatible_runtime
    __args__['layerName'] = layer_name
    __args__['region'] = region
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:lambda/getLayerVersion:getLayerVersion', __args__, opts=opts, typ=GetLayerVersionResult)
    return __ret__.apply(lambda __response__: GetLayerVersionResult(
        arn=pulumi.get(__response__, 'arn'),
        code_sha256=pulumi.get(__response__, 'code_sha256'),
        compatible_architecture=pulumi.get(__response__, 'compatible_architecture'),
        compatible_architectures=pulumi.get(__response__, 'compatible_architectures'),
        compatible_runtime=pulumi.get(__response__, 'compatible_runtime'),
        compatible_runtimes=pulumi.get(__response__, 'compatible_runtimes'),
        created_date=pulumi.get(__response__, 'created_date'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        layer_arn=pulumi.get(__response__, 'layer_arn'),
        layer_name=pulumi.get(__response__, 'layer_name'),
        license_info=pulumi.get(__response__, 'license_info'),
        region=pulumi.get(__response__, 'region'),
        signing_job_arn=pulumi.get(__response__, 'signing_job_arn'),
        signing_profile_version_arn=pulumi.get(__response__, 'signing_profile_version_arn'),
        source_code_hash=pulumi.get(__response__, 'source_code_hash'),
        source_code_size=pulumi.get(__response__, 'source_code_size'),
        version=pulumi.get(__response__, 'version')))
