# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetHostedZoneIdResult',
    'AwaitableGetHostedZoneIdResult',
    'get_hosted_zone_id',
    'get_hosted_zone_id_output',
]

@pulumi.output_type
class GetHostedZoneIdResult:
    """
    A collection of values returned by getHostedZoneId.
    """
    def __init__(__self__, id=None, load_balancer_type=None, region=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if load_balancer_type and not isinstance(load_balancer_type, str):
            raise TypeError("Expected argument 'load_balancer_type' to be a str")
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "load_balancer_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetHostedZoneIdResult(GetHostedZoneIdResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostedZoneIdResult(
            id=self.id,
            load_balancer_type=self.load_balancer_type,
            region=self.region)


def get_hosted_zone_id(load_balancer_type: Optional[_builtins.str] = None,
                       region: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostedZoneIdResult:
    """
    Use this data source to get the HostedZoneId of the AWS Elastic Load Balancing (ELB) in a given region for the purpose of using in an AWS Route53 Alias. Specify the ELB type (`network` or `application`) to return the relevant the associated HostedZoneId. Ref: [ELB service endpoints](https://docs.aws.amazon.com/general/latest/gr/elb.html#elb_region)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    main = aws.lb.get_hosted_zone_id()
    www = aws.route53.Record("www",
        zone_id=primary["zoneId"],
        name="example.com",
        type=aws.route53.RecordType.A,
        aliases=[{
            "name": main_aws_lb["dnsName"],
            "zone_id": main.id,
            "evaluate_target_health": True,
        }])
    ```


    :param _builtins.str load_balancer_type: Type of load balancer to create. Possible values are `application` or `network`. The default value is `application`.
    :param _builtins.str region: Name of the Region whose AWS ELB HostedZoneId is desired. Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['loadBalancerType'] = load_balancer_type
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lb/getHostedZoneId:getHostedZoneId', __args__, opts=opts, typ=GetHostedZoneIdResult).value

    return AwaitableGetHostedZoneIdResult(
        id=pulumi.get(__ret__, 'id'),
        load_balancer_type=pulumi.get(__ret__, 'load_balancer_type'),
        region=pulumi.get(__ret__, 'region'))
def get_hosted_zone_id_output(load_balancer_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHostedZoneIdResult]:
    """
    Use this data source to get the HostedZoneId of the AWS Elastic Load Balancing (ELB) in a given region for the purpose of using in an AWS Route53 Alias. Specify the ELB type (`network` or `application`) to return the relevant the associated HostedZoneId. Ref: [ELB service endpoints](https://docs.aws.amazon.com/general/latest/gr/elb.html#elb_region)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    main = aws.lb.get_hosted_zone_id()
    www = aws.route53.Record("www",
        zone_id=primary["zoneId"],
        name="example.com",
        type=aws.route53.RecordType.A,
        aliases=[{
            "name": main_aws_lb["dnsName"],
            "zone_id": main.id,
            "evaluate_target_health": True,
        }])
    ```


    :param _builtins.str load_balancer_type: Type of load balancer to create. Possible values are `application` or `network`. The default value is `application`.
    :param _builtins.str region: Name of the Region whose AWS ELB HostedZoneId is desired. Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['loadBalancerType'] = load_balancer_type
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:lb/getHostedZoneId:getHostedZoneId', __args__, opts=opts, typ=GetHostedZoneIdResult)
    return __ret__.apply(lambda __response__: GetHostedZoneIdResult(
        id=pulumi.get(__response__, 'id'),
        load_balancer_type=pulumi.get(__response__, 'load_balancer_type'),
        region=pulumi.get(__response__, 'region')))
