# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LbAttachmentArgs', 'LbAttachment']

@pulumi.input_type
class LbAttachmentArgs:
    def __init__(__self__, *,
                 instance_name: pulumi.Input[_builtins.str],
                 lb_name: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LbAttachment resource.
        :param pulumi.Input[_builtins.str] instance_name: Name of the instance to attach to the load balancer.
        :param pulumi.Input[_builtins.str] lb_name: Name of the Lightsail load balancer.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "lb_name", lb_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the instance to attach to the load balancer.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="lbName")
    def lb_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Lightsail load balancer.

        The following arguments are optional:
        """
        return pulumi.get(self, "lb_name")

    @lb_name.setter
    def lb_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "lb_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _LbAttachmentState:
    def __init__(__self__, *,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lb_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LbAttachment resources.
        :param pulumi.Input[_builtins.str] instance_name: Name of the instance to attach to the load balancer.
        :param pulumi.Input[_builtins.str] lb_name: Name of the Lightsail load balancer.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if lb_name is not None:
            pulumi.set(__self__, "lb_name", lb_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the instance to attach to the load balancer.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="lbName")
    def lb_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Lightsail load balancer.

        The following arguments are optional:
        """
        return pulumi.get(self, "lb_name")

    @lb_name.setter
    def lb_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lb_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:lightsail/lbAttachment:LbAttachment")
class LbAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lb_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Lightsail Load Balancer Attachment. Use this resource to attach Lightsail instances to a load balancer for distributing traffic across multiple instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        available = aws.get_availability_zones(state="available",
            filters=[{
                "name": "opt-in-status",
                "values": ["opt-in-not-required"],
            }])
        example = aws.lightsail.Lb("example",
            name="example-load-balancer",
            health_check_path="/",
            instance_port=80,
            tags={
                "foo": "bar",
            })
        example_instance = aws.lightsail.Instance("example",
            name="example-instance",
            availability_zone=available.names[0],
            blueprint_id="amazon_linux_2",
            bundle_id="nano_3_0")
        example_lb_attachment = aws.lightsail.LbAttachment("example",
            lb_name=example.name,
            instance_name=example_instance.name)
        ```

        ## Import

        Using `pulumi import`, import `aws_lightsail_lb_attachment` using the name attribute. For example:

        ```sh
        $ pulumi import aws:lightsail/lbAttachment:LbAttachment example example-load-balancer,example-instance
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_name: Name of the instance to attach to the load balancer.
        :param pulumi.Input[_builtins.str] lb_name: Name of the Lightsail load balancer.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LbAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Lightsail Load Balancer Attachment. Use this resource to attach Lightsail instances to a load balancer for distributing traffic across multiple instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        available = aws.get_availability_zones(state="available",
            filters=[{
                "name": "opt-in-status",
                "values": ["opt-in-not-required"],
            }])
        example = aws.lightsail.Lb("example",
            name="example-load-balancer",
            health_check_path="/",
            instance_port=80,
            tags={
                "foo": "bar",
            })
        example_instance = aws.lightsail.Instance("example",
            name="example-instance",
            availability_zone=available.names[0],
            blueprint_id="amazon_linux_2",
            bundle_id="nano_3_0")
        example_lb_attachment = aws.lightsail.LbAttachment("example",
            lb_name=example.name,
            instance_name=example_instance.name)
        ```

        ## Import

        Using `pulumi import`, import `aws_lightsail_lb_attachment` using the name attribute. For example:

        ```sh
        $ pulumi import aws:lightsail/lbAttachment:LbAttachment example example-load-balancer,example-instance
        ```

        :param str resource_name: The name of the resource.
        :param LbAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LbAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lb_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LbAttachmentArgs.__new__(LbAttachmentArgs)

            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            if lb_name is None and not opts.urn:
                raise TypeError("Missing required property 'lb_name'")
            __props__.__dict__["lb_name"] = lb_name
            __props__.__dict__["region"] = region
        super(LbAttachment, __self__).__init__(
            'aws:lightsail/lbAttachment:LbAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            lb_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'LbAttachment':
        """
        Get an existing LbAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_name: Name of the instance to attach to the load balancer.
        :param pulumi.Input[_builtins.str] lb_name: Name of the Lightsail load balancer.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LbAttachmentState.__new__(_LbAttachmentState)

        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["lb_name"] = lb_name
        __props__.__dict__["region"] = region
        return LbAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the instance to attach to the load balancer.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="lbName")
    def lb_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Lightsail load balancer.

        The following arguments are optional:
        """
        return pulumi.get(self, "lb_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

