# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClassificationExportConfigurationArgs', 'ClassificationExportConfiguration']

@pulumi.input_type
class ClassificationExportConfigurationArgs:
    def __init__(__self__, *,
                 s3_destination: pulumi.Input['ClassificationExportConfigurationS3DestinationArgs'],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ClassificationExportConfiguration resource.
        :param pulumi.Input['ClassificationExportConfigurationS3DestinationArgs'] s3_destination: Configuration block for a S3 Destination. Defined below
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "s3_destination", s3_destination)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="s3Destination")
    def s3_destination(self) -> pulumi.Input['ClassificationExportConfigurationS3DestinationArgs']:
        """
        Configuration block for a S3 Destination. Defined below
        """
        return pulumi.get(self, "s3_destination")

    @s3_destination.setter
    def s3_destination(self, value: pulumi.Input['ClassificationExportConfigurationS3DestinationArgs']):
        pulumi.set(self, "s3_destination", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ClassificationExportConfigurationState:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_destination: Optional[pulumi.Input['ClassificationExportConfigurationS3DestinationArgs']] = None):
        """
        Input properties used for looking up and filtering ClassificationExportConfiguration resources.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ClassificationExportConfigurationS3DestinationArgs'] s3_destination: Configuration block for a S3 Destination. Defined below
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_destination is not None:
            pulumi.set(__self__, "s3_destination", s3_destination)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="s3Destination")
    def s3_destination(self) -> Optional[pulumi.Input['ClassificationExportConfigurationS3DestinationArgs']]:
        """
        Configuration block for a S3 Destination. Defined below
        """
        return pulumi.get(self, "s3_destination")

    @s3_destination.setter
    def s3_destination(self, value: Optional[pulumi.Input['ClassificationExportConfigurationS3DestinationArgs']]):
        pulumi.set(self, "s3_destination", value)


@pulumi.type_token("aws:macie2/classificationExportConfiguration:ClassificationExportConfiguration")
class ClassificationExportConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_destination: Optional[pulumi.Input[Union['ClassificationExportConfigurationS3DestinationArgs', 'ClassificationExportConfigurationS3DestinationArgsDict']]] = None,
                 __props__=None):
        """
        Provides a resource to manage an [Amazon Macie Classification Export Configuration](https://docs.aws.amazon.com/macie/latest/APIReference/classification-export-configuration.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.macie2.Account("example")
        example_classification_export_configuration = aws.macie2.ClassificationExportConfiguration("example", s3_destination={
            "bucket_name": example_aws_s3_bucket["bucket"],
            "key_prefix": "exampleprefix/",
            "kms_key_arn": example_aws_kms_key["arn"],
        },
        opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ## Import

        Using `pulumi import`, import `aws_macie2_classification_export_configuration` using the region. For example:

        ```sh
        $ pulumi import aws:macie2/classificationExportConfiguration:ClassificationExportConfiguration example us-west-2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ClassificationExportConfigurationS3DestinationArgs', 'ClassificationExportConfigurationS3DestinationArgsDict']] s3_destination: Configuration block for a S3 Destination. Defined below
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClassificationExportConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage an [Amazon Macie Classification Export Configuration](https://docs.aws.amazon.com/macie/latest/APIReference/classification-export-configuration.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.macie2.Account("example")
        example_classification_export_configuration = aws.macie2.ClassificationExportConfiguration("example", s3_destination={
            "bucket_name": example_aws_s3_bucket["bucket"],
            "key_prefix": "exampleprefix/",
            "kms_key_arn": example_aws_kms_key["arn"],
        },
        opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ## Import

        Using `pulumi import`, import `aws_macie2_classification_export_configuration` using the region. For example:

        ```sh
        $ pulumi import aws:macie2/classificationExportConfiguration:ClassificationExportConfiguration example us-west-2
        ```

        :param str resource_name: The name of the resource.
        :param ClassificationExportConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClassificationExportConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_destination: Optional[pulumi.Input[Union['ClassificationExportConfigurationS3DestinationArgs', 'ClassificationExportConfigurationS3DestinationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClassificationExportConfigurationArgs.__new__(ClassificationExportConfigurationArgs)

            __props__.__dict__["region"] = region
            if s3_destination is None and not opts.urn:
                raise TypeError("Missing required property 's3_destination'")
            __props__.__dict__["s3_destination"] = s3_destination
        super(ClassificationExportConfiguration, __self__).__init__(
            'aws:macie2/classificationExportConfiguration:ClassificationExportConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            s3_destination: Optional[pulumi.Input[Union['ClassificationExportConfigurationS3DestinationArgs', 'ClassificationExportConfigurationS3DestinationArgsDict']]] = None) -> 'ClassificationExportConfiguration':
        """
        Get an existing ClassificationExportConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ClassificationExportConfigurationS3DestinationArgs', 'ClassificationExportConfigurationS3DestinationArgsDict']] s3_destination: Configuration block for a S3 Destination. Defined below
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClassificationExportConfigurationState.__new__(_ClassificationExportConfigurationState)

        __props__.__dict__["region"] = region
        __props__.__dict__["s3_destination"] = s3_destination
        return ClassificationExportConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="s3Destination")
    def s3_destination(self) -> pulumi.Output['outputs.ClassificationExportConfigurationS3Destination']:
        """
        Configuration block for a S3 Destination. Defined below
        """
        return pulumi.get(self, "s3_destination")

